using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_BenMAP_AnnualPM_ModelData : UserControl
    {
        string path = string.Empty;

        public uc_BenMAP_AnnualPM_ModelData()
        {
            InitializeComponent();
        }

        private void uc_BenMAP_AnnualPM_ModelData_Load(object sender, EventArgs e)
        {
            cboSpatialGridA.Items.Add("1x1");
            cboSpatialGridA.Items.Add("3x3");
            cboSpatialGridA.Items.Add("5x5");
            cboSpatialGridA.Items.Add("7x7");
        }

        private void btnBaselineA_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.baseModelFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.baseModelFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.baseModelFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                string filter = "";
                if (rbtnCMAQA.Checked == true)
                {
                    filter = LanguageOld.Translate("All Files(*.*)|*.*");
                }
                else
                {
                    filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                }
                openfile.Filter = filter;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.baseModelFile = openfile.FileName;
                    txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnForecastA_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.futureModelFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.futureModelFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.futureModelFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                string filter = "";
                if (rbtnCMAQA.Checked == true)
                {
                    filter = LanguageOld.Translate("All Files(*.*)|*.*");
                }
                else
                {
                    filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                }
                openfile.Filter = filter;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.futureModelFile = openfile.FileName;
                    txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
