using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_BenMAP_AnnualPM_MonitorData : UserControl
    {
        public uc_BenMAP_AnnualPM_MonitorData()
        {
            InitializeComponent();
            choChangedHeightAndTop();
        }

        private void btnUnofficialMonitorA_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(CommonClass.unofficialPMFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.unofficialPMFile)))
                {
                    openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                }
                else
                {
                    openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.unofficialPMFile);
                }
                openfile.Title = LanguageOld.Translate("Select file...");
                openfile.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.unofficialPMFile = openfile.FileName;
                    txtUnofficialMonitorA.Text = Path.GetFileName(CommonClass.unofficialPMFile);
                    openfile.RestoreDirectory = true;
                    cboEndYearA.DataSource = null;
                    cboStartYearA.DataSource = null;
                    bool isOK = CommonClass.getmonitorYear("uc_BenMAP_AnnualPM_MonitorData");
                    if (!isOK)
                    {
                        MessageBox.Show("Unofficial Quarterly Average FRM Data File is ill-formatted data!");
                    }
                    else
                    {
                        List<string> year = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.lstUnofficialYear;
                        cboStartYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.lstUnofficialYear.Distinct().ToList();
                        cboEndYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.lstUnofficialYear.Distinct().ToList();

                        if (cboStartYearA.Items.Count >= 9)
                            cboStartYearA.SelectedIndex = 8;
                        else
                            cboStartYearA.SelectedIndex = cboStartYearA.Items.Count - 1;
                        if (cboEndYearA.Items.Count >= 11)
                            cboEndYearA.SelectedIndex = 10;
                        else
                            cboEndYearA.SelectedIndex = cboEndYearA.Items.Count - 1;
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void chkDSAdvance_CheckedChanged(object sender, EventArgs e)
        {
            choChangedHeightAndTop();
        }

        public void choChangedHeightAndTop()
        {
            bool DS = true, DSadvance = true;
            DS = chkDS.Checked;
            DSadvance = chkDSAdvance.Checked;

            //the default location when all controls are expanded
            int thisheight = 534;
            //int pnlTopHeight = 517;
            //int pnlVNATop = 102;
            //int choEVNATop = 133;
            //int pnlEVNATop = 183;
            int chkDSTop = 273;
            int pnlDSTop = 315;
            int pnlDSAdvanceTop = 403;
            //int pnlBottom = 526;

            //Calculate the new location
            //top
            int delta = 0;
            //if (!VNA) delta = choEVNATop - pnlVNATop;
            //choEVNATop -= delta;
            //pnlEVNATop -= delta;
            //if (!eVNA) delta = chkDSTop - pnlEVNATop;
            //chkDSTop -= delta;
            //pnlDSTop -= delta;
            //pnlDSAdvanceTop -= delta;
            if (!DS)
            {
                delta = thisheight - pnlDSTop;
                //pnlTopHeight -= delta;
                thisheight -= delta;
            }
            else if (!DSadvance)
            {
                delta = thisheight - pnlDSAdvanceTop;
                //pnlTopHeight -= delta;
                thisheight -= delta;
            }

            //Bottom
            //pnlBottom -= delta;
            //thisheight -= delta;

            //reset the locations of Controls            
            this.Height = thisheight;
            //panel_Top.Height = pnlTopHeight;
            //choIAdjustedFRMSpeA.Top = choEVNATop;
            //panelEvna.Top = pnlEVNATop;
            chkDS.Top = chkDSTop;
            panelDS.Top = pnlDSTop;
            pnlDSAdvance.Top = pnlDSAdvanceTop;
            //panel_bottom.Top = pnlBottom;

        }

        private void chkDS_CheckedChanged(object sender, EventArgs e)
        {
            choChangedHeightAndTop();
        }
    }
}
