using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_DataInputOzone : ucBase
    {
        //public string _fileName;
        public static int intPage = 0;
        string path = "";
        public uc_DataInputOzone()
        {
            InitializeComponent();

            #region Language added by Edwin
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }
        private void uc_DataInputOzone_Load(object sender, EventArgs e)
        {
            try
            {
                cboGridOzone.Items.Add("1x1");
                cboGridOzone.Items.Add("3x3");
                cboGridOzone.Items.Add("5x5");
                cboGridOzone.Items.Add("7x7");
                cboStatisticOzone.Items.Add("Mean");
                cboStatisticOzone.Items.Add("Maximum");
                cboStatisticOzone.Items.Add("Maximum-paired in space");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        /// Initialize Control
        /// add by Devin
        /// 20190724
        /// </summary>
        public void InitializeControl()
        {
            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO == null)
            {
                (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO = new DataInputO();

                if (CommonClass.dicExampleConfiguration != null)
                {
                    CommonClass.ozoneMonitorFile = CommonClass.dicExampleConfiguration["Ozone"]["ozoneMonitorDataFile"];
                    txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);
                    cboCMAQOzone.Checked = false;
                    CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["Ozone"]["baselineModelDataFile"];
                    txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                    CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["Ozone"]["forecastModelDataFile"];
                    txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                }
                cboGridOzone.SelectedIndex = 1;//3 x 3
                cboStatisticOzone.SelectedIndex = 2;//Maximum-paired in space
            }
            else
            {
                CommonClass.ozoneMonitorFile = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.ozoneMonitorDataFile;
                txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);
                cboCMAQOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.doInputfromCmaq;
                CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.baselineModelDataFile;
                txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.forecastModelDataFile;
                txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                cboGridOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.temporalAdjustmentAtMonitorGrid;
                cboStatisticOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.temporalAdjustmentType;
            }
        }

        private void btnOzoneData_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.ozoneMonitorFile) || !Directory.Exists(Path.GetDirectoryName(CommonClass.ozoneMonitorFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.ozoneMonitorFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = "Select file...";
                // Application.StartupPath + @"\Data\SampleData";
                openfile.Filter = "CSV Files(*.csv)|*.csv";
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.ozoneMonitorFile = openfile.FileName;
                    txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;//remember the last directory 
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnChooseModelFile_Click(object sender, EventArgs e)
        {
            try
            {
                Button btn = sender as Button;
                string tag = btn.Tag.ToString().ToLower();
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    switch (tag)
                    {
                        case "baseline":
                            if (string.IsNullOrEmpty(CommonClass.baseModelFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.baseModelFile)))
                            {
                                openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                            }
                            else
                            {
                                openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.baseModelFile);
                            }
                            break;
                        case "forecast":
                            if (string.IsNullOrEmpty(CommonClass.futureModelFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.futureModelFile)))
                            {
                                openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                            }
                            else
                            {
                                openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.futureModelFile);
                            }
                            break;
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = "Select file...";
                //openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                string filter = "";
                if (cboCMAQOzone.Checked == true)
                {
                    filter = "All Files(*.*)|*.*";
                }
                else
                {
                    filter = "CSV Files(*.csv)|*.csv";
                }
                openfile.Filter = filter;
                openfile.RestoreDirectory = true;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    switch (tag)
                    {
                        case "baseline":
                            CommonClass.baseModelFile = openfile.FileName;
                            txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                            break;
                        case "forecast":
                            CommonClass.futureModelFile = openfile.FileName;
                            txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                            break;
                    }
                    path = Path.GetDirectoryName(openfile.FileName);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboCMAQOzone_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (cboCMAQOzone.Checked == true)
                {
                    txtBaselineOzone.Text = "";
                    txtForecastOzone.Text = "";
                }
                else
                {
                    CommonClass.baseModelFile = Application.StartupPath + @"\Data\SampleData\ozone_model_data_2001.csv";
                    txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                    CommonClass.futureModelFile = Application.StartupPath + @"\Data\SampleData\ozone_model_data_2015.csv";
                    txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblMonitorData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_3_2_data_input.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblModelData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_3_2_data_input.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblUsinngModelData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_3_2_data_input.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        #region integrate to btnChooseModelFile_Click event
        //private void btnBaselineOzone_Click(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        OpenFileDialog openfile = new OpenFileDialog();
        //        openfile.Title = "Select file...";
        //        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
        //        string filter = "";
        //        if (cboCMAQOzone.Checked == true)
        //        {
        //            filter = "All Files(*.*)|*.*";
        //        }
        //        else
        //        {
        //            filter = "CSV Files(*.csv)|*.csv";
        //        }
        //        openfile.Filter = filter;
        //        openfile.RestoreDirectory = true;
        //        if (openfile.ShowDialog() == DialogResult.OK)
        //        {
        //            _fileName = openfile.FileName;
        //            txtBaselineOzone.Text = _fileName;

        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        CommonClass.LogError(ex);
        //    }
        //}

        //private void btnForecastOzone_Click(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        OpenFileDialog openfile = new OpenFileDialog();
        //        openfile.Title = "Select file...";
        //        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
        //        string filter = "";
        //        if (cboCMAQOzone.Checked == true)
        //        {
        //            filter = "All Files(*.*)|*.*";

        //        }
        //        else
        //        {
        //            filter = "CSV Files(*.csv)|*.csv";
        //        }
        //        openfile.Filter = filter;
        //        openfile.RestoreDirectory = true;
        //        if (openfile.ShowDialog() == DialogResult.OK)
        //        {
        //            _fileName = openfile.FileName;
        //            txtForecastOzone.Text = _fileName;
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        CommonClass.LogError(ex);
        //    }
        //}
        #endregion



    }
}
