using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class uc_DesiredOutputOzone : ucBase
    {
        public uc_DesiredOutputOzone()
        {
            InitializeComponent();

            #region Language added by Edwin
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }


        private void uc_DesiredOutputOzone_Load(object sender, EventArgs e)
        {
            choSpatialGradAdjOzone_CheckedChanged(sender, e);
            choSpatialOzone_CheckedChanged(sender, e);
        }

        private void lblPointEstimates_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_3_1_desired_output.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblSpatialField_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_3_1_desired_output.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblExtractAll_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_3_1_desired_output.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblDesignValuePeriods_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_3_1_desired_output.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choNeighborFileSpatial_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (!choSpatialOzone.Checked && !choBaseOnlyVNAOzone.Checked
                     && !choFutureOnlyVNAOzone.Checked && choNeighborFileSpatial.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Spatial Field Neighbor File generation requires 'Spatial Field File' be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choBaseOnlyVNAOzone_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (!choSpatialOzone.Checked && !choBaseOnlyVNAOzone.Checked
                     && !choFutureOnlyVNAOzone.Checked && choNeighborFileSpatial.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Spatial Field Neighbor File generation requires 'Spatial Field File' be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choSpatialOzone_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (!choSpatialOzone.Checked && !choBaseOnlyVNAOzone.Checked
                     && !choFutureOnlyVNAOzone.Checked && choNeighborFileSpatial.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Spatial Field Neighbor File generation requires 'Spatial Field File' be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choFutureOnlyVNAOzone_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (!choSpatialOzone.Checked && !choBaseOnlyVNAOzone.Checked
                     && !choFutureOnlyVNAOzone.Checked && choNeighborFileSpatial.Checked)
                {
                    MessageBox.Show(LanguageOld.Translate("Spatial Field Neighbor File generation requires 'Spatial Field File' be checked."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choChangeHeightAndTop()
        {
            try
            {
                bool VNA = true, eVNA = true, DS = true, DSadvance = true;
                VNA = choSpatialOzone.Checked || choBaseOnlyVNAOzone.Checked || choFutureOnlyVNAOzone.Checked;
                eVNA = choSpatialGradAdjOzone.Checked || choBaseOnlyEvnaOzone.Checked || choFutureOnlyEvnaOzone.Checked;
                DS = chkDS.Checked || chkDSOnlyBase.Checked || chkDSOnlyFuture.Checked;
                DSadvance = chkDSAdvance.Checked;

                //the default location when all controls are expanded
                int thisheight = 932;
                int pnlMiddleHeight = 485;
                int pnlVNATop = 83;
                int choEVNATop = 116;
                int pnlEVNATop = 164;
                int chkDSTop = 200;
                int pnlDSTop = 245;
                int pnlDSAdvanceTop = 359;
                int pnlBottom = 670;

                //Calculate the new location
                //top--no changes

                //Middle
                int delta = 0;
                if (!VNA) delta = choEVNATop - pnlVNATop;
                choEVNATop -= delta;
                pnlEVNATop -= delta;
                if (!eVNA) delta = chkDSTop - pnlEVNATop;
                chkDSTop -= delta;
                pnlDSTop -= delta;
                pnlDSAdvanceTop -= delta;
                if (!DS)
                {
                    delta = pnlMiddleHeight - pnlDSTop;
                    pnlMiddleHeight -= delta;
                }
                else if (!DSadvance)
                {
                    delta = pnlMiddleHeight - pnlDSAdvanceTop+80;
                    pnlMiddleHeight -= delta;
                }

                //Bottom
                pnlBottom -= delta;
                thisheight -= delta;

                //reset the locations of Controls            
                this.Height = thisheight;
                panel_Middle.Height = pnlMiddleHeight;
                choSpatialGradAdjOzone.Top = choEVNATop;
                panelEvna.Top = pnlEVNATop;
                chkDS.Top = chkDSTop;
                panelDS.Top = pnlDSTop;
                pnlDSAdvance.Top = pnlDSAdvanceTop;
                panel_Bottom.Top = pnlBottom;
                panel_Bottom.Top = pnlBottom;
                //below are used to invisible the DS options
                //BetaVersion,��Ҫ����DS
                if (CommonClass.BetaVersion)
                {
                    chkDS.Enabled = false;
                    panel_Bottom.Top = panel_Bottom.Top - 50;
                    pnlInvisibleDS.Top = chkDSTop;
                }     
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choSpatialOzone_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (choSpatialOzone.Checked)
                {
                    choBaseOnlyVNAOzone.Checked = false;
                    choFutureOnlyVNAOzone.Checked = false;
                }
                choChangeHeightAndTop();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choBaseOnlyVNAOzone_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (choBaseOnlyVNAOzone.Checked)
                {
                    choFutureOnlyVNAOzone.Checked = false;
                    choSpatialOzone.Checked = false;
                }
                choChangeHeightAndTop();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choFutureOnlyVNAOzone_CheckedChanged(object sender, EventArgs e)
        {
            if (choFutureOnlyVNAOzone.Checked)
            {
                choSpatialOzone.Checked = false;
                choBaseOnlyVNAOzone.Checked = false;
            }
            choChangeHeightAndTop();
        }

        private void choSpatialGradAdjOzone_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (choSpatialGradAdjOzone.Checked)
                {
                    choBaseOnlyEvnaOzone.Checked = false;
                    choFutureOnlyEvnaOzone.Checked = false;
                }
                choChangeHeightAndTop();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choBaseOnlyEvnaOzone_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (choBaseOnlyEvnaOzone.Checked)
                {
                    choSpatialGradAdjOzone.Checked = false;
                    choFutureOnlyEvnaOzone.Checked = false;
                }
                choChangeHeightAndTop();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choFutureOnlyEvnaOzone_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (choFutureOnlyEvnaOzone.Checked)
                {
                    choSpatialGradAdjOzone.Checked = false;
                    choBaseOnlyEvnaOzone.Checked = false;
                }
                choChangeHeightAndTop();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void chkDS_CheckedChanged(object sender, EventArgs e)
        {
            if (chkDS.Checked)
            {
                chkDSOnlyBase.Checked = false;
                chkDSOnlyFuture.Checked = false;
            }

            if (!chkDS.Checked && !chkDSOnlyBase.Checked && !chkDSOnlyFuture.Checked)
            {
                chkDSAdvance.Checked = false;
            }
            choChangeHeightAndTop();
        }

        private void chkDSAdvance_CheckedChanged(object sender, EventArgs e)
        {
            choChangeHeightAndTop();
        }

        private void chkDSOnlyBase_CheckedChanged(object sender, EventArgs e)
        {
            if (chkDSOnlyBase.Checked)
            {
                chkDS.Checked = false;
                chkDSOnlyFuture.Checked = false;
            }
            choChangeHeightAndTop();
        }

        private void chkDSOnlyFuture_CheckedChanged(object sender, EventArgs e)
        {
            if (chkDSOnlyFuture.Checked)
            {
                chkDS.Checked = false;
                chkDSOnlyBase.Checked = false;
            }
            choChangeHeightAndTop();
        }

        private void label1_Click(object sender, EventArgs e)
        {

        }
    }
}
