using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class uc_FilteringorInterpolationOzone : ucBase
    {
        public uc_FilteringorInterpolationOzone()
        {
            InitializeComponent();
            #region Language added by Edwin
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }

        private void choMaxItpDistanceOzone_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (choMaxItpDistanceOzone.Checked == true)
                {
                    nudownMaxItpDistanceOzone.Enabled = true;
                }
                else
                {
                    nudownMaxItpDistanceOzone.Enabled = false;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void uc_FilteringorInterpolationOzone_Load(object sender, EventArgs e)
        {
            try
            {
                pnlRequiredDV.Visible = false;
                cboDefaultItpOzone.Items.Add("Equal Weighting of Monitors");
                cboDefaultItpOzone.Items.Add("Inverse Distance Weights");
                cboDefaultItpOzone.Items.Add("Inverse Distance Squared Weights");

            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnSelect_Click(object sender, EventArgs e)
        {
            try
            {
                pnlRequiredDV.Visible = true;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            try
            {
                string strDV = "";
                StringBuilder builder = new StringBuilder();
                this.pnlRequiredDV.Visible = false;
                for (int i = 0; i < this.clboRequiredDV.Items.Count; i++)
                {
                    if (this.clboRequiredDV.GetItemChecked(i))
                    {
                        builder.Append(clboRequiredDV.Items[i].ToString() + ",");
                    }
                }
                strDV = builder.ToString();
                #region modified by devin
                if (strDV.Length != 0)
                {
                    strDV = strDV.Substring(0, strDV.Length - 1);
                    txtRequiredDVOzone.Text = strDV;
                }
                else
                {
                    txtRequiredDVOzone.Text = "None selected";
                }
                #endregion
                if (txtRequiredDVOzone.Text != "None selected")
                {
                    if (Convert.ToInt32(txtRequiredDVOzone.Text.Substring(0, 4)) < Convert.ToInt32(cboStartYearOzone.Text.Substring(0,4))
                        || Convert.ToInt32(txtRequiredDVOzone.Text.Remove(0, txtRequiredDVOzone.Text.Length - 4)) > Convert.ToInt32(cboEndYearOzone.Text.Remove(0,cboEndYearOzone.Text.Length-4)))
                        MessageBox.Show(LanguageOld.Translate("Required Design Values is not correct!"));
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblChooseDV_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_3_3_filtering_interpolation.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblValidOzoneMonitors_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_3_3_filtering_interpolation.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblDefaultMethod_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_3_3_filtering_interpolation.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboStartYearOzone_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboEndYearOzone.Text.Substring(0, 4)) < Convert.ToInt32(cboStartYearOzone.Text.Substring(0, 4)))
                    //MessageBox.Show(Language.Translate("End Year should be later than Start Year."));
                    cboEndYearOzone.Text = cboStartYearOzone.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboEndYearOzone_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboEndYearOzone.Text.Substring(0, 4)) < Convert.ToInt32(cboStartYearOzone.Text.Substring(0, 4)))
                    //MessageBox.Show(Language.Translate("End Year should be later than Start Year."));
                    cboStartYearOzone.Text = cboEndYearOzone.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
