using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class uc_RRForSpatialGradientOzone : ucBase
    {
        public uc_RRForSpatialGradientOzone()
        {
            InitializeComponent();

            #region Language added by Edwin
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }

        private void choEnableBackstopOzone_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (choEnableBackstopOzone.Checked)
                {
                    txtBackstopMinOzone.Enabled = true;
                }
                else
                    txtBackstopMinOzone.Enabled = false;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblRRFSetup_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_3_4_rrf_spatial_gradient.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblSpatialGradientSetup_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_3_4_rrf_spatial_gradient.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void txtInt_KeyPress(object sender, KeyPressEventArgs e)
        {
            CommonClass.keypress(true, sender, e);
        }

        private void txtDouble_KeyPress(object sender, KeyPressEventArgs e)
        {
            CommonClass.keypress(false, sender, e);
        }

        private void radioTopX_CheckedChanged(object sender, EventArgs e)
        {
            if (rbtnTopX.Checked)
            {
                txtTopX.Enabled = true;
                txtInitialValueOzone.Enabled = false;
                txtAboveThresholdOzone.Enabled = false;
            }
            else
            {
                txtTopX.Enabled = false;
                txtInitialValueOzone.Enabled = true;
                txtAboveThresholdOzone.Enabled = true;
            }
        }

        private void radioInitial_CheckedChanged(object sender, EventArgs e)
        {
            if (rbtnInitial.Checked)
            {
                txtTopX.Enabled = false;
                txtInitialValueOzone.Enabled = true;
                txtAboveThresholdOzone.Enabled = true;
            }
            else
            {
                txtTopX.Enabled = true;
                txtInitialValueOzone.Enabled = false;
                txtAboveThresholdOzone.Enabled = false;
            }
        }
        //private void txtStartValueOzone_TextChanged(object sender, EventArgs e)
        //{
        //    try
        //    {
                //if ((txtStartValueOzone.Text != "" && txtStartValueOzone.Text.Length > 0) && txtEndValueOzone.Text != "" && txtEndValueOzone.Text.Length > 0)
                //{
                //    if (Convert.ToDouble(txtStartValueOzone.Text) > Convert.ToDouble(txtEndValueOzone.Text))
                //        MessageBox.Show(Language.Translate("End Value should be greater than Start Value."));
                //}
        //    }
        //    catch (Exception ex)
        //    {
        //        CommonClass.LogError(ex);
        //    }
        //}

        //private void txtEndValueOzone_TextChanged(object sender, EventArgs e)
        //{
        //    try
        //    {
                //if ((txtStartValueOzone.Text != "" && txtStartValueOzone.Text.Length > 0) && txtEndValueOzone.Text != "" && txtEndValueOzone.Text.Length > 0)
                //{
                //    if (Convert.ToDouble(txtStartValueOzone.Text) > Convert.ToDouble(txtEndValueOzone.Text))
                //        MessageBox.Show(Language.Translate("End Value should be greater than Start Value."));
                //}
        //    }
        //    catch (Exception ex)
        //    {
        //        CommonClass.LogError(ex);
        //    }
        //}
    }
}
