using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Data;
using DotSpatial.Data;
using DotSpatial.Projections;

namespace SMAT_CE
{
    class SSIADepositionCommonClass
    {
        public static DateTime _beginTime;
        public static DateTime _endTime;

        public static string _resultFilePath = "";

        #region SSIA Deposition
        public static bool DepositonAnalysis(BaseScenario baseScenario, SMAT_CE mats)
        {
            if (!(baseScenario.configuration is SSIADepositionConfiguration))
            {
                return false;
            }
            try
            {
                _beginTime = DateTime.Now;
                SSIADepositionConfiguration depositionAnalysisConfiguration = baseScenario.configuration as SSIADepositionConfiguration;
                if (!CommonClass.IsBatch)
                {
                    if (_resultFilePath == "" && _resultFilePath.Length == 0 || _resultFilePath != CommonClass.ResultFilePath + @"\Result\Output\" + (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.scenarioName)
                        _resultFilePath = CommonClass.ResultFilePath + @"\Result\Output\" + (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.scenarioName;
                }
                else
                {
                    if (_resultFilePath == "" && _resultFilePath.Length == 0 || _resultFilePath != CommonClass.ResultFilePath + @"\" + (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.scenarioName)
                        _resultFilePath = CommonClass.ResultFilePath + @"\" + (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.scenarioName;
                }
                if (!Directory.Exists(_resultFilePath))
                    System.IO.Directory.CreateDirectory(_resultFilePath);

                
                CommonClass.CurrentLog = "Read model data \"" + Path.GetFileName(depositionAnalysisConfiguration.modelInputDep.baselineModelDataFile) + "\".";
                CommonClass.CurrentBaseScenario.log.lstLog.Add(CommonClass.CurrentLog);
                #region Read DepositionModel Base from csv //save to dicDepositionDataOutput
                _beginTime = DateTime.Now;
                int iID = -1, iType = -1, iLat = -1, iLong = -1, iTSDep = -1, iTNDep = -1;
                int iDate = -1;
                Dictionary<string, SSIADepositionData> dicDepositionDataOutput = new Dictionary<string, SSIADepositionData>();
                FileStream fs = new FileStream(depositionAnalysisConfiguration.modelInputDep.baselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                try
                {
                    using (StreamReader csv = new StreamReader(fs, System.Text.Encoding.UTF8))
                    {
                        string strLine = csv.ReadLine();
                        string[] strLineArray = csv.ReadLine().Split(new char[] { ',' });
                        int i = 0;
                        while (i < strLineArray.Length)
                        {
                            string s = strLineArray[i];
                            switch (s.Trim().ToLower())
                            {
                                case "_id":
                                    iID = i;
                                    break;
                                case "_type":
                                    iType = i;
                                    break;
                                case "lat":
                                    iLat = i;
                                    break;
                                case "long":
                                    iLong = i;
                                    break;
                                case "date":
                                    iDate = i;
                                    break;
                                case "tsdep":
                                    iTSDep = i;
                                    break;
                                case "tndep":
                                    iTNDep = i;
                                    break;
                            }
                            i++;
                        }
                        while (strLine != null)
                        {
                            strLine = csv.ReadLine();
                            if (strLine == null) break;
                            strLineArray = strLine.Split(new char[] { ',' });
                            //if (strLineArray[iDate].Substring(0, 4) != startYear) continue;
                            if (dicDepositionDataOutput.ContainsKey(strLineArray[iID].ToString().Trim()))//strLineArray[iDate].Substring(0, 4)))
                            {
                                try
                                {
                                    float fTS = 0;
                                    float fTN = 0;
                                    float.TryParse(strLineArray[iTSDep].Trim(), out fTS);
                                    float.TryParse(strLineArray[iTNDep].Trim(), out fTN);
                                    dicDepositionDataOutput[strLineArray[iID].ToString().Trim()].lstDeposition.Add(strLineArray[iDate].Substring(4), new float[4] { fTS, 0, fTN, 0 });
                                }
                                catch
                                {
                                }
                            }
                            else
                            {
                                dicDepositionDataOutput.Add(strLineArray[iID].ToString().Trim(), new SSIADepositionData()
                                {
                                    Date = strLineArray[iDate].Substring(0, 4),
                                    id = strLineArray[iID],
                                    lat = Convert.ToDouble(strLineArray[iLat]),
                                    longitude = Convert.ToDouble(strLineArray[iLong]),
                                    type = strLineArray[iType],
                                    lstDeposition = new Dictionary<string, float[]>(),
                                });
                                float fTS = 0;
                                float fTN = 0;
                                float.TryParse(strLineArray[iTSDep].Trim(), out fTS);
                                float.TryParse(strLineArray[iTNDep].Trim(), out fTN);
                                dicDepositionDataOutput[strLineArray[iID].ToString().Trim()].lstDeposition.Add(strLineArray[iDate].Substring(4), new float[4] { fTS, 0, fTN, 0 });
                            }

                        }
                        csv.Dispose();
                        fs.Dispose();
                    }
                }
                catch
                {
                    CommonClass.CurrentLog = "Fail to read model data \"" + Path.GetFileName(depositionAnalysisConfiguration.modelInputDep.baselineModelDataFile) + "\".";
                    CommonClass.CurrentBaseScenario.log.lstLog.Add(CommonClass.CurrentLog);
                    return false;
                }
                GC.Collect();
                #endregion
                _endTime = DateTime.Now;
                CommonClass.TotalTime = Math.Round(_endTime.Subtract(_beginTime).TotalSeconds, 3);
                CommonClass.CurrentLog = "Finish reading model data: " + CommonClass.TotalTime + " s.";
                CommonClass.CurrentBaseScenario.log.lstLog.Add(CommonClass.CurrentLog);
                                
                _beginTime = DateTime.Now;
                string _strid = "";
                CommonClass.CurrentLog = "Read model data \"" + Path.GetFileName(depositionAnalysisConfiguration.modelInputDep.alternativeScenarioFile) + "\".";
                CommonClass.CurrentBaseScenario.log.lstLog.Add(CommonClass.CurrentLog);
                #region Read DepositionMode Control from csv
                _beginTime = DateTime.Now;
                iID = -1; iType = -1; iLat = -1; iLong = -1; iTSDep = -1; iTNDep = -1;
                iDate = -1;
                fs = new FileStream(depositionAnalysisConfiguration.modelInputDep.alternativeScenarioFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);             
                try
                {
                    using (StreamReader csv = new StreamReader(fs, System.Text.Encoding.UTF8))
                    {
                        string strLine = csv.ReadLine();
                        string[] strLineArray = csv.ReadLine().Split(new char[] { ',' });
                        int i = 0;
                        while (i < strLineArray.Length)
                        {
                            string s = strLineArray[i];
                            switch (s.Trim().ToLower())
                            {
                                case "_id":
                                    iID = i;
                                    break;
                                case "_type":
                                    iType = i;
                                    break;
                                case "lat":
                                    iLat = i;
                                    break;
                                case "long":
                                    iLong = i;
                                    break;
                                case "date":
                                    iDate = i;
                                    break;
                                case "tsdep":
                                    iTSDep = i;
                                    break;
                                case "tndep":
                                    iTNDep = i;
                                    break;

                            }
                            i++;
                        }
                        _strid = "";
                        DataTable dtDatesLackness = new DataTable();
                        dtDatesLackness.Columns.Add("id");
                        dtDatesLackness.Columns.Add("daysCount");
                        try
                        {
                            foreach (KeyValuePair<string, SSIADepositionData> k in dicDepositionDataOutput)
                            {
                                DataRow dr = dtDatesLackness.NewRow();
                                if (k.Value.lstDeposition.Count < 365)
                                {
                                    dr[0] = k.Key;
                                    dr[1] = k.Value.lstDeposition.Count;
                                    dtDatesLackness.Rows.Add(dr);
                                    break;
                                }
                            }
                        }
                        catch (Exception)
                        {

                            throw;
                        }                              
                        if (dtDatesLackness.Rows.Count == 0)
                        {
                            while (strLine != null)
                            {
                                strLine = csv.ReadLine();
                                if (strLine == null) break;
                                strLineArray = strLine.Split(new char[] { ',' });
                                _strid = strLineArray[iID].ToString().Trim();
                                if (dicDepositionDataOutput.ContainsKey(_strid))
                                {
                                    try
                                    {
                                        float fTS = 0;
                                        float fTN = 0;
                                        float.TryParse(strLineArray[iTSDep].Trim(), out fTS);
                                        float.TryParse(strLineArray[iTNDep].Trim(), out fTN);
                                        dicDepositionDataOutput[_strid].lstDeposition[strLineArray[iDate].Trim().Substring(4)][1] = fTS;
                                        dicDepositionDataOutput[_strid].lstDeposition[strLineArray[iDate].Trim().Substring(4)][3] = fTN;
                                    }
                                    catch
                                    {
                                    }

                                }
                                else
                                {

                                }
                                //dicDepositionDataOutput[strLineArray[iID].ToString().Trim()].lstDepositionTS[strLineArray[iDate].Trim().Substring(4)]
                            }
                        }
                        else
                        {
                            CommonClass.CurrentLog = "Read model data \"" + Path.GetFileName(depositionAnalysisConfiguration.modelInputDep.alternativeScenarioFile) + "\".";
                            CommonClass.CurrentBaseScenario.log.lstLog.Add(CommonClass.CurrentLog);
                            #region Read DepositionMode Control from csv
                            _beginTime = DateTime.Now;
                            iID = -1; iType = -1; iLat = -1; iLong = -1; iTSDep = -1; iTNDep = -1;
                            iDate = -1;
                            Dictionary<string, SSIADepositionData> dicDepositionDataOutput1 = new Dictionary<string, SSIADepositionData>();
                            FileStream fs1 = new FileStream(depositionAnalysisConfiguration.modelInputDep.alternativeScenarioFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            try
                            {
                                using (StreamReader csv1 = new StreamReader(fs1, System.Text.Encoding.UTF8))
                                {
                                    string strLine1 = csv1.ReadLine();
                                    string[] strLineArray1 = csv1.ReadLine().Split(new char[] { ',' });
                                    i = 0;
                                    while (i < strLineArray1.Length)
                                    {
                                        string s = strLineArray1[i];
                                        switch (s.Trim().ToLower())
                                        {
                                            case "_id":
                                                iID = i;
                                                break;
                                            case "_type":
                                                iType = i;
                                                break;
                                            case "lat":
                                                iLat = i;
                                                break;
                                            case "long":
                                                iLong = i;
                                                break;
                                            case "date":
                                                iDate = i;
                                                break;
                                            case "tsdep":
                                                iTSDep = i;
                                                break;
                                            case "tndep":
                                                iTNDep = i;
                                                break;

                                        }
                                        i++;
                                    }
                                    while (strLine1 != null)
                                    {
                                        strLine1 = csv1.ReadLine();
                                        if (strLine1 == null) break;
                                        strLineArray1 = strLine1.Split(new char[] { ',' });
                                        //if (strLineArray[iDate].Substring(0, 4) != startYear) continue;
                                        if (dicDepositionDataOutput1.ContainsKey(strLineArray1[iID].ToString().Trim()))//strLineArray[iDate].Substring(0, 4)))
                                        {
                                            try
                                            {
                                                float fTS = 0;
                                                float fTN = 0;
                                                float.TryParse(strLineArray1[iTSDep].Trim(), out fTS);
                                                float.TryParse(strLineArray1[iTNDep].Trim(), out fTN);
                                                dicDepositionDataOutput1[strLineArray1[iID].ToString().Trim()].lstDeposition.Add(strLineArray1[iDate].Substring(4), new float[4] { 0, fTS, 0, fTN });
                                                //dicDepositionDataOutput[strLineArray[iID].ToString().Trim()].lstDepositionTN.Add(strLineArray[iDate].Substring(4), new float[2] { Convert.ToSingle(strLineArray[iTNDep]), -9 });
                                            }
                                            catch
                                            {
                                            }
                                        }
                                        else
                                        {
                                            dicDepositionDataOutput1.Add(strLineArray1[iID].ToString().Trim(), new SSIADepositionData()
                                            {
                                                Date = strLineArray1[iDate].Substring(0, 4),
                                                id = strLineArray1[iID],
                                                lat = Convert.ToDouble(strLineArray1[iLat]),
                                                longitude = Convert.ToDouble(strLineArray1[iLong]),
                                                type = strLineArray1[iType],
                                                lstDeposition = new Dictionary<string, float[]>(),
                                                //lstDepositionTN = new Dictionary<string, float[]>(),
                                            });
                                            float fTS = 0;
                                            float fTN = 0;
                                            float.TryParse(strLineArray1[iTSDep].Trim(), out fTS);
                                            float.TryParse(strLineArray1[iTNDep].Trim(), out fTN);
                                            dicDepositionDataOutput1[strLineArray1[iID].ToString().Trim()].lstDeposition.Add(strLineArray1[iDate].Substring(4), new float[4] { 0, fTS, 0, fTN });
                                            //dicDepositionDataOutput[strLineArray[iID].ToString().Trim()].lstDepositionTN.Add(strLineArray[iDate].Substring(4), new float[2] { Convert.ToSingle(strLineArray[iTNDep]), -9 });
                                        }
                                        //dicDepositionDataOutput[strLineArray[iID].ToString().Trim()].lstDepositionTS[strLineArray[iDate].Trim().Substring(4)]
                                    }
                                    csv.Dispose();
                                    fs.Dispose();
                                }
                            }
                            catch
                            {
                                CommonClass.CurrentLog = "Fail to read model data \"" + Path.GetFileName(depositionAnalysisConfiguration.modelInputDep.alternativeScenarioFile) + "\".";
                                CommonClass.CurrentBaseScenario.log.lstLog.Add(CommonClass.CurrentLog);
                                return false;
                            }
                            GC.Collect();
                            #endregion
                            _endTime = DateTime.Now;
                            CommonClass.TotalTime = Math.Round(_endTime.Subtract(_beginTime).TotalSeconds, 3);
                            CommonClass.CurrentLog = "Finish reading model data: " + CommonClass.TotalTime + " s.";
                            CommonClass.CurrentBaseScenario.log.lstLog.Add(CommonClass.CurrentLog);

                            _beginTime = DateTime.Now;
                            _strid = "";
                            CommonClass.CurrentLog = "Read model data \"" + Path.GetFileName(depositionAnalysisConfiguration.modelInputDep.baselineModelDataFile) + "\".";
                            CommonClass.CurrentBaseScenario.log.lstLog.Add(CommonClass.CurrentLog);
                            #region Read DepositionModel Base from csv //save to dicDepositionDataOutput
                            _beginTime = DateTime.Now;
                            iID = -1; iType = -1; iLat = -1; iLong = -1; iTSDep = -1; iTNDep = -1;
                            iDate = -1;
                            fs1 = new FileStream(depositionAnalysisConfiguration.modelInputDep.baselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            try
                            {
                                using (StreamReader csv1 = new StreamReader(fs1, System.Text.Encoding.UTF8))
                                {
                                    string strLine1 = csv1.ReadLine();
                                    string[] strLineArray1 = csv1.ReadLine().Split(new char[] { ',' });
                                    i = 0;
                                    while (i < strLineArray1.Length)
                                    {
                                        string s = strLineArray1[i];
                                        switch (s.Trim().ToLower())
                                        {
                                            case "_id":
                                                iID = i;
                                                break;
                                            case "_type":
                                                iType = i;
                                                break;
                                            case "lat":
                                                iLat = i;
                                                break;
                                            case "long":
                                                iLong = i;
                                                break;
                                            case "date":
                                                iDate = i;
                                                break;
                                            case "tsdep":
                                                iTSDep = i;
                                                break;
                                            case "tndep":
                                                iTNDep = i;
                                                break;
                                        }
                                        i++;
                                    }
                                    while (strLine1 != null)
                                    {
                                        strLine1 = csv1.ReadLine();
                                        _strid = "";
                                        if (strLine1 == null) break;
                                        strLineArray1 = strLine1.Split(new char[] { ',' });
                                        _strid = strLineArray1[iID].ToString().Trim();
                                        if (dicDepositionDataOutput1.ContainsKey(_strid))
                                        {
                                            try
                                            {
                                                float fTS = 0;
                                                float fTN = 0;
                                                float.TryParse(strLineArray1[iTSDep].Trim(), out fTS);
                                                float.TryParse(strLineArray1[iTNDep].Trim(), out fTN);
                                                dicDepositionDataOutput1[_strid].lstDeposition[strLineArray1[iDate].Trim().Substring(4)][0] = fTS;
                                                dicDepositionDataOutput1[_strid].lstDeposition[strLineArray1[iDate].Trim().Substring(4)][2] = fTN;
                                            }
                                            catch (Exception)
                                            {

                                                throw;
                                            }
                                        }
                                        else
                                        {
                                        }
                                    }
                                    csv.Dispose();
                                    fs.Dispose();
                                }
                            }
                            catch
                            {
                                //string _failid = _strid;
                                //float[] failT = new float[4];
                                //failT = dicDepositionDataOutput[_failid].lstDeposition.Values.ToArray()[0];
                                CommonClass.CurrentLog = "Fail to read model data \"" + Path.GetFileName(depositionAnalysisConfiguration.modelInputDep.baselineModelDataFile) + "\".";
                                CommonClass.CurrentBaseScenario.log.lstLog.Add(CommonClass.CurrentLog);
                                return false;
                            }
                            GC.Collect();
                            #endregion
                            _endTime = DateTime.Now;
                            CommonClass.TotalTime = Math.Round(_endTime.Subtract(_beginTime).TotalSeconds, 3);
                            CommonClass.CurrentLog = "Finish reading model data: " + CommonClass.TotalTime + " s.";
                            CommonClass.CurrentBaseScenario.log.lstLog.Add(CommonClass.CurrentLog);
                        }
                                                
                        csv.Dispose();
                        fs.Dispose();
                    }                    
                }                
                catch
                {
                    string _failid = _strid;
                    float[] failT=new float[4];
                    failT = dicDepositionDataOutput[_failid].lstDeposition.Values.ToArray()[0];
                    CommonClass.CurrentLog = "Fail to read model data \"" + Path.GetFileName(depositionAnalysisConfiguration.modelInputDep.alternativeScenarioFile) + "\".";
                    CommonClass.CurrentBaseScenario.log.lstLog.Add(CommonClass.CurrentLog);
                    return false;
                }
                GC.Collect();
                #endregion
                _endTime = DateTime.Now;
                CommonClass.TotalTime = Math.Round(_endTime.Subtract(_beginTime).TotalSeconds, 3);
                CommonClass.CurrentLog = "Finish reading model data: " + CommonClass.TotalTime + " s.";
                CommonClass.CurrentBaseScenario.log.lstLog.Add(CommonClass.CurrentLog);
                
                               

                //change project - write in dictionary (lat,long to lambert) - for draw map
                _beginTime = DateTime.Now;
                DataTable dt = new DataTable();
                dt.Columns.Add("id");
                dt.Columns.Add("lat");
                dt.Columns.Add("long");
                foreach (KeyValuePair<string, SSIADepositionData> keyvalue in dicDepositionDataOutput)
                {
                    DataRow dr = dt.NewRow();
                    dr[0] = keyvalue.Key;
                    dr[1] = keyvalue.Value.lat;
                    dr[2] = keyvalue.Value.longitude;
                    dt.Rows.Add(dr);
                }
                mats.changeProject(dt, "USA");

                #region Calculate cell center distance from source
                Dictionary<string, double[]> dicCells = new Dictionary<string, double[]>();
                foreach (var item in dicDepositionDataOutput)
                {
                    double[] v = new double[3] { item.Value.lat, item.Value.longitude, 0 };
                    dicCells.Add(item.Value.id, v);
                }
                
                try
                {
                    #region Read Source File
                    Dictionary<string, double[]> dicSource = new Dictionary<string, double[]>();
                    FileStream fs2 = new FileStream(depositionAnalysisConfiguration.modelInputDep.SourceCoordinateFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                    using (StreamReader csv = new StreamReader(fs2, System.Text.Encoding.UTF8))
                    {
                        string strLine = csv.ReadLine();//header
                        strLine = csv.ReadLine();
                        string[] strLineArray;
                        while (strLine != null)
                        {
                            strLineArray = strLine.Split(new char[] { ',' });
                            double[] v = new double[2] { Convert.ToDouble(strLineArray[1]), Convert.ToDouble(strLineArray[2]) };
                            dicSource.Add(strLineArray[0], v);
                            strLine = csv.ReadLine();
                        }
                        csv.Dispose(); fs2.Dispose();
                        GC.Collect();
                    }
                #endregion

                    #region Output Source Location file
                    string filename = depositionAnalysisConfiguration.analysisOptionDep.scenarioName + " SSIA Source Location.csv";
                    BaseOutput baseOutput = new BaseOutput();
                    File.Copy(depositionAnalysisConfiguration.modelInputDep.SourceCoordinateFile, _resultFilePath + "\\" + filename, true);
                    baseOutput.outputName = filename.Replace(".csv", "");
                    baseOutput.outputType = "Source Location";
                    baseOutput.outputFilePath = _resultFilePath + "\\" + filename;
                    if (File.Exists(baseOutput.outputFilePath))
                    {
                        FileInfo fileInfo = new FileInfo(baseOutput.outputFilePath);
                        baseOutput.outputSize = Convert.ToInt32(fileInfo.Length / 1024);
                    }
                    else
                    {
                        baseOutput.outputSize = 0;
                    }
                    baseScenario.lstOutput.Add(baseOutput);

                    CalculateDistance(ref dicCells, dicSource);
                    #endregion
                }
                catch (Exception)
                {
                    
                    throw;
                }                
                                
                #endregion

                #region cal total deposition
                foreach (KeyValuePair<string, SSIADepositionData> K in dicDepositionDataOutput)
                {
                    //#Region cal tzdep --- sulfur deposition
                    float[][] tdep = K.Value.lstDeposition.Values.ToArray();                   
                    float sumBaseTSDep = 0;
                    float sumAltTSDep = 0;
                    float sumBaseTNDep = 0;
                    float sumAltTNDep = 0;
                    for (int i = 0; i < tdep.Length; i++)
                    {
                        sumBaseTSDep = sumBaseTSDep + tdep[i][0];
                        sumAltTSDep = sumAltTSDep + tdep[i][1];
                        sumBaseTNDep = sumBaseTNDep + tdep[i][2];
                        sumAltTNDep = sumAltTNDep + tdep[i][3];
                    }
                    K.Value.baseTSDep = sumBaseTSDep;
                    K.Value.altTSDep = sumAltTSDep;
                    K.Value.deltaTSDep = sumBaseTSDep - sumAltTSDep;
                    K.Value.baseTNDep = sumBaseTNDep;
                    K.Value.altTNDep = sumAltTNDep;
                    K.Value.deltaTNDep = sumBaseTNDep - sumAltTNDep;
                    //#endregion 

                    //#Region cal tndep ---- nitrogen deposition
                    //float[][] tndep = K.Value.lstDeposition.Values.ToArray();
                    //float sumBaseTNDep = 0;
                    //float sumAltTNDep = 0;
                    //for (int i = 0; i < tndep.Length; i++)
                    //{
                    //    sumBaseTNDep = sumBaseTNDep + tndep[i][2];
                    //    sumAltTNDep = sumAltTNDep + tndep[i][3];
                    //}
                    //K.Value.baseTNDep = sumBaseTNDep;
                    //K.Value.altTNDep = sumAltTNDep;
                    //K.Value.deltaTNDep = sumBaseTNDep - sumAltTNDep;
                    //#endregion
                }                
                #endregion

                SaveSSIADepositionData(baseScenario, dicDepositionDataOutput, dicCells);
                _endTime = DateTime.Now;
                CommonClass.TotalTime = Math.Round(_endTime.Subtract(_beginTime).TotalSeconds, 3);
                CommonClass.CurrentBaseScenario.log.lstLog.Add("Finish computing deposition: " + CommonClass.TotalTime + " s.");
                CommonClass.CurrentLog = "Finish computing deposition: " + CommonClass.TotalTime + " s.";
                baseScenario.lstOutput.Reverse();
                return true;
            }
            catch 
            {
                return false;
            }
        }

        public static bool SaveSSIADepositionData(BaseScenario baseScenario, Dictionary<string, SSIADepositionData> dicData, Dictionary<string, double[]> dicDistanceFromSource)
        {
            if (!(baseScenario.configuration is SSIADepositionConfiguration))
            {
                return false;
            }
            try
            {
                int decimaldigits = 8;
                SSIADepositionConfiguration depositionAnalysisConfiguration = baseScenario.configuration as SSIADepositionConfiguration;
                DataTable dt = new DataTable();
                DataRow dr = null;
                dt.Columns.Add("_id");
                dt.Columns.Add("lat");
                dt.Columns.Add("long");
                dt.Columns.Add("Base_TSDep");
                dt.Columns.Add("Alt_TSDep");
                dt.Columns.Add("DeltaTSDep");
                dt.Columns.Add("Base_TNDep");
                dt.Columns.Add("Alt_TNDep");
                dt.Columns.Add("DeltaTNDep");
                dt.Columns.Add("Cell center distance from source(km)");

                foreach (KeyValuePair<string, SSIADepositionData> k in dicData)
                    {
                        dr = dt.NewRow();
                        dr[0] = k.Value.id;
                        dr[1] = Math.Round(k.Value.lat, 6);
                        dr[2] = Math.Round(k.Value.longitude, 6);
                        dr[3] = Math.Round(k.Value.baseTSDep, decimaldigits);
                        dr[4] = Math.Round(k.Value.altTSDep, decimaldigits);
                        dr[5] = Math.Round(k.Value.deltaTSDep, decimaldigits);
                        dr[6] = Math.Round(k.Value.baseTNDep, decimaldigits);
                        dr[7] = Math.Round(k.Value.altTNDep, decimaldigits);
                        dr[8] = Math.Round(k.Value.deltaTNDep, decimaldigits);
                        dr[9] = dicDistanceFromSource[k.Value.id][2];
                        dt.Rows.Add(dr);
                    }

                if (!CommonClass.IsBatch)
                {
                    if (_resultFilePath == "" && _resultFilePath.Length == 0 || _resultFilePath != CommonClass.ResultFilePath + @"\Result\Output\" + (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.scenarioName)
                        _resultFilePath = CommonClass.ResultFilePath + @"\Result\Output\" + (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.scenarioName;
                }
                else
                {
                    if (_resultFilePath == "" && _resultFilePath.Length == 0 || _resultFilePath != CommonClass.ResultFilePath + @"\" + (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.scenarioName)
                        _resultFilePath = CommonClass.ResultFilePath + @"\" + (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.scenarioName;
                }
                if (!Directory.Exists(_resultFilePath))
                    System.IO.Directory.CreateDirectory(_resultFilePath);
                //modify file name
                string strFile = depositionAnalysisConfiguration.analysisOptionDep.scenarioName + " SSIA Deposition Data.csv";
                BaseOutput baseOutput = new BaseOutput();
                CommonClass.SaveCSV(dt, _resultFilePath + @"\" + strFile, "Annual");
                baseOutput.outputName = strFile.Replace(".csv", "");
                baseOutput.outputType = "Model Network";
                baseOutput.outputFilePath = _resultFilePath + @"\" + strFile;
                if (File.Exists(_resultFilePath + @"\" + strFile))
                {
                    FileInfo fileInfo = new FileInfo(_resultFilePath + @"\" + strFile);
                    baseOutput.outputSize = Convert.ToInt32(fileInfo.Length / 1024);
                }
                else
                {
                    baseOutput.outputSize = 0;
                }
                baseScenario.lstOutput.Add(baseOutput);
                dt.Dispose();
                return true;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return false;
            }
        }
        
        #endregion

        public static void CalculateDistance(ref Dictionary<string, double[]> dicGrid, Dictionary<string, double[]> dicSource)
        {
            try
            {
                double lat0, long0;
                double lat1, long1;
                foreach (var source in dicSource)
                {
                    lat0 = source.Value[0];
                    long0 = source.Value[1];

                    foreach (var grid in dicGrid)
                    {
                        lat1 = grid.Value[0];
                        long1 = grid.Value[1];

                        double distance = CommonClass.GetDistance(lat0, long0, lat1, long1);
                        if (grid.Value[2] == 0) grid.Value[2] = distance;
                        grid.Value[2] = Math.Min(distance, grid.Value[2]);
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
