using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class uc_AnalysisOption : UserControl
    {
        SMAT_CE _m = null;
        public uc_AnalysisOption(SMAT_CE mats)
        {
            InitializeComponent();
            _m = mats;
        }

        private void choUseModelFRMData_CheckedChanged(object sender, EventArgs e)
        {
            if (choUseModelFRMData.Checked)
            {
                _m.Ssia_useMonitor = true;
                _m.btnSaveRun.Enabled = false;
            }
            else
            {
                _m.Ssia_useMonitor = false;
            }
        }

        private void uc_AnalysisOption_Load(object sender, EventArgs e)
        {
            if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAOzone)
            {
                choUseModelFRMData.Text = Language.Localization.GetValue("Cumulative Impact Analysis (use both model && Ozone monitoring data)");
                panelModelOption.Visible = false;
            }
            else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADeposition)    //added by K.B.
            {
                choUseModelFRMData.Text = Language.Localization.GetValue("Cumulative Impact Analysis (use both model && Deposition monitoring data)");
                choUseModelFRMData.Enabled = false;
                choUseModelFRMData.Checked = false;
                panelModelOption.Visible = false;
            }
            else
            {
                choUseModelFRMData.Text = Language.Localization.GetValue("Cumulative Impact Analysis (use both model && FRM PM2.5 data)");
            }
        }
    }
}
