using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_MonitorDataInputD : UserControl
    {
        public uc_MonitorDataInputD()
        {
            InitializeComponent();
        }

        private void btnOfficialMonitorD_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(CommonClass.officialPMFile) || !Directory.Exists(Path.GetDirectoryName(CommonClass.officialPMFile)))
                {
                    openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData\SSIA";
                }
                else
                {
                    openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.officialPMFile);
                }
                openfile.Title = "Select file...";
                //openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                openfile.Filter = "CSV Files(*.csv)|*.csv";

                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.officialPMFile = openfile.FileName;
                    txtOfficialMonitorDataFileD.Text = Path.GetFileName(CommonClass.officialPMFile);
                    openfile.RestoreDirectory = true;
                    cboEndYearD.DataSource = null;
                    cboStartYearD.DataSource = null;
                    bool isOK = CommonClass.getmonitorYear("");
                    if (!isOK)
                    {
                        MessageBox.Show("Official Quarterly Average FRM Data File is ill-formatted data!");
                    }
                    else
                    {
                        List<string> year = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears;
                        cboStartYearD.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                        cboEndYearD.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();

                        if (cboStartYearD.Items.Count > 7)
                            cboStartYearD.SelectedIndex = 6;
                        else
                            cboStartYearD.SelectedIndex = cboStartYearD.Items.Count - 1;
                        if (cboEndYearD.Items.Count > 11)
                            cboEndYearD.SelectedIndex = 10;
                        else
                            cboEndYearD.SelectedIndex = cboEndYearD.Items.Count - 1;
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboStartYearD_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboEndYearD.Text) < Convert.ToInt32(cboStartYearD.Text))
                    cboEndYearD.Text = cboStartYearD.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboEndYearD_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboEndYearD.Text) < Convert.ToInt32(cboStartYearD.Text))
                    cboStartYearD.Text = cboEndYearD.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choVNA_CheckedChanged(object sender, EventArgs e)
        {
            if(!(choVNA.Checked||choEVNA.Checked))
            {
                choEVNA.Checked = true;
            }
        }

        private void choEVNA_CheckedChanged(object sender, EventArgs e)
        {
            if (!(choVNA.Checked || choEVNA.Checked))
            {
                choVNA.Checked = true;
            }
        }
    }
}
