using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_MonitorDataInputO : UserControl
    {
        public uc_MonitorDataInputO()
        {
            InitializeComponent();
        }

        private void choVNA_CheckedChanged(object sender, EventArgs e)
        {
            if (!choVNA.Checked)
            {
                if (!choEVNA.Checked)
                {
                    choEVNA.Checked = true;
                }
            }
        }

        private void choEVNA_CheckedChanged(object sender, EventArgs e)
        {
            if (!choEVNA.Checked)
            {
                if (!choVNA.Checked)
                {
                    choVNA.Checked = true;
                }
            }
        }

        private void btnOzoneData_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(CommonClass.ozoneMonitorFile) || !Directory.Exists(Path.GetDirectoryName(CommonClass.ozoneMonitorFile)))
                {
                    openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                }
                else
                {
                    openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.ozoneMonitorFile);
                }
                openfile.Title = "Select file...";
                // Application.StartupPath + @"\Data\SampleData";
                openfile.Filter = "CSV Files(*.csv)|*.csv";
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.ozoneMonitorFile = openfile.FileName;
                    txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);
                    openfile.RestoreDirectory = true;
                    cboEndYearOzone.Items.Clear();
                    cboStartYearOzone.Items.Clear();
                    bool isOK = CommonClass.getmonitorYear("");
                    if (!isOK)
                    {
                        MessageBox.Show("Ozone Monitor Data File is ill-formatted data!");
                    }
                    else
                    {
                        List<string> year = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData;
                        for (int i = 0; i < year.Count; i++)
                        {
                            cboStartYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                            cboEndYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                        }

                        if (cboStartYearOzone.Items.Count >= 5)
                            cboStartYearOzone.SelectedIndex = 4;
                        else
                            cboStartYearOzone.SelectedIndex = cboStartYearOzone.Items.Count - 1;
                        if (cboEndYearOzone.Items.Count >= 7)
                            cboEndYearOzone.SelectedIndex = 6;
                        else
                            cboEndYearOzone.SelectedIndex = cboEndYearOzone.Items.Count - 1;
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void uc_MonitorDataInputO_Load(object sender, EventArgs e)
        {
            cboGridOzone.Items.Add("1x1");
            cboGridOzone.Items.Add("3x3");
            cboGridOzone.Items.Add("5x5");
            cboGridOzone.Items.Add("7x7");
            cboStatisticOzone.Items.Add("Mean");
            cboStatisticOzone.Items.Add("Maximum");
            cboStatisticOzone.Items.Add("Maximum-paired in space");
            choChangeHeightAndTop();
        }

        private void cboStartYearOzone_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboEndYearOzone.Text.Substring(0, 4)) < Convert.ToInt32(cboStartYearOzone.Text.Substring(0, 4)))
                    cboEndYearOzone.Text = cboStartYearOzone.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboEndYearOzone_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboEndYearOzone.Text.Substring(0, 4)) < Convert.ToInt32(cboStartYearOzone.Text.Substring(0, 4)))
                    cboStartYearOzone.Text = cboEndYearOzone.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }


        /*private void choChangeHeightAndTop()
        {
            try
            {
                if(CommonClass.CurrentAnalysis==enumAnalysis.SSIAAnnualPM||CommonClass.CurrentAnalysis==enumAnalysis.SSIADailyPM)
                {
                    pnlTemAdj.Top = chkDS.Top;

                    this.Height = 552 - 184 - 28 - 42 - 5;
                }
                else if (CommonClass.CurrentAnalysis==enumAnalysis.SSIAOzone)
                {
                    if(!chkDS.Checked)
                    {
                        pnlTemAdj.Top = panelDS.Top;
                        this.Height = 552 - 184 - 28;
                    }
                    else if(!chkDSAdvance.Checked)
                    {
                        pnlTemAdj.Top = pnlDSAdvance.Top;
                        this.Height = 552 - 184;
                    }
                    else if (chkDSAdvance.Checked)
                    {
                        pnlTemAdj.Top = 491;
                        this.Height = 552;
                    }
                }
            }
            catch (Exception ex)
            {
               CommonClass.LogError(ex);
            }
        }*/

        public void choChangeHeightAndTop()
        {
            try
            {
                bool bDS = true, bDSadvance = true;
                bDS = chkDS.Checked;
                bDSadvance = chkDSAdvance.Checked;

                // the default location when all controls are expanded
                int totalHeight = 552;
                int plnDSTop = 275;
                int pnlDSAdvanceTop = 366;
                int pnlTemAdjTop = 491;

                // Calculate the new location
                if (bDS)
                {
                    panelDS.Visible = true;
                    panelDS.Top = plnDSTop;
                    if (bDSadvance)
                    {
                        pnlDSAdvance.Visible = true;
                        pnlDSAdvance.Top = pnlDSAdvanceTop;
                        pnlTemAdj.Top = pnlTemAdjTop;
                        this.Height = totalHeight;
                    }
                    else
                    {
                        pnlDSAdvance.Visible = false;
                        pnlTemAdj.Top = pnlDSAdvanceTop;
                        this.Height = totalHeight - pnlDSAdvance.Height;
                    }
                }
                else
                {
                    panelDS.Visible = false;
                    pnlDSAdvance.Visible = false;
                    pnlTemAdj.Top = plnDSTop;
                    this.Height = totalHeight - panelDS.Height - pnlDSAdvance.Height;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void chkDS_CheckedChanged(object sender, EventArgs e)
        {
            if(!chkDS.Checked)
            {
                chkDSAdvance.Checked = false;
            }
            choChangeHeightAndTop();
        }

        private void chkDSAdvance_CheckedChanged(object sender, EventArgs e)
        {
            choChangeHeightAndTop();
        }
    }
}
