using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_DataInputV : ucBase
    {
        //public string _fileName;
        public static int intPage = 0;
        string path = "";
        public uc_DataInputV()
        {
            InitializeComponent();

            #region Language added by Edwin
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion

        }

        private void uc_DataInputV_Load(object sender, EventArgs e)
        {
            try
            {
                cboModelGridTypeVisi.Items.Add("1x1");
                cboModelGridTypeVisi.Items.Add("3x3");
                cboModelGridTypeVisi.Items.Add("5x5");
                cboModelGridTypeVisi.Items.Add("7x7");

                chkForecastIMPROVEAdvanced_CheckStateChanged(sender, e);
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }

        }

        /// <summary>
        /// Initialize Control
        /// add by devin
        /// 2017-02-17
        /// </summary>
        public void InitializeControl()
        {
            try
            {
                if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV == null)
                {
                    (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV = new DataInputV();

                    if (CommonClass.dicExampleConfiguration != null)
                    {                                                 
                        txtOldIMPROVEAlgorithmInputVisi.ToTag(CommonClass.dicExampleConfiguration["Visibility"]["monitorDataFileOldAlgorithm"]);
                        txtNewIMPROVEAlgorithmInputVisi.ToTag(CommonClass.dicExampleConfiguration["Visibility"]["monitorDataFileNewAlgorithm"]);
                        txtBaselineModelInputVisi.ToTag(CommonClass.dicExampleConfiguration["Visibility"]["baselineModelDataFile"]);
                        txtForecastModelInputVisi.ToTag(CommonClass.dicExampleConfiguration["Visibility"]["forecastModelDataFile"]);
                        txtforecastIMPROVE.ToTag(CommonClass.dicExampleConfiguration["Visibility"]["forecastIMPROVEDataFile"]);
                    }                   
                    rbtnCreateIMPROVE.Checked = false;
                    chkForecastIMPROVEAdvanced.Checked = false;
                    rbtnForecastIMPROVE.Checked = false;
                    cboModelGridTypeVisi.SelectedIndex = 1;
                }
                else
                {
                    DataInputV dataInputV = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV;
                    txtOldIMPROVEAlgorithmInputVisi.Text = Path.GetFileName(dataInputV.monitorDataFileOldAlgorithm);
                    txtOldIMPROVEAlgorithmInputVisi.Tag = dataInputV.monitorDataFileOldAlgorithm;

                    txtNewIMPROVEAlgorithmInputVisi.Text = Path.GetFileName(dataInputV.monitorDataFileNewAlgorithm);
                    txtNewIMPROVEAlgorithmInputVisi.Tag = dataInputV.monitorDataFileNewAlgorithm;

                    txtBaselineModelInputVisi.Text = Path.GetFileName(dataInputV.baselineModelDataFile);
                    txtBaselineModelInputVisi.Tag = dataInputV.baselineModelDataFile;

                    txtForecastModelInputVisi.Text = Path.GetFileName(dataInputV.forecastModelDataFile);
                    txtForecastModelInputVisi.Tag = dataInputV.forecastModelDataFile;

                    rbtnCreateIMPROVE.Checked = dataInputV.isCreateForecastIMPROVEData;
                    rbtnForecastIMPROVE.Checked = dataInputV.isCheckedForecastIMPROVEAdvanced;
                    if (rbtnCreateIMPROVE.Checked||rbtnForecastIMPROVE.Checked)
                    {
                        chkForecastIMPROVEAdvanced.Checked = true;
                    }
                  //  chkForecastIMPROVEAdvanced.Checked = dataInputV.isCheckedForecastIMPROVEAdvanced;
                 //   rbtnForecastIMPROVE.Checked = !rbtnCreateIMPROVE.Checked;

                    txtforecastIMPROVE.Text = Path.GetFileName(dataInputV.forecastIMPROVEDataFile);// by shengyewen
                    txtforecastIMPROVE.Tag = dataInputV.forecastIMPROVEDataFile;// by shengyewen

                    cboModelGridTypeVisi.Text = dataInputV.temporalAdjustmentAtMonitorGrid;

                }

                //����Choose Desired Output ��ѡ����»�ɵ�Algorithm���ж�Data Input��Monitor Data �ļ����ǲ��ú���Algorithm �ļ�
                if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseNewVersionforIMPROVEAlgorithm)
                {                  
                    txtNewIMPROVEAlgorithmInputVisi.Enabled = true;
                    btnNewIMPROVEAlgorithmInputVisi.Enabled = true;
                    txtOldIMPROVEAlgorithmInputVisi.Enabled = false;
                    btnOldIMPROVEAlgorithmInputVisi.Enabled = false;
                    if (rbtnForecastIMPROVE.Checked)
                    {
                        txtNewIMPROVEAlgorithmInputVisi.Enabled = false;
                        btnNewIMPROVEAlgorithmInputVisi.Enabled = false;
                    }
                    else if (rbtnCreateIMPROVE.Checked)
                    {
                        txtNewIMPROVEAlgorithmInputVisi.Enabled = true;
                        btnNewIMPROVEAlgorithmInputVisi.Enabled = true;
                    }
                }
                else
                {
                    txtNewIMPROVEAlgorithmInputVisi.Enabled = false;
                    txtNewIMPROVEAlgorithmInputVisi.Enabled = false;
                    txtOldIMPROVEAlgorithmInputVisi.Enabled = true;
                    btnOldIMPROVEAlgorithmInputVisi.Enabled = true;
                }
                //��Դ�ѡ��chkForecastIMPROVEAdvanced����������г�ʼ��
                if (chkForecastIMPROVEAdvanced.Checked)
                {
                    chkForecastIMPROVEAdvanced_Click(null, null);
                }

                //BetaVersion����Ҫ�������㷨
                //rbtnCreateIMPROVE.Visible = !CommonClass.BetaVersion;
                //chkForecastIMPROVEAdvanced.Visible = !CommonClass.BetaVersion;
                //rbtnForecastIMPROVE.Visible = !CommonClass.BetaVersion;
                //txtforecastIMPROVE.Visible = !CommonClass.BetaVersion;
                //btnforecastIMPROVE.Visible = !CommonClass.BetaVersion;

            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }

        }

        /// <summary>
        /// Check Visibility Data input 
        /// add by devin 
        /// 2017-02-17
        /// </summary>
        /// <returns></returns>
        public string checkDataInputV()
        {
            try
            {
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;

                //check monitor data file
                if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseOldVersionforIMPROVEAlgorithm)
                {

                    if (txtOldIMPROVEAlgorithmInputVisi.Tag != null && txtOldIMPROVEAlgorithmInputVisi.Tag.ToString().Length > 0)
                    {
                        if (!File.Exists(txtOldIMPROVEAlgorithmInputVisi.Tag.ToString()))
                        { errorTipBuilder.Append(LanguageOld.Translate("Monitor Data File path does not exist!\n")); }
                        else
                        {
                            fileStream = new FileStream(txtOldIMPROVEAlgorithmInputVisi.Tag.ToString(), FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Monitor Data File is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                string[] requireColumns = new string[] { "_id", "_type", "lat", "long", "date", "frh", "pm25", "crustal", "amm_no3", "omc", "ec", "pm10", "cm", "amm_so4", "e_amm_so4", "e_amm_no3", "e_omc", "e_ec", "e_crustal", "e_cm", "tbext", "dv", "good_year", "group", "possible_ndays", "ndays", "complete_quarter", "sf", "so4f" };
                                ok = fieldNameAdd.Length == 29;
                                foreach (var item in requireColumns)
                                {
                                    if (!fieldNameAdd.Contains(item))
                                    {
                                        ok = false;
                                    }
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(LanguageOld.Translate("Monitor Data File is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(LanguageOld.Translate("Please select a Monitor Data File!\n"));
                    }
                }
                else
                {
                    if (txtNewIMPROVEAlgorithmInputVisi.Tag != null && txtNewIMPROVEAlgorithmInputVisi.Tag.ToString().Length > 0)
                    {
                        if (!File.Exists(txtNewIMPROVEAlgorithmInputVisi.Tag.ToString()))
                        { errorTipBuilder.Append(LanguageOld.Translate("Monitor Data File path does not exist!\n")); }
                        else
                        {
                            fileStream = new FileStream(txtNewIMPROVEAlgorithmInputVisi.Tag.ToString(), FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Monitor Data File is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                string[] requireColumns = new string[] { "_id", "_type", "lat", "long", "date", "frh", "fsrh", "flrh", "fssrh", "ss_rayleigh", "sea_salt", "pm25", "crustal", "amm_no3", "omc", "ec", "pm10", "cm", "amm_so4", "large_omc", "small_omc", "large_amm_so4", "small_amm_so4", "large_amm_no3", "small_amm_no3", "e_amm_so4", "e_amm_no3", "e_omc", "e_ec", "e_crustal", "e_cm", "e_sea_salt", "tbext", "dv", "good_year", "group", "possible_ndays", "ndays", "complete_quarter", "sf", "so4f" };
                                ok = fieldNameAdd.Length == 41;
                                foreach (var item in requireColumns)
                                {
                                    if (!fieldNameAdd.Contains(item))
                                    {
                                        ok = false;
                                    }
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(LanguageOld.Translate("Monitor Data File is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(LanguageOld.Translate("Please select a Monitor Data File!\n"));
                    }
                }

                //check model data file
                if (txtBaselineModelInputVisi.Tag != null && txtBaselineModelInputVisi.Tag.ToString().Length > 0)
                {
                    if (!File.Exists(txtBaselineModelInputVisi.Tag.ToString()))
                    { errorTipBuilder.Append(LanguageOld.Translate("Model Baseline Data File path does not exist!\n")); }
                    else
                    {
                        fileStream = new FileStream(txtBaselineModelInputVisi.Tag.ToString(), FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorTipBuilder.Append(LanguageOld.Translate("Model Baseline File is ill-formatted data!\n"));
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            string[] requireColumns = new string[] { "_id", "_type", "lat", "long", "date", "crustal", "nh4", "so4", "ec", "no3", "oc", "pm25", "cm" };
                            ok = fieldNameAdd.Length == 13;
                            foreach (var item in requireColumns)
                            {
                                if (!fieldNameAdd.Contains(item))
                                {
                                    ok = false;
                                }
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Model Baseline File is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(LanguageOld.Translate("Please select a Model Baseline File!\n"));
                }

                if (txtForecastModelInputVisi.Tag != null && txtForecastModelInputVisi.Tag.ToString().Length > 0)
                {
                    if (!File.Exists(txtForecastModelInputVisi.Tag.ToString()))
                    { errorTipBuilder.Append(LanguageOld.Translate("Model Forecast Data File path does not exist!\n")); }
                    else
                    {
                        fileStream = new FileStream(txtForecastModelInputVisi.Tag.ToString(), FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorTipBuilder.Append(LanguageOld.Translate("Model Forecast File is ill-formatted data!\n"));
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            string[] requireColumns = new string[] { "_id", "_type", "lat", "long", "date", "crustal", "nh4", "so4", "ec", "no3", "oc", "pm25", "cm" };
                            ok = fieldNameAdd.Length == 13;
                            foreach (var item in requireColumns)
                            {
                                if (!fieldNameAdd.Contains(item))
                                {
                                    ok = false;
                                }
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Model Forecast File is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(LanguageOld.Translate("Please select a Model Forecast File!\n"));
                }

                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        /// <summary>
        ///�������� 
        ///add by devin
        ///2017-02-17
        /// </summary>
        public string SaveDataInputV()
        {
            try
            {
                StringBuilder errorBuilder = new StringBuilder("");
                if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV == null)
                    (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV = new DataInputV();
                DataInputV dataInputV = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV;

                #region added by devin 20120916
                //��Filtering�����е� monitor data year�����ԡ�2000-2006-daily IMPROVE-all data-new equation.csv���ļ� 
                if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseOldVersionforIMPROVEAlgorithm)//Old Version
                {
                    if (dataInputV.lstMonitorDataOld == null || txtOldIMPROVEAlgorithmInputVisi.Tag.ToString() != dataInputV.monitorDataFileOldAlgorithm)
                    {
                        dataInputV.monitorDataFileOldAlgorithm = txtOldIMPROVEAlgorithmInputVisi.Tag.ToString();
                        List<string> lstYearsOld = CommonClass.getListYearsFromCSV(dataInputV.monitorDataFileOldAlgorithm);
                        if (lstYearsOld == null)
                            errorBuilder.Append("Fail to read data \"" + Path.GetFileName(dataInputV.monitorDataFileOldAlgorithm) + "\"");
                        else
                        {
                            dataInputV.lstMonitorDataOld = new List<string>();
                            foreach (string item in lstYearsOld)
                            {
                                dataInputV.lstMonitorDataOld.Add(item);
                            }
                            dataInputV.lstMonitorDataOld = dataInputV.lstMonitorDataOld.Distinct().ToList();
                            dataInputV.lstMonitorDataOld.Sort();
                        }
                    }
                }
                else//New Version
                {
                    if (dataInputV.lstMonitorDataNew == null || txtNewIMPROVEAlgorithmInputVisi.Tag.ToString() != dataInputV.monitorDataFileNewAlgorithm)
                    {
                        dataInputV.monitorDataFileNewAlgorithm = txtNewIMPROVEAlgorithmInputVisi.Tag.ToString();
                        List<string> lstYearsNew = CommonClass.getListYearsFromCSV(dataInputV.monitorDataFileNewAlgorithm);
                        if (lstYearsNew == null)
                            errorBuilder.Append("Fail to read data \"" + Path.GetFileName(dataInputV.monitorDataFileNewAlgorithm) + "\"");
                        else
                        {
                            dataInputV.lstMonitorDataNew = new List<string>();
                            foreach (string item in lstYearsNew)
                            {
                                dataInputV.lstMonitorDataNew.Add(item);
                            }
                            dataInputV.lstMonitorDataNew = dataInputV.lstMonitorDataNew.Distinct().ToList();
                            dataInputV.lstMonitorDataNew.Sort();
                        }
                    }
                }
                #endregion

                dataInputV.baselineModelDataFile = txtBaselineModelInputVisi.Tag == null ? "" : txtBaselineModelInputVisi.Tag.ToString();
                dataInputV.forecastModelDataFile = txtForecastModelInputVisi.Tag == null ? "" : txtForecastModelInputVisi.Tag.ToString();             
                dataInputV.isCreateForecastIMPROVEData = rbtnCreateIMPROVE.Checked;
                dataInputV.isCheckedForecastIMPROVEAdvanced = rbtnForecastIMPROVE.Checked;
           
                dataInputV.forecastIMPROVEDataFile = txtforecastIMPROVE.Tag == null ? "" : txtforecastIMPROVE.Tag.ToString();
                dataInputV.temporalAdjustmentAtMonitorGrid = cboModelGridTypeVisi.Text;
                (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV = dataInputV;
                return errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return "Fail to read monitor data";
            }
        }

        private void btnOldIMPROVEAlgorithmInputVisi_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                string filePath = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV == null ? "" : (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.monitorDataFileOldAlgorithm;

                filePath = (string.IsNullOrEmpty(filePath) && txtOldIMPROVEAlgorithmInputVisi.Tag != null) ? Path.GetDirectoryName(txtOldIMPROVEAlgorithmInputVisi.Tag.ToString()) : Path.GetDirectoryName(filePath);
                if (string.IsNullOrEmpty(filePath) || !Directory.Exists(filePath))
                {
                    openfile.InitialDirectory = (string.IsNullOrEmpty(path) || !Directory.Exists(path)) ? (Application.StartupPath + @"\Data\SampleData") : path;
                }
                else
                {
                    openfile.InitialDirectory = filePath;
                }
                openfile.Title = "Select file...";
                openfile.Filter = "CSV Files(*.csv)|*.csv";
                openfile.RestoreDirectory = true;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    path = Path.GetDirectoryName(openfile.FileName);
                    txtOldIMPROVEAlgorithmInputVisi.Tag = openfile.FileName;
                    txtOldIMPROVEAlgorithmInputVisi.Text = Path.GetFileName(openfile.FileName);

                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnNewIMPROVEAlgorithmInputVisi_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                string filePath = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV == null ? "" : (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.monitorDataFileNewAlgorithm;
                filePath = (string.IsNullOrEmpty(filePath) && txtNewIMPROVEAlgorithmInputVisi.Tag != null) ? Path.GetDirectoryName(txtNewIMPROVEAlgorithmInputVisi.Tag.ToString()) : Path.GetDirectoryName(filePath);

                if (string.IsNullOrEmpty(filePath) || !Directory.Exists(filePath))
                {
                    openfile.InitialDirectory = (string.IsNullOrEmpty(path) || !Directory.Exists(path)) ? (Application.StartupPath + @"\Data\SampleData") : path;
                }
                else
                {
                    openfile.InitialDirectory = filePath;
                }

                openfile.Title = "Select file...";
                //openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                openfile.Filter = "CSV Files(*.csv)|*.csv";
                openfile.RestoreDirectory = true;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    path = Path.GetDirectoryName(openfile.FileName);
                    txtNewIMPROVEAlgorithmInputVisi.Tag = openfile.FileName;
                    txtNewIMPROVEAlgorithmInputVisi.Text = Path.GetFileName(txtNewIMPROVEAlgorithmInputVisi.Tag.ToString());
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnBaselineModelInputVisi_Click(object sender, EventArgs e)
        {
            try
            {

                OpenFileDialog openfile = new OpenFileDialog();
                string filePath = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV == null ? "" : (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.baselineModelDataFile;
                filePath = (string.IsNullOrEmpty(filePath) && txtBaselineModelInputVisi.Tag != null) ? Path.GetDirectoryName(txtBaselineModelInputVisi.Tag.ToString()) : Path.GetDirectoryName(filePath);

                if (string.IsNullOrEmpty(filePath) || !Directory.Exists(filePath))
                {
                    openfile.InitialDirectory = (string.IsNullOrEmpty(path) || !Directory.Exists(path)) ? (Application.StartupPath + @"\Data\SampleData") : path;
                }
                else
                {
                    openfile.InitialDirectory = filePath;
                }


                openfile.Title = "Select file...";
                //openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                openfile.Filter = "CSV Files(*.csv)|*.csv";
                openfile.RestoreDirectory = true;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    path = Path.GetDirectoryName(openfile.FileName);
                    txtBaselineModelInputVisi.Tag = openfile.FileName;
                    txtBaselineModelInputVisi.Text = Path.GetFileName(openfile.FileName);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnForecastModelInputVisi_Click(object sender, EventArgs e)
        {
            try
            {

                OpenFileDialog openfile = new OpenFileDialog();
                string filePath = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV == null ? "" : (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.forecastModelDataFile;
                filePath = (string.IsNullOrEmpty(filePath) && txtForecastModelInputVisi.Tag != null) ? Path.GetDirectoryName(txtForecastModelInputVisi.Tag.ToString()) : Path.GetDirectoryName(filePath);

                if (string.IsNullOrEmpty(filePath) || !Directory.Exists(filePath))
                {
                    openfile.InitialDirectory = (string.IsNullOrEmpty(path) || !Directory.Exists(path)) ? (Application.StartupPath + @"\Data\SampleData") : path;
                }
                else
                {
                    openfile.InitialDirectory = filePath;
                }


                openfile.Title = "Select file...";
                //openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                openfile.Filter = "CSV Files(*.csv)|*.csv";
                openfile.RestoreDirectory = true;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    path = Path.GetDirectoryName(openfile.FileName);
                    txtForecastModelInputVisi.Tag = openfile.FileName;
                    txtForecastModelInputVisi.Text = Path.GetFileName(openfile.FileName);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnforecastIMPROVE_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();

                string filePath = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV == null ? "" : (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.forecastIMPROVEDataFile;
                filePath = (string.IsNullOrEmpty(filePath) && txtforecastIMPROVE.Tag != null) ? Path.GetDirectoryName(txtforecastIMPROVE.Tag.ToString()) : Path.GetDirectoryName(filePath);

                if (string.IsNullOrEmpty(filePath) || !Directory.Exists(filePath))
                {
                    openfile.InitialDirectory = (string.IsNullOrEmpty(path) || !Directory.Exists(path)) ? (Application.StartupPath + @"\Data\SampleData") : path;
                }
                else
                {
                    openfile.InitialDirectory = filePath;
                }

                openfile.Title = "Select file...";
                //openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                openfile.Filter = "CSV Files(*.csv)|*.csv";
                openfile.RestoreDirectory = true;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    path = Path.GetDirectoryName(openfile.FileName);
                    txtforecastIMPROVE.Tag = openfile.FileName;
                    txtforecastIMPROVE.Text = Path.GetFileName(openfile.FileName);
                }
            }
            catch (Exception ex)
            {
                Logger.LogError(ex);
            }


        }
        private void lblMonitorData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_4_2_data_input.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblModelData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_4_2_data_input.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblUsingModelData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_4_2_data_input.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }


        private void chkForecastIMPROVEAdvanced_Click(object sender, EventArgs e)
        {
            int height = this.Height;
            btnforecastIMPROVE.Visible = chkForecastIMPROVEAdvanced.Checked;
            txtforecastIMPROVE.Visible = chkForecastIMPROVEAdvanced.Checked;
            rbtnForecastIMPROVE.Visible = chkForecastIMPROVEAdvanced.Checked;
            rbtnCreateIMPROVE.Visible = chkForecastIMPROVEAdvanced.Checked;//����
           // txtNewIMPROVEAlgorithmInputVisi.Enabled = !chkForecastIMPROVEAdvanced.Checked;
          //  btnNewIMPROVEAlgorithmInputVisi.Enabled = !chkForecastIMPROVEAdvanced.Checked;
          //  chkCreateIMPROVEFile.Enabled = !chkForecastIMPROVEAdvanced.Checked;

           // rbtnCreateIMPROVE.Checked = !rbtnForecastIMPROVE.Checked && !chkForecastIMPROVEAdvanced;

        }

        private void chkCreateIMPROVEFile_Click(object sender, EventArgs e)
        {
           // chkForecastIMPROVEAdvanced.Enabled = !chkCreateIMPROVEFile.Checked;
            //chkForecastIMPROVEAdvanced.Checked = chkCreateIMPROVEFile.Checked;
           // chkForecast.Enabled = !chkCreateIMPROVEFile.Checked;
           // chkForecast.Checked = !chkCreateIMPROVEFile.Checked;

        }

        private void chkForecast_Click(object sender, EventArgs e)
        {
            //chkCreateIMPROVEFile.Enabled = !chkForecast.Checked;
           // chkCreateIMPROVEFile.Checked = !chkForecast.Checked;
        }

        private void rbtnCreateIMPROVE_Click(object sender, EventArgs e)
        {
            rbtnCreateIMPROVE.Checked = !rbtnForecastIMPROVE.Checked;
            txtNewIMPROVEAlgorithmInputVisi.Enabled = rbtnCreateIMPROVE.Checked;//���ٶ�
            btnNewIMPROVEAlgorithmInputVisi.Enabled = rbtnCreateIMPROVE.Checked;//���ٶ�
           // txtforecastIMPROVE.Enabled = !rbtnCreateIMPROVE.Checked;
          //  btnforecastIMPROVE.Enabled = !rbtnCreateIMPROVE.Checked;
            txtforecastIMPROVE.Enabled = false;
            btnforecastIMPROVE.Enabled = false;
        }

        private void chkForecastIMPROVEAdvanced_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (chkForecastIMPROVEAdvanced.Checked)
                {
                    this.Height = 542;
                }
                else
                {
                    // this.Height = 731;
                    this.Height = 445;
                    rbtnCreateIMPROVE.Checked = false;
                    rbtnForecastIMPROVE.Checked = false;
                    txtNewIMPROVEAlgorithmInputVisi.Enabled = true;
                    btnNewIMPROVEAlgorithmInputVisi.Enabled = true;

                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnForecastIMPROVE_Click(object sender, EventArgs e)
        {
            rbtnForecastIMPROVE.Checked = !rbtnCreateIMPROVE.Checked;
            txtNewIMPROVEAlgorithmInputVisi.Enabled = !rbtnForecastIMPROVE.Checked;//���ٶ�
            btnNewIMPROVEAlgorithmInputVisi.Enabled = !rbtnForecastIMPROVE.Checked;//���ٶ�
            //txtforecastIMPROVE.Enabled = rbtnForecastIMPROVE.Checked;
          //  btnforecastIMPROVE.Enabled = rbtnForecastIMPROVE.Checked;
            txtforecastIMPROVE.Enabled =true;
            btnforecastIMPROVE.Enabled = true;

        }

        private void rbtnCreateIMPROVE_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (rbtnCreateIMPROVE.Checked)
                {
                    txtforecastIMPROVE.Enabled = false;
                    btnforecastIMPROVE.Enabled = false;
                    txtNewIMPROVEAlgorithmInputVisi.Enabled = true;
                    btnNewIMPROVEAlgorithmInputVisi.Enabled = true;
                }
                else
                {
                    txtforecastIMPROVE.Enabled = true;
                    btnforecastIMPROVE.Enabled = true;
                    txtNewIMPROVEAlgorithmInputVisi.Enabled = false;
                    btnNewIMPROVEAlgorithmInputVisi.Enabled = false;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnForecastIMPROVE_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                //if (rbtnCreateIMPROVE.Checked)
                //{
                //   // txtforecastIMPROVE.Enabled = true;
                //  //  btnforecastIMPROVE.Enabled = true;
                //    txtNewIMPROVEAlgorithmInputVisi.Enabled = false;
                //    btnNewIMPROVEAlgorithmInputVisi.Enabled = false;
                //}
                //else
                //{
                //    txtforecastIMPROVE.Enabled = false;
                //    btnforecastIMPROVE.Enabled = false;
                //    txtNewIMPROVEAlgorithmInputVisi.Enabled = true;
                //    btnNewIMPROVEAlgorithmInputVisi.Enabled = true;
                //}
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }




    }
}
