using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Collections;
using DotSpatial.Data;
using System.Data;

namespace SMAT_CE
{
    class BatchCommonClass
    {
        public static bool OutPutBaseConfiguration(BaseConfiguration baseConfiguration, string strFile)
        {
            try
            {
                if (baseConfiguration is AnnualPMAnalysisConfiguration)
                {
                    OutPutBaseConfiguration(baseConfiguration as AnnualPMAnalysisConfiguration, strFile);
                }
                else if (baseConfiguration is DailyPMAnalysisConfiguration)
                {
                    OutPutBaseConfiguration(baseConfiguration as DailyPMAnalysisConfiguration, strFile);
                }
                else if (baseConfiguration is OzoneAnalysisConfiguration)
                {
                    OutPutBaseConfiguration(baseConfiguration as OzoneAnalysisConfiguration, strFile);
                }
                else if (baseConfiguration is VisibilityAnalysisConfiguration)
                {
                    OutPutBaseConfiguration(baseConfiguration as VisibilityAnalysisConfiguration, strFile);
                }
                else if (baseConfiguration is SSIAAnnualPMAnalysisConfiguration)
                {
                    OutPutBaseConfiguration(baseConfiguration as SSIAAnnualPMAnalysisConfiguration, strFile);
                }
                else if (baseConfiguration is SSIADailyPMAnalysisConfiguration)
                {
                    OutPutBaseConfiguration(baseConfiguration as SSIADailyPMAnalysisConfiguration, strFile);
                }
                else if (baseConfiguration is SSIAOzoneAnalysisConfiguration)
                {
                    OutPutBaseConfiguration(baseConfiguration as SSIAOzoneAnalysisConfiguration, strFile);
                }
                else if (baseConfiguration is SSIADepositionConfiguration)                           //added by Lijiabin
                {
                    OutPutBaseConfiguration(baseConfiguration as SSIADepositionConfiguration, strFile);
                }
                else if (baseConfiguration is AnnualPMAnalysisChinaConfiguration)
                {
                    OutPutBaseConfiguration(baseConfiguration as AnnualPMAnalysisChinaConfiguration, strFile);
                }
                else if (baseConfiguration is OzoneAnalysisChinaConfiguration)
                {
                    OutPutBaseConfiguration(baseConfiguration as OzoneAnalysisChinaConfiguration, strFile);
                }
                else if (baseConfiguration is BenMAPAnnualPMAnalysisConfiguration)
                {
                    OutPutBaseConfiguration(baseConfiguration as BenMAPAnnualPMAnalysisConfiguration, strFile);
                }
                else if (baseConfiguration is BenMAPOzoneAnalysisConfiguration)
                {
                    OutPutBaseConfiguration(baseConfiguration as BenMAPOzoneAnalysisConfiguration, strFile);
                }
            }
            catch
            {
                return false;
            }
            return true;
        }
        public static bool OutPutBaseConfiguration(BenMAPOzoneAnalysisConfiguration BenMAPOzoneAnalysisConfiguration, string strFile)
        {
            try
            {
                FileStream fs = new FileStream(strFile, FileMode.Create);
                StreamWriter sw = new StreamWriter(fs, Encoding.UTF8);
                sw.WriteLine("RunType=RunSSIAOzone");
                if (CommonClass.IsBatch)
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath);//CommonClass.ResultFilePath
                }
                else
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath + @"\Result\Output");
                }
                sw.WriteLine("OutputFileName=" + Path.GetFileName(CommonClass.ProjectName.Replace(".proj", ".cfg")));
                sw.WriteLine("scenarioName=" + BenMAPOzoneAnalysisConfiguration.modelInput.scenarioName.ToString());
                sw.WriteLine("doInputFromCmaq=" + (Convert.ToString(BenMAPOzoneAnalysisConfiguration.modelInput.doInputfromCmaq ? 1 : 0)));
                sw.WriteLine("baselineModelDataFile=" + BenMAPOzoneAnalysisConfiguration.modelInput.baselineModelDataFile.ToString());
                sw.WriteLine("alternativeModelDataFile=" + BenMAPOzoneAnalysisConfiguration.modelInput.forecastModelDataFile.ToString());

                sw.WriteLine("ozoneStartYear=" + BenMAPOzoneAnalysisConfiguration.monitorInput.ozoneStartYear.ToString());
                sw.WriteLine("ozoneEndYear=" + BenMAPOzoneAnalysisConfiguration.monitorInput.ozoneEndYear.ToString());
                sw.WriteLine("doVNA=" + Convert.ToString(BenMAPOzoneAnalysisConfiguration.monitorInput.useVNA ? 1 : 0));
                sw.WriteLine("doEVNA=" + Convert.ToString(BenMAPOzoneAnalysisConfiguration.monitorInput.useEVNA ? 1 : 0));
                sw.WriteLine("doEVNA=" + Convert.ToString(BenMAPOzoneAnalysisConfiguration.monitorInput.useEVNA ? 1 : 0));
                //sw.WriteLine("temporalAdjustmentAtMonitorGrid=" + BenMAPOzoneAnalysisConfiguration.monitorInput.temporalAdjustmentAtMonitorGrid.ToString());
                //sw.WriteLine("temporalAdjustmentType=" + BenMAPOzoneAnalysisConfiguration.monitorInput.temporalAdjustmentType.ToString());

                sw.WriteLine("gridDefinitionFile=" + BenMAPOzoneAnalysisConfiguration.gridDefinitionFile);
                sw.Flush();
                sw.Close();
                fs.Close();
            }
            catch
            {
                return false;
            }
            return true;
        }

        public static bool OutPutBaseConfiguration(BenMAPAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration, string strFile)
        {
            try
            {
                FileStream fs = new FileStream(strFile, FileMode.Create);
                StreamWriter sw = new StreamWriter(fs, Encoding.UTF8);
                sw.WriteLine("RunType=RunBenMAPAnnualPM");
                if (CommonClass.IsBatch)
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath);//CommonClass.ResultFilePath
                }
                else
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath + @"\Result\Output");
                }
                sw.WriteLine("OutputFileName=" + Path.GetFileName(CommonClass.ProjectName.Replace(".proj", ".cfg")));
                if (annualPMAnalysisConfiguration.modelInput.scenarioName.ToString() == Path.GetFileNameWithoutExtension(strFile))
                    sw.WriteLine("scenarioName=" + annualPMAnalysisConfiguration.modelInput.scenarioName.ToString());
                else
                    sw.WriteLine("scenarioName=" + Path.GetFileNameWithoutExtension(strFile));
                sw.WriteLine("doDailyModelDataInput=" + (Convert.ToString(annualPMAnalysisConfiguration.modelInput.doDailyModelData ? 1 : 0)));
                sw.WriteLine("doQuarterlyModelDataInput=" + (Convert.ToString(annualPMAnalysisConfiguration.modelInput.doQuarterlyModelData ? 1 : 0)));
                sw.WriteLine("doInputFromCmaq=" + (Convert.ToString(annualPMAnalysisConfiguration.modelInput.doInputfromCMAQ ? 1 : 0)));
                sw.WriteLine("baselineModelDataFile=" + annualPMAnalysisConfiguration.modelInput.baselineFile);
                sw.WriteLine("forecastModelDataFile=" + annualPMAnalysisConfiguration.modelInput.forecastFile);
                sw.WriteLine("temporalAdjustmentAtMonitorGridSpatial=" + annualPMAnalysisConfiguration.modelInput.temporalAdjustmentAtMonitorGridSpatial);
                sw.WriteLine("unofficialMonitorDataFile=" + annualPMAnalysisConfiguration.monitorInput.unofficialFile.ToString());
                sw.WriteLine("unofficialStartYear=" + annualPMAnalysisConfiguration.monitorInput.startYear);
                sw.WriteLine("unofficialEndYear=" + annualPMAnalysisConfiguration.monitorInput.endYear);
                sw.WriteLine("doVNA=" + (Convert.ToString(annualPMAnalysisConfiguration.monitorInput.useVNA ? 1 : 0)));
                sw.WriteLine("doEVNA=" + (Convert.ToString(annualPMAnalysisConfiguration.monitorInput.useEVNA ? 1 : 0)));
                sw.WriteLine("doSpeciesMonitorDataFile=" + (Convert.ToString(annualPMAnalysisConfiguration.speciesMonitorInput.doSpeciesMonitorDataFile ? 1 : 0)));
                sw.WriteLine("speciesMonitorDataFile=" + annualPMAnalysisConfiguration.speciesMonitorInput.speciesMonitorDataFile);
                sw.WriteLine("doSpeciesFractionFile=" + (Convert.ToString(annualPMAnalysisConfiguration.speciesMonitorInput.doSpeciesFractionFile ? 1 : 0)));
                sw.WriteLine("specFracSpatialFile=" + annualPMAnalysisConfiguration.speciesMonitorInput.specFracSpatialFile);
                sw.WriteLine("gradAdjSpecFracSpatialFile=" + annualPMAnalysisConfiguration.speciesMonitorInput.gradAdjSpecFracSpatialFile);
                sw.WriteLine("speciesStartYear=" + annualPMAnalysisConfiguration.speciesMonitorInput.startYear);
                sw.WriteLine("speciesEndYear=" + annualPMAnalysisConfiguration.speciesMonitorInput.endYear);
                sw.WriteLine("gridDefinitionFile=" + annualPMAnalysisConfiguration.gridDefinitionFile);
                sw.Flush();
                sw.Close();
                fs.Close();
            }
            catch
            {
                return false;
            }
            return true;
        }

        public static bool OutPutBaseConfiguration(OzoneAnalysisChinaConfiguration ozoneAnalysisConfiguration, string strFile)
        {
            try
            {
                FileStream fs = new FileStream(strFile, FileMode.Create);
                StreamWriter sw = new StreamWriter(fs, Encoding.UTF8);
                sw.WriteLine("RunType=RunOzoneChina");
                if (CommonClass.IsBatch)
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath);//CommonClass.ResultFilePath
                }
                else
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath + @"\Result\Output");
                }
                sw.WriteLine("OutputFileName=" + Path.GetFileName(CommonClass.ProjectName.Replace(".proj", ".cfg")));
                //sw.WriteLine("OutputFileName=" + Path.GetFullPath(strFile));
                if (ozoneAnalysisConfiguration.modelDataOzoneChina.scenarioName.ToString() == Path.GetFileNameWithoutExtension(strFile))
                    sw.WriteLine("scenarioName=" + ozoneAnalysisConfiguration.modelDataOzoneChina.scenarioName.ToString());
                else
                    sw.WriteLine("scenarioName=" + Path.GetFileNameWithoutExtension(strFile));
                sw.WriteLine("doInputfromCmaq=" + Convert.ToString(ozoneAnalysisConfiguration.modelDataOzoneChina.doInputfromCmaq ? 1 : 0));
                sw.WriteLine("baselineModelDataFile=" + ozoneAnalysisConfiguration.modelDataOzoneChina.baselineModelDataFile.ToString());
                sw.WriteLine("forecastModelDataFile=" + ozoneAnalysisConfiguration.modelDataOzoneChina.forecastModelDataFile.ToString());
                sw.WriteLine("ozoneMonitorDataFile=" + ozoneAnalysisConfiguration.monitorDataOzoneChina.ozoneMonitorDataFile.ToString());
                sw.WriteLine("ozoneStartYear=" + ozoneAnalysisConfiguration.monitorDataOzoneChina.ozoneStartYear.ToString());
                sw.WriteLine("ozoneEndYear=" + ozoneAnalysisConfiguration.monitorDataOzoneChina.ozoneEndYear.ToString());
                sw.WriteLine("doVNA=" + Convert.ToString(ozoneAnalysisConfiguration.monitorDataOzoneChina.useVNA ? 1 : 0));
                sw.WriteLine("doEVNA=" + Convert.ToString(ozoneAnalysisConfiguration.monitorDataOzoneChina.useEVNA ? 1 : 0));
                sw.Flush();
                sw.Close();
                fs.Close();
            }
            catch
            {
                return false;
            }
            return true;
        }

        public static bool OutPutBaseConfiguration(AnnualPMAnalysisChinaConfiguration annualPMAnalysisConfiguration, string strFile)
        {
            try
            {
                FileStream fs = new FileStream(strFile, FileMode.Create);
                StreamWriter sw = new StreamWriter(fs, Encoding.UTF8);
                sw.WriteLine("RunType=RunChinaAnnualPM");
                if (CommonClass.IsBatch)
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath);//CommonClass.ResultFilePath
                }
                else
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath + @"\Result\Output");
                }
                sw.WriteLine("OutputFileName=" + Path.GetFileName(CommonClass.ProjectName.Replace(".proj", ".cfg")));
                //sw.WriteLine("OutputFileName=" + Path.GetFullPath(strFile));
                //sw.WriteLine("scenarioName=" + annualPMAnalysisConfiguration.chooseDesiredOutputA.scenarioName.ToString());
                if (annualPMAnalysisConfiguration.modelDataInputChina.scenarioName.ToString() == Path.GetFileNameWithoutExtension(strFile))
                    sw.WriteLine("scenarioName=" + annualPMAnalysisConfiguration.modelDataInputChina.scenarioName.ToString());
                else
                    sw.WriteLine("scenarioName=" + Path.GetFileNameWithoutExtension(strFile));
                sw.WriteLine("doDailyModelDataInput=" + (Convert.ToString(annualPMAnalysisConfiguration.modelDataInputChina.doDailyAverageDataInput ? 1 : 0)));
                sw.WriteLine("doQuarterlyModelDataInput=" + (Convert.ToString(annualPMAnalysisConfiguration.modelDataInputChina.doQuarterlyAverageDataInput ? 1 : 0)));
                sw.WriteLine("doInputFromCmaq=" + (Convert.ToString(annualPMAnalysisConfiguration.modelDataInputChina.doInputFromCMAQ ? 1 : 0)));
                sw.WriteLine("baselineModelDataFile=" + annualPMAnalysisConfiguration.modelDataInputChina.BaselineModelDataFile.ToString());
                sw.WriteLine("forecastModelDataFile=" + annualPMAnalysisConfiguration.modelDataInputChina.ControlModelDataFile.ToString());
                sw.WriteLine("doDailyMonitorDataInput=" + (Convert.ToString(annualPMAnalysisConfiguration.monitorDataInputChina.doDailyMonitorDataInput ? 1 : 0)));
                sw.WriteLine("doQuarterlyMonitorDataInput=" + (Convert.ToString(annualPMAnalysisConfiguration.monitorDataInputChina.doQuarterlyMonitorDataInput ? 1 : 0)));
                sw.WriteLine("PMMonitorDataFile=" + annualPMAnalysisConfiguration.monitorDataInputChina.MonitorDataInputFile.ToString());
                sw.WriteLine("MonitorStartYear=" + annualPMAnalysisConfiguration.monitorDataInputChina.MonitorDataStartYear.ToString());
                sw.WriteLine("MonitorEndYear=" + annualPMAnalysisConfiguration.monitorDataInputChina.MonitorDataEndYear.ToString());
                sw.WriteLine("doVNA=" + (Convert.ToString(annualPMAnalysisConfiguration.monitorDataInputChina.doInterpolateFRM ? 1 : 0)));
                sw.WriteLine("doEVNA=" + (Convert.ToString(annualPMAnalysisConfiguration.monitorDataInputChina.doInterpolateAdjustedFRM ? 1 : 0)));
                sw.WriteLine("doSpeciesFraction=" + (Convert.ToString(annualPMAnalysisConfiguration.pm25SpeciesOptionChina.PM25SpeciesFractionDataAvailable ? 1 : 0)));
                sw.WriteLine("SpeciesMonitorDataFile=" + annualPMAnalysisConfiguration.pm25SpeciesOptionChina.SpeciesMonitorDataFile.ToString());
                sw.Flush();
                sw.Close();
                fs.Close();
            }
            catch
            {
                return false;
            }
            return true;
        }

        public static bool OutPutBaseConfiguration(SSIADepositionConfiguration depositionAnalysisConfiguration, string strFile)    //added by Lijiabin
        {
            try
            {
                FileStream fs = new FileStream(strFile, FileMode.Create);
                StreamWriter sw = new StreamWriter(fs, Encoding.UTF8);
                sw.WriteLine("RunType=RunSSIADeposition");
                if (CommonClass.IsBatch)
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath);//CommonClass.ResultFilePath
                }
                else
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath + @"\Result\Output");
                }
                sw.WriteLine("OutputFileName=" + Path.GetFileName(CommonClass.ProjectName.Replace(".proj", ".cfg")));
                if (depositionAnalysisConfiguration.analysisOptionDep.scenarioName.ToString() == Path.GetFileNameWithoutExtension(strFile))
                    sw.WriteLine("scenarioName=" + depositionAnalysisConfiguration.analysisOptionDep.scenarioName.ToString());
                else
                    sw.WriteLine("scenarioName=" + Path.GetFileNameWithoutExtension(strFile));
                sw.WriteLine("baselineModelDataFile=" + depositionAnalysisConfiguration.modelInputDep.baselineModelDataFile.ToString());
                sw.WriteLine("alternativeModelDataFile=" + depositionAnalysisConfiguration.modelInputDep.alternativeScenarioFile.ToString());
                //sw.WriteLine("NAAQS=" + depositionAnalysisConfiguration.calculationOption.NAAQS);
                sw.WriteLine("threshold=" + depositionAnalysisConfiguration.calculationOption.threshold);

                sw.Flush();
                sw.Close();
                fs.Close();
            }
            catch
            {
                return false;
            }
            return true;
        }
        public static bool OutPutBaseConfiguration(SSIAOzoneAnalysisConfiguration ozoneAnalysisConfiguration, string strFile)
        {
            try
            {
                FileStream fs = new FileStream(strFile, FileMode.Create);
                StreamWriter sw = new StreamWriter(fs, Encoding.UTF8);
                sw.WriteLine("RunType=RunSSIAOzone");
                if (CommonClass.IsBatch)
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath);//CommonClass.ResultFilePath
                }
                else
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath + @"\Result\Output");
                }
                sw.WriteLine("OutputFileName=" + Path.GetFileName(CommonClass.ProjectName.Replace(".proj", ".cfg")));
                if (ozoneAnalysisConfiguration.analysisOptionO.scenarioName.ToString() == Path.GetFileNameWithoutExtension(strFile))
                    sw.WriteLine("scenarioName=" + ozoneAnalysisConfiguration.analysisOptionO.scenarioName.ToString());
                else
                    sw.WriteLine("scenarioName=" + Path.GetFileNameWithoutExtension(strFile));
                sw.WriteLine("doCumulativeImpactAnalysis=" + (Convert.ToString(ozoneAnalysisConfiguration.analysisOptionO.useModelFRMData ? 1 : 0)));
                sw.WriteLine("doInputFromCmaq=" + (Convert.ToString(ozoneAnalysisConfiguration.modelInputO.doInputfromCmaq ? 1 : 0)));
                sw.WriteLine("baselineModelDataFile=" + ozoneAnalysisConfiguration.modelInputO.baselineModelDataFile.ToString());
                sw.WriteLine("alternativeModelDataFile=" + ozoneAnalysisConfiguration.modelInputO.forecastModelDataFile.ToString());
                if (ozoneAnalysisConfiguration.analysisOptionO.useModelFRMData)
                {
                    sw.WriteLine("monitorDataFile=" + ozoneAnalysisConfiguration.monitorInputO.ozoneMonitorDataFile);
                    sw.WriteLine("ozoneStartYear=" + ozoneAnalysisConfiguration.monitorInputO.ozoneStartYear.ToString());
                    sw.WriteLine("ozoneEndYear=" + ozoneAnalysisConfiguration.monitorInputO.ozoneEndYear.ToString());
                    sw.WriteLine("doVNA=" + Convert.ToString(ozoneAnalysisConfiguration.monitorInputO.useVNA ? 1 : 0));
                    sw.WriteLine("doEVNA=" + Convert.ToString(ozoneAnalysisConfiguration.monitorInputO.useEVNA ? 1 : 0));
                    sw.WriteLine("temporalAdjustmentAtMonitorGrid=" + ozoneAnalysisConfiguration.monitorInputO.temporalAdjustmentAtMonitorGrid.ToString());
                    sw.WriteLine("temporalAdjustmentType=" + ozoneAnalysisConfiguration.monitorInputO.temporalAdjustmentType.ToString());
                }
                sw.WriteLine("NAAQS=" + ozoneAnalysisConfiguration.calculationOption.NAAQS);
                sw.WriteLine("threshold=" + ozoneAnalysisConfiguration.calculationOption.threshold);
                sw.WriteLine("startPercentage=" + ozoneAnalysisConfiguration.calculationOption.startPercentage.ToString());
                sw.WriteLine("endPercentage=" + ozoneAnalysisConfiguration.calculationOption.endPercentage.ToString());

                sw.Flush();
                sw.Close();
                fs.Close();
            }
            catch
            {
                return false;
            }
            return true;
        }
        public static bool OutPutBaseConfiguration(SSIAAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration, string strFile)
        {
            try
            {
                FileStream fs = new FileStream(strFile, FileMode.Create);
                StreamWriter sw = new StreamWriter(fs, Encoding.UTF8);
                sw.WriteLine("RunType=RunSSIAAnnualPM");
                if (CommonClass.IsBatch)
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath);//CommonClass.ResultFilePath
                }
                else
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath + @"\Result\Output");
                }
                sw.WriteLine("OutputFileName=" + Path.GetFileName(CommonClass.ProjectName.Replace(".proj", ".cfg")));
                if (annualPMAnalysisConfiguration.analysisOptionA.scenarioName.ToString() == Path.GetFileNameWithoutExtension(strFile))
                    sw.WriteLine("scenarioName=" + annualPMAnalysisConfiguration.analysisOptionA.scenarioName.ToString());
                else
                    sw.WriteLine("scenarioName=" + Path.GetFileNameWithoutExtension(strFile));
                sw.WriteLine("doCumulativeImpactAnalysis=" + (Convert.ToString(annualPMAnalysisConfiguration.analysisOptionA.useModelFRMData ? 1 : 0)));
                sw.WriteLine("useGridAndDispersion=" + (Convert.ToString(annualPMAnalysisConfiguration.analysisOptionA.useGridAndDispersion ? 1 : 0)));
                sw.WriteLine("useGridOnly=" + (Convert.ToString(annualPMAnalysisConfiguration.analysisOptionA.useGridOnly ? 1 : 0)));
                sw.WriteLine("useDispersionOnly=" + (Convert.ToString(annualPMAnalysisConfiguration.analysisOptionA.useDispersionOnly ? 1 : 0)));
                sw.WriteLine("doDailyModelDataInput=" + (Convert.ToString(annualPMAnalysisConfiguration.modelInputA.DailyModelDataInput ? 1 : 0)));
                sw.WriteLine("doQuarterlyModelDataInput=" + (Convert.ToString(annualPMAnalysisConfiguration.modelInputA.QuarterlyModelDataInput ? 1 : 0)));
                //sw.WriteLine("doInputFromCmaq=" + (Convert.ToString(annualPMAnalysisConfiguration.modelInputA.InputFromCMAQ ? 1 : 0)));
                if (annualPMAnalysisConfiguration.analysisOptionA.useGridOnly)
                {
                    sw.WriteLine("baselineModelDataFile=" + annualPMAnalysisConfiguration.modelInputA.baselineModelDataFile.ToString());
                    sw.WriteLine("alternativeModelDataFile=" + annualPMAnalysisConfiguration.modelInputA.alternativeScenarioFile.ToString());
                    sw.WriteLine("dispersionFile=");
                }
                else if (annualPMAnalysisConfiguration.analysisOptionA.useGridAndDispersion)
                {
                    sw.WriteLine("baselineModelDataFile=" + annualPMAnalysisConfiguration.modelInputA.baselineModelDataFile.ToString());
                    sw.WriteLine("alternativeModelDataFile=" + annualPMAnalysisConfiguration.modelInputA.alternativeScenarioFile.ToString());
                    sw.WriteLine("dispersionFile=" + annualPMAnalysisConfiguration.modelInputA.dispersionFile.ToString());
                }
                else if (annualPMAnalysisConfiguration.analysisOptionA.useDispersionOnly)
                {
                    sw.WriteLine("baselineModelDataFile=");
                    sw.WriteLine("alternativeModelDataFile=");
                    sw.WriteLine("dispersionFile=" + annualPMAnalysisConfiguration.modelInputA.dispersionFile.ToString());
                }
                if (annualPMAnalysisConfiguration.analysisOptionA.useModelFRMData)
                {
                    sw.WriteLine("officialDataFile=" + annualPMAnalysisConfiguration.monitorInputA.officialMonitorDataFile);
                    sw.WriteLine("officialPM25StartYear=" + annualPMAnalysisConfiguration.monitorInputA.monitorDataStartYear.ToString());
                    sw.WriteLine("officialPM25EndYear=" + annualPMAnalysisConfiguration.monitorInputA.monitorDataEndYear.ToString());
                    sw.WriteLine("doVNA=" + Convert.ToString(annualPMAnalysisConfiguration.monitorInputA.useVNA ? 1 : 0));
                    sw.WriteLine("doEVNA=" + Convert.ToString(annualPMAnalysisConfiguration.monitorInputA.useEVNA ? 1 : 0));
                    sw.WriteLine("temporalAdjustmentAtMonitorGrid=" + annualPMAnalysisConfiguration.monitorInputA.temporalAdjustmentAtMonitorGrid.ToString());
                }
                sw.WriteLine("NAAQS=" + annualPMAnalysisConfiguration.calculationOption.NAAQS);
                sw.WriteLine("threshold=" + annualPMAnalysisConfiguration.calculationOption.threshold);
                sw.WriteLine("startPercentage=" + annualPMAnalysisConfiguration.calculationOption.startPercentage.ToString());
                sw.WriteLine("endPercentage=" + annualPMAnalysisConfiguration.calculationOption.endPercentage.ToString());
                sw.Flush();
                sw.Close();
                fs.Close();
            }
            catch
            {
                return false;
            }
            return true;
        }
        public static bool OutPutBaseConfiguration(SSIADailyPMAnalysisConfiguration dailyPMAnalysisConfiguration, string strFile)
        {
            try
            {
                FileStream fs = new FileStream(strFile, FileMode.Create);
                StreamWriter sw = new StreamWriter(fs, Encoding.UTF8);
                sw.WriteLine("RunType=RunSSIADailyPM");
                if (CommonClass.IsBatch)
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath);//CommonClass.ResultFilePath
                }
                else
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath + @"\Result\Output");
                }
                sw.WriteLine("OutputFileName=" + Path.GetFileName(CommonClass.ProjectName.Replace(".proj", ".cfg")));
                if (dailyPMAnalysisConfiguration.analysisOptionD.scenarioName.ToString() == Path.GetFileNameWithoutExtension(strFile))
                    sw.WriteLine("scenarioName=" + dailyPMAnalysisConfiguration.analysisOptionD.scenarioName.ToString());
                else
                    sw.WriteLine("scenarioName=" + Path.GetFileNameWithoutExtension(strFile));
                sw.WriteLine("doCumulativeImpactAnalysis=" + (Convert.ToString(dailyPMAnalysisConfiguration.analysisOptionD.useModelFRMData ? 1 : 0)));
                sw.WriteLine("doDailyModelDataInput=" + (Convert.ToString(dailyPMAnalysisConfiguration.modelInputD.DailyModelDataInput ? 1 : 0)));
                sw.WriteLine("doQuarterlyModelDataInput=" + (Convert.ToString(dailyPMAnalysisConfiguration.modelInputD.QuarterlyModelDataInput ? 1 : 0)));
                //sw.WriteLine("doInputFromCmaq=" + (Convert.ToString(dailyPMAnalysisConfiguration.modelInputD.InputFromCMAQ ? 1 : 0)));
                if (dailyPMAnalysisConfiguration.analysisOptionD.useGridOnly)
                {
                    sw.WriteLine("useGridOnly=1");
                    sw.WriteLine("useGridAndDispersion=0");
                    sw.WriteLine("useDispersionOnly=0");
                    sw.WriteLine("baselineModelDataFile=" + dailyPMAnalysisConfiguration.modelInputD.baselineModelDataFile.ToString());
                    sw.WriteLine("alternativeModelDataFile=" + dailyPMAnalysisConfiguration.modelInputD.alternativeScenarioFile.ToString());
                    sw.WriteLine("dispersionFile=");
                }
                else if (dailyPMAnalysisConfiguration.analysisOptionD.useGridAndDispersion)
                {
                    sw.WriteLine("useGridOnly=0");
                    sw.WriteLine("useGridAndDispersion=1");
                    sw.WriteLine("useDispersionOnly=0");
                    sw.WriteLine("baselineModelDataFile=" + dailyPMAnalysisConfiguration.modelInputD.baselineModelDataFile.ToString());
                    sw.WriteLine("alternativeModelDataFile=" + dailyPMAnalysisConfiguration.modelInputD.alternativeScenarioFile.ToString());
                    sw.WriteLine("dispersionFile=" + dailyPMAnalysisConfiguration.modelInputD.dispersionFile.ToString());
                }
                else if (dailyPMAnalysisConfiguration.analysisOptionD.useDispersionOnly)
                {
                    sw.WriteLine("useGridOnly=0");
                    sw.WriteLine("useGridAndDispersion=0");
                    sw.WriteLine("useDispersionOnly=1");
                    sw.WriteLine("baselineModelDataFile=");
                    sw.WriteLine("alternativeModelDataFile=");
                    sw.WriteLine("dispersionFile=" + dailyPMAnalysisConfiguration.modelInputD.dispersionFile.ToString());
                }
                if (dailyPMAnalysisConfiguration.analysisOptionD.useModelFRMData)
                {
                    sw.WriteLine("officialDataFile=" + dailyPMAnalysisConfiguration.monitorInputD.officialMonitorDataFile);
                    sw.WriteLine("officialPM25StartYear=" + dailyPMAnalysisConfiguration.monitorInputD.monitorDataStartYear.ToString());
                    sw.WriteLine("officialPM25EndYear=" + dailyPMAnalysisConfiguration.monitorInputD.monitorDataEndYear.ToString());
                }
                sw.WriteLine("doVNA=" + Convert.ToString(dailyPMAnalysisConfiguration.monitorInputD.useVNA ? 1 : 0));
                sw.WriteLine("doEVNA=" + Convert.ToString(dailyPMAnalysisConfiguration.monitorInputD.useEVNA ? 1 : 0));
                //sw.WriteLine("temporalAdjustmentAtMonitorGridPoint=" + dailyPMAnalysisConfiguration.modelInputD.temporalAdjustmentAtMonitorGridPoint.ToString());
                //sw.WriteLine("temporalAdjustmentAtMonitorGridSpatial=" + dailyPMAnalysisConfiguration.modelInputD.temporalAdjustmentAtMonitorGridSpatial.ToString());
                //sw.WriteLine("temporalAdjustmentType=" + dailyPMAnalysisConfiguration.modelInputD.temporalAdjustmentType.ToString());
                //sw.WriteLine("RRF_DoUseXTopPercent=" + (Convert.ToString(dailyPMAnalysisConfiguration.modelInputD.RRF_DoUseXTopPercent ? 1 : 0)));
                //sw.WriteLine("RRF_DoUseTopXNumber=" + (Convert.ToString(dailyPMAnalysisConfiguration.modelInputD.RRF_DoUseTopXNumber ? 1 : 0)));
                //sw.WriteLine("RRF_DoUseAllModelDaysGreaterThan=" + (Convert.ToString(dailyPMAnalysisConfiguration.modelInputD.RRF_DoUseAllModelDaysGreaterThan ? 1 : 0)));
                //sw.WriteLine("RRF_MinumumNumberOfDaysRequiredAboveFixedAmount=" + (Convert.ToString(dailyPMAnalysisConfiguration.modelInputD.RRF_MinumumNumberOfDaysRequiredAboveFixedAmount)));
                //sw.WriteLine("RRF_UseAllModelDaysGreaterThan=" + (Convert.ToString(dailyPMAnalysisConfiguration.modelInputD.RRF_UseAllModelDaysGreaterThan)));
                //sw.WriteLine("RRF_UseXTopPercent=" + (Convert.ToString(dailyPMAnalysisConfiguration.modelInputD.RRF_UseXTopPercent)));
                //sw.WriteLine("RRF_UseTopXNumber=" + (Convert.ToString(dailyPMAnalysisConfiguration.modelInputD.RRF_UseTopXNumber)));
                sw.WriteLine("NAAQS=" + dailyPMAnalysisConfiguration.calculationOption.NAAQS);
                sw.WriteLine("threshold=" + dailyPMAnalysisConfiguration.calculationOption.threshold);
                sw.WriteLine("startPercentage=" + dailyPMAnalysisConfiguration.calculationOption.startPercentage.ToString());
                sw.WriteLine("endPercentage=" + dailyPMAnalysisConfiguration.calculationOption.endPercentage.ToString());

                sw.Flush();
                sw.Close();
                fs.Close();
            }
            catch
            {
                return false;
            }
            return true;
        }
        public static bool OutPutBaseConfiguration(AnnualPMAnalysisConfiguration annualPMAnalysisConfiguration, string strFile)
        {
            try
            {
                FileStream fs = new FileStream(strFile, FileMode.Create);
                StreamWriter sw = new StreamWriter(fs, Encoding.UTF8);
                sw.WriteLine("RunType=RunPM25Quarterly");
                if (CommonClass.IsBatch)
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath);//CommonClass.ResultFilePath
                }
                else
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath + @"\Result\Output");
                }
                sw.WriteLine("OutputFileName=" + Path.GetFileName(CommonClass.ProjectName.Replace(".proj", ".cfg")));
                //sw.WriteLine("OutputFileName=" + Path.GetFullPath(strFile));
                //sw.WriteLine("scenarioName=" + annualPMAnalysisConfiguration.chooseDesiredOutputA.scenarioName.ToString());
                if (annualPMAnalysisConfiguration.chooseDesiredOutputA.scenarioName.ToString() == Path.GetFileNameWithoutExtension(strFile))
                    sw.WriteLine("scenarioName=" + annualPMAnalysisConfiguration.chooseDesiredOutputA.scenarioName.ToString());
                else
                    sw.WriteLine("scenarioName=" + Path.GetFileNameWithoutExtension(strFile));
                sw.WriteLine("doStandardAnalysis=" + (Convert.ToString(annualPMAnalysisConfiguration.chooseDesiredOutputA.doStandardAnalysis ? 1 : 0)));
                sw.WriteLine("doQuarterlyModelData=" + (Convert.ToString(annualPMAnalysisConfiguration.chooseDesiredOutputA.doQuarterlyModelData ? 1 : 0)));
                sw.WriteLine("doUsedQuarterlyAvgModelData=" + (Convert.ToString(annualPMAnalysisConfiguration.chooseDesiredOutputA.doUsedQuarterlyAvgModelData ? 1 : 0)));
                sw.WriteLine("doSpeciesFraction=" + (Convert.ToString(annualPMAnalysisConfiguration.chooseDesiredOutputA.doSpeciesFraction ? 1 : 0)));
                sw.WriteLine("doAutomaticallyExtract=" + (Convert.ToString(annualPMAnalysisConfiguration.chooseDesiredOutputA.doAutomaticallyExtract ? 1 : 0)));
                sw.WriteLine("doInterpolatedSFETempAdj=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doInterpolatedSFETempAdj ? 1 : 0)));
                sw.WriteLine("doBaseOnlyVNA=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doBaseOnlyVNA ? 1 : 0)));
                sw.WriteLine("doFutureOnlyVNA=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doFutureOnlyVNA ? 1 : 0)));
                sw.WriteLine("doInterpolatedSFETempAdj_GradAdj=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doInterpolatedSFETempAdj_GradAdj ? 1 : 0)));
                sw.WriteLine("doBaseOnlyEvna=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doBaseOnlyEvna ? 1 : 0)));
                sw.WriteLine("doFutureOnlyEvna=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doFutureOnlyEvna ? 1 : 0)));
                sw.WriteLine("doQuarterlyAvgFilePoint=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doQuarterlyAvgFilePoint ? 1 : 0)));
                sw.WriteLine("doQuarterlyAvgFileSpatial=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doQuarterlyAvgFileSpatial ? 1 : 0)));
                sw.WriteLine("doQuarterlyAvgFileSpatial_GraAdj=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doQuarterlyAvgFileSpatial_GraAdj ? 1 : 0)));
                sw.WriteLine("doHighCountySites=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doHighCountySites ? 1 : 0)));
                sw.WriteLine("doSpeciesFractionSpatial=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doSpeciesFractionSpatial ? 1 : 0)));
                sw.WriteLine("doSpeciesFractionSpatial_GraAdj=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doSpeciesFractionSpatial_GraAdj ? 1 : 0)));
                sw.WriteLine("doQuarterlyAvgSpeciatedMonitors=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doQuarterlyAvgSpeciatedMonitors ? 1 : 0)));
                sw.WriteLine("doDesignValuePeriods=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doDesignValuePeriods ? 1 : 0)));
                sw.WriteLine("doNeighborFilePoint=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFilePoint ? 1 : 0)));
                sw.WriteLine("doNeighborFileSpatial=" + (Convert.ToString(annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFileSpatial ? 1 : 0)));
                sw.WriteLine("doSpeciesMonitorDataFile=" + (Convert.ToString(annualPMAnalysisConfiguration.dataInputA.doSpeciesMonitorDataFile ? 1 : 0)));
                sw.WriteLine("speciesMonitorDataFile=" + annualPMAnalysisConfiguration.dataInputA.speciesMonitorDataFile.ToString());
                sw.WriteLine("doSpeciesFractionFile=" + (Convert.ToString(annualPMAnalysisConfiguration.dataInputA.doSpeciesFractionFile ? 1 : 0)));
                sw.WriteLine("specFracModePoint=" + annualPMAnalysisConfiguration.dataInputA.specFracModePoint.ToString());
                sw.WriteLine("specFracPointFile=" + annualPMAnalysisConfiguration.dataInputA.specFracPointFile.ToString());
                sw.WriteLine("specFracModeSpatial=" + annualPMAnalysisConfiguration.dataInputA.specFracModeSpatial.ToString());
                sw.WriteLine("specFracSpatialFile=" + annualPMAnalysisConfiguration.dataInputA.specFracSpatialFile.ToString());
                sw.WriteLine("unofficialMonitorDataFile=" + annualPMAnalysisConfiguration.dataInputA.unofficialMonitorDataFile.ToString());
                sw.WriteLine("officialMonitorDataFile=" + annualPMAnalysisConfiguration.dataInputA.officialMonitorDataFile.ToString());
                sw.WriteLine("doDailyModelDataInput=" + (Convert.ToString(annualPMAnalysisConfiguration.dataInputA.doDailyModelDataInput ? 1 : 0)));
                sw.WriteLine("doQuarterlyModelDataInput=" + (Convert.ToString(annualPMAnalysisConfiguration.dataInputA.doQuarterlyModelDataInput ? 1 : 0)));
                sw.WriteLine("doInputFromCmaq=" + (Convert.ToString(annualPMAnalysisConfiguration.dataInputA.doInputFromCmaq ? 1 : 0)));
                sw.WriteLine("baselineModelDataFile=" + annualPMAnalysisConfiguration.dataInputA.baselineModelDataFile.ToString());
                sw.WriteLine("forecastModelDataFile=" + annualPMAnalysisConfiguration.dataInputA.forecastModelDataFile.ToString());
                sw.WriteLine("IMPROVESTN_StartYear=" + annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_StartYear.ToString());
                sw.WriteLine("IMPROVESTN_EndYear=" + annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_EndYear.ToString());
                sw.WriteLine("IMPROVESTN_EPADeletionChoice=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_EPADeletionChoice ? 1 : 0));
                sw.WriteLine("IMPROVESTN_UserDeletionChoice=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_UserDeletionChoice ? 1 : 0));
                sw.WriteLine("IMPROVESTN_MinDays=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_MinDays));
                sw.WriteLine("IMPROVESTN_MinYear=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_MinYear));
                sw.WriteLine("IMPROVESTN_MinSeasons=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_MinSeasons));
                sw.WriteLine("unofficialStartYear=" + annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialStartYear.ToString());
                sw.WriteLine("unofficialEndYear=" + annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialEndYear.ToString());
                sw.WriteLine("unofficialEPADeletionChoice=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialEPADeletionChoice ? 1 : 0));
                sw.WriteLine("unofficialUserDeletionChoice=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialUserDeletionChoice ? 1 : 0));
                sw.WriteLine("unofficialMinDays=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialMinDays));
                sw.WriteLine("unofficialMinYears=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialMinYears));
                sw.WriteLine("unofficialMinSeasonsPoint=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialMinSeasonsPoint));
                sw.WriteLine("unofficialMinSeasonsSpatial=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialMinSeasonsSpatial));
                sw.WriteLine("doAdvancedOptionsForSpeciesFraction=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.doAdvancedOptionsForSpeciesFraction ? 1 : 0));
                sw.WriteLine("interpolationMethodPM25=" + annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodPM25.ToString());
                sw.WriteLine("distancePM25=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.distancePM25));
                sw.WriteLine("interpolationMethodSO4=" + annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodPM25.ToString());
                sw.WriteLine("distanceSO4=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceSO4));
                sw.WriteLine("interpolationMethodNO3=" + annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodSO4.ToString());
                sw.WriteLine("distanceNO3=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.distancePM25));
                sw.WriteLine("interpolationMethodEC=" + annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodEC.ToString());
                sw.WriteLine("distanceEC=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceEC));
                sw.WriteLine("interpolationMethodSalt=" + annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodSalt.ToString());
                sw.WriteLine("distanceSalt=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceSalt));
                sw.WriteLine("interpolationMethodCrustal=" + annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodCrustal.ToString());
                sw.WriteLine("distanceCrustal=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceCrustal));
                sw.WriteLine("interpolationMethodDON=" + annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodDON.ToString());
                sw.WriteLine("distanceDON=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceDON));
                sw.WriteLine("interpolationMethodOC=" + annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodOC.ToString());
                sw.WriteLine("distanceOC=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceOC));
                sw.WriteLine("interpolationMethodNH4=" + annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodNH4.ToString());
                sw.WriteLine("distanceNH4=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceNH4));
                sw.WriteLine("doUseDonValues=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.doUseDonValues ? 1 : 0));
                sw.WriteLine("doUseAmmoniumValues=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.doUseAmmoniumValues ? 1 : 0));
                sw.WriteLine("nh4PercentageEvaporating=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.nh4PercentageEvaporating));
                sw.WriteLine("defaultBlankMass=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.defaultBlankMass));
                sw.WriteLine("floorOCMMB=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.floorOCMMB));
                sw.WriteLine("ceilingOCMMB=" + Convert.ToString(annualPMAnalysisConfiguration.speciesFractionOptionsA.ceilingOCMMB));
                sw.WriteLine("officialPM25StartYear=" + annualPMAnalysisConfiguration.pm25CalculationOptionsA.officialPM25StartYear.ToString());
                sw.WriteLine("officialPM25EndYear=" + annualPMAnalysisConfiguration.pm25CalculationOptionsA.officialPM25EndYear.ToString());
                sw.WriteLine("choiceOfficialDV=" + Convert.ToString(annualPMAnalysisConfiguration.pm25CalculationOptionsA.choiceOfficialDV ? 1 : 0));
                sw.WriteLine("choiceCustomDV=" + Convert.ToString(annualPMAnalysisConfiguration.pm25CalculationOptionsA.choiceCustomDV ? 1 : 0));
                sw.WriteLine("minDaysForValidFRMQuarters=" + Convert.ToString(annualPMAnalysisConfiguration.pm25CalculationOptionsA.minDaysForValidFRMQuarters));
                sw.WriteLine("minQuartersForValidFRMDesignValues=" + Convert.ToString(annualPMAnalysisConfiguration.pm25CalculationOptionsA.minQuartersForValidFRMDesignValues));
                sw.WriteLine("minNumDVPeriodsForValidFRMMonitors=" + Convert.ToString(annualPMAnalysisConfiguration.pm25CalculationOptionsA.minNumDVPeriodsForValidFRMMonitors));
                sw.WriteLine("requiredDVPeriodsForValidFRMMonitors=" + annualPMAnalysisConfiguration.pm25CalculationOptionsA.requiredDVPeriodsForValidFRMMonitors.ToString());
                sw.WriteLine("doCalcNH4fromDON=" + Convert.ToString(annualPMAnalysisConfiguration.pm25CalculationOptionsA.doCalcNH4fromDON ? 1 : 0));
                sw.WriteLine("doCalcNH4fromRRF=" + Convert.ToString(annualPMAnalysisConfiguration.pm25CalculationOptionsA.doCalcNH4fromRRF ? 1 : 0));
                sw.WriteLine("temporalAdjustmentAtMonitorGrid=" + annualPMAnalysisConfiguration.modelDataOptionsA.temporalAdjustmentAtMonitorGrid.ToString());
                sw.WriteLine("temporalAdjustmentAtMonitorGridSpatial=" + annualPMAnalysisConfiguration.modelDataOptionsA.temporalAdjustmentAtMonitorGridSpatial.ToString());
                sw.Flush();
                sw.Close();
                fs.Close();
            }
            catch
            {
                return false;
            }
            return true;
        }
        public static bool OutPutBaseConfiguration(DailyPMAnalysisConfiguration dailyPMAnalysisConfiguration, string strFile)
        {
            try
            {
                FileStream fs = new FileStream(strFile, FileMode.Create);
                StreamWriter sw = new StreamWriter(fs, Encoding.UTF8);
                sw.WriteLine("RunType=RunPM25Daily");
                if (CommonClass.IsBatch)
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath);//CommonClass.ResultFilePath
                }
                else
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath + @"\Result\Output");
                }
                sw.WriteLine("OutputFileName=" + Path.GetFileName(CommonClass.ProjectName.Replace(".proj", ".cfg")));
                //sw.WriteLine("OutputFileName=" + Path.GetFullPath(strFile));
                //sw.WriteLine("scenarioName=" + dailyPMAnalysisConfiguration.chooseDesiredOutputD.scenarioName.ToString());
                if (dailyPMAnalysisConfiguration.chooseDesiredOutputD.scenarioName.ToString() == Path.GetFileNameWithoutExtension(strFile))
                    sw.WriteLine("scenarioName=" + dailyPMAnalysisConfiguration.chooseDesiredOutputD.scenarioName.ToString());
                else
                    sw.WriteLine("scenarioName=" + Path.GetFileNameWithoutExtension(strFile));
                sw.WriteLine("doStandardAnalysis=" + Convert.ToString(dailyPMAnalysisConfiguration.chooseDesiredOutputD.doStandardAnalysis ? 1 : 0));
                sw.WriteLine("doQuarterlyPeakModelData=" + Convert.ToString(dailyPMAnalysisConfiguration.chooseDesiredOutputD.doQuarterlyPeakModelData ? 1 : 0));
                sw.WriteLine("doSpeciesFraction=" + Convert.ToString(dailyPMAnalysisConfiguration.chooseDesiredOutputD.doSpeciesFraction ? 1 : 0));
                sw.WriteLine("doAutomaticallyExtract=" + Convert.ToString(dailyPMAnalysisConfiguration.chooseDesiredOutputD.doAutomaticallyExtract ? 1 : 0));
                sw.WriteLine("doQuarterlyPeakFilesPoint=" + Convert.ToString(dailyPMAnalysisConfiguration.outputChoiceAdvancedD.doQuarterlyPeakFilesPoint ? 1 : 0));
                sw.WriteLine("doHighCountySites=" + Convert.ToString(dailyPMAnalysisConfiguration.outputChoiceAdvancedD.doHighCountySites ? 1 : 0));
                sw.WriteLine("doQuarterlyPeakSpeciatedMonitors=" + Convert.ToString(dailyPMAnalysisConfiguration.outputChoiceAdvancedD.doQuarterlyPeakSpeciatedMonitors ? 1 : 0));
                sw.WriteLine("doDesignValuePeriods=" + Convert.ToString(dailyPMAnalysisConfiguration.outputChoiceAdvancedD.doDesignValuePeriods ? 1 : 0));
                sw.WriteLine("doNeighborFilePoint=" + Convert.ToString(dailyPMAnalysisConfiguration.outputChoiceAdvancedD.doNeighborFilePoint ? 1 : 0));
                sw.WriteLine("doSpeciesMonitorDataFile=" + Convert.ToString(dailyPMAnalysisConfiguration.dataInputD.doSpeciesMonitorDataFile ? 1 : 0));
                sw.WriteLine("speciesMonitorDataFile=" + dailyPMAnalysisConfiguration.dataInputD.speciesMonitorDataFile.ToString());
                sw.WriteLine("doSpeciesFractionFile=" + Convert.ToString(dailyPMAnalysisConfiguration.dataInputD.doSpeciesFractionFile ? 1 : 0));
                sw.WriteLine("specFracModePoint=" + dailyPMAnalysisConfiguration.dataInputD.specFracModePoint.ToString());
                sw.WriteLine("specFracPointFile=" + dailyPMAnalysisConfiguration.dataInputD.specFracPointFile.ToString());
                sw.WriteLine("specFracModeSpatial=" + dailyPMAnalysisConfiguration.dataInputD.specFracModeSpatial.ToString());
                sw.WriteLine("specFracSpatialFile=" + dailyPMAnalysisConfiguration.dataInputD.specFracSpatialFile.ToString());
                sw.WriteLine("unofficialMonitorFile=" + dailyPMAnalysisConfiguration.dataInputD.unofficialMonitorFile.ToString());
                sw.WriteLine("officialMonitorFile=" + dailyPMAnalysisConfiguration.dataInputD.officialMonitorFile.ToString());
                sw.WriteLine("doDailyModelDataInput=" + Convert.ToString(dailyPMAnalysisConfiguration.dataInputD.doDailyModelDataInput ? 1 : 0));
                sw.WriteLine("doQuarterlyPeakModelDataInput=" + Convert.ToString(dailyPMAnalysisConfiguration.dataInputD.doQuarterlyPeakModelDataInput ? 1 : 0));
                sw.WriteLine("doInputfromCmaq=" + Convert.ToString(dailyPMAnalysisConfiguration.dataInputD.doInputfromCmaq ? 1 : 0));
                sw.WriteLine("baselineModelFile=" + dailyPMAnalysisConfiguration.dataInputD.baselineModelFile.ToString());
                sw.WriteLine("forecastModelFile=" + dailyPMAnalysisConfiguration.dataInputD.forecastModelFile.ToString());
                sw.WriteLine("IMPROVE_StartYear=" + dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_StartYear.ToString());
                sw.WriteLine("IMPROVE_EndYear=" + dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_EndYear.ToString());
                sw.WriteLine("IMPROVE_EPADeletionChoice=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_EPADeletionChoice ? 1 : 0));
                sw.WriteLine("IMPROVE_UserDeletionChoice=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_UserDeletionChoice ? 1 : 0));
                sw.WriteLine("IMPROVE_MinDays=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_MinDays));
                sw.WriteLine("IMPROVE_MinQuarters=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_MinQuarters));
                sw.WriteLine("IMPROVE_MinYear=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_MinYear));
                sw.WriteLine("unofficialStartYear=" + dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialStartYear.ToString());
                sw.WriteLine("unofficialEndYear=" + dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialEndYear.ToString());
                sw.WriteLine("unofficialEPADeletionChoice=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialEPADeletionChoice ? 1 : 0));
                sw.WriteLine("unofficialUserDeletionChoice=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialUserDeletionChoice ? 1 : 0));
                sw.WriteLine("unofficialMinDays=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialMinDays));
                sw.WriteLine("unofficialMinQuartersPoint=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialMinQuartersPoint));
                sw.WriteLine("unofficialMinYears=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_MinYear));
                sw.WriteLine("IMPROVESTN_DoTopXPercent=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVESTN_DoTopXPercent ? 1 : 0));
                sw.WriteLine("IMPROVESTN_TopXPercent=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVESTN_TopXPercent));
                sw.WriteLine("IMPROVESTN_DoUseAlldailyMonitorValuesGreaterThan=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVESTN_DoUseAlldailyMonitorValuesGreaterThan ? 1 : 0));
                sw.WriteLine("IMPROVESTN_UseAlldailyMonitorValuesGreaterThan=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVESTN_UseAlldailyMonitorValuesGreaterThan));
                sw.WriteLine("IMPROVESTN_MinumumNumberOfDaysRequiredAboveFixedAmount=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVESTN_MinumumNumberOfDaysRequiredAboveFixedAmount));
                sw.WriteLine("IMPROVESTN_DoUseTopXNumber=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVESTN_DoUseTopXNumber ? 1 : 0));
                sw.WriteLine("IMPROVESTN_UseTopXNumber=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVESTN_UseTopXNumber));
                sw.WriteLine("unofficialPM25_DoTopXPercent=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialPM25_DoTopXPercent ? 1 : 0));
                sw.WriteLine("unofficialPM25_TopXPercent=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialPM25_TopXPercent));
                sw.WriteLine("unofficialPM25_DoUseAlldailyMonitorValuesGreaterThan=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialPM25_DoUseAlldailyMonitorValuesGreaterThan ? 1 : 0));
                sw.WriteLine("unofficialPM25_UseAlldailyMonitorValuesGreaterThan=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialPM25_UseAlldailyMonitorValuesGreaterThan));
                sw.WriteLine("unofficialPM25_MinumumNumberOfDaysRequiredAboveFixedAmount=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialPM25_MinumumNumberOfDaysRequiredAboveFixedAmount));
                sw.WriteLine("unofficialPM25_DoTopXNumber=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialPM25_DoTopXNumber ? 1 : 0));
                sw.WriteLine("unofficialPM25_TopXNumber=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialPM25_TopXNumber));
                sw.WriteLine("interpolationMethodPM25=" + dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodPM25.ToString());
                sw.WriteLine("distancePM25=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.distancePM25));
                sw.WriteLine("interpolationMethodSO4=" + dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodSO4.ToString());
                sw.WriteLine("distanceSO4=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceSO4));
                sw.WriteLine("interpolationMethodNO3=" + dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodNO3.ToString());
                sw.WriteLine("distanceNO3=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceNO3));
                sw.WriteLine("interpolationMethodEC=" + dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodEC.ToString());
                sw.WriteLine("distanceEC=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceEC));
                sw.WriteLine("interpolationMethodSalt=" + dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodSalt.ToString());
                sw.WriteLine("distanceSalt=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceSalt));
                sw.WriteLine("interpolationMethodCrustal=" + dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodCrustal.ToString());
                sw.WriteLine("distanceCrustal=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceCrustal));
                sw.WriteLine("interpolationMethodDON=" + dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodDON.ToString());
                sw.WriteLine("distanceDON=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceDON));
                sw.WriteLine("interpolationMethodOC=" + dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodOC.ToString());
                sw.WriteLine("distanceOC=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceOC));
                sw.WriteLine("interpolationMethodNH4=" + dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodNH4.ToString());
                sw.WriteLine("distanceNH4=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceNH4));
                sw.WriteLine("doUseDonValues=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.doUseDonValues ? 1 : 0));
                sw.WriteLine("doUseMeasuredAmmonium=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.doUseMeasuredAmmonium ? 1 : 0));
                sw.WriteLine("nh4PercentageEvaporating=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.nh4PercentageEvaporating));
                sw.WriteLine("defaultBlankMass=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.defaultBlankMass));
                sw.WriteLine("floorOCMMB=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.floorOCMMB));
                sw.WriteLine("ceilingOCMMB=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.ceilingOCMMB));
                sw.WriteLine("doAdvancedOptionsForSpeciesFraction=" + Convert.ToString(dailyPMAnalysisConfiguration.speciesFractionOptionsD.doAdvancedOptionsForSpeciesFraction ? 1 : 0));
                sw.WriteLine("officialPM25StartYear=" + dailyPMAnalysisConfiguration.pm25CalculationOptionsD.officialPM25StartYear.ToString());
                sw.WriteLine("officialPM25EndYear=" + dailyPMAnalysisConfiguration.pm25CalculationOptionsD.officialPM25EndYear.ToString());
                sw.WriteLine("minNumDVPeriodsForValidFRMMonitors=" + Convert.ToString(dailyPMAnalysisConfiguration.pm25CalculationOptionsD.minNumDVPeriodsForValidFRMMonitors));
                sw.WriteLine("requiredDesignValuePeriodsForValidFRMMonitors=" + dailyPMAnalysisConfiguration.pm25CalculationOptionsD.requiredDesignValuePeriodsForValidFRMMonitors.ToString());
                sw.WriteLine("doCalcNH4fromDON=" + Convert.ToString(dailyPMAnalysisConfiguration.pm25CalculationOptionsD.doCalcNH4fromDON ? 1 : 0));
                sw.WriteLine("doCalcNH4fromRRF=" + Convert.ToString(dailyPMAnalysisConfiguration.pm25CalculationOptionsD.doCalcNH4fromRRF ? 1 : 0));
                sw.WriteLine("temporalAdjustmentAtMonitorGridPoint=" + dailyPMAnalysisConfiguration.modelDataOptionsD.temporalAdjustmentAtMonitorGridPoint.ToString());
                sw.WriteLine("temporalAdjustmentAtMonitorGridSpatial=" + dailyPMAnalysisConfiguration.modelDataOptionsD.temporalAdjustmentAtMonitorGridSpatial.ToString());
                sw.WriteLine("temporalAdjustmentType=" + dailyPMAnalysisConfiguration.modelDataOptionsD.temporalAdjustmentType.ToString());
                sw.WriteLine("RRF_DoUseXTopPercent=" + Convert.ToString(dailyPMAnalysisConfiguration.modelDataOptionsD.RRF_DoUseXTopPercent ? 1 : 0));
                sw.WriteLine("RRF_UseXTopPercent=" + Convert.ToString(dailyPMAnalysisConfiguration.modelDataOptionsD.RRF_UseTopXNumber));
                sw.WriteLine("RRF_DoUseAllModelDaysGreaterThan=" + Convert.ToString(dailyPMAnalysisConfiguration.modelDataOptionsD.RRF_DoUseAllModelDaysGreaterThan ? 1 : 0));
                sw.WriteLine("RRF_UseAllModelDaysGreaterThan=" + Convert.ToString(dailyPMAnalysisConfiguration.modelDataOptionsD.RRF_UseAllModelDaysGreaterThan));
                sw.WriteLine("RRF_MinumumNumberOfDaysRequiredAboveFixedAmount=" + Convert.ToString(dailyPMAnalysisConfiguration.modelDataOptionsD.RRF_MinumumNumberOfDaysRequiredAboveFixedAmount));
                sw.WriteLine("RRF_DoUseTopXNumber=" + Convert.ToString(dailyPMAnalysisConfiguration.modelDataOptionsD.RRF_DoUseTopXNumber ? 1 : 0));
                sw.WriteLine("RRF_UseTopXNumber=" + Convert.ToString(dailyPMAnalysisConfiguration.modelDataOptionsD.RRF_UseTopXNumber));
                sw.Flush();
                sw.Close();
                fs.Close();
            }
            catch
            {
                return false;
            }
            return true;
        }
        public static bool OutPutBaseConfiguration(OzoneAnalysisConfiguration ozoneAnalysisConfiguration, string strFile)
        {
            try
            {
                FileStream fs = new FileStream(strFile, FileMode.Create);
                StreamWriter sw = new StreamWriter(fs, Encoding.UTF8);
                sw.WriteLine("RunType=RunOzone");
                if (CommonClass.IsBatch)
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath);//CommonClass.ResultFilePath
                }
                else
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath + @"\Result\Output");
                }
                sw.WriteLine("OutputFileName=" + Path.GetFileName(CommonClass.ProjectName.Replace(".proj", ".cfg")));
                //sw.WriteLine("OutputFileName=" + Path.GetFullPath(strFile));
                if (ozoneAnalysisConfiguration.chooseDesiredOutputO.scenarioName.ToString() == Path.GetFileNameWithoutExtension(strFile))
                    sw.WriteLine("scenarioName=" + ozoneAnalysisConfiguration.chooseDesiredOutputO.scenarioName.ToString());
                else
                    sw.WriteLine("scenarioName=" + Path.GetFileNameWithoutExtension(strFile));
                sw.WriteLine("doPointEstimatesForecast=" + Convert.ToString(ozoneAnalysisConfiguration.chooseDesiredOutputO.doPointEstimatesForecast ? 1 : 0));
                sw.WriteLine("doQuarterlyModelData=" + Convert.ToString(ozoneAnalysisConfiguration.chooseDesiredOutputO.doQuarterlyModelData ? 1 : 0));
                sw.WriteLine("doSpatialFieldEstimates=" + Convert.ToString(ozoneAnalysisConfiguration.chooseDesiredOutputO.doSpatialFieldEstimates ? 1 : 0));
                sw.WriteLine("doBaseOnlyVNA=" + Convert.ToString(ozoneAnalysisConfiguration.chooseDesiredOutputO.doBaseOnlyVNA ? 1 : 0));
                sw.WriteLine("doFutureOnlyVNA=" + Convert.ToString(ozoneAnalysisConfiguration.chooseDesiredOutputO.doFutureOnlyVNA ? 1 : 0));
                sw.WriteLine("doSpatialFieldEstimatesGradAdj=" + Convert.ToString(ozoneAnalysisConfiguration.chooseDesiredOutputO.doSpatialFieldEstimatesGradAdj ? 1 : 0));
                sw.WriteLine("doBaseOnlyEVNA=" + Convert.ToString(ozoneAnalysisConfiguration.chooseDesiredOutputO.doBaseOnlyEVNA ? 1 : 0));
                sw.WriteLine("doFutureOnlyEVNA=" + Convert.ToString(ozoneAnalysisConfiguration.chooseDesiredOutputO.doFutureOnlyEVNA ? 1 : 0));
                sw.WriteLine("doNeighborFileSpatial=" + Convert.ToString(ozoneAnalysisConfiguration.chooseDesiredOutputO.doNeighborFileSpatial ? 1 : 0));
                sw.WriteLine("doAutomaticallyExtract=" + Convert.ToString(ozoneAnalysisConfiguration.chooseDesiredOutputO.doAutomaticallyExtract ? 1 : 0));
                sw.WriteLine("doDesignValuePeriods=" + Convert.ToString(ozoneAnalysisConfiguration.chooseDesiredOutputO.doDesignValuePeriods ? 1 : 0));
                sw.WriteLine("doMaxDesignValuePeriods=" + Convert.ToString(ozoneAnalysisConfiguration.chooseDesiredOutputO.doMaxDesignValuePeriods ? 1 : 0));
                sw.WriteLine("ozoneMonitorDataFile=" + ozoneAnalysisConfiguration.dataInputO.ozoneMonitorDataFile.ToString());
                sw.WriteLine("doInputfromCmaq=" + Convert.ToString(ozoneAnalysisConfiguration.dataInputO.doInputfromCmaq ? 1 : 0));
                sw.WriteLine("baselineModelDataFile=" + ozoneAnalysisConfiguration.dataInputO.baselineModelDataFile.ToString());
                sw.WriteLine("forecastModelDataFile=" + ozoneAnalysisConfiguration.dataInputO.forecastModelDataFile.ToString());
                sw.WriteLine("temporalAdjustmentAtMonitorGrid=" + ozoneAnalysisConfiguration.dataInputO.temporalAdjustmentAtMonitorGrid.ToString());
                sw.WriteLine("temporalAdjustmentType=" + ozoneAnalysisConfiguration.dataInputO.temporalAdjustmentType.ToString());
                sw.WriteLine("ozoneStartYear=" + ozoneAnalysisConfiguration.filteringInterpolationO.ozoneStartYear.ToString());
                sw.WriteLine("ozoneEndYear=" + ozoneAnalysisConfiguration.filteringInterpolationO.ozoneEndYear.ToString());
                sw.WriteLine("minNumDV=" + Convert.ToString(ozoneAnalysisConfiguration.filteringInterpolationO.minNumDV));
                sw.WriteLine("requiredDVPeriods=" + ozoneAnalysisConfiguration.filteringInterpolationO.requiredDVPeriods.ToString());
                sw.WriteLine("defaultInterpolationMethod=" + ozoneAnalysisConfiguration.filteringInterpolationO.defaultInterpolationMethod.ToString());
                sw.WriteLine("doCheckToSetMaxDistance=" + Convert.ToString(ozoneAnalysisConfiguration.filteringInterpolationO.doCheckToSetMaxDistance ? 1 : 0));
                sw.WriteLine("maxDistance=" + Convert.ToString(ozoneAnalysisConfiguration.filteringInterpolationO.maxDistance));
                sw.WriteLine("useInitialThresholdValue=" + Convert.ToString(ozoneAnalysisConfiguration.rrfSpatialGradientO.useInitialThreshold ? 1 : 0));
                sw.WriteLine("initialThresholdValue=" + ozoneAnalysisConfiguration.rrfSpatialGradientO.initialThresholdValue.ToString());
                sw.WriteLine("minNumofDaysAtorAboveThreshold=" + ozoneAnalysisConfiguration.rrfSpatialGradientO.minNumofDaysAtorAboveThreshold.ToString());
                sw.WriteLine("topXmodeledozonedays=" + ozoneAnalysisConfiguration.rrfSpatialGradientO.topXDays.ToString());
                sw.WriteLine("minAllowableThresholdValue=" + ozoneAnalysisConfiguration.rrfSpatialGradientO.minAllowableThresholdValue.ToString());
                sw.WriteLine("minNumDaysAtorAboveMinAllowableThreshold=" + ozoneAnalysisConfiguration.rrfSpatialGradientO.minNumDaysAtorAboveMinAllowableThreshold.ToString());
                sw.WriteLine("doBackstop=" + Convert.ToString(ozoneAnalysisConfiguration.rrfSpatialGradientO.doBackstop ? 1 : 0));
                sw.WriteLine("backstopMinThresholdforSpatialField=" + ozoneAnalysisConfiguration.rrfSpatialGradientO.backstopMinThresholdforSpatialField.ToString());
                sw.WriteLine("subrangeFirstDay=" + Convert.ToString(ozoneAnalysisConfiguration.rrfSpatialGradientO.subrangeFirstDay));
                sw.WriteLine("subrangeLastDay=" + Convert.ToString(ozoneAnalysisConfiguration.rrfSpatialGradientO.subrangeLastDay));
                sw.WriteLine("doPairDays=" + Convert.ToString(ozoneAnalysisConfiguration.rrfSpatialGradientO.doPairDays ? 1 : 0));
                sw.WriteLine("SRF_StartValue=" + ozoneAnalysisConfiguration.rrfSpatialGradientO.SRF_StartValue.ToString());
                sw.WriteLine("SRF_EndValue=" + ozoneAnalysisConfiguration.rrfSpatialGradientO.SRF_EndValue.ToString());
                sw.Flush();
                sw.Close();
                fs.Close();
            }
            catch
            {
                return false;
            }
            return true;
        }
        public static bool OutPutBaseConfiguration(VisibilityAnalysisConfiguration visibilityAnalysisConfiguration, string strFile)
        {
            try
            {
                FileStream fs = new FileStream(strFile, FileMode.Create);
                StreamWriter sw = new StreamWriter(fs, Encoding.UTF8);
                sw.WriteLine("RunType=RunVisibility");
                if (CommonClass.IsBatch)
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath);//CommonClass.ResultFilePath
                }
                else
                {
                    sw.WriteLine("OutputFileDir=" + CommonClass.ResultFilePath + @"\Result\Output");
                }

                sw.WriteLine("OutputFileName=" + Path.GetFileName(CommonClass.ProjectName.Replace(".proj", ".cfg")));
                //sw.WriteLine("OutputFileName=" + Path.GetFullPath(strFile));
                //sw.WriteLine("scenarioName=" + visibilityAnalysisConfiguration.chooseDesiredOutputV.scenarioName.ToString());
                if (visibilityAnalysisConfiguration.chooseDesiredOutputV.scenarioName.ToString() == Path.GetFileNameWithoutExtension(strFile))
                    sw.WriteLine("scenarioName=" + visibilityAnalysisConfiguration.chooseDesiredOutputV.scenarioName.ToString());
                else
                    sw.WriteLine("scenarioName=" + Path.GetFileNameWithoutExtension(strFile));
                sw.WriteLine("doTemporallyAdjVisibilityLevelsForecast=" + Convert.ToString(visibilityAnalysisConfiguration.chooseDesiredOutputV.doTemporallyAdjVisibilityLevelsForecast ? 1 : 0));
                sw.WriteLine("choiceUseOldVersionforIMPROVEAlgorithm=" + Convert.ToString(visibilityAnalysisConfiguration.chooseDesiredOutputV.choiceUseOldVersionforIMPROVEAlgorithm ? 1 : 0));
                sw.WriteLine("choiceUseNewVersionforIMPROVEAlgorithm=" + Convert.ToString(visibilityAnalysisConfiguration.chooseDesiredOutputV.choiceUseNewVersionforIMPROVEAlgorithm ? 1 : 0));
                sw.WriteLine("choiceUseModelGridCellAtMonitor=" + Convert.ToString(visibilityAnalysisConfiguration.chooseDesiredOutputV.choiceUseModelGridCellAtMonitor ? 1 : 0));
                sw.WriteLine("choiceUseModelGridCellatClassIAreaCentroid=" + Convert.ToString(visibilityAnalysisConfiguration.chooseDesiredOutputV.choiceUseModelGridCellatClassIAreaCentroid ? 1 : 0));
                sw.WriteLine("doAutomaticallyExtract=" + Convert.ToString(visibilityAnalysisConfiguration.chooseDesiredOutputV.doAutomaticallyExtract ? 1 : 0));
                sw.WriteLine("monitorDataFileOldAlgorithm=" + (visibilityAnalysisConfiguration.dataInputV.monitorDataFileOldAlgorithm == null ? "" : visibilityAnalysisConfiguration.dataInputV.monitorDataFileOldAlgorithm.ToString()));
                sw.WriteLine("monitorDataFileNewAlgorithm=" + (visibilityAnalysisConfiguration.dataInputV.monitorDataFileNewAlgorithm == null ? "" : visibilityAnalysisConfiguration.dataInputV.monitorDataFileNewAlgorithm.ToString()));
                //for new calculation of Visibility, add by sclong, 2017-03-30
                sw.WriteLine("forecastIMPROVEDataFile=" + (visibilityAnalysisConfiguration.dataInputV.forecastIMPROVEDataFile == null ? "" : visibilityAnalysisConfiguration.dataInputV.forecastIMPROVEDataFile.ToString()));
                sw.WriteLine("needCreateForecastIMPROVEDataFile=" + (visibilityAnalysisConfiguration.dataInputV.isCreateForecastIMPROVEData ? 1 : 0));
                sw.WriteLine("checkForecastIMPROVEAdvance=" + (visibilityAnalysisConfiguration.dataInputV.isCheckedForecastIMPROVEAdvanced ? 1 : 0));

                sw.WriteLine("baselineModelDataFile=" + visibilityAnalysisConfiguration.dataInputV.baselineModelDataFile.ToString());
                sw.WriteLine("forecastModelDataFile=" + visibilityAnalysisConfiguration.dataInputV.forecastModelDataFile.ToString());
                sw.WriteLine("temporalAdjustmentAtMonitorGrid=" + visibilityAnalysisConfiguration.dataInputV.temporalAdjustmentAtMonitorGrid.ToString());
                sw.WriteLine("startMonitorYear=" + visibilityAnalysisConfiguration.filteringV.startMonitorYear.ToString());
                sw.WriteLine("endMonitorYear=" + visibilityAnalysisConfiguration.filteringV.endMonitorYear.ToString());
                sw.WriteLine("baseModelYear=" + visibilityAnalysisConfiguration.filteringV.baseModelYear.ToString());
                sw.WriteLine("minYearsForValidVisibilityMonitors=" + visibilityAnalysisConfiguration.filteringV.minYearsForValidVisibilityMonitors.ToString());
                sw.Flush();
                sw.Close();
                fs.Close();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return false;
            }
            return true;
        }

        public static bool RunBatch(string strFile)
        {
            try
            {
                BatchBase batchBase = ReadBatchFile(strFile);
                if (batchBase == null) return false;
                //---------modify by xiejp Set batchResultPath
                if (batchBase.batchResultPath != "") CommonClass.ResultFilePath = batchBase.batchResultPath;
                if (batchBase is BatchAnnualPM)
                {
                    #region
                    try
                    {
                        CommonClass.CurrentAnalysis = enumAnalysis.AnnualPM;
                        BatchAnnualPM batchAnnualPM = batchBase as BatchAnnualPM;
                        if (CommonClass.CurrentBaseScenario == null)
                            CommonClass.CurrentBaseScenario = new BaseScenario();
                        CommonClass.CurrentBaseScenario.configuration = new AnnualPMAnalysisConfiguration();
                        AnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration;
                        CommonClass.CurrentBaseScenario.configuration.configurationName = batchAnnualPM.scenarioName;
                        annualPMAnalysisConfiguration.chooseDesiredOutputA = new ChooseDesiredOutputA();
                        annualPMAnalysisConfiguration.chooseDesiredOutputA.scenarioName = batchAnnualPM.scenarioName;
                        annualPMAnalysisConfiguration.chooseDesiredOutputA.doStandardAnalysis = batchAnnualPM.doStandardAnalysis;
                        annualPMAnalysisConfiguration.chooseDesiredOutputA.doQuarterlyModelData = batchAnnualPM.doQuarterlyModelData;
                        annualPMAnalysisConfiguration.chooseDesiredOutputA.doUsedQuarterlyAvgModelData = batchAnnualPM.doUsedQuarterlyAvgModelData;
                        annualPMAnalysisConfiguration.chooseDesiredOutputA.doSpeciesFraction = batchAnnualPM.doSpeciesFraction;
                        annualPMAnalysisConfiguration.chooseDesiredOutputA.doAutomaticallyExtract = batchAnnualPM.doAutomaticallyExtract;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA = new OutputChoiceAdvancedA();
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doInterpolatedSFETempAdj = batchAnnualPM.doInterpolatedSFETempAdj;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doBaseOnlyVNA = batchAnnualPM.doBaseOnlyVNA;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doFutureOnlyVNA = batchAnnualPM.doFutureOnlyVNA;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doInterpolatedSFETempAdj_GradAdj = batchAnnualPM.doInterpolatedSFETempAdj_GradAdj;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doBaseOnlyEvna = batchAnnualPM.doBaseOnlyEvna;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doFutureOnlyEvna = batchAnnualPM.doFutureOnlyEvna;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doQuarterlyAvgFilePoint = batchAnnualPM.doQuarterlyAvgFilePoint;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doQuarterlyAvgFileSpatial = batchAnnualPM.doQuarterlyAvgFileSpatial;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doQuarterlyAvgFileSpatial_GraAdj = batchAnnualPM.doQuarterlyAvgFileSpatial_GraAdj;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doHighCountySites = batchAnnualPM.doHighCountySites;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doSpeciesFractionSpatial = batchAnnualPM.doSpeciesFractionSpatial;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doSpeciesFractionSpatial_GraAdj = batchAnnualPM.doSpeciesFractionSpatial_GraAdj;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doQuarterlyAvgSpeciatedMonitors = batchAnnualPM.doQuarterlyAvgSpeciatedMonitors;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doDesignValuePeriods = batchAnnualPM.doDesignValuePeriods;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFilePoint = batchAnnualPM.doNeighborFilePoint;
                        annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFileSpatial = batchAnnualPM.doNeighborFileSpatial;
                        annualPMAnalysisConfiguration.dataInputA = new DataInputA();
                        annualPMAnalysisConfiguration.dataInputA.doSpeciesMonitorDataFile = batchAnnualPM.doSpeciesMonitorDataFile;
                        annualPMAnalysisConfiguration.dataInputA.speciesMonitorDataFile = batchAnnualPM.speciesMonitorDataFile;
                        annualPMAnalysisConfiguration.dataInputA.doSpeciesFractionFile = batchAnnualPM.doSpeciesFractionFile;
                        annualPMAnalysisConfiguration.dataInputA.specFracModePoint = batchAnnualPM.specFracModePoint;
                        annualPMAnalysisConfiguration.dataInputA.specFracModeSpatial = batchAnnualPM.specFracModeSpatial;
                        annualPMAnalysisConfiguration.dataInputA.specFracPointFile = batchAnnualPM.specFracPointFile;
                        annualPMAnalysisConfiguration.dataInputA.specFracSpatialFile = batchAnnualPM.specFracSpatialFile;
                        annualPMAnalysisConfiguration.dataInputA.unofficialMonitorDataFile = batchAnnualPM.unofficialMonitorDataFile;
                        annualPMAnalysisConfiguration.dataInputA.officialMonitorDataFile = batchAnnualPM.officialMonitorDataFile;
                        annualPMAnalysisConfiguration.dataInputA.doDailyModelDataInput = batchAnnualPM.doDailyModelDataInput;
                        annualPMAnalysisConfiguration.dataInputA.doQuarterlyModelDataInput = batchAnnualPM.doQuarterlyModelDataInput;
                        annualPMAnalysisConfiguration.dataInputA.doInputFromCmaq = batchAnnualPM.doInputFromCmaq;
                        annualPMAnalysisConfiguration.dataInputA.baselineModelDataFile = batchAnnualPM.baselineModelDataFile;
                        annualPMAnalysisConfiguration.dataInputA.forecastModelDataFile = batchAnnualPM.forecastModelDataFile;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA = new SpeciesFractionOptionsA();
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_StartYear = batchAnnualPM.IMPROVESTN_StartYear;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_EndYear = batchAnnualPM.IMPROVESTN_EndYear;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_EPADeletionChoice = batchAnnualPM.IMPROVESTN_EPADeletionChoice;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_UserDeletionChoice = batchAnnualPM.IMPROVESTN_UserDeletionChoice;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_MinDays = batchAnnualPM.IMPROVESTN_MinDays;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_MinSeasons = batchAnnualPM.IMPROVESTN_MinSeasons;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_MinYear = batchAnnualPM.IMPROVESTN_MinYear;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialStartYear = batchAnnualPM.unofficialStartYear;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialEndYear = batchAnnualPM.unofficialEndYear;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialEPADeletionChoice = batchAnnualPM.unofficialEPADeletionChoice;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialUserDeletionChoice = batchAnnualPM.unofficialUserDeletionChoice;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialMinDays = batchAnnualPM.unofficialMinDays;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialMinYears = batchAnnualPM.unofficialMinYears;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialMinSeasonsPoint = batchAnnualPM.unofficialMinSeasonsPoint;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialMinSeasonsSpatial = batchAnnualPM.unofficialMinSeasonsSpatial;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.doAdvancedOptionsForSpeciesFraction = batchAnnualPM.doAdvancedOptionsForSpeciesFraction;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodPM25 = batchAnnualPM.interpolationMethodPM25;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.distancePM25 = batchAnnualPM.distancePM25;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodSO4 = batchAnnualPM.interpolationMethodSO4;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceSO4 = batchAnnualPM.distanceSO4;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodNO3 = batchAnnualPM.interpolationMethodNO3;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceNO3 = batchAnnualPM.distanceNO3;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodEC = batchAnnualPM.interpolationMethodEC;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceEC = batchAnnualPM.distanceEC;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodSalt = batchAnnualPM.interpolationMethodSalt;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceSalt = batchAnnualPM.distanceSalt;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodCrustal = batchAnnualPM.interpolationMethodCrustal;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceCrustal = batchAnnualPM.distanceCrustal;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodDON = batchAnnualPM.interpolationMethodDON;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceDON = batchAnnualPM.distanceDON;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodOC = batchAnnualPM.interpolationMethodOC;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceOC = batchAnnualPM.distanceOC;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.interpolationMethodNH4 = batchAnnualPM.interpolationMethodNH4;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.distanceNH4 = batchAnnualPM.distanceNH4;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.doUseDonValues = batchAnnualPM.doUseDonValues;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.doUseAmmoniumValues = batchAnnualPM.doUseAmmoniumValues;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.nh4PercentageEvaporating = batchAnnualPM.nh4PercentageEvaporating;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.defaultBlankMass = batchAnnualPM.defaultBlankMass;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.floorOCMMB = batchAnnualPM.floorOCMMB;
                        annualPMAnalysisConfiguration.speciesFractionOptionsA.ceilingOCMMB = batchAnnualPM.ceilingOCMMB;
                        annualPMAnalysisConfiguration.pm25CalculationOptionsA = new PM25CalculationOptionsA();
                        annualPMAnalysisConfiguration.pm25CalculationOptionsA.officialPM25StartYear = batchAnnualPM.officialPM25StartYear;
                        annualPMAnalysisConfiguration.pm25CalculationOptionsA.officialPM25EndYear = batchAnnualPM.officialPM25EndYear;
                        annualPMAnalysisConfiguration.pm25CalculationOptionsA.choiceOfficialDV = batchAnnualPM.choiceOfficialDV;
                        annualPMAnalysisConfiguration.pm25CalculationOptionsA.choiceCustomDV = batchAnnualPM.choiceCustomDV;
                        annualPMAnalysisConfiguration.pm25CalculationOptionsA.minDaysForValidFRMQuarters = batchAnnualPM.minDaysForValidFRMQuarters;
                        annualPMAnalysisConfiguration.pm25CalculationOptionsA.minQuartersForValidFRMDesignValues = batchAnnualPM.minQuartersForValidFRMDesignValues;
                        annualPMAnalysisConfiguration.pm25CalculationOptionsA.minNumDVPeriodsForValidFRMMonitors = batchAnnualPM.minNumDVPeriodsForValidFRMMonitors;
                        annualPMAnalysisConfiguration.pm25CalculationOptionsA.requiredDVPeriodsForValidFRMMonitors = batchAnnualPM.requiredDVPeriodsForValidFRMMonitors;
                        annualPMAnalysisConfiguration.pm25CalculationOptionsA.doCalcNH4fromDON = batchAnnualPM.doCalcNH4fromDON;
                        annualPMAnalysisConfiguration.pm25CalculationOptionsA.doCalcNH4fromRRF = batchAnnualPM.doCalcNH4fromRRF;
                        annualPMAnalysisConfiguration.modelDataOptionsA = new ModelDataOptionsA();
                        annualPMAnalysisConfiguration.modelDataOptionsA.temporalAdjustmentAtMonitorGrid = batchAnnualPM.temporalAdjustmentAtMonitorGrid;
                        annualPMAnalysisConfiguration.modelDataOptionsA.temporalAdjustmentAtMonitorGridSpatial = batchAnnualPM.temporalAdjustmentAtMonitorGridSpatial;
                        //--------------RunProject------------------
                        SMAT_CE mats = new SMAT_CE();
                        mats.btnSaveRun_Click(null, null);
                    }
                    catch (Exception ex)
                    {
                        //---------写错误日志
                        WriteBatchLogFile("Wrong Batch :" + ex.Message, strFile + ".log");
                        for (int j = 1; j < batchBase.BatchText.Count; j++)
                        {
                            WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                        }
                    }
                    #endregion
                }
                else if (batchBase is BatchDailyPM)
                {
                    #region
                    try
                    {
                        CommonClass.CurrentAnalysis = enumAnalysis.DailyPM;
                        BatchDailyPM batchDailyPM = batchBase as BatchDailyPM;
                        if (CommonClass.CurrentBaseScenario == null)
                            CommonClass.CurrentBaseScenario = new BaseScenario();
                        CommonClass.CurrentBaseScenario.configuration = new DailyPMAnalysisConfiguration();
                        DailyPMAnalysisConfiguration dailyPMAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration;
                        CommonClass.CurrentBaseScenario.configuration.configurationName = batchDailyPM.scenarioName;
                        dailyPMAnalysisConfiguration.chooseDesiredOutputD = new ChooseDesiredOutputD();
                        dailyPMAnalysisConfiguration.chooseDesiredOutputD.scenarioName = batchDailyPM.scenarioName;
                        dailyPMAnalysisConfiguration.chooseDesiredOutputD.doStandardAnalysis = batchDailyPM.doStandardAnalysis;
                        dailyPMAnalysisConfiguration.chooseDesiredOutputD.doQuarterlyPeakModelData = batchDailyPM.doQuarterlyPeakModelData;
                        dailyPMAnalysisConfiguration.chooseDesiredOutputD.doSpeciesFraction = batchDailyPM.doSpeciesFraction;
                        dailyPMAnalysisConfiguration.chooseDesiredOutputD.doAutomaticallyExtract = batchDailyPM.doAutomaticallyExtract;
                        dailyPMAnalysisConfiguration.outputChoiceAdvancedD = new OutputChoiceAdvancedD();
                        dailyPMAnalysisConfiguration.outputChoiceAdvancedD.doQuarterlyPeakFilesPoint = batchDailyPM.doQuarterlyPeakFilesPoint;
                        dailyPMAnalysisConfiguration.outputChoiceAdvancedD.doHighCountySites = batchDailyPM.doHighCountySites;
                        dailyPMAnalysisConfiguration.outputChoiceAdvancedD.doQuarterlyPeakSpeciatedMonitors = batchDailyPM.doQuarterlyPeakSpeciatedMonitors;
                        dailyPMAnalysisConfiguration.outputChoiceAdvancedD.doDesignValuePeriods = batchDailyPM.doDesignValuePeriods;
                        dailyPMAnalysisConfiguration.outputChoiceAdvancedD.doNeighborFilePoint = batchDailyPM.doNeighborFilePoint;
                        dailyPMAnalysisConfiguration.dataInputD = new DataInputD();
                        dailyPMAnalysisConfiguration.dataInputD.doSpeciesMonitorDataFile = batchDailyPM.doSpeciesMonitorDataFile;
                        dailyPMAnalysisConfiguration.dataInputD.speciesMonitorDataFile = batchDailyPM.speciesMonitorDataFile;
                        dailyPMAnalysisConfiguration.dataInputD.doSpeciesFractionFile = batchDailyPM.doSpeciesFractionFile;
                        dailyPMAnalysisConfiguration.dataInputD.specFracModePoint = batchDailyPM.specFracModePoint;
                        dailyPMAnalysisConfiguration.dataInputD.specFracPointFile = batchDailyPM.specFracPointFile;
                        dailyPMAnalysisConfiguration.dataInputD.specFracModeSpatial = batchDailyPM.specFracModeSpatial;
                        dailyPMAnalysisConfiguration.dataInputD.specFracSpatialFile = batchDailyPM.specFracSpatialFile;
                        dailyPMAnalysisConfiguration.dataInputD.unofficialMonitorFile = batchDailyPM.unofficialMonitorFile;
                        dailyPMAnalysisConfiguration.dataInputD.officialMonitorFile = batchDailyPM.officialMonitorFile;
                        dailyPMAnalysisConfiguration.dataInputD.doDailyModelDataInput = batchDailyPM.doDailyModelDataInput;
                        dailyPMAnalysisConfiguration.dataInputD.doQuarterlyPeakModelDataInput = batchDailyPM.doQuarterlyPeakModelDataInput;
                        dailyPMAnalysisConfiguration.dataInputD.doInputfromCmaq = batchDailyPM.doInputfromCmaq;
                        dailyPMAnalysisConfiguration.dataInputD.baselineModelFile = batchDailyPM.baselineModelFile;
                        dailyPMAnalysisConfiguration.dataInputD.forecastModelFile = batchDailyPM.forecastModelFile;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD = new SpeciesFractionOptionsD();
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_StartYear = batchDailyPM.IMPROVE_StartYear;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_EndYear = batchDailyPM.IMPROVE_EndYear;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_EPADeletionChoice = batchDailyPM.IMPROVE_EPADeletionChoice;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_UserDeletionChoice = batchDailyPM.IMPROVE_UserDeletionChoice;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_MinDays = batchDailyPM.IMPROVE_MinDays;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_MinQuarters = batchDailyPM.IMPROVE_MinQuarters;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_MinYear = batchDailyPM.IMPROVE_MinYear;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialStartYear = batchDailyPM.unofficialStartYear;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialEndYear = batchDailyPM.unofficialEndYear;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialEPADeletionChoice = batchDailyPM.unofficialEPADeletionChoice;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialUserDeletionChoice = batchDailyPM.unofficialUserDeletionChoice;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialMinDays = batchDailyPM.unofficialMinDays;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialMinQuartersPoint = batchDailyPM.unofficialMinQuartersPoint;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialMinYears = batchDailyPM.unofficialMinYears;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.doAdvancedOptionsForSpeciesFraction = batchDailyPM.doAdvancedOptionsForSpeciesFraction;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVESTN_DoTopXPercent = batchDailyPM.IMPROVESTN_DoTopXPercent;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVESTN_TopXPercent = batchDailyPM.IMPROVESTN_TopXPercent;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVESTN_DoUseAlldailyMonitorValuesGreaterThan = batchDailyPM.IMPROVESTN_DoUseAlldailyMonitorValuesGreaterThan;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVESTN_UseAlldailyMonitorValuesGreaterThan = batchDailyPM.IMPROVESTN_UseAlldailyMonitorValuesGreaterThan;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVESTN_MinumumNumberOfDaysRequiredAboveFixedAmount = batchDailyPM.IMPROVESTN_MinumumNumberOfDaysRequiredAboveFixedAmount;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVESTN_DoUseTopXNumber = batchDailyPM.IMPROVESTN_DoTopXPercent;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVESTN_UseTopXNumber = batchDailyPM.IMPROVESTN_UseTopXNumber;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialPM25_DoTopXPercent = batchDailyPM.unofficialPM25_DoTopXPercent;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialPM25_TopXPercent = batchDailyPM.unofficialPM25_TopXPercent;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialPM25_DoUseAlldailyMonitorValuesGreaterThan = batchDailyPM.unofficialPM25_DoUseAlldailyMonitorValuesGreaterThan;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialPM25_UseAlldailyMonitorValuesGreaterThan = batchDailyPM.unofficialPM25_UseAlldailyMonitorValuesGreaterThan;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialPM25_MinumumNumberOfDaysRequiredAboveFixedAmount = batchDailyPM.unofficialPM25_MinumumNumberOfDaysRequiredAboveFixedAmount;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialPM25_DoTopXNumber = batchDailyPM.unofficialPM25_DoTopXNumber;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialPM25_TopXNumber = batchDailyPM.unofficialPM25_TopXNumber;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodPM25 = batchDailyPM.interpolationMethodPM25;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.distancePM25 = batchDailyPM.distancePM25;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodSO4 = batchDailyPM.interpolationMethodSO4;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceSO4 = batchDailyPM.distanceSO4;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodNO3 = batchDailyPM.interpolationMethodNO3;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceNO3 = batchDailyPM.distanceNO3;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodEC = batchDailyPM.interpolationMethodEC;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceEC = batchDailyPM.distanceEC;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodSalt = batchDailyPM.interpolationMethodSalt;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceSalt = batchDailyPM.distanceSalt;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodCrustal = batchDailyPM.interpolationMethodCrustal;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceCrustal = batchDailyPM.distanceCrustal;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodDON = batchDailyPM.interpolationMethodDON;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceDON = batchDailyPM.distanceDON;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodOC = batchDailyPM.interpolationMethodOC;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceOC = batchDailyPM.distanceOC;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.interpolationMethodNH4 = batchDailyPM.interpolationMethodNH4;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.distanceNH4 = batchDailyPM.distanceNH4;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.doUseDonValues = batchDailyPM.doUseDonValues;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.doUseMeasuredAmmonium = batchDailyPM.doUseMeasuredAmmonium;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.nh4PercentageEvaporating = batchDailyPM.nh4PercentageEvaporating;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.defaultBlankMass = batchDailyPM.defaultBlankMass;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.floorOCMMB = batchDailyPM.floorOCMMB;
                        dailyPMAnalysisConfiguration.speciesFractionOptionsD.ceilingOCMMB = batchDailyPM.ceilingOCMMB;
                        dailyPMAnalysisConfiguration.pm25CalculationOptionsD = new PM25CalculationOptionsD();
                        dailyPMAnalysisConfiguration.pm25CalculationOptionsD.officialPM25StartYear = batchDailyPM.officialPM25StartYear;
                        dailyPMAnalysisConfiguration.pm25CalculationOptionsD.officialPM25EndYear = batchDailyPM.officialPM25EndYear;
                        dailyPMAnalysisConfiguration.pm25CalculationOptionsD.minNumDVPeriodsForValidFRMMonitors = batchDailyPM.minNumDVPeriodsForValidFRMMonitors;
                        dailyPMAnalysisConfiguration.pm25CalculationOptionsD.requiredDesignValuePeriodsForValidFRMMonitors = batchDailyPM.requiredDesignValuePeriodsForValidFRMMonitors;
                        dailyPMAnalysisConfiguration.pm25CalculationOptionsD.doCalcNH4fromDON = batchDailyPM.doCalcNH4fromDON;
                        dailyPMAnalysisConfiguration.pm25CalculationOptionsD.doCalcNH4fromRRF = batchDailyPM.doCalcNH4fromRRF;
                        dailyPMAnalysisConfiguration.modelDataOptionsD = new ModelDataOptionsD();
                        dailyPMAnalysisConfiguration.modelDataOptionsD.temporalAdjustmentAtMonitorGridPoint = batchDailyPM.temporalAdjustmentAtMonitorGridPoint;
                        dailyPMAnalysisConfiguration.modelDataOptionsD.temporalAdjustmentAtMonitorGridSpatial = batchDailyPM.temporalAdjustmentAtMonitorGridSpatial;
                        dailyPMAnalysisConfiguration.modelDataOptionsD.temporalAdjustmentType = batchDailyPM.temporalAdjustmentType;
                        dailyPMAnalysisConfiguration.modelDataOptionsD.RRF_DoUseXTopPercent = batchDailyPM.RRF_DoUseXTopPercent;
                        dailyPMAnalysisConfiguration.modelDataOptionsD.RRF_UseXTopPercent = batchDailyPM.RRF_UseXTopPercent;
                        dailyPMAnalysisConfiguration.modelDataOptionsD.RRF_DoUseAllModelDaysGreaterThan = batchDailyPM.RRF_DoUseAllModelDaysGreaterThan;
                        dailyPMAnalysisConfiguration.modelDataOptionsD.RRF_UseAllModelDaysGreaterThan = batchDailyPM.RRF_UseAllModelDaysGreaterThan;
                        dailyPMAnalysisConfiguration.modelDataOptionsD.RRF_MinumumNumberOfDaysRequiredAboveFixedAmount = batchDailyPM.RRF_MinumumNumberOfDaysRequiredAboveFixedAmount;
                        dailyPMAnalysisConfiguration.modelDataOptionsD.RRF_DoUseTopXNumber = batchDailyPM.RRF_DoUseTopXNumber;
                        dailyPMAnalysisConfiguration.modelDataOptionsD.RRF_UseTopXNumber = batchDailyPM.RRF_UseTopXNumber;
                        //----------RunProject--------------
                        SMAT_CE mats = new SMAT_CE();
                        mats.btnSaveRun_Click(null, null);
                    }
                    catch (Exception ex)
                    {
                        //---------写错误日志
                        WriteBatchLogFile("Wrong Batch :" + ex.Message, strFile + ".log");
                        for (int j = 1; j < batchBase.BatchText.Count; j++)
                        {
                            WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                        }
                    }
                    #endregion
                }
                else if (batchBase is BatchOzone)
                {
                    #region
                    try
                    {
                        CommonClass.CurrentAnalysis = enumAnalysis.Ozone;
                        BatchOzone batchOzone = batchBase as BatchOzone;
                        if (CommonClass.CurrentBaseScenario == null)
                            CommonClass.CurrentBaseScenario = new BaseScenario();
                        CommonClass.CurrentBaseScenario.configuration = new OzoneAnalysisConfiguration();
                        OzoneAnalysisConfiguration ozoneAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration;
                        CommonClass.CurrentBaseScenario.configuration.configurationName = batchOzone.scenarioName;
                        ozoneAnalysisConfiguration.chooseDesiredOutputO = new ChooseDesiredOutputO();
                        ozoneAnalysisConfiguration.chooseDesiredOutputO.scenarioName = batchOzone.scenarioName;
                        ozoneAnalysisConfiguration.chooseDesiredOutputO.doPointEstimatesForecast = batchOzone.doPointEstimatesForecast;
                        ozoneAnalysisConfiguration.chooseDesiredOutputO.doQuarterlyModelData = batchOzone.doQuarterlyModelData;
                        ozoneAnalysisConfiguration.chooseDesiredOutputO.doSpatialFieldEstimates = batchOzone.doSpatialFieldEstimates;
                        ozoneAnalysisConfiguration.chooseDesiredOutputO.doSpatialFieldEstimatesGradAdj = batchOzone.doSpatialFieldEstimatesGradAdj;
                        ozoneAnalysisConfiguration.chooseDesiredOutputO.doBaseOnlyVNA = batchOzone.doBaseOnlyVNA;
                        ozoneAnalysisConfiguration.chooseDesiredOutputO.doFutureOnlyVNA = batchOzone.doFutureOnlyVNA;
                        ozoneAnalysisConfiguration.chooseDesiredOutputO.doBaseOnlyEVNA = batchOzone.doBaseOnlyEvna;
                        ozoneAnalysisConfiguration.chooseDesiredOutputO.doFutureOnlyEVNA = batchOzone.doFutureOnlyEvna;
                        //ozoneAnalysisConfiguration.chooseDesiredOutputO.doSpatialFieldEstimatesForecast = batchOzone.doSpatialFieldEstimatesForecast;
                        //ozoneAnalysisConfiguration.chooseDesiredOutputO.doSpatialFieldEstimatesForecastGradAdj = batchOzone.doSpatialFieldEstimatesForecastGradAdj;
                        ozoneAnalysisConfiguration.chooseDesiredOutputO.doNeighborFileSpatial = batchOzone.doNeighborFileSpatial;
                        ozoneAnalysisConfiguration.chooseDesiredOutputO.doAutomaticallyExtract = batchOzone.doAutomaticallyExtract;
                        ozoneAnalysisConfiguration.chooseDesiredOutputO.doDesignValuePeriods = batchOzone.doDesignValuePeriods;
                        ozoneAnalysisConfiguration.chooseDesiredOutputO.doMaxDesignValuePeriods = batchOzone.doMaxDesignValuePeriods;
                        ozoneAnalysisConfiguration.dataInputO = new DataInputO();
                        ozoneAnalysisConfiguration.dataInputO.ozoneMonitorDataFile = batchOzone.ozoneMonitorDataFile;
                        ozoneAnalysisConfiguration.dataInputO.baselineModelDataFile = batchOzone.baselineModelDataFile;
                        ozoneAnalysisConfiguration.dataInputO.forecastModelDataFile = batchOzone.forecastModelDataFile;
                        ozoneAnalysisConfiguration.dataInputO.temporalAdjustmentAtMonitorGrid = batchOzone.temporalAdjustmentAtMonitorGrid;
                        ozoneAnalysisConfiguration.dataInputO.temporalAdjustmentType = batchOzone.temporalAdjustmentType;
                        ozoneAnalysisConfiguration.filteringInterpolationO = new FilteringInterpolationO();
                        ozoneAnalysisConfiguration.filteringInterpolationO.ozoneStartYear = batchOzone.ozoneStartYear;
                        ozoneAnalysisConfiguration.filteringInterpolationO.ozoneEndYear = batchOzone.ozoneEndYear;
                        ozoneAnalysisConfiguration.filteringInterpolationO.minNumDV = batchOzone.minNumDV;
                        ozoneAnalysisConfiguration.filteringInterpolationO.requiredDVPeriods = batchOzone.requiredDVPeriods;
                        ozoneAnalysisConfiguration.filteringInterpolationO.defaultInterpolationMethod = batchOzone.defaultInterpolationMethod;
                        ozoneAnalysisConfiguration.filteringInterpolationO.doCheckToSetMaxDistance = batchOzone.doCheckToSetMaxDistance;
                        ozoneAnalysisConfiguration.filteringInterpolationO.maxDistance = batchOzone.maxDistance;
                        ozoneAnalysisConfiguration.rrfSpatialGradientO = new RRFSpatialGradientO();
                        ozoneAnalysisConfiguration.rrfSpatialGradientO.useInitialThreshold = batchOzone.useInitialThresholdValue;
                        ozoneAnalysisConfiguration.rrfSpatialGradientO.initialThresholdValue = batchOzone.initialThresholdValue;
                        ozoneAnalysisConfiguration.rrfSpatialGradientO.minNumofDaysAtorAboveThreshold = batchOzone.minNumofDaysAtorAboveThreshold;
                        ozoneAnalysisConfiguration.rrfSpatialGradientO.topXDays = Convert.ToInt32(batchOzone.topXmodeledozonedays);
                        ozoneAnalysisConfiguration.rrfSpatialGradientO.minAllowableThresholdValue = batchOzone.minAllowableThresholdValue;
                        ozoneAnalysisConfiguration.rrfSpatialGradientO.minNumDaysAtorAboveMinAllowableThreshold = batchOzone.minNumDaysAtorAboveMinAllowableThreshold;
                        ozoneAnalysisConfiguration.rrfSpatialGradientO.doBackstop = batchOzone.doBackstop;
                        ozoneAnalysisConfiguration.rrfSpatialGradientO.backstopMinThresholdforSpatialField = batchOzone.backstopMinThresholdforSpatialField;
                        ozoneAnalysisConfiguration.rrfSpatialGradientO.subrangeFirstDay = batchOzone.subrangeFirstDay;
                        ozoneAnalysisConfiguration.rrfSpatialGradientO.subrangeLastDay = batchOzone.subrangeLastDay;
                        ozoneAnalysisConfiguration.rrfSpatialGradientO.doPairDays = batchOzone.doPairDays;
                        ozoneAnalysisConfiguration.rrfSpatialGradientO.SRF_StartValue = batchOzone.SRF_StartValue;
                        ozoneAnalysisConfiguration.rrfSpatialGradientO.SRF_EndValue = batchOzone.SRF_EndValue;
                        //-----------RunProject-------------
                        SMAT_CE mats = new SMAT_CE();
                        mats.btnSaveRun_Click(null, null);
                    }
                    catch (Exception ex)
                    {
                        //---------写错误日志
                        WriteBatchLogFile("Wrong Batch :" + ex.Message, strFile + ".log");
                        for (int j = 1; j < batchBase.BatchText.Count; j++)
                        {
                            WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                        }
                    }
                    #endregion
                }
                else if (batchBase is BatchVisibility)
                {
                    #region
                    try
                    {
                        CommonClass.CurrentAnalysis = enumAnalysis.Visibility;
                        BatchVisibility batchVisibility = batchBase as BatchVisibility;
                        if (CommonClass.CurrentBaseScenario == null)
                            CommonClass.CurrentBaseScenario = new BaseScenario();
                        CommonClass.CurrentBaseScenario.configuration = new VisibilityAnalysisConfiguration();
                        CommonClass.CurrentBaseScenario.configuration.configurationName = batchVisibility.scenarioName;
                        VisibilityAnalysisConfiguration visibilityAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration;
                        visibilityAnalysisConfiguration.chooseDesiredOutputV = new ChooseDesiredOutputV();
                        visibilityAnalysisConfiguration.chooseDesiredOutputV.scenarioName = batchVisibility.scenarioName;
                        visibilityAnalysisConfiguration.chooseDesiredOutputV.doTemporallyAdjVisibilityLevelsForecast = batchVisibility.doTemporallyAdjVisibilityLevelsForecast;
                        visibilityAnalysisConfiguration.chooseDesiredOutputV.choiceUseOldVersionforIMPROVEAlgorithm = batchVisibility.choiceUseOldVersionforIMPROVEAlgorithm;
                        visibilityAnalysisConfiguration.chooseDesiredOutputV.choiceUseNewVersionforIMPROVEAlgorithm = batchVisibility.choiceUseNewVersionforIMPROVEAlgorithm;
                        visibilityAnalysisConfiguration.chooseDesiredOutputV.choiceUseModelGridCellAtMonitor = batchVisibility.choiceUseModelGridCellAtMonitor;
                        visibilityAnalysisConfiguration.chooseDesiredOutputV.choiceUseModelGridCellatClassIAreaCentroid = batchVisibility.choiceUseModelGridCellatClassIAreaCentroid;
                        visibilityAnalysisConfiguration.chooseDesiredOutputV.doAutomaticallyExtract = batchVisibility.doAutomaticallyExtract;
                        visibilityAnalysisConfiguration.dataInputV = new DataInputV();
                        visibilityAnalysisConfiguration.dataInputV.monitorDataFileOldAlgorithm = batchVisibility.monitorDataFileOldAlgorithm;
                        visibilityAnalysisConfiguration.dataInputV.monitorDataFileNewAlgorithm = batchVisibility.monitorDataFileNewAlgorithm;
                        visibilityAnalysisConfiguration.dataInputV.baselineModelDataFile = batchVisibility.baselineModelDataFile;
                        visibilityAnalysisConfiguration.dataInputV.forecastModelDataFile = batchVisibility.forecastModelDataFile;

                        visibilityAnalysisConfiguration.dataInputV.forecastIMPROVEDataFile = batchVisibility.forecastIMPROVEDataFile;
                        visibilityAnalysisConfiguration.dataInputV.isCreateForecastIMPROVEData = batchVisibility.isCreateForecastIMPROVEData;
                        visibilityAnalysisConfiguration.dataInputV.isCheckedForecastIMPROVEAdvanced = batchVisibility.isCheckedForecastIMPROVEAdvanced;

                        visibilityAnalysisConfiguration.dataInputV.temporalAdjustmentAtMonitorGrid = batchVisibility.temporalAdjustmentAtMonitorGrid;
                        visibilityAnalysisConfiguration.filteringV = new FilteringV();
                        visibilityAnalysisConfiguration.filteringV.startMonitorYear = batchVisibility.startMonitorYear;
                        visibilityAnalysisConfiguration.filteringV.endMonitorYear = batchVisibility.endMonitorYear;
                        visibilityAnalysisConfiguration.filteringV.baseModelYear = batchVisibility.baseModelYear;
                        visibilityAnalysisConfiguration.filteringV.minYearsForValidVisibilityMonitors = batchVisibility.minYearsForValidVisibilityMonitors;
                        //-------------RunProject---------------
                        SMAT_CE mats = new SMAT_CE();
                        mats.btnSaveRun_Click(null, null);
                    }
                    catch (Exception ex)
                    {
                        //---------写错误日志
                        WriteBatchLogFile("Wrong Batch :" + ex.Message, strFile + ".log");
                        for (int j = 1; j < batchBase.BatchText.Count; j++)
                        {
                            WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                        }
                    }
                    #endregion
                }
                else if (batchBase is BatchSSIAAnnual)
                {
                    #region
                    try
                    {
                        CommonClass.CurrentAnalysis = enumAnalysis.SSIAAnnualPM;
                        BatchSSIAAnnual batchSSIAAnnual = batchBase as BatchSSIAAnnual;
                        if (CommonClass.CurrentBaseScenario == null)
                            CommonClass.CurrentBaseScenario = new BaseScenario();
                        CommonClass.CurrentBaseScenario.configuration = new SSIAAnnualPMAnalysisConfiguration();
                        CommonClass.CurrentBaseScenario.configuration.configurationName = batchSSIAAnnual.scenarioName;
                        SSIAAnnualPMAnalysisConfiguration annualSSIAAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration;
                        annualSSIAAnalysisConfiguration.analysisOptionA = new SSIAAnalysisOption();
                        annualSSIAAnalysisConfiguration.analysisOptionA.scenarioName = batchSSIAAnnual.scenarioName;
                        annualSSIAAnalysisConfiguration.analysisOptionA.useModelData = true;
                        annualSSIAAnalysisConfiguration.analysisOptionA.useModelFRMData = batchSSIAAnnual.doCumulativeImpactAnalysis;
                        annualSSIAAnalysisConfiguration.analysisOptionA.useGridAndDispersion = batchSSIAAnnual.useGridAndDispersion;
                        annualSSIAAnalysisConfiguration.analysisOptionA.useGridOnly = batchSSIAAnnual.useGridOnly;
                        annualSSIAAnalysisConfiguration.analysisOptionA.useDispersionOnly = batchSSIAAnnual.useDispersionOnly;
                        annualSSIAAnalysisConfiguration.modelInputA = new SSIAModelDataInputA();
                        annualSSIAAnalysisConfiguration.modelInputA.DailyModelDataInput = batchSSIAAnnual.doDailyModelDataInput;
                        annualSSIAAnalysisConfiguration.modelInputA.QuarterlyModelDataInput = batchSSIAAnnual.doQuarterlyModelDataInput;
                        annualSSIAAnalysisConfiguration.modelInputA.InputFromCMAQ = batchSSIAAnnual.doInputFromCmaq;
                        annualSSIAAnalysisConfiguration.modelInputA.baselineModelDataFile = batchSSIAAnnual.baselineModelDataFile;
                        annualSSIAAnalysisConfiguration.modelInputA.alternativeScenarioFile = batchSSIAAnnual.alternativeModelDataFile;
                        annualSSIAAnalysisConfiguration.modelInputA.dispersionFile = batchSSIAAnnual.dispersionFile;
                        if (annualSSIAAnalysisConfiguration.analysisOptionA.useModelFRMData)
                        {
                            annualSSIAAnalysisConfiguration.monitorInputA = new SSIAMonitorDataInputA();
                            annualSSIAAnalysisConfiguration.monitorInputA.officialMonitorDataFile = batchSSIAAnnual.officialDataFile;
                            annualSSIAAnalysisConfiguration.monitorInputA.monitorDataStartYear = batchSSIAAnnual.officialPM25StartYear;
                            annualSSIAAnalysisConfiguration.monitorInputA.monitorDataEndYear = batchSSIAAnnual.officialPM25EndYear;
                            annualSSIAAnalysisConfiguration.monitorInputA.useVNA = batchSSIAAnnual.doVNA;
                            annualSSIAAnalysisConfiguration.monitorInputA.useEVNA = batchSSIAAnnual.doEVNA;
                            annualSSIAAnalysisConfiguration.monitorInputA.temporalAdjustmentAtMonitorGrid = batchSSIAAnnual.temporalAdjustmentAtMonitorGrid;
                        }
                        annualSSIAAnalysisConfiguration.calculationOption = new SSIACalculationOption();
                        annualSSIAAnalysisConfiguration.calculationOption.NAAQS = batchSSIAAnnual.NAAQS;
                        annualSSIAAnalysisConfiguration.calculationOption.threshold = batchSSIAAnnual.threshold;
                        annualSSIAAnalysisConfiguration.calculationOption.startPercentage = batchSSIAAnnual.startPercentage;
                        annualSSIAAnalysisConfiguration.calculationOption.endPercentage = batchSSIAAnnual.endPercentage;
                        //-------------RunProject---------------
                        SMAT_CE mats = new SMAT_CE();
                        mats.btnSaveRun_Click(null, null);
                    }
                    catch (Exception ex)
                    {
                        //---------写错误日志
                        WriteBatchLogFile("Wrong Batch :" + ex.Message, strFile + ".log");
                        for (int j = 1; j < batchBase.BatchText.Count; j++)
                        {
                            WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                        }
                    }
                    #endregion
                }
                else if (batchBase is BatchSSIADaily)
                {
                    #region
                    try
                    {
                        CommonClass.CurrentAnalysis = enumAnalysis.SSIADailyPM;
                        BatchSSIADaily batchSSIADaily = batchBase as BatchSSIADaily;
                        if (CommonClass.CurrentBaseScenario == null)
                            CommonClass.CurrentBaseScenario = new BaseScenario();
                        CommonClass.CurrentBaseScenario.configuration = new SSIADailyPMAnalysisConfiguration();
                        CommonClass.CurrentBaseScenario.configuration.configurationName = batchSSIADaily.scenarioName;
                        SSIADailyPMAnalysisConfiguration dailySSIAAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration;
                        dailySSIAAnalysisConfiguration.analysisOptionD = new SSIAAnalysisOption();
                        dailySSIAAnalysisConfiguration.analysisOptionD.scenarioName = batchSSIADaily.scenarioName;
                        dailySSIAAnalysisConfiguration.analysisOptionD.useModelData = true;
                        dailySSIAAnalysisConfiguration.analysisOptionD.useModelFRMData = batchSSIADaily.doCumulativeImpactAnalysis;
                        dailySSIAAnalysisConfiguration.analysisOptionD.useGridAndDispersion = batchSSIADaily.useGridAndDispersion;
                        dailySSIAAnalysisConfiguration.analysisOptionD.useGridOnly = batchSSIADaily.useGridOnly;
                        dailySSIAAnalysisConfiguration.analysisOptionD.useDispersionOnly = batchSSIADaily.useDispersionOnly;
                        dailySSIAAnalysisConfiguration.modelInputD = new SSIAModelDataInputD();
                        dailySSIAAnalysisConfiguration.modelInputD.DailyModelDataInput = batchSSIADaily.doDailyModelDataInput;
                        dailySSIAAnalysisConfiguration.modelInputD.QuarterlyModelDataInput = batchSSIADaily.doQuarterlyModelDataInput;
                        dailySSIAAnalysisConfiguration.modelInputD.InputFromCMAQ = batchSSIADaily.doInputFromCmaq;
                        dailySSIAAnalysisConfiguration.modelInputD.baselineModelDataFile = batchSSIADaily.baselineModelDataFile;
                        dailySSIAAnalysisConfiguration.modelInputD.alternativeScenarioFile = batchSSIADaily.alternativeModelDataFile;
                        dailySSIAAnalysisConfiguration.modelInputD.dispersionFile = batchSSIADaily.dispersionFile;
                        if (dailySSIAAnalysisConfiguration.analysisOptionD.useModelFRMData)
                        {
                            dailySSIAAnalysisConfiguration.monitorInputD = new SSIAMonitorDataInputD();
                            dailySSIAAnalysisConfiguration.monitorInputD.officialMonitorDataFile = batchSSIADaily.officialDataFile;
                            dailySSIAAnalysisConfiguration.monitorInputD.monitorDataStartYear = batchSSIADaily.monitorDataStartYear;
                            dailySSIAAnalysisConfiguration.monitorInputD.monitorDataEndYear = batchSSIADaily.monitorDataEndYear;
                            dailySSIAAnalysisConfiguration.monitorInputD.useVNA = batchSSIADaily.useVNA;
                            dailySSIAAnalysisConfiguration.monitorInputD.useEVNA = batchSSIADaily.useEVNA;
                        }
                        //dailySSIAAnalysisConfiguration.modelInputD.temporalAdjustmentAtMonitorGridPoint = batchSSIADaily.temporalAdjustmentAtMonitorGridPoint;
                        //dailySSIAAnalysisConfiguration.modelInputD.temporalAdjustmentAtMonitorGridSpatial = batchSSIADaily.temporalAdjustmentAtMonitorGridSpatial;
                        //dailySSIAAnalysisConfiguration.modelInputD.temporalAdjustmentType = batchSSIADaily.temporalAdjustmentType;
                        //dailySSIAAnalysisConfiguration.modelInputD.RRF_DoUseAllModelDaysGreaterThan = batchSSIADaily.RRF_DoUseAllModelDaysGreaterThan;
                        //dailySSIAAnalysisConfiguration.modelInputD.RRF_DoUseTopXNumber = batchSSIADaily.RRF_DoUseTopXNumber;
                        //dailySSIAAnalysisConfiguration.modelInputD.RRF_DoUseXTopPercent = batchSSIADaily.RRF_DoUseXTopPercent;
                        //dailySSIAAnalysisConfiguration.modelInputD.RRF_MinumumNumberOfDaysRequiredAboveFixedAmount = batchSSIADaily.RRF_MinumumNumberOfDaysRequiredAboveFixedAmount;
                        //dailySSIAAnalysisConfiguration.modelInputD.RRF_UseAllModelDaysGreaterThan = batchSSIADaily.RRF_UseAllModelDaysGreaterThan;
                        //dailySSIAAnalysisConfiguration.modelInputD.RRF_UseTopXNumber = batchSSIADaily.RRF_UseTopXNumber;
                        //dailySSIAAnalysisConfiguration.modelInputD.RRF_UseXTopPercent = batchSSIADaily.RRF_UseXTopPercent;
                        dailySSIAAnalysisConfiguration.calculationOption = new SSIACalculationOption();
                        dailySSIAAnalysisConfiguration.calculationOption.NAAQS = batchSSIADaily.NAAQS;
                        dailySSIAAnalysisConfiguration.calculationOption.threshold = batchSSIADaily.threshold;
                        dailySSIAAnalysisConfiguration.calculationOption.startPercentage = batchSSIADaily.startPercentage;
                        dailySSIAAnalysisConfiguration.calculationOption.endPercentage = batchSSIADaily.endPercentage;
                        //-------------RunProject---------------
                        SMAT_CE mats = new SMAT_CE();
                        mats.btnSaveRun_Click(null, null);
                    }
                    catch (Exception ex)
                    {
                        //---------写错误日志
                        WriteBatchLogFile("Wrong Batch :" + ex.Message, strFile + ".log");
                        for (int j = 1; j < batchBase.BatchText.Count; j++)
                        {
                            WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                        }
                    }
                    #endregion
                }
                else if (batchBase is BatchSSIAOzone)
                {
                    #region
                    try
                    {
                        CommonClass.CurrentAnalysis = enumAnalysis.SSIAOzone;
                        BatchSSIAOzone batchSSIAOzone = batchBase as BatchSSIAOzone;
                        if (CommonClass.CurrentBaseScenario == null)
                            CommonClass.CurrentBaseScenario = new BaseScenario();
                        CommonClass.CurrentBaseScenario.configuration = new SSIAOzoneAnalysisConfiguration();
                        CommonClass.CurrentBaseScenario.configuration.configurationName = batchSSIAOzone.scenarioName;
                        SSIAOzoneAnalysisConfiguration ozoneSSIAAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration;
                        ozoneSSIAAnalysisConfiguration.analysisOptionO = new SSIAAnalysisOption();
                        ozoneSSIAAnalysisConfiguration.analysisOptionO.scenarioName = batchSSIAOzone.scenarioName;
                        ozoneSSIAAnalysisConfiguration.analysisOptionO.useModelData = true;
                        ozoneSSIAAnalysisConfiguration.analysisOptionO.useModelFRMData = batchSSIAOzone.doCumulativeImpactAnalysis;
                        ozoneSSIAAnalysisConfiguration.modelInputO = new SSIAModelDataInputO();
                        ozoneSSIAAnalysisConfiguration.modelInputO.doInputfromCmaq = batchSSIAOzone.doInputFromCmaq;
                        ozoneSSIAAnalysisConfiguration.modelInputO.baselineModelDataFile = batchSSIAOzone.baselineModelDataFile;
                        ozoneSSIAAnalysisConfiguration.modelInputO.forecastModelDataFile = batchSSIAOzone.alternativeModelDataFile;
                        if (ozoneSSIAAnalysisConfiguration.analysisOptionO.useModelFRMData)
                        {
                            ozoneSSIAAnalysisConfiguration.monitorInputO = new SSIAMonitorDataInputO();
                            ozoneSSIAAnalysisConfiguration.monitorInputO.ozoneMonitorDataFile = batchSSIAOzone.monitorDataFile;
                            ozoneSSIAAnalysisConfiguration.monitorInputO.ozoneStartYear = batchSSIAOzone.ozoneStartYear;
                            ozoneSSIAAnalysisConfiguration.monitorInputO.ozoneEndYear = batchSSIAOzone.ozoneEndYear;
                            ozoneSSIAAnalysisConfiguration.monitorInputO.useVNA = batchSSIAOzone.doVNA;
                            ozoneSSIAAnalysisConfiguration.monitorInputO.useEVNA = batchSSIAOzone.doEVNA;
                            ozoneSSIAAnalysisConfiguration.monitorInputO.temporalAdjustmentAtMonitorGrid = batchSSIAOzone.temporalAdjustmentAtMonitorGrid;
                            ozoneSSIAAnalysisConfiguration.monitorInputO.temporalAdjustmentType = batchSSIAOzone.temporalAdjustmentType;
                        }
                        ozoneSSIAAnalysisConfiguration.calculationOption = new SSIACalculationOption();
                        ozoneSSIAAnalysisConfiguration.calculationOption.NAAQS = batchSSIAOzone.NAAQS;
                        ozoneSSIAAnalysisConfiguration.calculationOption.threshold = batchSSIAOzone.threshold;
                        ozoneSSIAAnalysisConfiguration.calculationOption.startPercentage = batchSSIAOzone.startPercentage;
                        ozoneSSIAAnalysisConfiguration.calculationOption.endPercentage = batchSSIAOzone.endPercentage;
                        //-------------RunProject---------------
                        SMAT_CE mats = new SMAT_CE();
                        mats.btnSaveRun_Click(null, null);
                    }

                    catch (Exception ex)
                    {
                        //---------写错误日志
                        WriteBatchLogFile("Wrong Batch :" + ex.Message, strFile + ".log");
                        for (int j = 1; j < batchBase.BatchText.Count; j++)
                        {
                            WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                        }
                    }
                    #endregion
                }
                else if (batchBase is BatchSSIADeposition)    //added by Lijiabin
                {
                    #region
                    try
                    {
                        CommonClass.CurrentAnalysis = enumAnalysis.SSIADeposition;
                        BatchSSIADeposition batchSSIADeposition = batchBase as BatchSSIADeposition;
                        if (CommonClass.CurrentBaseScenario == null)
                            CommonClass.CurrentBaseScenario = new BaseScenario();
                        CommonClass.CurrentBaseScenario.configuration = new SSIADepositionConfiguration();
                        CommonClass.CurrentBaseScenario.configuration.configurationName = batchSSIADeposition.scenarioName;
                        SSIADepositionConfiguration depositionSSIAAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration;
                        depositionSSIAAnalysisConfiguration.analysisOptionDep = new SSIAAnalysisOption();
                        depositionSSIAAnalysisConfiguration.analysisOptionDep.scenarioName = batchSSIADeposition.scenarioName;
                        depositionSSIAAnalysisConfiguration.analysisOptionDep.useModelData = true;
                        depositionSSIAAnalysisConfiguration.modelInputDep = new SSIAModelDataInputDep();
                        depositionSSIAAnalysisConfiguration.modelInputDep.baselineModelDataFile = batchSSIADeposition.baselineModelDataFile;
                        depositionSSIAAnalysisConfiguration.modelInputDep.alternativeScenarioFile = batchSSIADeposition.alternativeModelDataFile;
                        depositionSSIAAnalysisConfiguration.calculationOption = new SSIACalculationOption();
                        //depositionSSIAAnalysisConfiguration.calculationOption.NAAQS = batchSSIADeposition.NAAQS;
                        depositionSSIAAnalysisConfiguration.calculationOption.threshold = batchSSIADeposition.threshold;
                        //-------------RunProject---------------
                        SMAT_CE mats = new SMAT_CE();
                        mats.btnSaveRun_Click(null, null);
                    }

                    catch (Exception ex)
                    {
                        //---------写错误日志
                        WriteBatchLogFile("Wrong Batch :" + ex.Message, strFile + ".log");
                        for (int j = 1; j < batchBase.BatchText.Count; j++)
                        {
                            WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                        }
                    }
                    #endregion
                }
                else if (batchBase is BatchAnnualPMChina)
                {
                    #region
                    try
                    {
                        CommonClass.CurrentAnalysis = enumAnalysis.AnnualPMChina;
                        BatchAnnualPMChina batchAnnualChina = batchBase as BatchAnnualPMChina;
                        if (CommonClass.CurrentBaseScenario == null)
                            CommonClass.CurrentBaseScenario = new BaseScenario();
                        CommonClass.CurrentBaseScenario.configuration = new AnnualPMAnalysisChinaConfiguration();
                        CommonClass.CurrentBaseScenario.configuration.configurationName = batchAnnualChina.scenarioName;
                        AnnualPMAnalysisChinaConfiguration annualConfiguration = CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration;
                        annualConfiguration.modelDataInputChina = new ModelDataInputChina();
                        annualConfiguration.modelDataInputChina.scenarioName = batchAnnualChina.scenarioName;
                        annualConfiguration.modelDataInputChina.doDailyAverageDataInput = batchAnnualChina.doDailyModelDataInput;
                        annualConfiguration.modelDataInputChina.doQuarterlyAverageDataInput = batchAnnualChina.doQuarterlyModelDataInput;
                        annualConfiguration.modelDataInputChina.doInputFromCMAQ = batchAnnualChina.doInputFromCmaq;
                        annualConfiguration.modelDataInputChina.BaselineModelDataFile = batchAnnualChina.baselineModelDataFile;
                        annualConfiguration.modelDataInputChina.ControlModelDataFile = batchAnnualChina.futureModelDataFile;
                        annualConfiguration.modelDataInputChina.temporalAdjustmentAtMonitorGridPoint = batchAnnualChina.temporalAdjustmentAtMonitorGrid;
                        annualConfiguration.monitorDataInputChina = new MonitorDataInputChina();
                        annualConfiguration.monitorDataInputChina.doDailyMonitorDataInput = batchAnnualChina.doDailyMonitorDataInput;
                        annualConfiguration.monitorDataInputChina.doQuarterlyMonitorDataInput = batchAnnualChina.doQuarterlyMonitorDataInput;
                        annualConfiguration.monitorDataInputChina.MonitorDataInputFile = batchAnnualChina.PMMonitorDataFile;
                        annualConfiguration.monitorDataInputChina.MonitorDataStartYear = batchAnnualChina.monitorStartYear;
                        annualConfiguration.monitorDataInputChina.MonitorDataEndYear = batchAnnualChina.monitorEndYear;
                        annualConfiguration.monitorDataInputChina.doInterpolateFRM = batchAnnualChina.doVNA;
                        annualConfiguration.monitorDataInputChina.doInterpolateAdjustedFRM = batchAnnualChina.doEVNA;
                        annualConfiguration.pm25SpeciesOptionChina = new PM25SpeciesOptionChina();
                        annualConfiguration.pm25SpeciesOptionChina.PM25SpeciesFractionDataAvailable = batchAnnualChina.PM25SpeciesFractionDataAvailable;
                        annualConfiguration.pm25SpeciesOptionChina.SpeciesMonitorDataFile = batchAnnualChina.SpeciesMonitorDataFile;
                        //-------------RunProject---------------
                        SMAT_CE mats = new SMAT_CE();
                        //mats.LoadProject(@"C:\Users\esil\Documents\My SMAT-CE Files\Result\Project\cannual.proj");
                        mats.btnSaveRun_Click(null, null);
                        //----------------modify by xiejp---------------------------------------To benmap-------------

                        string strFileSpatialFiled = " Annual PM25 Spatial Field.csv";
                        string strFileGradSpatialField = " Grad Adj Annual PM25 Spatial Field.csv";
                        string strPath = "";
                        if (batchAnnualChina.doEVNA)
                        {
                            strPath = CommonClass.CurrentBaseScenario.lstOutput.Where(p => p.outputFilePath.Contains(strFileGradSpatialField)).First().outputFilePath;

                        }
                        else
                        {
                            strPath = CommonClass.CurrentBaseScenario.lstOutput.Where(p => p.outputFilePath.Contains(strFileSpatialFiled)).First().outputFilePath;
                        }
                        bool hasBenMapReadyFile = false;
                        string sourceBaseFile = Path.GetDirectoryName(strPath) + @"\BenMAP-ready PM25 Spatial Field Base (eVNA).csv";
                        string sourceControlFile = Path.GetDirectoryName(strPath) + @"\BenMAP-ready PM25 Spatial Field Future (eVNA).csv";
                        string destinationBaseFile = Path.GetDirectoryName(strPath) + @"\benmapBase.csv";
                        string destinationControlFile = Path.GetDirectoryName(strPath) + @"\benmapControl.csv";

                        if (File.Exists(sourceBaseFile) && File.Exists(sourceControlFile))
                        {
                            System.IO.File.Copy(sourceBaseFile, destinationBaseFile, true);
                            System.IO.File.Copy(sourceControlFile, destinationControlFile, true);
                            hasBenMapReadyFile = true;
                        }
                        if (!hasBenMapReadyFile)//不存在BenMAP-ready PM25 Spatial Field Future (eVNA).csv用传统方法解析生成
                        {
                            #region read shape file

                            Dictionary<double[], int[]> dic = new Dictionary<double[], int[]>();
                            IFeatureSet fs = FeatureSet.Open(batchAnnualChina.gridDefinitionFile);
                            if (!fs.AttributesPopulated) fs.FillAttributes();
                            Dictionary<string, int[]> dicColRow = new Dictionary<string, int[]>();
                            int iCol = -1;
                            int iRow = -1;
                            string columnName = "";
                            for (int i = 0; i < fs.DataTable.Columns.Count; i++)
                            {
                                columnName = fs.DataTable.Columns[i].ToString().ToLower().Trim();
                                switch (columnName)
                                {
                                    case "row":
                                        iRow = i;
                                        break;
                                    case "column":
                                    case "col":
                                        iCol = i;
                                        break;
                                }
                            }

                            if (iCol != -1 && iRow != -1)
                            {
                                foreach (IFeature f in fs.Features)
                                {
                                    dic.Add(new double[2] { f.Centroid().Coordinates.First().X, f.Centroid().Coordinates.First().Y }, new int[2] { Convert.ToInt16(f.DataRow[iCol]), Convert.ToInt16(f.DataRow[iRow]) });
                                }
                            }
                            #endregion

                            OutputPMDataForBenMAP(strPath, dic);
                        }
                        #region remove to OutputPMDataForBenMAP

                        /*
                        string strFirstLine = "";
                        bool errorOccur = false;
                        DataTable dt = CommonClass.getDataSetFromCSVAndFirstLine(strPath, ref strFirstLine, ref  errorOccur);
                        List<string> lstStringOutputb = new List<string>();
                        lstStringOutputb.Add("Column,Row,Metric,Seasonal Metric,Statistic,Values");
                        List<string> lstStringOutputc = new List<string>();
                        lstStringOutputc.Add("Column,Row,Metric,Seasonal Metric,Statistic,Values");
                        //Dictionary<string, Dictionary<string, double>> dicOutput = new Dictionary<string, Dictionary<string, double>>();
                        int iLat = 0, iLong = 0, iPM25b = 0, iPM25c = 0, iQuarter = 0, iID = 0;
                        foreach (DataColumn dc in dt.Columns)
                        {
                            switch (dc.ColumnName.ToLower().Trim())
                            {
                                case "gridcell_lat":
                                    iLat = dt.Columns.IndexOf(dc);
                                    break;
                                case "gridcell_long":
                                    iLong = dt.Columns.IndexOf(dc);
                                    break;
                                case "b_pm25_ann_dv_ga":
                                case "b_pm25_ann_dv":
                                    iPM25b = dt.Columns.IndexOf(dc);
                                    break;
                                case "f_pm25_ann_dv_ga":
                                case "f_pm25_ann_dv":
                                    iPM25c = dt.Columns.IndexOf(dc);
                                    break;
                                case "quarter":
                                    iQuarter = dt.Columns.IndexOf(dc);
                                    break;
                                case "_id":
                                    iID = dt.Columns.IndexOf(dc);
                                    break;
                            }
                        }
                        foreach (DataRow dr in dt.Rows)
                        {
                            if (dicColRow.ContainsKey(dr[iID].ToString())) continue;
                            var q = dic.Where(p => Math.Abs(Convert.ToDouble(dr[iLong]) - p.Key[0]) <= 0.1 && Math.Abs(Convert.ToDouble(dr[iLat]) - p.Key[1]) <= 0.1).ToList();
                            if (q.Count >= 0)
                            {
                                var v = q.OrderBy(p => Math.Pow(Convert.ToDouble(dr[iLong]) - p.Key[0], 2) + Math.Pow(Convert.ToDouble(dr[iLat]) - p.Key[1], 2)).First();
                                dicColRow.Add(dr[iID].ToString(), new int[2] { v.Value[0], v.Value[1] });
                            }
                            else
                            {
                                var v = dic.OrderBy(p => Math.Pow(Convert.ToDouble(dr[iLong]) - p.Key[0], 2) + Math.Pow(Convert.ToDouble(dr[iLat]) - p.Key[1], 2)).ToList().First();
                                dicColRow.Add(dr[iID].ToString(), new int[2] { v.Value[0], v.Value[1] });
                            }
                        }
                        foreach (DataRow dr in dt.Rows)
                        {
                            lstStringOutputb.Add(string.Format("{0},{1},{2},{3},{4}", dicColRow[dr[iID].ToString()][0] + "," + dicColRow[dr[iID].ToString()][1], "D24HourMean", "QuarterlyMean", "Mean", Convert.ToDouble(dr[iPM25b])));
                            lstStringOutputc.Add(string.Format("{0},{1},{2},{3},{4}", dicColRow[dr[iID].ToString()][0] + "," + dicColRow[dr[iID].ToString()][1], "D24HourMean", "QuarterlyMean", "Mean", Convert.ToDouble(dr[iPM25c])));

                            //if (dicOutput.ContainsKey(dicColRow[dr[iID].ToString()][0] + "," + dicColRow[dr[iID].ToString()][1]))
                            //{
                            //    dicOutput[dicColRow[dr[iID].ToString()][0] + "," + dicColRow[dr[iID].ToString()][1]].Add(dr[iQuarter].ToString(), Convert.ToDouble(dr[iPM25]));
                            //}
                            //else
                            //{
                            //    dicOutput.Add(dicColRow[dr[iID].ToString()][0] + "," + dicColRow[dr[iID].ToString()][1], new Dictionary<string, double>());
                            //    dicOutput[dicColRow[dr[iID].ToString()][0] + "," + dicColRow[dr[iID].ToString()][1]].Add(dr[iQuarter].ToString(), Convert.ToDouble(dr[iPM25]));
                            //}
                        }
                        //foreach (KeyValuePair<string, Dictionary<string, double>> k in dicOutput)
                        //{
                        //    lstStringOutputb.Add(string.Format("{0},{1},{2},{3},{4}", k.Key, "D24HourMean", "QuarterlyMean", "Mean", k.Value.Values.Average()));
                        //}
                        //----------------输出--------------------未完成！---------------------------
                        //if (!Directory.Exists(Path.GetDirectoryName(strScriptPath)))
                        //{
                        //    Directory.CreateDirectory(Path.GetDirectoryName(strScriptPath));
                        //}
                        //System.IO.StreamWriter sw = new System.IO.StreamWriter(strScriptPath, false);
                        string strPathB = Path.GetDirectoryName(strPath) + @"\benmapBase.csv";
                        string strPathC = Path.GetDirectoryName(strPath) + @"\benmapControl.csv";
                        System.IO.StreamWriter swB = new System.IO.StreamWriter(strPathB, false);
                        foreach (string s in lstStringOutputb)
                        {
                            swB.WriteLine(s);
                        }
                        swB.Flush();

                        System.IO.StreamWriter swC = new System.IO.StreamWriter(strPathC, false);
                        foreach (string s in lstStringOutputc)
                        {
                            swC.WriteLine(s);
                        }
                        swC.Flush();
                    * */
                        #endregion remove to OutputPMDataForBenMAP
                    }
                    catch (Exception ex)
                    {
                        //---------写错误日志
                        WriteBatchLogFile("Wrong Batch :" + ex.Message, strFile + ".log");
                        for (int j = 1; j < batchBase.BatchText.Count; j++)
                        {
                            WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                        }
                    }
                    #endregion
                }
                else if (batchBase is BatchAnnualPMOther)
                {
                    #region
                    try
                    {
                        CommonClass.CurrentAnalysis = enumAnalysis.AnnualPMOther;
                        BatchAnnualPMOther batchAnnualOther = batchBase as BatchAnnualPMOther;
                        if (CommonClass.CurrentBaseScenario == null)
                            CommonClass.CurrentBaseScenario = new BaseScenario();
                        CommonClass.CurrentBaseScenario.configuration = new AnnualPMAnalysisChinaConfiguration();
                        CommonClass.CurrentBaseScenario.configuration.configurationName = batchAnnualOther.scenarioName;
                        AnnualPMAnalysisChinaConfiguration annualConfiguration = CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration;
                        annualConfiguration.modelDataInputChina = new ModelDataInputChina();
                        annualConfiguration.modelDataInputChina.scenarioName = batchAnnualOther.scenarioName;
                        annualConfiguration.modelDataInputChina.doDailyAverageDataInput = batchAnnualOther.doDailyModelDataInput;
                        annualConfiguration.modelDataInputChina.doQuarterlyAverageDataInput = batchAnnualOther.doQuarterlyModelDataInput;
                        annualConfiguration.modelDataInputChina.doInputFromCMAQ = batchAnnualOther.doInputFromCmaq;
                        annualConfiguration.modelDataInputChina.BaselineModelDataFile = batchAnnualOther.baselineModelDataFile;
                        annualConfiguration.modelDataInputChina.ControlModelDataFile = batchAnnualOther.futureModelDataFile;
                        annualConfiguration.monitorDataInputChina = new MonitorDataInputChina();
                        annualConfiguration.monitorDataInputChina.doDailyMonitorDataInput = batchAnnualOther.doDailyMonitorDataInput;
                        annualConfiguration.monitorDataInputChina.doQuarterlyMonitorDataInput = batchAnnualOther.doQuarterlyMonitorDataInput;
                        annualConfiguration.monitorDataInputChina.MonitorDataInputFile = batchAnnualOther.PMMonitorDataFile;
                        annualConfiguration.monitorDataInputChina.MonitorDataStartYear = batchAnnualOther.monitorStartYear;
                        annualConfiguration.monitorDataInputChina.MonitorDataEndYear = batchAnnualOther.monitorEndYear;
                        annualConfiguration.monitorDataInputChina.doInterpolateFRM = batchAnnualOther.doVNA;
                        annualConfiguration.monitorDataInputChina.doInterpolateAdjustedFRM = batchAnnualOther.doEVNA;
                        annualConfiguration.pm25SpeciesOptionChina = new PM25SpeciesOptionChina();
                        annualConfiguration.pm25SpeciesOptionChina.PM25SpeciesFractionDataAvailable = batchAnnualOther.PM25SpeciesFractionDataAvailable;
                        annualConfiguration.pm25SpeciesOptionChina.SpeciesMonitorDataFile = batchAnnualOther.SpeciesMonitorDataFile;
                        //-------------RunProject---------------
                        SMAT_CE mats = new SMAT_CE();
                        //mats.LoadProject(@"C:\Users\esil\Documents\My SMAT-CE Files\Result\Project\cannual.proj");
                        mats.btnSaveRun_Click(null, null);
                        //----------------modify by xiejp---------------------------------------To benmap-------------
                        #region read shape file
                        Dictionary<double[], int[]> dic = new Dictionary<double[], int[]>();
                        IFeatureSet fs = FeatureSet.Open(batchAnnualOther.gridDefinitionFile);
                        if (!fs.AttributesPopulated) fs.FillAttributes();
                        //change projection
                        //fs.Projection = DotSpatial.Projections.KnownCoordinateSystems.Geographic.World.WGS1984;
                        //fs.Reproject(DotSpatial.Projections.ProjectionInfo.FromProj4String(CommonClass.projUSACMAQ));
                        Dictionary<string, int[]> dicColRow = new Dictionary<string, int[]>();

                        foreach (IFeature f in fs.Features)
                        {
                            dic.Add(new double[2] { f.Centroid().Coordinates.First().X, f.Centroid().Coordinates.First().Y }, new int[2] { Convert.ToInt16(f.DataRow["COL"]), Convert.ToInt16(f.DataRow["ROW"]) });
                        }


                        #endregion

                        string strFileSpatialFiled = " Annual PM25 Spatial Field.csv";
                        string strFileGradSpatialField = " Grad Adj Annual PM25 Spatial Field.csv";
                        string strPath = "";
                        if (batchAnnualOther.doEVNA)
                        {
                            strPath = CommonClass.CurrentBaseScenario.lstOutput.Where(p => p.outputFilePath.Contains(strFileGradSpatialField)).First().outputFilePath;

                        }
                        else
                        {
                            strPath = CommonClass.CurrentBaseScenario.lstOutput.Where(p => p.outputFilePath.Contains(strFileSpatialFiled)).First().outputFilePath;

                        }
                        OutputPMDataForBenMAP(strPath, dic);
                    }
                    catch (Exception ex)
                    {
                        //---------写错误日志
                        WriteBatchLogFile("Wrong Batch :" + ex.Message, strFile + ".log");
                        for (int j = 1; j < batchBase.BatchText.Count; j++)
                        {
                            WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                        }
                    }
                    #endregion
                }
                else if (batchBase is BatchOzoneOther)
                {
                    #region
                    try
                    {
                        CommonClass.CurrentAnalysis = enumAnalysis.OzoneOther;
                        BatchOzoneOther batchOzone = batchBase as BatchOzoneOther;
                        if (CommonClass.CurrentBaseScenario == null)
                            CommonClass.CurrentBaseScenario = new BaseScenario();
                        CommonClass.CurrentBaseScenario.configuration = new OzoneAnalysisChinaConfiguration();
                        CommonClass.CurrentBaseScenario.configuration.configurationName = batchOzone.scenarioName;
                        OzoneAnalysisChinaConfiguration ozoneSSIAAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration;
                        ozoneSSIAAnalysisConfiguration.modelDataOzoneChina = new ModelDataOzoneChina();
                        ozoneSSIAAnalysisConfiguration.modelDataOzoneChina.scenarioName = batchOzone.scenarioName;
                        ozoneSSIAAnalysisConfiguration.modelDataOzoneChina.doInputfromCmaq = batchOzone.doInputfromCmaq;
                        ozoneSSIAAnalysisConfiguration.modelDataOzoneChina.baselineModelDataFile = batchOzone.baselineModelDataFile;
                        ozoneSSIAAnalysisConfiguration.modelDataOzoneChina.forecastModelDataFile = batchOzone.forecastModelDataFile;
                        ozoneSSIAAnalysisConfiguration.monitorDataOzoneChina = new MonitorDataOzoneChina();
                        ozoneSSIAAnalysisConfiguration.monitorDataOzoneChina.ozoneMonitorDataFile = batchOzone.ozoneMonitorDataFile;
                        ozoneSSIAAnalysisConfiguration.monitorDataOzoneChina.ozoneStartYear = batchOzone.ozoneStartYear;
                        ozoneSSIAAnalysisConfiguration.monitorDataOzoneChina.ozoneEndYear = batchOzone.ozoneEndYear;
                        ozoneSSIAAnalysisConfiguration.monitorDataOzoneChina.useVNA = batchOzone.useVNA;
                        ozoneSSIAAnalysisConfiguration.monitorDataOzoneChina.useEVNA = batchOzone.useEVNA;
                        //-------------RunProject---------------
                        SMAT_CE mats = new SMAT_CE();
                        mats.btnSaveRun_Click(null, null);
                    }

                    catch (Exception ex)
                    {
                        //---------写错误日志
                        WriteBatchLogFile("Wrong Batch :" + ex.Message, strFile + ".log");
                        for (int j = 1; j < batchBase.BatchText.Count; j++)
                        {
                            WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                        }
                    }
                    #endregion
                }
                else if (batchBase is BatchOzoneChina)
                {
                    #region
                    try
                    {
                        CommonClass.CurrentAnalysis = enumAnalysis.OzoneChina;
                        BatchOzoneChina batchOzone = batchBase as BatchOzoneChina;
                        if (CommonClass.CurrentBaseScenario == null)
                            CommonClass.CurrentBaseScenario = new BaseScenario();
                        CommonClass.CurrentBaseScenario.configuration = new OzoneAnalysisChinaConfiguration();
                        CommonClass.CurrentBaseScenario.configuration.configurationName = batchOzone.scenarioName;
                        OzoneAnalysisChinaConfiguration ozoneSSIAAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration;
                        ozoneSSIAAnalysisConfiguration.modelDataOzoneChina = new ModelDataOzoneChina();
                        ozoneSSIAAnalysisConfiguration.modelDataOzoneChina.scenarioName = batchOzone.scenarioName;
                        ozoneSSIAAnalysisConfiguration.modelDataOzoneChina.doInputfromCmaq = batchOzone.doInputfromCmaq;
                        ozoneSSIAAnalysisConfiguration.modelDataOzoneChina.baselineModelDataFile = batchOzone.baselineModelDataFile;
                        ozoneSSIAAnalysisConfiguration.modelDataOzoneChina.forecastModelDataFile = batchOzone.forecastModelDataFile;
                        ozoneSSIAAnalysisConfiguration.monitorDataOzoneChina = new MonitorDataOzoneChina();
                        ozoneSSIAAnalysisConfiguration.monitorDataOzoneChina.ozoneMonitorDataFile = batchOzone.ozoneMonitorDataFile;
                        ozoneSSIAAnalysisConfiguration.monitorDataOzoneChina.ozoneStartYear = batchOzone.ozoneStartYear;
                        ozoneSSIAAnalysisConfiguration.monitorDataOzoneChina.ozoneEndYear = batchOzone.ozoneEndYear;
                        ozoneSSIAAnalysisConfiguration.monitorDataOzoneChina.useVNA = batchOzone.useVNA;
                        ozoneSSIAAnalysisConfiguration.monitorDataOzoneChina.useEVNA = batchOzone.useEVNA;
                        //-------------RunProject---------------
                        SMAT_CE mats = new SMAT_CE();
                        mats.btnSaveRun_Click(null, null);
                    }

                    catch (Exception ex)
                    {
                        //---------写错误日志
                        WriteBatchLogFile("Wrong Batch :" + ex.Message, strFile + ".log");
                        for (int j = 1; j < batchBase.BatchText.Count; j++)
                        {
                            WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                        }
                    }
                    #endregion
                }
                else if (batchBase is BatchBenMapOzone)
                {
                    #region
                    try
                    {
                        CommonClass.CurrentAnalysis = enumAnalysis.BenMAPSeasonalOzone;
                        BatchBenMapOzone batchBenMapOzone = batchBase as BatchBenMapOzone;
                        if (CommonClass.CurrentBaseScenario == null)
                            CommonClass.CurrentBaseScenario = new BaseScenario();
                        CommonClass.CurrentBaseScenario.configuration = new BenMAPOzoneAnalysisConfiguration();
                        CommonClass.CurrentBaseScenario.configuration.configurationName = batchBenMapOzone.scenarioName;
                        BenMAPOzoneAnalysisConfiguration ozoneAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration;
                        ozoneAnalysisConfiguration.modelInput = new BenMAPOzoneModel();
                        ozoneAnalysisConfiguration.modelInput.doInputfromCmaq = batchBenMapOzone.doInputFromCmaq;
                        ozoneAnalysisConfiguration.modelInput.baselineModelDataFile = batchBenMapOzone.baselineModelDataFile;
                        ozoneAnalysisConfiguration.modelInput.forecastModelDataFile = batchBenMapOzone.alternativeModelDataFile;

                        ozoneAnalysisConfiguration.monitorInput = new BenMapOzoneMonitor();
                        ozoneAnalysisConfiguration.monitorInput.ozoneMonitorDataFile = batchBenMapOzone.monitorDataFile;
                        ozoneAnalysisConfiguration.monitorInput.ozoneStartYear = batchBenMapOzone.ozoneStartYear;
                        ozoneAnalysisConfiguration.monitorInput.ozoneEndYear = batchBenMapOzone.ozoneEndYear;
                        ozoneAnalysisConfiguration.monitorInput.useVNA = batchBenMapOzone.doVNA;
                        ozoneAnalysisConfiguration.monitorInput.useEVNA = batchBenMapOzone.doEVNA;

                        ozoneAnalysisConfiguration.gridDefinitionFile = batchBenMapOzone.gridDifinition;
                        //ozoneAnalysisConfiguration.monitorInput.temporalAdjustmentAtMonitorGrid = batchBenMapOzone.temporalAdjustmentAtMonitorGrid;
                        //ozoneAnalysisConfiguration.monitorInput.temporalAdjustmentType = batchBenMapOzone.temporalAdjustmentType;

                        //-------------RunProject---------------
                        SMAT_CE mats = new SMAT_CE();
                        mats.btnSaveRun_Click(null, null);
                    }

                    catch (Exception ex)
                    {
                        //---------写错误日志
                        WriteBatchLogFile("Wrong Batch :" + ex.Message, strFile + ".log");
                        for (int j = 1; j < batchBase.BatchText.Count; j++)
                        {
                            WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                        }
                    }
                    #endregion
                }
                else if (batchBase is BatchBenMapAnnualPM)
                {
                    #region
                    try
                    {
                        CommonClass.CurrentAnalysis = enumAnalysis.BenMAPAnnualPM;
                        BatchBenMapAnnualPM batchBenMapAnnualPM = batchBase as BatchBenMapAnnualPM;
                        if (CommonClass.CurrentBaseScenario == null)
                            CommonClass.CurrentBaseScenario = new BaseScenario();
                        CommonClass.CurrentBaseScenario.configuration = new BenMAPAnnualPMAnalysisConfiguration();
                        CommonClass.CurrentBaseScenario.configuration.configurationName = batchBenMapAnnualPM.scenarioName;
                        BenMAPAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration;
                        annualPMAnalysisConfiguration.modelInput = new BenMAPAnnualPMModel();
                        annualPMAnalysisConfiguration.modelInput.scenarioName = batchBenMapAnnualPM.scenarioName;
                        annualPMAnalysisConfiguration.modelInput.doInputfromCMAQ = batchBenMapAnnualPM.doInputFromCmaq;
                        annualPMAnalysisConfiguration.modelInput.baselineFile = batchBenMapAnnualPM.baselineModelDataFile;
                        annualPMAnalysisConfiguration.modelInput.forecastFile = batchBenMapAnnualPM.forecastModelDataFile;
                        annualPMAnalysisConfiguration.modelInput.doQuarterlyModelData = batchBenMapAnnualPM.doQuarterlyModelDataInput;
                        annualPMAnalysisConfiguration.modelInput.doDailyModelData = batchBenMapAnnualPM.doDailyModelDataInput;
                        annualPMAnalysisConfiguration.modelInput.temporalAdjustmentAtMonitorGridSpatial = batchBenMapAnnualPM.temporalAdjustmentAtMonitorGridSpatial;

                        annualPMAnalysisConfiguration.monitorInput = new BenMAPAnnualPMMonitor();
                        annualPMAnalysisConfiguration.monitorInput.unofficialFile = batchBenMapAnnualPM.unofficialMonitorDataFile;
                        annualPMAnalysisConfiguration.monitorInput.startYear = batchBenMapAnnualPM.unofficialStartYear;
                        annualPMAnalysisConfiguration.monitorInput.endYear = batchBenMapAnnualPM.unofficialEndYear;
                        annualPMAnalysisConfiguration.monitorInput.useVNA = batchBenMapAnnualPM.doVNA;
                        annualPMAnalysisConfiguration.monitorInput.useEVNA = batchBenMapAnnualPM.doEVNA;

                        annualPMAnalysisConfiguration.speciesMonitorInput = new BenMAPAnnualPMSpecies();
                        annualPMAnalysisConfiguration.speciesMonitorInput.doSpeciesFractionFile = batchBenMapAnnualPM.doSpeciesFractionFile;
                        annualPMAnalysisConfiguration.speciesMonitorInput.doSpeciesMonitorDataFile = batchBenMapAnnualPM.doSpeciesMonitorDataFile;
                        annualPMAnalysisConfiguration.speciesMonitorInput.gradAdjSpecFracSpatialFile = batchBenMapAnnualPM.gradAdjSpecFracSpatialFile;
                        annualPMAnalysisConfiguration.speciesMonitorInput.specFracSpatialFile = batchBenMapAnnualPM.specFracSpatialFile;
                        annualPMAnalysisConfiguration.speciesMonitorInput.speciesMonitorDataFile = batchBenMapAnnualPM.speciesMonitorDataFile;
                        annualPMAnalysisConfiguration.speciesMonitorInput.startYear = batchBenMapAnnualPM.speciesStartYear;
                        annualPMAnalysisConfiguration.speciesMonitorInput.endYear = batchBenMapAnnualPM.speciesEndYear;

                        annualPMAnalysisConfiguration.gridDefinitionFile = batchBenMapAnnualPM.gridDefinitionFile;
                        //ozoneAnalysisConfiguration.monitorInput.temporalAdjustmentAtMonitorGrid = batchBenMapOzone.temporalAdjustmentAtMonitorGrid;
                        //ozoneAnalysisConfiguration.monitorInput.temporalAdjustmentType = batchBenMapOzone.temporalAdjustmentType;

                        //-------------RunProject---------------
                        SMAT_CE mats = new SMAT_CE();
                        mats.btnSaveRun_Click(null, null);
                    }

                    catch (Exception ex)
                    {
                        //---------写错误日志
                        WriteBatchLogFile("Wrong Batch :" + ex.Message, strFile + ".log");
                        for (int j = 1; j < batchBase.BatchText.Count; j++)
                        {
                            WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                        }
                    }

                    #endregion
                }
                return true;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return false;
            }
        }

        /// <summary>
        /// 导出BenMAP格式数据
        /// add by sclong
        /// 2016-09-12
        /// </summary>
        /// <param name="strPath"></param>
        /// <param name="dic"></param>
        private static void OutputPMDataForBenMAP(string strPath, Dictionary<double[], int[]> dic)
        {
            try
            {
                Dictionary<string, int[]> dicColRow = new Dictionary<string, int[]>();
                string strFirstLine = "";
                bool errorOccur = false;
                DataTable dt = CommonClass.getDataSetFromCSVAndFirstLine(strPath, ref strFirstLine, ref  errorOccur);
                List<string> lstStringOutputb = new List<string>();
                lstStringOutputb.Add("Column,Row,Metric,Seasonal Metric,Statistic,Values");
                List<string> lstStringOutputc = new List<string>();
                lstStringOutputc.Add("Column,Row,Metric,Seasonal Metric,Statistic,Values");
                //Dictionary<string, Dictionary<string, double>> dicOutput = new Dictionary<string, Dictionary<string, double>>();
                int iLat = 0, iLong = 0, iPM25b = 0, iPM25c = 0, iQuarter = 0, iID = 0;
                foreach (DataColumn dc in dt.Columns)
                {
                    switch (dc.ColumnName.ToLower().Trim())
                    {
                        case "gridcell_lat":
                            iLat = dt.Columns.IndexOf(dc);
                            break;
                        case "gridcell_long":
                            iLong = dt.Columns.IndexOf(dc);
                            break;
                        case "b_pm25_ann_dv_ga":
                        case "b_pm25_ann_dv":
                            iPM25b = dt.Columns.IndexOf(dc);
                            break;
                        case "f_pm25_ann_dv_ga":
                        case "f_pm25_ann_dv":
                            iPM25c = dt.Columns.IndexOf(dc);
                            break;
                        case "quarter":
                            iQuarter = dt.Columns.IndexOf(dc);
                            break;
                        case "_id":
                            iID = dt.Columns.IndexOf(dc);
                            break;
                    }
                }
                foreach (DataRow dr in dt.Rows)
                {
                    if (dicColRow.ContainsKey(dr[iID].ToString())) continue;
                    var q = dic.Where(p => Math.Abs(Convert.ToDouble(dr[iLong]) - p.Key[0]) <= 0.1 && Math.Abs(Convert.ToDouble(dr[iLat]) - p.Key[1]) <= 0.1).ToList();
                    if (q.Count > 0)
                    {
                        var v = q.OrderBy(p => Math.Pow(Convert.ToDouble(dr[iLong]) - p.Key[0], 2) + Math.Pow(Convert.ToDouble(dr[iLat]) - p.Key[1], 2)).First();
                        dicColRow.Add(dr[iID].ToString(), new int[2] { v.Value[0], v.Value[1] });
                    }
                    else
                    {
                        var v = dic.OrderBy(p => Math.Pow(Convert.ToDouble(dr[iLong]) - p.Key[0], 2) + Math.Pow(Convert.ToDouble(dr[iLat]) - p.Key[1], 2)).ToList().First();
                        dicColRow.Add(dr[iID].ToString(), new int[2] { v.Value[0], v.Value[1] });
                    }
                }
                foreach (DataRow dr in dt.Rows)
                {
                    lstStringOutputb.Add(string.Format("{0},{1},{2},{3},{4}", dicColRow[dr[iID].ToString()][0] + "," + dicColRow[dr[iID].ToString()][1], "D24HourMean", "QuarterlyMean", "Mean", Convert.ToDouble(dr[iPM25b])));
                    lstStringOutputc.Add(string.Format("{0},{1},{2},{3},{4}", dicColRow[dr[iID].ToString()][0] + "," + dicColRow[dr[iID].ToString()][1], "D24HourMean", "QuarterlyMean", "Mean", Convert.ToDouble(dr[iPM25c])));
                }

                string strPathB = Path.GetDirectoryName(strPath) + @"\benmapBase.csv";
                string strPathC = Path.GetDirectoryName(strPath) + @"\benmapControl.csv";
                System.IO.StreamWriter swB = new System.IO.StreamWriter(strPathB, false);
                foreach (string s in lstStringOutputb)
                {
                    swB.WriteLine(s);
                }
                swB.Flush();

                System.IO.StreamWriter swC = new System.IO.StreamWriter(strPathC, false);
                foreach (string s in lstStringOutputc)
                {
                    swC.WriteLine(s);
                }
                swC.Flush();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        public static BatchBase ReadBatchFile(string strFile)
        {
            try
            {
                //-------------------------------------
                //-----判断文件是否存在----------------
                if (!File.Exists(strFile))
                {
                    //---------写错误日志
                    WriteBatchLogFile("Wrong Batch : Please check the directory of CFG file(*.cfg) !", strFile + ".log");
                    //for (int j = 1; j < batchBase.BatchText.Count; j++)
                    //{
                    //    WriteBatchLogFile("            " + batchBase.BatchText[j].ToString(), strFile + ".log");
                    //}
                    return null;
                }
                BatchBase batchBase = new BatchBase();
                StreamReader objReader = new StreamReader(strFile);
                string sLine = "";
                ArrayList LineList = new ArrayList();
                while (sLine != null)
                {
                    sLine = objReader.ReadLine();
                    if (sLine != null && !sLine.Equals(""))
                        LineList.Add(sLine);
                }
                switch (LineList[0].ToString().Replace("RunType=", ""))
                {
                    case "RunPM25Quarterly":
                        batchBase = ReadBatchFileAnnualPM(LineList, strFile);
                        break;
                    case "RunPM25Daily":
                        batchBase = ReadBatchFileDailyPM(LineList, strFile);
                        break;
                    case "RunOzone":
                        batchBase = ReadBatchFileOzone(LineList, strFile);
                        break;
                    case "RunVisibility":
                        batchBase = ReadBatchFileVisibility(LineList, strFile);
                        break;
                    case "RunSSIAAnnualPM":
                        batchBase = ReadBatchFileSSIAAnnual(LineList, strFile);
                        break;
                    case "RunSSIADailyPM":
                        batchBase = ReadBatchFileSSIADaily(LineList, strFile);
                        break;
                    case "RunSSIAOzone":
                        batchBase = ReadBatchFileSSIAOzone(LineList, strFile);
                        break;
                    case "RunSSIADeposition":
                        batchBase = ReadBatchFileSSIADeposition(LineList, strFile);
                        break;
                    case "RunChinaAnnualPM":
                        batchBase = ReadBatchFileChinaAnnualPM(LineList, strFile);
                        LanguageOld.IsSMATChina = true;
                        break;
                    case "RunOtherAnnualPM":
                        batchBase = ReadBatchFileOtherAnnualPM(LineList, strFile);
                        break;
                    case "RunOzoneChina":
                        batchBase = ReadBatchFileOzoneChina(LineList, strFile);
                        LanguageOld.IsSMATChina = true;
                        break;
                    case "RunOzoneOther":
                        batchBase = ReadBatchFileOzoneOther(LineList, strFile);
                        break;
                    case "RunBenMAPAnnualPM":
                        batchBase = ReadBatchFileBenMapAnnualPM(LineList, strFile);
                        break;
                    case "RunBenMAPOzone":
                        batchBase = ReadBatchFileBenMAPOzone(LineList, strFile);
                        break;
                }
                //----------modify by xiejp Get the Batch Result Path
                for (int i = 0; i < LineList.Count; i++)
                {
                    if (LineList[i].ToString().ToLower().Contains("batchresultpath="))
                        batchBase.batchResultPath = LineList[i].ToString().Replace("batchResultPath=", "").Trim();
                    if (LineList[i].ToString().ToLower().Contains("outputfiledir="))
                        batchBase.batchResultPath = LineList[i].ToString().Replace("OutputFileDir=", "").Trim();
                    //if (string.IsNullOrEmpty(batchBase.batchResultPath))
                    //{
                    //    if (LineList[i].ToString().ToLower().Contains("outputfilename="))
                    //        batchBase.batchResultPath = Path.GetDirectoryName(LineList[i].ToString().Replace("OutputFileName=", "").Trim());// + @"\" + Path.GetFileNameWithoutExtension(strFile)
                    //}
                    //else
                    //{
                    //    break;
                    //}

                }
                //不存在outputfiledir或者batchresultpath则默认路径为“*\Result\Output” subdirectory
                if (string.IsNullOrEmpty(batchBase.batchResultPath))
                {
                    batchBase.batchResultPath = CommonClass.ResultFilePath + @"\Result\Output";
                }

                return batchBase;
            }
            catch
            {
                return null;
            }
        }

        public static BatchBase ReadBatchFileBenMapAnnualPM(ArrayList arrayList, string strFile)
        {
            try
            {
                //---------在读取文件的同时判断字段类型是否正确-----------
                BatchBenMapAnnualPM batchAnnual = new BatchBenMapAnnualPM();
                BatchBase batchBase = null;
                for (int i = 2; i < arrayList.Count; i++)
                {
                    if (arrayList[i].ToString().Contains("scenarioName="))
                        batchAnnual.scenarioName = arrayList[i].ToString().Replace("scenarioName=", "");
                    else if (arrayList[i].ToString().Contains("doQuarterlyModelDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 1)
                        {
                            batchAnnual.doQuarterlyModelDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doDailyModelDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 1)
                        {
                            batchAnnual.doDailyModelDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doInputFromCmaq="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1)
                        {
                            batchAnnual.doInputFromCmaq = Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1)
                        {
                            batchAnnual.doVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doEVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1)
                        {
                            batchAnnual.doEVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doSpeciesMonitorDataFile="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesMonitorDataFile=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesMonitorDataFile=", "")) == 1)
                        {
                            batchAnnual.doSpeciesMonitorDataFile = Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesMonitorDataFile=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("baselineModelDataFile="))
                    {
                        batchAnnual.baselineModelDataFile = arrayList[i].ToString().Replace("baselineModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("forecastModelDataFile="))
                    {
                        batchAnnual.forecastModelDataFile = arrayList[i].ToString().Replace("forecastModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("temporalAdjustmentAtMonitorGridSpatial="))
                    {
                        batchAnnual.temporalAdjustmentAtMonitorGridSpatial = arrayList[i].ToString().Replace("temporalAdjustmentAtMonitorGridSpatial=", "");
                    }
                    else if (arrayList[i].ToString().Contains("unofficialMonitorDataFile="))
                    {
                        batchAnnual.unofficialMonitorDataFile = arrayList[i].ToString().Replace("unofficialMonitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("unofficialStartYear="))
                    {
                        batchAnnual.unofficialStartYear = arrayList[i].ToString().Replace("unofficialStartYear=", "");
                    }
                    else if (arrayList[i].ToString().Contains("unofficialEndYear="))
                    {
                        batchAnnual.unofficialEndYear = arrayList[i].ToString().Replace("unofficialEndYear=", "");
                    }
                    else if (arrayList[i].ToString().Contains("speciesMonitorDataFile="))
                    {
                        batchAnnual.speciesMonitorDataFile = arrayList[i].ToString().Replace("speciesMonitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("specFracSpatialFile="))
                    {
                        batchAnnual.specFracSpatialFile = arrayList[i].ToString().Replace("specFracSpatialFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("gradAdjSpecFracSpatialFile="))
                    {
                        batchAnnual.gradAdjSpecFracSpatialFile = arrayList[i].ToString().Replace("gradAdjSpecFracSpatialFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("speciesStartYear="))
                    {
                        batchAnnual.speciesStartYear = arrayList[i].ToString().Replace("speciesStartYear=", "");
                    }
                    else if (arrayList[i].ToString().Contains("speciesEndYear="))
                    {
                        batchAnnual.speciesEndYear = arrayList[i].ToString().Replace("speciesEndYear=", "");
                    }
                    else if (arrayList[i].ToString().Contains("gridDefinitionFile="))
                    {
                        batchAnnual.gridDefinitionFile = arrayList[i].ToString().Replace("gridDefinitionFile=", "");
                    }
                }
                string msg = CheckBatch(batchAnnual);
                if (msg != "" && msg.Length != 0)
                {
                    WriteBatchLogFile("Wrong cfg : " + msg, strFile + ".log");
                    for (int i = 0; i < arrayList.Count; i++)
                    {
                        WriteBatchLogFile("           " + arrayList[i], strFile + ".log");
                    }
                }
                else
                {
                    batchAnnual.BatchText = arrayList;
                    batchBase = batchAnnual as BatchBase;
                }
                return batchBase;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return null;
            }
        }

        public static BatchBase ReadBatchFileOzoneChina(ArrayList arrayList, string strFile)
        {
            try
            {
                BatchOzoneChina batchOzone = new BatchOzoneChina();
                BatchBase batchBase = null;
                for (int i = 0; i < arrayList.Count; i++)
                {
                    if (arrayList[i].ToString().Contains("scenarioName="))
                        batchOzone.scenarioName = arrayList[i].ToString().Replace("scenarioName=", "");
                    else if (arrayList[i].ToString().Contains("doInputFromCmaq="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().ToLower().Replace("doInputfromCmaq=".ToLower(), "")) == 0 || Convert.ToInt32(arrayList[i].ToString().ToLower().Replace("doInputfromCmaq=".ToLower(), "")) == 1)
                        {
                            batchOzone.doInputfromCmaq = Convert.ToInt32(arrayList[i].ToString().ToLower().Replace("doInputfromCmaq=".ToLower(), "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("baselineModelDataFile="))
                    {
                        batchOzone.baselineModelDataFile = arrayList[i].ToString().Replace("baselineModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("forecastModelDataFile="))
                    {
                        batchOzone.forecastModelDataFile = arrayList[i].ToString().Replace("forecastModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("ozoneMonitorDataFile="))
                    {
                        batchOzone.ozoneMonitorDataFile = arrayList[i].ToString().Replace("ozoneMonitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("ozoneStartYear="))
                    {
                        batchOzone.ozoneStartYear = arrayList[i].ToString().Replace("ozoneStartYear=", "");
                    }
                    else if (arrayList[i].ToString().Contains("ozoneEndYear="))
                    {
                        batchOzone.ozoneEndYear = arrayList[i].ToString().Replace("ozoneEndYear=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1)
                        {
                            batchOzone.useVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doEVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1)
                        {
                            batchOzone.useEVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                }
                string msg = CheckBatch(batchOzone);
                if (msg != "" && msg.Length != 0)
                {
                    WriteBatchLogFile("Wrong cfg : " + msg, strFile + ".log");
                    for (int j = 0; j < arrayList.Count; j++)
                    {
                        WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                    }
                }
                else
                {
                    batchOzone.BatchText = arrayList;
                    batchBase = batchOzone as BatchBase;
                }
                return batchBase;
            }
            catch
            {
                return null;
            }
        }
        public static BatchBase ReadBatchFileOzoneOther(ArrayList arrayList, string strFile)
        {
            try
            {
                BatchOzoneOther batchOzone = new BatchOzoneOther();
                BatchBase batchBase = null;
                for (int i = 0; i < arrayList.Count; i++)
                {
                    if (arrayList[i].ToString().Contains("scenarioName="))
                        batchOzone.scenarioName = arrayList[i].ToString().Replace("scenarioName=", "");
                    else if (arrayList[i].ToString().Contains("doInputFromCmaq="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().ToLower().Replace("doInputfromCmaq=".ToLower(), "")) == 0 || Convert.ToInt32(arrayList[i].ToString().ToLower().Replace("doInputfromCmaq=".ToLower(), "")) == 1)
                        {
                            batchOzone.doInputfromCmaq = Convert.ToInt32(arrayList[i].ToString().ToLower().Replace("doInputfromCmaq=".ToLower(), "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("baselineModelDataFile="))
                    {
                        batchOzone.baselineModelDataFile = arrayList[i].ToString().Replace("baselineModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("forecastModelDataFile="))
                    {
                        batchOzone.forecastModelDataFile = arrayList[i].ToString().Replace("forecastModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("ozoneMonitorDataFile="))
                    {
                        batchOzone.ozoneMonitorDataFile = arrayList[i].ToString().Replace("ozoneMonitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("ozoneStartYear="))
                    {
                        batchOzone.ozoneStartYear = arrayList[i].ToString().Replace("ozoneStartYear=", "");
                    }
                    else if (arrayList[i].ToString().Contains("ozoneEndYear="))
                    {
                        batchOzone.ozoneEndYear = arrayList[i].ToString().Replace("ozoneEndYear=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1)
                        {
                            batchOzone.useVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doEVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1)
                        {
                            batchOzone.useEVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("gridDefinitionFile="))
                    {
                        batchOzone.gridDefinitionFile = arrayList[i].ToString().Replace("gridDefinitionFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("projectionString="))
                    {
                        CommonClass.projOther = arrayList[i].ToString().Replace("projectionString=", ""); ;
                    }
                }
                string msg = CheckBatch(batchOzone);
                if (msg != "" && msg.Length != 0)
                {
                    WriteBatchLogFile("Wrong cfg : " + msg, strFile + ".log");
                    for (int j = 0; j < arrayList.Count; j++)
                    {
                        WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                    }
                }
                else
                {
                    batchOzone.BatchText = arrayList;
                    batchBase = batchOzone as BatchBase;
                }
                return batchBase;
            }
            catch
            {
                return null;
            }
        }

        public static BatchBase ReadBatchFileChinaAnnualPM(ArrayList arrayList, string strFile)
        {
            try
            {
                BatchAnnualPMChina batchAnnual = new BatchAnnualPMChina();
                BatchBase batchBase = null;
                for (int i = 0; i < arrayList.Count; i++)
                {
                    if (arrayList[i].ToString().Contains("scenarioName="))
                        batchAnnual.scenarioName = arrayList[i].ToString().Replace("scenarioName=", "");
                    else if (arrayList[i].ToString().Contains("doDailyModelDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 1)
                        {
                            batchAnnual.doDailyModelDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyModelDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 1)
                        {
                            batchAnnual.doQuarterlyModelDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doInputFromCmaq="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1)
                        {
                            batchAnnual.doInputFromCmaq = Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("baselineModelDataFile="))
                    {
                        batchAnnual.baselineModelDataFile = arrayList[i].ToString().Replace("baselineModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("forecastModelDataFile="))
                    {
                        batchAnnual.futureModelDataFile = arrayList[i].ToString().Replace("forecastModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doDailyMonitorDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doDailyMonitorDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doDailyMonitorDataInput=", "")) == 1)
                        {
                            batchAnnual.doDailyMonitorDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doDailyMonitorDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyMonitorDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyMonitorDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyMonitorDataInput=", "")) == 1)
                        {
                            batchAnnual.doQuarterlyMonitorDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyMonitorDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("PMMonitorDataFile="))
                    {
                        batchAnnual.PMMonitorDataFile = arrayList[i].ToString().Replace("PMMonitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("MonitorStartYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("MonitorStartYear=", "")) >= 1999)//&& Convert.ToInt32(arrayList[i].ToString().Replace("MonitorStartYear=", "")) <= 2017
                            batchAnnual.monitorStartYear = arrayList[i].ToString().Replace("MonitorStartYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("MonitorEndYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("MonitorEndYear=", "")) >= 1999//&& Convert.ToInt32(arrayList[i].ToString().Replace("MonitorEndYear=", "")) <= 2017                            
                            && Convert.ToInt32(batchAnnual.monitorStartYear) <= Convert.ToInt32(arrayList[i].ToString().Replace("MonitorEndYear=", "")))
                            batchAnnual.monitorEndYear = arrayList[i].ToString().Replace("MonitorEndYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1)
                        {
                            batchAnnual.doVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doEVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1)
                        {
                            batchAnnual.doEVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doSpeciesFraction="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFraction=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFraction=", "")) == 1)
                        {
                            batchAnnual.PM25SpeciesFractionDataAvailable = Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFraction=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("SpeciesMonitorDataFile="))
                    {
                        batchAnnual.SpeciesMonitorDataFile = arrayList[i].ToString().Replace("SpeciesMonitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("gridDefinitionFile="))
                    {
                        batchAnnual.gridDefinitionFile = arrayList[i].ToString().Replace("gridDefinitionFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("gridtype="))
                    {
                        batchAnnual.temporalAdjustmentAtMonitorGrid = arrayList[i].ToString().Replace("gridtype=", ""); ;
                    }
                }
                string msg = CheckBatch(batchAnnual);
                if (msg != "" && msg.Length != 0)
                {
                    WriteBatchLogFile("Wrong cfg : " + msg, strFile + ".log");
                    for (int j = 0; j < arrayList.Count; j++)
                    {
                        WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                    }
                }
                else
                {
                    batchAnnual.BatchText = arrayList;
                    batchBase = batchAnnual as BatchBase;
                }
                return batchBase;
            }
            catch
            {
                return null;
            }
        }

        /// <summary>
        /// add for other region
        /// </summary>
        /// <param name="arrayList"></param>
        /// <param name="strFile"></param>
        /// <returns></returns>
        public static BatchBase ReadBatchFileOtherAnnualPM(ArrayList arrayList, string strFile)
        {
            try
            {
                BatchAnnualPMOther batchAnnual = new BatchAnnualPMOther();
                BatchBase batchBase = null;
                for (int i = 0; i < arrayList.Count; i++)
                {
                    if (arrayList[i].ToString().Contains("scenarioName="))
                        batchAnnual.scenarioName = arrayList[i].ToString().Replace("scenarioName=", "");
                    else if (arrayList[i].ToString().Contains("doDailyModelDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 1)
                        {
                            batchAnnual.doDailyModelDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyModelDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 1)
                        {
                            batchAnnual.doQuarterlyModelDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doInputFromCmaq="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1)
                        {
                            batchAnnual.doInputFromCmaq = Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("baselineModelDataFile="))
                    {
                        batchAnnual.baselineModelDataFile = arrayList[i].ToString().Replace("baselineModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("forecastModelDataFile="))
                    {
                        batchAnnual.futureModelDataFile = arrayList[i].ToString().Replace("forecastModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doDailyMonitorDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doDailyMonitorDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doDailyMonitorDataInput=", "")) == 1)
                        {
                            batchAnnual.doDailyMonitorDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doDailyMonitorDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyMonitorDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyMonitorDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyMonitorDataInput=", "")) == 1)
                        {
                            batchAnnual.doQuarterlyMonitorDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyMonitorDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("PMMonitorDataFile="))
                    {
                        batchAnnual.PMMonitorDataFile = arrayList[i].ToString().Replace("PMMonitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("MonitorStartYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("MonitorStartYear=", "")) >= 1999)//&& Convert.ToInt32(arrayList[i].ToString().Replace("MonitorStartYear=", "")) <= 2017
                            batchAnnual.monitorStartYear = arrayList[i].ToString().Replace("MonitorStartYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("MonitorEndYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("MonitorEndYear=", "")) >= 1999//&& Convert.ToInt32(arrayList[i].ToString().Replace("MonitorEndYear=", "")) <= 2017                            
                            && Convert.ToInt32(batchAnnual.monitorStartYear) <= Convert.ToInt32(arrayList[i].ToString().Replace("MonitorEndYear=", "")))
                            batchAnnual.monitorEndYear = arrayList[i].ToString().Replace("MonitorEndYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1)
                        {
                            batchAnnual.doVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doEVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1)
                        {
                            batchAnnual.doEVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doSpeciesFraction="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFraction=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFraction=", "")) == 1)
                        {
                            batchAnnual.PM25SpeciesFractionDataAvailable = Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFraction=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("SpeciesMonitorDataFile="))
                    {
                        batchAnnual.SpeciesMonitorDataFile = arrayList[i].ToString().Replace("SpeciesMonitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("gridDefinitionFile="))
                    {
                        batchAnnual.gridDefinitionFile = arrayList[i].ToString().Replace("gridDefinitionFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("projectionString="))
                    {
                        CommonClass.projOther = arrayList[i].ToString().Replace("projectionString=", ""); ;
                    }
                    else if (arrayList[i].ToString().Contains("gridtype="))
                    {
                        batchAnnual.temporalAdjustmentAtMonitorGrid = arrayList[i].ToString().Replace("gridtype=", ""); ;
                    }
                }
                string msg = CheckBatch(batchAnnual);
                if (msg != "" && msg.Length != 0)
                {
                    WriteBatchLogFile("Wrong cfg : " + msg, strFile + ".log");
                    for (int j = 0; j < arrayList.Count; j++)
                    {
                        WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                    }
                }
                else
                {
                    batchAnnual.BatchText = arrayList;
                    batchBase = batchAnnual as BatchBase;
                }
                return batchBase;
            }
            catch
            {
                return null;
            }
        }

        public static BatchBase ReadBatchFileAnnualPM(ArrayList arrayList, string strFile)
        {
            try
            {
                //---------在读取文件的同时判断字段类型是否正确-----------
                BatchAnnualPM batchAnnual = new BatchAnnualPM();
                BatchBase batchBase = null;
                for (int i = 2; i < arrayList.Count; i++)
                {
                    if (arrayList[i].ToString().Contains("scenarioName="))
                        batchAnnual.scenarioName = arrayList[i].ToString().Replace("scenarioName=", "");
                    else if (arrayList[i].ToString().Contains("doStandardAnalysis="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doStandardAnalysis=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doStandardAnalysis=", "")) == 1)
                        {
                            batchAnnual.doStandardAnalysis = Convert.ToInt32(arrayList[i].ToString().Replace("doStandardAnalysis=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyModelData="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelData=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelData=", "")) == 1)
                        {
                            batchAnnual.doQuarterlyModelData = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelData=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doUsedQuarterlyAvgModelData="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doUsedQuarterlyAvgModelData=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doUsedQuarterlyAvgModelData=", "")) == 1)
                        {
                            batchAnnual.doUsedQuarterlyAvgModelData = Convert.ToInt32(arrayList[i].ToString().Replace("doUsedQuarterlyAvgModelData=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doSpeciesFraction="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFraction=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFraction=", "")) == 1)
                        {
                            batchAnnual.doSpeciesFraction = Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFraction=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doAutomaticallyExtract="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doAutomaticallyExtract=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doAutomaticallyExtract=", "")) == 1)
                        {
                            batchAnnual.doAutomaticallyExtract = Convert.ToInt32(arrayList[i].ToString().Replace("doAutomaticallyExtract=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doInterpolatedSFETempAdj="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doInterpolatedSFETempAdj=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doInterpolatedSFETempAdj=", "")) == 1)
                        {
                            batchAnnual.doInterpolatedSFETempAdj = Convert.ToInt32(arrayList[i].ToString().Replace("doInterpolatedSFETempAdj=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doBaseOnlyVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doBaseOnlyVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doBaseOnlyVNA=", "")) == 1)
                        {
                            batchAnnual.doBaseOnlyVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doBaseOnlyVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doFutureOnlyVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doFutureOnlyVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doFutureOnlyVNA=", "")) == 1)
                        {
                            batchAnnual.doFutureOnlyVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doFutureOnlyVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doInterpolatedSFETempAdj_GradAdj="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doInterpolatedSFETempAdj_GradAdj=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doInterpolatedSFETempAdj_GradAdj=", "")) == 1)
                        {
                            batchAnnual.doInterpolatedSFETempAdj_GradAdj = Convert.ToInt32(arrayList[i].ToString().Replace("doInterpolatedSFETempAdj_GradAdj=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doBaseOnlyEvna="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doBaseOnlyEvna=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doBaseOnlyEvna=", "")) == 1)
                        {
                            batchAnnual.doBaseOnlyEvna = Convert.ToInt32(arrayList[i].ToString().Replace("doBaseOnlyEvna=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doFutureOnlyEvna="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doFutureOnlyEvna=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doFutureOnlyEvna=", "")) == 1)
                        {
                            batchAnnual.doFutureOnlyEvna = Convert.ToInt32(arrayList[i].ToString().Replace("doFutureOnlyEvna=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyAvgFilePoint="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyAvgFilePoint=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyAvgFilePoint=", "")) == 1)
                        {
                            batchAnnual.doQuarterlyAvgFilePoint = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyAvgFilePoint=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyAvgFileSpatial="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyAvgFileSpatial=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyAvgFileSpatial=", "")) == 1)
                        {
                            batchAnnual.doQuarterlyAvgFileSpatial = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyAvgFileSpatial=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyAvgFileSpatial_GraAdj="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyAvgFileSpatial_GraAdj=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyAvgFileSpatial_GraAdj=", "")) == 1)
                        {
                            batchAnnual.doQuarterlyAvgFileSpatial_GraAdj = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyAvgFileSpatial_GraAdj=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doHighCountySites="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doHighCountySites=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doHighCountySites=", "")) == 1)
                        {
                            batchAnnual.doHighCountySites = Convert.ToInt32(arrayList[i].ToString().Replace("doHighCountySites=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doSpeciesFractionSpatial="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFractionSpatial=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFractionSpatial=", "")) == 1)
                        {
                            batchAnnual.doSpeciesFractionSpatial = Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFractionSpatial=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doSpeciesFractionSpatial_GraAdj="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFractionSpatial_GraAdj=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFractionSpatial_GraAdj=", "")) == 1)
                        {
                            batchAnnual.doSpeciesFractionSpatial_GraAdj = Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFractionSpatial_GraAdj=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyAvgSpeciatedMonitors="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyAvgSpeciatedMonitors=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyAvgSpeciatedMonitors=", "")) == 1)
                        {
                            batchAnnual.doQuarterlyAvgSpeciatedMonitors = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyAvgSpeciatedMonitors=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doDesignValuePeriods="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doDesignValuePeriods=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doDesignValuePeriods=", "")) == 1)
                        {
                            batchAnnual.doDesignValuePeriods = Convert.ToInt32(arrayList[i].ToString().Replace("doDesignValuePeriods=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doNeighborFilePoint="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doNeighborFilePoint=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doNeighborFilePoint=", "")) == 1)
                        {
                            batchAnnual.doNeighborFilePoint = Convert.ToInt32(arrayList[i].ToString().Replace("doNeighborFilePoint=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doNeighborFileSpatial="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doNeighborFileSpatial=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doNeighborFileSpatial=", "")) == 1)
                        {
                            batchAnnual.doNeighborFileSpatial = Convert.ToInt32(arrayList[i].ToString().Replace("doNeighborFileSpatial=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doSpeciesMonitorDataFile="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesMonitorDataFile=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesMonitorDataFile=", "")) == 1)
                        {
                            batchAnnual.doSpeciesMonitorDataFile = Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesMonitorDataFile=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("speciesMonitorDataFile="))
                    {
                        batchAnnual.speciesMonitorDataFile = arrayList[i].ToString().Replace("speciesMonitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doSpeciesFractionFile="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFractionFile=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFractionFile=", "")) == 1)
                        {
                            batchAnnual.doSpeciesFractionFile = Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFractionFile=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("specFracModePoint="))
                    {
                        batchAnnual.specFracModePoint = arrayList[i].ToString().Replace("specFracModePoint=", "");
                    }
                    else if (arrayList[i].ToString().Contains("specFracPointFile="))
                    {
                        batchAnnual.specFracPointFile = arrayList[i].ToString().Replace("specFracPointFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("specFracModeSpatial="))
                    {
                        batchAnnual.specFracModeSpatial = arrayList[i].ToString().Replace("specFracModeSpatial=", "");
                    }
                    else if (arrayList[i].ToString().Contains("specFracSpatialFile="))
                    {
                        batchAnnual.specFracSpatialFile = arrayList[i].ToString().Replace("specFracSpatialFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("unofficialMonitorDataFile="))
                    {
                        batchAnnual.unofficialMonitorDataFile = arrayList[i].ToString().Replace("unofficialMonitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("officialMonitorDataFile="))
                    {
                        batchAnnual.officialMonitorDataFile = arrayList[i].ToString().Replace("officialMonitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doDailyModelDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 1)
                        {
                            batchAnnual.doDailyModelDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyModelDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 1)
                        {
                            batchAnnual.doQuarterlyModelDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doInputFromCmaq="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1)
                        {
                            batchAnnual.doInputFromCmaq = Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("baselineModelDataFile="))
                    {
                        batchAnnual.baselineModelDataFile = arrayList[i].ToString().Replace("baselineModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("forecastModelDataFile="))
                    {
                        batchAnnual.forecastModelDataFile = arrayList[i].ToString().Replace("forecastModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVESTN_StartYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_StartYear=", "")) >= 2002
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_StartYear=", "")) <= 2014
                            )
                            batchAnnual.IMPROVESTN_StartYear = arrayList[i].ToString().Replace("IMPROVESTN_StartYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVESTN_EndYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_EndYear=", "")) >= 2002
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_EndYear=", "")) <= 2016
                            && Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_EndYear=", "")) >= Convert.ToInt32(batchAnnual.IMPROVESTN_StartYear))
                            batchAnnual.IMPROVESTN_EndYear = arrayList[i].ToString().Replace("IMPROVESTN_EndYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVESTN_EPADeletionChoice="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_EPADeletionChoice=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_EPADeletionChoice=", "")) == 1)
                        {
                            batchAnnual.IMPROVESTN_EPADeletionChoice = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_EPADeletionChoice=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVESTN_UserDeletionChoice="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_UserDeletionChoice=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_UserDeletionChoice=", "")) == 1)
                        {
                            batchAnnual.IMPROVESTN_UserDeletionChoice = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_UserDeletionChoice=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVESTN_MinDays="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_MinDays=", "")) <= 90
                            && Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_MinDays=", "")) >= 1)
                            batchAnnual.IMPROVESTN_MinDays = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_MinDays=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVESTN_MinYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_MinYear=", "")) <= 3
                            && Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_MinYear=", "")) >= 1)
                            batchAnnual.IMPROVESTN_MinYear = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_MinYear=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVESTN_MinSeasons="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_MinSeasons=", "")) <= 4
                            && Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_MinSeasons=", "")) >= 1)
                            batchAnnual.IMPROVESTN_MinSeasons = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_MinSeasons=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialStartYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialStartYear=", "")) >= 2002
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("unofficialStartYear=", "")) <= 2014
                            )
                            batchAnnual.unofficialStartYear = arrayList[i].ToString().Replace("unofficialStartYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialEndYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialEndYear=", "")) >= 2002
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("unofficialEndYear=", "")) <= 2014
                            && Convert.ToInt32(arrayList[i].ToString().Replace("unofficialEndYear=", "")) >= Convert.ToInt32(batchAnnual.unofficialStartYear))
                            batchAnnual.unofficialEndYear = arrayList[i].ToString().Replace("unofficialEndYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialEPADeletionChoice="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialEPADeletionChoice=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("unofficialEPADeletionChoice=", "")) == 1)
                        {
                            batchAnnual.unofficialEPADeletionChoice = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialEPADeletionChoice=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialUserDeletionChoice="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialUserDeletionChoice=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("unofficialUserDeletionChoice=", "")) == 1)
                        {
                            batchAnnual.unofficialUserDeletionChoice = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialUserDeletionChoice=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialMinDays="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinDays=", "")) <= 90
                            && Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinDays=", "")) >= 1)
                            batchAnnual.unofficialMinDays = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinDays=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialMinYears="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinYears=", "")) <= 3
                            && Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinYears=", "")) >= 1)
                            batchAnnual.unofficialMinYears = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinYears=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialMinSeasonsPoint="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinSeasonsPoint=", "")) <= 4
                            && Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinSeasonsPoint=", "")) >= 1)
                            batchAnnual.unofficialMinSeasonsPoint = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinSeasonsPoint=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialMinSeasonsSpatial="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinSeasonsSpatial=", "")) <= 4
                            && Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinSeasonsSpatial=", "")) >= 1)
                            batchAnnual.unofficialMinSeasonsSpatial = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinSeasonsSpatial=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doAdvancedOptionsForSpeciesFraction="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doAdvancedOptionsForSpeciesFraction=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doAdvancedOptionsForSpeciesFraction=", "")) == 1)
                        {
                            batchAnnual.doAdvancedOptionsForSpeciesFraction = Convert.ToInt32(arrayList[i].ToString().Replace("doAdvancedOptionsForSpeciesFraction=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodPM25="))
                    {
                        batchAnnual.interpolationMethodPM25 = arrayList[i].ToString().Replace("interpolationMethodPM25=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distancePM25="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distancePM25=", "")) > 0)
                            batchAnnual.distancePM25 = Convert.ToInt64(arrayList[i].ToString().Replace("distancePM25=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodSO4="))
                    {
                        batchAnnual.interpolationMethodSO4 = arrayList[i].ToString().Replace("interpolationMethodSO4=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceSO4="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceSO4=", "")) > 0)
                            batchAnnual.distanceSO4 = Convert.ToInt64(arrayList[i].ToString().Replace("distanceSO4=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodNO3="))
                    {
                        batchAnnual.interpolationMethodNO3 = arrayList[i].ToString().Replace("interpolationMethodNO3=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceNO3="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceNO3=", "")) > 0)
                            batchAnnual.distanceNO3 = Convert.ToInt64(arrayList[i].ToString().Replace("distanceNO3=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodEC="))
                    {
                        batchAnnual.interpolationMethodEC = arrayList[i].ToString().Replace("interpolationMethodEC=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceEC="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceEC=", "")) > 0)
                            batchAnnual.distanceEC = Convert.ToInt64(arrayList[i].ToString().Replace("distanceEC=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodSalt="))
                    {
                        batchAnnual.interpolationMethodSalt = arrayList[i].ToString().Replace("interpolationMethodSalt=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceSalt="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceSalt=", "")) > 0)
                            batchAnnual.distanceSalt = Convert.ToInt64(arrayList[i].ToString().Replace("distanceSalt=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodCrustal="))
                    {
                        batchAnnual.interpolationMethodCrustal = arrayList[i].ToString().Replace("interpolationMethodCrustal=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceCrustal="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceCrustal=", "")) > 0)
                            batchAnnual.distanceCrustal = Convert.ToInt64(arrayList[i].ToString().Replace("distanceCrustal=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodDON="))
                    {
                        batchAnnual.interpolationMethodDON = arrayList[i].ToString().Replace("interpolationMethodDON=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceDON="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceDON=", "")) > 0)
                            batchAnnual.distanceDON = Convert.ToInt64(arrayList[i].ToString().Replace("distanceDON=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodOC="))
                    {
                        batchAnnual.interpolationMethodOC = arrayList[i].ToString().Replace("interpolationMethodOC=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceOC="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceOC=", "")) > 0)
                            batchAnnual.distanceOC = Convert.ToInt64(arrayList[i].ToString().Replace("distanceOC=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodNH4="))
                    {
                        batchAnnual.interpolationMethodNH4 = arrayList[i].ToString().Replace("interpolationMethodNH4=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceNH4="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceNH4=", "")) > 0)
                            batchAnnual.distanceNH4 = Convert.ToInt64(arrayList[i].ToString().Replace("distanceNH4=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doUseDonValues="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doUseDonValues=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doUseDonValues=", "")) == 1)
                        {
                            batchAnnual.doUseDonValues = Convert.ToInt32(arrayList[i].ToString().Replace("doUseDonValues=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doUseAmmoniumValues="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doUseAmmoniumValues=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doUseAmmoniumValues=", "")) == 1)
                        {
                            batchAnnual.doUseAmmoniumValues = Convert.ToInt32(arrayList[i].ToString().Replace("doUseAmmoniumValues=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("nh4PercentageEvaporating="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("nh4PercentageEvaporating=", "")) <= 100
                            && Convert.ToInt32(arrayList[i].ToString().Replace("nh4PercentageEvaporating=", "")) >= 0)
                            batchAnnual.nh4PercentageEvaporating = Convert.ToInt32(arrayList[i].ToString().Replace("nh4PercentageEvaporating=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("defaultBlankMass="))
                    {
                        if (Convert.ToDecimal(arrayList[i].ToString().Replace("defaultBlankMass=", "")) >= 0)
                            batchAnnual.defaultBlankMass = Convert.ToDecimal(arrayList[i].ToString().Replace("defaultBlankMass=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("floorOCMMB="))
                    {
                        if (Convert.ToDecimal(arrayList[i].ToString().Replace("floorOCMMB=", "")) >= 0)
                            batchAnnual.floorOCMMB = Convert.ToDecimal(arrayList[i].ToString().Replace("floorOCMMB=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("ceilingOCMMB="))
                    {
                        if (Convert.ToDecimal(arrayList[i].ToString().Replace("ceilingOCMMB=", "")) >= 0)
                            batchAnnual.ceilingOCMMB = Convert.ToDecimal(arrayList[i].ToString().Replace("ceilingOCMMB=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("officialPM25StartYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25StartYear=", "")) >= 1999
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25StartYear=", "")) <= 2014
                            )
                            batchAnnual.officialPM25StartYear = arrayList[i].ToString().Replace("officialPM25StartYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("officialPM25EndYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25EndYear=", "")) >= 1999
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25EndYear=", "")) <= 2014
                            && Convert.ToInt32(batchAnnual.officialPM25StartYear) <= Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25EndYear=", "")))
                            batchAnnual.officialPM25EndYear = arrayList[i].ToString().Replace("officialPM25EndYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("choiceOfficialDV="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("choiceOfficialDV=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("choiceOfficialDV=", "")) == 1)
                        {
                            batchAnnual.choiceOfficialDV = Convert.ToInt32(arrayList[i].ToString().Replace("choiceOfficialDV=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("choiceCustomDV="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("choiceCustomDV=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("choiceCustomDV=", "")) == 1)
                        {
                            batchAnnual.choiceCustomDV = Convert.ToInt32(arrayList[i].ToString().Replace("choiceCustomDV=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("minDaysForValidFRMQuarters="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("minDaysForValidFRMQuarters=", "")) <= 90
                            && Convert.ToInt32(arrayList[i].ToString().Replace("minDaysForValidFRMQuarters=", "")) >= 0)
                            batchAnnual.minDaysForValidFRMQuarters = Convert.ToInt32(arrayList[i].ToString().Replace("minDaysForValidFRMQuarters=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("minQuartersForValidFRMDesignValues="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("minQuartersForValidFRMDesignValues=", "")) >= 10
                            && Convert.ToInt32(arrayList[i].ToString().Replace("minQuartersForValidFRMDesignValues=", "")) <= 12)
                            batchAnnual.minQuartersForValidFRMDesignValues = Convert.ToInt32(arrayList[i].ToString().Replace("minQuartersForValidFRMDesignValues=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("minNumDVPeriodsForValidFRMMonitors="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("minNumDVPeriodsForValidFRMMonitors=", "")) >= 1
                            && Convert.ToInt32(arrayList[i].ToString().Replace("minNumDVPeriodsForValidFRMMonitors=", "")) <= 3)
                            batchAnnual.minNumDVPeriodsForValidFRMMonitors = Convert.ToInt32(arrayList[i].ToString().Replace("minNumDVPeriodsForValidFRMMonitors=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("requiredDVPeriodsForValidFRMMonitors="))
                    {
                        batchAnnual.requiredDVPeriodsForValidFRMMonitors = arrayList[i].ToString().Replace("requiredDVPeriodsForValidFRMMonitors=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doCalcNH4fromDON="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doCalcNH4fromDON=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doCalcNH4fromDON=", "")) == 1)
                        {
                            batchAnnual.doCalcNH4fromDON = Convert.ToInt32(arrayList[i].ToString().Replace("doCalcNH4fromDON=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doCalcNH4fromRRF="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doCalcNH4fromRRF=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doCalcNH4fromRRF=", "")) == 1)
                        {
                            batchAnnual.doCalcNH4fromRRF = Convert.ToInt32(arrayList[i].ToString().Replace("doCalcNH4fromRRF=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("temporalAdjustmentAtMonitorGrid="))
                    {
                        batchAnnual.temporalAdjustmentAtMonitorGrid = arrayList[i].ToString().Replace("temporalAdjustmentAtMonitorGrid=", "");
                    }
                    else if (arrayList[i].ToString().Contains("temporalAdjustmentAtMonitorGridSpatial="))
                    {
                        batchAnnual.temporalAdjustmentAtMonitorGridSpatial = arrayList[i].ToString().Replace("temporalAdjustmentAtMonitorGridSpatial=", "");
                    }
                }
                string msg = CheckBatch(batchAnnual);
                if (msg != "" && msg.Length != 0)
                {
                    WriteBatchLogFile("Wrong cfg : " + msg, strFile + ".log");
                    for (int i = 0; i < arrayList.Count; i++)
                    {
                        WriteBatchLogFile("           " + arrayList[i], strFile + ".log");
                    }
                }
                else
                {
                    batchAnnual.BatchText = arrayList;
                    batchBase = batchAnnual as BatchBase;
                }
                return batchBase;
            }
            catch
            {
                return null;
            }
        }

        public static BatchBase ReadBatchFileDailyPM(ArrayList arrayList, string strFile)
        {
            try
            {
                BatchDailyPM batchDailyPM = new BatchDailyPM();
                BatchBase batchBase = null;
                for (int i = 2; i < arrayList.Count; i++)
                {
                    if (arrayList[i].ToString().Contains("scenarioName="))
                    {
                        batchDailyPM.scenarioName = arrayList[i].ToString().Replace("scenarioName=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doStandardAnalysis="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doStandardAnalysis=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doStandardAnalysis=", "")) == 1)
                        {
                            batchDailyPM.doStandardAnalysis = Convert.ToInt32(arrayList[i].ToString().Replace("doStandardAnalysis=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyPeakModelData="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyPeakModelData=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyPeakModelData=", "")) == 1)
                        {
                            batchDailyPM.doQuarterlyPeakModelData = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyPeakModelData=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doSpeciesFraction="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFraction=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFraction=", "")) == 1)
                        {
                            batchDailyPM.doSpeciesFraction = Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFraction=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doAutomaticallyExtract="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doAutomaticallyExtract=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doAutomaticallyExtract=", "")) == 1)
                        {
                            batchDailyPM.doAutomaticallyExtract = Convert.ToInt32(arrayList[i].ToString().Replace("doAutomaticallyExtract=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyPeakFilesPoint="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyPeakFilesPoint=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyPeakFilesPoint=", "")) == 1)
                        {
                            batchDailyPM.doQuarterlyPeakFilesPoint = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyPeakFilesPoint=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doHighCountySites="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doHighCountySites=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doHighCountySites=", "")) == 1)
                        {
                            batchDailyPM.doHighCountySites = Convert.ToInt32(arrayList[i].ToString().Replace("doHighCountySites=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyPeakSpeciatedMonitors="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyPeakSpeciatedMonitors=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyPeakSpeciatedMonitors=", "")) == 1)
                        {
                            batchDailyPM.doQuarterlyPeakSpeciatedMonitors = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyPeakSpeciatedMonitors=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doDesignValuePeriods="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doDesignValuePeriods=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doDesignValuePeriods=", "")) == 1)
                        {
                            batchDailyPM.doDesignValuePeriods = Convert.ToInt32(arrayList[i].ToString().Replace("doDesignValuePeriods=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doNeighborFilePoint="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doNeighborFilePoint=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doNeighborFilePoint=", "")) == 1)
                        {
                            batchDailyPM.doNeighborFilePoint = Convert.ToInt32(arrayList[i].ToString().Replace("doNeighborFilePoint=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doSpeciesMonitorDataFile="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesMonitorDataFile=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesMonitorDataFile=", "")) == 1)
                        {
                            batchDailyPM.doSpeciesMonitorDataFile = Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesMonitorDataFile=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("speciesMonitorDataFile="))
                    {
                        batchDailyPM.speciesMonitorDataFile = arrayList[i].ToString().Replace("speciesMonitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doSpeciesFractionFile="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFractionFile=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFractionFile=", "")) == 1)
                        {
                            batchDailyPM.doSpeciesFractionFile = Convert.ToInt32(arrayList[i].ToString().Replace("doSpeciesFractionFile=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("specFracModePoint="))
                    {
                        batchDailyPM.specFracModePoint = arrayList[i].ToString().Replace("specFracModePoint=", "");
                    }
                    else if (arrayList[i].ToString().Contains("specFracPointFile="))
                    {
                        batchDailyPM.specFracPointFile = arrayList[i].ToString().Replace("specFracPointFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("specFracModeSpatial="))
                    {
                        batchDailyPM.specFracModeSpatial = arrayList[i].ToString().Replace("specFracModeSpatial=", "");
                    }
                    else if (arrayList[i].ToString().Contains("specFracSpatialFile="))
                    {
                        batchDailyPM.specFracSpatialFile = arrayList[i].ToString().Replace("specFracSpatialFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("unofficialMonitorFile="))
                    {
                        batchDailyPM.unofficialMonitorFile = arrayList[i].ToString().Replace("unofficialMonitorFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("officialMonitorFile="))
                    {
                        batchDailyPM.officialMonitorFile = arrayList[i].ToString().Replace("officialMonitorFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doDailyModelDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 1)
                        {
                            batchDailyPM.doDailyModelDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyPeakModelDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyPeakModelDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyPeakModelDataInput=", "")) == 1)
                        {
                            batchDailyPM.doQuarterlyPeakModelDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyPeakModelDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doInputfromCmaq="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doInputfromCmaq=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doInputfromCmaq=", "")) == 1)
                        {
                            batchDailyPM.doInputfromCmaq = Convert.ToInt32(arrayList[i].ToString().Replace("doInputfromCmaq=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("baselineModelFile="))
                    {
                        batchDailyPM.baselineModelFile = arrayList[i].ToString().Replace("baselineModelFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("forecastModelFile="))
                    {
                        batchDailyPM.forecastModelFile = arrayList[i].ToString().Replace("forecastModelFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVE_StartYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_StartYear=", "")) >= 2002
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_StartYear=", "")) <= 2014
                            )
                            batchDailyPM.IMPROVE_StartYear = arrayList[i].ToString().Replace("IMPROVE_StartYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVE_EndYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_EndYear=", "")) >= 2002
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_EndYear=", "")) <= 2014
                            && Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_EndYear=", "")) >= Convert.ToInt32(batchDailyPM.IMPROVE_StartYear))
                            batchDailyPM.IMPROVE_EndYear = arrayList[i].ToString().Replace("IMPROVE_EndYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVE_EPADeletionChoice="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_EPADeletionChoice=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_EPADeletionChoice=", "")) == 1)
                        {
                            batchDailyPM.IMPROVE_EPADeletionChoice = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_EPADeletionChoice=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVE_UserDeletionChoice="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_UserDeletionChoice=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_UserDeletionChoice=", "")) == 1)
                        {
                            batchDailyPM.IMPROVE_UserDeletionChoice = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_UserDeletionChoice=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVE_MinDays="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_MinDays=", "")) > 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_MinDays=", "")) <= 90)
                            batchDailyPM.IMPROVE_MinDays = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_MinDays=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVE_MinQuarters="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_MinQuarters=", "")) > 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_MinQuarters=", "")) <= 4)
                            batchDailyPM.IMPROVE_MinQuarters = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_MinQuarters=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVE_MinYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_MinYear=", "")) >= 1
                            && Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_MinYear=", "")) <= 3)
                            batchDailyPM.IMPROVE_MinYear = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVE_MinYear=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialStartYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialStartYear=", "")) >= 2002
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("unofficialStartYear=", "")) <= 2014
                            )
                            batchDailyPM.unofficialStartYear = arrayList[i].ToString().Replace("unofficialStartYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialEndYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialEndYear=", "")) >= 2002
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("unofficialEndYear=", "")) <= 2014
                            && Convert.ToInt32(arrayList[i].ToString().Replace("unofficialEndYear=", "")) >= Convert.ToInt32(batchDailyPM.unofficialStartYear))
                            batchDailyPM.unofficialEndYear = arrayList[i].ToString().Replace("unofficialEndYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialEPADeletionChoice="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialEPADeletionChoice=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("unofficialEPADeletionChoice=", "")) == 1)
                        {
                            batchDailyPM.unofficialEPADeletionChoice = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialEPADeletionChoice=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialUserDeletionChoice="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialUserDeletionChoice=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("unofficialUserDeletionChoice=", "")) == 1)
                        {
                            batchDailyPM.unofficialUserDeletionChoice = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialUserDeletionChoice=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialMinDays="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinDays=", "")) > 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinDays=", "")) <= 90)
                            batchDailyPM.unofficialMinDays = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinDays=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialMinQuartersPoint="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinQuartersPoint=", "")) > 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinQuartersPoint=", "")) <= 4)
                            batchDailyPM.unofficialMinQuartersPoint = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinQuartersPoint=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialMinYears="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinYears=", "")) >= 1
                            && Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinYears=", "")) <= 3)
                            batchDailyPM.unofficialMinYears = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialMinYears=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVESTN_DoTopXPercent="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_DoTopXPercent=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_DoTopXPercent=", "")) == 1)
                        {
                            batchDailyPM.IMPROVESTN_DoTopXPercent = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_DoTopXPercent=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVESTN_TopXPercent="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_TopXPercent=", "")) > 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_TopXPercent=", "")) <= 100)
                            batchDailyPM.IMPROVESTN_TopXPercent = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_TopXPercent=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVESTN_DoUseAlldailyMonitorValuesGreaterThan="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_DoUseAlldailyMonitorValuesGreaterThan=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_DoUseAlldailyMonitorValuesGreaterThan=", "")) == 1)
                        {
                            batchDailyPM.IMPROVESTN_DoUseAlldailyMonitorValuesGreaterThan = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_DoUseAlldailyMonitorValuesGreaterThan=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVESTN_UseAlldailyMonitorValuesGreaterThan="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_UseAlldailyMonitorValuesGreaterThan=", "")) >= 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_UseAlldailyMonitorValuesGreaterThan=", "")) <= 200)
                            batchDailyPM.IMPROVESTN_UseAlldailyMonitorValuesGreaterThan = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_UseAlldailyMonitorValuesGreaterThan=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : in the line " + Convert.ToString(i + 1) + ", data format is not correct !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVESTN_MinumumNumberOfDaysRequiredAboveFixedAmount="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_MinumumNumberOfDaysRequiredAboveFixedAmount=", "")) >= 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_MinumumNumberOfDaysRequiredAboveFixedAmount=", "")) <= 90)
                            batchDailyPM.IMPROVESTN_MinumumNumberOfDaysRequiredAboveFixedAmount = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_MinumumNumberOfDaysRequiredAboveFixedAmount=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVESTN_DoUseTopXNumber="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_DoUseTopXNumber=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_DoUseTopXNumber=", "")) == 1)
                        {
                            batchDailyPM.IMPROVESTN_DoUseTopXNumber = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_DoUseTopXNumber=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("IMPROVESTN_UseTopXNumber="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_UseTopXNumber=", "")) > 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_UseTopXNumber=", "")) <= 90)
                            batchDailyPM.IMPROVESTN_UseTopXNumber = Convert.ToInt32(arrayList[i].ToString().Replace("IMPROVESTN_UseTopXNumber=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialPM25_DoTopXPercent="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_DoTopXPercent=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_DoTopXPercent=", "")) == 1)
                        {
                            batchDailyPM.unofficialPM25_DoTopXPercent = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_DoTopXPercent=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialPM25_TopXPercent="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_TopXPercent=", "")) > 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_TopXPercent=", "")) <= 100)
                            batchDailyPM.unofficialPM25_TopXPercent = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_TopXPercent=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialPM25_DoUseAlldailyMonitorValuesGreaterThan="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_DoUseAlldailyMonitorValuesGreaterThan=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_DoUseAlldailyMonitorValuesGreaterThan=", "")) == 1)
                        {
                            batchDailyPM.unofficialPM25_DoUseAlldailyMonitorValuesGreaterThan = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_DoUseAlldailyMonitorValuesGreaterThan=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialPM25_UseAlldailyMonitorValuesGreaterThan="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_UseAlldailyMonitorValuesGreaterThan=", "")) >= 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_UseAlldailyMonitorValuesGreaterThan=", "")) <= 200)
                            batchDailyPM.unofficialPM25_UseAlldailyMonitorValuesGreaterThan = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_UseAlldailyMonitorValuesGreaterThan=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialPM25_MinumumNumberOfDaysRequiredAboveFixedAmount="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_MinumumNumberOfDaysRequiredAboveFixedAmount=", "")) >= 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_MinumumNumberOfDaysRequiredAboveFixedAmount=", "")) <= 90)
                            batchDailyPM.unofficialPM25_MinumumNumberOfDaysRequiredAboveFixedAmount = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_MinumumNumberOfDaysRequiredAboveFixedAmount=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialPM25_DoTopXNumber="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_DoTopXNumber=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_DoTopXNumber=", "")) == 1)
                        {
                            batchDailyPM.unofficialPM25_DoTopXNumber = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_DoTopXNumber=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("unofficialPM25_TopXNumber="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_TopXNumber=", "")) > 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_TopXNumber=", "")) <= 90)
                            batchDailyPM.unofficialPM25_TopXNumber = Convert.ToInt32(arrayList[i].ToString().Replace("unofficialPM25_TopXNumber=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodPM25="))
                    {
                        batchDailyPM.interpolationMethodPM25 = arrayList[i].ToString().Replace("interpolationMethodPM25=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distancePM25="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distancePM25=", "")) > 0)
                            batchDailyPM.distancePM25 = Convert.ToInt64(arrayList[i].ToString().Replace("distancePM25=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodSO4="))
                    {
                        batchDailyPM.interpolationMethodSO4 = arrayList[i].ToString().Replace("interpolationMethodSO4=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceSO4="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceSO4=", "")) > 0)
                            batchDailyPM.distanceSO4 = Convert.ToInt64(arrayList[i].ToString().Replace("distanceSO4=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodNO3="))
                    {
                        batchDailyPM.interpolationMethodNO3 = arrayList[i].ToString().Replace("interpolationMethodNO3=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceNO3="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceNO3=", "")) > 0)
                            batchDailyPM.distanceNO3 = Convert.ToInt64(arrayList[i].ToString().Replace("distanceNO3=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodEC="))
                    {
                        batchDailyPM.interpolationMethodEC = arrayList[i].ToString().Replace("interpolationMethodEC=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceEC="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceEC=", "")) > 0)
                            batchDailyPM.distanceEC = Convert.ToInt64(arrayList[i].ToString().Replace("distanceEC=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodSalt="))
                    {
                        batchDailyPM.interpolationMethodSalt = arrayList[i].ToString().Replace("interpolationMethodSalt=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceSalt="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceSalt=", "")) > 0)
                            batchDailyPM.distanceSalt = Convert.ToInt64(arrayList[i].ToString().Replace("distanceSalt=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodCrustal="))
                    {
                        batchDailyPM.interpolationMethodCrustal = arrayList[i].ToString().Replace("interpolationMethodCrustal=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceCrustal="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceCrustal=", "")) > 0)
                            batchDailyPM.distanceCrustal = Convert.ToInt64(arrayList[i].ToString().Replace("distanceCrustal=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodDON="))
                    {
                        batchDailyPM.interpolationMethodDON = arrayList[i].ToString().Replace("interpolationMethodDON=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceDON="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceDON=", "")) > 0)
                            batchDailyPM.distanceDON = Convert.ToInt64(arrayList[i].ToString().Replace("distanceDON=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodOC="))
                    {
                        batchDailyPM.interpolationMethodOC = arrayList[i].ToString().Replace("interpolationMethodOC=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceOC="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceOC=", "")) > 0)
                            batchDailyPM.distanceOC = Convert.ToInt64(arrayList[i].ToString().Replace("distanceOC=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("interpolationMethodNH4="))
                    {
                        batchDailyPM.interpolationMethodNH4 = arrayList[i].ToString().Replace("interpolationMethodNH4=", "");
                    }
                    else if (arrayList[i].ToString().Contains("distanceNH4="))
                    {
                        if (Convert.ToInt64(arrayList[i].ToString().Replace("distanceNH4=", "")) > 0)
                            batchDailyPM.distanceNH4 = Convert.ToInt64(arrayList[i].ToString().Replace("distanceNH4=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doUseDonValues="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doUseDonValues=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doUseDonValues=", "")) == 1)
                        {
                            batchDailyPM.doUseDonValues = Convert.ToInt32(arrayList[i].ToString().Replace("doUseDonValues=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doUseMeasuredAmmonium="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doUseMeasuredAmmonium=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doUseMeasuredAmmonium=", "")) == 1)
                        {
                            batchDailyPM.doUseMeasuredAmmonium = Convert.ToInt32(arrayList[i].ToString().Replace("doUseMeasuredAmmonium=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("nh4PercentageEvaporating="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("nh4PercentageEvaporating=", "")) >= 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("nh4PercentageEvaporating=", "")) <= 100)
                            batchDailyPM.nh4PercentageEvaporating = Convert.ToInt32(arrayList[i].ToString().Replace("nh4PercentageEvaporating=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("defaultBlankMass="))
                    {
                        if (Convert.ToDecimal(arrayList[i].ToString().Replace("defaultBlankMass=", "")) >= 0)
                            batchDailyPM.defaultBlankMass = Convert.ToDecimal(arrayList[i].ToString().Replace("defaultBlankMass=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("floorOCMMB="))
                    {
                        if (Convert.ToDecimal(arrayList[i].ToString().Replace("floorOCMMB=", "")) >= 0)
                            batchDailyPM.floorOCMMB = Convert.ToDecimal(arrayList[i].ToString().Replace("floorOCMMB=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("ceilingOCMMB="))
                    {
                        if (Convert.ToDecimal(arrayList[i].ToString().Replace("ceilingOCMMB=", "")) >= 0)
                            batchDailyPM.ceilingOCMMB = Convert.ToDecimal(arrayList[i].ToString().Replace("ceilingOCMMB=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doAdvancedOptionsForSpeciesFraction="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doAdvancedOptionsForSpeciesFraction=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doAdvancedOptionsForSpeciesFraction=", "")) == 1)
                        {
                            batchDailyPM.doAdvancedOptionsForSpeciesFraction = Convert.ToInt32(arrayList[i].ToString().Replace("doAdvancedOptionsForSpeciesFraction=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("officialPM25StartYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25StartYear=", "")) >= 1999
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25StartYear=", "")) <= 2014
                            )
                        {
                            batchDailyPM.officialPM25StartYear = arrayList[i].ToString().Replace("officialPM25StartYear=", "");
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("officialPM25EndYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25EndYear=", "")) >= 1999
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25EndYear=", "")) <= 2014
                            && Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25EndYear=", "")) >= Convert.ToInt32(batchDailyPM.officialPM25StartYear))
                        {
                            batchDailyPM.officialPM25EndYear = arrayList[i].ToString().Replace("officialPM25EndYear=", "");
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("minNumDVPeriodsForValidFRMMonitors="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("minNumDVPeriodsForValidFRMMonitors=", "")) >= 1
                            && Convert.ToInt32(arrayList[i].ToString().Replace("minNumDVPeriodsForValidFRMMonitors=", "")) <= 3)
                            batchDailyPM.minNumDVPeriodsForValidFRMMonitors = Convert.ToInt32(arrayList[i].ToString().Replace("minNumDVPeriodsForValidFRMMonitors=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("requiredDesignValuePeriodsForValidFRMMonitors="))
                    {
                        batchDailyPM.requiredDesignValuePeriodsForValidFRMMonitors = arrayList[i].ToString().Replace("requiredDesignValuePeriodsForValidFRMMonitors=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doCalcNH4fromDON="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doCalcNH4fromDON=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doCalcNH4fromDON=", "")) == 1)
                        {
                            batchDailyPM.doCalcNH4fromDON = Convert.ToInt32(arrayList[i].ToString().Replace("doCalcNH4fromDON=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doCalcNH4fromRRF="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doCalcNH4fromRRF=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doCalcNH4fromRRF=", "")) == 1)
                        {
                            batchDailyPM.doCalcNH4fromRRF = Convert.ToInt32(arrayList[i].ToString().Replace("doCalcNH4fromRRF=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("temporalAdjustmentAtMonitorGridPoint="))
                    {
                        batchDailyPM.temporalAdjustmentAtMonitorGridPoint = arrayList[i].ToString().Replace("temporalAdjustmentAtMonitorGridPoint=", "");
                    }
                    else if (arrayList[i].ToString().Contains("temporalAdjustmentAtMonitorGridSpatial="))
                    {
                        batchDailyPM.temporalAdjustmentAtMonitorGridSpatial = arrayList[i].ToString().Replace("temporalAdjustmentAtMonitorGridSpatial=", "");
                    }
                    else if (arrayList[i].ToString().Contains("temporalAdjustmentType="))
                    {
                        batchDailyPM.temporalAdjustmentType = arrayList[i].ToString().Replace("temporalAdjustmentType=", "");
                    }
                    else if (arrayList[i].ToString().Contains("RRF_DoUseXTopPercent="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseXTopPercent=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseXTopPercent=", "")) == 1)
                        {
                            batchDailyPM.RRF_DoUseXTopPercent = Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseXTopPercent=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("RRF_UseXTopPercent="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("RRF_UseXTopPercent=", "")) > 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("RRF_UseXTopPercent=", "")) <= 100)
                            batchDailyPM.RRF_UseXTopPercent = Convert.ToInt32(arrayList[i].ToString().Replace("RRF_UseXTopPercent=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("RRF_DoUseAllModelDaysGreaterThan="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseAllModelDaysGreaterThan=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseAllModelDaysGreaterThan=", "")) == 1)
                        {
                            batchDailyPM.RRF_DoUseAllModelDaysGreaterThan = Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseAllModelDaysGreaterThan=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("RRF_UseAllModelDaysGreaterThan="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("RRF_UseAllModelDaysGreaterThan=", "")) >= 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("RRF_UseAllModelDaysGreaterThan=", "")) <= 200)
                            batchDailyPM.RRF_UseAllModelDaysGreaterThan = Convert.ToInt32(arrayList[i].ToString().Replace("RRF_UseAllModelDaysGreaterThan=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("RRF_MinumumNumberOfDaysRequiredAboveFixedAmount="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("RRF_MinumumNumberOfDaysRequiredAboveFixedAmount=", "")) >= 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("RRF_MinumumNumberOfDaysRequiredAboveFixedAmount=", "")) <= 90)
                            batchDailyPM.RRF_MinumumNumberOfDaysRequiredAboveFixedAmount = Convert.ToInt32(arrayList[i].ToString().Replace("RRF_MinumumNumberOfDaysRequiredAboveFixedAmount=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("RRF_DoUseTopXNumber="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseTopXNumber=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseTopXNumber=", "")) == 1)
                        {
                            batchDailyPM.RRF_DoUseTopXNumber = Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseTopXNumber=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("RRF_UseTopXNumber="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("RRF_UseTopXNumber=", "")) > 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("RRF_UseTopXNumber=", "")) <= 90)
                            batchDailyPM.RRF_UseTopXNumber = Convert.ToInt32(arrayList[i].ToString().Replace("RRF_UseTopXNumber=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                }
                string msg = CheckBatch(batchDailyPM);
                if (msg != "" && msg.Length != 0)
                {
                    WriteBatchLogFile("Wrong cfg : " + msg, strFile + ".log");
                    for (int i = 0; i < arrayList.Count; i++)
                    {
                        WriteBatchLogFile("           " + arrayList[i], strFile + ".log");
                    }
                }
                else
                {
                    batchDailyPM.BatchText = arrayList;
                    batchBase = batchDailyPM as BatchBase;
                }
                return batchBase;
            }
            catch
            {
                return null;
            }
        }

        public static BatchBase ReadBatchFileOzone(ArrayList arrayList, string strFile)
        {
            try
            {
                //-------------------------------------
                //-----判断文件是否存在----------------
                //if (!File.Exists(strFile)) return null;
                BatchOzone batchOzone = new BatchOzone();
                BatchBase batchBase = null;
                for (int i = 0; i < arrayList.Count; i++)
                {
                    if (arrayList[i].ToString().Contains("scenarioName="))
                    {
                        batchOzone.scenarioName = arrayList[i].ToString().Replace("scenarioName=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doPointEstimatesForecast="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doPointEstimatesForecast=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doPointEstimatesForecast=", "")) == 1)
                        {
                            batchOzone.doPointEstimatesForecast = Convert.ToInt32(arrayList[i].ToString().Replace("doPointEstimatesForecast=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyModelData="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelData=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelData=", "")) == 1)
                        {
                            batchOzone.doQuarterlyModelData = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelData=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doSpatialFieldEstimates="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doSpatialFieldEstimates=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doSpatialFieldEstimates=", "")) == 1)
                        {
                            batchOzone.doSpatialFieldEstimates = Convert.ToInt32(arrayList[i].ToString().Replace("doSpatialFieldEstimates=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doSpatialFieldEstimatesGradAdj="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doSpatialFieldEstimatesGradAdj=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doSpatialFieldEstimatesGradAdj=", "")) == 1)
                        {
                            batchOzone.doSpatialFieldEstimatesGradAdj = Convert.ToInt32(arrayList[i].ToString().Replace("doSpatialFieldEstimatesGradAdj=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doBaseOnlyVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doBaseOnlyVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doBaseOnlyVNA=", "")) == 1)
                        {
                            batchOzone.doBaseOnlyVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doBaseOnlyVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doFutureOnlyVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doFutureOnlyVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doFutureOnlyVNA=", "")) == 1)
                        {
                            batchOzone.doFutureOnlyVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doFutureOnlyVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doBaseOnlyEvna="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doBaseOnlyEvna=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doBaseOnlyEvna=", "")) == 1)
                        {
                            batchOzone.doBaseOnlyEvna = Convert.ToInt32(arrayList[i].ToString().Replace("doBaseOnlyEvna=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doFutureOnlyEvna="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doFutureOnlyEvna=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doFutureOnlyEvna=", "")) == 1)
                        {
                            batchOzone.doFutureOnlyEvna = Convert.ToInt32(arrayList[i].ToString().Replace("doFutureOnlyEvna=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doNeighborFileSpatial="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doNeighborFileSpatial=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doNeighborFileSpatial=", "")) == 1)
                        {
                            batchOzone.doNeighborFileSpatial = Convert.ToInt32(arrayList[i].ToString().Replace("doNeighborFileSpatial=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doAutomaticallyExtract="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doAutomaticallyExtract=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doAutomaticallyExtract=", "")) == 1)
                        {
                            batchOzone.doAutomaticallyExtract = Convert.ToInt32(arrayList[i].ToString().Replace("doAutomaticallyExtract=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doDesignValuePeriods="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doDesignValuePeriods=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doDesignValuePeriods=", "")) == 1)
                        {
                            batchOzone.doDesignValuePeriods = Convert.ToInt32(arrayList[i].ToString().Replace("doDesignValuePeriods=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("ozoneMonitorDataFile="))
                    {
                        batchOzone.ozoneMonitorDataFile = arrayList[i].ToString().Replace("ozoneMonitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doInputfromCmaq="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doInputfromCmaq=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doInputfromCmaq=", "")) == 1)
                        {
                            batchOzone.doInputfromCmaq = Convert.ToInt32(arrayList[i].ToString().Replace("doInputfromCmaq=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("baselineModelDataFile="))
                    {
                        batchOzone.baselineModelDataFile = arrayList[i].ToString().Replace("baselineModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("forecastModelDataFile="))
                    {
                        batchOzone.forecastModelDataFile = arrayList[i].ToString().Replace("forecastModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("temporalAdjustmentAtMonitorGrid="))
                    {
                        batchOzone.temporalAdjustmentAtMonitorGrid = arrayList[i].ToString().Replace("temporalAdjustmentAtMonitorGrid=", "");
                    }
                    else if (arrayList[i].ToString().Contains("temporalAdjustmentType="))
                    {
                        batchOzone.temporalAdjustmentType = arrayList[i].ToString().Replace("temporalAdjustmentType=", "");
                    }
                    //需要判断
                    else if (arrayList[i].ToString().Contains("ozoneStartYear="))
                    {
                        batchOzone.ozoneStartYear = arrayList[i].ToString().Replace("ozoneStartYear=", "");
                    }
                    else if (arrayList[i].ToString().Contains("ozoneEndYear="))
                    {
                        batchOzone.ozoneEndYear = arrayList[i].ToString().Replace("ozoneEndYear=", "");
                    }
                    else if (arrayList[i].ToString().Contains("minNumDV="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("minNumDV=", "")) >= 1
                            && Convert.ToInt32(arrayList[i].ToString().Replace("minNumDV=", "")) <= 3)
                            batchOzone.minNumDV = Convert.ToInt32(arrayList[i].ToString().Replace("minNumDV=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("requiredDVPeriods="))
                    {
                        batchOzone.requiredDVPeriods = arrayList[i].ToString().Replace("requiredDVPeriods=", "");
                    }
                    else if (arrayList[i].ToString().Contains("defaultInterpolationMethod="))
                    {
                        batchOzone.defaultInterpolationMethod = arrayList[i].ToString().Replace("defaultInterpolationMethod=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doCheckToSetMaxDistance="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doCheckToSetMaxDistance=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doCheckToSetMaxDistance=", "")) == 1)
                        {
                            batchOzone.doCheckToSetMaxDistance = Convert.ToInt32(arrayList[i].ToString().Replace("doCheckToSetMaxDistance=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("maxDistance="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("maxDistance=", "")) >= 0)
                            batchOzone.maxDistance = Convert.ToInt32(arrayList[i].ToString().Replace("maxDistance=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("useInitialThresholdValue="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("useInitialThresholdValue=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("useInitialThresholdValue=", "")) == 1)
                        {
                            batchOzone.useInitialThresholdValue = Convert.ToInt32(arrayList[i].ToString().Replace("useInitialThresholdValue=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("initialThresholdValue="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("initialThresholdValue=", "")) >= 0)
                            batchOzone.initialThresholdValue = arrayList[i].ToString().Replace("initialThresholdValue=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("minNumofDaysAtorAboveThreshold="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("minNumofDaysAtorAboveThreshold=", "")) > 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("minNumofDaysAtorAboveThreshold=", "")) <= 90)
                            batchOzone.minNumofDaysAtorAboveThreshold = arrayList[i].ToString().Replace("minNumofDaysAtorAboveThreshold=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("topXmodeledozonedays="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("topXmodeledozonedays=", "")) > 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("topXmodeledozonedays=", "")) <= 153)
                            batchOzone.topXmodeledozonedays = arrayList[i].ToString().Replace("topXmodeledozonedays=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("minAllowableThresholdValue="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("minAllowableThresholdValue=", "")) >= 0)
                            batchOzone.minAllowableThresholdValue = arrayList[i].ToString().Replace("minAllowableThresholdValue=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("minNumDaysAtorAboveMinAllowableThreshold="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("minNumDaysAtorAboveMinAllowableThreshold=", "")) > 0
                            && Convert.ToInt32(arrayList[i].ToString().Replace("minNumDaysAtorAboveMinAllowableThreshold=", "")) <= 90)
                            batchOzone.minNumDaysAtorAboveMinAllowableThreshold = arrayList[i].ToString().Replace("minNumDaysAtorAboveMinAllowableThreshold=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doBackstop="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doBackstop=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doBackstop=", "")) == 1)
                        {
                            batchOzone.doBackstop = Convert.ToInt32(arrayList[i].ToString().Replace("doBackstop=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("backstopMinThresholdforSpatialField="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("backstopMinThresholdforSpatialField=", "")) >= 0)
                            batchOzone.backstopMinThresholdforSpatialField = arrayList[i].ToString().Replace("backstopMinThresholdforSpatialField=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("subrangeFirstDay="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("subrangeFirstDay=", "")) >= 0)
                            batchOzone.subrangeFirstDay = Convert.ToInt32(arrayList[i].ToString().Replace("subrangeFirstDay=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("subrangeLastDay="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("subrangeLastDay=", "")) >= 0)
                            batchOzone.subrangeLastDay = Convert.ToInt32(arrayList[i].ToString().Replace("subrangeLastDay=", ""));
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doPairDays="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doPairDays=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doPairDays=", "")) == 1)
                        {
                            batchOzone.doPairDays = Convert.ToInt32(arrayList[i].ToString().Replace("doPairDays=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("SRF_StartValue="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("SRF_StartValue=", "")) >= 0)
                            batchOzone.SRF_StartValue = arrayList[i].ToString().Replace("SRF_StartValue=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("SRF_EndValue="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("SRF_EndValue=", "")) >= 0)
                            batchOzone.SRF_EndValue = arrayList[i].ToString().Replace("SRF_EndValue=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                }
                string msg = CheckBatch(batchOzone);
                if (msg != "" && msg.Length != 0)
                {
                    WriteBatchLogFile("Wrong cfg : " + msg, strFile + ".log");
                    for (int i = 0; i < arrayList.Count; i++)
                    {
                        WriteBatchLogFile("           " + arrayList[i], strFile + ".log");
                    }
                }
                else
                {
                    batchOzone.BatchText = arrayList;
                    batchBase = batchOzone as BatchBase;
                }
                return batchBase;
            }
            catch
            {
                return null;
            }
        }

        public static BatchBase ReadBatchFileVisibility(ArrayList arrayList, string strFile)
        {
            try
            {
                BatchVisibility batchVisibility = new BatchVisibility();
                BatchBase batchBase = null;
                string value = "";
                for (int i = 0; i < arrayList.Count; i++)
                {
                    if (arrayList[i].ToString().Contains("scenarioName="))
                        batchVisibility.scenarioName = arrayList[i].ToString().Replace("scenarioName=", "");
                    else if (arrayList[i].ToString().Contains("doTemporallyAdjVisibilityLevelsForecast="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doTemporallyAdjVisibilityLevelsForecast=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doTemporallyAdjVisibilityLevelsForecast=", "")) == 1)
                        {
                            batchVisibility.doTemporallyAdjVisibilityLevelsForecast = Convert.ToInt32(arrayList[i].ToString().Replace("doTemporallyAdjVisibilityLevelsForecast=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("choiceUseOldVersionforIMPROVEAlgorithm="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("choiceUseOldVersionforIMPROVEAlgorithm=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("choiceUseOldVersionforIMPROVEAlgorithm=", "")) == 1)
                        {
                            batchVisibility.choiceUseOldVersionforIMPROVEAlgorithm = Convert.ToInt32(arrayList[i].ToString().Replace("choiceUseOldVersionforIMPROVEAlgorithm=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("choiceUseNewVersionforIMPROVEAlgorithm="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("choiceUseNewVersionforIMPROVEAlgorithm=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("choiceUseNewVersionforIMPROVEAlgorithm=", "")) == 1)
                        {
                            batchVisibility.choiceUseNewVersionforIMPROVEAlgorithm = Convert.ToInt32(arrayList[i].ToString().Replace("choiceUseNewVersionforIMPROVEAlgorithm=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("choiceUseModelGridCellAtMonitor="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("choiceUseModelGridCellAtMonitor=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("choiceUseModelGridCellAtMonitor=", "")) == 1)
                        {
                            batchVisibility.choiceUseModelGridCellAtMonitor = Convert.ToInt32(arrayList[i].ToString().Replace("choiceUseModelGridCellAtMonitor=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("choiceUseModelGridCellatClassIAreaCentroid="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("choiceUseModelGridCellatClassIAreaCentroid=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("choiceUseModelGridCellatClassIAreaCentroid=", "")) == 1)
                        {
                            batchVisibility.choiceUseModelGridCellatClassIAreaCentroid = Convert.ToInt32(arrayList[i].ToString().Replace("choiceUseModelGridCellatClassIAreaCentroid=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doAutomaticallyExtract="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doAutomaticallyExtract=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doAutomaticallyExtract=", "")) == 1)
                        {
                            batchVisibility.doAutomaticallyExtract = Convert.ToInt32(arrayList[i].ToString().Replace("doAutomaticallyExtract=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("monitorDataFileOldAlgorithm="))
                        batchVisibility.monitorDataFileOldAlgorithm = arrayList[i].ToString().Replace("monitorDataFileOldAlgorithm=", "");

                    else if (arrayList[i].ToString().Contains("monitorDataFileNewAlgorithm="))
                        batchVisibility.monitorDataFileNewAlgorithm = arrayList[i].ToString().Replace("monitorDataFileNewAlgorithm=", "");

                    else if (arrayList[i].ToString().Contains("baselineModelDataFile="))
                        batchVisibility.baselineModelDataFile = arrayList[i].ToString().Replace("baselineModelDataFile=", "");

                    else if (arrayList[i].ToString().Contains("forecastModelDataFile="))
                        batchVisibility.forecastModelDataFile = arrayList[i].ToString().Replace("forecastModelDataFile=", "");


                    else if (arrayList[i].ToString().Contains("forecastIMPROVEDataFile="))
                        batchVisibility.forecastIMPROVEDataFile = arrayList[i].ToString().Replace("forecastIMPROVEDataFile=", "");

                    else if (arrayList[i].ToString().Contains("needCreateForecastIMPROVEDataFile="))
                    {
                        value = arrayList[i].ToString().Replace("needCreateForecastIMPROVEDataFile=", "").Trim();
                        if (value == "0" || value == "1")
                        {
                            batchVisibility.isCreateForecastIMPROVEData = Convert.ToInt32(value) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }

                    else if (arrayList[i].ToString().Contains("checkForecastIMPROVEAdvance="))
                    {
                        value = arrayList[i].ToString().Replace("checkForecastIMPROVEAdvance=", "").Trim();
                        if (value == "0" || value == "1")
                        {
                            batchVisibility.isCheckedForecastIMPROVEAdvanced = Convert.ToInt32(value) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }


                    else if (arrayList[i].ToString().Contains("temporalAdjustmentAtMonitorGrid="))
                        batchVisibility.temporalAdjustmentAtMonitorGrid = arrayList[i].ToString().Replace("temporalAdjustmentAtMonitorGrid=", "");

                    else if (arrayList[i].ToString().Contains("startMonitorYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("startMonitorYear=", "")) >= 2000
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("startMonitorYear=", "")) <= 2014
                            )
                            batchVisibility.startMonitorYear = arrayList[i].ToString().Replace("startMonitorYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("endMonitorYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("endMonitorYear=", "")) >= 2000
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("endMonitorYear=", "")) <= 2014
                               && Convert.ToInt32(arrayList[i].ToString().Replace("endMonitorYear=", "")) >= Convert.ToInt32(batchVisibility.startMonitorYear))
                            batchVisibility.endMonitorYear = arrayList[i].ToString().Replace("endMonitorYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("baseModelYear="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("baseModelYear=", "")) >= 2000
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("baseModelYear=", "")) <= 2014
                            )
                            batchVisibility.baseModelYear = arrayList[i].ToString().Replace("baseModelYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("minYearsForValidVisibilityMonitors="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("minYearsForValidVisibilityMonitors=", "")) >= 1
                                   && Convert.ToInt32(arrayList[i].ToString().Replace("minYearsForValidVisibilityMonitors=", "")) <= 3)
                            batchVisibility.minYearsForValidVisibilityMonitors = arrayList[i].ToString().Replace("minYearsForValidVisibilityMonitors=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                }
                string msg = CheckBatch(batchVisibility);
                if (msg != "" && msg.Length != 0)
                {
                    WriteBatchLogFile("Wrong cfg : " + msg, strFile + ".log");
                    for (int j = 0; j < arrayList.Count; j++)
                    {
                        WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                    }
                }
                else
                {
                    batchVisibility.BatchText = arrayList;
                    batchBase = batchVisibility as BatchBase;
                }
                return batchBase;
            }
            catch
            {
                return null;
            }
        }

        public static BatchBase ReadBatchFileSSIAAnnual(ArrayList arrayList, string strFile)
        {
            try
            {
                BatchSSIAAnnual batchSSIAAnnual = new BatchSSIAAnnual();
                BatchBase batchBase = null;
                for (int i = 0; i < arrayList.Count; i++)
                {
                    if (arrayList[i].ToString().Contains("scenarioName="))
                        batchSSIAAnnual.scenarioName = arrayList[i].ToString().Replace("scenarioName=", "");
                    else if (arrayList[i].ToString().Contains("doCumulativeImpactAnalysis="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doCumulativeImpactAnalysis=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doCumulativeImpactAnalysis=", "")) == 1)
                        {
                            batchSSIAAnnual.doCumulativeImpactAnalysis = Convert.ToInt32(arrayList[i].ToString().Replace("doCumulativeImpactAnalysis=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("useGridAndDispersion="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("useGridAndDispersion=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("useGridAndDispersion=", "")) == 1)
                        {
                            batchSSIAAnnual.useGridAndDispersion = Convert.ToInt32(arrayList[i].ToString().Replace("useGridAndDispersion=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("useGridOnly="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("useGridOnly=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("useGridOnly=", "")) == 1)
                        {
                            batchSSIAAnnual.useGridOnly = Convert.ToInt32(arrayList[i].ToString().Replace("useGridOnly=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("useDispersionOnly="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("useDispersionOnly=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("useDispersionOnly=", "")) == 1)
                        {
                            batchSSIAAnnual.useDispersionOnly = Convert.ToInt32(arrayList[i].ToString().Replace("useDispersionOnly=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doDailyModelDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 1)
                        {
                            batchSSIAAnnual.doDailyModelDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyModelDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 1)
                        {
                            batchSSIAAnnual.doQuarterlyModelDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doInputFromCmaq="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1)
                        {
                            batchSSIAAnnual.doInputFromCmaq = Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("baselineModelDataFile="))
                    {
                        batchSSIAAnnual.baselineModelDataFile = arrayList[i].ToString().Replace("baselineModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("alternativeModelDataFile="))
                    {
                        batchSSIAAnnual.alternativeModelDataFile = arrayList[i].ToString().Replace("alternativeModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("dispersionFile="))
                    {
                        batchSSIAAnnual.dispersionFile = arrayList[i].ToString().Replace("dispersionFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("officialDataFile=") && batchSSIAAnnual.doCumulativeImpactAnalysis)
                    {
                        batchSSIAAnnual.officialDataFile = arrayList[i].ToString().Replace("officialDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("officialPM25StartYear=") && batchSSIAAnnual.doCumulativeImpactAnalysis)
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25StartYear=", "")) >= 1999
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25StartYear=", "")) <= 2014
                            )
                            batchSSIAAnnual.officialPM25StartYear = arrayList[i].ToString().Replace("officialPM25StartYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("officialPM25EndYear=") && batchSSIAAnnual.doCumulativeImpactAnalysis)
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25EndYear=", "")) >= 1999
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25EndYear=", "")) <= 2014
                            && Convert.ToInt32(batchSSIAAnnual.officialPM25StartYear) <= Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25EndYear=", "")))
                            batchSSIAAnnual.officialPM25EndYear = arrayList[i].ToString().Replace("officialPM25EndYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doVNA=") && batchSSIAAnnual.doCumulativeImpactAnalysis)
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1)
                        {
                            batchSSIAAnnual.doVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doEVNA=") && batchSSIAAnnual.doCumulativeImpactAnalysis)
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1)
                        {
                            batchSSIAAnnual.doEVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("temporalAdjustmentAtMonitorGrid="))
                    {
                        batchSSIAAnnual.temporalAdjustmentAtMonitorGrid = arrayList[i].ToString().Replace("temporalAdjustmentAtMonitorGrid=", "");
                    }
                    else if (arrayList[i].ToString().Contains("NAAQS="))
                    {
                        double d = 0;
                        if (double.TryParse(arrayList[i].ToString().Replace("NAAQS=", "").Trim(), out d))
                            batchSSIAAnnual.NAAQS = d.ToString();
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("threshold="))
                    {
                        double d = 0;
                        if (double.TryParse(arrayList[i].ToString().Replace("threshold=", "").Trim(), out d) && d >= 0 && d <= 100)
                            batchSSIAAnnual.threshold = d.ToString();
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("startPercentage="))
                    {
                        int d = 0;
                        if (int.TryParse(arrayList[i].ToString().Replace("startPercentage=", "").Trim(), out d) && d >= 0 && d <= 100)
                            batchSSIAAnnual.startPercentage = d;
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("endPercentage="))
                    {
                        int d = 0;
                        if (int.TryParse(arrayList[i].ToString().Replace("endPercentage=", "").Trim(), out d) && d >= 0 && d <= 100)
                            batchSSIAAnnual.endPercentage = d;
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                }
                string msg = CheckBatch(batchSSIAAnnual);
                if (msg != "" && msg.Length != 0)
                {
                    WriteBatchLogFile("Wrong cfg : " + msg, strFile + ".log");
                    for (int j = 0; j < arrayList.Count; j++)
                    {
                        WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                    }
                }
                else
                {
                    batchSSIAAnnual.BatchText = arrayList;
                    batchBase = batchSSIAAnnual as BatchBase;
                }
                return batchBase;
            }
            catch
            {
                return null;
            }
        }

        public static BatchBase ReadBatchFileSSIADaily(ArrayList arrayList, string strFile)
        {
            try
            {
                BatchSSIADaily batchSSIADaily = new BatchSSIADaily();
                BatchBase batchBase = null;
                for (int i = 0; i < arrayList.Count; i++)
                {
                    if (arrayList[i].ToString().Contains("scenarioName="))
                        batchSSIADaily.scenarioName = arrayList[i].ToString().Replace("scenarioName=", "");
                    else if (arrayList[i].ToString().Contains("doCumulativeImpactAnalysis="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doCumulativeImpactAnalysis=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doCumulativeImpactAnalysis=", "")) == 1)
                        {
                            batchSSIADaily.doCumulativeImpactAnalysis = Convert.ToInt32(arrayList[i].ToString().Replace("doCumulativeImpactAnalysis=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("useGridAndDispersion="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("useGridAndDispersion=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("useGridAndDispersion=", "")) == 1)
                        {
                            batchSSIADaily.useGridAndDispersion = Convert.ToInt32(arrayList[i].ToString().Replace("useGridAndDispersion=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("useGridOnly="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("useGridOnly=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("useGridOnly=", "")) == 1)
                        {
                            batchSSIADaily.useGridOnly = Convert.ToInt32(arrayList[i].ToString().Replace("useGridOnly=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("useDispersionOnly="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("useDispersionOnly=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("useDispersionOnly=", "")) == 1)
                        {
                            batchSSIADaily.useDispersionOnly = Convert.ToInt32(arrayList[i].ToString().Replace("useDispersionOnly=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doDailyModelDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 1)
                        {
                            batchSSIADaily.doDailyModelDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doDailyModelDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doQuarterlyModelDataInput="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 1)
                        {
                            batchSSIADaily.doQuarterlyModelDataInput = Convert.ToInt32(arrayList[i].ToString().Replace("doQuarterlyModelDataInput=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doInputFromCmaq="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1)
                        {
                            batchSSIADaily.doInputFromCmaq = Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("baselineModelDataFile="))
                    {
                        batchSSIADaily.baselineModelDataFile = arrayList[i].ToString().Replace("baselineModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("alternativeModelDataFile="))
                    {
                        batchSSIADaily.alternativeModelDataFile = arrayList[i].ToString().Replace("alternativeModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("dispersionFile="))
                    {
                        batchSSIADaily.dispersionFile = arrayList[i].ToString().Replace("dispersionFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("officialDataFile=") && batchSSIADaily.doCumulativeImpactAnalysis)
                    {
                        batchSSIADaily.officialDataFile = arrayList[i].ToString().Replace("officialDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("officialPM25StartYear=") && batchSSIADaily.doCumulativeImpactAnalysis)
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25StartYear=", "")) >= 1999
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25StartYear=", "")) <= 2014
                            )
                            batchSSIADaily.monitorDataStartYear = arrayList[i].ToString().Replace("officialPM25StartYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("officialPM25EndYear=") && batchSSIADaily.doCumulativeImpactAnalysis)
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25EndYear=", "")) >= 1999
                            //&& Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25EndYear=", "")) <= 2014
                            && Convert.ToInt32(batchSSIADaily.monitorDataEndYear) <= Convert.ToInt32(arrayList[i].ToString().Replace("officialPM25EndYear=", "")))
                            batchSSIADaily.monitorDataEndYear = arrayList[i].ToString().Replace("officialPM25EndYear=", "");
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("temporalAdjustmentAtMonitorGridPoint="))
                    {
                        batchSSIADaily.temporalAdjustmentAtMonitorGridPoint = arrayList[i].ToString().Replace("temporalAdjustmentAtMonitorGridPoint=", "");
                    }
                    else if (arrayList[i].ToString().Contains("temporalAdjustmentAtMonitorGridSpatial="))
                    {
                        batchSSIADaily.temporalAdjustmentAtMonitorGridSpatial = arrayList[i].ToString().Replace("temporalAdjustmentAtMonitorGridSpatial=", "");
                    }
                    else if (arrayList[i].ToString().Contains("temporalAdjustmentType="))
                    {
                        batchSSIADaily.temporalAdjustmentType = arrayList[i].ToString().Replace("temporalAdjustmentType=", "");
                    }
                    else if (arrayList[i].ToString().Contains("RRF_DoUseXTopPercent="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseXTopPercent=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseXTopPercent=", "")) == 1)
                        {
                            batchSSIADaily.RRF_DoUseXTopPercent = Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseXTopPercent=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("RRF_DoUseTopXNumber="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseTopXNumber=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseTopXNumber=", "")) == 1)
                        {
                            batchSSIADaily.RRF_DoUseTopXNumber = Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseTopXNumber=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("RRF_DoUseAllModelDaysGreaterThan="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseAllModelDaysGreaterThan=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseTopXNumber=", "")) == 1)
                        {
                            batchSSIADaily.RRF_DoUseAllModelDaysGreaterThan = Convert.ToInt32(arrayList[i].ToString().Replace("RRF_DoUseAllModelDaysGreaterThan=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("RRF_MinumumNumberOfDaysRequiredAboveFixedAmount="))
                    {
                        batchSSIADaily.RRF_MinumumNumberOfDaysRequiredAboveFixedAmount = Convert.ToInt32(arrayList[i].ToString().Replace("RRF_MinumumNumberOfDaysRequiredAboveFixedAmount=", ""));
                    }
                    else if (arrayList[i].ToString().Contains("RRF_UseAllModelDaysGreaterThan="))
                    {
                        batchSSIADaily.RRF_UseAllModelDaysGreaterThan = Convert.ToInt32(arrayList[i].ToString().Replace("RRF_UseAllModelDaysGreaterThan=", ""));
                    }
                    else if (arrayList[i].ToString().Contains("RRF_UseXTopPercent="))
                    {
                        batchSSIADaily.RRF_UseXTopPercent = Convert.ToInt32(arrayList[i].ToString().Replace("RRF_UseXTopPercent=", ""));
                    }
                    else if (arrayList[i].ToString().Contains("RRF_UseTopXNumber="))
                    {
                        batchSSIADaily.RRF_UseTopXNumber = Convert.ToInt32(arrayList[i].ToString().Replace("RRF_UseTopXNumber=", ""));
                    }
                    else if (arrayList[i].ToString().Contains("NAAQS="))
                    {
                        double d = 0;
                        if (double.TryParse(arrayList[i].ToString().Replace("NAAQS=", "").Trim(), out d))
                            batchSSIADaily.NAAQS = d.ToString();
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("threshold="))
                    {
                        double d = 0;
                        if (double.TryParse(arrayList[i].ToString().Replace("threshold=", "").Trim(), out d) && d >= 0 && d <= 100)
                            batchSSIADaily.threshold = d.ToString();
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("startPercentage="))
                    {
                        int d = 0;
                        if (int.TryParse(arrayList[i].ToString().Replace("startPercentage=", "").Trim(), out d) && d >= 0 && d <= 100)
                            batchSSIADaily.startPercentage = d;
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("endPercentage="))
                    {
                        int d = 0;
                        if (int.TryParse(arrayList[i].ToString().Replace("endPercentage=", "").Trim(), out d) && d >= 0 && d <= 100)
                            batchSSIADaily.endPercentage = d;
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1)
                        {
                            batchSSIADaily.useVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doEVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1)
                        {
                            batchSSIADaily.useEVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                }
                string msg = CheckBatch(batchSSIADaily);
                if (msg != "" && msg.Length != 0)
                {
                    WriteBatchLogFile("Wrong cfg : " + msg, strFile + ".log");
                    for (int j = 0; j < arrayList.Count; j++)
                    {
                        WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                    }
                }
                else
                {
                    batchSSIADaily.BatchText = arrayList;
                    batchBase = batchSSIADaily as BatchBase;
                }
                return batchBase;
            }
            catch (Exception)
            {
                return null;
            }
        }

        public static BatchBase ReadBatchFileSSIAOzone(ArrayList arrayList, string strFile)
        {
            try
            {
                BatchSSIAOzone batchSSIAOzone = new BatchSSIAOzone();
                BatchBase batchBase = null;
                for (int i = 0; i < arrayList.Count; i++)
                {
                    if (arrayList[i].ToString().Contains("scenarioName="))
                        batchSSIAOzone.scenarioName = arrayList[i].ToString().Replace("scenarioName=", "");
                    else if (arrayList[i].ToString().Contains("doCumulativeImpactAnalysis="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doCumulativeImpactAnalysis=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doCumulativeImpactAnalysis=", "")) == 1)
                        {
                            batchSSIAOzone.doCumulativeImpactAnalysis = Convert.ToInt32(arrayList[i].ToString().Replace("doCumulativeImpactAnalysis=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doInputFromCmaq="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1)
                        {
                            batchSSIAOzone.doInputFromCmaq = Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("baselineModelDataFile="))
                    {
                        batchSSIAOzone.baselineModelDataFile = arrayList[i].ToString().Replace("baselineModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("alternativeModelDataFile="))
                    {
                        batchSSIAOzone.alternativeModelDataFile = arrayList[i].ToString().Replace("alternativeModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("monitorDataFile=") && batchSSIAOzone.doCumulativeImpactAnalysis)
                    {
                        batchSSIAOzone.monitorDataFile = arrayList[i].ToString().Replace("monitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("ozoneStartYear="))
                    {
                        batchSSIAOzone.ozoneStartYear = arrayList[i].ToString().Replace("ozoneStartYear=", "");
                    }
                    else if (arrayList[i].ToString().Contains("ozoneEndYear="))
                    {
                        batchSSIAOzone.ozoneEndYear = arrayList[i].ToString().Replace("ozoneEndYear=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doVNA=") && batchSSIAOzone.doCumulativeImpactAnalysis)
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1)
                        {
                            batchSSIAOzone.doVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doEVNA=") && batchSSIAOzone.doCumulativeImpactAnalysis)
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1)
                        {
                            batchSSIAOzone.doEVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("temporalAdjustmentAtMonitorGrid="))
                    {
                        batchSSIAOzone.temporalAdjustmentAtMonitorGrid = arrayList[i].ToString().Replace("temporalAdjustmentAtMonitorGrid=", "");
                    }
                    else if (arrayList[i].ToString().Contains("temporalAdjustmentType="))
                    {
                        batchSSIAOzone.temporalAdjustmentType = arrayList[i].ToString().Replace("temporalAdjustmentType=", "");
                    }
                    else if (arrayList[i].ToString().Contains("NAAQS="))
                    {
                        double d = 0;
                        if (double.TryParse(arrayList[i].ToString().Replace("NAAQS=", "").Trim(), out d))
                            batchSSIAOzone.NAAQS = d.ToString();
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("threshold="))
                    {
                        double d = 0;
                        if (double.TryParse(arrayList[i].ToString().Replace("threshold=", "").Trim(), out d) && d >= 0 && d <= 100)
                            batchSSIAOzone.threshold = d.ToString();
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("startPercentage="))
                    {
                        int d = 0;
                        if (int.TryParse(arrayList[i].ToString().Replace("startPercentage=", "").Trim(), out d) && d >= 0 && d <= 100)
                            batchSSIAOzone.startPercentage = d;
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("endPercentage="))
                    {
                        int d = 0;
                        if (int.TryParse(arrayList[i].ToString().Replace("endPercentage=", "").Trim(), out d) && d >= 0 && d <= 100)
                            batchSSIAOzone.endPercentage = d;
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                }
                string msg = CheckBatch(batchSSIAOzone);
                if (msg != "" && msg.Length != 0)
                {
                    WriteBatchLogFile("Wrong cfg : " + msg, strFile + ".log");
                    for (int j = 0; j < arrayList.Count; j++)
                    {
                        WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                    }
                }
                else
                {
                    batchSSIAOzone.BatchText = arrayList;
                    batchBase = batchSSIAOzone as BatchBase;
                }
                return batchBase;
            }
            catch
            {
                return null;
            }
        }

        public static BatchBase ReadBatchFileSSIADeposition(ArrayList arrayList, string strFile)    //added by Lijiabin
        {
            try
            {
                BatchSSIADeposition batchSSIADeposition = new BatchSSIADeposition();
                BatchBase batchBase = null;
                for (int i = 0; i < arrayList.Count; i++)
                {
                    if (arrayList[i].ToString().Contains("scenarioName="))
                        batchSSIADeposition.scenarioName = arrayList[i].ToString().Replace("scenarioName=", "");
                    else if (arrayList[i].ToString().Contains("baselineModelDataFile="))
                    {
                        batchSSIADeposition.baselineModelDataFile = arrayList[i].ToString().Replace("baselineModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("alternativeModelDataFile="))
                    {
                        batchSSIADeposition.alternativeModelDataFile = arrayList[i].ToString().Replace("alternativeModelDataFile=", "");
                    }
                    //else if (arrayList[i].ToString().Contains("NAAQS="))
                    //{
                    //    double d = 0;
                    //    if (double.TryParse(arrayList[i].ToString().Replace("NAAQS=", "").Trim(), out d))
                    //        batchSSIADeposition.NAAQS = d.ToString();
                    //    else
                    //    {
                    //        WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                    //        for (int j = 0; j < arrayList.Count; j++)
                    //        {
                    //            WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                    //        }
                    //        return null;
                    //    }
                    //}
                    else if (arrayList[i].ToString().Contains("threshold="))
                    {
                        double d = 0;
                        if (double.TryParse(arrayList[i].ToString().Replace("threshold=", "").Trim(), out d) && d >= 0 && d <= 100)
                            batchSSIADeposition.threshold = d.ToString();
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                }
                string msg = CheckBatch(batchSSIADeposition);
                if (msg != "" && msg.Length != 0)
                {
                    WriteBatchLogFile("Wrong cfg : " + msg, strFile + ".log");
                    for (int j = 0; j < arrayList.Count; j++)
                    {
                        WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                    }
                }
                else
                {
                    batchSSIADeposition.BatchText = arrayList;
                    batchBase = batchSSIADeposition as BatchBase;
                }
                return batchBase;
            }
            catch
            {
                return null;
            }
        }

        public static BatchBase ReadBatchFileBenMAPOzone(ArrayList arrayList, string strFile)
        {
            try
            {
                BatchBenMapOzone batchBenMapOzone = new BatchBenMapOzone();
                BatchBase batchBase = null;
                for (int i = 0; i < arrayList.Count; i++)
                {
                    if (arrayList[i].ToString().Contains("scenarioName="))
                        batchBenMapOzone.scenarioName = arrayList[i].ToString().Replace("scenarioName=", "");
                    else if (arrayList[i].ToString().Contains("doInputFromCmaq="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1)
                        {
                            batchBenMapOzone.doInputFromCmaq = Convert.ToInt32(arrayList[i].ToString().Replace("doInputFromCmaq=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("baselineModelDataFile="))
                    {
                        batchBenMapOzone.baselineModelDataFile = arrayList[i].ToString().Replace("baselineModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("alternativeModelDataFile="))
                    {
                        batchBenMapOzone.alternativeModelDataFile = arrayList[i].ToString().Replace("alternativeModelDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("monitorDataFile="))
                    {
                        batchBenMapOzone.monitorDataFile = arrayList[i].ToString().Replace("monitorDataFile=", "");
                    }
                    else if (arrayList[i].ToString().Contains("ozoneStartYear="))
                    {
                        batchBenMapOzone.ozoneStartYear = arrayList[i].ToString().Replace("ozoneStartYear=", "");
                    }
                    else if (arrayList[i].ToString().Contains("ozoneEndYear="))
                    {
                        batchBenMapOzone.ozoneEndYear = arrayList[i].ToString().Replace("ozoneEndYear=", "");
                    }
                    else if (arrayList[i].ToString().Contains("doVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1)
                        {
                            batchBenMapOzone.doVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    else if (arrayList[i].ToString().Contains("doEVNA="))
                    {
                        if (Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 0 || Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1)
                        {
                            batchBenMapOzone.doEVNA = Convert.ToInt32(arrayList[i].ToString().Replace("doEVNA=", "")) == 1 ? true : false;
                        }
                        else
                        {
                            WriteBatchLogFile("Wrong cfg : data format is not correct in the line " + Convert.ToString(i) + " !", strFile + ".log");
                            for (int j = 0; j < arrayList.Count; j++)
                            {
                                WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                            }
                            return null;
                        }
                    }
                    //else if (arrayList[i].ToString().Contains("temporalAdjustmentAtMonitorGrid="))
                    //{
                    //    batchBenMapOzone.temporalAdjustmentAtMonitorGrid = arrayList[i].ToString().Replace("temporalAdjustmentAtMonitorGrid=", "");
                    //}
                    //else if (arrayList[i].ToString().Contains("temporalAdjustmentType="))
                    //{
                    //    batchBenMapOzone.temporalAdjustmentType = arrayList[i].ToString().Replace("temporalAdjustmentType=", "");
                    //}
                    else if (arrayList[i].ToString().Contains("gridDefinitionFile="))
                    {
                        batchBenMapOzone.gridDifinition = arrayList[i].ToString().Replace("gridDefinitionFile=", "");
                    }
                }
                string msg = CheckBatch(batchBenMapOzone);
                if (msg != "" && msg.Length != 0)
                {
                    WriteBatchLogFile("Wrong cfg : " + msg, strFile + ".log");
                    for (int j = 0; j < arrayList.Count; j++)
                    {
                        WriteBatchLogFile("           " + arrayList[j], strFile + ".log");
                    }
                }
                else
                {
                    batchBenMapOzone.BatchText = arrayList;
                    batchBase = batchBenMapOzone as BatchBase;
                }
                return batchBase;
            }
            catch
            {
                return null;
            }
        }

        /// <summary>
        /// write log file
        /// </summary>
        /// <param name="msg"></param>
        /// <param name="strFile"></param>
        public static void WriteBatchLogFile(string msg, string strFile)
        {
            try
            {
                if (!File.Exists(strFile))
                {
                    FileStream fsCreate = File.Create(strFile);
                    fsCreate.Close();
                }
                FileStream fs = new FileStream(strFile, FileMode.Append);
                StreamWriter streamWriter = new StreamWriter(fs, Encoding.UTF8);
                streamWriter.BaseStream.Seek(0, SeekOrigin.End);
                streamWriter.WriteLine(msg);
                streamWriter.Flush();
                fs.Close();
            }
            catch
            {
            }
        }

        /// <summary>
        /// check batch file
        /// </summary>
        /// <param name="batchBase"></param>
        /// <returns></returns>
        public static string CheckBatch(BatchBase batchBase)
        {
            try
            {
                string msg = "";
                //----主要Check文件是否存在
                if (batchBase is BatchAnnualPM)
                {
                    BatchAnnualPM batchAnnual = batchBase as BatchAnnualPM;
                    if (batchAnnual.doSpeciesMonitorDataFile)
                    {
                        if (!File.Exists(batchAnnual.speciesMonitorDataFile)) return msg = "Species Monitor Data File does not exist !";
                    }
                    else if (batchAnnual.doSpeciesFractionFile)
                    {
                        //在data input窗体中选择了species fractions，则不能选择neighbor files，前面的output 要与后面的data input对应。
                        //----------选了spatial field，则前面只能选择spatial field，gradient adjustment不能选，反之亦然
                        if (batchAnnual.doNeighborFilePoint || batchAnnual.doNeighborFileSpatial) return msg = "Using species fractions file. Disable neighbor file creation.";
                        if (batchAnnual.specFracModeSpatial == "spatial field")
                        {
                            if (batchAnnual.doInterpolatedSFETempAdj_GradAdj || batchAnnual.doQuarterlyAvgFileSpatial_GraAdj || batchAnnual.doSpeciesFractionSpatial_GraAdj) return msg = "You cannot generate gradient adjusted spatial interpolations based on a non gradient adjusted spatial species fractions file ! ";
                        }
                        else if (batchAnnual.specFracModeSpatial == "grad adj spatial field")
                        {
                            if (batchAnnual.doInterpolatedSFETempAdj || batchAnnual.doQuarterlyAvgFileSpatial || batchAnnual.doSpeciesFractionSpatial || batchAnnual.doNeighborFileSpatial)
                                return msg = "You cannot generate spatial interpolations based on a gradient adjusted spatial species fractions file.";
                        }
                        if (!File.Exists(batchAnnual.specFracPointFile)) return msg = "Species Fractions File - Point does not exist !";
                        if (!File.Exists(batchAnnual.specFracSpatialFile)) return msg = "Species Fractions File - Spatial Field does not exist !";
                    }
                    if (!File.Exists(batchAnnual.unofficialMonitorDataFile)) return msg = "Unofficial Daily Average PM2.5 Data File does not exist !";
                    if (!File.Exists(batchAnnual.officialMonitorDataFile)) return msg = "Official Quarterly Average PM2.5 Data File does not exist !";
                    if (!File.Exists(batchAnnual.baselineModelDataFile)) return msg = "Baseline Model Data File does not exist !";
                    if (!File.Exists(batchAnnual.forecastModelDataFile)) return msg = "Forecast Model Data File does not exist !";
                }
                else if (batchBase is BatchDailyPM)
                {
                    BatchDailyPM batchDailyPM = batchBase as BatchDailyPM;
                    if (batchDailyPM.doSpeciesMonitorDataFile)
                    { if (!File.Exists(batchDailyPM.speciesMonitorDataFile)) return msg = "Species Monitor Data File does not exist !"; }
                    else if (batchDailyPM.doSpeciesFractionFile)
                    {
                        if (!File.Exists(batchDailyPM.specFracPointFile)) return msg = "Species Fractions File - Point does not exist !";
                        if (!File.Exists(batchDailyPM.specFracSpatialFile)) return msg = "Species Fractions File - Spatial Field does not exist !";
                    }
                    if (!File.Exists(batchDailyPM.unofficialMonitorFile)) return msg = "Unofficial Daily Average PM2.5 Data File does not exist !";
                    if (!File.Exists(batchDailyPM.officialMonitorFile)) return msg = "Official Daily Average PM2.5 Data File does not exist !";
                    if (!File.Exists(batchDailyPM.baselineModelFile)) return msg = "Baseline Model Data File does not exist !";
                    if (!File.Exists(batchDailyPM.forecastModelFile)) return msg = "Forecast Model Data File does not exist !";
                }
                else if (batchBase is BatchOzone)
                {
                    BatchOzone batchOzone = batchBase as BatchOzone;
                    if (!File.Exists(batchOzone.ozoneMonitorDataFile)) return msg = "Ozone Monitor Data File does not exist !";
                    if (!File.Exists(batchOzone.baselineModelDataFile)) return msg = "Baseline Model Data File does not exist !";
                    if (!File.Exists(batchOzone.forecastModelDataFile)) return msg = "Forecast Model Data File does not exist !";
                }
                else if (batchBase is BatchVisibility)
                {
                    BatchVisibility batchVisibility = batchBase as BatchVisibility;
                    if (batchVisibility.choiceUseNewVersionforIMPROVEAlgorithm)
                    {
                        if (!File.Exists(batchVisibility.monitorDataFileNewAlgorithm)) return msg = "IMPROVE Monitor Data File - New Algorithm does not exist !";
                    }
                    else if (batchVisibility.choiceUseOldVersionforIMPROVEAlgorithm)
                    {
                        if (!File.Exists(batchVisibility.monitorDataFileOldAlgorithm)) return msg = "IMPROVE Monitor Data File - Old Algorithm does not exist !";
                    }
                    if (!File.Exists(batchVisibility.baselineModelDataFile)) return msg = "Baseline Model Data File does not exist !";
                    if (!File.Exists(batchVisibility.forecastModelDataFile)) return msg = "Forecast Model Data File does not exist !";
                }
                else if (batchBase is BatchSSIAAnnual)
                {
                    BatchSSIAAnnual batchSSIAAnnual = batchBase as BatchSSIAAnnual;
                    if (!batchSSIAAnnual.useDispersionOnly)
                    {
                        if (!File.Exists(batchSSIAAnnual.baselineModelDataFile)) return msg = "Baseline Model Data File does not exist !";
                        if (!File.Exists(batchSSIAAnnual.alternativeModelDataFile)) return msg = "Alternative Scenario Model Data File does not exist !";
                    }
                    if (!batchSSIAAnnual.useGridOnly)
                    {
                        if (!File.Exists(batchSSIAAnnual.dispersionFile)) return msg = "Dispersion Model Data File does not exist !";
                    }
                    if (batchSSIAAnnual.doCumulativeImpactAnalysis && !File.Exists(batchSSIAAnnual.officialDataFile)) return msg = "Official Quarterly Average PM2.5 Data File does not exist !";
                    if (batchSSIAAnnual.startPercentage > batchSSIAAnnual.endPercentage) return msg = "End percentage should be bigger than start percentage !";
                }
                else if (batchBase is BatchSSIAOzone)
                {
                    BatchSSIAOzone batchSSIAOzone = batchBase as BatchSSIAOzone;
                    if (!File.Exists(batchSSIAOzone.baselineModelDataFile)) return msg = "Baseline Model Data File does not exist !";
                    if (!File.Exists(batchSSIAOzone.alternativeModelDataFile)) return msg = "Alternative Scenario Model Data File does not exist !";
                    if (batchSSIAOzone.doCumulativeImpactAnalysis && !File.Exists(batchSSIAOzone.monitorDataFile)) return msg = "Ozone monitor Data File does not exist !";
                    if (batchSSIAOzone.startPercentage > batchSSIAOzone.endPercentage) return msg = "End percentage should be bigger than start percentage !";
                }
                else if (batchBase is BatchSSIADeposition)    //added by Lijiabin
                {
                    BatchSSIADeposition batchSSIADeposition = batchBase as BatchSSIADeposition;
                    if (!File.Exists(batchSSIADeposition.baselineModelDataFile)) return msg = "Baseline Model Data File does not exist !";
                    if (!File.Exists(batchSSIADeposition.alternativeModelDataFile)) return msg = "Alternative Scenario Model Data File does not exist !";
                }
                else if (batchBase is BatchSSIADaily)
                {
                    BatchSSIADaily batchSSIADaily = batchBase as BatchSSIADaily;
                    if (!batchSSIADaily.useDispersionOnly)
                    {
                        if (!File.Exists(batchSSIADaily.baselineModelDataFile)) return msg = "Baseline Model Data File does not exist !";
                        if (!File.Exists(batchSSIADaily.alternativeModelDataFile)) return msg = "Alternative Scenario Model Data File does not exist !";
                    }
                    if (!batchSSIADaily.useGridOnly)
                    {
                        if (!File.Exists(batchSSIADaily.dispersionFile)) return msg = "Dispersion Model Data File does not exist !";
                    }
                    if (batchSSIADaily.doCumulativeImpactAnalysis && !File.Exists(batchSSIADaily.officialDataFile)) return msg = "Official PM2.5 Data File does not exist !";
                    if (batchSSIADaily.startPercentage > batchSSIADaily.endPercentage) return msg = "End percentage should be bigger than start percentage !";
                }
                return msg;
            }
            catch (Exception ex)
            {
                return ex.Message;
            }

        }
    }
}
