using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using ProtoBuf;
using System.Data;
using LumenWorks.Framework.IO.Csv;
using System.Collections;
using System.Windows.Forms;
using System.Data.OleDb;
using DotSpatial.Topology.Voronoi;
using System.Runtime.InteropServices;
using System.Text.RegularExpressions;
using System.Drawing;
using System.Xml;


namespace SMAT_CE
{
    public class CommonClass
    {
        #region project information
        public static string projUSACMAQ = "+proj=lcc +lat_1=33 +lat_2=45 +lat_0=40 +lon_0=-97 +a=6370000.0 +b=6370000.0";
        public static string projUSAAERMOD = "+proj=utm +zone=16 +datum=NAD83 +ellps=WGS84";
        public static string projChina = "+x_0=0 +y_0=0 +lat_0=34 +lon_0=110 +lat_1=25 +lat_2=40 +proj=lcc +datum=wgs84 +no_defs";//for china
        public static string projOther = "+x_0=0 +y_0=0 +lat_0=34 +lon_0=110 +lat_1=25 +lat_2=40 +proj=lcc +datum=wgs84 +no_defs";//Other region
        //public static string projChina = "+x_0=0 +y_0=0 +lat_0=30 +lon_0=112 +lat_1=25 +lat_2=40 +proj=lcc +datum=wgs84 +no_defs";//for shenzhen
        public static bool currentProjisLCC()
        {
            if (CommonClass.CurrentBaseScenario != null && ((CommonClass.CurrentBaseScenario.configuration is SSIAAnnualPMAnalysisConfiguration && (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA != null && (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useDispersionOnly) || (CommonClass.CurrentBaseScenario.configuration is SSIADailyPMAnalysisConfiguration && (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD != null && (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useDispersionOnly)))
            {
                return false;
            }
            return true;
        }

        //use in calculate vna - usa
        public static DotSpatial.Topology.Polygon generatePolygonWithinUSA(string model)
        {
            double[] dConvertArray = null;
            List<double> lstConvertArray = new List<double>();
            lstConvertArray.Add(-121.5367); lstConvertArray.Add(47.3921);
            lstConvertArray.Add(-112.0372); lstConvertArray.Add(46.6568);
            lstConvertArray.Add(-90.6937); lstConvertArray.Add(46.6298);
            lstConvertArray.Add(-83.0164); lstConvertArray.Add(41.6843);
            lstConvertArray.Add(-74.0386); lstConvertArray.Add(41.5823);
            lstConvertArray.Add(-83.1890); lstConvertArray.Add(31.4584);
            lstConvertArray.Add(-97.4922); lstConvertArray.Add(32.7920);
            lstConvertArray.Add(-109.9439); lstConvertArray.Add(33.0041);
            lstConvertArray.Add(-120.3418); lstConvertArray.Add(37.1646);

            dConvertArray = lstConvertArray.ToArray();
            List<DotSpatial.Topology.Coordinate> lstUSA = new List<DotSpatial.Topology.Coordinate>();

            if (model == "AERMOD")
            {
                DotSpatial.Projections.Reproject.ReprojectPoints(dConvertArray, null,
                      DotSpatial.Projections.KnownCoordinateSystems.Geographic.World.WGS1984, DotSpatial.Projections.ProjectionInfo.FromProj4String(CommonClass.projUSAAERMOD), 0, dConvertArray.Length / 2);

                for (int i = 0; i < dConvertArray.Length / 2; i++)
                {
                    lstUSA.Add(new DotSpatial.Topology.Coordinate((dConvertArray[2 * i] - 738547) / 100.0, (dConvertArray[2 * i + 1] - 3724842) / 100.0));
                }
            }
            else
            {
                DotSpatial.Projections.Reproject.ReprojectPoints(dConvertArray, null,
                   DotSpatial.Projections.KnownCoordinateSystems.Geographic.World.WGS1984, DotSpatial.Projections.ProjectionInfo.FromProj4String(CommonClass.projUSACMAQ), 0, dConvertArray.Length / 2);

                for (int i = 0; i < dConvertArray.Length / 2; i++)
                {
                    lstUSA.Add(new DotSpatial.Topology.Coordinate(dConvertArray[2 * i] / 100.0, dConvertArray[2 * i + 1] / 100.0));
                }
            }
            DotSpatial.Topology.Polygon pUSA = new DotSpatial.Topology.Polygon(lstUSA);
            return pUSA;
        }
        #endregion

        private static string _resultFilePath = "";

        public static string ResultFilePath
        {
            get
            {
                if (_resultFilePath == "")
                {
                    _resultFilePath = Environment.GetFolderPath(System.Environment.SpecialFolder.MyDocuments) + @"\My SMAT-CE Files";
                }
                return CommonClass._resultFilePath;
            }
            set { CommonClass._resultFilePath = value; }
        }

        public static string versionSMATChina = "0.2";
        public static Dictionary<string, Dictionary<string, SaveBlend>> dicBlend = new Dictionary<string, Dictionary<string, SaveBlend>>();
        public static Dictionary<string, Tuple<double, double>> dicLayerValueRange = new Dictionary<string, Tuple<double, double>>();

        /// <summary>
        /// 是否为betaVersion
        /// </summary>
        public static bool BetaVersion
        {
            get { return System.Configuration.ConfigurationManager.AppSettings["BetaVersion"] == "T"; }
        }
        /// <summary>
        /// record Version Number, avoid to using System.Reflection.Assembly.GetExecutingAssembly().GetName().Version several times
        /// by sclong
        /// </summary>
        public static string VersionNumber
        {
            get
            {
                string[] arr = System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString().Split('.');

                return string.Format("{0}.{1}", arr[0], arr[1]);// System.Configuration.ConfigurationManager.AppSettings["BetaVersion"] == "T" ? "1.2.1" : "1.2.1";// System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString().Substring(0, System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString().Count() - 4).ToString(); 
            }
        }

         /// <summary>
        /// add by Devin
        /// 2019-07-24
        /// 示例数据的配置文件
        /// </summary>
        public static Dictionary<string, Dictionary<string, string>> dicExampleConfiguration;

        //added by Yangwenwei
        public class SaveBlend
        {
            public SaveBlend(Color[] c, double[] d)
            {
                colorarray = new Color[c.Count()];
                c.CopyTo(colorarray, 0);
                value = new double[d.Count()];
                d.CopyTo(value, 0);
            }
            public Color[] colorarray;
            public double[] value;
            public double min;
            public double max;
        }

        #region DrawMAP
        /// <summary>
        /// Model对象
        /// </summary>
        public static ModelDefinition modelDefinition = null;

        /// <summary>
        /// 保存ShapeLCC 文件
        /// </summary>
        private static double[,] _ShapeLCC;
        public static double[,] ShapeLCC
        {
            get { return _ShapeLCC; }
            set { _ShapeLCC = value; }
        }

        /// <summary>
        /// 网格值的最小值
        /// </summary>
        public static double minValue;

        //读取Shape文件时的分隔号
        private static Regex _regex = new Regex(".");
        /// <summary>
        /// 解析ShapeLCC文件
        /// </summary>
        /// <returns></returns>
        ///  // 正则表达式
        public static double[,] ParseShapeLcc(string strPath)
        {
            string msg = "";
            double[,] shapeLcc = new double[0, 0];
            try
            {
                if (!File.Exists(strPath))
                {
                    msg = "Invalid ShapeLcc File!\t";
                    return null;
                }
                string[] datas = File.ReadAllLines(strPath, Encoding.Default);
                if (datas == null || datas.Length == 0)
                {
                    msg = "Invalid ShapeLcc File!\t";
                    return null;
                }
                shapeLcc = new double[datas.Length - 1, 3];
                _regex = new Regex(",");
                string[] vars;
                int count = 0;
                // 设置
                for (int i = 1; i < datas.Length; i++)
                {
                    strPath = datas[i];
                    vars = _regex.Split(strPath);
                    shapeLcc[count, 0] = double.Parse(vars[0]);
                    shapeLcc[count, 1] = double.Parse(vars[1]);
                    shapeLcc[count, 2] = double.Parse(vars[2]);
                    count++;
                }
                return shapeLcc;
            }
            catch (Exception ex)
            {
                msg = "Invalid ShapeLcc File!\t";
                CommonClass.LogError(ex);
                return null;
            }
            finally
            {
                if (msg != "") { MessageBox.Show(msg, "Tip", MessageBoxButtons.OK, MessageBoxIcon.Exclamation); }
            }
        }


        #region LogError
        private static string CRLF = "\r\n";           // 结束符

        /// <summary>
        /// 记录发生的错误
        /// 重载1
        /// </summary>
        /// <param name="ex">Exception对象</param>
        public static void LogError(Exception ex)
        {
            try
            {
                Console.WriteLine(ex.ToString());
                string place = ex.StackTrace.ToString();
                int pos = place.LastIndexOf("\n");
                //Debug.WriteLine(ex.Message+"\n"+msg+"\n"+ex.StackTrace.ToString());
                // 如果找不到,pos=-1,C#中字符索引是从0开始的
                string msg = CRLF + DateTime.Now.ToString() + CRLF + ex.Message + CRLF + place.Substring(pos + 1);
                //Debug.WriteLine(msg);
                AppendErr(GetLogPath(ex), msg);
                //Debug.WriteLine(System.Threading.Thread.GetDomain().GetAssemblies().ToString());
            }
            catch (Exception myEx)
            {
                string errMsg = CRLF + DateTime.Now.ToString() + CRLF + myEx.Message + "  " + "CommonClass.LogError,1";
                Console.WriteLine(errMsg);
            }
        }

        /// <summary>
        /// 记录发生的错误
        /// 重载2
        /// </summary>
        /// <param name="ex">Exception对象</param>
        /// <param name="msg">附加的自定义信息</param>
        public static void LogError(Exception ex, string msg)
        {
            try
            {
                string place = ex.StackTrace.ToString();
                int pos = place.LastIndexOf("\n");

                //Debug.WriteLine(ex.Message+"\n"+msg+"\n"+ex.StackTrace.ToString());
                // 如果找不到,pos=-1,C#中字符索引是从0开始的
                string myMsg = CRLF + DateTime.Now.ToString() + CRLF + ex.Message + CRLF + msg + CRLF + place.Substring(pos + 1);
                //Debug.WriteLine(myMsg);
                AppendErr(GetLogPath(ex), myMsg);
            }
            catch (Exception myEx)
            {
                string errMsg = CRLF + DateTime.Now.ToString() + CRLF + myEx.Message + "  " + "CommonClass.LogError,2";
                Console.WriteLine(errMsg);
            }
        }

        /// <summary>
        /// 记录发生的错误
        /// 重载3
        /// </summary>
        /// <param name="msg">自定义的错误信息</param>
        public static void LogError(string msg)
        {
            try
            {
                //Debug.WriteLine("\n"+msg+"  "+DateTime.Now.ToString());
                string myMsg = CRLF + DateTime.Now.ToString() + CRLF + msg;
                // 必须保证 c:\Err_log\目录存在,并且asp_net有权写入
                //AppendErr("c:\\Err_Log\\Err_.log",myMsg);
                AppendErr(GetLogPath(null), myMsg);
            }
            catch (Exception myEx)
            {
                string errMsg = CRLF + DateTime.Now.ToString() + CRLF + myEx.Message + CRLF + "CommonClass.LogError,3";
                Console.WriteLine(errMsg);
            }
        }

        /// <summary>
        /// 从app.config(或web.config)的appSettings节中获取记录错误日志的文件全路径.<br />
        /// 如果配置节不存在,则在DataManager.dll所在目录下创建err_log.log
        /// </summary>
        /// <param name="ex"></param>
        /// <returns>文件全路径</returns>
        private static string GetLogPath(Exception ex)
        {
            try
            {
                string logPath;
                // 用于Web程序必须保证 c:\Err_log\目录存在,并且asp_net有权写入
                //logPath="c:\\Err_Log\\Err_"+ex.Source+".log";

                // 以下两个路径都指向c:\windows\system32
                //logPath=Directory.GetCurrentDirectory()+"\\Err_"+ex.Source+".log";
                //logPath=ex.Source+".log";

                // 此做法将在组件所在目录记录错误日志
                //logPath = "Err_" + ex.Source + ".log";
                //logPath = Directory.GetCurrentDirectory() + "\\ErrorLog.log";
                //logPath = "ErrorLog.log";

                // Get the appSettings.
                // 即使配置文件里不存在appSettings这个节,也不会出错
                //System.Collections.Specialized.NameValueCollection appSettings = ConfigurationManager.AppSettings;

                //logPath = appSettings["errorLogFile"];

                //if (logPath == null)
                //{
                logPath = AppDomain.CurrentDomain.BaseDirectory + "\\err_log.log";
                logPath = logPath.Replace("\\\\", "\\");
                //}
                CheckAndCreateDir(logPath);
                return logPath;
            }
            catch (Exception myEx)
            {
                string errMsg = CRLF + DateTime.Now.ToString() + CRLF + myEx.Message + CRLF + "CommonClass.GetLogPath";
                Console.WriteLine(errMsg);
                return "err_log.log";
            }
        }

        /// <summary>
        /// 检查会议的文件全路径,创建所有不存在的目录.(注:不创建文件)
        /// </summary>
        /// <param name="path">文件全路径,必须包含文件名.如: D:\Test\test.txt</param>
        private static void CheckAndCreateDir(string path)
        {
            try
            {
                string dir;
                int pos = path.LastIndexOf("\\");
                dir = path.Substring(0, pos);
                if (Directory.Exists(dir) == false)
                {
                    // 创建路径中 所有 不存在的目录
                    Directory.CreateDirectory(dir);
                }
                //return;
            }
            catch (Exception ex)
            {
                string errMsg = CRLF + DateTime.Now.ToString() + "\\rn" + ex.ToString() + "\r\npath=" + path + CRLF + "CommonClass.CheckAndCreateDir";
                Console.WriteLine(errMsg);
            }
        }

        /// <summary>
        /// 将错误信息追加到错误日志
        /// </summary>
        /// <param name="path">错误日志文件位置,如:"c:\\Err_Log\\err_myUtil.log"</param>
        /// <param name="msg">错误信息</param>
        private static void AppendErr(string path, string msg)
        {
            try
            {
                // 路径里的文件可以不存在,但目录必须存在,否则会报错?
                //				StreamWriter writer;
                //				if (File.Exists(path)) {
                //					writer=File.AppendText(path);
                //				}else{
                //					writer=File.CreateText(path);
                //				}
                StreamWriter writer = new StreamWriter(path, true);
                writer.WriteLine(msg);
                writer.Close();
                Console.WriteLine(msg);
            }
            catch (Exception myEx)
            {
                string errMsg = CRLF + DateTime.Now.ToString() + CRLF + myEx.Message + CRLF + "CommonClass.AppendErr";
                Console.WriteLine(errMsg);
            }
        }

        #endregion LogError
        #endregion
        #region ini

        /*
         * RRFLimit=0.001
GradLimit=0.001

#all pm
species_calc_precision=7
species_fraction_precision=7
pm_defaultformat=%.7f

#daily pm
pm_daily_base_output_precision=1
pm_daily_future_output_precision=4
pm_daily_output_precisionfuture_final=1

#ozone Section
o3base_precision=1
o3future_precision=1
f_o3_dv=%.1f
daily_leapyearaction=1
         */
        private static double rrfLimit = 0.001;

        public static double RrfLimit
        {
            get { return CommonClass.rrfLimit; }
            set { CommonClass.rrfLimit = value; }
        }
        private static double gradLimit = 0.001;

        public static double GradLimit
        {
            get { return CommonClass.gradLimit; }
            set { CommonClass.gradLimit = value; }
        }
        private static int species_calc_precision = 7;

        public static int Species_calc_precision
        {
            get { return species_calc_precision; }
            set { species_calc_precision = value; }
        }
        private static int species_fraction_precision = 7;

        public static int Species_fraction_precision
        {
            get { return species_fraction_precision; }
            set { species_fraction_precision = value; }
        }
        private static int pm_defaultformat = 7;

        public static int Pm_defaultformat
        {
            get { return pm_defaultformat; }
            set { pm_defaultformat = value; }
        }
        private static int pm_daily_base_output_precision = 1;

        public static int Pm_daily_base_output_precision
        {
            get { return pm_daily_base_output_precision; }
            set { pm_daily_base_output_precision = value; }
        }
        private static int pm_daily_future_output_precision = 4;

        public static int Pm_daily_future_output_precision
        {
            get { return pm_daily_future_output_precision; }
            set { pm_daily_future_output_precision = value; }
        }
        private static int pm_daily_output_precisionfuture_final = 1;

        public static int Pm_daily_output_precisionfuture_final
        {
            get { return pm_daily_output_precisionfuture_final; }
            set { pm_daily_output_precisionfuture_final = value; }
        }
        private static int o3base_precision = 1;

        public static int O3base_precision
        {
            get { return o3base_precision; }
            set { o3base_precision = value; }
        }
        private static int o3future_precision = 1;

        public static int O3future_precision
        {
            get { return o3future_precision; }
            set { o3future_precision = value; }
        }
        private static int f_o3_dv = 1;

        public static int F_o3_dv
        {
            get { return f_o3_dv; }
            set { f_o3_dv = value; }
        }
        private static int daily_leapyearaction = 1;

        public static int Daily_leapyearaction
        {
            get { return daily_leapyearaction; }
            set { daily_leapyearaction = value; }
        }

        private static int visibility_calculation_decimal_point = 2;
        /// <summary>
        /// re-calculate and fixed the deciview values (dv_best, dv_worst, base_best, base_worst) to the decimal point=2.
        /// </summary>
        public static int Visibility_calculation_decimal_point
        {
            get { return visibility_calculation_decimal_point; }
            set { visibility_calculation_decimal_point = value; }
        }

        [DllImport("kernel32.dll")]
        private static extern long WritePrivateProfileString(string section, string key, string val, string filePath);
        [DllImport("kernel32.dll")]
        private static extern int GetPrivateProfileString(string section, string key, string def, StringBuilder retVal, int size, string filePath);
        /// <summary>
        /// 写入INI文件
        /// </summary>
        /// <param name=^Section^>节点名称</param>
        /// <param name=^Key^>关键字</param>
        /// <param name=^Value^>值</param>
        /// <param name=^filepath^>INI文件路径</param>
        static public void IniWriteValue(string Section, string Key, string Value, string filepath)
        {
            WritePrivateProfileString(Section, Key, Value, filepath);
        }
        /// <summary>
        /// 读取INI文件
        /// </summary>
        /// <param name=^Section^>节点名称</param>
        /// <param name=^Key^>关键字</param>
        /// <param name=^filepath^>INI文件路径</param>
        /// <returns>值</returns>
        static public string IniReadValue(string Section, string Key, string filepath)
        {
            StringBuilder temp = new StringBuilder(255);
            int i = GetPrivateProfileString(Section, Key, "", temp, 255, filepath);
            return temp.ToString();
        }
        /// <summary>
        /// 从Ini文件中提取所有属性
        /// </summary>
        public static void GetAllIniFromFile()
        {
            try
            {
                string iniPath = Application.StartupPath + @"\SMAT.ini";
                rrfLimit = Convert.ToDouble(IniReadValue("all", "RRFLimit", iniPath));
                gradLimit = Convert.ToDouble(IniReadValue("all", "GradLimit", iniPath));
                species_calc_precision = Convert.ToInt32(IniReadValue("all pm", "species_calc_precision", iniPath));
                species_fraction_precision = Convert.ToInt32(IniReadValue("all pm", "species_fraction_precision", iniPath));
                pm_defaultformat = Convert.ToInt32(IniReadValue("all pm", "pm_defaultformat", iniPath).Replace("%.", "").Replace("f", ""));

                pm_daily_base_output_precision = Convert.ToInt32(IniReadValue("daily pm", "pm_daily_base_output_precision", iniPath));
                pm_daily_future_output_precision = Convert.ToInt32(IniReadValue("daily pm", "pm_daily_future_output_precision", iniPath));
                pm_daily_output_precisionfuture_final = Convert.ToInt32(IniReadValue("daily pm", "pm_daily_output_precisionfuture_final", iniPath));

                o3base_precision = Convert.ToInt32(IniReadValue("ozone Section", "o3base_precision", iniPath));
                o3future_precision = Convert.ToInt32(IniReadValue("ozone Section", "o3future_precision", iniPath));
                f_o3_dv = Convert.ToInt32(IniReadValue("ozone Section", "f_o3_dv", iniPath).Replace("%.", "").Replace("f", ""));
                daily_leapyearaction = Convert.ToInt32(IniReadValue("ozone Section", "daily_leapyearaction", iniPath));

                visibility_calculation_decimal_point = Convert.ToInt32(IniReadValue("Visibility", "Visibility_calculation_decimal_point", iniPath));

            }
            catch (Exception)
            {
            }
        }
        #endregion
        #region save input file path
        public static string speciesMonitorFile;
        public static string speciesFractionFilePoint;
        public static string speciesFractionFileSpatial;
        public static string unofficialPMFile;
        public static string officialPMFile;
        public static string baseModelFile;
        public static string futureModelFile;
        public static string dispersionModelFile;
        public static string monitorFile;
        public static string ozoneMonitorFile;
        //public static string improveAlgorithmNew;
        //public static string improveAlgorithmOld;
        public static string shapefile;
        public static string ssiasourcefile;
        public static string improveforecast;
        #endregion
        /// <summary>
        /// current log改变后做相应处理
        /// </summary>
        public delegate void CurrentLogChangedStartHandler();

        #region define an event:当commonclass中新添加一条log后触发添加running log
        public static event CurrentLogChangedStartHandler CurrentLogChanged;

        public static void OnCurrentLogChanged()
        {
            if (CurrentLogChanged != null)
            {
                CurrentLogChanged();
            }
        }
        #endregion
        public delegate void CurrentProgressBarChangedStartHandler();
        #region define an event:从方法中传出一个参数，然后触发进度条前进
        public static event CurrentProgressBarChangedStartHandler CurrentProgressBarChanged;

        public static void OnCurrentProgressBarChanged()
        {
            if (CurrentProgressBarChanged != null)
            {
                CurrentProgressBarChanged();
            }
        }
        #endregion

        #region Serialization
        /// <summary>
        /// 序列化，保存scenario
        /// </summary>
        /// <param name="baseScenario"></param>
        /// <param name="strScenarioPath">scenario *.asrx存储路径</param>
        public static void SaveScenario(BaseScenario baseScenario, string strScenarioPath)
        {
            try
            {
                if (File.Exists(strScenarioPath))
                    File.Delete(strScenarioPath);
                using (FileStream fs = new FileStream(strScenarioPath, FileMode.OpenOrCreate))
                {
                    Serializer.Serialize<BaseScenario>(fs, baseScenario);
                    fs.Close();
                    fs.Dispose();
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        /// 加载scenario
        /// </summary>
        /// <param name="strScenarioPath">scenario的存储路径</param>
        /// <returns></returns>
        public static BaseScenario LoadScenario(string strScenarioPath)
        {
            using (FileStream fs = new FileStream(strScenarioPath, FileMode.Open))
            {
                try
                {
                    BaseScenario baseScenario = Serializer.Deserialize<BaseScenario>(fs);
                    fs.Close();
                    fs.Dispose();
                    baseScenario.ToUserDocument();
                    return baseScenario;
                }
                catch (Exception)
                {
                    fs.Close();
                    fs.Dispose();
                    return null;
                }
            }
        }

        /// <summary>
        /// Save CFG
        /// </summary>
        /// <param name="baseConfiguration">cfg</param>
        /// <param name="strCFGPath">文件保存路径</param>
        public static void SaveCFG(BaseConfiguration baseConfiguration, string strCFGPath)
        {
            try
            {
                if (File.Exists(strCFGPath))
                    File.Delete(strCFGPath);
                using (FileStream fs = new FileStream(strCFGPath, FileMode.OpenOrCreate))
                {
                    Serializer.Serialize<BaseConfiguration>(fs, baseConfiguration);
                    fs.Close();
                    fs.Dispose();
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        /// 保存run log
        /// </summary>
        /// <param name="baseLog">log</param>
        /// <param name="strLogPath">保存路径</param>
        public static void SaveLog(BaseLog baseLog, string strLogPath, bool needSerialize)
        {
            try
            {
                if (File.Exists(strLogPath))
                    File.Delete(strLogPath);

                if (needSerialize)//序列化输出
                {
                    using (FileStream fs = new FileStream(strLogPath, FileMode.OpenOrCreate))
                    {
                        Serializer.Serialize<BaseLog>(fs, baseLog);
                        fs.Close();
                        fs.Dispose();
                    }
                }
                else//文本格式输出
                {
                    FileInfo myFile = new FileInfo(strLogPath);
                    using (StreamWriter sW = myFile.CreateText())
                    {
                        foreach (var s in baseLog.lstLog)
                        {
                            sW.WriteLine(s);
                        }
                        sW.Close();
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        #endregion

        #region Excel
        /// <summary>
        /// 读取CSV文件转化为Datatable，列名在第一行
        /// </summary>
        /// <param name="strPath">file directory</param>
        /// <returns>datatable</returns>
        public static System.Data.DataSet getDataSetFromCSV(string strPath)
        {
            try
            {
                System.Data.DataSet ds = new System.Data.DataSet();
                System.Data.DataTable dt = new DataTable();
                using (CsvReader csv =
               new CsvReader(new StreamReader(strPath), true))
                {
                    int fieldCount = csv.FieldCount;

                    string[] headers = csv.GetFieldHeaders();
                    foreach (string s in headers)
                    {
                        dt.Columns.Add(s);

                    }
                    while (csv.ReadNextRecord())
                    {
                        DataRow dr = dt.NewRow();
                        for (int i = 0; i < fieldCount; i++)
                        {
                            dr[i] = csv[i];
                        }
                        dt.Rows.Add(dr);
                    }
                    ds.Tables.Add(dt);
                }
                return ds;
            }
            catch (Exception)
            {
                return null;
            }
        }

        #region dian
        public static List<string> getListYearsFromCSV(string strPath)
        {
            try
            {
                //要与只读方式打开csv文件，可以防止excel文档被占用问题 added by sclong 20120917 20:50
                #region
                FileStream fs = new FileStream(strPath, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                StreamReader sr = new StreamReader(fs, System.Text.Encoding.UTF8);
                #endregion
                List<string> lstYear = new List<string>();
                //Dictionary<string, string> dicYears = new Dictionary<string, string>();
                sr.ReadLine();
                if (currentAnalysis == enumAnalysis.OzoneChina)
                    sr.ReadLine();
                string strLine = sr.ReadLine();
                strLine = strLine.Replace(" ", "");
                strLine = strLine.Replace("\"", "");
                string[] aryline = strLine.Split(new char[] { ',' });
                int n = 0;
                if (currentAnalysis == enumAnalysis.Ozone || currentAnalysis == enumAnalysis.SSIAOzone || currentAnalysis == enumAnalysis.BenMAPSeasonalOzone)
                {
                    while (aryline[n].Trim().ToLower() != "dvyear")
                    {
                        n++;
                    }
                }
                else if (currentAnalysis == enumAnalysis.AnnualPMChina)
                {
                    while (aryline[n].Trim().ToLower() != "quarter_dv")
                    {
                        n++;
                    }
                }
                else if (currentAnalysis == enumAnalysis.OzoneChina)
                {
                    while (aryline[n].Trim().ToLower() != "season_dv")
                    {
                        n++;
                    }
                }
                else
                {
                    while (aryline[n].Trim().ToLower() != "date")
                    {
                        n++;
                    }
                }
                while (sr.Peek() > 0)
                {
                    strLine = sr.ReadLine();
                    aryline = strLine.Split(new char[] { ',' });
                    try
                    {
                        if (Convert.ToInt32(aryline[n]) > 0)
                        {
                            if (!lstYear.Contains(aryline[n].Substring(0, 4)))
                                lstYear.Add(aryline[n].Substring(0, 4));
                            //if (!dicYears.ContainsKey(aryline[n].Substring(0, 4)))
                            //{
                            //    dicYears.Add(aryline[n].Substring(0, 4), aryline[n].Substring(0, 4));
                            //}
                        }
                    }
                    catch (Exception)
                    {
                    }
                }
                fs.Dispose();
                sr.Dispose();
                //lstYear = dicYears.Select(q => q.Value).ToList();
                return lstYear;
            }
            catch (Exception ex)//modified by sclong 20120917
            {
                CommonClass.LogError(ex);
                //MessageBox.Show(ex.Message, "Tip", MessageBoxButtons.OK, MessageBoxIcon.Information);
                return null;
            }
        }

        public static int getOzoneModelMaxDays(string strPath)
        {
            try
            {
                //要与只读方式打开csv文件，可以防止excel文档被占用问题 added by sclong 20120917 20:50
                FileStream fs = new FileStream(strPath, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                StreamReader sr = new StreamReader(fs, System.Text.Encoding.UTF8);
                sr.ReadLine();
                string strLine = sr.ReadLine();
                strLine = strLine.Replace(" ", "");
                strLine = strLine.Replace("\"", "");
                string[] aryline = strLine.Split(new char[] { ',' });
                int n = 0;
                List<DateTime> lstDays = new List<DateTime>();
                while (aryline[n].Trim().ToLower() != "date")
                {
                    n++;
                }
                while (sr.Peek() > 0)
                {
                    strLine = sr.ReadLine();
                    aryline = strLine.Split(new char[] { ',' });
                    try
                    {
                        DateTime time = DateTime.ParseExact(aryline[n].Trim(), "yyyyMMdd", null);
                        if (!lstDays.Contains(time))
                            lstDays.Add(time);
                    }
                    catch
                    { }
                }
                fs.Dispose();
                sr.Dispose();
                return lstDays.Count;
            }
            catch
            {
                return 0;
            }
        }
        #endregion
        /// <summary>
        /// 获取state name
        /// </summary>
        /// <param name="dt"></param>
        /// <returns></returns>
        public static List<string> getStateListFromCSV(DataTable dt)
        {
            try
            {
                //-First get State Column ID
                int iState = -1;
                List<string> lstStateNames = new List<string>();
                for (int i = 0; i < dt.Columns.Count; i++)
                {
                    if (dt.Columns[i].ColumnName.Trim().ToLower().Contains("state") || dt.Columns[i].ColumnName.Trim().ToLower().Contains("location"))
                    {
                        iState = i;
                    }
                }
                if (iState == -1) return null;
                foreach (DataRow dr in dt.Rows)
                {
                    if (!lstStateNames.Contains(dr[iState].ToString().Replace("\"", "")) && (dr[iState].ToString() != "" || dr[iState].ToString().Length > 0))
                    {
                        lstStateNames.Add(dr[iState].ToString().Replace("\"", ""));
                    }

                }
                return lstStateNames;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return null;
            }
        }
        public static List<string> getStateListFromCSV(string filePath)
        {
            try
            {
                //-----------获取stateName---------
                //要与只读方式打开csv文件，可以防止excel文档被占用问题
                #region
                FileStream fs = new FileStream(filePath, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                StreamReader sr = new StreamReader(fs, System.Text.Encoding.UTF8);
                #endregion
                Dictionary<string, string> dicStateNames = new Dictionary<string, string>();
                sr.ReadLine();
                string strLine = sr.ReadLine();
                string[] aryline = strLine.Split(new char[] { ',' });
                int n = 0;
                while (!aryline[n].Trim().ToLower().Contains("state") && aryline.Count() < n)
                {
                    n++;
                }

                while (sr.Peek() > 0)
                {
                    strLine = sr.ReadLine();
                    aryline = strLine.Split(new char[] { ',' });
                    if (aryline[n].Length > 0)
                    {
                        if (!dicStateNames.ContainsKey(aryline[n].Replace("\"", "")))
                        {
                            dicStateNames.Add(aryline[n].Replace("\"", ""), aryline[n].Replace("\"", ""));
                        }
                    }
                }
                List<string> lstStateNames = new List<string>();
                lstStateNames = dicStateNames.Select(q => q.Value).ToList();
                return lstStateNames;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return null;
            }
        }

        /// <summary>
        /// 读取CSV中的数据转化为Datatable,第一行为采集频率
        /// </summary>
        /// <param name="strPath">file directory</param>
        /// <param name="strFirstLine">the first line</param>
        /// <returns>return datatable</returns>
        public static System.Data.DataTable getDataSetFromCSVAndFirstLine(string strPath, ref string strFirstLine, ref bool errorOccur, bool saveFile = false)
        {
            try
            {
                //要与只读方式打开csv文件，可以防止excel文档被占用问题
                #region
                FileStream fs = new FileStream(strPath, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                StreamReader sr = new StreamReader(fs, System.Text.Encoding.UTF8);
                #endregion
                System.Data.DataTable dt = new DataTable();
                DataTable dtTemp = getTempDataTableForDataType(strPath);
                //Regex r = new Regex(@"^[+-]?\d*[.]?\d*$");// (@"^[0-9]+");
                //StringBuilder builder = new StringBuilder("");
                double d = 0;
                Dictionary<int, bool> dicType = new Dictionary<int, bool>();
                for (int i = 0; i < dtTemp.Columns.Count; i++)
                {
                    // BenMAP-ready导出文件不包含经纬度2列 ty
                    if (saveFile && strPath.Contains("BenMAP-ready") && (dtTemp.Columns[i].ColumnName.ToLower() == "gridcell_lat" || dtTemp.Columns[i].ColumnName.ToLower() == "gridcell_long"))
                        continue;
                    //

                    if (dtTemp.Columns[i].ColumnName.ToLower() == "_id")
                    {
                        dt.Columns.Add(dtTemp.Columns[i].ColumnName);
                        dicType.Add(i, false);
                        continue;
                    }
                    if (dtTemp.Columns[i].ColumnName.Contains("Delta"))
                        dt.Columns.Add(dtTemp.Columns[i].ColumnName.Replace("Delta", "Δ"));

                    //builder = new StringBuilder("");
                    bool isDouble = true;
                    for (int j = 0; j < dtTemp.Rows.Count; j++)
                    {
                        // builder.Append(dtTemp.Rows[j][i].ToString());
                        if (!double.TryParse(dtTemp.Rows[j][i].ToString(), out d))
                        //if (!r.IsMatch(dtTemp.Rows[j][i].ToString())||dtTemp.Rows[j][i].ToString()=="")
                        {
                            isDouble = false;
                        }
                    }
                    dicType.Add(i, isDouble);
                    if (isDouble)
                    {
                        dt.Columns.Add(dtTemp.Columns[i].ColumnName, typeof(double));
                    }
                    else
                    {
                        dt.Columns.Add(dtTemp.Columns[i].ColumnName);
                    }
                }
                dtTemp.Dispose();
                dtTemp = null;

                if (!(CommonClass._currentBaseScenario.configuration is BenMAPAnnualPMAnalysisConfiguration)
                    && !(CommonClass._currentBaseScenario.configuration is BenMAPOzoneAnalysisConfiguration && strPath.Contains("Ozone Spatial Field"))
                    && (!strPath.Contains("BenMAP-ready")))
                {
                    string fileDataLine = sr.ReadLine();
                    string[] sMatchArray = fileDataLine.Split(new char[] { ',' });
                    strFirstLine = sMatchArray[0];
                    errorOccur = false;
                    if (sr.Peek() == 79)//if next line start with "O"(O3),skip. added by Yangwenwei 
                        sr.ReadLine();
                }
                using (CsvReader csv = new CsvReader(sr, true))
                {
                    int fieldCount = csv.FieldCount;
                    string[] headers = csv.GetFieldHeaders();
                    double u;
                    while (csv.ReadNextRecord())
                    {
                        DataRow dr = dt.NewRow();
                        //try
                        //{
                        bool errorOccurin = false;
                        for (int i = 0; i < fieldCount; i++)
                        {
                            //if (csv[i] == "-9" || csv[i] == "-8")
                            //{
                            //    double csvValue = Convert.ToDouble(csv[i]);
                            //    dr[i] =csvValue;
                            //}
                            //else

                            // BenMAP-ready导出文件不包含经纬度2列 ty
                            if (saveFile && strPath.Contains("BenMAP-ready") && (headers[i].ToLower() == "gridcell_lat" || headers[i].ToLower() == "gridcell_long"))
                                continue;
                            //

                            if (dicType[i] && !double.TryParse(csv[i], out u))
                            {
                                errorOccurin = true;
                                errorOccur = true;
                                break;
                            }
                            dr[i] = csv[i];
                        }
                        if (!errorOccurin)
                            dt.Rows.Add(dr);
                        //}
                        //catch
                        //{
                        //    errorOccur = true;
                        //}
                    }
                    csv.Dispose();
                }
                fs.Dispose();
                sr.Dispose();
                return dt;
                //---------判断------------------第一个采集频率
                //string[] sMatchArray = fileDataLine.Split(new char[] { ',' });
                //strFirstLine = sMatchArray[0];

                //string strLine = "";
                ////ds = new System.Data.DataSet();

                //DataRow dr = null;
                //string[] strArray;
                //strLine = sr.ReadLine();
                //if (strLine != null && strLine.Length > 0)
                //{
                //    strArray = strLine.Split(',');
                //    for (int i = 0; i < strArray.Count(); i++)
                //    {
                //        dt.Columns.Add(strArray[i].Trim());
                //    }
                //}
                //while (strLine != null)
                //{
                //    strLine = sr.ReadLine();
                //    if (strLine != null && strLine.Length > 0)
                //    {
                //        dr = dt.NewRow();
                //        strArray = strLine.Split(',');
                //        for (int i = 0; i < strArray.Count(); i++)
                //        {
                //            dr[i] = strArray[i].Replace("\"", "");
                //        }
                //        dt.Rows.Add(dr);
                //    }
                //}
                ////ds.Tables.Add(dt);
                ////return ds;
                //return dt;
            }
            catch (Exception)
            {
                return null;
            }
        }

        public static DataTable getDataTableForQuarterlyMonitors(string filePath, ref string strFirstLine)
        {
            try
            {
                //要与只读方式打开csv文件，可以防止excel文档被占用问题
                #region
                FileStream fs = new FileStream(filePath, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                StreamReader sr = new StreamReader(fs, System.Text.Encoding.UTF8);
                #endregion
                System.Data.DataTable dt = new DataTable();
                string fileDataLine = sr.ReadLine();
                string[] sMatchArray = fileDataLine.Split(new char[] { ',' });
                strFirstLine = sMatchArray[0];
                using (CsvReader csv = new CsvReader(sr, true))
                {
                    int fieldCount = csv.FieldCount;
                    string[] headers = csv.GetFieldHeaders();
                    foreach (string s in headers)
                    {
                        if (s.ToLower().Contains("_state_name") || s.ToLower().Contains("_county_name") || s.ToLower().Contains("type") || s.ToLower().Contains("_visibility_rank") || s.ToLower().Contains("_id"))
                            dt.Columns.Add(s);
                        else
                            dt.Columns.Add(s, typeof(double));
                    }
                    while (csv.ReadNextRecord())
                    {
                        DataRow dr = dt.NewRow();
                        for (int i = 0; i < fieldCount; i++)
                        {
                            dr[i] = csv[i];
                        }
                        dt.Rows.Add(dr);
                    }
                    csv.Dispose();
                }
                fs.Dispose();
                sr.Dispose();
                return dt;
            }
            catch (Exception)
            {
                return null;
            }
        }

        public static DataTable getTempDataTableForDataType(string filePath)
        {
            try
            {
                #region
                FileStream fs = new FileStream(filePath, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                StreamReader sr = new StreamReader(fs, System.Text.Encoding.UTF8);
                #endregion
                DataTable dtTemp = new DataTable();
                if (!(CommonClass._currentBaseScenario.configuration is BenMAPAnnualPMAnalysisConfiguration)
                    && !(CommonClass._currentBaseScenario.configuration is BenMAPOzoneAnalysisConfiguration && filePath.Contains("Ozone Spatial Field"))
                    && (!filePath.Contains("BenMAP-ready")))
                {
                    string fileDataLine = sr.ReadLine();
                    string[] sMatchArray = fileDataLine.Split(new char[] { ',' });
                    string strFirstLine = sMatchArray[0];
                    if (sr.Peek() == 79)//if next line start with "O"(O3),skip. added by Yangwenwei 
                        sr.ReadLine();
                }
                using (CsvReader csv = new CsvReader(sr, true))
                {
                    int fieldCount = csv.FieldCount;
                    string[] headers = csv.GetFieldHeaders();
                    //if (CommonClass.CurrentBaseScenario.configuration is SSIAAnnualPMAnalysisConfiguration || CommonClass.CurrentBaseScenario.configuration is SSIAOzoneAnalysisConfiguration)
                    //{
                    foreach (string s in headers)
                    {
                        dtTemp.Columns.Add(s.Replace("Delta", "Δ"));
                    }
                    //}
                    //else
                    //{
                    //    foreach (string s in headers)
                    //    {
                    //        dtTemp.Columns.Add(s);
                    //    }
                    //}
                    int rowCount = 0;
                    while (csv.ReadNextRecord() && rowCount != 10)
                    {
                        DataRow dr = dtTemp.NewRow();
                        for (int i = 0; i < fieldCount; i++)
                        {
                            dr[i] = csv[i];
                        }
                        dtTemp.Rows.Add(dr);
                        rowCount++;
                    }
                    csv.Dispose();
                    fs.Dispose();
                    sr.Dispose();
                }
                return dtTemp;
            }
            catch (Exception)
            {
                return null;
            }
        }

        /// <summary>
        /// 读取CSV中的数据转化为Datatable,第一行为采集频率
        /// </summary>
        /// <param name="strPath">file directory</param>
        /// <param name="strFirstLine">the first line</param>
        /// <returns>return datatable</returns>
        public static System.Data.DataTable getDataSetFromCSVAndFirstLine(string strPath, ref string strFirstLine, int iMaxRows)
        {
            try
            {
                #region 要与只读方式打开csv文件，可以防止excel文档被占用问题
                FileStream fs = new FileStream(strPath, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                StreamReader sr = new StreamReader(fs, System.Text.Encoding.UTF8);
                #endregion
                //System.Data.DataSet ds = new System.Data.DataSet();
                System.Data.DataTable dt = new DataTable();
                //StreamReader sr = new StreamReader(strPath);
                string fileDataLine = sr.ReadLine();
                string[] sMatchArray = fileDataLine.Split(new char[] { ',' });
                strFirstLine = sMatchArray[0];
                int iRows = 0;
                using (CsvReader csv = new CsvReader(sr, true))
                {
                    int fieldCount = csv.FieldCount;

                    string[] headers = csv.GetFieldHeaders();
                    foreach (string s in headers)
                    {
                        dt.Columns.Add(s);

                    }
                    while (csv.ReadNextRecord() && iRows < iMaxRows)
                    {
                        DataRow dr = dt.NewRow();
                        for (int i = 0; i < fieldCount; i++)
                        {
                            dr[i] = csv[i];
                        }
                        dt.Rows.Add(dr);
                        iRows++;
                    }
                    csv.Dispose();
                    // ds.Tables.Add(dt);
                }
                fs.Dispose();
                sr.Dispose();
                return dt;
                //---------判断------------------第一个采集频率
                //string[] sMatchArray = fileDataLine.Split(new char[] { ',' });
                //strFirstLine = sMatchArray[0];

                //string strLine = "";
                ////ds = new System.Data.DataSet();

                //DataRow dr = null;
                //string[] strArray;
                //strLine = sr.ReadLine();
                //if (strLine != null && strLine.Length > 0)
                //{
                //    strArray = strLine.Split(',');
                //    for (int i = 0; i < strArray.Count(); i++)
                //    {
                //        dt.Columns.Add(strArray[i].Trim());
                //    }
                //}
                //while (strLine != null)
                //{
                //    strLine = sr.ReadLine();
                //    if (strLine != null && strLine.Length > 0)
                //    {
                //        dr = dt.NewRow();
                //        strArray = strLine.Split(',');
                //        for (int i = 0; i < strArray.Count(); i++)
                //        {
                //            dr[i] = strArray[i].Replace("\"", "");
                //        }
                //        dt.Rows.Add(dr);
                //    }
                //}
                ////ds.Tables.Add(dt);
                ////return ds;
                //return dt;
            }
            catch (Exception)
            {
                return null;
            }
        }

        /// <summary>
        /// 当数据为quarterly avg时，将每个点的数据由四行变成一行，只为add to map处理
        /// </summary>
        /// <param name="filePath">文件路径</param>
        /// <returns></returns>
        public static System.Data.DataTable getDataTableForMap(string filePath)
        {
            try
            {
                int iValue = 0, count = 0;
                FileStream fs = new FileStream(filePath, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                StreamReader sr = new StreamReader(fs, System.Text.Encoding.UTF8);
                string firstLine = sr.ReadLine();
                string strLine = "";
                DataTable dtMap = new DataTable();
                DataRow dr = null;
                string[] strArray;
                strLine = sr.ReadLine();
                if (strLine != null && strLine.Length > 0)
                {
                    strArray = strLine.Split(',');
                    for (int i = 0; i < strArray.Count(); i++)
                    {
                        string columnname = strArray[i].Trim();
                        if (columnname.ToLower().Contains("id") || columnname.ToLower().Contains("gridcell") || columnname.ToLower().Contains("long") || columnname.ToLower().Contains("state")
                            || columnname.ToLower().Contains("quarter") || columnname.ToLower().Contains("lat") || columnname.ToLower().Contains("type") || columnname.ToLower().Contains("county")
                            || columnname.ToLower().Contains("date") || columnname.ToLower().Contains("location") || columnname.ToLower().Contains("station"))
                        {
                            if (columnname.ToLower().Contains("quarter") || columnname.ToLower().Contains("date"))
                                iValue = i;
                            if (!columnname.ToLower().Contains("quarter") && !columnname.ToLower().Contains("date"))
                                dtMap.Columns.Add(columnname);
                        }
                        else
                        {
                            if (columnname.Contains("Delta"))
                                columnname = columnname.Replace("Delta", "Δ");
                            for (int j = 1; j <= 4; j++)
                            {
                                dtMap.Columns.Add(columnname + "_q" + j);
                            }
                            count++;
                        }
                    }
                }
                string id = "";
                int k = 0;
                while (strLine != null)
                {
                    strLine = sr.ReadLine();
                    if (strLine == "") continue;
                    if (strLine != null && strLine.Length > 0)
                    {

                        strArray = strLine.Split(',');
                        if (strArray[0] == "") continue;
                        int iArray = strArray.Count();
                        if (id == "")
                        {
                            dr = dtMap.NewRow();
                            id = strArray[0];
                            for (int i = 0; i < iArray; i++)
                            {
                                if (i < iArray - count)
                                {
                                    if (i != iValue)
                                        dr[i] = strArray[i];
                                }
                                else
                                {

                                    if (i == iArray - count)
                                        dr[iArray - count - 1 + k] = strArray[i];
                                    else
                                        dr[iArray - count - 1 + 4 * (i - (iArray - count)) + k] = strArray[i];
                                }
                            }
                            k++;
                        }
                        else
                        {
                            if (id == strArray[0])
                            {
                                for (int i = 0; i < iArray; i++)
                                {
                                    if (i >= iArray - count)
                                    {
                                        if (i == iArray - count)
                                            dr[iArray - count - 1 + k] = strArray[i];
                                        else
                                            dr[iArray - count - 1 + 4 * (i - (iArray - count)) + k] = strArray[i];
                                    }
                                }
                                k++;
                            }
                            else
                            {
                                dtMap.Rows.Add(dr);
                                dr = dtMap.NewRow();
                                k = 0;
                                id = strArray[0];
                                for (int i = 0; i < iArray; i++)
                                {
                                    if (i < iArray - count)
                                    {
                                        if (i != iValue)
                                            dr[i] = strArray[i];
                                    }
                                    else
                                    {
                                        if (i == iArray - count)
                                            dr[iArray - count - 1 + k] = strArray[i];
                                        else
                                            dr[iArray - count - 1 + 4 * (i - (iArray - count)) + k] = strArray[i];
                                    }
                                }
                                k++;
                            }
                        }
                    }
                }
                if (dr != null) dtMap.Rows.Add(dr);
                fs.Dispose();
                sr.Dispose();

                #region Sort
                DataView dv = dtMap.DefaultView;
                dv.Sort = dtMap.Columns[0].ColumnName;
                dtMap = dv.ToTable();
                #endregion

                return dtMap;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return null;
            }
        }


        public static System.Data.DataTable getDataTableForMapDaily(string filePath, BaseScenario baseScenario)
        {
            try
            {
                Dictionary<string, Monitors> dicDailyFile = new Dictionary<string, Monitors>();
                int startYear = Convert.ToInt32((baseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.officialPM25StartYear);
                //int iValue = -1, count = 0;
                DataTable dtMap = new DataTable();
                DataRow dr = null;
                FileStream fs = null;
                StreamReader sr = null;
                fs = new FileStream(filePath, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                sr = new StreamReader(fs, System.Text.Encoding.UTF8);
                string firstLine = sr.ReadLine();
                string strLine = "";
                string[] strArray;
                strLine = sr.ReadLine();
                if (Path.GetFileNameWithoutExtension(filePath).Contains("Daily All Years All Days PM25 Point"))
                {
                    #region
                    int iID = -1, iType = -1, iStateName = -1, iCountyName = -1, iLat = -1, iLong = -1, iGridcell = -1, iDay = -1, iYear = -1, iQuarter = -1, iWater_b = -1, iWater_f = -1, iWater_rrf = -1,
                    iPM_b = -1, iPM_f = -1, iBlankMass_b = -1, iBlankMass_f = -1, iCrustal_b = -1, iNH4_b = -1, iSO4_b = -1, iEC_b = -1, iNO3_b = -1, iOC_b = -1, iSalt_b = -1,
                    iCrustal_f = -1, iNH4_f = -1, iSO4_f = -1, iEC_f = -1, iNO3_f = -1, iOC_f = -1, iSalt_f = -1, iCrustal_rrf = -1, iNH4_rrf = -1, iSO4_rrf = -1, iEC_rrf = -1, iNO3_rrf = -1, iOC_rrf = -1, iSalt_rrf = -1;
                    if (strLine != null && strLine.Length > 0)
                    {
                        strArray = strLine.Split(',');
                        for (int i = 0; i < strArray.Count(); i++)
                        {
                            switch (strArray[i].Trim().ToLower())
                            {
                                case "_id":
                                    iID = i;
                                    break;
                                case "_type":
                                    iType = i;
                                    break;
                                case "_state_name":
                                    iStateName = i;
                                    break;
                                case "_county_name":
                                    iCountyName = i;
                                    break;
                                case "monitor_lat":
                                    iLat = i;
                                    break;
                                case "monitor_long":
                                    iLong = i;
                                    break;
                                case "monitor_gridcell":
                                    iGridcell = i;
                                    break;
                                case "day":
                                    iDay = i;
                                    break;
                                case "year":
                                    iYear = i;
                                    break;
                                case "quarter":
                                    iQuarter = i;
                                    break;
                                case "b_pm25_d_conc":
                                    iPM_b = i;
                                    break;
                                case "f_pm25_d_conc":
                                    iPM_f = i;
                                    break;
                                case "b_blank_mass":
                                    iBlankMass_b = i;
                                    break;
                                case "b_crustal_mass":
                                    iCrustal_b = i;
                                    break;
                                case "b_ec_mass":
                                    iEC_b = i;
                                    break;
                                case "b_nh4_mass":
                                    iNH4_b = i;
                                    break;
                                case "b_ocmb_mass":
                                    iOC_b = i;
                                    break;
                                case "b_so4_mass":
                                    iSO4_b = i;
                                    break;
                                case "b_no3_mass":
                                    iNO3_b = i;
                                    break;
                                case "b_water_mass":
                                    iWater_b = i;
                                    break;
                                case "b_salt_mass":
                                    iSalt_b = i;
                                    break;
                                case "f_blank_mass":
                                    iBlankMass_f = i;
                                    break;
                                case "f_crustal_mass":
                                    iCrustal_f = i;
                                    break;
                                case "f_ec_mass":
                                    iEC_f = i;
                                    break;
                                case "f_nh4_mass":
                                    iNH4_f = i;
                                    break;
                                case "f_ocmb_mass":
                                    iOC_f = i;
                                    break;
                                case "f_so4_mass":
                                    iSO4_f = i;
                                    break;
                                case "f_no3_mass":
                                    iNO3_f = i;
                                    break;
                                case "f_water_mass":
                                    iWater_f = i;
                                    break;
                                case "f_salt_mass":
                                    iSalt_f = i;
                                    break;
                                case "rrf_crustal_q":
                                    iCrustal_rrf = i;
                                    break;
                                case "rrf_ec_q":
                                    iEC_rrf = i;
                                    break;
                                case "rrf_nh4_q":
                                    iNH4_rrf = i;
                                    break;
                                case "rrf_oc_q":
                                    iOC_rrf = i;
                                    break;
                                case "rrf_so4_q":
                                    iSO4_rrf = i;
                                    break;
                                case "rrf_no3_q":
                                    iNO3_rrf = i;
                                    break;
                                case "rrf_water_q":
                                    iWater_rrf = i;
                                    break;
                                case "rrf_salt_q":
                                    iSalt_rrf = i;
                                    break;
                            }
                            if (strArray[i].Trim().ToLower().Contains("id") || strArray[i].Trim().ToLower().Contains("gridcell") || strArray[i].Trim().ToLower().Contains("long") || strArray[i].Trim().ToLower().Contains("state")
                                || strArray[i].Trim().ToLower().Contains("quarter") || strArray[i].Trim().ToLower().Contains("lat") || strArray[i].Trim().ToLower().Contains("type") || strArray[i].Trim().ToLower().Contains("county")
                                || strArray[i].Trim().ToLower().Contains("day") || strArray[i].Trim().ToLower().Contains("year"))
                            {
                                //if (strArray[i].Trim().ToLower().Contains("day"))
                                //    iValue = i;
                                if (!strArray[i].Trim().ToLower().Contains("quarter") && !strArray[i].Trim().ToLower().Contains("day") && !strArray[i].Trim().ToLower().Contains("year"))
                                    dtMap.Columns.Add(strArray[i].Trim());
                            }
                            else
                            {
                                for (int iY = 0; iY < 5; iY++)
                                {
                                    for (int j = 1; j <= 4; j++)
                                    {
                                        dtMap.Columns.Add(strArray[i].Trim() + "_" + Convert.ToString(iY + startYear) + "_q" + j);
                                    }
                                }

                            }
                        }
                    }
                    Dictionary<string, PM25Monitors> dicDays = new Dictionary<string, PM25Monitors>();
                    Dictionary<string, Dictionary<string, PM25Monitors>> dicQuarters = new Dictionary<string, Dictionary<string, PM25Monitors>>();
                    Dictionary<string, Dictionary<string, Dictionary<string, PM25Monitors>>> dicYears = new Dictionary<string, Dictionary<string, Dictionary<string, PM25Monitors>>>();
                    while (strLine != null)
                    {
                        strLine = sr.ReadLine();
                        if (strLine != null && strLine.Length > 0)
                        {
                            strArray = strLine.Split(',');
                            dicDays = new Dictionary<string, PM25Monitors>();
                            dicQuarters = new Dictionary<string, Dictionary<string, PM25Monitors>>();
                            if (dicDailyFile.ContainsKey(strArray[iID]))
                            {
                                if (dicDailyFile[strArray[iID]].dicOfficialPM25Daily.ContainsKey(strArray[iYear]))
                                {
                                    if (dicDailyFile[strArray[iID]].dicOfficialPM25Daily[strArray[iYear]].ContainsKey(strArray[iQuarter]))
                                    {
                                        dicDailyFile[strArray[iID]].dicOfficialPM25Daily[strArray[iYear]][strArray[iQuarter]].Add(strArray[iDay], new PM25Monitors()
                                        {
                                            bPM25 = Convert.ToSingle(strArray[iPM_b]),
                                            fPM25 = Convert.ToSingle(strArray[iPM_f]),
                                            bBlankmass = Convert.ToSingle(strArray[iBlankMass_b]),
                                            bCrustal = Convert.ToSingle(strArray[iCrustal_b]),
                                            bEC = Convert.ToSingle(strArray[iEC_b]),
                                            bNH4 = Convert.ToSingle(strArray[iNH4_b]),
                                            bOCMmb = Convert.ToSingle(strArray[iOC_b]),
                                            bSO4 = Convert.ToSingle(strArray[iSO4_b]),
                                            bNO3 = Convert.ToSingle(strArray[iNO3_b]),
                                            bWater = Convert.ToSingle(strArray[iWater_b]),
                                            bSalt = Convert.ToSingle(strArray[iSalt_b]),
                                            fBlankmass = Convert.ToSingle(strArray[iBlankMass_f]),
                                            fCrustal = Convert.ToSingle(strArray[iCrustal_f]),
                                            fEC = Convert.ToSingle(strArray[iEC_f]),
                                            fNH4 = Convert.ToSingle(strArray[iNH4_f]),
                                            fOCMmb = Convert.ToSingle(strArray[iOC_f]),
                                            fSO4 = Convert.ToSingle(strArray[iSO4_f]),
                                            fNO3r = Convert.ToSingle(strArray[iNO3_f]),
                                            fWater = Convert.ToSingle(strArray[iWater_f]),
                                            fSalt = Convert.ToSingle(strArray[iSalt_f]),
                                            rrfCrustal = Convert.ToSingle(strArray[iCrustal_rrf]),
                                            rrfEC = Convert.ToSingle(strArray[iEC_rrf]),
                                            rrfNH4 = Convert.ToSingle(strArray[iNH4_rrf]),
                                            rrfOC = Convert.ToSingle(strArray[iOC_rrf]),
                                            rrfSO4 = Convert.ToSingle(strArray[iSO4_rrf]),
                                            rrfNO3 = Convert.ToSingle(strArray[iNO3_rrf]),
                                            rrfWater = Convert.ToSingle(strArray[iWater_rrf]),
                                            rrfSalt = Convert.ToSingle(strArray[iSalt_rrf]),
                                        });
                                    }
                                    else
                                    {
                                        dicDays.Add(strArray[iDay], new PM25Monitors()
                                        {
                                            bPM25 = Convert.ToSingle(strArray[iPM_b]),
                                            fPM25 = Convert.ToSingle(strArray[iPM_f]),
                                            bBlankmass = Convert.ToSingle(strArray[iBlankMass_b]),
                                            bCrustal = Convert.ToSingle(strArray[iCrustal_b]),
                                            bEC = Convert.ToSingle(strArray[iEC_b]),
                                            bNH4 = Convert.ToSingle(strArray[iNH4_b]),
                                            bOCMmb = Convert.ToSingle(strArray[iOC_b]),
                                            bSO4 = Convert.ToSingle(strArray[iSO4_b]),
                                            bNO3 = Convert.ToSingle(strArray[iNO3_b]),
                                            bWater = Convert.ToSingle(strArray[iWater_b]),
                                            bSalt = Convert.ToSingle(strArray[iSalt_b]),
                                            fBlankmass = Convert.ToSingle(strArray[iBlankMass_f]),
                                            fCrustal = Convert.ToSingle(strArray[iCrustal_f]),
                                            fEC = Convert.ToSingle(strArray[iEC_f]),
                                            fNH4 = Convert.ToSingle(strArray[iNH4_f]),
                                            fOCMmb = Convert.ToSingle(strArray[iOC_f]),
                                            fSO4 = Convert.ToSingle(strArray[iSO4_f]),
                                            fNO3r = Convert.ToSingle(strArray[iNO3_f]),
                                            fWater = Convert.ToSingle(strArray[iWater_f]),
                                            fSalt = Convert.ToSingle(strArray[iSalt_f]),
                                            rrfCrustal = Convert.ToSingle(strArray[iCrustal_rrf]),
                                            rrfEC = Convert.ToSingle(strArray[iEC_rrf]),
                                            rrfNH4 = Convert.ToSingle(strArray[iNH4_rrf]),
                                            rrfOC = Convert.ToSingle(strArray[iOC_rrf]),
                                            rrfSO4 = Convert.ToSingle(strArray[iSO4_rrf]),
                                            rrfNO3 = Convert.ToSingle(strArray[iNO3_rrf]),
                                            rrfWater = Convert.ToSingle(strArray[iWater_rrf]),
                                            rrfSalt = Convert.ToSingle(strArray[iSalt_rrf]),
                                        });
                                        dicDailyFile[strArray[iID]].dicOfficialPM25Daily[strArray[iYear]].Add(strArray[iQuarter], dicDays);
                                    }
                                }
                                else
                                {
                                    dicDays.Add(strArray[iDay], new PM25Monitors()
                                    {
                                        bPM25 = Convert.ToSingle(strArray[iPM_b]),
                                        fPM25 = Convert.ToSingle(strArray[iPM_f]),
                                        bBlankmass = Convert.ToSingle(strArray[iBlankMass_b]),
                                        bCrustal = Convert.ToSingle(strArray[iCrustal_b]),
                                        bEC = Convert.ToSingle(strArray[iEC_b]),
                                        bNH4 = Convert.ToSingle(strArray[iNH4_b]),
                                        bOCMmb = Convert.ToSingle(strArray[iOC_b]),
                                        bSO4 = Convert.ToSingle(strArray[iSO4_b]),
                                        bNO3 = Convert.ToSingle(strArray[iNO3_b]),
                                        bWater = Convert.ToSingle(strArray[iWater_b]),
                                        bSalt = Convert.ToSingle(strArray[iSalt_b]),
                                        fBlankmass = Convert.ToSingle(strArray[iBlankMass_f]),
                                        fCrustal = Convert.ToSingle(strArray[iCrustal_f]),
                                        fEC = Convert.ToSingle(strArray[iEC_f]),
                                        fNH4 = Convert.ToSingle(strArray[iNH4_f]),
                                        fOCMmb = Convert.ToSingle(strArray[iOC_f]),
                                        fSO4 = Convert.ToSingle(strArray[iSO4_f]),
                                        fNO3r = Convert.ToSingle(strArray[iNO3_f]),
                                        fWater = Convert.ToSingle(strArray[iWater_f]),
                                        fSalt = Convert.ToSingle(strArray[iSalt_f]),
                                        rrfCrustal = Convert.ToSingle(strArray[iCrustal_rrf]),
                                        rrfEC = Convert.ToSingle(strArray[iEC_rrf]),
                                        rrfNH4 = Convert.ToSingle(strArray[iNH4_rrf]),
                                        rrfOC = Convert.ToSingle(strArray[iOC_rrf]),
                                        rrfSO4 = Convert.ToSingle(strArray[iSO4_rrf]),
                                        rrfNO3 = Convert.ToSingle(strArray[iNO3_rrf]),
                                        rrfWater = Convert.ToSingle(strArray[iWater_rrf]),
                                        rrfSalt = Convert.ToSingle(strArray[iSalt_rrf]),
                                    });
                                    dicQuarters.Add(strArray[iQuarter], dicDays);
                                    dicDailyFile[strArray[iID]].dicOfficialPM25Daily.Add(strArray[iYear], dicQuarters);
                                }
                            }
                            else
                            {
                                dicDailyFile.Add(strArray[iID], new Monitors()
                                {
                                    id = strArray[iID],
                                    type = strArray[iType],
                                    stateName = strArray[iStateName],
                                    countyName = strArray[iCountyName],
                                    lat = Convert.ToSingle(strArray[iLat]),
                                    longitude = Convert.ToSingle(strArray[iLong]),
                                    monitorGridcell = strArray[iGridcell],
                                    dicOfficialPM25Daily = new Dictionary<string, Dictionary<string, Dictionary<string, PM25Monitors>>>(),
                                });
                                dicDays.Add(strArray[iDay], new PM25Monitors()
                                {
                                    bPM25 = Convert.ToSingle(strArray[iPM_b]),
                                    fPM25 = Convert.ToSingle(strArray[iPM_f]),
                                    bBlankmass = Convert.ToSingle(strArray[iBlankMass_b]),
                                    bCrustal = Convert.ToSingle(strArray[iCrustal_b]),
                                    bEC = Convert.ToSingle(strArray[iEC_b]),
                                    bNH4 = Convert.ToSingle(strArray[iNH4_b]),
                                    bOCMmb = Convert.ToSingle(strArray[iOC_b]),
                                    bSO4 = Convert.ToSingle(strArray[iSO4_b]),
                                    bNO3 = Convert.ToSingle(strArray[iNO3_b]),
                                    bWater = Convert.ToSingle(strArray[iWater_b]),
                                    bSalt = Convert.ToSingle(strArray[iSalt_b]),
                                    fBlankmass = Convert.ToSingle(strArray[iBlankMass_f]),
                                    fCrustal = Convert.ToSingle(strArray[iCrustal_f]),
                                    fEC = Convert.ToSingle(strArray[iEC_f]),
                                    fNH4 = Convert.ToSingle(strArray[iNH4_f]),
                                    fOCMmb = Convert.ToSingle(strArray[iOC_f]),
                                    fSO4 = Convert.ToSingle(strArray[iSO4_f]),
                                    fNO3r = Convert.ToSingle(strArray[iNO3_f]),
                                    fWater = Convert.ToSingle(strArray[iWater_f]),
                                    fSalt = Convert.ToSingle(strArray[iSalt_f]),
                                    rrfCrustal = Convert.ToSingle(strArray[iCrustal_rrf]),
                                    rrfEC = Convert.ToSingle(strArray[iEC_rrf]),
                                    rrfNH4 = Convert.ToSingle(strArray[iNH4_rrf]),
                                    rrfOC = Convert.ToSingle(strArray[iOC_rrf]),
                                    rrfSO4 = Convert.ToSingle(strArray[iSO4_rrf]),
                                    rrfNO3 = Convert.ToSingle(strArray[iNO3_rrf]),
                                    rrfWater = Convert.ToSingle(strArray[iWater_rrf]),
                                    rrfSalt = Convert.ToSingle(strArray[iSalt_rrf]),
                                });
                                dicQuarters.Add(strArray[iQuarter], dicDays);
                                dicDailyFile[strArray[iID]].dicOfficialPM25Daily.Add(strArray[iYear], dicQuarters);
                            }
                        }
                    }
                    #region
                    foreach (KeyValuePair<string, Monitors> k in dicDailyFile)
                    {
                        k.Value.dicQuarterlyPM = new Dictionary<string, Dictionary<string, PM25Monitors>>();
                        foreach (KeyValuePair<string, Dictionary<string, Dictionary<string, PM25Monitors>>> kYear in k.Value.dicOfficialPM25Daily)
                        {
                            k.Value.dicQuarterlyPM.Add(kYear.Key, new Dictionary<string, PM25Monitors>());
                            foreach (KeyValuePair<string, Dictionary<string, PM25Monitors>> kQ in kYear.Value)
                            {
                                k.Value.dicQuarterlyPM[kYear.Key].Add(kQ.Key, new PM25Monitors
                                {
                                    bPM25 = kQ.Value.Select(p => p.Value.bPM25).Average(),
                                    fPM25 = kQ.Value.Select(p => p.Value.fPM25).Average(),
                                    bBlankmass = kQ.Value.Select(p => p.Value.bBlankmass).Average(),
                                    bCrustal = kQ.Value.Select(p => p.Value.bCrustal).Average(),
                                    bEC = kQ.Value.Select(p => p.Value.bEC).Average(),
                                    bNH4 = kQ.Value.Select(p => p.Value.bNH4).Average(),
                                    bOCMmb = kQ.Value.Select(p => p.Value.bOCMmb).Average(),
                                    bSO4 = kQ.Value.Select(p => p.Value.bSO4).Average(),
                                    bNO3 = kQ.Value.Select(p => p.Value.bNO3).Average(),
                                    bWater = kQ.Value.Select(p => p.Value.bWater).Average(),
                                    bSalt = kQ.Value.Select(p => p.Value.bSalt).Average(),
                                    fBlankmass = kQ.Value.Select(p => p.Value.fBlankmass).Average(),
                                    fCrustal = kQ.Value.Select(p => p.Value.fCrustal).Average(),
                                    fEC = kQ.Value.Select(p => p.Value.fEC).Average(),
                                    fNH4 = kQ.Value.Select(p => p.Value.fNH4).Average(),
                                    fOCMmb = kQ.Value.Select(p => p.Value.fOCMmb).Average(),
                                    fSO4 = kQ.Value.Select(p => p.Value.fSO4).Average(),
                                    fNO3r = kQ.Value.Select(p => p.Value.fNO3r).Average(),
                                    fWater = kQ.Value.Select(p => p.Value.fWater).Average(),
                                    fSalt = kQ.Value.Select(p => p.Value.fSalt).Average(),
                                    rrfCrustal = kQ.Value.Select(p => p.Value.rrfCrustal).Average(),
                                    rrfEC = kQ.Value.Select(p => p.Value.rrfEC).Average(),
                                    rrfNH4 = kQ.Value.Select(p => p.Value.rrfNH4).Average(),
                                    rrfOC = kQ.Value.Select(p => p.Value.rrfOC).Average(),
                                    rrfSO4 = kQ.Value.Select(p => p.Value.rrfSO4).Average(),
                                    rrfNO3 = kQ.Value.Select(p => p.Value.rrfNO3).Average(),
                                    rrfWater = kQ.Value.Select(p => p.Value.rrfWater).Average(),
                                    rrfSalt = kQ.Value.Select(p => p.Value.rrfSalt).Average(),
                                });
                            }
                        }
                        k.Value.dicOfficialPM25Daily.Clear();
                    }
                    #endregion
                    #region
                    int nQuarter = 0;
                    foreach (KeyValuePair<string, Monitors> k in dicDailyFile)
                    {
                        dr = dtMap.NewRow();
                        dr[0] = k.Value.id;
                        dr[1] = k.Value.type;
                        dr[2] = k.Value.stateName;
                        dr[3] = k.Value.countyName;
                        dr[4] = k.Value.lat;
                        dr[5] = k.Value.longitude;
                        dr[6] = k.Value.monitorGridcell;
                        nQuarter = 0;
                        foreach (KeyValuePair<string, Dictionary<string, PM25Monitors>> kYear in k.Value.dicQuarterlyPM.OrderBy(p => p.Key))
                        {
                            foreach (KeyValuePair<string, PM25Monitors> kQ in kYear.Value.OrderBy(p => p.Key))
                            {
                                dr[7 + nQuarter] = kQ.Value.bPM25;
                                dr[27 + nQuarter] = kQ.Value.fPM25;
                                dr[47 + nQuarter] = kQ.Value.bBlankmass;
                                dr[67 + nQuarter] = kQ.Value.bCrustal;
                                dr[87 + nQuarter] = kQ.Value.bEC;
                                dr[107 + nQuarter] = kQ.Value.bNH4;
                                dr[127 + nQuarter] = kQ.Value.bOCMmb;
                                dr[147 + nQuarter] = kQ.Value.bSO4;
                                dr[167 + nQuarter] = kQ.Value.bNO3;
                                dr[187 + nQuarter] = kQ.Value.bWater;
                                dr[207 + nQuarter] = kQ.Value.bSalt;
                                dr[227 + nQuarter] = kQ.Value.fBlankmass;
                                dr[247 + nQuarter] = kQ.Value.fCrustal;
                                dr[267 + nQuarter] = kQ.Value.fEC;
                                dr[287 + nQuarter] = kQ.Value.fNH4;
                                dr[307 + nQuarter] = kQ.Value.fOCMmb;
                                dr[327 + nQuarter] = kQ.Value.fSO4;
                                dr[347 + nQuarter] = kQ.Value.fNO3r;
                                dr[367 + nQuarter] = kQ.Value.fWater;
                                dr[387 + nQuarter] = kQ.Value.fSalt;
                                dr[407 + nQuarter] = kQ.Value.rrfCrustal;
                                dr[427 + nQuarter] = kQ.Value.rrfEC;
                                dr[447 + nQuarter] = kQ.Value.rrfNH4;
                                dr[467 + nQuarter] = kQ.Value.rrfOC;
                                dr[487 + nQuarter] = kQ.Value.rrfSO4;
                                dr[507 + nQuarter] = kQ.Value.rrfNO3;
                                dr[527 + nQuarter] = kQ.Value.rrfWater;
                                dr[547 + nQuarter] = kQ.Value.rrfSalt;
                                nQuarter++;
                            }
                        }
                        dtMap.Rows.Add(dr);
                    }
                    #endregion
                    #endregion
                }
                else
                {
                    //int iID = -1, iType = -1, iStateName = -1, iCountyName = -1, iLat = -1, iLong = -1, iGridcell = -1, iPercent = -1, iDay_b = -1, iYear = -1, iDay_f = -1, iQuarter = -1, iWater_f = -1, iWater_rrf = -1,
                    //    iPM_b = -1, iPM_f = -1, iBlankMass_f = -1, iCrustal_f = -1, iNH4_f = -1, iSO4_f = -1, iEC_f = -1, iNO3_f = -1, iOC_f = -1, iSalt_f = -1, iCrustal_rrf = -1, iNH4_rrf = -1,
                    //    iSO4_rrf = -1, iEC_rrf = -1, iNO3_rrf = -1, iOC_rrf = -1, iSalt_rrf = -1;

                }


                dicDailyFile.Clear();
                fs.Dispose();
                sr.Dispose();
                return dtMap;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return null;
            }
        }
        /// <summary>
        /// 读取Excel数据转化为DataTable，应用引用的com组件：Microsoft.Office.Interop.Excel.dll 读取EXCEL文件
        /// </summary>
        /// <param name="filePath">物理路径</param>
        /// <param name="sheetIndex">sheet名称的索引</param>
        /// <returns>DataSet</returns>
        public static System.Data.DataTable ReadExcel(string filenameurl, int sheetIndex, string splitstr)
        {
            try
            {
                string firstline = "";
                if (filenameurl.Substring(filenameurl.Length - 3, 3).ToLower() == "csv")
                {
                    bool errorOccur = false;
                    return getDataSetFromCSVAndFirstLine(filenameurl, ref firstline, ref errorOccur);
                }
                // 
                Microsoft.Office.Interop.Excel.Workbook wb = null;
                Microsoft.Office.Interop.Excel.Worksheet ws = null;
                bool isEqual = false;//不相等 
                ArrayList columnArr = new ArrayList();//列字段表 
                System.Data.DataSet myDs = new System.Data.DataSet();
                //DataTable xlsTable = myDs.Tables.Add("show");
                DataTable xlsTable = new DataTable() { TableName = "show" };
                object missing = System.Reflection.Missing.Value;
                Microsoft.Office.Interop.Excel.Application excel = new Microsoft.Office.Interop.Excel.Application();//lauch excel application
                if (excel != null)
                {
                    excel.Visible = false;
                    excel.UserControl = true;
                    // 以只读的形式打开EXCEL文件 
                    wb = excel.Workbooks.Open(filenameurl, missing, true, missing, missing, missing,
                     missing, missing, missing, true, missing, missing, missing, missing, missing);
                    //取得第一个工作薄 
                    ws = (Microsoft.Office.Interop.Excel.Worksheet)wb.Worksheets.get_Item(sheetIndex);
                    //取得总记录行数(包括标题列) 
                    int rowsint = ws.UsedRange.Cells.Rows.Count; //得到行数 
                    int columnsint = ws.UsedRange.Cells.Columns.Count;//得到列数 
                    DataRow dr;
                    //Add fields, from the second line
                    for (int i = 1; i <= columnsint; i++)
                    {
                        //Detemine whether there are the same column or not. 
                        if (i >= 2)
                        {
                            int r = 0;
                            for (int k = 1; k <= i - 1; k++)//列从第一列到第i-1列遍历进行比较 
                            {
                                if (((Microsoft.Office.Interop.Excel.Range)ws.Cells[2, i]).Text.Trim().ToString() == ((Microsoft.Office.Interop.Excel.Range)ws.Cells[2, k]).Text.Trim().ToString())
                                {
                                    //如果该列的值等于前面列中某一列的值 
                                    xlsTable.Columns.Add(((Microsoft.Office.Interop.Excel.Range)ws.Cells[2, i]).Text.Trim().ToString() + splitstr + (r + 1).ToString(), typeof(string));
                                    columnArr.Add(((Microsoft.Office.Interop.Excel.Range)ws.Cells[2, i]).Text.Trim().ToString() + splitstr + (r + 1).ToString());
                                    isEqual = true;
                                    r++;
                                    break;
                                }
                                else
                                {
                                    isEqual = false;
                                    continue;
                                }
                            }
                            if (!isEqual)
                            {
                                xlsTable.Columns.Add(((Microsoft.Office.Interop.Excel.Range)ws.Cells[2, i]).Text.Trim().ToString(), typeof(string));
                                columnArr.Add(((Microsoft.Office.Interop.Excel.Range)ws.Cells[2, i]).Text.Trim().ToString());
                            }
                        }
                        else
                        {
                            xlsTable.Columns.Add(((Microsoft.Office.Interop.Excel.Range)ws.Cells[2, i]).Text.Trim().ToString(), typeof(string));
                            columnArr.Add(((Microsoft.Office.Interop.Excel.Range)ws.Cells[2, i]).Text.Trim().ToString());
                        }
                    }
                    //the first row is monitor frequency, the second row is titles. the data start from the third row
                    //excel中一行标题栏，一行为数据采集的频率，eg，Day,Quarter,Year
                    for (int i = 3; i <= rowsint; i++)
                    {
                        dr = xlsTable.NewRow();

                        xlsTable.Rows.Add(dr);
                    }
                    for (int j = 1; j <= columnsint; j++)
                    {
                        //dr[columnArr[j - 1].ToString()] = ((Microsoft.Office.Interop.Excel.Range)ws.Cells[i, j]).Value2.ToString();
                        System.Array values = (System.Array)((Microsoft.Office.Interop.Excel.Range)ws.Columns[j]).Formula;
                        for (int i = 3; i <= rowsint; i++)
                        {
                            xlsTable.Rows[i - 3][j - 1] = values.GetValue(i, 1);
                        }
                        //var v = (Microsoft.Office.Interop.Excel.Range)ws.Rows[2];
                        //string s= ((Microsoft.Office.Interop.Excel.Range)ws.Rows[i]).get;
                    }
                }
                if (xlsTable != null)
                    //{ myDs.Tables.Add(xlsTable); }
                    excel.Quit();
                excel = null;
                //Dispose(ws, wb);

                return xlsTable;
            }
            catch (Exception)
            {
                return null;
            }
        }

        /// <summary>
        /// 将Datatable中的数据写入CSV文件中
        /// </summary>
        /// <param name="dt">提供保存数据的Datatable</param>
        /// <param name="fileName">CSV的路径</param>
        /// <param name="fileType"> 数据的频率，例如year,quarter,day</param>
        public static void SaveCSV(DataTable dt, string fileName, string fileType)
        {
            try
            {
                FileStream fs = new FileStream(fileName, System.IO.FileMode.Create, System.IO.FileAccess.Write);
                StreamWriter sw;
                sw = LanguageOld.IsSMATChina ? new StreamWriter(fs, Encoding.UTF8) : new StreamWriter(fs, Encoding.Default);

                string data = "";
                if (!string.IsNullOrEmpty(fileType))
                    sw.WriteLine(fileType);
                //写出列名称
                for (int i = 0; i < dt.Columns.Count; i++)
                {
                    data += dt.Columns[i].ColumnName.ToString();
                    if (i < dt.Columns.Count - 1)
                    {
                        data += ",";
                    }
                }
                sw.WriteLine(data);

                //写出各行数据
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    data = "";
                    for (int j = 0; j < dt.Columns.Count; j++)
                    {
                        data += dt.Rows[i][j].ToString();
                        if (j < dt.Columns.Count - 1)
                        {
                            data += ",";
                        }
                    }
                    sw.WriteLine(data);
                }
                sw.Close();
                fs.Close();
                GC.Collect();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }

        }

        #endregion

        #region Annual PM UC check
        public static string checkUCOutputAdvancedA(BaseScenario baseScenario)
        {
            try
            {
                AnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as AnnualPMAnalysisConfiguration;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                if (annualPMAnalysisConfiguration.outputChoiceAdvancedA != null)
                {
                    if (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doQuarterlyAvgFileSpatial
                         && (!annualPMAnalysisConfiguration.outputChoiceAdvancedA.doInterpolatedSFETempAdj && !annualPMAnalysisConfiguration.outputChoiceAdvancedA.doBaseOnlyVNA && !annualPMAnalysisConfiguration.outputChoiceAdvancedA.doFutureOnlyVNA))
                        errorBuilder.Append("Base Quarterly PM25 Spatial Field generation requires 'Interpolate FRM and speciation monitor data to spatial field. Temporally adjust.' be checked.\n");

                    if (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doQuarterlyAvgFileSpatial_GraAdj
                         && (!annualPMAnalysisConfiguration.outputChoiceAdvancedA.doInterpolatedSFETempAdj_GradAdj && !annualPMAnalysisConfiguration.outputChoiceAdvancedA.doBaseOnlyEvna && !annualPMAnalysisConfiguration.outputChoiceAdvancedA.doFutureOnlyEvna))
                        errorBuilder.Append("Base Quarterly PM25 Spatial Field - gradient-adjusted generation requires 'Interpolate gradient-adjusted FRM and speciation monitor data to spatial field.Temporally adjust.' be checked.\n");

                    if (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFileSpatial
                          && !annualPMAnalysisConfiguration.outputChoiceAdvancedA.doSpeciesFractionSpatial)
                        errorBuilder.Append("Spatial Neighbor File generation requires Species Fraction Spatial Field be checked.\n");
                    if (annualPMAnalysisConfiguration.dataInputA != null)
                    {
                        if (annualPMAnalysisConfiguration.dataInputA.doSpeciesFractionFile)
                        {
                            if (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFilePoint || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFileSpatial)
                                errorBuilder.Append("Using species fractions file. Disable neighbor file creation.\n");
                        }
                    }
                    if (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doHighCountySites == true || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doQuarterlyAvgFilePoint == true
                        || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFilePoint == true || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFileSpatial == true)
                    {
                        if (annualPMAnalysisConfiguration.chooseDesiredOutputA == null)
                        {
                            errorBuilder.Append("Choose desired output before choosing advanced output choices.\n");
                        }
                        else
                        {
                            if (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doHighCountySites == true && annualPMAnalysisConfiguration.chooseDesiredOutputA.doStandardAnalysis == false)
                            {
                                errorBuilder.Append("High County Sites generation requires 'Interpolate monitor data to FRM monitor sites. Temporally-adjust.' be checked.\n");
                            }
                            if (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doQuarterlyAvgFilePoint == true && annualPMAnalysisConfiguration.chooseDesiredOutputA.doStandardAnalysis == false)
                            {
                                errorBuilder.Append("Base Quarterly PM25 Point generation requires 'Interpolate monitor data to FRM monitor sites. Temporally-adjust.' be checked.\n");
                            }
                            if (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFilePoint == true && (annualPMAnalysisConfiguration.chooseDesiredOutputA.doStandardAnalysis == false || annualPMAnalysisConfiguration.chooseDesiredOutputA.doSpeciesFraction == false))
                            {
                                errorBuilder.Append("Point Neighbor File generation requires 'Output species fractions file' and 'Interpolate monitor data to FRM monitor sites. Temporally-adjust.' be checked.\n");
                            }
                            if (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFileSpatial == true && annualPMAnalysisConfiguration.chooseDesiredOutputA.doSpeciesFraction == false)
                            {
                                errorBuilder.Append("Spatial Neighbor File generation requires Species Fraction Spatial Field be checked.\n");
                            }
                        }
                    }
                }
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                //CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public static string checkUCDataInputA(BaseScenario baseScenario)
        {
            try
            {
                AnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as AnnualPMAnalysisConfiguration;
                bool ok = false;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";
                //check species monitor data file path
                #region
                if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.doSpeciesMonitorDataFile == true)
                {
                    if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.speciesMonitorDataFile != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.speciesMonitorDataFile.Length > 0)
                    {
                        if (!File.Exists((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.speciesMonitorDataFile))
                        {
                            errorBuilder.Append("Species Monitor Data File path does not exist!\n");
                        }
                        else
                        {
                            fileStream = new FileStream((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.speciesMonitorDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorBuilder.Append("Species Monitor Data File is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("no3r") && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("ocb")
                                    && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("salt") && fieldNameAdd.Contains("don") && fieldNameAdd.Contains("h2o_aim") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("so4_3s") && fieldNameAdd.Contains("crustal_alt")
                                    && fieldNameAdd.Contains("frm_mass") && fieldNameAdd.Contains("measured_fm") && fieldNameAdd.Contains("rcfm") && fieldNameAdd.Contains("al") && fieldNameAdd.Contains("ca") && fieldNameAdd.Contains("fe") && fieldNameAdd.Contains("ti") && fieldNameAdd.Contains("si") && fieldNameAdd.Contains("epa_flag")
                                    && fieldNameAdd.Contains("user_flag") && fieldNameAdd.Length == 28)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Species Monitor Data File is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Species Monitor Data File can't be empty!\n");
                    }

                    //check unofficial monitor data
                    if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.unofficialMonitorDataFile != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.unofficialMonitorDataFile.Length > 0)
                    {
                        if (!File.Exists((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.unofficialMonitorDataFile))
                        {
                            errorBuilder.Append("Unofficial Daily Average PM25 Data File path does not exist!\n");
                        }
                        else
                        {
                            fileStream = new FileStream((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.unofficialMonitorDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorBuilder.Append("Unofficial Daily Average PM25 Data File is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("epa_flag") && fieldNameAdd.Contains("user_flag") && fieldNameAdd.Length == 8)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Unofficial Daily Average PM25 Data File is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Unofficial Daily Average PM25 Data File can't be empty!\n");
                    }
                }
                #endregion
                //check species fractions file-point
                if (annualPMAnalysisConfiguration.dataInputA.doSpeciesFractionFile == true)
                {
                    #region
                    if (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFilePoint || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFileSpatial)
                    {
                        errorBuilder.Append("Using species fractions file. Disable neighbor file creation.\n");
                    }
                    if (annualPMAnalysisConfiguration.dataInputA.doSpeciesFractionFile && annualPMAnalysisConfiguration.dataInputA.specFracModeSpatial == "spatial field" && (annualPMAnalysisConfiguration.outputChoiceAdvancedA != null
                    && (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doInterpolatedSFETempAdj_GradAdj || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doFutureOnlyEvna
                    || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doBaseOnlyEvna || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doSpeciesFractionSpatial_GraAdj)))
                    {
                        errorBuilder.Append("Using species fractions file spatial field. Disable eVNA files creation.\n");
                    }
                    if (annualPMAnalysisConfiguration.dataInputA.doSpeciesFractionFile && annualPMAnalysisConfiguration.dataInputA.specFracModeSpatial == "grad adj spatial field" && (annualPMAnalysisConfiguration.outputChoiceAdvancedA != null
                        && (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doInterpolatedSFETempAdj || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doFutureOnlyVNA
                        || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doBaseOnlyVNA || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doSpeciesFractionSpatial)))
                    {
                        errorBuilder.Append("Using gradient-adjustment species fractions file spatial field. Disable VNA files creation.\n");
                    }
                    if (annualPMAnalysisConfiguration.dataInputA.specFracPointFile != null && annualPMAnalysisConfiguration.dataInputA.specFracPointFile.Length > 0)
                    {
                        if (!File.Exists(annualPMAnalysisConfiguration.dataInputA.specFracPointFile))
                        {
                            errorBuilder.Append("Point Species Fractions File path does not exist!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(annualPMAnalysisConfiguration.dataInputA.specFracPointFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorBuilder.Append("Point Species Fractions File is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Contains("monitor_lat") && fieldNameAdd.Contains("monitor_long") && fieldNameAdd.Contains("quarter")
                                    && fieldNameAdd.Contains("pm25_mass_frac") && fieldNameAdd.Contains("fcr") && fieldNameAdd.Contains("fec") && fieldNameAdd.Contains("fnh4") && fieldNameAdd.Contains("focm") && fieldNameAdd.Contains("fso4")
                                    && fieldNameAdd.Contains("fno3") && fieldNameAdd.Contains("fwater") && fieldNameAdd.Contains("fsalt") && fieldNameAdd.Contains("blank_mass") && fieldNameAdd.Contains("don") && fieldNameAdd.Contains("i_so4")
                                    && fieldNameAdd.Contains("i_no3r") && fieldNameAdd.Contains("i_ocb") && fieldNameAdd.Contains("i_ec") && fieldNameAdd.Contains("i_crustal") && fieldNameAdd.Contains("i_don") && fieldNameAdd.Contains("i_nh4")
                                    && fieldNameAdd.Contains("i_no3") && fieldNameAdd.Contains("i_salt") && fieldNameAdd.Length == 26)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Point Species Fractions File is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Point Species Fractions File can't be empty!\n");
                    }
                    #endregion
                    //check species fractions file-spatial field
                    #region
                    if (annualPMAnalysisConfiguration.dataInputA.specFracModeSpatial == "spatial field" && (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doInterpolatedSFETempAdj || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doFutureOnlyVNA || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doSpeciesFractionSpatial))
                    {
                        if (annualPMAnalysisConfiguration.dataInputA.specFracSpatialFile != null && annualPMAnalysisConfiguration.dataInputA.specFracSpatialFile.Length > 0)
                        {
                            if (!File.Exists(annualPMAnalysisConfiguration.dataInputA.specFracSpatialFile))
                            {
                                errorBuilder.Append("Spatial Field Species Fractions File path does not exist!\n");
                            }
                            else
                            {
                                fileStream = new FileStream(annualPMAnalysisConfiguration.dataInputA.specFracSpatialFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorBuilder.Append("Spatial Field Species Fractions File is ill-formatted data!\n");
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("gridcell_lat") && fieldNameAdd.Contains("gridcell_long") && fieldNameAdd.Contains("quarter") && fieldNameAdd.Contains("pm25_mass_frac")
                                    && fieldNameAdd.Contains("fcr") && fieldNameAdd.Contains("fec") && fieldNameAdd.Contains("fnh4") && fieldNameAdd.Contains("focm") && fieldNameAdd.Contains("fso4")
                                    && fieldNameAdd.Contains("fno3") && fieldNameAdd.Contains("fwater") && fieldNameAdd.Contains("fsalt") && fieldNameAdd.Contains("blank_mass") && fieldNameAdd.Contains("don") && fieldNameAdd.Contains("i_so4")
                                    && fieldNameAdd.Contains("i_no3r") && fieldNameAdd.Contains("i_ocb") && fieldNameAdd.Contains("i_ec") && fieldNameAdd.Contains("i_crustal") && fieldNameAdd.Contains("i_don") && fieldNameAdd.Contains("i_nh4")
                                    && fieldNameAdd.Contains("i_no3") && fieldNameAdd.Contains("i_salt") && fieldNameAdd.Length == 24)
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorBuilder.Append("Spatial Field Species Fractions File is ill-formatted data!\n");
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorBuilder.Append("Spatial Field Species Fractions File can't be empty!\n");
                        }
                    }
                    else if (annualPMAnalysisConfiguration.dataInputA.specFracModeSpatial == "grad adj spatial field" && (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doInterpolatedSFETempAdj_GradAdj || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doFutureOnlyEvna || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doSpeciesFractionSpatial_GraAdj))
                    {
                        if (annualPMAnalysisConfiguration.dataInputA.specFracSpatialFile != null && annualPMAnalysisConfiguration.dataInputA.specFracSpatialFile.Length > 0)
                        {
                            if (!File.Exists(annualPMAnalysisConfiguration.dataInputA.specFracSpatialFile))
                            {
                                errorBuilder.Append("Gradient-adjusted Spatial Field Species Fractions File path does not exist!\n");
                            }
                            else
                            {
                                fileStream = new FileStream(annualPMAnalysisConfiguration.dataInputA.specFracSpatialFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorBuilder.Append("Gradient-adjusted Spatial Field Species Fractions File is ill-formatted data!\n");
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("gridcell_lat") && fieldNameAdd.Contains("gridcell_long") && fieldNameAdd.Contains("quarter") && fieldNameAdd.Contains("pm25_mass_frac_ga") && fieldNameAdd.Contains("fcr_ga") && fieldNameAdd.Contains("fec_ga")
                                        && fieldNameAdd.Contains("fnh4_ga") && fieldNameAdd.Contains("focm_ga") && fieldNameAdd.Contains("fso4_ga") && fieldNameAdd.Contains("fno3_ga") && fieldNameAdd.Contains("fwater_ga") && fieldNameAdd.Contains("fsalt_ga") && fieldNameAdd.Contains("blank_mass_ga")
                                        && fieldNameAdd.Contains("don_ga") && fieldNameAdd.Contains("i_so4_ga") && fieldNameAdd.Contains("i_no3r_ga") && fieldNameAdd.Contains("i_ocb_ga") && fieldNameAdd.Contains("i_ec_ga") && fieldNameAdd.Contains("i_crustal_ga") && fieldNameAdd.Contains("i_don_ga")
                                        && fieldNameAdd.Contains("i_nh4_ga") && fieldNameAdd.Contains("i_no3_ga") && fieldNameAdd.Contains("i_salt_ga") && fieldNameAdd.Length == 24)
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorBuilder.Append("Gradient-adjusted Spatial Field Species Fractions File is ill-formatted data!\n");
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorBuilder.Append("Gradient-adjusted Spatial Field Species Fractions File can't be empty!\n");
                        }
                    }
                    #endregion
                }

                //check official monitor data
                #region
                if (annualPMAnalysisConfiguration.dataInputA.officialMonitorDataFile != null && annualPMAnalysisConfiguration.dataInputA.officialMonitorDataFile.Length > 0)
                {
                    if (!File.Exists(annualPMAnalysisConfiguration.dataInputA.officialMonitorDataFile))
                    {
                        errorBuilder.Append("Official Quarterly Average FRM Data File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(annualPMAnalysisConfiguration.dataInputA.officialMonitorDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                        {
                            errorBuilder.Append("Official Quarterly Average FRM Data File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("ndays")
                                && fieldNameAdd.Contains("_substitution_code") && fieldNameAdd.Contains("completion_code") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Length == 11)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Official Quarterly Average FRM Data File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Official Quarterly Average FRM Data File can not be empty!\n");
                }

                if (annualPMAnalysisConfiguration.dataInputA.doDailyModelDataInput)//check daily model data
                {
                    //baseline model data
                    if (annualPMAnalysisConfiguration.dataInputA.baselineModelDataFile != null && annualPMAnalysisConfiguration.dataInputA.baselineModelDataFile.Length > 0)
                    {
                        if (!File.Exists(annualPMAnalysisConfiguration.dataInputA.baselineModelDataFile))
                        {
                            errorBuilder.Append("Baseline file path does not exits!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(annualPMAnalysisConfiguration.dataInputA.baselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorBuilder.Append("Baseline file is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Baseline file is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Daily Baseline Model Data File can not be empty!\n");
                    }

                    //control model data
                    if (annualPMAnalysisConfiguration.dataInputA.forecastModelDataFile != null && annualPMAnalysisConfiguration.dataInputA.forecastModelDataFile.Length > 0)
                    {
                        if (!File.Exists(annualPMAnalysisConfiguration.dataInputA.forecastModelDataFile))
                        {
                            errorBuilder.Append("Forecast file path does not exits!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(annualPMAnalysisConfiguration.dataInputA.forecastModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorBuilder.Append("Forecast file is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Forecast file is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Daily Forecast Model Data File can not be empty!\n");
                    }
                }

                if (annualPMAnalysisConfiguration.dataInputA.doQuarterlyModelDataInput)//check quarterly model data
                {
                    //baseline model data
                    if (annualPMAnalysisConfiguration.dataInputA.baselineModelDataFile != null && annualPMAnalysisConfiguration.dataInputA.baselineModelDataFile.Length > 0)
                    {
                        if (!File.Exists(annualPMAnalysisConfiguration.dataInputA.baselineModelDataFile))
                        {
                            errorBuilder.Append("Baseline file path does not exits!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(annualPMAnalysisConfiguration.dataInputA.baselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorBuilder.Append("Baseline file is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)//add the quarter by sclong,20160912 (fieldNameAdd.Contains("date") || fieldNameAdd.Contains("quarter"))
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Baseline file is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Quarterly Baseline Model Data File can not be empty!\n");
                    }

                    //control model data
                    #region
                    if (annualPMAnalysisConfiguration.dataInputA.forecastModelDataFile != null && annualPMAnalysisConfiguration.dataInputA.forecastModelDataFile.Length > 0)
                    {
                        if (!File.Exists(annualPMAnalysisConfiguration.dataInputA.forecastModelDataFile))
                        {
                            errorBuilder.Append("Forecast file path does not exits!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(annualPMAnalysisConfiguration.dataInputA.forecastModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorBuilder.Append("Forecast file is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)//add the quarter by sclong,20160912 (fieldNameAdd.Contains("date") || fieldNameAdd.Contains("quarter"))
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Forecast file is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Quarterly Forecast Model Data File can not be empty!\n");
                    }
                    #endregion
                }
                #endregion
                if (annualPMAnalysisConfiguration.dataInputA.doQuarterlyModelDataInput)//CMAQ
                {

                }
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkUCSpeciesFractionOptionsA(BaseScenario baseScenario)
        {
            try
            {
                AnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as AnnualPMAnalysisConfiguration;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                if (Convert.ToInt32(annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_EndYear) < Convert.ToInt32(annualPMAnalysisConfiguration.speciesFractionOptionsA.IMPROVESTN_StartYear))
                    errorBuilder.Append("End Year should be later than Start Year!\n");
                if (Convert.ToInt32(annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialEndYear) < Convert.ToInt32(annualPMAnalysisConfiguration.speciesFractionOptionsA.unofficialStartYear))
                    errorBuilder.Append("End Year should be later than Start Year!\n");
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkUCPMCalculationOptionsA(BaseScenario baseScenario)
        {
            try
            {
                AnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as AnnualPMAnalysisConfiguration;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                if (Convert.ToInt32(annualPMAnalysisConfiguration.pm25CalculationOptionsA.officialPM25EndYear) < Convert.ToInt32(annualPMAnalysisConfiguration.pm25CalculationOptionsA.officialPM25StartYear))
                    errorBuilder.Append("End Year should be later than Start Year!\n");
                if (annualPMAnalysisConfiguration.pm25CalculationOptionsA.requiredDVPeriodsForValidFRMMonitors != "None selected")
                {
                    if (Convert.ToInt32(annualPMAnalysisConfiguration.pm25CalculationOptionsA.requiredDVPeriodsForValidFRMMonitors.Substring(0, 4)) < Convert.ToInt32(annualPMAnalysisConfiguration.pm25CalculationOptionsA.officialPM25StartYear)
                        || Convert.ToInt32(annualPMAnalysisConfiguration.pm25CalculationOptionsA.requiredDVPeriodsForValidFRMMonitors.Remove(0, annualPMAnalysisConfiguration.pm25CalculationOptionsA.requiredDVPeriodsForValidFRMMonitors.Length - 4)) > Convert.ToInt32(annualPMAnalysisConfiguration.pm25CalculationOptionsA.officialPM25EndYear))
                        errorBuilder.Append("Required Design Values is not correct!\n");
                }
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkAnnualPMUC(BaseScenario baseScenario)
        {
            try
            {
                AnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as AnnualPMAnalysisConfiguration;
                string errorTips = "";
                StringBuilder errorTipsBuilder = new StringBuilder("");
                if (annualPMAnalysisConfiguration.outputChoiceAdvancedA != null)
                {
                    errorTips = "";
                    errorTips = checkUCOutputAdvancedA(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (annualPMAnalysisConfiguration.dataInputA != null)
                {
                    errorTips = "";
                    errorTips = checkUCDataInputA(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (annualPMAnalysisConfiguration.speciesFractionOptionsA != null)
                {
                    errorTips = "";
                    errorTips = checkUCSpeciesFractionOptionsA(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (annualPMAnalysisConfiguration.pm25CalculationOptionsA != null)
                {
                    errorTips = "";
                    errorTips = checkUCPMCalculationOptionsA(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                errorTips = errorTipsBuilder.ToString();
                if (errorTips != null && errorTips.Length > 0)
                {
                    return errorTips;
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }
        #endregion

        #region Daily PM UC check
        public static string checkUCOutputD(BaseScenario baseScenario)
        {
            try
            {
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD != null)
                {
                    if (((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doStandardAnalysis == true && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doSpeciesFraction == false) || ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doStandardAnalysis == false && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doSpeciesFraction == true))
                    {
                        errorBuilder.Append("'Standard Analysis' and 'Species Fraction' need to be checked or not checked simultaneously.\n");
                    }
                }
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkUCOutputAdvancedD(BaseScenario baseScenario)
        {
            try
            {
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD != null)
                {
                    if (!((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doStandardAnalysis == true && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doQuarterlyPeakModelData == true && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doSpeciesFraction == true))
                    {
                        if (!((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doQuarterlyPeakFilesPoint == false && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doHighCountySites == false && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doQuarterlyPeakSpeciatedMonitors == false && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doNeighborFilePoint == false))
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doQuarterlyPeakFilesPoint == true)
                            {
                                errorBuilder.Append("'Quarterly average files' and");
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doHighCountySites == true)
                            {
                                errorBuilder.Append(" 'High county sites' and");
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doQuarterlyPeakSpeciatedMonitors == true)
                            {
                                errorBuilder.Append(" 'Quarterly average speciated monitors' and");
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doNeighborFilePoint == true)
                            {
                                errorBuilder.Append(" 'Neighbor files' and");
                            }
                            errorBuilder.Length = errorBuilder.Length - 3;
                            errorBuilder.Append("need");
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doStandardAnalysis == false)
                            {
                                errorBuilder.Append(" 'Standard Analysis' and");
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doQuarterlyPeakModelData == false)
                            {
                                errorBuilder.Append(" 'Quarterly Peak Model Data' and");
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doSpeciesFraction == false)
                            {
                                errorBuilder.Append(" 'Species Fraction' and");
                            }
                            errorBuilder.Length = errorBuilder.Length - 3;
                            errorBuilder.Append("be checked.\n");
                        }
                    }
                }
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkUCDataInputD(BaseScenario baseScenario)
        {
            try
            {
                DailyPMAnalysisConfiguration dailyPMAnalysisConfiguration = baseScenario.configuration as DailyPMAnalysisConfiguration;
                bool ok = false;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";
                //check species monitor data file path
                if (dailyPMAnalysisConfiguration.dataInputD.doSpeciesMonitorDataFile == true)
                {
                    if (dailyPMAnalysisConfiguration.dataInputD.speciesMonitorDataFile != null && dailyPMAnalysisConfiguration.dataInputD.speciesMonitorDataFile.Length > 0)
                    {
                        if (!File.Exists(dailyPMAnalysisConfiguration.dataInputD.speciesMonitorDataFile))
                        {
                            errorBuilder.Append("Species Monitor Data File path does not exist!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(dailyPMAnalysisConfiguration.dataInputD.speciesMonitorDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorBuilder.Append("Species Monitor Data File is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("no3r") && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("ocb")
                                    && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("salt") && fieldNameAdd.Contains("don") && fieldNameAdd.Contains("h2o_aim") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("so4_3s") && fieldNameAdd.Contains("crustal_alt")
                                    && fieldNameAdd.Contains("frm_mass") && fieldNameAdd.Contains("measured_fm") && fieldNameAdd.Contains("rcfm") && fieldNameAdd.Contains("al") && fieldNameAdd.Contains("ca") && fieldNameAdd.Contains("fe") && fieldNameAdd.Contains("ti") && fieldNameAdd.Contains("si") && fieldNameAdd.Contains("epa_flag")
                                    && fieldNameAdd.Contains("user_flag") && fieldNameAdd.Length == 28)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Species Monitor Data File is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Species Monitor Data File can't be empty!\n");
                    }

                    //check unofficial monitor data
                    if (dailyPMAnalysisConfiguration.dataInputD.unofficialMonitorFile != null && dailyPMAnalysisConfiguration.dataInputD.unofficialMonitorFile.Length > 0)
                    {
                        if (!File.Exists(dailyPMAnalysisConfiguration.dataInputD.unofficialMonitorFile))
                        {
                            errorBuilder.Append("Unofficial Daily Average PM25 Data File path does not exist!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(dailyPMAnalysisConfiguration.dataInputD.unofficialMonitorFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorBuilder.Append("Unofficial Daily Average PM25 Data File is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("epa_flag") && fieldNameAdd.Contains("user_flag") && fieldNameAdd.Length == 8)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Unofficial Daily Average PM25 Data File is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Unofficial Daily Average PM25 Data File can't be empty!\n");
                    }
                }

                //check species fractions file-point
                if (dailyPMAnalysisConfiguration.dataInputD.doSpeciesFractionFile == true)
                {
                    if (dailyPMAnalysisConfiguration.outputChoiceAdvancedD.doNeighborFilePoint)
                    {
                        errorBuilder.Append("Using species fractions file. Disable neighbor file creation.\n");
                    }
                    if (dailyPMAnalysisConfiguration.dataInputD.specFracPointFile != null && dailyPMAnalysisConfiguration.dataInputD.specFracPointFile.Length > 0)
                    {
                        if (!File.Exists(dailyPMAnalysisConfiguration.dataInputD.specFracPointFile))
                        {
                            errorBuilder.Append("Point Species Fractions File path does not exist!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(dailyPMAnalysisConfiguration.dataInputD.specFracPointFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorBuilder.Append("Point Species Fractions File is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Contains("monitor_lat") && fieldNameAdd.Contains("monitor_long") && fieldNameAdd.Contains("quarter")
                                    && fieldNameAdd.Contains("pm25_mass_frac") && fieldNameAdd.Contains("fcr") && fieldNameAdd.Contains("fec") && fieldNameAdd.Contains("fnh4") && fieldNameAdd.Contains("focm") && fieldNameAdd.Contains("fso4")
                                    && fieldNameAdd.Contains("fno3") && fieldNameAdd.Contains("fwater") && fieldNameAdd.Contains("fsalt") && fieldNameAdd.Contains("blank_mass") && fieldNameAdd.Contains("don") && fieldNameAdd.Contains("i_so4")
                                    && fieldNameAdd.Contains("i_no3r") && fieldNameAdd.Contains("i_ocb") && fieldNameAdd.Contains("i_ec") && fieldNameAdd.Contains("i_crustal") && fieldNameAdd.Contains("i_don") && fieldNameAdd.Contains("i_nh4")
                                    && fieldNameAdd.Contains("i_no3") && fieldNameAdd.Contains("i_salt") && fieldNameAdd.Length == 26)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Point Species Fractions File is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Point Species Fractions File can't be empty!\n");
                    }
                }
                //check official monitor data
                if (dailyPMAnalysisConfiguration.dataInputD.officialMonitorFile != null && dailyPMAnalysisConfiguration.dataInputD.officialMonitorFile.Length > 0)
                {
                    if (!File.Exists(dailyPMAnalysisConfiguration.dataInputD.officialMonitorFile))
                    {
                        errorBuilder.Append("Official Quarterly Average FRM Data File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(dailyPMAnalysisConfiguration.dataInputD.officialMonitorFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Official Quarterly Average FRM Data File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("98_percentile")
                                && fieldNameAdd.Contains("epa_flag") && fieldNameAdd.Contains("completion_code") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Contains("rank98") && fieldNameAdd.Length == 12)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Official Quarterly Average FRM Data File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Official Quarterly Average FRM Data File can not be empty!\n");
                }

                if (dailyPMAnalysisConfiguration.dataInputD.doDailyModelDataInput)//check daily model data
                {
                    //baseline model data
                    if (dailyPMAnalysisConfiguration.dataInputD.baselineModelFile != null && dailyPMAnalysisConfiguration.dataInputD.baselineModelFile.Length > 0)
                    {
                        if (!File.Exists(dailyPMAnalysisConfiguration.dataInputD.baselineModelFile))
                        {
                            errorBuilder.Append("Baseline file path does not exits!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(dailyPMAnalysisConfiguration.dataInputD.baselineModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorBuilder.Append("Baseline file is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Baseline file is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Daily Baseline Model Data File can not be empty!\n");
                    }

                    //control model data
                    if (dailyPMAnalysisConfiguration.dataInputD.forecastModelFile != null && dailyPMAnalysisConfiguration.dataInputD.forecastModelFile.Length > 0)
                    {
                        if (!File.Exists(dailyPMAnalysisConfiguration.dataInputD.forecastModelFile))
                        {
                            errorBuilder.Append("Forecast file path does not exits!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(dailyPMAnalysisConfiguration.dataInputD.forecastModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorBuilder.Append("Forecast file is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Forecast file is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Daily Forecast Model Data File can not be empty!\n");
                    }
                }

                if (dailyPMAnalysisConfiguration.dataInputD.doQuarterlyPeakModelDataInput)//check quarterly model data
                {
                    //baseline model data
                    if (dailyPMAnalysisConfiguration.dataInputD.baselineModelFile != null && dailyPMAnalysisConfiguration.dataInputD.baselineModelFile.Length > 0)
                    {
                        if (!File.Exists(dailyPMAnalysisConfiguration.dataInputD.baselineModelFile))
                        {
                            errorBuilder.Append("Baseline file path does not exits!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(dailyPMAnalysisConfiguration.dataInputD.baselineModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorBuilder.Append("Baseline file is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Baseline file is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Quarterly Baseline Model Data File can not be empty!\n");
                    }

                    //control model data
                    if (dailyPMAnalysisConfiguration.dataInputD.forecastModelFile != null && dailyPMAnalysisConfiguration.dataInputD.forecastModelFile.Length > 0)
                    {
                        if (!File.Exists(dailyPMAnalysisConfiguration.dataInputD.forecastModelFile))
                        {
                            errorBuilder.Append("Forecast file path does not exits!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(dailyPMAnalysisConfiguration.dataInputD.forecastModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorBuilder.Append("Forecast file is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Forecast file is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Quarterly Forecast Model Data File can not be empty!\n");
                    }
                }

                if (dailyPMAnalysisConfiguration.dataInputD.doQuarterlyPeakModelDataInput)//CMAQ
                {

                }
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkUCSpeciesFractionOptionsD(BaseScenario baseScenario)
        {
            try
            {
                DailyPMAnalysisConfiguration dailyPMAnalysisConfiguration = baseScenario.configuration as DailyPMAnalysisConfiguration;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                if (Convert.ToInt32(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_EndYear) < Convert.ToInt32(dailyPMAnalysisConfiguration.speciesFractionOptionsD.IMPROVE_StartYear))
                    errorBuilder.Append("End Year should be later than Start Year!\n");
                if (Convert.ToInt32(dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialEndYear) < Convert.ToInt32(dailyPMAnalysisConfiguration.speciesFractionOptionsD.unofficialStartYear))
                    errorBuilder.Append("End Year should be later than Start Year!\n");
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkUCPMCalculationOptionsD(BaseScenario baseScenario)
        {
            try
            {
                DailyPMAnalysisConfiguration dailyPMAnalysisConfiguration = baseScenario.configuration as DailyPMAnalysisConfiguration;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                if (Convert.ToInt32(dailyPMAnalysisConfiguration.pm25CalculationOptionsD.officialPM25EndYear) < Convert.ToInt32(dailyPMAnalysisConfiguration.pm25CalculationOptionsD.officialPM25StartYear))
                    errorBuilder.Append("End Year should be later than Start Year!\n");
                if (dailyPMAnalysisConfiguration.pm25CalculationOptionsD.requiredDesignValuePeriodsForValidFRMMonitors != "None selected")
                {
                    if (Convert.ToInt32(dailyPMAnalysisConfiguration.pm25CalculationOptionsD.requiredDesignValuePeriodsForValidFRMMonitors.Substring(0, 4)) < Convert.ToInt32(dailyPMAnalysisConfiguration.pm25CalculationOptionsD.officialPM25StartYear)
                        || Convert.ToInt32(dailyPMAnalysisConfiguration.pm25CalculationOptionsD.requiredDesignValuePeriodsForValidFRMMonitors.Remove(0, dailyPMAnalysisConfiguration.pm25CalculationOptionsD.requiredDesignValuePeriodsForValidFRMMonitors.Length - 4)) > Convert.ToInt32(dailyPMAnalysisConfiguration.pm25CalculationOptionsD.officialPM25EndYear))
                        errorBuilder.Append("Required Design Values is not correct!\n");
                }
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkDailyPMUC(BaseScenario baseScenario)
        {
            try
            {
                DailyPMAnalysisConfiguration dailyPMAnalysisConfiguration = baseScenario.configuration as DailyPMAnalysisConfiguration;
                string errorTips = "";
                StringBuilder errorTipsBuilder = new StringBuilder("");
                if (dailyPMAnalysisConfiguration.chooseDesiredOutputD != null)
                {
                    errorTips = "";
                    errorTips = checkUCOutputD(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (dailyPMAnalysisConfiguration.outputChoiceAdvancedD != null)
                {
                    errorTips = "";
                    errorTips = checkUCOutputAdvancedD(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (dailyPMAnalysisConfiguration.dataInputD != null)
                {
                    errorTips = "";
                    errorTips = checkUCDataInputD(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (dailyPMAnalysisConfiguration.speciesFractionOptionsD != null)
                {
                    errorTips = "";
                    errorTips = checkUCSpeciesFractionOptionsD(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (dailyPMAnalysisConfiguration.pm25CalculationOptionsD != null)
                {
                    errorTips = "";
                    errorTips = checkUCPMCalculationOptionsD(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                errorTips = errorTipsBuilder.ToString();
                if (errorTips != null && errorTips.Length > 0)
                {
                    return errorTips;
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }
        #endregion

        #region Ozone
        public static string checkUCOutputO(BaseScenario baseScenario)
        {
            try
            {
                OzoneAnalysisConfiguration ozoneAnalysisConfiguration = baseScenario.configuration as OzoneAnalysisConfiguration;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                if (ozoneAnalysisConfiguration.chooseDesiredOutputO != null)
                {
                    if (!ozoneAnalysisConfiguration.chooseDesiredOutputO.doSpatialFieldEstimates && !ozoneAnalysisConfiguration.chooseDesiredOutputO.doBaseOnlyVNA
                        && !ozoneAnalysisConfiguration.chooseDesiredOutputO.doFutureOnlyVNA && ozoneAnalysisConfiguration.chooseDesiredOutputO.doNeighborFileSpatial)
                    {
                        errorBuilder.Append("Spatial Field Neighbor File generation requires 'Spatial Field File' be checked.\n");
                    }
                }
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkUCDataInputO(BaseScenario baseScenario)
        {
            try
            {
                OzoneAnalysisConfiguration ozoneAnalysisConfiguration = baseScenario.configuration as OzoneAnalysisConfiguration;
                bool ok = false;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";
                //check monitor data file path
                if (ozoneAnalysisConfiguration.dataInputO.ozoneMonitorDataFile != null && ozoneAnalysisConfiguration.dataInputO.ozoneMonitorDataFile.Length > 0)
                {
                    if (!File.Exists(ozoneAnalysisConfiguration.dataInputO.ozoneMonitorDataFile))
                    {
                        errorBuilder.Append("Monitor Data File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(ozoneAnalysisConfiguration.dataInputO.ozoneMonitorDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "designvalue")
                        {
                            errorBuilder.Append("Monitor Data File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("poc") && fieldNameAdd.Contains("dvyear") && fieldNameAdd.Contains("o3") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Length == 9)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Monitor Data File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Monitor Data File can't be empty!\n");
                }

                //check model file-baseline
                if (ozoneAnalysisConfiguration.dataInputO.baselineModelDataFile != null && ozoneAnalysisConfiguration.dataInputO.baselineModelDataFile.Length > 0)
                {
                    if (!File.Exists(ozoneAnalysisConfiguration.dataInputO.baselineModelDataFile))
                    {
                        errorBuilder.Append("Model Baseline File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(ozoneAnalysisConfiguration.dataInputO.baselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Model Baseline File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("o3") && fieldNameAdd.Length == 6)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Model Baseline File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Model Baseline File can't be empty!\n");
                }

                //check model file-forecast
                if (ozoneAnalysisConfiguration.dataInputO.forecastModelDataFile != null && ozoneAnalysisConfiguration.dataInputO.forecastModelDataFile.Length > 0)
                {
                    if (!File.Exists(ozoneAnalysisConfiguration.dataInputO.forecastModelDataFile))
                    {
                        errorBuilder.Append("Model Forecast File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(ozoneAnalysisConfiguration.dataInputO.forecastModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Model Forecast File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("o3") && fieldNameAdd.Length == 6)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Model Forecast File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Model Forecast File can't be empty!\n");
                }

                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkUCFilteringInterpolationO(BaseScenario baseScenario)
        {
            try
            {
                OzoneAnalysisConfiguration ozoneAnalysisConfiguration = baseScenario.configuration as OzoneAnalysisConfiguration;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                if (Convert.ToInt32(ozoneAnalysisConfiguration.filteringInterpolationO.ozoneStartYear.Substring(0, 4)) > Convert.ToInt32(ozoneAnalysisConfiguration.filteringInterpolationO.ozoneEndYear.Substring(0, 4)))
                    errorBuilder.Append("End Year should be later than Start Year!\n");
                if (ozoneAnalysisConfiguration.filteringInterpolationO.requiredDVPeriods != "None selected")
                {
                    if (Convert.ToInt32(ozoneAnalysisConfiguration.filteringInterpolationO.requiredDVPeriods.Substring(0, 4)) < Convert.ToInt32(ozoneAnalysisConfiguration.filteringInterpolationO.ozoneStartYear.Substring(0, 4))
                        || Convert.ToInt32(ozoneAnalysisConfiguration.filteringInterpolationO.requiredDVPeriods.Remove(0, ozoneAnalysisConfiguration.filteringInterpolationO.requiredDVPeriods.Length - 4)) > Convert.ToInt32(ozoneAnalysisConfiguration.filteringInterpolationO.ozoneEndYear.Remove(0, ozoneAnalysisConfiguration.filteringInterpolationO.ozoneEndYear.Length - 4)))
                        errorBuilder.Append("Required Design Values is not correct!\n");
                }
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkUCRRFSpatialGradientO(BaseScenario baseScenario)
        {
            try
            {
                OzoneAnalysisConfiguration ozoneAnalysisConfiguration = baseScenario.configuration as OzoneAnalysisConfiguration;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                double dtest = 0;
                int itest = 0;
                if (ozoneAnalysisConfiguration.rrfSpatialGradientO.useInitialThreshold && (!double.TryParse(ozoneAnalysisConfiguration.rrfSpatialGradientO.initialThresholdValue, out dtest) || dtest < 0))
                    errorBuilder.Append("\"Initial threshold value\" is invalid.\n");
                if (ozoneAnalysisConfiguration.rrfSpatialGradientO.useInitialThreshold && (!int.TryParse(ozoneAnalysisConfiguration.rrfSpatialGradientO.minNumofDaysAtorAboveThreshold, out itest) || itest <= 0))
                    errorBuilder.Append("\"Minimum number of days in baseline at or above threshold\" is invalid.\n");
                if (!ozoneAnalysisConfiguration.rrfSpatialGradientO.useInitialThreshold && ozoneAnalysisConfiguration.rrfSpatialGradientO.topXDays <= 0)
                    errorBuilder.Append("\"Top 'x' modeled ozone days\" is invalid.\n");
                if (!double.TryParse(ozoneAnalysisConfiguration.rrfSpatialGradientO.minAllowableThresholdValue, out dtest) || dtest < 0)
                    errorBuilder.Append("\"Minimum allowable threshold value\" is invalid.\n");
                if (!int.TryParse(ozoneAnalysisConfiguration.rrfSpatialGradientO.minNumDaysAtorAboveMinAllowableThreshold, out itest) || itest <= 0)
                    errorBuilder.Append("\"Min number of days at or above minimum allowable threshold\" is invalid.\n");
                if (ozoneAnalysisConfiguration.rrfSpatialGradientO.doBackstop && (!double.TryParse(ozoneAnalysisConfiguration.rrfSpatialGradientO.backstopMinThresholdforSpatialField, out dtest) || dtest <= 0))
                    errorBuilder.Append("\"Backstop minimum threshold for spatial fields\" is invalid.\n");
                if (!int.TryParse(ozoneAnalysisConfiguration.rrfSpatialGradientO.SRF_StartValue, out itest) || itest <= 0)
                    errorBuilder.Append("\"Start value\" is invalid.\n");
                if (!int.TryParse(ozoneAnalysisConfiguration.rrfSpatialGradientO.SRF_EndValue, out itest) || itest <= 0)
                    errorBuilder.Append("\"End value\" is invalid.\n");
                if (!string.IsNullOrEmpty(errorBuilder.ToString()))
                    return errorTips = errorBuilder.ToString();

                if (Convert.ToSingle(ozoneAnalysisConfiguration.rrfSpatialGradientO.initialThresholdValue) < Convert.ToSingle(ozoneAnalysisConfiguration.rrfSpatialGradientO.minAllowableThresholdValue))
                    errorBuilder.Append("Initial threshold value should be greater than minimum allowable threshold value.\n");
                if (ozoneAnalysisConfiguration.rrfSpatialGradientO.doBackstop && Convert.ToSingle(ozoneAnalysisConfiguration.rrfSpatialGradientO.minAllowableThresholdValue) <= Convert.ToSingle(ozoneAnalysisConfiguration.rrfSpatialGradientO.backstopMinThresholdforSpatialField))
                    errorBuilder.Append("Minimum allowable threshold value should be greater than backstop minimum threshold.\n");
                //if (Convert.ToSingle(ozoneAnalysisConfiguration.rrfSpatialGradientO.subrangeFirstDay) >= Convert.ToSingle(ozoneAnalysisConfiguration.rrfSpatialGradientO.subrangeLastDay))
                if (Convert.ToSingle(ozoneAnalysisConfiguration.rrfSpatialGradientO.subrangeFirstDay) > Convert.ToSingle(ozoneAnalysisConfiguration.rrfSpatialGradientO.subrangeLastDay))//只有1天
                    errorBuilder.Append("Subrange Last Day should be greater than Subrange First Day.\n");
                if (Convert.ToSingle(ozoneAnalysisConfiguration.rrfSpatialGradientO.SRF_StartValue) > Convert.ToSingle(ozoneAnalysisConfiguration.rrfSpatialGradientO.SRF_EndValue))
                    errorBuilder.Append("End Value should be greater than Start Value.\n");
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkOzoneUC(BaseScenario baseScenario)
        {
            try
            {
                OzoneAnalysisConfiguration ozoneAnalysisConfiguration = baseScenario.configuration as OzoneAnalysisConfiguration;
                string errorTips = "";
                StringBuilder errorTipsBuilder = new StringBuilder("");
                if (ozoneAnalysisConfiguration.chooseDesiredOutputO != null)
                {
                    errorTips = "";
                    errorTips = checkUCOutputO(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (ozoneAnalysisConfiguration.dataInputO != null)
                {
                    errorTips = "";
                    errorTips = checkUCDataInputO(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (ozoneAnalysisConfiguration.filteringInterpolationO != null)
                {
                    errorTips = "";
                    errorTips = checkUCFilteringInterpolationO(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (ozoneAnalysisConfiguration.rrfSpatialGradientO != null)
                {
                    errorTips = "";
                    errorTips = checkUCRRFSpatialGradientO(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                errorTips = errorTipsBuilder.ToString();
                if (errorTips != null && errorTips.Length > 0)
                {
                    return errorTips;
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }
        #endregion

        #region Visibility
        public static string checkUCDataInputV(BaseScenario baseScenario)
        {
            try
            {
                VisibilityAnalysisConfiguration visibilityAnalysisConfiguration = baseScenario.configuration as VisibilityAnalysisConfiguration;
                bool ok = false;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";
                //check monitor data file path
                if (visibilityAnalysisConfiguration.chooseDesiredOutputV.choiceUseOldVersionforIMPROVEAlgorithm)
                {
                    if (visibilityAnalysisConfiguration.dataInputV.monitorDataFileOldAlgorithm != null && visibilityAnalysisConfiguration.dataInputV.monitorDataFileOldAlgorithm.Length > 0)
                    {
                        if (!File.Exists(visibilityAnalysisConfiguration.dataInputV.monitorDataFileOldAlgorithm))
                        {
                            errorBuilder.Append("Monitor Data File path does not exist!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(visibilityAnalysisConfiguration.dataInputV.monitorDataFileOldAlgorithm, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorBuilder.Append("Monitor Data File is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("frh") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("amm_no3") && fieldNameAdd.Contains("omc") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("pm10") && fieldNameAdd.Contains("cm") && fieldNameAdd.Contains("amm_so4") && fieldNameAdd.Contains("e_amm_so4") && fieldNameAdd.Contains("e_amm_no3") && fieldNameAdd.Contains("e_omc") && fieldNameAdd.Contains("e_ec") && fieldNameAdd.Contains("e_crustal") && fieldNameAdd.Contains("e_cm") && fieldNameAdd.Contains("tbext") && fieldNameAdd.Contains("dv") && fieldNameAdd.Contains("good_year") && fieldNameAdd.Contains("group") && fieldNameAdd.Contains("possible_ndays") && fieldNameAdd.Contains("ndays") && fieldNameAdd.Contains("complete_quarter") && fieldNameAdd.Contains("sf") && fieldNameAdd.Contains("so4f") && fieldNameAdd.Length == 29)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Monitor Data File is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Monitor Data File can't be empty!\n");
                    }
                }
                else
                {
                    if (visibilityAnalysisConfiguration.dataInputV.monitorDataFileNewAlgorithm != null && visibilityAnalysisConfiguration.dataInputV.monitorDataFileNewAlgorithm.Length > 0)
                    {
                        if (!File.Exists(visibilityAnalysisConfiguration.dataInputV.monitorDataFileNewAlgorithm))
                        {
                            errorBuilder.Append("Monitor Data File path does not exist!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(visibilityAnalysisConfiguration.dataInputV.monitorDataFileNewAlgorithm, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorBuilder.Append("Monitor Data File is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("frh") && fieldNameAdd.Contains("fsrh") && fieldNameAdd.Contains("flrh") && fieldNameAdd.Contains("fssrh") && fieldNameAdd.Contains("ss_rayleigh") && fieldNameAdd.Contains("sea_salt") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("amm_no3") && fieldNameAdd.Contains("omc") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("pm10") && fieldNameAdd.Contains("cm") && fieldNameAdd.Contains("amm_so4") && fieldNameAdd.Contains("large_omc") && fieldNameAdd.Contains("small_omc") && fieldNameAdd.Contains("large_amm_so4") && fieldNameAdd.Contains("small_amm_so4") && fieldNameAdd.Contains("large_amm_no3") && fieldNameAdd.Contains("small_amm_no3") && fieldNameAdd.Contains("e_amm_so4") && fieldNameAdd.Contains("e_amm_no3") && fieldNameAdd.Contains("e_omc") && fieldNameAdd.Contains("e_ec") && fieldNameAdd.Contains("e_crustal") && fieldNameAdd.Contains("e_cm") && fieldNameAdd.Contains("e_sea_salt") && fieldNameAdd.Contains("tbext") && fieldNameAdd.Contains("dv") && fieldNameAdd.Contains("good_year") && fieldNameAdd.Contains("group") && fieldNameAdd.Contains("possible_ndays") && fieldNameAdd.Contains("ndays") && fieldNameAdd.Contains("complete_quarter") && fieldNameAdd.Contains("sf") && fieldNameAdd.Contains("so4f") && fieldNameAdd.Length == 41)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Monitor Data File is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Monitor Data File can't be empty!\n");
                    }
                }


                //check model file-baseline
                if (visibilityAnalysisConfiguration.dataInputV.baselineModelDataFile != null && visibilityAnalysisConfiguration.dataInputV.baselineModelDataFile.Length > 0)
                {
                    if (!File.Exists(visibilityAnalysisConfiguration.dataInputV.baselineModelDataFile))
                    {
                        errorBuilder.Append("Model Baseline File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(visibilityAnalysisConfiguration.dataInputV.baselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Model Baseline File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Model Baseline File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Model Baseline File can't be empty!\n");
                }

                //check model file-forecast
                if (visibilityAnalysisConfiguration.dataInputV.forecastModelDataFile != null && visibilityAnalysisConfiguration.dataInputV.forecastModelDataFile.Length > 0)
                {
                    if (!File.Exists(visibilityAnalysisConfiguration.dataInputV.forecastModelDataFile))
                    {
                        errorBuilder.Append("Model Forecast File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(visibilityAnalysisConfiguration.dataInputV.forecastModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Model Forecast File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Model Forecast File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Model Forecast File can't be empty!\n");
                }

                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkUCFilteringV(BaseScenario baseScenario)
        {
            try
            {
                VisibilityAnalysisConfiguration visibilityAnalysisConfiguration = baseScenario.configuration as VisibilityAnalysisConfiguration;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                if (Convert.ToInt32(visibilityAnalysisConfiguration.filteringV.startMonitorYear) > Convert.ToInt32(visibilityAnalysisConfiguration.filteringV.endMonitorYear))
                    errorBuilder.Append("End Year should be later than Start Year!\n");
                if (Convert.ToInt32(visibilityAnalysisConfiguration.filteringV.baseModelYear) < Convert.ToInt32(visibilityAnalysisConfiguration.filteringV.startMonitorYear)
                    || Convert.ToInt32(visibilityAnalysisConfiguration.filteringV.baseModelYear) > Convert.ToInt32(visibilityAnalysisConfiguration.filteringV.endMonitorYear))
                    errorBuilder.Append("Base Model Year should be between Start Year and End Year.\n");
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkVisibilityUC(BaseScenario baseScenario)
        {
            try
            {
                VisibilityAnalysisConfiguration visibilityAnalysisConfiguration = baseScenario.configuration as VisibilityAnalysisConfiguration;
                string errorTips = "";
                StringBuilder errorTipsBuilder = new StringBuilder("");
                if (visibilityAnalysisConfiguration.dataInputV != null)
                {
                    errorTips = "";
                    errorTips = checkUCDataInputV(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (visibilityAnalysisConfiguration.filteringV != null)
                {
                    errorTips = "";
                    errorTips = checkUCFilteringV(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                errorTips = errorTipsBuilder.ToString();
                if (errorTips != null && errorTips.Length > 0)
                {
                    return errorTips;
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }
        #endregion

        #region SSIA Annual PM
        public static string checkSSIAAnnualPMUC(BaseScenario baseScenario)
        {
            try
            {
                SSIAAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as SSIAAnnualPMAnalysisConfiguration;
                string errorTips = "";
                StringBuilder errorTipsBuilder = new StringBuilder("");
                if (annualPMAnalysisConfiguration.modelInputA != null)
                {
                    errorTips = "";
                    errorTips = checkSSIAUCModelInputA(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (annualPMAnalysisConfiguration.monitorInputA != null)
                {
                    errorTips = "";
                    errorTips = checkSSIAUCMonitorInputA(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                errorTips = errorTipsBuilder.ToString();
                if (errorTips != null && errorTips.Length > 0)
                {
                    return errorTips;
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public static string checkSSIAUCModelInputA(BaseScenario baseScenario)
        {
            try
            {
                SSIAAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as SSIAAnnualPMAnalysisConfiguration;
                bool ok = false;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";

                if (!annualPMAnalysisConfiguration.analysisOptionA.useDispersionOnly)
                {
                    if (annualPMAnalysisConfiguration.modelInputA.DailyModelDataInput)//check daily model data
                    {
                        #region baseline model data
                        if (annualPMAnalysisConfiguration.modelInputA.baselineModelDataFile != null && annualPMAnalysisConfiguration.modelInputA.baselineModelDataFile.Length > 0)
                        {
                            if (!File.Exists(annualPMAnalysisConfiguration.modelInputA.baselineModelDataFile))
                            {
                                errorBuilder.Append("Baseline file path does not exits!\n");
                            }
                            else
                            {
                                fileStream = new FileStream(annualPMAnalysisConfiguration.modelInputA.baselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "day")
                                {
                                    errorBuilder.Append("Baseline file is ill-formatted data!\n");
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                        && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorBuilder.Append("Baseline file is ill-formatted data!\n");
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorBuilder.Append("Daily Baseline Model Data File can not be empty!\n");
                        }
                        #endregion

                        #region control model data
                        if (annualPMAnalysisConfiguration.modelInputA.alternativeScenarioFile != null && annualPMAnalysisConfiguration.modelInputA.alternativeScenarioFile.Length > 0)
                        {
                            if (!File.Exists(annualPMAnalysisConfiguration.modelInputA.alternativeScenarioFile))
                            {
                                errorBuilder.Append("Forecast file path does not exits!\n");
                            }
                            else
                            {
                                fileStream = new FileStream(annualPMAnalysisConfiguration.modelInputA.alternativeScenarioFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "day")
                                {
                                    errorBuilder.Append("Forecast file is ill-formatted data!\n");
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                        && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorBuilder.Append("Forecast file is ill-formatted data!\n");
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorBuilder.Append("Daily Forecast Model Data File can not be empty!\n");
                        }
                        #endregion
                    }

                    if (annualPMAnalysisConfiguration.modelInputA.QuarterlyModelDataInput)//check quarterly model data
                    {
                        #region baseline model data
                        if (annualPMAnalysisConfiguration.modelInputA.baselineModelDataFile != null && annualPMAnalysisConfiguration.modelInputA.baselineModelDataFile.Length > 0)
                        {
                            if (!File.Exists(annualPMAnalysisConfiguration.modelInputA.baselineModelDataFile))
                            {
                                errorBuilder.Append("Baseline file path does not exits!\n");
                            }
                            else
                            {
                                fileStream = new FileStream(annualPMAnalysisConfiguration.modelInputA.baselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorBuilder.Append("Baseline file is ill-formatted data!\n");
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                        && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorBuilder.Append("Baseline file is ill-formatted data!\n");
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorBuilder.Append("Quarterly Baseline Model Data File can not be empty!\n");
                        }
                        #endregion

                        #region control model data
                        if (annualPMAnalysisConfiguration.modelInputA.alternativeScenarioFile != null && annualPMAnalysisConfiguration.modelInputA.alternativeScenarioFile.Length > 0)
                        {
                            if (!File.Exists(annualPMAnalysisConfiguration.modelInputA.alternativeScenarioFile))
                            {
                                errorBuilder.Append("Forecast file path does not exits!\n");
                            }
                            else
                            {
                                fileStream = new FileStream(annualPMAnalysisConfiguration.modelInputA.alternativeScenarioFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorBuilder.Append("Forecast file is ill-formatted data!\n");
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                        && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorBuilder.Append("Forecast file is ill-formatted data!\n");
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorBuilder.Append("Quarterly Forecast Model Data File can not be empty!\n");
                        }
                        #endregion
                    }
                    if (annualPMAnalysisConfiguration.modelInputA.InputFromCMAQ)//CMAQ
                    {

                    }
                }
                if (!annualPMAnalysisConfiguration.analysisOptionA.useGridOnly)
                {
                    if (annualPMAnalysisConfiguration.modelInputA.dispersionFile != null && annualPMAnalysisConfiguration.modelInputA.dispersionFile.Length > 0)
                    {
                        if (!File.Exists(annualPMAnalysisConfiguration.modelInputA.dispersionFile))
                        {
                            errorBuilder.Append(LanguageOld.Translate("Dispersion model file path does not exits!\n"));
                        }
                    }
                    else
                    {
                        errorBuilder.Append(LanguageOld.Translate("Please select a Dispersion Model Data File!\n"));
                    }
                }
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkSSIAUCMonitorInputA(BaseScenario baseScenario)
        {
            try
            {
                SSIAAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as SSIAAnnualPMAnalysisConfiguration;
                bool ok = false;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";

                #region check official monitor data
                if (annualPMAnalysisConfiguration.monitorInputA.officialMonitorDataFile != null && annualPMAnalysisConfiguration.monitorInputA.officialMonitorDataFile.Length > 0)
                {
                    if (!File.Exists(annualPMAnalysisConfiguration.monitorInputA.officialMonitorDataFile))
                    {
                        errorBuilder.Append("Official Quarterly Average FRM Data File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(annualPMAnalysisConfiguration.monitorInputA.officialMonitorDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                        {
                            errorBuilder.Append("Official Quarterly Average FRM Data File is ill-formatted data!\n");
                            return errorTips = errorBuilder.ToString();
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("ndays")
                                && fieldNameAdd.Contains("_substitution_code") && fieldNameAdd.Contains("completion_code") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Length == 11)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Official Quarterly Average FRM Data File is ill-formatted data!\n");
                                return errorTips = errorBuilder.ToString();
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Official Quarterly Average FRM Data File can not be empty!\n");
                    return errorTips = errorBuilder.ToString();
                }
                #endregion

                if (Convert.ToInt32(annualPMAnalysisConfiguration.monitorInputA.monitorDataEndYear) < Convert.ToInt32(annualPMAnalysisConfiguration.monitorInputA.monitorDataStartYear))
                    errorBuilder.Append("End Year should be later than Start Year!\n");
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkSSIAUCCalculationOption(BaseScenario baseScenario)
        {
            try
            {
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                double d = 0;
                if (CommonClass.CurrentBaseScenario.configuration is SSIAAnnualPMAnalysisConfiguration)
                {
                    SSIAAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as SSIAAnnualPMAnalysisConfiguration;
                    if (!double.TryParse(annualPMAnalysisConfiguration.calculationOption.NAAQS, out d))
                        errorBuilder.Append("NAAQS is invalid.\n");
                    if (!double.TryParse(annualPMAnalysisConfiguration.calculationOption.threshold, out d) || d > 100)
                        errorBuilder.Append("Threshold is invalid.\n");
                    if (Convert.ToInt32(annualPMAnalysisConfiguration.calculationOption.endPercentage) < Convert.ToInt32(annualPMAnalysisConfiguration.calculationOption.startPercentage))
                        errorBuilder.Append("End percentage should be bigger than start percentage.\n");
                }
                else if (CommonClass.CurrentBaseScenario.configuration is SSIADailyPMAnalysisConfiguration)
                {
                    SSIADailyPMAnalysisConfiguration dailyAnalysisConfiguration = baseScenario.configuration as SSIADailyPMAnalysisConfiguration;
                    if (!double.TryParse(dailyAnalysisConfiguration.calculationOption.NAAQS, out d))
                        errorBuilder.Append("NAAQS is invalid.\n");
                    if (!double.TryParse(dailyAnalysisConfiguration.calculationOption.threshold, out d) || d > 100)
                        errorBuilder.Append("Threshold is invalid.\n");
                    if (Convert.ToInt32(dailyAnalysisConfiguration.calculationOption.endPercentage) < Convert.ToInt32(dailyAnalysisConfiguration.calculationOption.startPercentage))
                        errorBuilder.Append("End percentage should be bigger than start percentage.\n");
                }
                if (CommonClass.CurrentBaseScenario.configuration is SSIAOzoneAnalysisConfiguration)
                {
                    SSIAOzoneAnalysisConfiguration ozoneAnalysisConfiguration = baseScenario.configuration as SSIAOzoneAnalysisConfiguration;
                    if (!double.TryParse(ozoneAnalysisConfiguration.calculationOption.NAAQS, out d))
                        errorBuilder.Append("NAAQS is invalid.\n");
                    if (!double.TryParse(ozoneAnalysisConfiguration.calculationOption.threshold, out d) || d > 100)
                        errorBuilder.Append("Threshold is invalid.\n");
                    if (Convert.ToInt32(ozoneAnalysisConfiguration.calculationOption.endPercentage) < Convert.ToInt32(ozoneAnalysisConfiguration.calculationOption.startPercentage))
                        errorBuilder.Append("End percentage should be bigger than start percentage.\n");
                }
                if (CommonClass.CurrentBaseScenario.configuration is SSIADepositionConfiguration)             //added by Lijiabin
                {
                    SSIADepositionConfiguration depositionAnalysisConfiguration = baseScenario.configuration as SSIADepositionConfiguration;
                    //if (!double.TryParse(depositionAnalysisConfiguration.calculationOption.NAAQS, out d))
                    //    errorBuilder.Append("NAAQS is invalid.\n");
                    if (!double.TryParse(depositionAnalysisConfiguration.calculationOption.threshold, out d) || d > 100)
                        errorBuilder.Append("Threshold is invalid.\n");
                    //if (Convert.ToInt32(depositionAnalysisConfiguration.calculationOption.endPercentage) < Convert.ToInt32(depositionAnalysisConfiguration.calculationOption.startPercentage))
                    //    errorBuilder.Append("End percentage should be bigger than start percentage.\n");
                }
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        #endregion

        #region SSIA Daily PM

        public static string checkSSIADailyPMUC(BaseScenario baseScenario)
        {
            try
            {
                SSIADailyPMAnalysisConfiguration dailyPMAnalysisConfiguration = baseScenario.configuration as SSIADailyPMAnalysisConfiguration;
                string errorTips = "";
                StringBuilder errorTipsBuilder = new StringBuilder("");
                if (dailyPMAnalysisConfiguration.modelInputD != null)
                {
                    errorTips = "";
                    errorTips = checkSSIAModelInputD(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (dailyPMAnalysisConfiguration.monitorInputD != null)
                {
                    errorTips = "";
                    errorTips = checkSSIAMonitorInputD(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                errorTips = errorTipsBuilder.ToString();
                if (errorTips != null && errorTips.Length > 0)
                {
                    return errorTips;
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public static string checkSSIAModelInputD(BaseScenario baseScenario)
        {
            try
            {
                SSIADailyPMAnalysisConfiguration dailyPMAnalysisConfiguration = baseScenario.configuration as SSIADailyPMAnalysisConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                if (!dailyPMAnalysisConfiguration.analysisOptionD.useDispersionOnly)
                {
                    if (dailyPMAnalysisConfiguration.modelInputD.DailyModelDataInput)//check daily model data
                    {
                        #region baseline model data
                        if (dailyPMAnalysisConfiguration.modelInputD.baselineModelDataFile != null && dailyPMAnalysisConfiguration.modelInputD.baselineModelDataFile.Length > 0)
                        {
                            if (!File.Exists(dailyPMAnalysisConfiguration.modelInputD.baselineModelDataFile))
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Baseline file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(dailyPMAnalysisConfiguration.modelInputD.baselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "day")
                                {
                                    errorTipBuilder.Append(LanguageOld.Translate("Baseline file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(LanguageOld.Translate("Baseline file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorTipBuilder.Append(LanguageOld.Translate("Please select a Daily Baseline Model Data File!\n"));
                        }
                        #endregion
                        #region control model data
                        if (dailyPMAnalysisConfiguration.modelInputD.alternativeScenarioFile != null && dailyPMAnalysisConfiguration.modelInputD.alternativeScenarioFile.Length > 0)
                        {
                            if (!File.Exists(dailyPMAnalysisConfiguration.modelInputD.alternativeScenarioFile))
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Forecast file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(dailyPMAnalysisConfiguration.modelInputD.alternativeScenarioFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "day")
                                {
                                    errorTipBuilder.Append(LanguageOld.Translate("Forecast file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                        && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(LanguageOld.Translate("Forecast file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                            #endregion
                        }
                        else
                        {
                            errorTipBuilder.Append(LanguageOld.Translate("Please select a Daily Forecast Model Data File!\n"));
                        }
                    }

                    if (dailyPMAnalysisConfiguration.modelInputD.QuarterlyModelDataInput)//check quarterly model data
                    {
                        #region baseline model data
                        if (dailyPMAnalysisConfiguration.modelInputD.baselineModelDataFile != null && dailyPMAnalysisConfiguration.modelInputD.baselineModelDataFile.Length > 0)
                        {
                            if (!File.Exists(dailyPMAnalysisConfiguration.modelInputD.baselineModelDataFile))
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Baseline file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(dailyPMAnalysisConfiguration.modelInputD.baselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorTipBuilder.Append(LanguageOld.Translate("Baseline file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(LanguageOld.Translate("Baseline file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorTipBuilder.Append(LanguageOld.Translate("Please select a Quarterly Baseline Model Data File!\n"));
                        }
                        #endregion
                        #region control model data
                        if (dailyPMAnalysisConfiguration.modelInputD.alternativeScenarioFile != null && dailyPMAnalysisConfiguration.modelInputD.alternativeScenarioFile.Length > 0)
                        {
                            if (!File.Exists(dailyPMAnalysisConfiguration.modelInputD.alternativeScenarioFile))
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Forecast file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(dailyPMAnalysisConfiguration.modelInputD.alternativeScenarioFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorTipBuilder.Append(LanguageOld.Translate("Forecast file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(LanguageOld.Translate("Forecast file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorTipBuilder.Append(LanguageOld.Translate("Please select a Quarterly Forecast Model Data File!\n"));
                        }
                        #endregion
                    }

                    if (dailyPMAnalysisConfiguration.modelInputD.InputFromCMAQ)//CMAQ
                    {

                    }
                }
                if (!dailyPMAnalysisConfiguration.analysisOptionD.useGridOnly)
                {
                    if (dailyPMAnalysisConfiguration.modelInputD.dispersionFile != null && dailyPMAnalysisConfiguration.modelInputD.dispersionFile.Length > 0)
                    {
                        if (!File.Exists(dailyPMAnalysisConfiguration.modelInputD.dispersionFile))
                        {
                            errorTipBuilder.Append(LanguageOld.Translate("Dispersion model file path does not exits!\n"));
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(LanguageOld.Translate("Please select a Dispersion Model Data File!\n"));
                    }
                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public static string checkSSIAMonitorInputD(BaseScenario baseScenario)
        {
            try
            {
                SSIADailyPMAnalysisConfiguration dailyPMAnalysisConfiguration = baseScenario.configuration as SSIADailyPMAnalysisConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                if (dailyPMAnalysisConfiguration.monitorInputD.officialMonitorDataFile != null && dailyPMAnalysisConfiguration.monitorInputD.officialMonitorDataFile.Length > 0)
                {
                    if (!File.Exists(dailyPMAnalysisConfiguration.monitorInputD.officialMonitorDataFile))
                    {
                        errorTipBuilder.Append(LanguageOld.Translate("Official Quarterly Average FRM Data File path does not exist!\n"));
                    }
                    else
                    {
                        fileStream = new FileStream(dailyPMAnalysisConfiguration.monitorInputD.officialMonitorDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorTipBuilder.Append(LanguageOld.Translate("Official Quarterly Average FRM Data File is ill-formatted data!\n"));
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("98_percentile")
                                && fieldNameAdd.Contains("epa_flag") && fieldNameAdd.Contains("completion_code") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Contains("rank98") && fieldNameAdd.Length == 12)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Official Quarterly Average FRM Data File is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(LanguageOld.Translate("Please select an Official Quarterly Average FRM Data File!\n"));
                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        #endregion

        #region SSIA O3
        public static string checkSSIAOzoneUC(BaseScenario baseScenario)
        {
            try
            {
                SSIAOzoneAnalysisConfiguration ozoneAnalysisConfiguration = baseScenario.configuration as SSIAOzoneAnalysisConfiguration;
                string errorTips = "";
                StringBuilder errorTipsBuilder = new StringBuilder("");
                if (ozoneAnalysisConfiguration.modelInputO != null)
                {
                    errorTips = "";
                    errorTips = checkSSIAUCModelInputO(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (ozoneAnalysisConfiguration.monitorInputO != null)
                {
                    errorTips = "";
                    errorTips = checkSSIAUCMonitorInputO(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                errorTips = errorTipsBuilder.ToString();
                if (errorTips != null && errorTips.Length > 0)
                {
                    return errorTips;
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public static string checkSSIAUCModelInputO(BaseScenario baseScenario)
        {
            try
            {
                SSIAOzoneAnalysisConfiguration ozoneAnalysisConfiguration = baseScenario.configuration as SSIAOzoneAnalysisConfiguration;
                bool ok = false;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";

                //check model file-baseline
                if (ozoneAnalysisConfiguration.modelInputO.baselineModelDataFile != null && ozoneAnalysisConfiguration.modelInputO.baselineModelDataFile.Length > 0)
                {
                    if (!File.Exists(ozoneAnalysisConfiguration.modelInputO.baselineModelDataFile))
                    {
                        errorBuilder.Append("Model Baseline File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(ozoneAnalysisConfiguration.modelInputO.baselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Model Baseline File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("o3") && fieldNameAdd.Length == 6)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Model Baseline File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Model Baseline File can't be empty!\n");
                }

                //check model file-forecast
                if (ozoneAnalysisConfiguration.modelInputO.forecastModelDataFile != null && ozoneAnalysisConfiguration.modelInputO.forecastModelDataFile.Length > 0)
                {
                    if (!File.Exists(ozoneAnalysisConfiguration.modelInputO.forecastModelDataFile))
                    {
                        errorBuilder.Append("Model Forecast File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(ozoneAnalysisConfiguration.modelInputO.forecastModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Model Forecast File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("o3") && fieldNameAdd.Length == 6)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Model Forecast File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Model Forecast File can't be empty!\n");
                }

                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkSSIAUCMonitorInputO(BaseScenario baseScenario)
        {
            try
            {
                SSIAOzoneAnalysisConfiguration ozoneAnalysisConfiguration = baseScenario.configuration as SSIAOzoneAnalysisConfiguration;
                bool ok = false;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";
                //check monitor data file path
                if (ozoneAnalysisConfiguration.monitorInputO.ozoneMonitorDataFile != null && ozoneAnalysisConfiguration.monitorInputO.ozoneMonitorDataFile.Length > 0)
                {
                    if (!File.Exists(ozoneAnalysisConfiguration.monitorInputO.ozoneMonitorDataFile))
                    {
                        errorBuilder.Append("Monitor Data File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(ozoneAnalysisConfiguration.monitorInputO.ozoneMonitorDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "designvalue")
                        {
                            errorBuilder.Append("Monitor Data File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("poc") && fieldNameAdd.Contains("dvyear") && fieldNameAdd.Contains("o3") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Length == 9)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Monitor Data File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Monitor Data File can't be empty!\n");
                }

                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }
        #endregion

        #region SSIA Deposition added by Lijiabin
        public static string checkSSIADepositionUC(BaseScenario baseScenario)
        {
            try
            {
                SSIADepositionConfiguration depositionAnalysisConfiguration = baseScenario.configuration as SSIADepositionConfiguration;
                string errorTips = "";
                StringBuilder errorTipsBuilder = new StringBuilder("");
                if (depositionAnalysisConfiguration.modelInputDep != null)
                {
                    errorTips = "";
                    errorTips = checkSSIAUCModelInputDep(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                //if (depositionAnalysisConfiguration.monitorInputDep != null)
                //{
                //    errorTips = "";
                //    errorTips = checkSSIAUCMonitorInputDep(baseScenario);
                //    errorTipsBuilder.Append(errorTips);
                //}
                errorTips = errorTipsBuilder.ToString();
                if (errorTips != null && errorTips.Length > 0)
                {
                    return errorTips;
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public static string checkSSIAUCModelInputDep(BaseScenario baseScenario)
        {
            try
            {
                SSIADepositionConfiguration depositionAnalysisConfiguration = baseScenario.configuration as SSIADepositionConfiguration;
                bool ok = false;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";

                //if (!depositionAnalysisConfiguration.analysisOptionDep.useDispersionOnly)
                //{
                //    if (depositionAnalysisConfiguration.modelInputDep.DailyModelDataInput)//check daily model data
                //    {
                #region baseline model data
                if (depositionAnalysisConfiguration.modelInputDep.baselineModelDataFile != null && depositionAnalysisConfiguration.modelInputDep.baselineModelDataFile.Length > 0)
                {
                    if (!File.Exists(depositionAnalysisConfiguration.modelInputDep.baselineModelDataFile))
                    {
                        errorBuilder.Append("Baseline file path does not exits!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(depositionAnalysisConfiguration.modelInputDep.baselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Baseline file is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("tsdep")
                                && fieldNameAdd.Contains("tndep"))
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Baseline file is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Daily Baseline Model Data File can not be empty!\n");
                }
                #endregion

                #region control model data
                if (depositionAnalysisConfiguration.modelInputDep.alternativeScenarioFile != null && depositionAnalysisConfiguration.modelInputDep.alternativeScenarioFile.Length > 0)
                {
                    if (!File.Exists(depositionAnalysisConfiguration.modelInputDep.alternativeScenarioFile))
                    {
                        errorBuilder.Append("Forecast file path does not exits!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(depositionAnalysisConfiguration.modelInputDep.alternativeScenarioFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Forecast file is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("tsdep")
                                && fieldNameAdd.Contains("tndep"))
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Forecast file is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Daily Forecast Model Data File can not be empty!\n");
                }
                #endregion
                //    }                                     
                //}
                //if (!depositionAnalysisConfiguration.analysisOptionDep.useGridOnly)
                //{
                //    if (depositionAnalysisConfiguration.analysisOptionDep.dispersionFile != null && depositionAnalysisConfiguration.analysisOptionDep.dispersionFile.Length > 0)
                //    {
                //        if (!File.Exists(depositionAnalysisConfiguration.analysisOptionDep.dispersionFile))
                //        {
                //            errorBuilder.Append(Language.Translate("Dispersion model file path does not exits!\n"));
                //        }
                //    }
                //    else
                //    {
                //        errorBuilder.Append(Language.Translate("Please select a Dispersion Model Data File!\n"));
                //    }
                //}
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }
        #endregion

        #region PM China check
        public static string checkAnnualPMChina(BaseScenario baseScenario)
        {
            try
            {
                AnnualPMAnalysisChinaConfiguration annualPMChinaConfiguration = baseScenario.configuration as AnnualPMAnalysisChinaConfiguration;
                string errorTips = "";
                StringBuilder errorTipsBuilder = new StringBuilder("");
                if (annualPMChinaConfiguration.modelDataInputChina != null)
                {
                    errorTips = "";
                    errorTips = checkPMChinaModelInput(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (annualPMChinaConfiguration.monitorDataInputChina != null)
                {
                    errorTips = "";
                    errorTips = checkPMChinaMonitorInput(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (annualPMChinaConfiguration.pm25SpeciesOptionChina != null)
                {
                    errorTips = "";
                    errorTips = checkPMChinaSpecies(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                errorTips = errorTipsBuilder.ToString();
                if (errorTips != null && errorTips.Length > 0)
                {
                    return errorTips;
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public static string checkPMChinaModelInput(BaseScenario baseScenario)
        {
            try
            {
                AnnualPMAnalysisChinaConfiguration annualpmchinaconfiguration = baseScenario.configuration as AnnualPMAnalysisChinaConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;

                if (annualpmchinaconfiguration.modelDataInputChina.doQuarterlyAverageDataInput)//check quarter model data
                {
                    #region baseline model data
                    if (annualpmchinaconfiguration.modelDataInputChina.BaselineModelDataFile != null && annualpmchinaconfiguration.modelDataInputChina.BaselineModelDataFile.Length > 0)
                    {
                        if (!File.Exists(annualpmchinaconfiguration.modelDataInputChina.BaselineModelDataFile))
                        {
                            errorTipBuilder.Append(LanguageOld.Translate("Baseline file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(annualpmchinaconfiguration.modelDataInputChina.BaselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Baseline file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("quarter") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(LanguageOld.Translate("Baseline file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(LanguageOld.Translate("Please select a Baseline Model Data File!\n"));
                    }
                    #endregion
                    #region control model data
                    if (annualpmchinaconfiguration.modelDataInputChina.ControlModelDataFile != null && annualpmchinaconfiguration.modelDataInputChina.ControlModelDataFile.Length > 0)
                    {
                        if (!File.Exists(annualpmchinaconfiguration.modelDataInputChina.ControlModelDataFile))
                        {
                            errorTipBuilder.Append(LanguageOld.Translate("Control file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(annualpmchinaconfiguration.modelDataInputChina.ControlModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Control file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("quarter") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(LanguageOld.Translate("Control file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                        #endregion
                    }
                    else
                    {
                        errorTipBuilder.Append(LanguageOld.Translate("Please select a Forecast Model Data File!\n"));
                    }
                }

                if (annualpmchinaconfiguration.modelDataInputChina.doDailyAverageDataInput)//check daily model data
                {
                }

                if (annualpmchinaconfiguration.modelDataInputChina.doInputFromCMAQ)//CMAQ
                {

                }

                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public static string checkPMChinaMonitorInput(BaseScenario baseScenario)
        {
            try
            {
                AnnualPMAnalysisChinaConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as AnnualPMAnalysisChinaConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;

                #region check quarter monitor data
                if (annualPMAnalysisConfiguration.monitorDataInputChina.doQuarterlyMonitorDataInput)
                {
                    if (annualPMAnalysisConfiguration.monitorDataInputChina.MonitorDataInputFile != null && annualPMAnalysisConfiguration.monitorDataInputChina.MonitorDataInputFile.Length > 0)
                    {
                        if (!File.Exists(annualPMAnalysisConfiguration.monitorDataInputChina.MonitorDataInputFile))
                        {
                            errorTipBuilder.Append(LanguageOld.Translate("Quarterly Monitor Data File path does not exist!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(annualPMAnalysisConfiguration.monitorDataInputChina.MonitorDataInputFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Quarterly Monitor Data File is ill-formatted data!\n"));
                                return errorTips = errorTipBuilder.ToString();
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("quarter_dv") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("location_name")
                                    && fieldNameAdd.Contains("station_name") && fieldNameAdd.Length == 8)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(LanguageOld.Translate("Quarterly Monitor Data File is ill-formatted data!\n"));
                                    return errorTips = errorTipBuilder.ToString();
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(LanguageOld.Translate("Please select a Quarterly Monitor Data File!\n"));
                        return errorTips = errorTipBuilder.ToString();
                    }
                }
                #endregion

                if (annualPMAnalysisConfiguration.monitorDataInputChina.doDailyMonitorDataInput)
                {
                }
                if (Convert.ToInt16(annualPMAnalysisConfiguration.monitorDataInputChina.MonitorDataEndYear) < Convert.ToInt16(annualPMAnalysisConfiguration.monitorDataInputChina.MonitorDataStartYear))
                    errorTipBuilder.Append(LanguageOld.Translate("End Year should be later than Start Year!\n"));

                if (annualPMAnalysisConfiguration.monitorDataInputChina.dowVNA)
                {
                    //勾选了wVNA,应该要勾选VNA和eVNA
                    if (!annualPMAnalysisConfiguration.monitorDataInputChina.doInterpolateFRM || !annualPMAnalysisConfiguration.monitorDataInputChina.doInterpolateAdjustedFRM)
                    {
                        errorTipBuilder.Append(LanguageOld.Translate("Calculating wVNA must calculate VNA and eVNA at the same time!\n"));
                    }
                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkPMChinaSpecies(BaseScenario baseScenario)
        {
            try
            {
                AnnualPMAnalysisChinaConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as AnnualPMAnalysisChinaConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                if (annualPMAnalysisConfiguration.pm25SpeciesOptionChina.PM25SpeciesFractionDataAvailable)
                {
                    //check species monitor data file
                    #region
                    if (annualPMAnalysisConfiguration.pm25SpeciesOptionChina.SpeciesMonitorDataFile != null && annualPMAnalysisConfiguration.pm25SpeciesOptionChina.SpeciesMonitorDataFile.Length > 0)
                    {
                        if (!File.Exists(annualPMAnalysisConfiguration.pm25SpeciesOptionChina.SpeciesMonitorDataFile))
                        { errorTipBuilder.Append(LanguageOld.Translate("Species Monitor Data File does not exist!\n")); }
                        else
                        {
                            fileStream = new FileStream(annualPMAnalysisConfiguration.pm25SpeciesOptionChina.SpeciesMonitorDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Species Monitor Data File is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("quarter_dv") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("oc")
                                    && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("h2o") && fieldNameAdd.Contains("other") && fieldNameAdd.Contains("location_name") && fieldNameAdd.Contains("station_name") && fieldNameAdd.Length == 15)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(LanguageOld.Translate("Species Monitor Data File is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(LanguageOld.Translate("Please select a Species Monitor Data File!\n"));
                    }
                    #endregion
                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }
        #endregion

        #region Ozone China check
        public static string checkOzoneChina(BaseScenario baseScenario)
        {
            try
            {
                OzoneAnalysisChinaConfiguration ozonechinaconfiguration = baseScenario.configuration as OzoneAnalysisChinaConfiguration;
                string errorTips = "";
                StringBuilder errorTipsBuilder = new StringBuilder("");
                if (ozonechinaconfiguration.modelDataOzoneChina != null)
                {
                    errorTips = "";
                    errorTips = checkOzoneChinaModelInput(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (ozonechinaconfiguration.monitorDataOzoneChina != null)
                {
                    errorTips = "";
                    errorTips = checkOzoneChinaMonitorInput(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                errorTips = errorTipsBuilder.ToString();
                if (errorTips != null && errorTips.Length > 0)
                {
                    return errorTips;
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public static string checkOzoneChinaModelInput(BaseScenario baseScenario)
        {
            try
            {
                OzoneAnalysisChinaConfiguration ozonechinaconfiguration = baseScenario.configuration as OzoneAnalysisChinaConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;

                #region baseline model data
                if (ozonechinaconfiguration.modelDataOzoneChina.baselineModelDataFile != null && ozonechinaconfiguration.modelDataOzoneChina.baselineModelDataFile.Length > 0)
                {
                    if (!File.Exists(ozonechinaconfiguration.modelDataOzoneChina.baselineModelDataFile))
                    {
                        errorTipBuilder.Append(LanguageOld.Translate("Baseline file path does not exits!\n"));
                    }
                    else
                    {
                        fileStream = new FileStream(ozonechinaconfiguration.modelDataOzoneChina.baselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "season")
                        //if (false)
                        {
                            errorTipBuilder.Append(LanguageOld.Translate("Baseline file is ill-formatted data!\n"));
                        }
                        else
                        {
                            streamReader.ReadLine();
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("season") && fieldNameAdd.Contains("o3") && fieldNameAdd.Length == 6)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Baseline file is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(LanguageOld.Translate("Please select a Baseline Model Data File!\n"));
                }
                #endregion
                #region control model data
                if (ozonechinaconfiguration.modelDataOzoneChina.forecastModelDataFile != null && ozonechinaconfiguration.modelDataOzoneChina.forecastModelDataFile.Length > 0)
                {
                    if (!File.Exists(ozonechinaconfiguration.modelDataOzoneChina.forecastModelDataFile))
                    {
                        errorTipBuilder.Append(LanguageOld.Translate("Control file path does not exits!\n"));
                    }
                    else
                    {
                        fileStream = new FileStream(ozonechinaconfiguration.modelDataOzoneChina.forecastModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "season")
                        //if (false)
                        {
                            errorTipBuilder.Append(LanguageOld.Translate("Control file is ill-formatted data!\n"));
                        }
                        else
                        {
                            streamReader.ReadLine();
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("season") && fieldNameAdd.Contains("o3") && fieldNameAdd.Length == 6)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Control file is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(LanguageOld.Translate("Please select a  Forecast Model Data File!\n"));
                }
                #endregion

                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public static string checkOzoneChinaMonitorInput(BaseScenario baseScenario)
        {
            try
            {
                OzoneAnalysisChinaConfiguration ozonechinaconfiguration = baseScenario.configuration as OzoneAnalysisChinaConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;

                if (ozonechinaconfiguration.monitorDataOzoneChina.ozoneMonitorDataFile != null && ozonechinaconfiguration.monitorDataOzoneChina.ozoneMonitorDataFile.Length > 0)
                {
                    if (!File.Exists(ozonechinaconfiguration.monitorDataOzoneChina.ozoneMonitorDataFile))
                    {
                        errorTipBuilder.Append(LanguageOld.Translate("Monitor file path does not exits!\n"));
                    }
                    else
                    {
                        fileStream = new FileStream(ozonechinaconfiguration.monitorDataOzoneChina.ozoneMonitorDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "designvalue")
                        //if (false)
                        {
                            errorTipBuilder.Append(LanguageOld.Translate("Monitor file is ill-formatted data!\n"));
                        }
                        else
                        {
                            streamReader.ReadLine();
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("season_dv") && fieldNameAdd.Contains("o3")
                                && fieldNameAdd.Contains("location_name") && fieldNameAdd.Contains("station_name") && fieldNameAdd.Length == 8)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(LanguageOld.Translate("Monitor file is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(LanguageOld.Translate("Please select a  Monitor Data File!\n"));
                }
                if (Convert.ToInt16(ozonechinaconfiguration.monitorDataOzoneChina.ozoneEndYear) < Convert.ToInt16(ozonechinaconfiguration.monitorDataOzoneChina.ozoneStartYear))
                    errorTipBuilder.Append(LanguageOld.Translate("End Year should be later than Start Year!\n"));

                if (ozonechinaconfiguration.monitorDataOzoneChina.usewVNA)
                {
                    if (!ozonechinaconfiguration.monitorDataOzoneChina.useVNA || !ozonechinaconfiguration.monitorDataOzoneChina.useEVNA)
                    {
                        errorTipBuilder.Append(LanguageOld.Translate("Calculating wVNA must calculate VNA and eVNA at the same time!\n"));
                    }
                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }

        }

        #endregion

        #region BenMAP Annual PM UC check
        public static string checkUCBenMAPPMModelData(BaseScenario baseScenario)
        {
            try
            {
                BenMAPAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";
                bool ok = false;

                if (annualPMAnalysisConfiguration.modelInput.doDailyModelData)//check daily model data
                {
                    //baseline model data
                    if (annualPMAnalysisConfiguration.modelInput.baselineFile != null && annualPMAnalysisConfiguration.modelInput.baselineFile.Length > 0)
                    {
                        if (!File.Exists(annualPMAnalysisConfiguration.modelInput.baselineFile))
                        {
                            errorBuilder.Append("Baseline file path does not exits!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(annualPMAnalysisConfiguration.modelInput.baselineFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorBuilder.Append("Baseline file is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Baseline file is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Daily Baseline Model Data File can not be empty!\n");
                    }

                    //control model data
                    if (annualPMAnalysisConfiguration.modelInput.forecastFile != null && annualPMAnalysisConfiguration.modelInput.forecastFile.Length > 0)
                    {
                        if (!File.Exists(annualPMAnalysisConfiguration.modelInput.forecastFile))
                        {
                            errorBuilder.Append("Forecast file path does not exits!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(annualPMAnalysisConfiguration.modelInput.forecastFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorBuilder.Append("Forecast file is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Forecast file is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Daily Forecast Model Data File can not be empty!\n");
                    }
                }

                if (annualPMAnalysisConfiguration.modelInput.doQuarterlyModelData)//check quarterly model data
                {
                    //baseline model data
                    if (annualPMAnalysisConfiguration.modelInput.baselineFile != null && annualPMAnalysisConfiguration.modelInput.baselineFile.Length > 0)
                    {
                        if (!File.Exists(annualPMAnalysisConfiguration.modelInput.baselineFile))
                        {
                            errorBuilder.Append("Baseline file path does not exits!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(annualPMAnalysisConfiguration.modelInput.baselineFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorBuilder.Append("Baseline file is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Baseline file is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Quarterly Baseline Model Data File can not be empty!\n");
                    }

                    //control model data
                    #region
                    if (annualPMAnalysisConfiguration.modelInput.forecastFile != null && annualPMAnalysisConfiguration.modelInput.forecastFile.Length > 0)
                    {
                        if (!File.Exists(annualPMAnalysisConfiguration.modelInput.forecastFile))
                        {
                            errorBuilder.Append("Forecast file path does not exits!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(annualPMAnalysisConfiguration.modelInput.forecastFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorBuilder.Append("Forecast file is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Forecast file is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Quarterly Forecast Model Data File can not be empty!\n");
                    }
                    #endregion
                }
                if (annualPMAnalysisConfiguration.modelInput.doInputfromCMAQ)//CMAQ
                {

                }
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkUCBenMAPPMMonitorData(BaseScenario baseScenario)
        {
            try
            {
                BenMAPAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";
                bool ok = false;

                //check unofficial monitor data
                if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.unofficialFile != null && (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.unofficialFile.Length > 0)
                {
                    if (!File.Exists((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.unofficialFile))
                    {
                        errorBuilder.Append("Unofficial Daily Average PM25 Data File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.unofficialFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Unofficial Daily Average PM25 Data File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("pm25")
                                && fieldNameAdd.Contains("epa_flag") && fieldNameAdd.Contains("user_flag") && fieldNameAdd.Length == 8)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Unofficial Daily Average PM25 Data File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Unofficial Daily Average PM25 Data File can't be empty!\n");
                }

                if (!string.IsNullOrEmpty(errorBuilder.ToString()))
                    return errorTips = errorBuilder.ToString();

                if (Convert.ToInt32(annualPMAnalysisConfiguration.monitorInput.endYear) < Convert.ToInt32(annualPMAnalysisConfiguration.monitorInput.startYear))
                    errorBuilder.Append("End Year should be later than Start Year!\n");
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkUCBenMAPPMSpeciesData(BaseScenario baseScenario)
        {
            try
            {
                BenMAPAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";
                bool ok = false;

                //check species monitor data file path
                #region
                if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.doSpeciesMonitorDataFile == true)
                {
                    if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.speciesMonitorDataFile != null && (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.speciesMonitorDataFile.Length > 0)
                    {
                        if (!File.Exists((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.speciesMonitorDataFile))
                        {
                            errorBuilder.Append("Species Monitor Data File path does not exist!\n");
                        }
                        else
                        {
                            fileStream = new FileStream((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.speciesMonitorDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorBuilder.Append("Species Monitor Data File is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("no3r") && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("ocb")
                                    && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("salt") && fieldNameAdd.Contains("don") && fieldNameAdd.Contains("h2o_aim") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("so4_3s") && fieldNameAdd.Contains("crustal_alt")
                                    && fieldNameAdd.Contains("frm_mass") && fieldNameAdd.Contains("measured_fm") && fieldNameAdd.Contains("rcfm") && fieldNameAdd.Contains("al") && fieldNameAdd.Contains("ca") && fieldNameAdd.Contains("fe") && fieldNameAdd.Contains("ti") && fieldNameAdd.Contains("si") && fieldNameAdd.Contains("epa_flag")
                                    && fieldNameAdd.Contains("user_flag") && fieldNameAdd.Length == 28)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Species Monitor Data File is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Species Monitor Data File can't be empty!\n");
                    }
                }
                #endregion
                if (annualPMAnalysisConfiguration.speciesMonitorInput.doSpeciesFractionFile == true)
                {
                    //check species fractions file-spatial field
                    #region
                    if (annualPMAnalysisConfiguration.monitorInput.useVNA)
                    {
                        if (annualPMAnalysisConfiguration.speciesMonitorInput.specFracSpatialFile != null && annualPMAnalysisConfiguration.speciesMonitorInput.specFracSpatialFile.Length > 0)
                        {
                            if (!File.Exists(annualPMAnalysisConfiguration.speciesMonitorInput.specFracSpatialFile))
                            {
                                errorBuilder.Append("Spatial Field Species Fractions File path does not exist!\n");
                            }
                            else
                            {
                                fileStream = new FileStream(annualPMAnalysisConfiguration.speciesMonitorInput.specFracSpatialFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorBuilder.Append("Spatial Field Species Fractions File is ill-formatted data!\n");
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("gridcell_lat") && fieldNameAdd.Contains("gridcell_long") && fieldNameAdd.Contains("quarter") && fieldNameAdd.Contains("pm25_mass_frac")
                                    && fieldNameAdd.Contains("fcr") && fieldNameAdd.Contains("fec") && fieldNameAdd.Contains("fnh4") && fieldNameAdd.Contains("focm") && fieldNameAdd.Contains("fso4")
                                    && fieldNameAdd.Contains("fno3") && fieldNameAdd.Contains("fwater") && fieldNameAdd.Contains("fsalt") && fieldNameAdd.Contains("blank_mass") && fieldNameAdd.Contains("don") && fieldNameAdd.Contains("i_so4")
                                    && fieldNameAdd.Contains("i_no3r") && fieldNameAdd.Contains("i_ocb") && fieldNameAdd.Contains("i_ec") && fieldNameAdd.Contains("i_crustal") && fieldNameAdd.Contains("i_don") && fieldNameAdd.Contains("i_nh4")
                                    && fieldNameAdd.Contains("i_no3") && fieldNameAdd.Contains("i_salt") && fieldNameAdd.Length == 24)
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorBuilder.Append("Spatial Field Species Fractions File is ill-formatted data!\n");
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorBuilder.Append("Spatial Field Species Fractions File can't be empty!\n");
                        }
                    }
                    else if (annualPMAnalysisConfiguration.monitorInput.useEVNA)
                    {
                        if (annualPMAnalysisConfiguration.speciesMonitorInput.specFracSpatialFile != null && annualPMAnalysisConfiguration.speciesMonitorInput.specFracSpatialFile.Length > 0)
                        {
                            if (!File.Exists(annualPMAnalysisConfiguration.speciesMonitorInput.specFracSpatialFile))
                            {
                                errorBuilder.Append("Gradient-adjusted Spatial Field Species Fractions File path does not exist!\n");
                            }
                            else
                            {
                                fileStream = new FileStream(annualPMAnalysisConfiguration.speciesMonitorInput.specFracSpatialFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorBuilder.Append("Gradient-adjusted Spatial Field Species Fractions File is ill-formatted data!\n");
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("gridcell_lat") && fieldNameAdd.Contains("gridcell_long") && fieldNameAdd.Contains("quarter") && fieldNameAdd.Contains("pm25_mass_frac_ga") && fieldNameAdd.Contains("fcr_ga") && fieldNameAdd.Contains("fec_ga")
                                        && fieldNameAdd.Contains("fnh4_ga") && fieldNameAdd.Contains("focm_ga") && fieldNameAdd.Contains("fso4_ga") && fieldNameAdd.Contains("fno3_ga") && fieldNameAdd.Contains("fwater_ga") && fieldNameAdd.Contains("fsalt_ga") && fieldNameAdd.Contains("blank_mass_ga")
                                        && fieldNameAdd.Contains("don_ga") && fieldNameAdd.Contains("i_so4_ga") && fieldNameAdd.Contains("i_no3r_ga") && fieldNameAdd.Contains("i_ocb_ga") && fieldNameAdd.Contains("i_ec_ga") && fieldNameAdd.Contains("i_crustal_ga") && fieldNameAdd.Contains("i_don_ga")
                                        && fieldNameAdd.Contains("i_nh4_ga") && fieldNameAdd.Contains("i_no3_ga") && fieldNameAdd.Contains("i_salt_ga") && fieldNameAdd.Length == 24)
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorBuilder.Append("Gradient-adjusted Spatial Field Species Fractions File is ill-formatted data!\n");
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorBuilder.Append("Gradient-adjusted Spatial Field Species Fractions File can't be empty!\n");
                        }
                    }
                    #endregion
                }

                if (!string.IsNullOrEmpty(errorBuilder.ToString()))
                    return errorTips = errorBuilder.ToString();

                if (Convert.ToInt32(annualPMAnalysisConfiguration.speciesMonitorInput.endYear) < Convert.ToInt32(annualPMAnalysisConfiguration.speciesMonitorInput.startYear))
                    errorBuilder.Append("End Year should be later than Start Year!\n");
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkBenMAPAnnualPMUC(BaseScenario baseScenario)
        {
            try
            {
                BenMAPAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = baseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration;
                string errorTips = "";
                StringBuilder errorTipsBuilder = new StringBuilder("");
                if (annualPMAnalysisConfiguration.modelInput != null)
                {
                    errorTips = "";
                    errorTips = checkUCBenMAPPMModelData(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (annualPMAnalysisConfiguration.monitorInput != null)
                {
                    errorTips = "";
                    errorTips = checkUCBenMAPPMMonitorData(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (annualPMAnalysisConfiguration.speciesMonitorInput != null)
                {
                    errorTips = "";
                    errorTips = checkUCBenMAPPMSpeciesData(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (annualPMAnalysisConfiguration.gridDefinitionFile == null || !File.Exists(annualPMAnalysisConfiguration.gridDefinitionFile))
                {
                    errorTipsBuilder.Append("Grid Definition File path does not exist!\n");
                }
                errorTips = errorTipsBuilder.ToString();
                if (errorTips != null && errorTips.Length > 0)
                {
                    return errorTips;
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }
        #endregion

        #region BenMAP Ozone check
        public static string checkBenMAPOzoneUC(BaseScenario baseScenario)
        {
            try
            {
                BenMAPOzoneAnalysisConfiguration BenMapOzone = baseScenario.configuration as BenMAPOzoneAnalysisConfiguration;
                string errorTips = "";
                StringBuilder errorTipsBuilder = new StringBuilder("");
                if (BenMapOzone.modelInput != null)
                {
                    errorTips = "";
                    errorTips = checkBenMAPOzoneModelData(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                if (BenMapOzone.monitorInput != null)
                {
                    errorTips = "";
                    errorTips = checkBenMAPOzoneMonitorlData(baseScenario);
                    errorTipsBuilder.Append(errorTips);
                }
                errorTips = errorTipsBuilder.ToString();
                if (errorTips != null && errorTips.Length > 0)
                {
                    return errorTips;
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public static string checkBenMAPOzoneModelData(BaseScenario baseScenario)
        {
            try
            {
                BenMAPOzoneAnalysisConfiguration BenMapOzone = baseScenario.configuration as BenMAPOzoneAnalysisConfiguration;
                bool ok = false;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";

                //check model file-baseline
                if (BenMapOzone.modelInput.baselineModelDataFile != null && BenMapOzone.modelInput.baselineModelDataFile.Length > 0)
                {
                    if (!File.Exists(BenMapOzone.modelInput.baselineModelDataFile))
                    {
                        errorBuilder.Append("Model Baseline File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(BenMapOzone.modelInput.baselineModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Model Baseline File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("o3"))
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Model Baseline File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Model Baseline File can't be empty!\n");
                }

                //check model file-forecast
                if (BenMapOzone.modelInput.forecastModelDataFile != null && BenMapOzone.modelInput.forecastModelDataFile.Length > 0)
                {
                    if (!File.Exists(BenMapOzone.modelInput.forecastModelDataFile))
                    {
                        errorBuilder.Append("Model Forecast File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(BenMapOzone.modelInput.forecastModelDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Model Forecast File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("o3"))
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Model Forecast File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Model Forecast File can't be empty!\n");
                }

                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public static string checkBenMAPOzoneMonitorlData(BaseScenario baseScenario)
        {
            try
            {
                BenMAPOzoneAnalysisConfiguration BenMapOzone = baseScenario.configuration as BenMAPOzoneAnalysisConfiguration;
                bool ok = false;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";
                //check monitor data file path
                if (BenMapOzone.monitorInput.ozoneMonitorDataFile != null && BenMapOzone.monitorInput.ozoneMonitorDataFile.Length > 0)
                {
                    if (!File.Exists(BenMapOzone.monitorInput.ozoneMonitorDataFile))
                    {
                        errorBuilder.Append("Monitor Data File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(BenMapOzone.monitorInput.ozoneMonitorDataFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "designvalue")
                        {
                            errorBuilder.Append("Monitor Data File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("poc") && fieldNameAdd.Contains("dvyear") && fieldNameAdd.Contains("o3") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name"))
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Monitor Data File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Monitor Data File can't be empty!\n");
                }

                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }
        #endregion

        #region running analysis
        private static bool runAnnualPM;

        public static bool RunAnnualPM
        {
            get { return CommonClass.runAnnualPM; }
            set { CommonClass.runAnnualPM = value; }
        }
        private static bool runDailyPM;

        public static bool RunDailyPM
        {
            get { return CommonClass.runDailyPM; }
            set { CommonClass.runDailyPM = value; }
        }
        private static bool runOzone;

        public static bool RunOzone
        {
            get { return CommonClass.runOzone; }
            set { CommonClass.runOzone = value; }
        }
        private static bool runVisibility;

        public static bool RunVisibility
        {
            get { return CommonClass.runVisibility; }
            set { CommonClass.runVisibility = value; }
        }
        #endregion

        public static double ToFixed(double d, int s)
        {
            double result = 0;
            //double sp = Math.Pow(10, s+1);
            try
            {
                int integerPart = Convert.ToInt32(Math.Truncate(d));
                string format = "";
                while (format.Length < s)
                {
                    format += "0";
                }
                //需要转为decimal在截取，否则数值较小时，toString之后会变成科学计数法，导致后面计算出错。
                format = d.ToString().Contains(".") ? (((decimal)d).ToString().Substring(d.ToString().IndexOf(".")) + format) : ("." + format);
                string decimalPart = format.Substring(0, s + 1);
                format = integerPart + decimalPart;
                result = Convert.ToDouble(format);
            }
            catch (Exception ex)
            {
                double sp = Math.Pow(10, s);
                result = Math.Round(Math.Truncate(d) + Math.Floor((d - Math.Truncate(d)) * sp) / sp, s);
            }
            //return Math.Round(Math.Truncate(d) + Math.Floor((d - Math.Truncate(d)) * sp) / sp, s);           
            return result;// Math.Round(d, s);//用上一个语句个别数据会出现强制用999结尾，而不是00结尾。
        }
        public static string ToFixedString(double d, int s)
        {
            string result;
            try
            {
                int integerPart = Convert.ToInt32(Math.Truncate(d));
                string format = "";
                while (format.Length < s)
                {
                    format += "0";
                }

                format = d.ToString().Contains(".") ? (d.ToString().Substring(d.ToString().IndexOf(".")) + format) : ("." + format);
                string decimalPart = format.Substring(0, s + 1);
                result = integerPart + decimalPart;
            }
            catch (Exception ex)
            {
                double sp = Math.Pow(10, s);
                result = (Math.Round(Math.Truncate(d) + Math.Floor((d - Math.Truncate(d)) * sp) / sp, s)).ToString();
            }
            return result;//用上一个语句个别数据会出现强制用999结尾，而不是00结尾。
        }

        public static void keypress(bool isInt, object sender, KeyPressEventArgs e)
        {
            if ((Control.ModifierKeys & Keys.Control) == Keys.Control)
            {
                if (e.KeyChar == 22)//ctrl+V
                {
                    IDataObject iData = Clipboard.GetDataObject();

                    // Determines whether the data is in a format you can use.
                    if (iData.GetDataPresent(DataFormats.Text))
                    {
                        // Yes it is, so display it in a text box.
                        string str = (String)iData.GetData(DataFormats.Text);
                        double d = 0;
                        if (!double.TryParse(str, out d))
                            e.Handled = true;
                    }
                    else
                    {
                        e.Handled = true;
                    }
                }
                return;
            }
            if (isInt)//是整数
            {
                if ((e.KeyChar >= '0' && e.KeyChar <= '9') || e.KeyChar == (char)8)
                {
                    e.Handled = false;
                }
                else
                {
                    e.Handled = true;
                }
            }
            else
            {
                if ((e.KeyChar >= '0' && e.KeyChar <= '9') || e.KeyChar == (char)8)
                {
                    e.Handled = false;
                }
                else if (e.KeyChar == '.')
                {
                    if (((TextBox)sender).Text.Trim().IndexOf('.') > -1 && !((TextBox)sender).SelectedText.Contains("."))
                        e.Handled = true;
                }
                else
                {
                    e.Handled = true;
                }
            }
        }

        public static double CalculationWater(double SO4, double NO3r, double NH4, double don, ref double PBW)
        {
            try
            {
                double sum = SO4 + NO3r + NH4;
                double S = SO4 / sum;
                double N = NO3r / sum;
                double A = NH4 / sum;
                if (don < 0.225)
                {
                    PBW = (595.556
                                  - 1440.584 * S
                                  - 1126.488 * N
                                  + 283.907 * (Math.Pow(S, 1.5))
                                  - 13.384 * (Math.Pow(N, 1.5))
                                  - 1486.711 * (Math.Pow(A, 1.5))
                                  + 764.229 * (Math.Pow(S, 2))
                                  + 1501.999 * (N * S)
                                  + 451.873 * (Math.Pow(N, 2))
                                  - 185.183 * (Math.Pow(S, 2.5))
                                  - 375.984 * (Math.Pow(S, 1.5)) * N
                                  - 16.895 * (Math.Pow(S, 3))
                                  - 65.814 * (Math.Pow(N, 1.5)) * S
                                  + 96.825 * (Math.Pow(N, 2.5))
                                  + 83.037 * (Math.Pow(N, 1.5)) * (Math.Pow(S, 1.5))
                                  - 4.419 * (Math.Pow(N, 3))
                                  + 1720.818 * (Math.Pow(A, 1.5)) * S
                                  + 1220.383 * (Math.Pow(A, 1.5)) * N
                                  - 311.496 * (Math.Pow(A, 1.5)) * (Math.Pow(S, 1.5))
                                  + 148.771 * (Math.Pow(A, 1.5)) * (Math.Pow(N, 1.5))
                                  + 1151.648 * (Math.Pow(A, 3))) * sum;
                }
                else
                {
                    PBW = (202048.975
                                - 391494.647 * S
                                - 390912.147 * N
                                + 442.435 * (Math.Pow(S, 1.5))
                                - 155.335 * (Math.Pow(N, 1.5))
                                - 293406.827 * (Math.Pow(A, 1.5))
                                + 189277.519 * (Math.Pow(S, 2))
                                + 377992.610 * N * S
                                + 188636.790 * (Math.Pow(N, 2))
                                - 447.123 * (Math.Pow(S, 2.5))
                                - 507.157 * (Math.Pow(S, 1.5)) * N
                                - 12.794 * (Math.Pow(S, 3))
                                + 146.221 * (Math.Pow(N, 1.5)) * S
                                + 217.197 * (Math.Pow(N, 2.5))
                                + 29.981 * (Math.Pow(N, 1.5)) * (Math.Pow(S, 1.5))
                                - 18.649 * (Math.Pow(N, 3))
                                + 216266.951 * (Math.Pow(A, 1.5)) * S
                                + 215419.876 * (Math.Pow(A, 1.5)) * N
                                - 621.843 * (Math.Pow(A, 1.5)) * (Math.Pow(S, 1.5))
                                + 239.132 * (Math.Pow(A, 1.5)) * (Math.Pow(N, 1.5))
                                + 95413.122 * (Math.Pow(A, 3))) * sum;
                }
                return PBW;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return 0;
            }
        }

        #region VNA
        public static float getDistanceFrom2Point(double X0, double Y0, double X1, double Y1)
        {
            //double radLat1 = Y0 * Math.PI / 180.0;
            //double radLat2 = Y1 * Math.PI / 180.0;
            //double a = radLat1 - radLat2;
            //double b = X0 * Math.PI / 180.0 - X1 * Math.PI / 180.0;
            //double s = 2 * Math.Asin(Math.Sqrt(Math.Pow(Math.Sin(a / 2), 2) +
            // Math.Cos(radLat1) * Math.Cos(radLat2) * Math.Pow(Math.Sin(b / 2), 2)));
            //return Convert.ToSingle(s * 6378.137);
            //double EarthRadius = 6378.137; //kilometers. Change to  1.60931 3960 miles to return all values in miles instead
            //double lon1 = start.X / 180 * Math.PI;
            //double lon2 = end.X / 180 * Math.PI;
            //double lat1 = start.Y / 180 * Math.PI;
            //double lat2 = end.Y / 180 * Math.PI;
            //return Math.Sqrt(Math.Pow(X1 - X0, 2) + Math.Pow(Y1 - Y0, 2)) ;

            return Convert.ToSingle(2 * Math.Asin(Math.Sqrt(Math.Pow((Math.Sin((Y0 / 180 * Math.PI - Y1 / 180 * Math.PI) / 2)), 2) +
             Math.Cos(Y0 / 180 * Math.PI) * Math.Cos(Y1 / 180 * Math.PI) * Math.Pow(Math.Sin((X0 / 180 * Math.PI - X1 / 180 * Math.PI) / 2), 2))) * 6371.000);
        }

        //VNA算法
        /// <summary>
        /// 用法： 输入vertices 首先加入需要计算的Point XY ,然后加入所有监测点X,Y坐标 ，输出为临近的所有监测点坐标同样按X,Y的顺序
        /// </summary>
        /// <param name="vertices"></param>
        /// <param name="result"></param>
        public static void VoronoiPoints(double[] vertices, ref List<double> result)//,List<KeyValuePair<Coordinate,double>> ikey)
        {
            VoronoiGraph gp = Fortune.ComputeVoronoiGraph(vertices);

            foreach (VoronoiEdge edge in gp.Edges)
            {
                if (vertices[0] == edge.RightData.X && vertices[1] == edge.RightData.Y) //|| (vertices[0] == edge.LeftData.X && vertices[1] == edge.LeftData.Y))
                {
                    result.Add(edge.LeftData.X);
                    result.Add(edge.LeftData.Y);
                }
                else if (vertices[0] == edge.LeftData.X && vertices[1] == edge.LeftData.Y)
                {
                    result.Add(edge.RightData.X);
                    result.Add(edge.RightData.Y);
                }
            }
            //foreach (VoronoiEdge edge in myEdgesFirst)
            //{
            //    if (edge.LeftData.X != vertices[0] && edge.LeftData.Y != vertices[1])
            //    {
            //        result.Add(edge.LeftData.X);
            //        result.Add(edge.LeftData.Y);
            //    }
            //    if (edge.RightData.X != vertices[0] && edge.RightData.Y != vertices[1])
            //    {
            //        result.Add(edge.RightData.X);
            //        result.Add(edge.RightData.Y);
            //    }
            //}
            //result.Remove(new Coordinate(vertices[0], vertices[1]));

            //for (int i = 2; i < vertices.Count()/2; i++)
            //{
            //        foreach (VoronoiEdge edge in gp.Edges)
            //        {
            //            if ((vertices[i * 2] == edge.RightData.X && vertices[i * 2 + 1] == edge.RightData.Y) || (vertices[i * 2] == edge.LeftData.X && vertices[i * 2 + 1] == edge.LeftData.Y))
            //            {
            //                if (myEdgesFirst.Contains(edge))
            //                {
            //                    result.Add(new Coordinate(vertices[i * 2], vertices[i * 2 + 1]));
            //                    // i = vertices.Length / 2;
            //                    break;
            //                }
            //            }
            //        }

            //}
            //return result;
        }
        #endregion

        #region
        private static byte[] _backColorPick;
        /// <summary>
        /// 保存背景颜色的rgb
        /// </summary>
        public static byte[] BackColorPick
        {
            get { return CommonClass._backColorPick; }
            set { CommonClass._backColorPick = value; }
        }

        //私有变量
        private static string _projectName;
        /// <summary>
        /// 保存工程路径
        /// </summary>
        public static string ProjectName
        {
            get { return CommonClass._projectName; }
            set { CommonClass._projectName = value; }
        }

        private static SMAT_CE _matsForm;

        public static SMAT_CE MatsForm
        {
            get { return CommonClass._matsForm; }
            set { CommonClass._matsForm = value; }
        }

        private static string[] inputParams;
        /// <summary>
        /// batch job中将参数传入到主程序中[Pragram.cs]
        /// </summary>
        public static string[] InputParams
        {
            get { return CommonClass.inputParams; }
            set { CommonClass.inputParams = value; }
        }

        private static string _currentLog;

        public static string CurrentLog
        {
            get { return _currentLog; }
            set
            {
                _currentLog = value;
                OnCurrentLogChanged();
            }
        }

        private static string _frameName;
        /// <summary>
        /// save frame name,map view 部分
        /// </summary>
        public static string FrameName
        {
            get { return CommonClass._frameName; }
            set { CommonClass._frameName = value; }
        }

        private static bool _isDataViewerState;
        /// <summary>
        /// 判断是否是由dataviewer查看configuration
        /// </summary>
        public static bool IsDataViewerState
        {
            get { return CommonClass._isDataViewerState; }
            set { CommonClass._isDataViewerState = value; }
        }

        private static bool _outputNavigator;
        /// <summary>
        /// 判断是否为Output Navigator
        /// </summary>
        public static bool OutputNavigator
        {
            get { return CommonClass._outputNavigator; }
            set { CommonClass._outputNavigator = value; }
        }

        private static bool _isOutputNavigator;
        /// <summary>
        /// 判断当前为analysis或output navigator，若为output navigator时，则点击dataviewer menu不会改变当前的状态，若为analysis状态，则相应的进行清空
        /// </summary>
        public static bool IsOutputNavigator
        {
            get { return CommonClass._isOutputNavigator; }
            set { CommonClass._isOutputNavigator = value; }
        }

        private static bool _isFirstLoadProject;
        //若直接点击dataviewer，则当前的tabpage为map，若当某个run第一次完成则当前的tabpage为audit trail report
        public static bool IsFirstLoadProject
        {
            get { return CommonClass._isFirstLoadProject; }
            set { CommonClass._isFirstLoadProject = value; }
        }

        private static bool _loadProjectFromStartPageOrAnalysisPage;
        /// <summary>
        /// 判断是否是直接从startpage加载project
        /// </summary>
        public static bool LoadProjectFromStartPageOrAnalysisPage
        {
            get { return CommonClass._loadProjectFromStartPageOrAnalysisPage; }
            set { CommonClass._loadProjectFromStartPageOrAnalysisPage = value; }
        }

        private static bool _openScenario;
        /// <summary>
        /// open scenario or not
        /// </summary>
        public static bool OpenScenario
        {
            get { return CommonClass._openScenario; }
            set { CommonClass._openScenario = value; }
        }

        private static string _fileName;
        /// <summary>
        /// 保存用户当前打开的scenario的路径
        /// </summary>
        public static string FileName
        {
            get { return CommonClass._fileName; }
            set { CommonClass._fileName = value; }
        }

        private static enumAnalysis currentAnalysis;
        /// <summary>
        /// 定义，目前的分析类型
        /// </summary>
        public static enumAnalysis CurrentAnalysis
        {
            get { return currentAnalysis; }
            set
            {
                currentAnalysis = value;
                string configPath = string.Empty;
                if (CommonClass.CurrentAnalysis.ToString().Contains("China"))
                {
                    configPath = System.Configuration.ConfigurationManager.AppSettings["China_DefaultConfiguration"].Replace("##USER_INSTALLATION_DIRECTORY##", Application.StartupPath);
                }
                else
                {
                    configPath = string.Format(Application.StartupPath + @"\Default\{0}.xml", "USA");
                }
                if (!string.IsNullOrEmpty(configPath))
                {
                    CommonClass.dicExampleConfiguration = ConfigurationWorker.GetDataFromXML(configPath);
                }
            }
        }

        private static bool _createCFG;
        /// <summary>
        /// 判断create or open cfg
        /// </summary>
        public static bool CreateCFG
        {
            get { return CommonClass._createCFG; }
            set { CommonClass._createCFG = value; }
        }

        private static enumSaveProjectOrRun _isSaveOrRun;
        /// <summary>
        /// 判断用户选择的是save project 或是save project and run
        /// </summary>
        public static enumSaveProjectOrRun IsSaveOrRun
        {
            get { return CommonClass._isSaveOrRun; }
            set { CommonClass._isSaveOrRun = value; }
        }

        private static double _totalTime;
        /// <summary>
        /// 记录每个过程需要的时间
        /// </summary>
        public static double TotalTime
        {
            get { return CommonClass._totalTime; }
            set { CommonClass._totalTime = Math.Round(value); }
        }

        private static BaseScenario _currentBaseScenario;

        public static BaseScenario CurrentBaseScenario
        {
            get { return CommonClass._currentBaseScenario; }
            set { CommonClass._currentBaseScenario = value; }
        }

        private static bool _isBatch;

        public static bool IsBatch
        {
            get { return CommonClass._isBatch; }
            set { CommonClass._isBatch = value; }
        }
        #endregion

        private const double EARTH_RADIUS = 6378.137;//地球半径，km
        private static double rad(double d)
        {
            return d * Math.PI / 180.0;
        }
        //输出单位，km
        public static double GetDistance(double lat1, double lng1, double lat2, double lng2)
        {
            double radLat1 = rad(lat1);
            double radLat2 = rad(lat2);
            double a = radLat1 - radLat2;
            double b = rad(lng1) - rad(lng2);
            double s = 2 * Math.Asin(Math.Sqrt(Math.Pow(Math.Sin(a / 2), 2) +
             Math.Cos(radLat1) * Math.Cos(radLat2) * Math.Pow(Math.Sin(b / 2), 2)));
            s = s * EARTH_RADIUS;
            s = Math.Round(s * 10000) / 10000;
            return s;
        }

        /// <summary>
        /// get FontSpec from fontName
        /// </summary>
        /// <param name="FontName"></param>
        /// <returns></returns>
        public static ZedGraph.FontSpec ToFontSpec(Font FontName)
        {
            if (FontName == null)
            {
                return null;
            }
            ZedGraph.FontSpec fontSpec = new ZedGraph.FontSpec(FontName.FontFamily.Name, FontName.Size,
        ZedGraph.Default.FontColor, FontName.Bold,
        FontName.Italic, FontName.Underline,
        ZedGraph.Default.FontFillColor, ZedGraph.Default.FontFillBrush,
       ZedGraph.Default.FontFillType);
            fontSpec.Border.IsVisible = false;
            return fontSpec;
        }

        public static bool getmonitorYear(string ucName)
        {
            try
            {
                if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAAnnualPM)
                {
                    if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears == null || CommonClass.officialPMFile != (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.officialMonitorDataFile)
                    {
                        (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears = new List<string>();
                        (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.officialMonitorDataFile = CommonClass.officialPMFile;
                        List<string> lstYears = CommonClass.getListYearsFromCSV((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.officialMonitorDataFile);
                        if (lstYears == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears = null;
                            return false;
                        }
                        foreach (string item in lstYears)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears.Add(item);
                        }
                        (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                        (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears.Sort();
                    }
                }
                else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADailyPM)
                {
                    if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears == null || CommonClass.officialPMFile != (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.officialMonitorDataFile)
                    {
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears = new List<string>();
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.officialMonitorDataFile = CommonClass.officialPMFile;
                        List<string> lstYears = CommonClass.getListYearsFromCSV((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.officialMonitorDataFile);
                        if (lstYears == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears = null;
                            return false;
                        }
                        foreach (string item in lstYears)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears.Add(item);
                        }
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears.Sort();
                    }
                }
                else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAOzone)
                {
                    if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData == null || CommonClass.ozoneMonitorFile != (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.ozoneMonitorDataFile)
                    {
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData = new List<string>();
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.ozoneMonitorDataFile = CommonClass.ozoneMonitorFile;
                        List<string> lstYears = CommonClass.getListYearsFromCSV((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.ozoneMonitorDataFile);
                        if (lstYears == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData = null;
                            return false;
                        }
                        foreach (string item in lstYears)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData.Add(item);
                        }
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData.Distinct().ToList();
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData.Sort();
                    }
                }
                else if (CommonClass.CurrentAnalysis == enumAnalysis.AnnualPMChina)
                {
                    if (CommonClass.monitorFile != (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataInputFile || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataEndYear == null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataStartYear == null)
                    {
                        List<string> lstYears = CommonClass.getListYearsFromCSV(CommonClass.monitorFile);
                        if (lstYears == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataStartYear = null;
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataEndYear = null;
                            return false;
                        }
                        lstYears = lstYears.Distinct().ToList();
                        lstYears.Sort();
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataStartYear = lstYears.First();
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataEndYear = lstYears.Last();
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.lstMonitorYears = lstYears;
                    }
                }
                else if (CommonClass.CurrentAnalysis == enumAnalysis.OzoneChina)
                {
                    if (CommonClass.ozoneMonitorFile != (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneMonitorDataFile || (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneEndYear == null || (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneStartYear == null)
                    {
                        List<string> lstYears = CommonClass.getListYearsFromCSV(CommonClass.ozoneMonitorFile);
                        if (lstYears == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneStartYear = null;
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneEndYear = null;
                            return false;
                        }
                        lstYears = lstYears.Distinct().ToList();
                        lstYears.Sort();
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.lstOzoneMonitorData = lstYears;
                        //(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneStartYear = lstYears.First();
                        //(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneEndYear = lstYears.Last();
                    }
                }
                else if (CommonClass.CurrentAnalysis == enumAnalysis.BenMAPAnnualPM)
                {
                    if (ucName == "uc_BenMAP_AnnualPM_MonitorData")
                    {
                        if (CommonClass.unofficialPMFile != (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.unofficialFile || (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.startYear == null || (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.endYear == null)
                        {
                            List<string> lstYears = CommonClass.getListYearsFromCSV(CommonClass.unofficialPMFile);
                            if (lstYears == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.startYear = null;
                                (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.endYear = null;
                                return false;
                            }
                            lstYears = lstYears.Distinct().ToList();
                            lstYears.Sort();
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.lstUnofficialYear = lstYears;
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.startYear = lstYears.First();
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.endYear = lstYears.Last();
                        }
                    }
                    else if (ucName == "uc_BenMAP_AnnualPM_SpeciesData")
                    {
                        if (CommonClass.speciesMonitorFile != (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.speciesMonitorDataFile || (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.startYear == null || (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.endYear == null)
                        {
                            List<string> lstYears = CommonClass.getListYearsFromCSV(CommonClass.speciesMonitorFile);
                            if (lstYears == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.startYear = null;
                                (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.endYear = null;
                                return false;
                            }
                            lstYears = lstYears.Distinct().ToList();
                            lstYears.Sort();
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.lstSpeciesYear = lstYears;
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.startYear = lstYears.First();
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.endYear = lstYears.Last();
                        }
                    }
                }
                else if (CommonClass.CurrentAnalysis == enumAnalysis.BenMAPSeasonalOzone)
                {
                    if (ucName == "uc_BenMap_Ozone_MonitorData")
                    {
                        if (CommonClass.ozoneMonitorFile != (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.ozoneMonitorDataFile || (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.ozoneStartYear == null || (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.ozoneEndYear == null)
                        {
                            List<string> lstYears = CommonClass.getListYearsFromCSV(CommonClass.ozoneMonitorFile);
                            if (lstYears == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.ozoneStartYear = null;
                                (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.ozoneEndYear = null;
                                return false;
                            }
                            lstYears = lstYears.Distinct().ToList();
                            lstYears.Sort();
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.lstOzoneMonitorData = lstYears;
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.ozoneStartYear = lstYears.First();
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.ozoneEndYear = lstYears.Last();
                        }
                    }
                }
                return true;
            }
            catch
            {
                return false;
            }
        }

    }

}
