﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace SMAT_CE
{

    /// <summary>
    /// 扩展方法
    /// added by devin
    /// 20190724
    /// </summary>
    public static class ExtensionMethods
    {
        /// <summary>
        /// 兼容不同电脑的项目
        /// </summary>
        /// <param name="filePath"></param>    
        /// <returns>返回当前计算机的本地路径</returns>
        public static string ToLocal(this string filePath, string keyWord = "SMAT-CE")
        {
            string result = filePath;
            if (string.IsNullOrEmpty(keyWord))
            {
                keyWord = "SMAT-CE";
            }
            try
            {
                string firstFile = filePath;
                int index = firstFile.IndexOf(keyWord);
                if (index >= 0)
                {
                    index += (keyWord + "\\").Length;
                    string OriginalFilePath = firstFile.Substring(0, index);
                    string LocalFilePath = AppDomain.CurrentDomain.BaseDirectory + string.Format(@"{0}\", keyWord);
                    if (!Directory.Exists(LocalFilePath))
                    {
                        LocalFilePath = AppDomain.CurrentDomain.BaseDirectory;
                    }
                    result = filePath.Replace(OriginalFilePath, LocalFilePath);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
            return result;
        }

        /// <summary>
        /// 设置文件路径时，可以将路径赋给控件的tag标签，然后文件名赋给控件的text
        /// </summary>
        /// <param name="control"></param>
        /// <param name="path">文件路径</param>
        public static void ToTag(this System.Windows.Forms.Control control, string path)
        {

            try
            {
                if (!string.IsNullOrEmpty(path))
                {
                    control.Tag = path;
                    control.Text = Path.GetFileName(path);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        /// 获取本地路径
        /// 针对路径是C:\Users\Devins\Documents\My SMAT-CE Files\格式的。
        /// add by sclong
        /// </summary>
        /// <param name="configPath">当前路径</param>
        ///<param name="keyWord">要截取的关键字位置，关键字前半部分用System.Environment.SpecialFolder.MyDocuments替换，后半部分直接接上</param>
        /// <returns>返回真实存在的路径，如找不到真实存在的路径，则原值返回</returns>
        public static string GetLocalDataPath(this string configPath, string keyWord = "My SMAT-CE Files")
        {
            string result = configPath;
            try
            {
                bool noNeedReplace = File.Exists(configPath) || Directory.Exists(configPath);//存在则不需要用Environment.SpecialFolder.MyDocuments替换
                if (!noNeedReplace)
                {
                    if (configPath.ToLower().Contains(keyWord.ToLower()))
                    {
                        int i = configPath.ToLower().IndexOf(keyWord.ToLower());
                        if (i > 0)
                        {
                            result = Environment.GetFolderPath(System.Environment.SpecialFolder.MyDocuments) + @"\" + configPath.Substring(i);
                        }
                        noNeedReplace = File.Exists(result) || Directory.Exists(result);
                        if (!noNeedReplace)
                        {
                            result = configPath;
                        }
                    }
                    else if (configPath.ToLower().Contains("debug"))
                    {
                        int i = configPath.ToLower().IndexOf("debug");
                        if (i > 0)
                        {
                            result = AppDomain.CurrentDomain.BaseDirectory + configPath.Substring(i + "debug".Length);
                        }
                        noNeedReplace = File.Exists(result) || Directory.Exists(result);
                        if (!noNeedReplace)
                        {
                            result = configPath;
                        }
                    }
                }

            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
            return result;
        }

        /// <summary>
        /// 获取用户文档所在目录
        /// </summary>
        /// <param name="filePath"></param>
        /// <returns></returns>
        public static void ToUserDocument(this BaseScenario baseScenario)
        {
            try
            {

                //ToDO:目前只校验中国案例,后续需补齐其他案例
                if (baseScenario.configuration is AnnualPMAnalysisChinaConfiguration)
                {
                    var configuration = baseScenario.configuration as AnnualPMAnalysisChinaConfiguration;
                    configuration.modelDataInputChina.BaselineModelDataFile = configuration.modelDataInputChina.BaselineModelDataFile.GetLocalDataPath();
                    configuration.modelDataInputChina.ControlModelDataFile = configuration.modelDataInputChina.ControlModelDataFile.GetLocalDataPath();
                    configuration.monitorDataInputChina.MonitorDataInputFile = configuration.monitorDataInputChina.MonitorDataInputFile.GetLocalDataPath();
                    configuration.pm25SpeciesOptionChina.SpeciesMonitorDataFile = configuration.pm25SpeciesOptionChina.SpeciesMonitorDataFile.GetLocalDataPath();
                }
                else if (baseScenario.configuration is OzoneAnalysisChinaConfiguration)
                {
                    var configuration = baseScenario.configuration as OzoneAnalysisChinaConfiguration;
                    configuration.modelDataOzoneChina.baselineModelDataFile = configuration.modelDataOzoneChina.baselineModelDataFile.GetLocalDataPath();
                    configuration.modelDataOzoneChina.forecastModelDataFile = configuration.modelDataOzoneChina.forecastModelDataFile.GetLocalDataPath();
                    configuration.monitorDataOzoneChina.ozoneMonitorDataFile = configuration.monitorDataOzoneChina.ozoneMonitorDataFile.GetLocalDataPath();
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }

        }
    }
}
