﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using ProtoBuf;
using System.Data;
using LumenWorks.Framework.IO.Csv;
using System.Collections;
using System.Windows.Forms;
using System.Data.OleDb;
using DotSpatial.Topology.Voronoi;
using System.Runtime.InteropServices;
using System.Text.RegularExpressions;
using System.Drawing;
using System.Xml;

namespace SMAT_CE
{
    #region DrawMAP Class
    /// <summary>
    /// RSM模型定义
    /// </summary>
    public struct ModelDef
    {
        /// <summary>
        /// 模型域行数
        /// </summary>
        public int RowCount;
        /// <summary>
        /// 模型域列数
        /// </summary>
        public int ColCount;
        /// <summary>
        /// 网格数
        /// </summary>
        public int LocationCount
        {
            get { return RowCount * ColCount; }
        }

        /// <summary>
        /// 最小X坐标
        /// </summary>
        public float MinX;
        /// <summary>
        /// 最大X坐标
        /// </summary>
        public float MaxX;
        /// <summary>
        /// 最小Y坐标
        /// </summary>
        public float MinY;
        /// <summary>
        /// 最大Y坐标
        /// </summary>
        public float MaxY;
        /// <summary>
        /// 网格宽度,单位为米
        /// </summary>
        public float CellWidth;
        /// <summary>
        /// 网格高度,单位为米
        /// </summary>
        public float CellHeight;

        /// <summary>
        /// X坐标轴的单位
        /// </summary>
        public string XUnit;
        /// <summary>
        /// Y坐标轴的单位
        /// </summary>
        public string YUnit;

        /// <summary>
        /// 值的单位
        /// </summary>
        public string ValueUnit;

        /// <summary>
        /// RSM模型计算的污染物
        /// </summary>
        public string Pollutant;

        //public List<string[]> GlobalAttributeslst;//用来保存cmaq数据时调用

    }

    public class ModelDefinition
    {
        string minmaxValueGrid = string.Empty;

        public string MinmaxValueGrid
        {
            get { return minmaxValueGrid; }
            set { minmaxValueGrid = value; }
        }

        double[] cellWidthHeight = new double[2];

        public double[] CellWidthHeight
        {
            get { return cellWidthHeight; }
            set { cellWidthHeight = value; }
        }

        private string _activeGridType;
        /// <summary>
        /// 获取当前活动的网格类型：36km；12km
        /// </summary>
        public string ActiveGridType
        {
            get
            {
                return _activeGridType;
            }
            set
            {
                _activeGridType = value;
            }
        }

        private Dictionary<string, ModelDef> _modelDefs = new Dictionary<string, ModelDef>();
        /// <summary>
        /// 活动网格类型对应的模型定义
        /// </summary>
        public ModelDef modelDef
        {
            get
            {
                if (_modelDefs.ContainsKey(_activeGridType))
                {
                    return _modelDefs[_activeGridType];
                }
                else
                { return new ModelDef(); }
            }
        }
        private Dictionary<string, Dictionary<string, double[,]>> _shapeLCCFiles;
        /// <summary>
        /// 网格类型对应的ShapeLCC定义文件路径,以网格类型为Key
        /// </summary>
        public Dictionary<string, Dictionary<string, double[,]>> ShapeLCCFiles
        {
            get { return _shapeLCCFiles; }
            set { _shapeLCCFiles = value; }
        }
        #region Dictionary<string, double> _gridValues;
        //  private Dictionary<string, double> _gridValues;

        //public Dictionary<string, double> GridValues
        //{
        //    get { return _gridValues; }
        //    set { _gridValues = value; }
        //}
        #endregion
        private Dictionary<string, double> _gridValues;

        public Dictionary<string, double> GridValues
        {
            get { return _gridValues; }
            set { _gridValues = value; }
        }
        private Dictionary<string, string> _ColRowgridValues = new Dictionary<string, string>();
        public Dictionary<string, string> ColRowgridValues
        {
            get { return _ColRowgridValues; }
            set { _ColRowgridValues = value; }
        }

        //读取Shape文件时的分隔号
        private Regex _regex = new Regex(".");
        /// <summary>
        /// 解析浓度文件
        /// </summary>
        /// <returns></returns>
        ///  // 正则表达式
        public Dictionary<string, double> ParseGridValues(Dictionary<string, string> diclatlongTOLambert, Dictionary<string, Dictionary<string, double>> dicValueMAP, string SpeciesType, int uselatlong)
        {
            string msg = "";
            //double gridvalue = new double();
            _gridValues = new Dictionary<string, double>();
            try
            {
                string minLatLong = diclatlongTOLambert[dicValueMAP.First().Key];
                string maxLatLong = minLatLong;
                //double minValue = dicValueMAP.First(p=>p.Value[SpeciesType]>=0).Value[SpeciesType];
                double minValue = dicValueMAP.First().Value[SpeciesType];
                double maxValue = minValue;
                foreach (KeyValuePair<string, Dictionary<string, double>> keyvalue in dicValueMAP)
                {
                    //_regex = new Regex(",");
                    //string[] vars;
                    //vars = _regex.Split(diclatlongTOLambert[keyvalue.Key]);
                    //float x = 0;
                    //float y = 0;
                    //x = float.Parse(vars[0]);
                    //y = float.Parse(vars[1]);
                    if (diclatlongTOLambert.ContainsKey(keyvalue.Key))
                    {
                        _gridValues.Add(diclatlongTOLambert[keyvalue.Key], keyvalue.Value[SpeciesType]);
                        if (keyvalue.Value[SpeciesType] == -9 || keyvalue.Value[SpeciesType] == -7)
                            continue;
                        if (minValue > keyvalue.Value[SpeciesType])
                        {
                            minValue = keyvalue.Value[SpeciesType];
                            minLatLong = diclatlongTOLambert[keyvalue.Key];
                        }
                        if (maxValue < keyvalue.Value[SpeciesType])
                        {
                            maxValue = keyvalue.Value[SpeciesType];
                            maxLatLong = diclatlongTOLambert[keyvalue.Key];
                        }
                    }
                    //_ColRowgridValues.Add(vars[1] + "," + vars[2], vars[0]);//--> key:x,y  value:id
                }
                try
                {
                    if (uselatlong == 0)
                    {
                        string idLatLong = CommonClass.CurrentBaseScenario.dicLambertLatLong[minLatLong];
                        MinmaxValueGrid = idLatLong.Split(',')[0] + "," + dicValueMAP[idLatLong.Split(',')[1] + "," + idLatLong.Split(',')[2]][SpeciesType];
                        idLatLong = CommonClass.CurrentBaseScenario.dicLambertLatLong[maxLatLong];
                        MinmaxValueGrid = MinmaxValueGrid + "," + idLatLong.Split(',')[0] + "," + dicValueMAP[idLatLong.Split(',')[1] + "," + idLatLong.Split(',')[2]][SpeciesType];
                    }
                    else
                    {
                        if (minLatLong.Contains("d"))
                            minLatLong = minLatLong.Substring(2);
                        string idLatLong = CommonClass.CurrentBaseScenario.dicLambertLatLong[minLatLong];
                        if (uselatlong == 2)
                            MinmaxValueGrid = idLatLong.Split(',')[1] + "," + idLatLong.Split(',')[2] + "," + dicValueMAP["utm," + idLatLong.Split(',')[1] + "," + idLatLong.Split(',')[2]][SpeciesType];
                        else
                            MinmaxValueGrid = idLatLong.Split(',')[1] + "," + idLatLong.Split(',')[2] + "," + dicValueMAP[idLatLong.Split(',')[1] + "," + idLatLong.Split(',')[2]][SpeciesType];
                        if (maxLatLong.Contains("d"))
                            maxLatLong = maxLatLong.Substring(2);
                        idLatLong = CommonClass.CurrentBaseScenario.dicLambertLatLong[maxLatLong];
                        if (uselatlong == 2)
                            MinmaxValueGrid = MinmaxValueGrid + "," + idLatLong.Split(',')[1] + "," + idLatLong.Split(',')[2] + "," + dicValueMAP["utm," + idLatLong.Split(',')[1] + "," + idLatLong.Split(',')[2]][SpeciesType];
                        else
                            MinmaxValueGrid = MinmaxValueGrid + "," + idLatLong.Split(',')[1] + "," + idLatLong.Split(',')[2] + "," + dicValueMAP[idLatLong.Split(',')[1] + "," + idLatLong.Split(',')[2]][SpeciesType];
                    }
                }
                catch
                {
                    MinmaxValueGrid = "";
                }
                ////shapeLcc = new double[datas.Length - 1, 3];
                //_regex = new Regex(",");
                //string[] vars;
                //float x = 0;
                //float y = 0;
                //int id = 0;
                ////最小值设置初始值
                //CommonClass.minValue = double.Parse(_regex.Split(datas[1])[3]);
                //// 设置
                //for (int i = 1; i < datas.Length; i++)
                //{
                //    strPath = datas[i];
                //    vars = _regex.Split(strPath);
                //    id = int.Parse(vars[0]);
                //    x = float.Parse(vars[1]);
                //    y = float.Parse(vars[2]);
                //    gridvalue = double.Parse(vars[3]);                  
                //    _gridValues.Add(new PointF(x,y), gridvalue);                  
                //    int row = id / 1000;
                //    int col= id % 1000;
                //    _ColRowgridValues.Add(row + "," + col, gridvalue);
                //}
                return _gridValues;
            }
            catch (Exception ex)
            {
                msg = "Invalid ShapeLcc File!\t";
                CommonClass.LogError(ex);
                return null;
            }
            //finally
            //{
            //    if (msg != "") { MessageBox.Show(msg, "Tip", MessageBoxButtons.OK, MessageBoxIcon.Exclamation); }
            //}
        }

        #region 解析浓度文件 Dictionary<string, double> ParseGridValues(string strPath)
        /// <summary>
        /// 解析浓度文件
        /// </summary>
        /// <returns></returns>
        ///  // 正则表达式
        //public Dictionary<string, double> ParseGridValues(string strPath)
        //{
        //    string msg = "";
        //    double gridvalue = new double();
        //    _gridValues = new Dictionary<string, double>();
        //    try
        //    {
        //        if (!File.Exists(strPath))
        //        {
        //            msg = "Invalid GridValue File!\t";
        //            return null;
        //        }
        //        string[] datas = File.ReadAllLines(strPath, Encoding.Default);
        //        if (datas == null || datas.Length == 0)
        //        {
        //            msg = "Invalid GridValue File!\t";
        //            return null;
        //        }

        //        //shapeLcc = new double[datas.Length - 1, 3];
        //        _regex = new Regex(",");
        //        string[] vars;
        //        double x = 0;
        //        double y = 0;
        //        int id = 0;
        //        //最小值设置初始值
        //        CommonClass.minValue = double.Parse(_regex.Split(datas[1])[3]);
        //        // 设置
        //        for (int i = 1; i < datas.Length; i++)
        //        {
        //            strPath = datas[i];
        //            vars = _regex.Split(strPath);
        //            id = int.Parse(vars[0]);
        //            x = double.Parse(vars[1]);
        //            y = double.Parse(vars[2]);
        //            gridvalue = double.Parse(vars[3]);

        //            _gridValues.Add(x + "," + y, gridvalue);
        //        }
        //        return _gridValues;
        //    }
        //    catch (Exception ex)
        //    {
        //        msg = "Invalid ShapeLcc File!\t";
        //        CommonClass.LogError(ex);
        //        return null;
        //    }
        //    finally
        //    {
        //        if (msg != "") { MessageBox.Show(msg, "Tip", MessageBoxButtons.OK, MessageBoxIcon.Exclamation); }
        //    }
        //}
        #endregion
        /// <summary>
        /// 解析shape定义文件,得到最小x,y和线段list
        /// </summary>
        /// <param name="shapeLCCFile">shape定义文件全路径</param>
        /// <returns>解析成功返回true; 否则返回false</returns>
        public List<List<PointF>> GetShapesSegments(string boundary)
        {
            double[,] shapeLCCFile = _shapeLCCFiles[_activeGridType][boundary];
            int indexX = 0; // csv文件中,x值的索引
            int indexY = 1;
            int indexSegmentID = 2;
            int lastSegmentID = 0;
            int segmentID = 0;
            List<List<PointF>> segmentsList = new List<List<PointF>>();
            char[] sepChar = new char[] { ',' };
            try
            {
                float x, y;
                List<PointF> pts = null;
                int rows = shapeLCCFile.GetLength(0);
                for (int i = 0; i < rows; i++)
                {
                    x = (float)shapeLCCFile[i, indexX];
                    y = (float)shapeLCCFile[i, indexY];
                    segmentID = (int)shapeLCCFile[i, indexSegmentID];
                    if (segmentID != lastSegmentID)
                    {
                        if (pts != null)
                        {
                            segmentsList.Add(pts);
                        }
                        pts = new List<PointF>();
                        lastSegmentID = segmentID;
                    }
                    pts.Add(new PointF(x, y));
                }
                if (pts != null) { segmentsList.Add(pts); }
                return segmentsList;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return null;
            }
        }



        #region 读取模型相关属性


        /// <summary>
        /// 初始化模型数据
        /// 选择模型文件路径后，对BaseCase进行解析,得到模型的全局属性
        /// ???这些数据如果有需要，可以保存到配置文件
        /// </summary>
        /// <param name="filePath">模型文件的路径</param>
        /// <returns></returns>
        public bool ParseModelDef(string domainSize, bool isUTM)
        {
            try
            {
                float width = 12100;
                float height = 12100;
                if (cellWidthHeight != null && cellWidthHeight[0] > 0 && cellWidthHeight[1] > 0)
                {
                    width = (float)cellWidthHeight[0];
                    height = (float)cellWidthHeight[1];
                }
                if (!string.IsNullOrEmpty(domainSize))
                {
                    string[] s = domainSize.Split(',');
                    ModelDef modelDefsmall = CommonClass.modelDefinition.modelDef;
                    modelDefsmall.CellWidth = (float)width;
                    modelDefsmall.CellHeight = (float)height;
                    modelDefsmall.MinX = Convert.ToSingle(s[0]);
                    modelDefsmall.MinY = Convert.ToSingle(s[1]);
                    modelDefsmall.MaxX = Convert.ToSingle(s[2]);
                    modelDefsmall.MaxY = Convert.ToSingle(s[3]);
                    _modelDefs[CommonClass.modelDefinition.ActiveGridType] = modelDefsmall;
                    return true;
                }
                //added by Yangwenwei
                if (LanguageOld.IsSMATChina)
                {
                    ModelDef modelDefchina = new ModelDef();
                    modelDefchina.CellWidth = (float)width;
                    modelDefchina.CellHeight = (float)height;
                    modelDefchina.MinX = (float)-3536000;
                    modelDefchina.MinY = (float)-2824300;
                    modelDefchina.MaxX = (float)2088000;
                    modelDefchina.MaxY = (float)2265500;
                    _modelDefs[CommonClass.modelDefinition.ActiveGridType] = modelDefchina;
                    return true;
                }
                ModelDef modelDef = new ModelDef();
                if (CommonClass.modelDefinition.ActiveGridType == "12km")
                {
                    modelDef.RowCount = 112 * 3;
                    modelDef.ColCount = 148 * 3;
                    // 网格宽度,高度
                    modelDef.CellWidth = (float)width;
                    modelDef.CellHeight = (float)height;

                    if (isUTM)
                    {
                        modelDef.MaxX = 2084597.7f;
                        modelDef.MaxY = 6873065.9f;
                        modelDef.MinX = -2728406.7f;
                        modelDef.MinY = 1935195.9f;
                    }
                    else
                    {
                        double tmp = 0;
                        modelDef.MinX = (float)(-2736000.0);// + modelDef.CellWidth / 2.0);
                        tmp = (modelDef.ColCount - 1) * 12100;// modelDef.CellWidth;
                        // 取得最大坐标
                        modelDef.MaxX = (float)(tmp + modelDef.MinX);
                        // 取得最小y坐标
                        modelDef.MinY = (float)(-2200000.0);// + modelDef.CellHeight / 2.0);
                        // 1~112行之间共有111段，所以1~112之间的总长度是：（112-1）*网格高度
                        tmp = (modelDef.RowCount - 1) * 12100;// modelDef.CellHeight;
                        // 取得最大坐标
                        modelDef.MaxY = (float)(tmp + modelDef.MinY);
                    }
                }
                else if (CommonClass.modelDefinition.ActiveGridType == "36km")
                {
                    modelDef.RowCount = 112;
                    modelDef.ColCount = 148;
                    // 网格宽度,高度
                    modelDef.CellWidth = (float)36000.0;
                    modelDef.CellHeight = (float)36000.0;
                    double tmp = 0;
                    modelDef.MinX = (float)(-2736000.0 + modelDef.CellWidth / 2.0);
                    tmp = (modelDef.ColCount - 1) * modelDef.CellWidth;
                    // 取得最大坐标
                    modelDef.MaxX = (float)(tmp + modelDef.MinX);
                    // 取得最小y坐标
                    modelDef.MinY = (float)(-2088000.0 + modelDef.CellHeight / 2.0);
                    // 1~112行之间共有111段，所以1~112之间的总长度是：（112-1）*网格高度
                    tmp = (modelDef.RowCount - 1) * modelDef.CellHeight;
                    // 取得最大坐标
                    modelDef.MaxY = (float)(tmp + modelDef.MinY);
                }
                //// 坐标轴单位
                modelDef.XUnit = "meter";
                modelDef.YUnit = "meter";
                //// 结果单位
                modelDef.ValueUnit = "μg/m3";
                //// 污染物
                modelDef.Pollutant = "PM25";
                _modelDefs[CommonClass.modelDefinition.ActiveGridType] = modelDef;
                return true;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return false;
            }
        }
        #endregion 读取模型相关属性







    }

    #endregion
    #region Base
    [ProtoContract]
    public class BaseScenario
    {
        [ProtoMember(1)]
        public BaseConfiguration configuration;
        [ProtoMember(2)]
        public BaseLog log;
        [ProtoMember(3)]
        public List<BaseOutput> lstOutput;
        [ProtoMember(4)]
        public List<BaseInput> lstInput;
        [ProtoMember(5)]
        public Dictionary<string, string> dicLatLongLambert;
        [ProtoMember(6)]
        public Dictionary<string, string> dicLambertLatLong;
    }
    [ProtoContract]
    [ProtoInclude(3, typeof(AnnualPMAnalysisConfiguration))]
    [ProtoInclude(4, typeof(DailyPMAnalysisConfiguration))]
    [ProtoInclude(5, typeof(OzoneAnalysisConfiguration))]
    [ProtoInclude(6, typeof(VisibilityAnalysisConfiguration))]
    [ProtoInclude(7, typeof(SSIAAnnualPMAnalysisConfiguration))]
    [ProtoInclude(8, typeof(SSIAOzoneAnalysisConfiguration))]
    [ProtoInclude(9, typeof(AnnualPMAnalysisChinaConfiguration))]
    [ProtoInclude(10, typeof(OzoneAnalysisChinaConfiguration))]
    [ProtoInclude(11, typeof(SSIADailyPMAnalysisConfiguration))]
    [ProtoInclude(12, typeof(BenMAPAnnualPMAnalysisConfiguration))]
    [ProtoInclude(13, typeof(BenMAPOzoneAnalysisConfiguration))]
    [ProtoInclude(14, typeof(SSIADepositionConfiguration))]
    public class BaseConfiguration
    {
        [ProtoMember(1)]
        public string configurationName;
        [ProtoMember(2)]
        public string configurationPath;
    }
    [ProtoContract]
    public class BaseLog
    {
        #region 1015
        [ProtoMember(1)]
        public DateTime start;
        [ProtoMember(2)]
        public DateTime end;
        #endregion
        [ProtoMember(3)]
        public List<string> lstLog;
    }
    [ProtoContract]
    public class BaseOutput
    {
        [ProtoMember(1)]
        public string outputName;
        [ProtoMember(2)]
        public string outputType;
        [ProtoMember(3)]
        public int outputSize;
        [ProtoMember(4)]
        public List<BaseOutputAttribute> lstBaseOutputAttribute;
        [ProtoMember(5)]
        public string outputFilePath;
    }
    [ProtoContract]
    public class BaseInput
    {
        [ProtoMember(1)]
        public string intputType;
        [ProtoMember(2)]
        public string inputName;
        [ProtoMember(3)]
        public string inputPath;
        [ProtoMember(4)]
        public List<BaseInputAttribute> lstBaseInputAttribute;
    }
    [ProtoContract]
    [ProtoInclude(1, typeof(PMPointAttribute))]
    [ProtoInclude(2, typeof(QuarterlyPMPointAttribute))]
    [ProtoInclude(3, typeof(PMModelDataAttribute))]
    [ProtoInclude(4, typeof(SpecFracPointAttribute))]
    [ProtoInclude(5, typeof(PMSpatialAttribute))]
    [ProtoInclude(6, typeof(QuarterlyPMSpatialAttribute))]
    [ProtoInclude(7, typeof(SpecFracSpatialAttribute))]
    [ProtoInclude(8, typeof(NH4DONMonitorsAttribute))]
    [ProtoInclude(9, typeof(PMMonitorsAttribute))]
    [ProtoInclude(10, typeof(SpeciatedMonitorsAttribute))]
    [ProtoInclude(11, typeof(NeighborFilePointAttribute))]
    [ProtoInclude(12, typeof(NeighborFileSpatial))]
    [ProtoInclude(13, typeof(AllYearAllQuarterlyAttribute))]
    [ProtoInclude(14, typeof(AllYearHighQuarterlyAttribute))]
    [ProtoInclude(15, typeof(MonitorsAttribute))]
    [ProtoInclude(16, typeof(OzoneSpatialAttribute))]
    [ProtoInclude(17, typeof(BaselineInterpMonitorAttribute))]
    [ProtoInclude(18, typeof(FutureInterpMonitorAttribute))]
    [ProtoInclude(19, typeof(MonitorIdentifiersAttribute))]
    [ProtoInclude(20, typeof(ForecastedAllDVAttribute))]
    [ProtoInclude(21, typeof(ForecastedVisibilityDataAttribute))]
    [ProtoInclude(22, typeof(ModelRefrenceCellsAttribute))]
    public class BaseOutputAttribute
    {
    }
    [ProtoContract]
    [ProtoInclude(1, typeof(OfficialDailyPMMonitorDataAttribute))]
    [ProtoInclude(2, typeof(ClassISiteNamesAttribute))]
    [ProtoInclude(3, typeof(NewImproveMonitorDataAttribute))]
    [ProtoInclude(4, typeof(DailyModelDataAttribute))]
    [ProtoInclude(5, typeof(OfficialAnnualPMMonitorDataAttribute))]
    [ProtoInclude(6, typeof(GeoMembershipAttribute))]
    [ProtoInclude(7, typeof(InterpolationAttribute))]
    [ProtoInclude(8, typeof(OzoneMonitorDataAttribute))]
    [ProtoInclude(9, typeof(OzoneModelDataAttribute))]
    [ProtoInclude(10, typeof(UnofficialPMMonitorDataAttribute))]
    [ProtoInclude(11, typeof(SpeciesMonitorDataAttribute))]
    [ProtoInclude(12, typeof(OldImproveMonitorDataAttribute))]
    [ProtoInclude(13, typeof(SimpleWindAttribute))]
    [ProtoInclude(14, typeof(DailyModelDataAttribute))]
    [ProtoInclude(15, typeof(QuarterlyModelDataAttribute))]
    [ProtoInclude(16, typeof(CMAQModelDataAttribute))]
    [ProtoInclude(17, typeof(SpeciesFractionFilePoint))]
    [ProtoInclude(18, typeof(SpeciesFractionFileSpatial))]
    public class BaseInputAttribute
    {
    }
    #endregion
    #region Configuration
    //------------------四种不同的Configuration
    [ProtoContract]
    public class ChooseDesiredOutputA
    {
        [ProtoMember(1)]
        public string scenarioName;
        [ProtoMember(2)]
        public bool doStandardAnalysis;
        [ProtoMember(3)]
        public bool doQuarterlyModelData;
        [ProtoMember(4)]
        public bool doUsedQuarterlyAvgModelData;
        [ProtoMember(5)]
        public bool doSpeciesFraction;
        [ProtoMember(6)]
        public bool doAutomaticallyExtract;
    }
    [ProtoContract]
    public class OutputChoiceAdvancedA
    {
        [ProtoMember(1)]
        public bool doInterpolatedSFETempAdj;
        [ProtoMember(2)]
        public bool doInterpolatedSFETempAdj_GradAdj;
        [ProtoMember(3)]
        public bool doQuarterlyAvgFilePoint;
        [ProtoMember(4)]
        public bool doQuarterlyAvgFileSpatial;
        [ProtoMember(5)]
        public bool doQuarterlyAvgFileSpatial_GraAdj;
        [ProtoMember(6)]
        public bool doHighCountySites;
        [ProtoMember(7)]
        public bool doSpeciesFractionSpatial;
        [ProtoMember(8)]
        public bool doSpeciesFractionSpatial_GraAdj;
        [ProtoMember(9)]
        public bool doQuarterlyAvgSpeciatedMonitors;
        [ProtoMember(10)]
        public bool doDesignValuePeriods;
        [ProtoMember(11)]
        public bool doNeighborFilePoint;
        [ProtoMember(12)]
        public bool doNeighborFileSpatial;
        [ProtoMember(13)]
        public bool doBaseOnlyVNA;
        [ProtoMember(14)]
        public bool doFutureOnlyVNA;
        [ProtoMember(15)]
        public bool doBaseOnlyEvna;
        [ProtoMember(16)]
        public bool doFutureOnlyEvna;
        [ProtoMember(17)]
        public bool doBaseOnlyDS;
        [ProtoMember(18)]
        public bool doFutureOnlyDS;
        [ProtoMember(19)]
        public bool doDS;
        [ProtoMember(20)]
        public bool doSpeciesFractionSpatial_DS;
        [ProtoMember(21)]
        public bool doQuarterlyAvgFileSpatial_DS;

        [ProtoMember(22)]
        public int DS_Cmaqres;
        [ProtoMember(23)]
        public int DS_Burn;
        [ProtoMember(24)]
        public int DS_Thin;
        [ProtoMember(25)]
        public int DS_Numit;

    }
    [ProtoContract]
    public class DataInputA
    {
        [ProtoMember(1)]
        public bool doSpeciesMonitorDataFile;
        [ProtoMember(2)]
        public string speciesMonitorDataFile;
        [ProtoMember(3)]
        public bool doSpeciesFractionFile;
        [ProtoMember(4)]
        public string specFracModePoint;
        [ProtoMember(5)]
        public string specFracPointFile;
        [ProtoMember(6)]
        public string specFracModeSpatial;
        [ProtoMember(7)]
        public string specFracSpatialFile;
        [ProtoMember(8)]
        public string unofficialMonitorDataFile;
        [ProtoMember(9)]
        public string officialMonitorDataFile;
        [ProtoMember(10)]
        public bool doDailyModelDataInput;
        [ProtoMember(11)]
        public bool doQuarterlyModelDataInput;
        [ProtoMember(12)]
        public bool doInputFromCmaq;
        [ProtoMember(13)]
        public string baselineModelDataFile;
        [ProtoMember(14)]
        public string forecastModelDataFile;
        [ProtoMember(15)]
        public List<string> lstSTNFractionsMonitorDataYears;
        [ProtoMember(16)]
        public List<string> lstPMCalculationMonitorDataYears;
        [ProtoMember(17)]
        public List<string> lstPMForFractionsMonitorDataYears;
    }
    [ProtoContract]
    public class SpeciesFractionOptionsA
    {
        [ProtoMember(1)]
        public string IMPROVESTN_StartYear;
        [ProtoMember(2)]
        public string IMPROVESTN_EndYear;
        [ProtoMember(3)]
        public bool IMPROVESTN_EPADeletionChoice;
        [ProtoMember(4)]
        public bool IMPROVESTN_UserDeletionChoice;
        [ProtoMember(5)]
        public int IMPROVESTN_MinDays;
        [ProtoMember(6)]
        public int IMPROVESTN_MinYear;
        [ProtoMember(7)]
        public int IMPROVESTN_MinSeasons;
        [ProtoMember(8)]
        public string unofficialStartYear;
        [ProtoMember(9)]
        public string unofficialEndYear;
        [ProtoMember(10)]
        public bool unofficialEPADeletionChoice;
        [ProtoMember(11)]
        public bool unofficialUserDeletionChoice;
        [ProtoMember(12)]
        public int unofficialMinDays;
        [ProtoMember(13)]
        public int unofficialMinYears;
        [ProtoMember(14)]
        public int unofficialMinSeasonsPoint;
        [ProtoMember(15)]
        public int unofficialMinSeasonsSpatial;
        [ProtoMember(16)]
        public string interpolationMethodPM25;
        [ProtoMember(17)]
        public long distancePM25;
        [ProtoMember(18)]
        public string interpolationMethodSO4;
        [ProtoMember(19)]
        public long distanceSO4;
        [ProtoMember(20)]
        public string interpolationMethodNO3;
        [ProtoMember(21)]
        public long distanceNO3;
        [ProtoMember(22)]
        public string interpolationMethodEC;
        [ProtoMember(23)]
        public long distanceEC;
        [ProtoMember(24)]
        public string interpolationMethodSalt;
        [ProtoMember(25)]
        public long distanceSalt;
        [ProtoMember(26)]
        public string interpolationMethodCrustal;
        [ProtoMember(27)]
        public long distanceCrustal;
        [ProtoMember(28)]
        public string interpolationMethodDON;
        [ProtoMember(29)]
        public long distanceDON;
        [ProtoMember(30)]
        public string interpolationMethodOC;
        [ProtoMember(31)]
        public long distanceOC;
        [ProtoMember(32)]
        public string interpolationMethodNH4;
        [ProtoMember(33)]
        public long distanceNH4;
        [ProtoMember(34)]
        public bool doUseDonValues;
        [ProtoMember(35)]
        public bool doUseAmmoniumValues;
        [ProtoMember(36)]
        public int nh4PercentageEvaporating;
        [ProtoMember(37)]
        public decimal defaultBlankMass;
        [ProtoMember(38)]
        public decimal floorOCMMB;
        [ProtoMember(39)]
        public decimal ceilingOCMMB;
        [ProtoMember(40)]
        public bool doAdvancedOptionsForSpeciesFraction;
    }
    [ProtoContract]
    public class PM25CalculationOptionsA
    {
        [ProtoMember(1)]
        public string officialPM25StartYear;
        [ProtoMember(2)]
        public string officialPM25EndYear;
        [ProtoMember(3)]
        public bool choiceOfficialDV;
        [ProtoMember(4)]
        public bool choiceCustomDV;
        [ProtoMember(5)]
        public int minDaysForValidFRMQuarters;
        [ProtoMember(6)]
        public int minQuartersForValidFRMDesignValues;
        [ProtoMember(7)]
        public int minNumDVPeriodsForValidFRMMonitors;
        [ProtoMember(8)]
        public string requiredDVPeriodsForValidFRMMonitors;
        [ProtoMember(9)]
        public bool doCalcNH4fromDON;
        [ProtoMember(10)]
        public bool doCalcNH4fromRRF;
    }
    [ProtoContract]
    public class ModelDataOptionsA
    {
        [ProtoMember(1)]
        public string temporalAdjustmentAtMonitorGrid;
        [ProtoMember(2)]
        public string temporalAdjustmentAtMonitorGridSpatial;
    }
    [ProtoContract]
    public class ChooseDesiredOutputD
    {
        [ProtoMember(1)]
        public string scenarioName;
        [ProtoMember(2)]
        public bool doStandardAnalysis;
        [ProtoMember(3)]
        public bool doQuarterlyPeakModelData;
        [ProtoMember(4)]
        public bool doSpeciesFraction;
        [ProtoMember(5)]
        public bool doAutomaticallyExtract;
    }
    [ProtoContract]
    public class OutputChoiceAdvancedD
    {
        [ProtoMember(1)]
        public bool doQuarterlyPeakFilesPoint;
        [ProtoMember(2)]
        public bool doHighCountySites;
        [ProtoMember(3)]
        public bool doQuarterlyPeakSpeciatedMonitors;
        [ProtoMember(5)]
        public bool doDesignValuePeriods;
        [ProtoMember(6)]
        public bool doNeighborFilePoint;
    }
    [ProtoContract]
    public class DataInputD
    {
        [ProtoMember(1)]
        public bool doSpeciesMonitorDataFile;
        [ProtoMember(2)]
        public string speciesMonitorDataFile;
        [ProtoMember(3)]
        public bool doSpeciesFractionFile;
        [ProtoMember(4)]
        public string specFracModePoint;
        [ProtoMember(5)]
        public string specFracPointFile;
        [ProtoMember(6)]
        public string specFracModeSpatial;
        [ProtoMember(7)]
        public string specFracSpatialFile;
        [ProtoMember(8)]
        public string unofficialMonitorFile;
        [ProtoMember(9)]
        public string officialMonitorFile;
        [ProtoMember(10)]
        public bool doDailyModelDataInput;
        [ProtoMember(11)]
        public bool doQuarterlyPeakModelDataInput;
        [ProtoMember(12)]
        public bool doInputfromCmaq;
        [ProtoMember(13)]
        public string baselineModelFile;
        [ProtoMember(14)]
        public string forecastModelFile;
        [ProtoMember(15)]
        public List<string> lstSTNFractionsMonitorDataYears;
        [ProtoMember(16)]
        public List<string> lstPMCalculationMonitorDataYears;
        [ProtoMember(17)]
        public List<string> lstPMForFractionsMonitorDataYears;
    }
    [ProtoContract]
    public class SpeciesFractionOptionsD
    {
        [ProtoMember(1)]
        public string IMPROVE_StartYear;
        [ProtoMember(2)]
        public string IMPROVE_EndYear;
        [ProtoMember(3)]
        public bool IMPROVE_EPADeletionChoice;
        [ProtoMember(4)]
        public bool IMPROVE_UserDeletionChoice;
        [ProtoMember(5)]
        public int IMPROVE_MinDays;
        [ProtoMember(6)]
        public int IMPROVE_MinQuarters;
        [ProtoMember(7)]
        public int IMPROVE_MinYear;
        [ProtoMember(8)]
        public string unofficialStartYear;
        [ProtoMember(9)]
        public string unofficialEndYear;
        [ProtoMember(10)]
        public bool unofficialEPADeletionChoice;
        [ProtoMember(11)]
        public bool unofficialUserDeletionChoice;
        [ProtoMember(12)]
        public int unofficialMinDays;
        [ProtoMember(13)]
        public int unofficialMinQuartersPoint;
        [ProtoMember(14)]
        public int unofficialMinYears;
        [ProtoMember(15)]
        public bool IMPROVESTN_DoTopXPercent;
        [ProtoMember(16)]
        public int IMPROVESTN_TopXPercent;
        [ProtoMember(17)]
        public bool IMPROVESTN_DoUseAlldailyMonitorValuesGreaterThan;
        [ProtoMember(18)]
        public int IMPROVESTN_UseAlldailyMonitorValuesGreaterThan;
        [ProtoMember(19)]
        public int IMPROVESTN_MinumumNumberOfDaysRequiredAboveFixedAmount;
        [ProtoMember(20)]
        public bool IMPROVESTN_DoUseTopXNumber;
        [ProtoMember(21)]
        public int IMPROVESTN_UseTopXNumber;
        [ProtoMember(22)]
        public bool unofficialPM25_DoTopXPercent;
        [ProtoMember(23)]
        public int unofficialPM25_TopXPercent;
        [ProtoMember(24)]
        public bool unofficialPM25_DoUseAlldailyMonitorValuesGreaterThan;
        [ProtoMember(25)]
        public int unofficialPM25_UseAlldailyMonitorValuesGreaterThan;
        [ProtoMember(26)]
        public int unofficialPM25_MinumumNumberOfDaysRequiredAboveFixedAmount;
        [ProtoMember(27)]
        public bool unofficialPM25_DoTopXNumber;
        [ProtoMember(28)]
        public int unofficialPM25_TopXNumber;
        [ProtoMember(29)]
        public string interpolationMethodPM25;
        [ProtoMember(30)]
        public long distancePM25;
        [ProtoMember(31)]
        public string interpolationMethodSO4;
        [ProtoMember(32)]
        public long distanceSO4;
        [ProtoMember(33)]
        public string interpolationMethodNO3;
        [ProtoMember(34)]
        public long distanceNO3;
        [ProtoMember(35)]
        public string interpolationMethodEC;
        [ProtoMember(36)]
        public long distanceEC;
        [ProtoMember(37)]
        public string interpolationMethodSalt;
        [ProtoMember(38)]
        public long distanceSalt;
        [ProtoMember(39)]
        public string interpolationMethodCrustal;
        [ProtoMember(40)]
        public long distanceCrustal;
        [ProtoMember(41)]
        public string interpolationMethodDON;
        [ProtoMember(42)]
        public long distanceDON;
        [ProtoMember(43)]
        public string interpolationMethodOC;
        [ProtoMember(44)]
        public long distanceOC;
        [ProtoMember(45)]
        public string interpolationMethodNH4;
        [ProtoMember(46)]
        public long distanceNH4;
        [ProtoMember(47)]
        public bool doUseDonValues;
        [ProtoMember(48)]
        public bool doUseMeasuredAmmonium;
        [ProtoMember(49)]
        public int nh4PercentageEvaporating;
        [ProtoMember(50)]
        public decimal defaultBlankMass;
        [ProtoMember(51)]
        public decimal floorOCMMB;
        [ProtoMember(52)]
        public decimal ceilingOCMMB;
        [ProtoMember(53)]
        public bool doAdvancedOptionsForSpeciesFraction;
    }
    [ProtoContract]
    public class PM25CalculationOptionsD
    {
        [ProtoMember(1)]
        public string officialPM25StartYear;
        [ProtoMember(2)]
        public string officialPM25EndYear;
        [ProtoMember(3)]
        public int minNumDVPeriodsForValidFRMMonitors;
        [ProtoMember(4)]
        public string requiredDesignValuePeriodsForValidFRMMonitors;
        [ProtoMember(5)]
        public bool doCalcNH4fromDON;
        [ProtoMember(6)]
        public bool doCalcNH4fromRRF;
    }
    [ProtoContract]
    public class ModelDataOptionsD
    {
        [ProtoMember(1)]
        public string temporalAdjustmentAtMonitorGridPoint;
        [ProtoMember(2)]
        public string temporalAdjustmentAtMonitorGridSpatial;
        [ProtoMember(3)]
        public string temporalAdjustmentType;
        [ProtoMember(4)]
        public bool RRF_DoUseXTopPercent;
        [ProtoMember(5)]
        public int RRF_UseXTopPercent;
        [ProtoMember(6)]
        public bool RRF_DoUseAllModelDaysGreaterThan;
        [ProtoMember(7)]
        public int RRF_UseAllModelDaysGreaterThan;
        [ProtoMember(8)]
        public int RRF_MinumumNumberOfDaysRequiredAboveFixedAmount;
        [ProtoMember(9)]
        public bool RRF_DoUseTopXNumber;
        [ProtoMember(10)]
        public int RRF_UseTopXNumber;
    }
    [ProtoContract]
    public class ChooseDesiredOutputO
    {
        [ProtoMember(1)]
        public string scenarioName;
        [ProtoMember(2)]
        public bool doPointEstimatesForecast;
        [ProtoMember(3)]
        public bool doSpatialFieldEstimates;
        //public bool doSpatialFieldEstimatesBaseline;
        [ProtoMember(4)]
        public bool doSpatialFieldEstimatesGradAdj;
        //public bool doSpatialFieldEstimatesBaselineGradAdj;
        [ProtoMember(5)]
        public bool doBaseOnlyVNA;
        //public bool doSpatialFieldEstimatesForecast;
        [ProtoMember(6)]
        public bool doFutureOnlyVNA;
        //public bool doSpatialFieldEstimatesForecastGradAdj;
        [ProtoMember(7)]
        public bool doAutomaticallyExtract;
        [ProtoMember(8)]
        public bool doDesignValuePeriods;
        [ProtoMember(9)]
        public bool doNeighborFileSpatial;
        [ProtoMember(10)]
        public bool doQuarterlyModelData;
        [ProtoMember(11)]
        public bool doBaseOnlyEVNA;
        [ProtoMember(12)]
        public bool doFutureOnlyEVNA;
        [ProtoMember(13)]
        public bool doMaxDesignValuePeriods;
        [ProtoMember(14)]
        public bool doDownscaler;
        [ProtoMember(15)]
        public bool DSBaseOnly;
        [ProtoMember(16)]
        public bool DSFutureOnly;
        [ProtoMember(17)]
        public int DSBurn;
        [ProtoMember(18)]
        public int DSCmaqres;
        [ProtoMember(19)]
        public int DSThin;
        [ProtoMember(20)]
        public int DSNumit;
    }
    [ProtoContract]
    public class DataInputO
    {
        [ProtoMember(1)]
        public string ozoneMonitorDataFile;
        [ProtoMember(2)]
        public bool doInputfromCmaq;
        [ProtoMember(3)]
        public string baselineModelDataFile;
        [ProtoMember(4)]
        public string forecastModelDataFile;
        [ProtoMember(5)]
        public string temporalAdjustmentAtMonitorGrid;
        [ProtoMember(6)]
        public string temporalAdjustmentType;
        [ProtoMember(7)]
        public List<string> lstOzoneMonitorData;
        [ProtoMember(8)]
        public int maxOzoneModelDays;
    }
    [ProtoContract]
    public class FilteringInterpolationO
    {
        [ProtoMember(1)]
        public string ozoneStartYear;
        [ProtoMember(2)]
        public string ozoneEndYear;
        [ProtoMember(3)]
        public int minNumDV;
        [ProtoMember(4)]
        public string requiredDVPeriods;
        [ProtoMember(5)]
        public string defaultInterpolationMethod;
        [ProtoMember(6)]
        public bool doCheckToSetMaxDistance;
        [ProtoMember(7)]
        public int maxDistance;
    }
    [ProtoContract]
    public class RRFSpatialGradientO
    {
        [ProtoMember(1)]
        public string initialThresholdValue;
        [ProtoMember(2)]
        public string minNumofDaysAtorAboveThreshold;
        [ProtoMember(3)]
        public string minAllowableThresholdValue;
        [ProtoMember(4)]
        public string minNumDaysAtorAboveMinAllowableThreshold;
        [ProtoMember(5)]
        public bool doBackstop;
        [ProtoMember(6)]
        public string backstopMinThresholdforSpatialField;
        [ProtoMember(7)]
        public int subrangeFirstDay;
        [ProtoMember(8)]
        public int subrangeLastDay;
        [ProtoMember(9)]
        public bool doPairDays;
        [ProtoMember(10)]
        public string SRF_StartValue;
        [ProtoMember(11)]
        public string SRF_EndValue;
        [ProtoMember(12)]
        public bool useInitialThreshold;
        [ProtoMember(13)]
        public int topXDays;
    }
    [ProtoContract]
    public class ChooseDesiredOutputV
    {
        [ProtoMember(1)]
        public string scenarioName;
        [ProtoMember(2)]
        public bool doTemporallyAdjVisibilityLevelsForecast;
        [ProtoMember(3)]
        public bool choiceUseOldVersionforIMPROVEAlgorithm;
        [ProtoMember(4)]
        public bool choiceUseNewVersionforIMPROVEAlgorithm;
        [ProtoMember(5)]
        public bool choiceUseModelGridCellAtMonitor;
        [ProtoMember(6)]
        public bool choiceUseModelGridCellatClassIAreaCentroid;
        [ProtoMember(7)]
        public bool doAutomaticallyExtract;
    }
    [ProtoContract]
    public class DataInputV
    {
        [ProtoMember(1)]
        public string monitorDataFileOldAlgorithm;
        [ProtoMember(2)]
        public string monitorDataFileNewAlgorithm;
        [ProtoMember(3)]
        public string baselineModelDataFile;
        [ProtoMember(4)]
        public string forecastModelDataFile;
        [ProtoMember(5)]
        public string temporalAdjustmentAtMonitorGrid;
        [ProtoMember(6)]
        public List<string> lstMonitorDataNew;
        [ProtoMember(7)]
        public List<string> lstMonitorDataOld;
        /// <summary>
        /// 是否生产新Forecast IMPROVE Data文件
        /// </summary>
        [ProtoMember(8)]
        public bool isCreateForecastIMPROVEData;
        [ProtoMember(9)]
        public bool isCheckedForecastIMPROVEAdvanced;
        [ProtoMember(10)]
        public string forecastIMPROVEDataFile;
    }
    [ProtoContract]
    public class FilteringV
    {
        [ProtoMember(1)]
        public string startMonitorYear;
        [ProtoMember(2)]
        public string endMonitorYear;
        [ProtoMember(3)]
        public string baseModelYear;
        [ProtoMember(4)]
        public string minYearsForValidVisibilityMonitors;
    }

    [ProtoContract]
    public class BenMAPAnnualPMModel
    {
        [ProtoMember(1)]
        public string scenarioName;
        [ProtoMember(2)]
        public bool doDailyModelData;
        [ProtoMember(3)]
        public bool doQuarterlyModelData;
        [ProtoMember(4)]
        public bool doInputfromCMAQ;
        [ProtoMember(5)]
        public string baselineFile;
        [ProtoMember(6)]
        public string forecastFile;
        [ProtoMember(7)]
        public string temporalAdjustmentAtMonitorGridSpatial;
    }
    [ProtoContract]
    public class BenMAPAnnualPMMonitor
    {
        [ProtoMember(1)]
        public string unofficialFile;
        [ProtoMember(2)]
        public string startYear;
        [ProtoMember(3)]
        public string endYear;
        [ProtoMember(4)]
        public bool useVNA;
        [ProtoMember(5)]
        public bool useEVNA;
        [ProtoMember(6)]
        public List<string> lstUnofficialYear;


        [ProtoMember(7)]
        public bool doDownscaler;
        [ProtoMember(8)]
        public int DS_Cmaqres;
        [ProtoMember(9)]
        public int DS_Burn;
        [ProtoMember(10)]
        public int DS_Thin;
        [ProtoMember(11)]
        public int DS_Numit;
    }
    [ProtoContract]
    public class BenMAPAnnualPMSpecies
    {
        [ProtoMember(1)]
        public bool doSpeciesMonitorDataFile;
        [ProtoMember(2)]
        public string speciesMonitorDataFile;
        [ProtoMember(3)]
        public bool doSpeciesFractionFile;
        [ProtoMember(4)]
        public string specFracSpatialFile;
        [ProtoMember(5)]
        public string gradAdjSpecFracSpatialFile;
        [ProtoMember(6)]
        public string startYear;
        [ProtoMember(7)]
        public string endYear;
        [ProtoMember(8)]
        public List<string> lstSpeciesYear;
    }

    [ProtoContract]
    public class BenMAPOzoneModel
    {
        [ProtoMember(1)]
        public bool doInputfromCmaq;
        [ProtoMember(2)]
        public string baselineModelDataFile;
        [ProtoMember(3)]
        public string forecastModelDataFile;
        [ProtoMember(4)]
        public string scenarioName;
    }
    [ProtoContract]
    public class BenMapOzoneMonitor
    {
        [ProtoMember(1)]
        public string ozoneMonitorDataFile;
        [ProtoMember(2)]
        public string ozoneStartYear;
        [ProtoMember(3)]
        public string ozoneEndYear;
        [ProtoMember(4)]
        public bool useVNA;
        [ProtoMember(5)]
        public bool useEVNA;
        [ProtoMember(6)]
        public List<string> lstOzoneMonitorData;
        [ProtoMember(7)]
        public string temporalAdjustmentAtMonitorGrid;
        [ProtoMember(8)]
        public string temporalAdjustmentType;

        [ProtoMember(9)]
        public bool doDownscaler;
        [ProtoMember(10)]
        public int DSBurn;
        [ProtoMember(11)]
        public int DSCmaqres;
        [ProtoMember(12)]
        public int DSThin;
        [ProtoMember(13)]
        public int DSNumit;
    }

    [ProtoContract]
    public class SSIAAnalysisOption
    {
        [ProtoMember(1)]
        public string scenarioName;
        [ProtoMember(2)]
        public bool useModelData;
        [ProtoMember(3)]
        public bool useModelFRMData;
        [ProtoMember(4)]
        public bool useGridAndDispersion;
        [ProtoMember(5)]
        public bool useGridOnly;
        [ProtoMember(6)]
        public bool useDispersionOnly;
    }
    [ProtoContract]
    public class SSIAModelDataInputA
    {
        [ProtoMember(1)]
        public bool DailyModelDataInput;
        [ProtoMember(2)]
        public bool QuarterlyModelDataInput;
        [ProtoMember(3)]
        public bool InputFromCMAQ;
        [ProtoMember(4)]
        public string baselineModelDataFile;
        [ProtoMember(5)]
        public string alternativeScenarioFile;
        [ProtoMember(6)]
        public string dispersionFile;
        [ProtoMember(7)]
        public string SourceCoordinateFile;
    }
    [ProtoContract]
    public class SSIAModelDataInputD
    {
        [ProtoMember(1)]
        public bool DailyModelDataInput;
        [ProtoMember(2)]
        public bool QuarterlyModelDataInput;
        [ProtoMember(3)]
        public bool InputFromCMAQ;
        [ProtoMember(4)]
        public string baselineModelDataFile;
        [ProtoMember(5)]
        public string alternativeScenarioFile;
        [ProtoMember(6)]
        public string temporalAdjustmentAtMonitorGridPoint;
        //[ProtoMember(7)]
        //public string temporalAdjustmentAtMonitorGridSpatial;
        [ProtoMember(7)]
        public string temporalAdjustmentType;
        [ProtoMember(8)]
        public bool RRF_DoUseXTopPercent;
        [ProtoMember(9)]
        public int RRF_UseXTopPercent;
        [ProtoMember(10)]
        public bool RRF_DoUseAllModelDaysGreaterThan;
        [ProtoMember(11)]
        public int RRF_UseAllModelDaysGreaterThan;
        [ProtoMember(12)]
        public int RRF_MinumumNumberOfDaysRequiredAboveFixedAmount;
        [ProtoMember(13)]
        public bool RRF_DoUseTopXNumber;
        [ProtoMember(14)]
        public int RRF_UseTopXNumber;
        [ProtoMember(15)]
        public string dispersionFile;
        [ProtoMember(16)]
        public string SourceCoordinateFile;
    }
    [ProtoContract]
    public class SSIAModelDataInputDep       //added by Lijiabin
    {
        [ProtoMember(1)]
        public bool DailyModelDataInput;
        [ProtoMember(2)]
        public bool QuarterlyModelDataInput;
        [ProtoMember(3)]
        public bool InputFromCMAQ;
        [ProtoMember(4)]
        public string baselineModelDataFile;
        [ProtoMember(5)]
        public string alternativeScenarioFile;
        [ProtoMember(6)]
        public string dispersionFile;
        [ProtoMember(7)]
        public string SourceCoordinateFile;
    }
    [ProtoContract]
    public class SSIAModelDataInputO
    {
        [ProtoMember(1)]
        public bool doInputfromCmaq;
        [ProtoMember(2)]
        public string baselineModelDataFile;
        [ProtoMember(3)]
        public string forecastModelDataFile;
        [ProtoMember(4)]
        public string dispersionFile;
        [ProtoMember(5)]
        public string SourceCoordinateFile;
    }
    [ProtoContract]
    public class SSIAMonitorDataInputA
    {
        [ProtoMember(1)]
        public string officialMonitorDataFile;
        [ProtoMember(2)]
        public string monitorDataStartYear;
        [ProtoMember(3)]
        public string monitorDataEndYear;
        [ProtoMember(4)]
        public bool useVNA;
        [ProtoMember(5)]
        public bool useEVNA;
        [ProtoMember(6)]
        public List<string> lstPMCalculationMonitorDataYears;
        [ProtoMember(7)]
        public string temporalAdjustmentAtMonitorGrid;
    }
    [ProtoContract]
    public class SSIAMonitorDataInputD
    {
        [ProtoMember(1)]
        public string officialMonitorDataFile;
        [ProtoMember(2)]
        public string monitorDataStartYear;
        [ProtoMember(3)]
        public string monitorDataEndYear;
        [ProtoMember(4)]
        public List<string> lstPMCalculationMonitorDataYears;
        [ProtoMember(5)]
        public bool useVNA;
        [ProtoMember(6)]
        public bool useEVNA;
    }
    [ProtoContract]
    public class SSIAMonitorDataInputO
    {
        [ProtoMember(1)]
        public string ozoneMonitorDataFile;
        [ProtoMember(2)]
        public string ozoneStartYear;
        [ProtoMember(3)]
        public string ozoneEndYear;
        [ProtoMember(4)]
        public bool useVNA;
        [ProtoMember(5)]
        public bool useEVNA;
        [ProtoMember(6)]
        public List<string> lstOzoneMonitorData;
        [ProtoMember(7)]
        public string temporalAdjustmentAtMonitorGrid;
        [ProtoMember(8)]
        public string temporalAdjustmentType;
        [ProtoMember(9)]
        public bool useDownscaler;
        [ProtoMember(10)]
        public int DSBurn;
        [ProtoMember(11)]
        public int DSThin;
        [ProtoMember(12)]
        public int DSNumit;
        [ProtoMember(13)]
        public int DSCmaqres;
    }
    [ProtoContract]
    public class SSIAMonitorDataInputDep    //added by Lijiabin
    {
        [ProtoMember(1)]
        public string officialMonitorDataFile;
        [ProtoMember(2)]
        public string monitorDataStartYear;
        [ProtoMember(3)]
        public string monitorDataEndYear;
        [ProtoMember(4)]
        public bool useVNA;
        [ProtoMember(5)]
        public bool useEVNA;
        [ProtoMember(6)]
        public List<string> lstPMCalculationMonitorDataYears;
        [ProtoMember(7)]
        public string temporalAdjustmentAtMonitorGrid;
    }
    [ProtoContract]
    public class SSIACalculationOption
    {
        [ProtoMember(1)]
        public string NAAQS;
        [ProtoMember(2)]
        public string threshold;
        [ProtoMember(3)]
        public int startPercentage;
        [ProtoMember(4)]
        public int endPercentage;
    }
    //---UC for Annual PM China added by Yangwenwei 20131227
    [ProtoContract]
    public class ModelDataInputChina
    {
        [ProtoMember(1)]
        public string scenarioName;
        [ProtoMember(2)]
        public bool doQuarterlyAverageDataInput;
        [ProtoMember(3)]
        public bool doDailyAverageDataInput;
        [ProtoMember(4)]
        public bool doInputFromCMAQ;
        [ProtoMember(5)]
        public string BaselineModelDataFile;
        [ProtoMember(6)]
        public string ControlModelDataFile;
        [ProtoMember(7)]
        public string temporalAdjustmentAtMonitorGridPoint;
    }
    [ProtoContract]
    public class MonitorDataInputChina
    {
        [ProtoMember(1)]
        public bool doQuarterlyMonitorDataInput;
        [ProtoMember(2)]
        public bool doDailyMonitorDataInput;
        [ProtoMember(3)]
        public string MonitorDataInputFile;
        [ProtoMember(4)]
        public string MonitorDataStartYear;
        [ProtoMember(5)]
        public string MonitorDataEndYear;
        [ProtoMember(6)]
        public bool doInterpolateFRM;
        [ProtoMember(7)]
        public bool doInterpolateAdjustedFRM;
        [ProtoMember(8)]
        public List<string> lstMonitorYears;
        [ProtoMember(9)]
        public bool dowVNA;
        [ProtoMember(10)]
        public bool dowVNAAdvancedOption;
        [ProtoMember(11)]
        public double wVNAWeight= 0.5d;
        [ProtoMember(12)]
        public bool doNS;
    }
    [ProtoContract]
    public class PM25SpeciesOptionChina
    {
        [ProtoMember(1)]
        public bool PM25SpeciesFractionDataAvailable;
        [ProtoMember(2)]
        public string SpeciesMonitorDataFile;
    }
    //---UC for Ozone China added by Yangwenwei 20140217
    [ProtoContract]
    public class ModelDataOzoneChina
    {
        [ProtoMember(1)]
        public string scenarioName;
        [ProtoMember(2)]
        public bool doInputfromCmaq;
        [ProtoMember(3)]
        public string baselineModelDataFile;
        [ProtoMember(4)]
        public string forecastModelDataFile;
    }
    [ProtoContract]
    public class MonitorDataOzoneChina
    {
        [ProtoMember(1)]
        public string ozoneMonitorDataFile;
        [ProtoMember(2)]
        public string ozoneStartYear;
        [ProtoMember(3)]
        public string ozoneEndYear;
        [ProtoMember(4)]
        public bool useVNA;
        [ProtoMember(5)]
        public bool useEVNA;
        [ProtoMember(6)]
        public List<string> lstOzoneMonitorData;
        [ProtoMember(7)]
        public bool usewVNA;
        [ProtoMember(8)]
        public bool usewVNAAdvancedOption;
        [ProtoMember(9)]
        public double usewVNAWeight = 0.5d;
        [ProtoMember(10)]
        public bool useNS;

    }
    //---------------Annual PM Analysis
    [ProtoContract]
    public class AnnualPMAnalysisConfiguration : BaseConfiguration
    {
        [ProtoMember(1)]
        public ChooseDesiredOutputA chooseDesiredOutputA;
        [ProtoMember(2)]
        public OutputChoiceAdvancedA outputChoiceAdvancedA;
        [ProtoMember(3)]
        public DataInputA dataInputA;
        [ProtoMember(4)]
        public SpeciesFractionOptionsA speciesFractionOptionsA;
        //[ProtoMember(5)]
        //public SpeciesFractionAdvancedA speciesFractionAdvancedA;
        [ProtoMember(5)]
        public PM25CalculationOptionsA pm25CalculationOptionsA;
        [ProtoMember(6)]
        public ModelDataOptionsA modelDataOptionsA;


    }

    //---------------Daily PM Analysis
    [ProtoContract]
    public class DailyPMAnalysisConfiguration : BaseConfiguration
    {
        [ProtoMember(1)]
        public ChooseDesiredOutputD chooseDesiredOutputD;
        [ProtoMember(2)]
        public OutputChoiceAdvancedD outputChoiceAdvancedD;
        [ProtoMember(3)]
        public DataInputD dataInputD;
        [ProtoMember(4)]
        public SpeciesFractionOptionsD speciesFractionOptionsD;
        //[ProtoMember(5)]
        //public SpeciesFractionAdvancedD speciesFractionAdvancedD;
        [ProtoMember(5)]
        public PM25CalculationOptionsD pm25CalculationOptionsD;
        [ProtoMember(6)]
        public ModelDataOptionsD modelDataOptionsD;
    }

    //---------------Ozone Analysis
    [ProtoContract]
    public class OzoneAnalysisConfiguration : BaseConfiguration
    {
        [ProtoMember(1)]
        public ChooseDesiredOutputO chooseDesiredOutputO;
        [ProtoMember(2)]
        public DataInputO dataInputO;
        [ProtoMember(3)]
        public FilteringInterpolationO filteringInterpolationO;
        [ProtoMember(4)]
        public RRFSpatialGradientO rrfSpatialGradientO;
    }

    //---------------Visibility Analysis
    [ProtoContract]
    public class VisibilityAnalysisConfiguration : BaseConfiguration
    {
        [ProtoMember(1)]
        public ChooseDesiredOutputV chooseDesiredOutputV;
        [ProtoMember(2)]
        public DataInputV dataInputV;
        [ProtoMember(3)]
        public FilteringV filteringV;
    }

    //---------------BenMAP Annual PM Analysis
    [ProtoContract]
    public class BenMAPAnnualPMAnalysisConfiguration : BaseConfiguration
    {
        [ProtoMember(1)]
        public BenMAPAnnualPMModel modelInput;
        [ProtoMember(2)]
        public BenMAPAnnualPMMonitor monitorInput;
        [ProtoMember(3)]
        public BenMAPAnnualPMSpecies speciesMonitorInput;
        [ProtoMember(4)]
        public string gridDefinitionFile;
    }
    [ProtoContract]
    public class BenMAPOzoneAnalysisConfiguration : BaseConfiguration
    {
        [ProtoMember(1)]
        public BenMAPOzoneModel modelInput;
        [ProtoMember(2)]
        public BenMapOzoneMonitor monitorInput;
        [ProtoMember(3)]
        public string gridDefinitionFile;
    }

    //---------------SSIA
    [ProtoContract]
    public class SSIAAnnualPMAnalysisConfiguration : BaseConfiguration
    {
        [ProtoMember(1)]
        public SSIAAnalysisOption analysisOptionA;
        [ProtoMember(2)]
        public SSIAModelDataInputA modelInputA;
        [ProtoMember(3)]
        public SSIAMonitorDataInputA monitorInputA;
        [ProtoMember(4)]
        public SSIACalculationOption calculationOption;
    }

    [ProtoContract]
    public class SSIADailyPMAnalysisConfiguration : BaseConfiguration
    {
        [ProtoMember(1)]
        public SSIAAnalysisOption analysisOptionD;
        [ProtoMember(2)]
        public SSIAModelDataInputD modelInputD;
        [ProtoMember(3)]
        public SSIAMonitorDataInputD monitorInputD;
        [ProtoMember(4)]
        public SSIACalculationOption calculationOption;
    }

    [ProtoContract]
    public class SSIAOzoneAnalysisConfiguration : BaseConfiguration
    {
        [ProtoMember(1)]
        public SSIAAnalysisOption analysisOptionO;
        [ProtoMember(2)]
        public SSIAModelDataInputO modelInputO;
        [ProtoMember(3)]
        public SSIAMonitorDataInputO monitorInputO;
        [ProtoMember(4)]
        public SSIACalculationOption calculationOption;
    }

    [ProtoContract]
    public class SSIADepositionConfiguration : BaseConfiguration  //added by Lijiabin
    {
        [ProtoMember(1)]
        public SSIAAnalysisOption analysisOptionDep;
        [ProtoMember(2)]
        public SSIAModelDataInputDep modelInputDep;
        [ProtoMember(3)]
        public SSIAMonitorDataInputDep monitorInputDep;
        [ProtoMember(4)]
        public SSIACalculationOption calculationOption;
    }
    //-----------------Annual PM Analysis in China added by Yangwenwei
    [ProtoContract]
    public class AnnualPMAnalysisChinaConfiguration : BaseConfiguration
    {
        [ProtoMember(1)]
        public ModelDataInputChina modelDataInputChina;
        [ProtoMember(2)]
        public MonitorDataInputChina monitorDataInputChina;
        [ProtoMember(3)]
        public PM25SpeciesOptionChina pm25SpeciesOptionChina;
    }

    //------------------Ozone Analysis in China added by Yangwenwei
    [ProtoContract]
    public class OzoneAnalysisChinaConfiguration : BaseConfiguration
    {
        [ProtoMember(1)]
        public ModelDataOzoneChina modelDataOzoneChina;
        [ProtoMember(2)]
        public MonitorDataOzoneChina monitorDataOzoneChina;
    }
    #endregion
    #region Output
    //------------Annual PM scenario name + Annual PM25 Point/High Counties Sites,对于Annual PM中，bPMDV为b_pm25_ann_DV，fPMDV为f_pm25_ann_DV
    //------------Daily PM ---------Daily PM Point,bPMDV 为b_pm25_b_DV, fPMDV为b_pm25_b_DV
    //------------Daily PM----------High County Sites
    [ProtoContract]
    public class PMPointAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public string stateName;
        [ProtoMember(4)]
        public string countyName;
        [ProtoMember(5)]
        public double monitorLat;
        [ProtoMember(6)]
        public double monitorLong;
        [ProtoMember(7)]
        public int monitorGridcell;//暂时不确定数据类型
        [ProtoMember(8)]
        public double bPMDV;
        [ProtoMember(9)]
        public double fPMDV;
        [ProtoMember(10)]
        public double bBlankMass;
        [ProtoMember(11)]
        public double bCrustalMass;
        [ProtoMember(12)]
        public double bECMass;
        [ProtoMember(13)]
        public double bNH4Mass;
        [ProtoMember(14)]
        public double bOcmbMass;
        [ProtoMember(15)]
        public double bSO4Mass;
        [ProtoMember(16)]
        public double bNO3Mass;
        [ProtoMember(17)]
        public double bWaterMass;
        [ProtoMember(18)]
        public double bSaltMass;
        [ProtoMember(19)]
        public double fBlankMass;
        [ProtoMember(20)]
        public double fCrustalMass;
        [ProtoMember(21)]
        public double fECMass;
        [ProtoMember(22)]
        public double fNH4Mass;
        [ProtoMember(23)]
        public double fOcmbMass;
        [ProtoMember(24)]
        public double fSO4Mass;
        [ProtoMember(25)]
        public double fNO3Mass;
        [ProtoMember(26)]
        public double fWaterMass;
        [ProtoMember(27)]
        public double fSaltMass;
        [ProtoMember(28)]
        public double rrfCrustal;
        [ProtoMember(29)]
        public double rrfEC;
        [ProtoMember(30)]
        public double rrfNH4;
        [ProtoMember(31)]
        public double rrfOC;
        [ProtoMember(32)]
        public double rrfSO4;
        [ProtoMember(33)]
        public double rrfNO3;
        [ProtoMember(34)]
        public double rrfWater;
        [ProtoMember(35)]
        public double rrfSalt;
    }

    //-------------------Annual PM scenario name + Quarterly PM25 Point，bPMDV为b_pm25_ann_q_DV，fPMDV为f_pm25_ann_q_DV
    [ProtoContract]
    public class QuarterlyPMPointAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public string stateName;
        [ProtoMember(4)]
        public string countyName;
        [ProtoMember(5)]
        public double monitorLat;
        [ProtoMember(6)]
        public double monitorLong;
        [ProtoMember(7)]
        public int monitorGridcell;
        [ProtoMember(8)]
        public int quarter;
        [ProtoMember(9)]
        public double bPMDV;
        [ProtoMember(10)]
        public double fPMDV;
        [ProtoMember(11)]
        public double bBlankMass;
        [ProtoMember(12)]
        public double bCrustalMass;
        [ProtoMember(13)]
        public double bECMass;
        [ProtoMember(14)]
        public double bNH4Mass;
        [ProtoMember(15)]
        public double bOcmbMass;
        [ProtoMember(16)]
        public double bSO4Mass;
        [ProtoMember(17)]
        public double bNO3Mass;
        [ProtoMember(18)]
        public double bWaterMass;
        [ProtoMember(19)]
        public double bSaltMass;
        [ProtoMember(20)]
        public double fBlankMass;
        [ProtoMember(21)]
        public double fCrustalMass;
        [ProtoMember(22)]
        public double fECMass;
        [ProtoMember(23)]
        public double fNH4Mass;
        [ProtoMember(24)]
        public double fOcmbMass;
        [ProtoMember(25)]
        public double fSO4Mass;
        [ProtoMember(26)]
        public double fNO3Mass;
        [ProtoMember(27)]
        public double fWaterMass;
        [ProtoMember(28)]
        public double fSaltMass;
        [ProtoMember(29)]
        public double rrfCrustal;
        [ProtoMember(30)]
        public double rrfEC;
        [ProtoMember(31)]
        public double rrfNH4;
        [ProtoMember(32)]
        public double rrfOC;
        [ProtoMember(33)]
        public double rrfSO4;
        [ProtoMember(34)]
        public double rrfNO3;
        [ProtoMember(35)]
        public double rrfSalt;
    }
    #region SSIA
    [ProtoContract]
    public class SSIAOzoneData
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double lat;
        [ProtoMember(3)]
        public double longitude;
        [ProtoMember(4)]
        public float baseOzone;
        [ProtoMember(5)]
        public float altOzone;
        [ProtoMember(6)]
        public float deltaOzone;
        [ProtoMember(7)]
        public double CIAvna;
        [ProtoMember(8)]
        public double CIAevna;
        [ProtoMember(9)]
        public double latitudeLamber;
        [ProtoMember(10)]
        public double longitudeLamber;
        [ProtoMember(11)]
        public Dictionary<string, float[]> lstOzone;
        [ProtoMember(12)]
        public string type;
        [ProtoMember(13)]
        public string Date;
        [ProtoMember(14)]
        public double srf;
    }
    [ProtoContract]
    public class SSIAOzoneMonitor
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public double ozone;
        [ProtoMember(6)]
        public Dictionary<string, double> dicOzone;
        [ProtoMember(7)]
        public double altozone;
        [ProtoMember(8)]
        public double deltaozone;
        [ProtoMember(9)]
        public int datacount;
        [ProtoMember(10)]
        public string county;
        [ProtoMember(11)]
        public string state;
        [ProtoMember(12)]
        public double longitudeLamber;
        [ProtoMember(13)]
        public double latitudeLamber;
        [ProtoMember(14)]
        public string gridcell;
    }
    [ProtoContract]
    public class SSIAAnnualPMDataOutput
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double lat;
        [ProtoMember(3)]
        public double longitude;
        [ProtoMember(4)]
        public Dictionary<string, ModelDataSpecies> dicBaselineModel;
        [ProtoMember(5)]
        public Dictionary<string, ModelDataSpecies> dicAlternativeModel;
        [ProtoMember(6)]
        public Dictionary<string, ModelDataSpecies> dicDeltaModel;
        [ProtoMember(7)]
        public Dictionary<string, double> dicCIAvna;
        [ProtoMember(8)]
        public Dictionary<string, double> dicCIAevna;
        [ProtoMember(9)]
        public double latitudeLamber;
        [ProtoMember(10)]
        public double longitudeLamber;
        [ProtoMember(11)]
        public double latitudeUTM;
        [ProtoMember(12)]
        public double longitudeUTM;
    }
    [ProtoContract]
    public class SSIAAnnualPMGridModelData
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double lat;
        [ProtoMember(3)]
        public double longitude;
        [ProtoMember(4)]
        public Dictionary<string, float[]> lstSpecies;
    }
    [ProtoContract]
    public class SSIAAnnualPMOfficial
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double latitude;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string stateName;
        [ProtoMember(6)]
        public string countyName;
        [ProtoMember(7)]
        public string gridcell;
        [ProtoMember(8)]
        public Dictionary<string, PMOfficialPoint> dicOfficialPM;
        [ProtoMember(9)]
        public Dictionary<string, Dictionary<string, PMOfficialPoint>> dicOfficialPMPeriod;
        [ProtoMember(10)]
        public Dictionary<string, float> dicAvgOfficialPM;
        [ProtoMember(11)]
        public Dictionary<string, float> dicAltPM;
        [ProtoMember(12)]
        public Dictionary<string, float> dicDeltaPM;
        [ProtoMember(13)]
        public double latitudeLamber;
        [ProtoMember(14)]
        public double longitudeLamber;
        [ProtoMember(15)]
        public Dictionary<string, float> dicBasePMsec;
        [ProtoMember(16)]
        public Dictionary<string, float> dicAltPMsec;
        [ProtoMember(17)]
        public Dictionary<string, float> dicDeltaPMsec;
        [ProtoMember(18)]
        public double latitudeUTM;
        [ProtoMember(19)]
        public double longitudeUTM;
    }
    [ProtoContract]
    public class SSIADepositionData
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double lat;
        [ProtoMember(3)]
        public double longitude;
        [ProtoMember(4)]
        public float baseTSDep;
        [ProtoMember(5)]
        public float altTSDep;
        [ProtoMember(6)]
        public float deltaTSDep;
        [ProtoMember(7)]
        public float baseTNDep;
        [ProtoMember(8)]
        public float altTNDep;
        [ProtoMember(9)]
        public float deltaTNDep;
        [ProtoMember(10)]
        public double latitudeLamber;
        [ProtoMember(11)]
        public double longitudeLamber;
        [ProtoMember(12)]
        public Dictionary<string, float[]> lstDeposition;
        [ProtoMember(13)]
        public string type;
        [ProtoMember(14)]
        public string Date;
    }

    #endregion

    #region China
    [ProtoContract]
    public class PMMonitorChina
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double latitude;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string locationName;
        [ProtoMember(6)]
        public string stationName;
        [ProtoMember(7)]
        public string gridcell;
        [ProtoMember(8)]
        public Dictionary<string, Dictionary<string, float>> dicMonitorPM;
        [ProtoMember(9)]
        //public Dictionary<string, Dictionary<string, Dictionary<string, float>>> dicUnofficialPMDaily;//------unofficial pm25--daily
        //[ProtoMember(10)]
        public Dictionary<string, float> dicMonitorPMAvg;
        //public Dictionary<string, float> dicUnofficialPM;
        [ProtoMember(11)]
        public Dictionary<string, Dictionary<string, SpeciesMonitorChina>> dicSpecies;
        //[ProtoMember(12)]
        public Dictionary<string, SpeciesMonitorChina> dicSpeciesAvg;
        [ProtoMember(13)]
        public Dictionary<string, SpecFracPMChina> dicSpeciesFraction;
        [ProtoMember(14)]
        //public Dictionary<string, Dictionary<string, float>> dicNeighborFile;
        //[ProtoMember(15)]
        public Dictionary<string, PMPointChina> dicQuarterlyPoint;
        [ProtoMember(16)]
        public Dictionary<string, PMSpatialChina> dicQuarterlySpatial;
        [ProtoMember(17)]
        public Dictionary<string, PMSpatialChina> dicQuarterlySpatialGradientAdjusted;
        //[ProtoMember(18)]
        //public Dictionary<string, Dictionary<string, float>> dicNeighborFileSpatial;
        [ProtoMember(18)]
        public Dictionary<string, SpecFracPMChina> dicSpecFracSpatial;
        [ProtoMember(19)]
        public Dictionary<string, SpecFracPMChina> dicSpecFracSpatialGradAdj;
        [ProtoMember(20)]
        public Dictionary<string, double[]> dicpmSpatial;
        //public Dictionary<string, Dictionary<string, PMOfficialPoint>> dicOfficialPMPeriod;
        //[ProtoMember(21)]
        public double latitudeLamber;
        [ProtoMember(22)]
        public double longitudeLamber;
        [ProtoMember(23)]
        public Dictionary<string, SpecFracPMChina> dicSpecFracSpatial_NS;
        [ProtoMember(24)]
        public Dictionary<string, PMSpatialChina> dicQuarterlySpatial_NS;
        [ProtoMember(25)]
        public Dictionary<string, SpecFracPMChina> dicSpecFracSpatial_wVNA;
        [ProtoMember(26)]
        public Dictionary<string, PMSpatialChina> dicQuarterlySpatial_wVNA;
    }

    [ProtoContract]
    public class PMSpatialChina
    {
        [ProtoMember(1)]
        public float bPMAnnDV;
        [ProtoMember(2)]
        public float fPMAnnDV;
        [ProtoMember(3)]
        public float bBlankMass;
        [ProtoMember(4)]
        public float bCrustalMass;
        [ProtoMember(5)]
        public float bECMass;
        [ProtoMember(6)]
        public float bNH4Mass;
        [ProtoMember(7)]
        public float bOCMass;
        [ProtoMember(8)]
        public float bSO4Mass;
        [ProtoMember(9)]
        public float bNO3Mass;
        [ProtoMember(10)]
        public float bWaterMass;
        [ProtoMember(11)]
        public float bOtherMass;
        [ProtoMember(12)]
        public float fBlankMass;
        [ProtoMember(13)]
        public float fCrustalMass;
        [ProtoMember(14)]
        public float fECMass;
        [ProtoMember(15)]
        public float fNH4Mass;
        [ProtoMember(16)]
        public float fOCMass;
        [ProtoMember(17)]
        public float fSO4Mass;
        [ProtoMember(18)]
        public float fNO3Mass;
        [ProtoMember(19)]
        public float fWaterMass;
        [ProtoMember(20)]
        public float fOtherMass;
        [ProtoMember(21)]
        public double rrfCrustal;
        [ProtoMember(22)]
        public double rrfEC;
        [ProtoMember(23)]
        public double rrfNH4;
        [ProtoMember(24)]
        public double rrfOC;
        [ProtoMember(26)]
        public double rrfSO4;
        [ProtoMember(27)]
        public double rrfNO3;
        [ProtoMember(28)]
        public double rrfWaterMass;
        [ProtoMember(29)]
        public double rrfOther;
        //[ProtoMember(30)]
        //public double bDON;
        //[ProtoMember(31)]
        //public double bNO3rMass;
    }

    [ProtoContract]
    public class SpeciesMonitorChina
    {
        //[ProtoMember(1)]
        //public string id;
        //[ProtoMember(2)]
        //public string type;
        //[ProtoMember(3)]
        //public double monitorLat;
        //[ProtoMember(4)]
        //public double monitorLong;
        //[ProtoMember(5)]
        //public int monitorGridcell;
        //[ProtoMember(6)]
        //public int quarter;
        [ProtoMember(7)]
        public float bSO4;
        [ProtoMember(8)]
        public float bNO3;
        [ProtoMember(9)]
        public float bNH4;
        [ProtoMember(10)]
        public float bOC;
        [ProtoMember(11)]
        public float bEC;
        [ProtoMember(12)]
        public float bCrustal;
        [ProtoMember(13)]
        public float bH2O;
        [ProtoMember(14)]
        public float bOther;
    }

    [ProtoContract]
    public class SpecFracPMChina
    {
        [ProtoMember(1)]
        public double pm25Frac;
        [ProtoMember(2)]
        public double fCrustal;
        [ProtoMember(3)]
        public double fEC;
        [ProtoMember(4)]
        public double fNH4;
        [ProtoMember(5)]
        public double fOC;
        [ProtoMember(6)]
        public double fSO4;
        [ProtoMember(7)]
        public double fNO3;
        [ProtoMember(8)]
        public double fWater;
        [ProtoMember(9)]
        public double fOther;
        [ProtoMember(10)]
        public double blankMass;
        [ProtoMember(11)]
        //public double don;
        //[ProtoMember(12)]
        public double iSO4;
        [ProtoMember(13)]
        public double iNO3;
        [ProtoMember(14)]
        public double iOC;
        [ProtoMember(15)]
        public double iEC;
        [ProtoMember(16)]
        public double iCrustal;
        //[ProtoMember(17)]
        //public double iDON;
        [ProtoMember(18)]
        public double iNH4;
        [ProtoMember(19)]
        public double iWater;
        [ProtoMember(20)]
        public double iOther;
        //[ProtoMember(21)]
        //public double fNO3r;
    }

    [ProtoContract]
    public class PMPointChina
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public string locationName;
        [ProtoMember(4)]
        public string stationName;
        [ProtoMember(5)]
        public double monitorLat;
        [ProtoMember(6)]
        public double monitorLong;
        [ProtoMember(7)]
        public string monitorGridcell;
        [ProtoMember(8)]
        public int quarter;
        [ProtoMember(9)]
        public double bPMDV;
        [ProtoMember(10)]
        public double fPMDV;
        [ProtoMember(11)]
        //public double bBlankMass;
        //[ProtoMember(12)]
        public double bCrustal;
        [ProtoMember(13)]
        public double bEC;
        [ProtoMember(14)]
        public double bNH4;
        [ProtoMember(15)]
        public double bOC;
        [ProtoMember(16)]
        public double bSO4;
        [ProtoMember(17)]
        public double bNO3;
        [ProtoMember(18)]
        public double bWater;
        [ProtoMember(19)]
        public double bOther;
        [ProtoMember(20)]
        //public double fBlankMass;
        //[ProtoMember(21)]
        public double fCrustal;
        [ProtoMember(22)]
        public double fEC;
        [ProtoMember(23)]
        public double fNH4;
        [ProtoMember(24)]
        public double fOC;
        [ProtoMember(25)]
        public double fSO4;
        [ProtoMember(26)]
        public double fNO3;
        [ProtoMember(27)]
        public double fWater;
        [ProtoMember(28)]
        public double fOther;
        [ProtoMember(29)]
        public double rrfCrustal;
        [ProtoMember(30)]
        public double rrfEC;
        [ProtoMember(31)]
        public double rrfNH4;
        [ProtoMember(32)]
        public double rrfOC;
        [ProtoMember(33)]
        public double rrfSO4;
        [ProtoMember(34)]
        public double rrfNO3;
        [ProtoMember(35)]
        public double rrfWater;
        [ProtoMember(36)]
        public double rrfOther;
        //[ProtoMember(37)]
        //public double rrfPM;
    }
    #endregion

    //---------------Annual PM -----------scenario name+ (Used) Baseline/Future Quarterly Avg Model Data (Point)
    //---------------Daily PM -----------(Used) Baseline/Future Quarterly Peak Model Data
    [ProtoContract]
    public class PMModelDataAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double crustal;
        [ProtoMember(7)]
        public double nh4;
        [ProtoMember(8)]
        public double so4;
        [ProtoMember(9)]
        public double ec;
        [ProtoMember(10)]
        public double no3;
        [ProtoMember(11)]
        public double oc;
        [ProtoMember(12)]
        public double pm25;
        [ProtoMember(13)]
        public double cm;
    }

    [ProtoContract]
    public class PmModelDataOutput
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public Dictionary<string, ModelDataSpecies> dicBaselineModel;
        //public Dictionary<string, Dictionary<string, ModelDataSpecies>> dicBaselineModelDailyFloat;
        //public Dictionary<string, Dictionary<string, PMModelDataAttribute>> dicBaselineModelDaily;
        [ProtoMember(6)]
        public Dictionary<string, ModelDataSpecies> dicFutureModel;
        //public Dictionary<string, Dictionary<string, ModelDataSpecies>> dicFutureModelDailyFloat;
        //public Dictionary<string, Dictionary<string, PMModelDataAttribute>> dicFutureModelDaily;    
        [ProtoMember(7)]
        public double longitudeLamber;
        [ProtoMember(8)]
        public double latitudeLamber;
    }

    [ProtoContract]
    public class ModelDataSpecies
    {
        [ProtoMember(1)]
        public float crustal;
        [ProtoMember(2)]
        public float nh4;
        [ProtoMember(3)]
        public float so4;
        [ProtoMember(4)]
        public float ec;
        [ProtoMember(5)]
        public float no3;
        [ProtoMember(6)]
        public float oc;
        [ProtoMember(7)]
        public float pm25;
        [ProtoMember(8)]
        public float cm;
        [ProtoMember(9)]
        public float salt;
        [ProtoMember(10)]
        public float pm25sec;
        [ProtoMember(11)]
        public float pm25prim;
    }

    [ProtoContract]
    public class PMMonitorOutput
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double latitude;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string stateName;
        [ProtoMember(6)]
        public string countyName;
        [ProtoMember(7)]
        public string gridcell;
        [ProtoMember(8)]
        public Dictionary<string, PMOfficialPoint> dicOfficialPM;
        [ProtoMember(9)]
        public Dictionary<string, Dictionary<string, Dictionary<string, float>>> dicUnofficialPMDaily;//------unofficial pm25--daily
        [ProtoMember(10)]
        public Dictionary<string, float> dicUnofficialPM;
        [ProtoMember(11)]
        public Dictionary<string, Dictionary<string, Dictionary<string, SpeciesMonitors>>> dicSpeciesDaily;
        [ProtoMember(12)]
        public Dictionary<string, SpeciesMonitors> dicSpecies;
        [ProtoMember(13)]
        public Dictionary<string, SpecFracPM> dicSpeciesFraction;
        [ProtoMember(14)]
        public Dictionary<string, Dictionary<string, float>> dicNeighborFile;
        [ProtoMember(15)]
        public Dictionary<string, PMPoint> dicQuarterlyPoint;
        [ProtoMember(16)]
        public Dictionary<string, PMSpatial> dicQuarterlySpatial;
        [ProtoMember(17)]
        public Dictionary<string, PMSpatial> dicQuarterlySpatialGradientAdjusted;
        //[ProtoMember(18)]
        //public Dictionary<string, Dictionary<string, float>> dicNeighborFileSpatial;
        [ProtoMember(18)]
        public Dictionary<string, SpecFracPM> dicSpecFracSpatial;
        [ProtoMember(19)]
        public Dictionary<string, SpecFracPM> dicSpecFracSpatialGradAdj;
        [ProtoMember(20)]
        public Dictionary<string, Dictionary<string, PMOfficialPoint>> dicOfficialPMPeriod;
        [ProtoMember(21)]
        public double latitudeLamber;
        [ProtoMember(22)]
        public double longitudeLamber;
        [ProtoMember(23)]
        public Dictionary<string, SpecFracPM> dicSpecFracSpatialDS;
        [ProtoMember(24)]
        public Dictionary<string, PMSpatial> dicQuarterlySpatialDS;
    }

    [ProtoContract]
    public class NeighborFileClass
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double monitorLat;
        [ProtoMember(3)]
        public double monitorLong;
        [ProtoMember(4)]
        public string stateName;
        [ProtoMember(5)]
        public string countyName;
        [ProtoMember(6)]
        public int quarter;
        [ProtoMember(7)]
        public Dictionary<string, NeighborInfo> dicNeighbors;
        [ProtoMember(8)]
        public string neighbor;
        [ProtoMember(9)]
        public string neighbor_gridcell;
        [ProtoMember(10)]
        public double distance;
        [ProtoMember(11)]
        public double weightDistance;
        [ProtoMember(12)]
        public double weightDistanceSquared;
        [ProtoMember(13)]
        public string pollutant;
        [ProtoMember(14)]
        public string monitor_gridcell;
        [ProtoMember(15)]
        public Dictionary<string, Dictionary<string, NeighborInfo>> dicNeighborsPoint;
        [ProtoMember(16)]
        public Dictionary<string, Dictionary<string, Dictionary<string, NeighborInfo>>> dicNeighborSpatialField;
    }


    [ProtoContract]
    public class NeighborInfo
    {
        [ProtoMember(1)]
        public string neighbor;
        [ProtoMember(2)]
        public double neighbor_lat;
        [ProtoMember(3)]
        public double neighbor_long;
        [ProtoMember(4)]
        public string neighbor_gridcell;
        [ProtoMember(5)]
        public double distance;
        [ProtoMember(6)]
        public double weightDistance;
        [ProtoMember(7)]
        public double weightDistanceSquared;
        [ProtoMember(8)]
        public Dictionary<string, NeighborPollutantInfo> dicPollutant;
        [ProtoMember(9)]
        public string pollutant;
        [ProtoMember(10)]
        public List<string> lstPollutant;
    }

    [ProtoContract]
    public class NeighborPollutantInfo
    {
        [ProtoMember(1)]
        public bool crustal;
        [ProtoMember(2)]
        public bool nh4;
        [ProtoMember(3)]
        public bool so4;
        [ProtoMember(4)]
        public bool ec;
        [ProtoMember(5)]
        public bool no3;
        [ProtoMember(6)]
        public bool no3r;
        [ProtoMember(7)]
        public bool oc;
        [ProtoMember(8)]
        public bool pm25;
        [ProtoMember(9)]
        public bool salt;
        [ProtoMember(10)]
        public bool don;
    }

    [ProtoContract]
    public class PMPoint
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public string stateName;
        [ProtoMember(4)]
        public string countyName;
        [ProtoMember(5)]
        public double monitorLat;
        [ProtoMember(6)]
        public double monitorLong;
        [ProtoMember(7)]
        public string monitorGridcell;
        [ProtoMember(8)]
        public int quarter;
        [ProtoMember(9)]
        public double bPMDV;
        [ProtoMember(10)]
        public double fPMDV;
        [ProtoMember(11)]
        public double bBlankMass;
        [ProtoMember(12)]
        public double bCrustalMass;
        [ProtoMember(13)]
        public double bECMass;
        [ProtoMember(14)]
        public double bNH4Mass;
        [ProtoMember(15)]
        public double bOcmbMass;
        [ProtoMember(16)]
        public double bSO4Mass;
        [ProtoMember(17)]
        public double bNO3Mass;
        [ProtoMember(18)]
        public double bWaterMass;
        [ProtoMember(19)]
        public double bSaltMass;
        [ProtoMember(20)]
        public double fBlankMass;
        [ProtoMember(21)]
        public double fCrustalMass;
        [ProtoMember(22)]
        public double fECMass;
        [ProtoMember(23)]
        public double fNH4Mass;
        [ProtoMember(24)]
        public double fOcmbMass;
        [ProtoMember(25)]
        public double fSO4Mass;
        [ProtoMember(26)]
        public double fNO3Mass;
        [ProtoMember(27)]
        public double fWaterMass;
        [ProtoMember(28)]
        public double fSaltMass;
        [ProtoMember(29)]
        public double rrfCrustal;
        [ProtoMember(30)]
        public double rrfEC;
        [ProtoMember(31)]
        public double rrfNH4;
        [ProtoMember(32)]
        public double rrfOC;
        [ProtoMember(33)]
        public double rrfSO4;
        [ProtoMember(34)]
        public double rrfNO3;
        [ProtoMember(35)]
        public double rrfSalt;
        [ProtoMember(36)]
        public double bDON;
        [ProtoMember(37)]
        public double rrfWater;
        [ProtoMember(38)]
        public double maxDelta;
    }

    [ProtoContract]
    public class PMSpatial
    {
        [ProtoMember(1)]
        public float bPMAnnDV;
        [ProtoMember(2)]
        public float fPMAnnDV;
        [ProtoMember(3)]
        public float bBlankMass;
        [ProtoMember(4)]
        public float bCrustalMass;
        [ProtoMember(5)]
        public float bECMass;
        [ProtoMember(6)]
        public float bNH4Mass;
        [ProtoMember(7)]
        public float bOcmbMass;
        [ProtoMember(8)]
        public float bSO4Mass;
        [ProtoMember(9)]
        public float bNO3Mass;
        [ProtoMember(10)]
        public float bWaterMass;
        [ProtoMember(11)]
        public float bSaltMass;
        [ProtoMember(12)]
        public float fBlankMass;
        [ProtoMember(13)]
        public float fCrustalMass;
        [ProtoMember(14)]
        public float fECMass;
        [ProtoMember(15)]
        public float fNH4Mass;
        [ProtoMember(16)]
        public float fOcmbMass;
        [ProtoMember(17)]
        public float fSO4Mass;
        [ProtoMember(18)]
        public float fNO3Mass;
        [ProtoMember(19)]
        public float fWaterMass;
        [ProtoMember(20)]
        public float fSaltMass;
        [ProtoMember(21)]
        public double rrfCrustal;
        [ProtoMember(22)]
        public double rrfEC;
        [ProtoMember(23)]
        public double rrfNH4;
        [ProtoMember(24)]
        public double rrfOC;
        [ProtoMember(26)]
        public double rrfSO4;
        [ProtoMember(27)]
        public double rrfNO3;
        [ProtoMember(28)]
        public double rrfWaterMass;
        [ProtoMember(29)]
        public double rrfSalt;
        [ProtoMember(30)]
        public double bDON;
        [ProtoMember(31)]
        public double bNO3rMass;
    }

    //[ProtoContract]
    //public class NeighborFile
    //{
    //    [ProtoMember(1)]
    //    public string neighbor;
    //    [ProtoMember(2)]
    //    public string neighborGridcell;
    //    [ProtoMember(3)]
    //    public double distance;
    //    [ProtoMember(4)]
    //    public double weightDistance;
    //    [ProtoMember(5)]
    //    public double weightDistanceSquared;
    //    [ProtoMember(6)]
    //    public string pollutant;
    //}

    [ProtoContract]
    public class SpecFracPM
    {
        [ProtoMember(1)]
        public double pm25MassFrac;
        [ProtoMember(2)]
        public double fCr;
        [ProtoMember(3)]
        public double fEC;
        [ProtoMember(4)]
        public double fNH4;
        [ProtoMember(5)]
        public double fOcm;
        [ProtoMember(6)]
        public double fSO4;
        [ProtoMember(7)]
        public double fNO3;
        [ProtoMember(8)]
        public double fWater;
        [ProtoMember(9)]
        public double fSalt;
        [ProtoMember(10)]
        public double blankMass;
        [ProtoMember(11)]
        public double don;
        [ProtoMember(12)]
        public double iSO4;
        [ProtoMember(13)]
        public double iNO3r;
        [ProtoMember(14)]
        public double iOcb;
        [ProtoMember(15)]
        public double iEC;
        [ProtoMember(16)]
        public double iCrustal;
        [ProtoMember(17)]
        public double iDON;
        [ProtoMember(18)]
        public double iNH4;
        [ProtoMember(19)]
        public double iNO3;
        [ProtoMember(20)]
        public double iSalt;
        [ProtoMember(21)]
        public double fNO3r;
    }

    [ProtoContract]
    public class SpeciesMonitors
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double monitorLat;
        [ProtoMember(4)]
        public double monitorLong;
        [ProtoMember(5)]
        public int monitorGridcell;
        [ProtoMember(6)]
        public int quarter;
        [ProtoMember(7)]
        public float bCrustalMass;
        [ProtoMember(8)]
        public float bECMass;
        [ProtoMember(9)]
        public float bOCBMass;
        [ProtoMember(10)]
        public float bSO4Mass;
        [ProtoMember(11)]
        public float bNO3Mass;
        [ProtoMember(12)]
        public float bNO3rMass;
        [ProtoMember(13)]
        public float bSaltMass;
        [ProtoMember(14)]
        public float bNH4Mass;
        [ProtoMember(15)]
        public float bDON;
    }

    [ProtoContract]
    public class PMOfficialPoint
    {
        [ProtoMember(1)]
        public string date;
        [ProtoMember(2)]
        public float pm;
        [ProtoMember(3)]
        public int nDays;
        [ProtoMember(4)]
        public string subCode;
        [ProtoMember(5)]
        public int comCode;
        [ProtoMember(6)]
        public int bad_dv;
    }

    [ProtoContract]
    public class PMOfficial
    {
        [ProtoMember(1)]
        public string date;
        [ProtoMember(2)]
        public double pm;
        [ProtoMember(3)]
        public int nDays;
        [ProtoMember(4)]
        public string subCode;
        [ProtoMember(5)]
        public int comCode;
        [ProtoMember(6)]
        public double q1;
        [ProtoMember(7)]
        public double q2;
        [ProtoMember(8)]
        public double q3;
        [ProtoMember(9)]
        public int comCode1;
        [ProtoMember(10)]
        public int comCode2;
        [ProtoMember(11)]
        public int comCode3;
        [ProtoMember(12)]
        public int bad_dv1;
        [ProtoMember(13)]
        public int bad_dv2;
        [ProtoMember(14)]
        public int bad_dv3;
    }

    #region class
    [ProtoContract]
    public class DailyModelMonitor
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string stateName;
        [ProtoMember(6)]
        public string countyName;
        [ProtoMember(7)]
        public string monitorGridcell;
        //[ProtoMember(8)]
        //public string baseYear;
        //[ProtoMember(14)]
        //public string futureYear;
        [ProtoMember(8)]
        public Dictionary<string, ModelDataSpecies> dicBaseSpecies;
        [ProtoMember(9)]
        public Dictionary<string, ModelDataSpecies> dicFutureSpecies;
        [ProtoMember(10)]
        public Dictionary<string, Dictionary<string, ModelDataSpecies>> dicBaseDailySpecies;
        [ProtoMember(11)]
        public Dictionary<string, Dictionary<string, ModelDataSpecies>> dicFutureDailySpecies;
        [ProtoMember(12)]
        public double longitudeLamber;
        [ProtoMember(13)]
        public double latitudeLamber;
        [ProtoMember(14)]
        public double longitudeUTM;
        [ProtoMember(15)]
        public double latitudeUTM;
        [ProtoMember(16)]
        public Dictionary<string, double> dicCIAvna;
        [ProtoMember(17)]
        public Dictionary<string, double> dicCIAevna;
        [ProtoMember(18)]
        public Dictionary<string, ModelDataSpecies> dicMaxDeltaSpecies;
    }

    [ProtoContract]
    public class PM25Monitors
    {
        [ProtoMember(1)]
        public string year;
        [ProtoMember(2)]
        public double bPM25;
        [ProtoMember(3)]
        public double fPM25;
        [ProtoMember(4)]
        public int epaFlag;
        [ProtoMember(5)]
        public int userFlag;
        [ProtoMember(6)]
        public int completionCode;
        [ProtoMember(7)]
        public int rank98;
        [ProtoMember(8)]
        public int percentile_98;
        [ProtoMember(9)]
        public float bBlankmass;
        [ProtoMember(10)]
        public float bCrustal;
        [ProtoMember(11)]
        public float bEC;
        [ProtoMember(12)]
        public float bNH4;
        [ProtoMember(13)]
        public float bOCMmb;
        [ProtoMember(14)]
        public float bSO4;
        [ProtoMember(15)]
        public float bNO3;
        [ProtoMember(16)]
        public float bNO3r;
        [ProtoMember(17)]
        public double bWater;
        [ProtoMember(18)]
        public float bSalt;
        [ProtoMember(19)]
        public float bDON;
        [ProtoMember(20)]
        public double fBlankmass;
        [ProtoMember(21)]
        public double fCrustal;
        [ProtoMember(22)]
        public double fEC;
        [ProtoMember(23)]
        public double fNH4;
        [ProtoMember(24)]
        public double fOCMmb;
        [ProtoMember(25)]
        public double fSO4;
        [ProtoMember(26)]
        public double fNO3r;
        [ProtoMember(27)]
        public double fWater;
        [ProtoMember(28)]
        public double fSalt;
        [ProtoMember(29)]
        public double rrfCrustal;
        [ProtoMember(30)]
        public double rrfEC;
        [ProtoMember(31)]
        public double rrfNH4;
        [ProtoMember(32)]
        public double rrfOC;
        [ProtoMember(33)]
        public double rrfSO4;
        [ProtoMember(34)]
        public double rrfNO3;
        [ProtoMember(35)]
        public double rrfWater;
        [ProtoMember(36)]
        public double rrfSalt;
    }

    [ProtoContract]
    public class Monitors
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double lat;
        [ProtoMember(3)]
        public double longitude;
        [ProtoMember(4)]
        public string type;
        [ProtoMember(5)]
        public string monitorGridcell;
        [ProtoMember(6)]
        public string stateName;
        [ProtoMember(7)]
        public string countyName;
        [ProtoMember(8)]
        public string date;
        [ProtoMember(9)]
        public int rank98;
        [ProtoMember(10)]
        public int percentile_98;
        [ProtoMember(11)]
        public Dictionary<string, SpeciesForFractions> dicSpeciesMonitors;
        [ProtoMember(12)]
        public Dictionary<string, Dictionary<string, Dictionary<string, SpeciesForFractions>>> dicSpeciesDailyQuarterYear;
        [ProtoMember(13)]
        public Dictionary<string, Dictionary<string, PM25Monitors>> dicPMDaily;
        [ProtoMember(14)]
        public Dictionary<string, PM25Monitors> dicDailyPointValues;
        [ProtoMember(15)]
        public Dictionary<string, Dictionary<string, Dictionary<string, PM25Monitors>>> dicOfficialPM25Daily;
        [ProtoMember(16)]
        public Dictionary<string, Dictionary<string, PM25Monitors>> dicQuarterlyPM;
        [ProtoMember(17)]
        public Dictionary<string, Dictionary<string, Dictionary<string, PM25Monitors>>> dicUnofficialPM25Daily;
        [ProtoMember(18)]
        public Dictionary<string, PM25Monitors> dicPM;
        [ProtoMember(19)]
        public Dictionary<string, SpecFracPM> dicSpeciesFractions;
        [ProtoMember(20)]
        public Dictionary<string, Dictionary<string, NeighborInfoDaily>> dicNeighborInfo;
        [ProtoMember(21)]
        public Dictionary<string, AllYearHighDays> dicHighDays;
        [ProtoMember(22)]
        public double longitudeLamber;
        [ProtoMember(23)]
        public double latitudeLamber;
        [ProtoMember(24)]
        public double longitudeUTM;
        [ProtoMember(25)]
        public double latitudeUTM;
    }

    [ProtoContract]
    public class AllYearHighDays
    {
        [ProtoMember(1)]
        public int rank98;
        [ProtoMember(2)]
        public string year;
        [ProtoMember(3)]
        public string date_b;
        [ProtoMember(4)]
        public int highQuarter_b;
        [ProtoMember(5)]
        public double bPMdqCONC;
        [ProtoMember(6)]
        public string date_f;
        [ProtoMember(7)]
        public int highQuarter_f;
        [ProtoMember(8)]
        public double fPMdqCONC;
        [ProtoMember(9)]
        public double bBlankMassq;
        [ProtoMember(10)]
        public double bCrustalMassq;
        [ProtoMember(11)]
        public double bECMassq;
        [ProtoMember(12)]
        public double bNH4Massq;
        [ProtoMember(13)]
        public double bOcmbMassq;
        [ProtoMember(14)]
        public double bSO4Massq;
        [ProtoMember(15)]
        public double bNO3Massq;
        [ProtoMember(16)]
        public double bWaterMassq;
        [ProtoMember(17)]
        public double bSaltMassq;
        [ProtoMember(18)]
        public double fBlankMassq;
        [ProtoMember(19)]
        public double fCrustalMassq;
        [ProtoMember(20)]
        public double fECMassq;
        [ProtoMember(21)]
        public double fNH4Massq;
        [ProtoMember(22)]
        public double fOcmbMassq;
        [ProtoMember(23)]
        public double fSO4Massq;
        [ProtoMember(24)]
        public double fNO3Massq;
        [ProtoMember(25)]
        public double fWaterMassq;
        [ProtoMember(26)]
        public double fSaltMassq;
        [ProtoMember(27)]
        public double rrfCrustalq;
        [ProtoMember(28)]
        public double rrfECq;
        [ProtoMember(29)]
        public double rrfNH4q;
        [ProtoMember(30)]
        public double rrfOCq;
        [ProtoMember(31)]
        public double rrfSO4q;
        [ProtoMember(32)]
        public double rrfNO3q;
        [ProtoMember(33)]
        public double rrfWaterq;
        [ProtoMember(34)]
        public double rrfSaltq;
    }

    [ProtoContract]
    public class SpeciesForFractions
    {
        [ProtoMember(1)]
        public string year;
        [ProtoMember(2)]
        //public string quarter;
        //[ProtoMember(3)]
        public float so4;
        [ProtoMember(3)]
        public float no3r;
        [ProtoMember(4)]
        public float nh4;
        [ProtoMember(5)]
        public float ocb;
        [ProtoMember(6)]
        public float ec;
        [ProtoMember(7)]
        public float crustal;
        [ProtoMember(8)]
        public float salt;
        [ProtoMember(9)]
        public float don;
        //[ProtoMember(11)]
        //public float h2o_aim;
        [ProtoMember(10)]
        public float oc;
        [ProtoMember(11)]
        public float no3;
        //[ProtoMember(14)]
        //public float so4_3s;
        //[ProtoMember(15)]
        //public float crustal_alt;
        //[ProtoMember(16)]
        //public float frm_mass;
        [ProtoMember(12)]
        public float measured_fm;
        //[ProtoMember(18)]
        //public float rcfm;
        //[ProtoMember(19)]
        //public float al;
        //[ProtoMember(20)]
        //public float ca;
        //[ProtoMember(21)]
        //public float fe;
        //[ProtoMember(22)]
        //public float ti;
        //[ProtoMember(23)]
        //public float si;
        [ProtoMember(13)]
        public float epa_flag;
        [ProtoMember(14)]
        public float user_flag;
    }

    [ProtoContract]
    public class NeighborInfoDaily
    {
        //[ProtoMember(1)]
        ////public string neighbor;
        //[ProtoMember(2)]
        ////public string neighborGridcell;
        [ProtoMember(1)]
        public double distance;
        [ProtoMember(2)]
        public List<string> lstPollutants;
    }
    #endregion

    //---------------------Annual PM--------- scenario name + Quarterly Avg Spec Frac Point
    //---------------------Daily PM ---------Quarterly Peak Spec Frac Point
    [ProtoContract]
    public class SpecFracPointAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string stateName;
        [ProtoMember(3)]
        public string countyName;
        [ProtoMember(4)]
        public double monitorLat;
        [ProtoMember(5)]
        public double monitorLong;
        [ProtoMember(6)]
        public int quarter;
        [ProtoMember(7)]
        public double pm25MassFrac;
        [ProtoMember(8)]
        public double fCr;
        [ProtoMember(9)]
        public double fEC;
        [ProtoMember(10)]
        public double fNH4;
        [ProtoMember(11)]
        public double fOcm;
        [ProtoMember(12)]
        public double fSO4;
        [ProtoMember(13)]
        public double fNO3;
        [ProtoMember(14)]
        public double fWater;
        [ProtoMember(15)]
        public double fSalt;
        [ProtoMember(16)]
        public double blankMass;
        [ProtoMember(17)]
        public double don;
        [ProtoMember(18)]
        public double iSO4;
        [ProtoMember(19)]
        public double iNO3r;
        [ProtoMember(20)]
        public double iOcb;
        [ProtoMember(21)]
        public double iEC;
        [ProtoMember(22)]
        public double iCrustal;
        [ProtoMember(23)]
        public double iDON;
        [ProtoMember(24)]
        public double iNH4;
        [ProtoMember(25)]
        public double iNO3;
        [ProtoMember(26)]
        public double iSalt;
    }

    //---------------Annual PM scenario name + Annual PM25 Spatial Field
    //---------------Annual PM scenario name + Grad Adj Annual PM25 Spatial Field
    [ProtoContract]
    public class PMSpatialAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double gridcellLat;
        [ProtoMember(3)]
        public double gridcellLong;
        [ProtoMember(4)]
        public double bPMAnnDV;
        [ProtoMember(5)]
        public double fPMAnnDV;
        [ProtoMember(6)]
        public double bBlankMass;
        [ProtoMember(7)]
        public double bCrustalMass;
        [ProtoMember(8)]
        public double bECMass;
        [ProtoMember(9)]
        public double bNH4Mass;
        [ProtoMember(10)]
        public double bOcmbMass;
        [ProtoMember(11)]
        public double bSO4Mass;
        [ProtoMember(12)]
        public double bNO3Mass;
        [ProtoMember(13)]
        public double bWaterMass;
        [ProtoMember(14)]
        public double bSaltMass;
        [ProtoMember(15)]
        public double fBlankMass;
        [ProtoMember(16)]
        public double fCrustalMass;
        [ProtoMember(17)]
        public double fECMass;
        [ProtoMember(18)]
        public double fNH4Mass;
        [ProtoMember(19)]
        public double fOcmbMass;
        [ProtoMember(20)]
        public double fSO4Mass;
        [ProtoMember(21)]
        public double fNO3Mass;
        [ProtoMember(22)]
        public double fWaterMass;
        [ProtoMember(23)]
        public double fSaltMass;
        [ProtoMember(24)]
        public double rrfCrustal;
        [ProtoMember(25)]
        public double rrfEC;
        [ProtoMember(26)]
        public double rrfNH4;
        [ProtoMember(27)]
        public double rrfOC;
        [ProtoMember(28)]
        public double rrfSO4;
        [ProtoMember(29)]
        public double rrfNO3;
        [ProtoMember(30)]
        public double rrfWaterMass;
        [ProtoMember(31)]
        public double rrfSalt;
    }

    //---------------Annual PM scenario name + Quarterly PM25 Spatial Field
    //---------------Annual PM scenario name + Grad Adj Quarterly PM25 Spatial Field
    [ProtoContract]
    public class QuarterlyPMSpatialAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double gridcellLat;
        [ProtoMember(3)]
        public double gridcellLong;
        [ProtoMember(4)]
        public int quarter;
        [ProtoMember(5)]
        public double bPMAnnDVq;
        [ProtoMember(6)]
        public double fPMAnnDVq;
        [ProtoMember(7)]
        public double bBlankMassq;
        [ProtoMember(8)]
        public double bCrustalMassq;
        [ProtoMember(9)]
        public double bECMassq;
        [ProtoMember(10)]
        public double bNH4Massq;
        [ProtoMember(11)]
        public double bOcmbMassq;
        [ProtoMember(12)]
        public double bSO4Massq;
        [ProtoMember(13)]
        public double bNO3Massq;
        [ProtoMember(14)]
        public double bWaterMassq;
        [ProtoMember(15)]
        public double bSaltMassq;
        [ProtoMember(16)]
        public double fBlankMassq;
        [ProtoMember(17)]
        public double fCrustalMassq;
        [ProtoMember(18)]
        public double fECMassq;
        [ProtoMember(19)]
        public double fNH4Massq;
        [ProtoMember(20)]
        public double fOcmbMassq;
        [ProtoMember(21)]
        public double fSO4Massq;
        [ProtoMember(22)]
        public double fNO3Massq;
        [ProtoMember(23)]
        public double fWaterMassq;
        [ProtoMember(24)]
        public double fSaltMassq;
        [ProtoMember(125)]
        public double rrfCrustalq;
        [ProtoMember(26)]
        public double rrfECq;
        [ProtoMember(27)]
        public double rrfNH4q;
        [ProtoMember(28)]
        public double rrfOCq;
        [ProtoMember(29)]
        public double rrfSO4q;
        [ProtoMember(30)]
        public double rrfNO3q;
        [ProtoMember(31)]
        public double rrfSaltq;
    }

    //-----------------Annual PM ---------Quarterly Avg Spec Frac Spatial Field
    //------------Annual PM -------Grad Adj Quarterly Avg Spec Frac Spatial Field
    [ProtoContract]
    public class SpecFracSpatialAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double gridcellLat;
        [ProtoMember(3)]
        public double gridcellLong;
        [ProtoMember(4)]
        public int quarter;
        [ProtoMember(5)]
        public double pmMassFrac;
        [ProtoMember(6)]
        public double fCr;
        [ProtoMember(7)]
        public double fEC;
        [ProtoMember(8)]
        public double fNH4;
        [ProtoMember(9)]
        public double fOcm;
        [ProtoMember(10)]
        public double fSO4;
        [ProtoMember(11)]
        public double fNO3;
        [ProtoMember(12)]
        public double fWater;
        [ProtoMember(13)]
        public double fSalt;
        [ProtoMember(14)]
        public double blankMass;
        [ProtoMember(15)]
        public double don;
        [ProtoMember(16)]
        public double iSO4;
        [ProtoMember(17)]
        public double iNO3r;
        [ProtoMember(18)]
        public double iOcb;
        [ProtoMember(19)]
        public double iEC;
        [ProtoMember(20)]
        public double iCrustal;
        [ProtoMember(21)]
        public double iDON;
        [ProtoMember(22)]
        public double iNH4;
        [ProtoMember(23)]
        public double iNO3;
        [ProtoMember(24)]
        public double iSalt;
    }

    //-------------Annual PM---------- Quarterly Avg NH4-DON Monitors
    //------------Daily PM---------Quarterly Peak NH4-DON Monitors
    [ProtoContract]
    public class NH4DONMonitorsAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double monitorlLat;
        [ProtoMember(4)]
        public double monitorLong;
        [ProtoMember(5)]
        public int monitorGridcell;
        [ProtoMember(6)]
        public int quarter;
        [ProtoMember(7)]
        public double bNH4Mass;
        [ProtoMember(8)]
        public double bDON;
    }

    //--------------Annual PM------------- Quarterly Avg PM25 Monitors
    //-----------Daily PM----------Quarterly Peak PM25 Monitors
    [ProtoContract]
    public class PMMonitorsAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double monitorLat;
        [ProtoMember(4)]
        public double monitorLong;
        [ProtoMember(5)]
        public int monitorGridcell;
        [ProtoMember(6)]
        public int quarter;
        [ProtoMember(7)]
        public double bPMMass;
    }

    //---------------Annual PM ------------Quarterly Avg Speciated Monitors
    //---------------Daily PM---------Quarterly Peak Speciated Monitors
    [ProtoContract]
    public class SpeciatedMonitorsAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double monitorLat;
        [ProtoMember(4)]
        public double monitorLong;
        [ProtoMember(5)]
        public int monitorGridcell;
        [ProtoMember(6)]
        public int quarter;
        [ProtoMember(7)]
        public double bCrustalMass;
        [ProtoMember(8)]
        public double bECMass;
        [ProtoMember(9)]
        public double bOCBMass;
        [ProtoMember(10)]
        public double bSO4Mass;
        [ProtoMember(11)]
        public double bNO3Mass;
        [ProtoMember(12)]
        public double bNO3rMass;
        [ProtoMember(13)]
        public double bSaltMass;
    }

    //---------------Annual PM ----------Neighbor File Point
    //----------Daily PM--------Neighbor File Point
    [ProtoContract]
    public class NeighborFilePointAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string stateName;
        [ProtoMember(3)]
        public string countyName;
        [ProtoMember(4)]
        public double monitorLat;
        [ProtoMember(5)]
        public double monitorLong;
        [ProtoMember(6)]
        public int monitorGridcell;
        [ProtoMember(7)]
        public int quarter;
        [ProtoMember(8)]
        public string neighbor;
        [ProtoMember(9)]
        public int neighborGridcell;
        [ProtoMember(10)]
        public double distance;
        [ProtoMember(11)]
        public double weightDistance;
        [ProtoMember(12)]
        public double weightDistanceSquared;
        [ProtoMember(13)]
        public string pollutant;
    }

    //----------------------Annual PM Neighbor File Spatial Field
    [ProtoContract]
    public class NeighborFileSpatial : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double gridcellLat;
        [ProtoMember(3)]
        public double gridcellLong;
        [ProtoMember(4)]
        public int quarter;
        [ProtoMember(5)]
        public string neighbor;
        [ProtoMember(6)]
        public int neighborGridcell;
        [ProtoMember(7)]
        public double distance;
        [ProtoMember(8)]
        public double weightDistance;
        [ProtoMember(9)]
        public double weightDistanceSquared;
        [ProtoMember(10)]
        public string pollutant;
    }

    //----------Daily PM-------Daily All Years All Quarters PM25 Point
    [ProtoContract]
    public class AllYearAllQuarterlyAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public string stateName;
        [ProtoMember(4)]
        public string countyName;
        [ProtoMember(5)]
        public double monitorLat;
        [ProtoMember(6)]
        public double monitorLong;
        [ProtoMember(7)]
        public int monitorGridcell;
        [ProtoMember(8)]
        public string year;
        [ProtoMember(9)]
        public int quarter;
        [ProtoMember(10)]
        public double bPMdqCONC;
        [ProtoMember(11)]
        public double fPMdqCONC;
        [ProtoMember(12)]
        public double bBlankMassq;
        [ProtoMember(13)]
        public double bCrustalMassq;
        [ProtoMember(14)]
        public double bECMassq;
        [ProtoMember(15)]
        public double bNH4Massq;
        [ProtoMember(16)]
        public double bOcmbMassq;
        [ProtoMember(17)]
        public double bSO4Massq;
        [ProtoMember(18)]
        public double bNO3Massq;
        [ProtoMember(19)]
        public double bWaterMassq;
        [ProtoMember(20)]
        public double bSaltMassq;
        [ProtoMember(21)]
        public double fBlankMassq;
        [ProtoMember(22)]
        public double fCrustalMassq;
        [ProtoMember(23)]
        public double fECMassq;
        [ProtoMember(24)]
        public double fNH4Massq;
        [ProtoMember(25)]
        public double fOcmbMassq;
        [ProtoMember(26)]
        public double fSO4Massq;
        [ProtoMember(27)]
        public double fNO3Massq;
        [ProtoMember(28)]
        public double fWaterMassq;
        [ProtoMember(29)]
        public double fSaltMassq;
        [ProtoMember(30)]
        public double rrfCrustalq;
        [ProtoMember(31)]
        public double rrfECq;
        [ProtoMember(32)]
        public double rrfNH4q;
        [ProtoMember(33)]
        public double rrfOCq;
        [ProtoMember(34)]
        public double rrfSO4q;
        [ProtoMember(35)]
        public double rrfNO3q;
        [ProtoMember(36)]
        public double rrfSaltq;
    }

    //Daily PM -----------Daily All Years High Quarterly PM25 Point
    [ProtoContract]
    public class AllYearHighQuarterlyAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public string stateName;
        [ProtoMember(4)]
        public string countyName;
        [ProtoMember(5)]
        public double monitorLat;
        [ProtoMember(6)]
        public double monitorLong;
        [ProtoMember(7)]
        public int monitorGridcell;
        [ProtoMember(8)]
        public string year;
        [ProtoMember(9)]
        public int bHighQuarter;
        [ProtoMember(10)]
        public double bPMdpCONC;
        [ProtoMember(11)]
        public int fHighQuarter;
        [ProtoMember(12)]
        public double fPMdpCONC;
    }
    [ProtoContract]
    public class OzoneMonitor
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double lat;
        [ProtoMember(3)]
        public double longitude;
        [ProtoMember(4)]
        public double ozone;
        [ProtoMember(5)]
        public Dictionary<string, double> dicOzone;
        [ProtoMember(6)]
        public int datacount;
        [ProtoMember(7)]
        public string county;
        [ProtoMember(8)]
        public string state;
        [ProtoMember(9)]
        public double longitudeLamber;
        [ProtoMember(10)]
        public double latitudeLamber;
    }
    [ProtoContract]
    public class OzoneMonitorControl
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double lat;
        [ProtoMember(3)]
        public double longitude;
        [ProtoMember(4)]
        public double ozonebase;
        [ProtoMember(5)]
        public double ozonecontrol;
        [ProtoMember(6)]
        public int ppb;
        [ProtoMember(7)]
        public int lim;
        [ProtoMember(8)]
        public double rrf;
        [ProtoMember(9)]
        public int days;
        [ProtoMember(10)]
        public string county;
        [ProtoMember(11)]
        public string state;
        [ProtoMember(12)]
        public string referencecell;
    }
    [ProtoContract]
    public class OzoneMonitorControlMax
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double lat;
        [ProtoMember(3)]
        public double longitude;
        [ProtoMember(4)]
        public double ozonebase;
        [ProtoMember(5)]
        public double ozonecontrol;
        [ProtoMember(6)]
        public int ppb;
        [ProtoMember(7)]
        public int lim;
        [ProtoMember(8)]
        public double rrf;
        [ProtoMember(9)]
        public int days;
        [ProtoMember(10)]
        public string county;
        [ProtoMember(11)]
        public string state;
        [ProtoMember(12)]
        public string referencecell;
        [ProtoMember(13)]
        public string data;
    }
    [ProtoContract]
    public class OzoneModel
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public string Date;//到月份
        [ProtoMember(4)]
        public double lat;
        [ProtoMember(5)]
        public double longitude;
        [ProtoMember(6)]
        public float ozone;
        [ProtoMember(7)]
        public Dictionary<string, float[]> lstOzone;//Ozone->Base Control
        //[ProtoMember(8)]
        //public Dictionary<string, float> lstOzoneForecast;//Ozone->Base Control
        [ProtoMember(9)]
        public int ppb;
        [ProtoMember(10)]
        public int lim;
        [ProtoMember(11)]
        public double rrf;
        [ProtoMember(12)]
        public int days;
        [ProtoMember(13)]
        public double srf;
        [ProtoMember(14)]
        public double longitudeLamber;
        [ProtoMember(15)]
        public double latitudeLamber;
        [ProtoMember(16)]
        public float futureOzone;
        [ProtoMember(17)]
        public float bO3forSptailfield;
        [ProtoMember(18)]
        public double rrfforSptailfield;
        [ProtoMember(19)]
        public int ppbforSptailfield;
        [ProtoMember(20)]
        public int daysforSptailfield;
    }
    [ProtoContract]
    public class OzoneModelOutput
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public string Date;//到月份
        [ProtoMember(4)]
        public double lat;
        [ProtoMember(5)]
        public double longitude;
        [ProtoMember(6)]
        public float ga_conc;
        [ProtoMember(7)]
        public float vna;
        [ProtoMember(8)]
        public float evna;
        [ProtoMember(9)]
        public float vnaForcast;
        [ProtoMember(10)]
        public float evnaForcast;
        [ProtoMember(11)]
        public int ppb;
        [ProtoMember(12)]
        public string referencecell;
        [ProtoMember(13)]
        public double rrf;
        [ProtoMember(14)]
        public int days;
        [ProtoMember(15)]
        public float downscaler;
        [ProtoMember(16)]
        public float downscalerForcast;
        [ProtoMember(17)]
        public float bO3modelForSpatialField;
        [ProtoMember(18)]
        public float wvna;
        [ProtoMember(19)]
        public float wvnaForcast;
        [ProtoMember(20)]
        public float ns;
        [ProtoMember(21)]
        public float nsForcast;
    }
    //---------Ozone--------Ozone Monitors -- county high monitoring sites, temporally adjusted 2015.csv
    //---------Ozone--------Ozone Monitors -- monitor data, temporally adjusted 2015.csv
    [ProtoContract]
    public class MonitorsAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double bO3DV;
        [ProtoMember(7)]
        public double fO3DV;
        [ProtoMember(8)]
        public int referenceCell;
        [ProtoMember(9)]
        public double rrf;
        [ProtoMember(10)]
        public int ppb;
        [ProtoMember(11)]
        public int days;
        [ProtoMember(12)]
        public string stateName;
        [ProtoMember(13)]
        public string countyName;
    }

    //------Ozone-------Spatial Field -- interpolated monitor data, temporally adjusted; gradient-adjusted monitor data, 2015.csv
    [ProtoContract]
    public class OzoneSpatialAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double gaCONC;
        [ProtoMember(7)]
        public double ibO3;
        [ProtoMember(8)]
        public double ifO3;
        [ProtoMember(9)]
        public double ibgaO3;
        [ProtoMember(10)]
        public double ifgaO3;
        [ProtoMember(11)]
        public int ppb;
        [ProtoMember(12)]
        public int days;
        [ProtoMember(13)]
        public int referenceCell;
        [ProtoMember(14)]
        public double rrf;
    }

    //--------Ozone------- Sptl. Fld. -- interp. monitor data.csv
    //----------Ozone--------Sptl. Fld. -- interp. grad.-adjusted monitor data.csv
    [ProtoContract]
    public class BaselineInterpMonitorAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double gaCONC;
        [ProtoMember(7)]
        public double ibO3;//i_b_ga_o3
    }

    //----------Ozone---------Spatial Field -- interpolated monitor data, temporally adjusted 2015.csv
    //----------Ozone--------- Spatial Field -- interpolated gradient-adjusted monitor data, temporally adjusted 2015.csv
    [ProtoContract]
    public class FutureInterpMonitorAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double gaCONC;
        [ProtoMember(7)]
        public double ibO3;//i_b_ga_o3
        [ProtoMember(8)]
        public double ifO3;//i_f_ga_o3
        [ProtoMember(9)]
        public int ppb;
        [ProtoMember(10)]
        public int days;
        [ProtoMember(11)]
        public int referenceCell;
        [ProtoMember(12)]
        public double rrf;
    }

    //-----Visibility----------Class 1 Area and IMPROVE Monitor Identifiers and Locations.csv--Day
    [ProtoContract]
    public class MonitorIdentifiersAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public string classIName;
        [ProtoMember(4)]
        public string classIState;
        [ProtoMember(5)]
        public double classIlat;
        [ProtoMember(6)]
        public double classIlong;
        [ProtoMember(7)]
        public string classIGridcell;
        [ProtoMember(8)]
        public string date;
        [ProtoMember(9)]
        public string monitorID;
        [ProtoMember(10)]
        public double monitorLat;
        [ProtoMember(11)]
        public double monitorLong;
        [ProtoMember(12)]
        public string monitorGridcell;
    }

    [ProtoContract]
    public class MonitorClass1AreaIdentifiers
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public string classIName;
        [ProtoMember(4)]
        public string classIState;
        [ProtoMember(5)]
        public double classIlat;
        [ProtoMember(6)]
        public double classIlong;
        [ProtoMember(7)]
        public string classIGridcell;
        [ProtoMember(8)]
        public string date;
        [ProtoMember(9)]
        public string monitorID;
        [ProtoMember(10)]
        public double monitorLat;
        [ProtoMember(11)]
        public double monitorLong;
        [ProtoMember(12)]
        public string monitorGridcell;
    }

    //---------Visibility-----------Forecasted Visibility-all design values--Year
    [ProtoContract]
    public class ForecastedAllDVAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public string date;
        [ProtoMember(4)]
        public double dvBest;
        [ProtoMember(5)]
        public double dvWorst;
        [ProtoMember(6)]
        public double baseBest;
        [ProtoMember(7)]
        public double baseWorst;
        [ProtoMember(8)]
        public int gridcell;//根据所选择的为monitor还是class i area来决定名称：monitor_gridcell/class_i_gridcell
        [ProtoMember(9)]
        public double gridcellLat;
        [ProtoMember(10)]
        public double gridcellLong;
        [ProtoMember(11)]
        public double lat;//monitor/class i
        [ProtoMember(12)]
        public double longitude;
    }

    //---------Visibility---------Forecasted Visibility Data.csv---Year
    //---------Visibility----------Forecasted Visibility Data for Class 1 Areas.csv
    [ProtoContract]
    public class ForecastedVisibilityDataAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public string date;
        [ProtoMember(4)]
        public double dvBest;
        [ProtoMember(5)]
        public double dvWorst;
        [ProtoMember(6)]
        public double baseBest;
        [ProtoMember(7)]
        public double baseWorst;
        [ProtoMember(8)]
        public double rrfbCrustal;
        [ProtoMember(9)]
        public double rrfbNO3;
        [ProtoMember(10)]
        public double rrfbOC;
        [ProtoMember(11)]
        public double rrfbEC;
        [ProtoMember(12)]
        public double rrfbCM;
        [ProtoMember(13)]
        public double rrfbSO4;
        [ProtoMember(14)]
        public double rrfwCrustal;
        [ProtoMember(15)]
        public double rrfwNO3;
        [ProtoMember(16)]
        public double rrfwOC;
        [ProtoMember(17)]
        public double rrfwEC;
        [ProtoMember(18)]
        public double rrfwCM;
        [ProtoMember(19)]
        public double rrfwSO4;
        [ProtoMember(20)]
        public string gridcell;//monitor_gridcell/class_i_gridcell
        [ProtoMember(21)]
        public double gridcellLat;
        [ProtoMember(22)]
        public double gridcellLong;
        [ProtoMember(23)]
        public double lat;//monitor_lat,monitor_long/class_i_lat,class_i_long
        [ProtoMember(24)]
        public double longitude;

        #region 成分数据的dv， by sclong, 2017-03-05
        [ProtoMember(25)]
        public SpeciesDV AmmSO4;
        [ProtoMember(26)]
        public SpeciesDV SmallAmmSO4;
        [ProtoMember(27)]
        public SpeciesDV LargeAmmSO4;
        [ProtoMember(28)]
        public SpeciesDV AmmNO3;
        [ProtoMember(29)]
        public SpeciesDV SmallAmmNO3;
        [ProtoMember(30)]
        public SpeciesDV LargeAmmNO3;
        [ProtoMember(31)]
        public SpeciesDV OMC;
        [ProtoMember(32)]
        public SpeciesDV SmallOMC;
        [ProtoMember(33)]
        public SpeciesDV LargeOMC;
        [ProtoMember(34)]
        public SpeciesDV EC;
        [ProtoMember(35)]
        public SpeciesDV Crustal;
        [ProtoMember(36)]
        public SpeciesDV CM;
        [ProtoMember(37)]
        public SpeciesDV SeaSalt;
        /// <summary>
        /// total extinction
        /// </summary>
        [ProtoMember(38)]
        public SpeciesDV TBext;
        #endregion 成分数据的dv， by sclong, 2017-03-05
    }

    /// <summary>
    /// 成分数据的基准年和未来年best and worst DV value;
    /// by sclong
    /// </summary>
    [ProtoContract]
    public class SpeciesDV
    {
        /// <summary>
        /// Base year measured specie mass (ug/m3) 20% clearest days
        /// </summary>
        [ProtoMember(1)]
        public double Best_b;
        /// <summary>
        /// Future year measured specie mass (ug/m3) 20% clearest days
        /// </summary>
        [ProtoMember(2)]
        public double Best_f;
        /// <summary>
        /// Base year measured specie mass (ug/m3) 20% most impaired days
        /// </summary>
        [ProtoMember(3)]
        public double Worst_b;
        /// <summary>
        /// Future year measured specie mass (ug/m3) 20% most impaired days
        /// </summary>
        [ProtoMember(4)]
        public double Worst_f;
        /// <summary>
        /// Base year measured specie extinction (Mm-1) 20% clearest days
        /// </summary>
        [ProtoMember(5)]
        public double E_Best_b;
        /// <summary>
        /// Future year measured specie extinction (Mm-1) 20% clearest days
        /// </summary>
        [ProtoMember(6)]
        public double E_Best_f;
        /// <summary>
        ///  Base year measured specie extinction (Mm-1) 20% most impaired days
        /// </summary>
        [ProtoMember(7)]
        public double E_Worst_b;
        /// <summary>
        ///  Future year measured specie extinction (Mm-1) 20% most impaired days
        /// </summary>
        [ProtoMember(8)]
        public double E_Worst_f;
    }

    [ProtoContract]
    public class ForecastedVisibility
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double rrfbNO3;
        [ProtoMember(4)]
        public double rrfbOC;
        [ProtoMember(5)]
        public double rrfbEC;
        [ProtoMember(6)]
        public double rrfbCM;
        [ProtoMember(7)]
        public double rrfbSO4;
        [ProtoMember(8)]
        public double rrfwCrustal;
        [ProtoMember(9)]
        public double rrfwNO3;
        [ProtoMember(10)]
        public double rrfwOC;
        [ProtoMember(11)]
        public double rrfwEC;
        [ProtoMember(12)]
        public double rrfwCM;
        [ProtoMember(13)]
        public double rrfwSO4;
        [ProtoMember(14)]
        public string gridcell;//monitor_gridcell/class_i_gridcell
        [ProtoMember(15)]
        public double gridcellLat;
        [ProtoMember(16)]
        public double gridcellLong;
        [ProtoMember(17)]
        public double lat;//monitor_lat,monitor_long/class_i_lat,class_i_long
        [ProtoMember(18)]
        public double longitude;
        [ProtoMember(19)]
        public Dictionary<string, ForecastedVisibilityDataAttribute> dicForecastedVisibilityValues;
        [ProtoMember(20)]
        public double rrfbCrustal;
        [ProtoMember(21)]
        public Dictionary<string, ForecastedVisibilityDataAttribute> dicForecastedValuesPoint;
        [ProtoMember(22)]
        public double monitorLat;//monitor_lat,monitor_long/class_i_lat,class_i_long
        [ProtoMember(23)]
        public double monitorLongitude;
        [ProtoMember(24)]
        public string monitorID;
    }

    //------------Visibility----------Used Model Reference Cells - Base/Future Data--Day
    [ProtoContract]
    public class ModelRefrenceCellsAttribute : BaseOutputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double gridcellLat;
        [ProtoMember(4)]
        public double gridcellLong;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double crustal;
        [ProtoMember(7)]
        public double so4;
        [ProtoMember(8)]
        public double ec;
        [ProtoMember(9)]
        public double no3;
        [ProtoMember(10)]
        public double oc;
        [ProtoMember(11)]
        public double cm;
        [ProtoMember(12)]
        public string visibilityRank;
    }

    [ProtoContract]
    public class VisibilityModelData
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double gridcellLat;
        [ProtoMember(4)]
        public double gridcellLong;
        [ProtoMember(5)]
        public Dictionary<string, ModelDataVisibility> dicBaselineModel;
        [ProtoMember(6)]
        public Dictionary<string, ModelDataVisibility> dicFutureModel;
    }

    [ProtoContract]
    public class ModelDataVisibility
    {
        [ProtoMember(1)]
        public float crustal;
        [ProtoMember(2)]
        public float so4;
        [ProtoMember(3)]
        public float ec;
        [ProtoMember(4)]
        public float no3;
        [ProtoMember(5)]
        public float oc;
        [ProtoMember(6)]
        public float cm;
        [ProtoMember(7)]
        public string visibilityRank;
    }
    #endregion
    #region input
    //-------------以output中的species fraction文件为input
    [ProtoContract]
    public class SpeciesFractionFilePoint : BaseInputAttribute
    {
    }
    [ProtoContract]
    public class SpeciesFractionFileSpatial : BaseInputAttribute
    {
    }
    //24-hr-official-FRM-99-08-v2
    [ProtoContract]
    public class OfficialDailyPMMonitorDataAttribute : BaseInputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double pm25;
        [ProtoMember(7)]
        public int ninetyEightPercentile;
        [ProtoMember(8)]
        public int epaFlag;
        [ProtoMember(9)]
        public int completionCode;
        [ProtoMember(10)]
        public string stateName;
        [ProtoMember(11)]
        public string countyName;
    }

    //156-Class1-coordinates-all site names
    [ProtoContract]
    public class ClassISiteNamesAttribute : BaseInputAttribute
    {
        [ProtoMember(1)]
        public string monitorID;
        [ProtoMember(2)]
        public double monitorLat;
        [ProtoMember(3)]
        public double monitorLong;
        [ProtoMember(4)]
        public string classIName;
        [ProtoMember(5)]
        public string id;
        [ProtoMember(6)]
        public string stateID;
        [ProtoMember(7)]
        public double lat;
        [ProtoMember(8)]
        public double longitude;
    }

    [ProtoContract]
    public class VisibilityMonitor
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public Dictionary<string, Dictionary<string, NewImproveMonitors>> dicNewIMPROVE; //new IMPROVE equation
        [ProtoMember(6)]
        public Dictionary<string, Dictionary<string, OldImproveMonitorDataAttribute>> dicOldIMPROVE;//old IMPROVE equation
    }

    [ProtoContract]
    public class NewImproveMonitors
    {
        [ProtoMember(1)]
        public double frh;
        [ProtoMember(2)]
        public double fsrh;
        [ProtoMember(3)]
        public double flrh;
        [ProtoMember(4)]
        public double fssrh;
        [ProtoMember(5)]
        public int ssRayleigh;
        [ProtoMember(6)]
        public double seaSalt;
        [ProtoMember(7)]
        public double pm25;
        [ProtoMember(8)]
        public double crustal;
        [ProtoMember(9)]
        public double ammNO3;
        [ProtoMember(10)]
        public double omc;
        [ProtoMember(11)]
        public double ec;
        [ProtoMember(12)]
        public double cm;
        [ProtoMember(13)]
        public double largeOMC;
        [ProtoMember(14)]
        public double smallOMC;
        [ProtoMember(15)]
        public double largeAmmSO4;
        [ProtoMember(16)]
        public double smallAmmSO4;
        [ProtoMember(17)]
        public double largeAmmNO3;
        [ProtoMember(18)]
        public double smallAmmNO3;
        /// <summary>
        ///tbext
        /// </summary>
        [ProtoMember(19)]
        public double baseBext;
        [ProtoMember(20)]
        public double baseDV;
        [ProtoMember(21)]
        public int goodYear;
        [ProtoMember(22)]
        public int group;
        [ProtoMember(23)]
        public int possibleNDays;
        [ProtoMember(24)]
        public int nDays;
        [ProtoMember(25)]
        public int completeQuarter;
        /// <summary>
        /// future_tbext
        /// </summary>
        [ProtoMember(26)]
        public double futureBext;
        [ProtoMember(27)]
        public double futureDV;
        [ProtoMember(28)]
        public double futureLargeOMC;
        [ProtoMember(29)]
        public double futureSmallOMC;
        [ProtoMember(30)]
        public double futureLargeAmmSO4;
        [ProtoMember(31)]
        public double futureSmallAmmSO4;
        [ProtoMember(32)]
        public double futureLargeAmmNO3;
        [ProtoMember(33)]
        public double futureSmallAmmNO3;
        [ProtoMember(34)]
        public double futureCrustal;
        [ProtoMember(35)]
        public double futureEC;
        [ProtoMember(36)]
        public double futureCm;
        [ProtoMember(37)]
        public double ammSO4;
        [ProtoMember(38)]
        public double futureAmmSO4;
        [ProtoMember(39)]
        public double futurAmmNO3;
        [ProtoMember(40)]
        public double futureOMC;

        #region add by sclong
        [ProtoMember(41)]
        public double e_amm_so4;
        [ProtoMember(42)]
        public double e_amm_no3;
        [ProtoMember(43)]
        public double e_omc;
        [ProtoMember(44)]
        public double e_ec;
        [ProtoMember(45)]
        public double e_crustal;
        [ProtoMember(46)]
        public double e_cm;
        [ProtoMember(47)]
        public double e_sea_salt;
        [ProtoMember(48)]
        public double tbext;
        [ProtoMember(49)]
        public double future_e_amm_so4;
        [ProtoMember(50)]
        public double future_e_amm_no3;
        [ProtoMember(51)]
        public double future_e_omc;
        [ProtoMember(52)]
        public double future_e_ec;
        [ProtoMember(53)]
        public double future_e_crustal;
        [ProtoMember(54)]
        public double future_e_cm;
        [ProtoMember(55)]
        public double future_e_sea_salt;
        [ProtoMember(56)]
        public double future_tbext;
        #endregion

        /// <summary>
        /// add by sclong,Future year sea salt mass (ug/m3) 
        /// </summary>
        //[ProtoMember(41)]
        //public double futureSeaSalt;
    }

    //2000-2006-daily IMPROVE-all data-new equation
    [ProtoContract]
    public class NewImproveMonitorDataAttribute : BaseInputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double frh;
        [ProtoMember(7)]
        public double fsrh;
        [ProtoMember(8)]
        public double flrh;
        [ProtoMember(9)]
        public double fssrh;
        [ProtoMember(10)]
        public int ssRayleigh;
        [ProtoMember(11)]
        public double seaSalt;
        [ProtoMember(12)]
        public double pm25;
        [ProtoMember(13)]
        public double crustal;
        [ProtoMember(14)]
        public double ammNO3;
        [ProtoMember(15)]
        public double omc;
        [ProtoMember(16)]
        public double ec;
        [ProtoMember(17)]
        public double pm10;
        [ProtoMember(18)]
        public double cm;
        [ProtoMember(19)]
        public double ammSO4;
        [ProtoMember(20)]
        public double largeOMC;
        [ProtoMember(21)]
        public double smallOMC;
        [ProtoMember(22)]
        public double largeAmmSO4;
        [ProtoMember(23)]
        public double smallAmmSO4;
        [ProtoMember(24)]
        public double largeAmmNO3;
        [ProtoMember(25)]
        public double smallAmmNO3;
        [ProtoMember(26)]
        public double eAmmSO4;
        [ProtoMember(27)]
        public double eAmmNO3;
        [ProtoMember(28)]
        public double eOMC;
        [ProtoMember(29)]
        public double eEC;
        [ProtoMember(30)]
        public double eCrtustal;
        [ProtoMember(31)]
        public double eCM;
        [ProtoMember(32)]
        public double eSeaSalt;
        [ProtoMember(33)]
        public double tBext;
        [ProtoMember(34)]
        public double dv;
        [ProtoMember(35)]
        public int goodYear;
        [ProtoMember(36)]
        public int group;
        [ProtoMember(37)]
        public int possibleNDays;
        [ProtoMember(38)]
        public int nDays;
        [ProtoMember(39)]
        public int completeQuarter;
        [ProtoMember(40)]
        public double sf;
        [ProtoMember(41)]
        public double so4F;
    }

    //2002cc_EUS_PM25_sub
    //2020cc_EUS_PM25_sub
    //Daily model data
    //visibility analysis 中的model data 也为上面两个文件
    [ProtoContract]
    public class DailyModelDataAttribute : BaseInputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double crustal;
        [ProtoMember(7)]
        public double nh4;
        [ProtoMember(8)]
        public double so4;
        [ProtoMember(9)]
        public double ec;
        [ProtoMember(10)]
        public double no3;
        [ProtoMember(11)]
        public double oc;
        [ProtoMember(12)]
        public double pm25;
        [ProtoMember(13)]
        public double cm;
    }

    //-------------Quarterly model data--------------baseline/future
    [ProtoContract]
    public class QuarterlyModelDataAttribute : BaseInputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double latitude;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double crustal;
        [ProtoMember(7)]
        public double nh4;
        [ProtoMember(8)]
        public double so4;
        [ProtoMember(9)]
        public double ec;
        [ProtoMember(10)]
        public double no3;
        [ProtoMember(11)]
        public double oc;
        [ProtoMember(12)]
        public double pm25;
        [ProtoMember(13)]
        public double cm;
    }

    //-------------CMAQ files---------------
    [ProtoContract]
    public class CMAQModelDataAttribute : BaseInputAttribute
    { }
    //----------------Annual-official-FRM-99-08-v2---------------
    [ProtoContract]
    public class OfficialAnnualPMMonitorDataAttribute : BaseInputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double pm25;
        [ProtoMember(7)]
        public int nDays;
        [ProtoMember(8)]
        public string substitutionCode;
        [ProtoMember(9)]
        public int completionCode;
        [ProtoMember(10)]
        public string stateName;
        [ProtoMember(11)]
        public string countyName;
    }

    //-----------------GeoMembership--------------
    [ProtoContract]
    public class GeoMembershipAttribute : BaseInputAttribute
    {
        [ProtoMember(1)]
        public int id;
        [ProtoMember(2)]
        public int r;
        [ProtoMember(3)]
        public int c;
        [ProtoMember(4)]
        public double lat;
        [ProtoMember(5)]
        public double longitude;
        [ProtoMember(6)]
        public double wgtPop;
        [ProtoMember(7)]
        public double wgtPopWhite;
        [ProtoMember(8)]
        public double wgtPopWhiteB20;
        [ProtoMember(9)]
        public double wgtPopNonWhite;
        [ProtoMember(10)]
        public double wgtPopNonWhiteB20;
        [ProtoMember(11)]
        public int msa;
        [ProtoMember(12)]
        public int cmsa;
        [ProtoMember(13)]
        public string epaRegion;//不确定数据类型，没数据
        [ProtoMember(14)]
        public int state;
    }

    //-----------Interpolation-----------------
    [ProtoContract]
    public class InterpolationAttribute : BaseInputAttribute
    {
        [ProtoMember(1)]
        public string pollutantName;
        [ProtoMember(2)]
        public string region;
        [ProtoMember(3)]
        public double value;
        [ProtoMember(4)]
        public int method;
        [ProtoMember(5)]
        public long misDist;
    }

    //--------------OZONE_SMAT_CE_input_9908-v2------------
    [ProtoContract]
    public class OzoneMonitorDataAttribute : BaseInputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public int poc;
        [ProtoMember(6)]
        public string dvYear;
        [ProtoMember(7)]
        public int o3;
        [ProtoMember(8)]
        public string stateName;
        [ProtoMember(9)]
        public string countyName;
    }

    //----------------ozone_model_data_2001-------------
    //---------------ozone_model_data_2015--------
    [ProtoContract]
    public class OzoneModelDataAttribute : BaseInputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double o3;
    }

    //PM25-for-fractions-0206-v3
    [ProtoContract]
    public class UnofficialPMMonitorDataAttribute : BaseInputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double pm25;
        [ProtoMember(7)]
        public int epaFlag;
        [ProtoMember(8)]
        public int userFlag;
    }

    //Species-for-fractions-0206-v2
    [ProtoContract]
    public class SpeciesMonitorDataAttribute : BaseInputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double lat;
        [ProtoMember(3)]
        public double longitude;
        [ProtoMember(4)]
        public string type;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double so4;
        [ProtoMember(7)]
        public double no3r;
        [ProtoMember(8)]
        public double nh4;
        [ProtoMember(9)]
        public double ocb;
        [ProtoMember(10)]
        public double ec;
        [ProtoMember(11)]
        public double crustal;
        [ProtoMember(12)]
        public double salt;
        [ProtoMember(13)]
        public double don;
        [ProtoMember(14)]
        public double h2oAIM;
        [ProtoMember(15)]
        public double oc;
        [ProtoMember(16)]
        public double no3;
        [ProtoMember(17)]
        public double so43S;
        [ProtoMember(18)]
        public double crustalALT;
        [ProtoMember(19)]
        public double frmMass;
        [ProtoMember(20)]
        public double measuredFM;
        [ProtoMember(21)]
        public double rcFM;
        [ProtoMember(22)]
        public double al;
        [ProtoMember(23)]
        public double ca;
        [ProtoMember(24)]
        public double fe;
        [ProtoMember(25)]
        public double ti;
        [ProtoMember(26)]
        public double si;
        [ProtoMember(27)]
        public int epaFlag;
        [ProtoMember(28)]
        public int userFlag;
    }

    //visibility_monitor_data_old_improve
    [ProtoContract]
    public class OldImproveMonitorDataAttribute : BaseInputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public string type;
        [ProtoMember(3)]
        public double lat;
        [ProtoMember(4)]
        public double longitude;
        [ProtoMember(5)]
        public string date;
        [ProtoMember(6)]
        public double frh;
        [ProtoMember(7)]
        public double pm25;
        [ProtoMember(8)]
        public double crustal;
        [ProtoMember(9)]
        public double ammNO3;
        [ProtoMember(10)]
        public double omc;
        [ProtoMember(11)]
        public double ec;
        [ProtoMember(12)]
        public double pm10;
        [ProtoMember(13)]
        public double cm;
        [ProtoMember(14)]
        public double ammSO4;
        [ProtoMember(15)]
        public double eAmmSO4;
        [ProtoMember(16)]
        public double eAmmNO3;
        [ProtoMember(17)]
        public double eOMC;
        [ProtoMember(18)]
        public double eEC;
        [ProtoMember(19)]
        public double eCrustal;
        [ProtoMember(20)]
        public double eCM;
        [ProtoMember(21)]
        public double tBEXT;
        [ProtoMember(22)]
        public double dv;
        [ProtoMember(23)]
        public double goodYear;
        [ProtoMember(24)]
        public double group;
        [ProtoMember(25)]
        public double possibleNDays;
        [ProtoMember(26)]
        public double nDays;
        [ProtoMember(27)]
        public double completeQuarter;
        [ProtoMember(28)]
        public double sf;
        [ProtoMember(29)]
        public double so4F;
    }

    //SimpleWind
    [ProtoContract]
    public class SimpleWindAttribute : BaseInputAttribute
    {
        [ProtoMember(1)]
        public string id;
        [ProtoMember(2)]
        public double lat;
        [ProtoMember(3)]
        public double longitude;
        [ProtoMember(4)]
        public double d1;
        [ProtoMember(5)]
        public double d2;
        [ProtoMember(6)]
        public double d3;
        [ProtoMember(7)]
        public double d4;
        [ProtoMember(8)]
        public double d5;
        [ProtoMember(9)]
        public double d6;
        [ProtoMember(10)]
        public double d7;
        [ProtoMember(11)]
        public double d8;
        [ProtoMember(12)]
        public double d9;
        [ProtoMember(13)]
        public double d10;
        [ProtoMember(14)]
        public double d11;
        [ProtoMember(15)]
        public double d12;
        [ProtoMember(16)]
        public double d13;
        [ProtoMember(17)]
        public double d14;
        [ProtoMember(18)]
        public double d15;
        [ProtoMember(19)]
        public double d16;
        [ProtoMember(20)]
        public double max;
    }
    #endregion

    #region Batch
    public class BatchBase
    {
        public ArrayList BatchText;
        public string batchResultPath;
    }

    public class BatchAnnualPM : BatchBase
    {
        //public string resultFilePath;
        public string scenarioName;
        public bool doStandardAnalysis;
        public bool doQuarterlyModelData;
        public bool doUsedQuarterlyAvgModelData;
        public bool doSpeciesFraction;
        public bool doAutomaticallyExtract;
        public bool doInterpolatedSFETempAdj;
        public bool doInterpolatedSFETempAdj_GradAdj;
        public bool doQuarterlyAvgFilePoint;
        public bool doQuarterlyAvgFileSpatial;
        public bool doQuarterlyAvgFileSpatial_GraAdj;
        public bool doHighCountySites;
        public bool doSpeciesFractionSpatial;
        public bool doSpeciesFractionSpatial_GraAdj;
        public bool doQuarterlyAvgSpeciatedMonitors;
        public bool doDesignValuePeriods;
        public bool doNeighborFilePoint;
        public bool doNeighborFileSpatial;
        public bool doBaseOnlyVNA;
        public bool doFutureOnlyVNA;
        public bool doBaseOnlyEvna;
        public bool doFutureOnlyEvna;
        public bool doSpeciesMonitorDataFile;
        public string speciesMonitorDataFile;
        public bool doSpeciesFractionFile;
        public string specFracModePoint;
        public string specFracPointFile;
        public string specFracModeSpatial;
        public string specFracSpatialFile;
        public string unofficialMonitorDataFile;
        public string officialMonitorDataFile;
        public bool doDailyModelDataInput;
        public bool doQuarterlyModelDataInput;
        public bool doInputFromCmaq;
        public string baselineModelDataFile;
        public string forecastModelDataFile;
        public string IMPROVESTN_StartYear;
        public string IMPROVESTN_EndYear;
        public bool IMPROVESTN_EPADeletionChoice;
        public bool IMPROVESTN_UserDeletionChoice;
        public int IMPROVESTN_MinDays;
        public int IMPROVESTN_MinYear;
        public int IMPROVESTN_MinSeasons;
        public string unofficialStartYear;
        public string unofficialEndYear;
        public bool unofficialEPADeletionChoice;
        public bool unofficialUserDeletionChoice;
        public int unofficialMinDays;
        public int unofficialMinYears;
        public int unofficialMinSeasonsPoint;
        public int unofficialMinSeasonsSpatial;
        public string interpolationMethodPM25;
        public long distancePM25;
        public string interpolationMethodSO4;
        public long distanceSO4;
        public string interpolationMethodNO3;
        public long distanceNO3;
        public string interpolationMethodEC;
        public long distanceEC;
        public string interpolationMethodSalt;
        public long distanceSalt;
        public string interpolationMethodCrustal;
        public long distanceCrustal;
        public string interpolationMethodDON;
        public long distanceDON;
        public string interpolationMethodOC;
        public long distanceOC;
        public string interpolationMethodNH4;
        public long distanceNH4;
        public bool doUseDonValues;
        public bool doUseAmmoniumValues;
        public int nh4PercentageEvaporating;
        public decimal defaultBlankMass;
        public decimal floorOCMMB;
        public decimal ceilingOCMMB;
        public bool doAdvancedOptionsForSpeciesFraction;
        public string officialPM25StartYear;
        public string officialPM25EndYear;
        public bool choiceOfficialDV;
        public bool choiceCustomDV;
        public int minDaysForValidFRMQuarters;
        public int minQuartersForValidFRMDesignValues;
        public int minNumDVPeriodsForValidFRMMonitors;
        public string requiredDVPeriodsForValidFRMMonitors;
        public bool doCalcNH4fromDON;
        public bool doCalcNH4fromRRF;
        public string temporalAdjustmentAtMonitorGrid;
        public string temporalAdjustmentAtMonitorGridSpatial;
    }

    public class BatchDailyPM : BatchBase
    {
        public string scenarioName;
        public bool doStandardAnalysis;
        public bool doQuarterlyPeakModelData;
        public bool doSpeciesFraction;
        public bool doAutomaticallyExtract;
        public bool doQuarterlyPeakFilesPoint;
        public bool doHighCountySites;
        public bool doQuarterlyPeakSpeciatedMonitors;
        public bool doDesignValuePeriods;
        public bool doNeighborFilePoint;
        public bool doSpeciesMonitorDataFile;
        public string speciesMonitorDataFile;
        public bool doSpeciesFractionFile;
        public string specFracModePoint;
        public string specFracPointFile;
        public string specFracModeSpatial;
        public string specFracSpatialFile;
        public string unofficialMonitorFile;
        public string officialMonitorFile;
        public bool doDailyModelDataInput;
        public bool doQuarterlyPeakModelDataInput;
        public bool doInputfromCmaq;
        public string baselineModelFile;
        public string forecastModelFile;
        public string IMPROVE_StartYear;
        public string IMPROVE_EndYear;
        public bool IMPROVE_EPADeletionChoice;
        public bool IMPROVE_UserDeletionChoice;
        public int IMPROVE_MinDays;
        public int IMPROVE_MinQuarters;
        public int IMPROVE_MinYear;
        public string unofficialStartYear;
        public string unofficialEndYear;
        public bool unofficialEPADeletionChoice;
        public bool unofficialUserDeletionChoice;
        public int unofficialMinDays;
        public int unofficialMinQuartersPoint;
        public int unofficialMinYears;
        public bool IMPROVESTN_DoTopXPercent;
        public int IMPROVESTN_TopXPercent;
        public bool IMPROVESTN_DoUseAlldailyMonitorValuesGreaterThan;
        public int IMPROVESTN_UseAlldailyMonitorValuesGreaterThan;
        public int IMPROVESTN_MinumumNumberOfDaysRequiredAboveFixedAmount;
        public bool IMPROVESTN_DoUseTopXNumber;
        public int IMPROVESTN_UseTopXNumber;
        public bool unofficialPM25_DoTopXPercent;
        public int unofficialPM25_TopXPercent;
        public bool unofficialPM25_DoUseAlldailyMonitorValuesGreaterThan;
        public int unofficialPM25_UseAlldailyMonitorValuesGreaterThan;
        public int unofficialPM25_MinumumNumberOfDaysRequiredAboveFixedAmount;
        public bool unofficialPM25_DoTopXNumber;
        public int unofficialPM25_TopXNumber;
        public string interpolationMethodPM25;
        public long distancePM25;
        public string interpolationMethodSO4;
        public long distanceSO4;
        public string interpolationMethodNO3;
        public long distanceNO3;
        public string interpolationMethodEC;
        public long distanceEC;
        public string interpolationMethodSalt;
        public long distanceSalt;
        public string interpolationMethodCrustal;
        public long distanceCrustal;
        public string interpolationMethodDON;
        public long distanceDON;
        public string interpolationMethodOC;
        public long distanceOC;
        public string interpolationMethodNH4;
        public long distanceNH4;
        public bool doUseDonValues;
        public bool doUseMeasuredAmmonium;
        public int nh4PercentageEvaporating;
        public decimal defaultBlankMass;
        public decimal floorOCMMB;
        public decimal ceilingOCMMB;
        public bool doAdvancedOptionsForSpeciesFraction;
        public string officialPM25StartYear;
        public string officialPM25EndYear;
        public int minNumDVPeriodsForValidFRMMonitors;
        public string requiredDesignValuePeriodsForValidFRMMonitors;
        public bool doCalcNH4fromDON;
        public bool doCalcNH4fromRRF;
        public string temporalAdjustmentAtMonitorGridPoint;
        public string temporalAdjustmentAtMonitorGridSpatial;
        public string temporalAdjustmentType;
        public bool RRF_DoUseXTopPercent;
        public int RRF_UseXTopPercent;
        public bool RRF_DoUseAllModelDaysGreaterThan;
        public int RRF_UseAllModelDaysGreaterThan;
        public int RRF_MinumumNumberOfDaysRequiredAboveFixedAmount;
        public bool RRF_DoUseTopXNumber;
        public int RRF_UseTopXNumber;
    }

    public class BatchOzone : BatchBase
    {
        public string scenarioName;
        public bool doPointEstimatesForecast;
        public bool doQuarterlyModelData;
        public bool doSpatialFieldEstimates;
        public bool doBaseOnlyVNA;
        public bool doFutureOnlyVNA;
        public bool doSpatialFieldEstimatesGradAdj;
        public bool doBaseOnlyEvna;
        public bool doFutureOnlyEvna;
        public bool doNeighborFileSpatial;
        public bool doAutomaticallyExtract;
        public bool doDesignValuePeriods;
        public bool doMaxDesignValuePeriods;
        public string ozoneMonitorDataFile;
        public bool doInputfromCmaq;
        public string baselineModelDataFile;
        public string forecastModelDataFile;
        public string temporalAdjustmentAtMonitorGrid;
        public string temporalAdjustmentType;
        public string ozoneStartYear;
        public string ozoneEndYear;
        public int minNumDV;
        public string requiredDVPeriods;
        public string defaultInterpolationMethod;
        public bool doCheckToSetMaxDistance;
        public int maxDistance;
        public bool useInitialThresholdValue;
        public string initialThresholdValue;
        public string minNumofDaysAtorAboveThreshold;
        public string topXmodeledozonedays;
        public string minAllowableThresholdValue;
        public string minNumDaysAtorAboveMinAllowableThreshold;
        public bool doBackstop;
        public string backstopMinThresholdforSpatialField;
        public int subrangeFirstDay;
        public int subrangeLastDay;
        public bool doPairDays;
        public string SRF_StartValue;
        public string SRF_EndValue;
    }

    public class BatchVisibility : BatchBase
    {
        public string scenarioName;
        public bool doTemporallyAdjVisibilityLevelsForecast;
        public bool choiceUseOldVersionforIMPROVEAlgorithm;
        public bool choiceUseNewVersionforIMPROVEAlgorithm;
        public bool choiceUseModelGridCellAtMonitor;
        public bool choiceUseModelGridCellatClassIAreaCentroid;
        public bool doAutomaticallyExtract;
        public string monitorDataFileOldAlgorithm;
        public string monitorDataFileNewAlgorithm;
        public string baselineModelDataFile;
        public string forecastModelDataFile;
        public string temporalAdjustmentAtMonitorGrid;
        public string startMonitorYear;
        public string endMonitorYear;
        public string baseModelYear;
        public string minYearsForValidVisibilityMonitors;
        /// <summary>
        /// 是否生产新Forecast IMPROVE Data文件
        /// </summary>    
        public bool isCreateForecastIMPROVEData;
        /// <summary>
        /// 是否利用新生成的Forecast IMPROVE Data文件，重新跑
        /// </summary>
        public bool isCheckedForecastIMPROVEAdvanced;
        /// <summary>
        /// 新Forecast IMPROVE Data文件
        /// </summary>
        public string forecastIMPROVEDataFile;

    }

    public class BatchSSIAAnnual : BatchBase
    {
        public string scenarioName;
        public bool doCumulativeImpactAnalysis;
        public bool useGridAndDispersion;
        public bool useGridOnly;
        public bool useDispersionOnly;
        public bool doDailyModelDataInput;
        public bool doQuarterlyModelDataInput;
        public bool doInputFromCmaq;
        public string baselineModelDataFile;
        public string alternativeModelDataFile;
        public string dispersionFile;
        public string officialDataFile;
        public string officialPM25StartYear;
        public string officialPM25EndYear;
        public bool doVNA;
        public bool doEVNA;
        public string temporalAdjustmentAtMonitorGrid;
        public string NAAQS;
        public string threshold;
        public int startPercentage;
        public int endPercentage;
    }

    public class BatchSSIADaily : BatchBase
    {
        public string scenarioName;
        public bool doCumulativeImpactAnalysis;
        public bool useGridAndDispersion;
        public bool useGridOnly;
        public bool useDispersionOnly;
        public bool doDailyModelDataInput;
        public bool doQuarterlyModelDataInput;
        public bool doInputFromCmaq;
        public string baselineModelDataFile;
        public string alternativeModelDataFile;
        public string dispersionFile;
        public string officialDataFile;
        public string temporalAdjustmentAtMonitorGridPoint;
        public string temporalAdjustmentAtMonitorGridSpatial;
        public string temporalAdjustmentType;
        public bool RRF_DoUseXTopPercent;
        public int RRF_UseXTopPercent;
        public bool RRF_DoUseAllModelDaysGreaterThan;
        public int RRF_UseAllModelDaysGreaterThan;
        public int RRF_MinumumNumberOfDaysRequiredAboveFixedAmount;
        public bool RRF_DoUseTopXNumber;
        public int RRF_UseTopXNumber;
        public string monitorDataStartYear;
        public string monitorDataEndYear;
        public string NAAQS;
        public string threshold;
        public int startPercentage;
        public int endPercentage;
        public bool useEVNA;
        public bool useVNA;
    }

    public class BatchSSIAOzone : BatchBase
    {
        public string scenarioName;
        public bool doCumulativeImpactAnalysis;
        public bool doInputFromCmaq;
        public string baselineModelDataFile;
        public string alternativeModelDataFile;
        public string monitorDataFile;
        public string ozoneStartYear;
        public string ozoneEndYear;
        public bool doVNA;
        public bool doEVNA;
        public string temporalAdjustmentAtMonitorGrid;
        public string temporalAdjustmentType;
        public string NAAQS;
        public string threshold;
        public int startPercentage;
        public int endPercentage;
    }

    public class BatchSSIADeposition : BatchBase
    {
        public string scenarioName;
        public string baselineModelDataFile;
        public string alternativeModelDataFile;
        public string NAAQS;
        public string threshold;
    }    //added by Lijiabin

    public class BatchAnnualPMChina : BatchBase
    {
        public string scenarioName;
        public bool doDailyModelDataInput;
        public bool doQuarterlyModelDataInput;
        public bool doInputFromCmaq;
        public string baselineModelDataFile;
        public string futureModelDataFile;
        public bool doQuarterlyMonitorDataInput;
        public bool doDailyMonitorDataInput;
        public string PMMonitorDataFile;
        public string monitorStartYear;
        public string monitorEndYear;
        public bool doVNA;
        public bool doEVNA;
        public bool PM25SpeciesFractionDataAvailable;
        public string SpeciesMonitorDataFile;
        public string gridDefinitionFile;
        public string temporalAdjustmentAtMonitorGrid;//1x1或3x3网格相对变化
    }
    /// <summary>
    /// Other region Annual PM
    /// add by sclong
    /// 2017-06-09
    /// </summary>
    public class BatchAnnualPMOther : BatchBase
    {
        public string scenarioName;
        public bool doDailyModelDataInput;
        public bool doQuarterlyModelDataInput;
        public bool doInputFromCmaq;
        public string baselineModelDataFile;
        public string futureModelDataFile;
        public bool doQuarterlyMonitorDataInput;
        public bool doDailyMonitorDataInput;
        public string PMMonitorDataFile;
        public string monitorStartYear;
        public string monitorEndYear;
        public bool doVNA;
        public bool doEVNA;
        public bool PM25SpeciesFractionDataAvailable;
        public string SpeciesMonitorDataFile;
        public string gridDefinitionFile;
        public string temporalAdjustmentAtMonitorGrid;//1x1或3x3网格相对变化
    }

    public class BatchOzoneChina : BatchBase
    {
        public string scenarioName;
        public bool doInputfromCmaq;
        public string baselineModelDataFile;
        public string forecastModelDataFile;
        public string ozoneMonitorDataFile;
        public string ozoneStartYear;
        public string ozoneEndYear;
        public bool useVNA;
        public bool useEVNA;
    }

    /// <summary>
    /// For other countries
    /// </summary>
    public class BatchOzoneOther : BatchBase
    {
        public string scenarioName;
        public bool doInputfromCmaq;
        public string baselineModelDataFile;
        public string forecastModelDataFile;
        public string ozoneMonitorDataFile;
        public string ozoneStartYear;
        public string ozoneEndYear;
        public bool useVNA;
        public bool useEVNA;
        public string gridDefinitionFile;
    }

    public class BatchBenMapAnnualPM : BatchBase
    {
        public string scenarioName;
        public bool doDailyModelDataInput;
        public bool doQuarterlyModelDataInput;
        public bool doInputFromCmaq;
        public string baselineModelDataFile;
        public string forecastModelDataFile;
        public string temporalAdjustmentAtMonitorGridSpatial;
        public string unofficialMonitorDataFile;
        public string unofficialStartYear;
        public string unofficialEndYear;
        public bool doVNA;
        public bool doEVNA;
        public bool doSpeciesMonitorDataFile;
        public string speciesMonitorDataFile;
        public bool doSpeciesFractionFile;
        public string specFracSpatialFile;
        public string gradAdjSpecFracSpatialFile;
        public string speciesStartYear;
        public string speciesEndYear;
        public string gridDefinitionFile;
    }

    public class BatchBenMapOzone : BatchBase
    {
        public string scenarioName;
        public bool doInputFromCmaq;
        public string baselineModelDataFile;
        public string alternativeModelDataFile;
        public string monitorDataFile;
        public string ozoneStartYear;
        public string ozoneEndYear;
        public bool doVNA;
        public bool doEVNA;
        public string gridDifinition;
        //public string temporalAdjustmentAtMonitorGrid;
        //public string temporalAdjustmentType;
    }
    #endregion

    public enum enumAnalysis
    {
        AnnualPM = 1, DailyPM = 2, Ozone = 3, Visibility = 4, SSIAAnnualPM = 5, SSIADailyPM = 6, SSIAOzone = 7, AnnualPMChina = 8, OzoneChina = 9, BenMAPAnnualPM = 10, BenMAPSeasonalOzone = 11, SSIADeposition = 12, AnnualPMOther = 13, OzoneOther = 14
    }

    public enum enumSaveProjectOrRun
    {
        SaveProject = 1, SaveRunProject = 2
    }

    public enum enumRunAnalysis
    {
        RunAnnualPM = 1, RunDailyPM = 2, RunOzone = 3, RunVisibility = 4
    }
}
