﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml;

namespace SMAT_CE
{
    public static class ConfigurationWorker
    {
        /// <summary>
        /// 获取xml数据
        /// </summary>
        /// <param name="xmlPath"></param>
        /// <returns>key为各个工具名字，ABaCAS,ICET,RSM,SMAT,BenMAP等，Value为对应工具里面具体配置，d</returns>
        public static Dictionary<string, Dictionary<string, string>> GetDataFromXML(string xmlPath)
        {
            var result = new Dictionary<string, Dictionary<string, string>>();
            try
            {
                XmlDocument xmlDoc = new XmlDocument();

                if (!File.Exists(xmlPath))
                {
                    string[] p = xmlPath.Split(new string[1] { "Default" }, StringSplitOptions.RemoveEmptyEntries);
                    xmlPath = Application.StartupPath + @"\Default" + p[1];
                    if (!File.Exists(xmlPath))
                    {
                        xmlPath = CommonClass.ResultFilePath + @"\Default" + p[1];
                    }
                }
                if (!File.Exists(xmlPath))
                {
                    return null;
                }
                xmlDoc.Load(xmlPath);
                XmlNode xn = xmlDoc.SelectSingleNode("Settings");
                XmlNodeList xnl = xn.ChildNodes;
                foreach (XmlNode xnf in xnl)
                {
                    XmlElement xe = (XmlElement)xnf;
                    result.Add(xe.Name, new Dictionary<string, string>());
                    XmlNodeList xnfABACAS = xe.ChildNodes;
                    foreach (XmlNode xn2 in xnfABACAS)
                    {
                        if (xn2.Name.Contains("File") && !File.Exists(xn2.InnerText))//文件路径不存在时需要替换为本地用户的数据目录
                        {
                            string actualTxt = xn2.InnerText.ToLocal();
                            result[xe.Name].Add(xn2.Name, actualTxt);
                        }
                        else
                        {
                            result[xe.Name].Add(xn2.Name, xn2.InnerText);
                        }
                    }//  foreach (XmlNode xn2 in xnfABACAS)

                }// foreach (XmlNode xnf in xnl)
            }
            catch (Exception ex)
            {
                result = null;
                CommonClass.LogError(ex);
            }
            return result;
        }

    }



}
