using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class ConfigurationManagement : FormBase
    {
        public ConfigurationManagement()
        {
            InitializeComponent();
        }

        private void ConfigurationManagement_Load(object sender, EventArgs e)
        {
            try
            {
                this.rbtnCreateCfg.Checked = true;
                this.BackColor = Color.FromArgb(225, 225, 225);
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            try
            {
                if (rbtnCreateCfg.Checked == true)
                {
                    CommonClass.CreateCFG = true;
                    this.DialogResult = DialogResult.OK;
                }
                else
                {
                    CommonClass.CreateCFG = false;
                    this.DialogResult = DialogResult.OK;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            try
            {
                DialogResult result = MessageBox.Show("Cancel this operation?", "Tip", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                if (result == DialogResult.No)
                {
                    return;
                }
                if (result == DialogResult.Yes)
                {
                    this.Close();
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
