﻿using System.Collections;
using System.Collections.Generic;

namespace SMAT_CE.DownscaleR.AnnualPM
{
    /// <summary>
    /// Annual PM DS output data
    /// </summary>
    public class AnnualPMDSOutput
    {
        /// <summary>
        /// Id
        /// </summary>
        public string Id { get; set; }
        /// <summary>
        /// Latitude
        /// </summary>
        public double Lat { get; set; }
        /// <summary>
        /// Longitude
        /// </summary>
        public double Lon { get; set; }
        /// <summary>
        /// Quarterly Value
        /// </summary>
        public Dictionary<string, AnnualPMDSQuarterlyValue> DicQuarterlyDSValue { get; set; }
    }
    /// <summary>
    /// Annual PM DS output quarterly data
    /// </summary>
    /// <remarks>
    /// XXX_Base: model base value;
    /// XXX_DS_Prediction: ds prediction value(equals VNA & eVNA);
    /// XXX_DS_Sepred: ds sepred value(no use temporarily);
    /// </remarks>
    public class AnnualPMDSQuarterlyValue
    {
        /// <summary>
        /// SO4_Base
        /// </summary>
        public double SO4_Base { get; set; }
        /// <summary>
        /// SO4_DS_Prediction
        /// </summary>
        public double SO4_DS_Prediction { get; set; }
        /// <summary>
        /// SO4_DS_Sepred
        /// </summary>
        public double SO4_DS_Sepred { get; set; }
        /// <summary>
        /// NO3R_Base
        /// </summary>
        public double NO3R_Base { get; set; }
        /// <summary>
        /// NO3R_DS_Prediction
        /// </summary>
        public double NO3R_DS_Prediction { get; set; }
        /// <summary>
        /// NO3R_DS_Sepred
        /// </summary>
        public double NO3R_DS_Sepred { get; set; }
        /// <summary>
        /// OCB_Base
        /// </summary>
        public double OCB_Base { get; set; }
        /// <summary>
        /// OCB_DS_Prediction
        /// </summary>
        public double OCB_DS_Prediction { get; set; }
        /// <summary>
        /// OCB_DS_Sepred
        /// </summary>
        public double OCB_DS_Sepred { get; set; }
        /// <summary>
        /// EC_Base
        /// </summary>
        public double EC_Base { get; set; }
        /// <summary>
        /// EC_DS_Prediction
        /// </summary>
        public double EC_DS_Prediction { get; set; }
        /// <summary>
        /// EC_DS_Sepred
        /// </summary>
        public double EC_DS_Sepred { get; set; }
        /// <summary>
        /// Crustal_Base
        /// </summary>
        public double Crustal_Base { get; set; }
        /// <summary>
        /// Crustal_DS_Prediction
        /// </summary>
        public double Crustal_DS_Prediction { get; set; }
        /// <summary>
        /// Crustal_DS_Sepred
        /// </summary>
        public double Crustal_DS_Sepred { get; set; }
        /// <summary>
        /// Salt_Base
        /// </summary>
        public double Salt_Base { get; set; }
        /// <summary>
        /// Salt_DS_Prediction
        /// </summary>
        public double Salt_DS_Prediction { get; set; }
        /// <summary>
        /// Salt_DS_Sepred
        /// </summary>
        public double Salt_DS_Sepred { get; set; }
        /// <summary>
        /// NO3_Base
        /// </summary>
        public double NO3_Base { get; set; }
        /// <summary>
        /// NO3_DS_Prediction
        /// </summary>
        public double NO3_DS_Prediction { get; set; }
        /// <summary>
        /// NO3_DS_Sepred
        /// </summary>
        public double NO3_DS_Sepred { get; set; }
        /// <summary>
        /// NH4_Base
        /// </summary>
        public double NH4_Base { get; set; }
        /// <summary>
        /// NH4_DS_Prediction
        /// </summary>
        public double NH4_DS_Prediction { get; set; }
        /// <summary>
        /// NH4_DS_Sepred
        /// </summary>
        public double NH4_DS_Sepred { get; set; }
        /// <summary>
        /// DON_Base
        /// </summary>
        public double DON_Base { get; set; }
        /// <summary>
        /// DON_DS_Prediction
        /// </summary>
        public double DON_DS_Prediction { get; set; }
        /// <summary>
        /// DON_DS_Sepred
        /// </summary>
        public double DON_DS_Sepred { get; set; }
        /// <summary>
        /// PM25_Base
        /// </summary>
        public double PM25_Base { get; set; }
        /// <summary>
        /// PM25_DS_Prediction
        /// </summary>
        public double PM25_DS_Prediction { get; set; }
        /// <summary>
        /// PM25_DS_Sepred
        /// </summary>
        public double PM25_DS_Sepred { get; set; }
        /// <summary>
        /// PBW_Base
        /// </summary>
        public double PBW_Base { get; set; }
        /// <summary>
        /// PBW_DS_Prediction
        /// </summary>
        public double PBW_DS_Prediction { get; set; }
        /// <summary>
        /// PBW_DS_Sepred
        /// </summary>
        public double PBW_DS_Sepred { get; set; }
    }
}
