﻿
namespace SMAT_CE.DownscaleR.AnnualPM
{
    /// <summary>
    /// Annual PM monitor data
    /// </summary>
    public class AnnualPMMonitor
    {
        private string _id;
        private double _lat;
        private double _lon;
        private double _pm;
        private string _quarter;
        /// <summary>
        /// Initialize the annual pm monitor data with some given values
        /// </summary>
        /// <param name="id">Id</param>
        /// <param name="lat">Latitude</param>
        /// <param name="lon">Longitude</param>
        /// <param name="pm">Base value</param>
        /// <param name="quarter">Quarter</param>
        public AnnualPMMonitor(string id, double lat, double lon, double pm, string quarter)
        {
            _id = id;
            _lat = lat;
            _lon = lon;
            _pm = pm;
            _quarter = quarter;
        }
        /// <summary>
        /// Id
        /// </summary>
        public string Id
        {
            get { return _id; }
            set { _id = value; }
        }
        /// <summary>
        /// Latitude
        /// </summary>
        public double Lat
        {
            get { return _lat; }
            set { _lat = value; }
        }
        /// <summary>
        /// Longitude
        /// </summary>
        public double Lon
        {
            get { return _lon; }
            set { _lon = value; }
        }
        /// <summary>
        /// Base value
        /// </summary>
        public double PM
        {
            get { return _pm; }
            set { _pm = value; }
        }
        /// <summary>
        /// Quarter
        /// </summary>
        public string Quarter
        {
            get { return _quarter; }
            set { _quarter = value; }
        }
    }
}
