﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SMAT_CE.DownscaleR
{
    /// <summary>
    /// DownscaleR设置
    /// </summary>
    public class CommonSettings : ICloneable
    {
        /// <summary>
        /// 初始化
        /// </summary>
        public CommonSettings()
        {
            _numit = 2500;
            _burn = 500;
            _thin = 1;
            _cmaqres = 12;
            _multithreading = false;
            _modelfilepath = null;
        }
        private int _numit;
        private int _burn;
        private int _thin;
        private int _cmaqres;
        private bool _multithreading;
        private string _modelfilepath;
        /// <summary>
        /// Desired number of MCMC draws
        /// 默认：2500
        /// </summary>
        public int Numit
        {
            get { return _numit; }
            set { _numit = value; }
        }
        /// <summary>
        /// Desired Burn-in time
        /// 默认：500
        /// </summary>
        public int Burn
        {
            get { return _burn; }
            set { _burn = value; }
        }
        /// <summary>
        /// Thin every
        /// 默认：1
        /// </summary>
        public int Thin
        {
            get { return _thin; }
            set { _thin = value; }
        }
        /// <summary>
        /// km resolution of the numerical model data：4, 12, 36；
        /// 默认：12
        /// </summary>
        public int Cmaqres
        {
            get { return _cmaqres; }
            set { _cmaqres = value; }
        }
        /// <summary>
        /// DS multithreading computing;
        /// 默认：false
        /// </summary>
        public bool MultiThreading
        {
            get { return _multithreading; }
            set { _multithreading = value; }
        }
        /// <summary>
        /// Model file path;
        /// 默认：null
        /// </summary>
        public string ModelFilePath
        {
            get { return _modelfilepath; }
            set { _modelfilepath = value; }
        }
        /// <summary>
        /// 克隆
        /// </summary>
        public object Clone()
        {
            return new CommonSettings()
            {
                Numit = _numit,
                Burn = _burn,
                Thin = _thin,
                Cmaqres = _cmaqres,
                MultiThreading = _multithreading,
                ModelFilePath = _modelfilepath
            };
        }
    }
}
