﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SMAT_CE.DownscaleR
{
    /// <summary>
    /// mcmc output data
    /// </summary>
    public class MCMC
    {
        private double _beta0;
        private double _beta1;
        private double _sigma2b0;
        private double _tau2;
        /// <summary>
        /// Initialize the downscaler mcmc output data with some given values
        /// </summary>
        /// <param name="beta0">beta0</param>
        /// <param name="beta1">beta1</param>
        /// <param name="sigma2b0">sigma2b0</param>
        /// <param name="tau2">tau2</param>
        public MCMC(double beta0, double beta1, double sigma2b0, double tau2)
        {
            _beta0 = beta0;
            _beta1 = beta1;
            _sigma2b0 = sigma2b0;
            _tau2 = tau2;
        }
        /// <summary>
        /// beta0
        /// </summary>
        public double beta0
        {
            get { return _beta0; }
            set { _beta0 = value; }
        }
        /// <summary>
        /// beta1
        /// </summary>
        public double beta1
        {
            get { return _beta1; }
            set { _beta1 = value; }
        }
        /// <summary>
        /// sigma2b0
        /// </summary>
        public double sigma2b0
        {
            get { return _sigma2b0; }
            set { _sigma2b0 = value; }
        }
        /// <summary>
        /// tau2
        /// </summary>
        public double tau2
        {
            get { return _tau2; }
            set { _tau2 = value; }
        }
    }
}
