﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SMAT_CE.Matlab
{
    /// <summary>
    /// 回归显著性检验
    /// regstats 结果专用
    /// </summary>
    public class LinearRegression
    {
        /// <summary>
        /// 构造函数
        /// </summary>
        public LinearRegression()
        {
            Coefficients = new Coefficients();
        }
        /// <summary>
        /// 回归平方和 regression sum of squares
        /// </summary>
        public double RegressionSumOfSquares { get; set; }
        /// <summary>
        /// 回归方差 regression variance
        /// </summary>
        public double RegressionVariance { get; set; }
        /// <summary>
        /// 剩余平方和 residual sum of square
        /// </summary>
        public double ResidualSumOfSquares { get; set; }
        /// <summary>
        /// 剩余方差 residual variance
        /// </summary>
        public double ResidualVariance { get; set; }
        /// <summary>
        /// 离差平方和 sum of squares of deviations
        /// </summary>
        public double SumOfSquaresOfDeviations { get; set; }
        /// <summary>
        /// 标准误差 standard error
        /// </summary>
        public double StandardError { get; set; }
        /// <summary>
        /// F检验 verification f
        /// </summary>
        public double VerificationF { get; set; }
        /// <summary>
        /// 相关系数 correlation coefficient
        /// </summary>
        public double CorrelationCoefficient { get; set; }
        /// <summary>
        /// 回归系数
        /// Y = item1 + item2 * X1
        /// </summary>
        public Coefficients Coefficients { get; set; }
    }
    /// <summary>
    /// 回归系数，暂时只有一元线性回归
    /// </summary>
    public class Coefficients
    {
        public double Item1 { get; set; }
        public double Item2 { get; set; }
    }
}
