﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SMAT_CE.Matlab
{
    /// <summary>
    /// Float 数值比较器
    /// </summary>
    public class SingleComparer : IComparer<float>
    {
        /// <summary>
        /// 初始化排序类型
        /// </summary>
        /// <param name="type">排序类型</param>
        public SingleComparer(SortType type)
        {
            _type = type;
        }

        // 默认升序
        private SortType _type;

        // IComparer<float> 成员
        public int Compare(float x, float y)
        {
            if (_type == SortType.Descend)
            {
                return y.CompareTo(x);
            }
            return x.CompareTo(y);
        }
    }
}
