using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.Configuration;
using System.IO;

namespace SMAT_CE
{
    public partial class Options : FormBase
    {
        public Options()
        {
            InitializeComponent();
        }

        private void Options_Load(object sender, EventArgs e)
        {
            try
            {
                string strPath=CommonClass.ResultFilePath + @"\SMAT.exe.config";
                if (!File.Exists(strPath))
                {
                    //File.Copy(Application.ExecutablePath + ".config", strPath);
                    FileStream fs = new FileStream(strPath, FileMode.Create);
                    StreamWriter sw = new StreamWriter(fs, Encoding.UTF8);
                    sw.WriteLine(@"<?xml version=""1.0""?>");
                    sw.WriteLine("<configuration>                                                                                          ");
                    sw.WriteLine("  <startup>                                                                                              ");
                    sw.WriteLine(@"    <supportedRuntime version=""v4.0"" sku="".NETFramework,Version=v4.0"" />                                 ");
                    sw.WriteLine("  </startup>                                                                                             ");
                    sw.WriteLine("  <appSettings>                                                                                          ");
                    sw.WriteLine(@"    <add key=""IncludeChina"" value=""F"" />                                                                 ");
                    sw.WriteLine(@"    <add key=""ShowSSIA"" value=""T"" />                                                                     ");
                    sw.WriteLine(@"    <add key=""IncludeTaiwan"" value=""F"" />                                                                ");
                    sw.WriteLine(@"    <add key=""ShowLanguage"" value=""F"" />                                                                ");
                    sw.WriteLine(@"    <add key=""BenMAP-CEpath"" value=""" + Application.StartupPath + @"\..\BenMAP-CE\BenMAP.exe"" /> ");
                    sw.WriteLine("  </appSettings>                                                                                         ");
                    sw.WriteLine("</configuration>                                                                                         ");
                    sw.Flush();
                    sw.Close();
                    fs.Close();
                }
                string isShow = "T";
                XmlDocument doc = new XmlDocument();
                doc.Load(strPath);//Application.ExecutablePath + ".config");
                XmlNode node = doc.SelectSingleNode(@"//add[@key='IncludeChina']");
                XmlElement ele = (XmlElement)node;
                isShow = ele.GetAttribute("value");
                chkIncludeChina.Checked = isShow == "T" ? true : false;

                node = doc.SelectSingleNode(@"//add[@key='IncludeTaiwan']");
                ele = (XmlElement)node;
                isShow = ele.GetAttribute("value");
                chkIncludeTaiwan.Checked = isShow == "T" ? true : false;

                node = doc.SelectSingleNode(@"//add[@key='ShowSSIA']");
                ele = (XmlElement)node;
                isShow = ele.GetAttribute("value");
                chkShowSSIA.Checked = isShow == "T" ? true : false;
                if (LanguageOld.IsSMATChina)
                    chkShowSSIA.Enabled = false;

                node = doc.SelectSingleNode(@"//add[@key='ShowLanguage']");
                if (node == null)
                {
                    node = doc.DocumentElement.SelectSingleNode("appSettings"); 
                    ele = doc.CreateElement("add");
                    ele.SetAttribute("key", "ShowLanguage");
                    ele.SetAttribute("value", "F");
                    node.AppendChild(ele);
                    doc.Save(strPath);
                    chkShowLanguage.Checked = false;
                }
                else
                {
                    ele = (XmlElement)node;
                    isShow = ele.GetAttribute("value");
                    chkShowLanguage.Checked = isShow == "T" ? true : false;
                }

            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            UpdateConfig("IncludeChina", chkIncludeChina.Checked == true ? "T" : "F");
            UpdateConfig("ShowSSIA", chkShowSSIA.Checked == true ? "T" : "F");
            UpdateConfig("IncludeTaiwan", chkIncludeTaiwan.Checked ? "T" : "F");
            UpdateConfig("ShowLanguage", chkShowLanguage.Checked ? "T" : "F");

            this.DialogResult = DialogResult.OK;
        }

        private void UpdateConfig(string appSettings, string Xvalue)
        {
            string strPath = CommonClass.ResultFilePath + @"\SMAT.exe.config";
            XmlDocument doc = new XmlDocument();
            doc.Load(strPath);//Application.ExecutablePath + ".config");
            XmlNode node = doc.SelectSingleNode(@"//add[@key='" + appSettings + "']");
            XmlElement ele = (XmlElement)node;
            ele.SetAttribute("value", Xvalue);
            //System.IO.File.Delete(Application.ExecutablePath + ".config");
            doc.Save(strPath);//Application.ExecutablePath + ".config");
            ConfigurationManager.RefreshSection("appSettings");
        }
    }
}
