using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class SaveAs : FormBase
    {
        public SaveAs()
        {
            InitializeComponent();
            
            #region added by Yangwenwei
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }

        private void SaveAs_Load(object sender, EventArgs e)
        {
            try
            {
                this.BackColor = Color.FromArgb(225, 225, 225);
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private Form _currentForm = null;
        private void btnOK_Click(object sender, EventArgs e)
        {
            try
            {
                string msg = "";
                if ((txtFileName.Text != "" && txtFileName.Text.Length > 0) && (txtDirectory.Text != "" && txtDirectory.Text.Length > 0) && Directory.Exists(txtDirectory.Text))
                {
                    this.Hide();
                    _currentForm = new SMAT_CE();
                    (_currentForm as SMAT_CE).ExtractAllOutput(txtFileName.Text, txtDirectory.Text);
                    this.Close();
                    MessageBox.Show(LanguageOld.Translate("Save all files successfully!"));
                }
                else
                {
                    if (txtFileName.Text.Length == 0 || txtFileName.Text == "")
                        msg = LanguageOld.Translate("Please enter file name!");
                    else
                        if (!Directory.Exists(txtDirectory.Text))
                            msg = LanguageOld.Translate("File directory does not exist!");
                        else
                            msg = LanguageOld.Translate("Please select directory!");
                }
                if (msg != "")
                {
                    MessageBox.Show(msg);
                    return;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            try
            {
                //DialogResult result = MessageBox.Show("Cancel this operation?", "Tip", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                //if (result == DialogResult.No)
                //{
                //    return;
                //}
                //if (result == DialogResult.Yes)
                //{
                this.Close();
                //}
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnBrowser_Click(object sender, EventArgs e)
        {
            try
            {
                FolderBrowserDialog folderBrowserDialog = new FolderBrowserDialog();
                if (folderBrowserDialog.ShowDialog() != DialogResult.OK)
                    return;
                txtDirectory.Text = folderBrowserDialog.SelectedPath;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
