using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_BenMAP_AnnualPM_SpeciesData : UserControl
    {
        string path = string.Empty;

        public uc_BenMAP_AnnualPM_SpeciesData()
        {
            InitializeComponent();
        }

        private void btnOpenMonitorFileA_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.speciesMonitorFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.speciesMonitorFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.speciesMonitorFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                openfile.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    //_fileName = openfile.FileName;
                    CommonClass.speciesMonitorFile = openfile.FileName;
                    txtMonitorFileA.Text = Path.GetFileName(CommonClass.speciesMonitorFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                    cboEndYearA.DataSource = null;
                    cboStartYearA.DataSource = null;
                    bool isOK = CommonClass.getmonitorYear("uc_BenMAP_AnnualPM_SpeciesData");
                    if (!isOK)
                    {
                        MessageBox.Show("Species Monitor Data File is ill-formatted data!");
                    }
                    else
                    {
                        List<string> year = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.lstSpeciesYear;
                        cboStartYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.lstSpeciesYear.Distinct().ToList();
                        cboEndYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.lstSpeciesYear.Distinct().ToList();

                        if (cboStartYearA.Items.Count >= 9)
                            cboStartYearA.SelectedIndex = 8;
                        else
                            cboStartYearA.SelectedIndex = cboStartYearA.Items.Count - 1;
                        if (cboEndYearA.Items.Count >= 11)
                            cboEndYearA.SelectedIndex = 10;
                        else
                            cboEndYearA.SelectedIndex = cboEndYearA.Items.Count - 1;
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnFractionPointA_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.speciesFractionFilePoint) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.speciesFractionFilePoint)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.speciesFractionFilePoint);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                openfile.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.speciesFractionFilePoint = openfile.FileName;
                    txtFractionSpatialA.Text = Path.GetFileName(CommonClass.speciesFractionFilePoint);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnFractionSpatialA_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.speciesFractionFileSpatial) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.speciesFractionFileSpatial)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.speciesFractionFileSpatial);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                openfile.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.speciesFractionFileSpatial = openfile.FileName;
                    txtgradadjFractionSpatialA.Text = Path.GetFileName(CommonClass.speciesFractionFileSpatial);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnMonitorFileA_CheckedChanged(object sender, EventArgs e)
        {
            ChangeSpeciesDataMode();
        }

        private void rbtnFractionA_CheckedChanged(object sender, EventArgs e)
        {
            ChangeSpeciesDataMode();
        }

        void ChangeSpeciesDataMode()
        {
            if (rbtnMonitorFileA.Checked)
            {
                txtMonitorFileA.Enabled = true;
                btnOpenMonitorFileA.Enabled = true;
                lblSpatialField.Enabled = false;
                txtFractionSpatialA.Enabled = false;
                btnFractionPointA.Enabled = false;
                lblGradAdjSpatialField.Enabled = false;
                txtgradadjFractionSpatialA.Enabled = false;
                btnFractionSpatialA.Enabled = false;
            }
            else
            {
                txtMonitorFileA.Enabled = false;
                btnOpenMonitorFileA.Enabled = false;
                lblSpatialField.Enabled = true;
                txtFractionSpatialA.Enabled = true;
                btnFractionPointA.Enabled = true;
                lblGradAdjSpatialField.Enabled = true;
                txtgradadjFractionSpatialA.Enabled = true;
                btnFractionSpatialA.Enabled = true;
            }
        }
    }
}
