using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_BenMAP_GridDefinition : UserControl
    {
        string path = string.Empty;

        public uc_BenMAP_GridDefinition()
        {
            InitializeComponent();
        }

        private void btnOpenShapefile_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.shapefile) || !Directory.Exists(Path.GetDirectoryName(CommonClass.shapefile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"Data\ShapeFiles";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.shapefile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = "Select file...";
                // Application.StartupPath + @"\Data\SampleData";
                openfile.Filter = "SHP Files(*.shp)|*.shp";
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.shapefile = openfile.FileName;
                    txtGridDefinition.Text = Path.GetFileName(CommonClass.shapefile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;//remember the last directory 
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
