using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_BenMap_Ozone_ModelData : UserControl
    {
        public uc_BenMap_Ozone_ModelData()
        {
            InitializeComponent();
        }
         string path = "";

        private void btnChooseModelFile_Click(object sender, EventArgs e)
        {
            try
            {
                Button btn = sender as Button;
                string tag = btn.Tag.ToString().ToLower();
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    switch (tag)
                    {
                        case "baseline":
                            if (string.IsNullOrEmpty(CommonClass.baseModelFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.baseModelFile)))
                            {
                                openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                            }
                            else
                            {
                                openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.baseModelFile);
                            }
                            break;
                        case "forecast":
                            if (string.IsNullOrEmpty(CommonClass.futureModelFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.futureModelFile)))
                            {
                                openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                            }
                            else
                            {
                                openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.futureModelFile);
                            }
                            break;
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = "Select file...";
                //openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                string filter = "";
                if (choCMAQOzone.Checked == true)
                {
                    filter = "All Files(*.*)|*.*";
                }
                else
                {
                    filter = "CSV Files(*.csv)|*.csv";
                }
                openfile.Filter = filter;
                openfile.RestoreDirectory = true;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    switch (tag)
                    {
                        case "baseline":
                            CommonClass.baseModelFile = openfile.FileName;
                            txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                            break;
                        case "forecast":
                            CommonClass.futureModelFile = openfile.FileName;
                            txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                            break;
                    }
                    path = Path.GetDirectoryName(openfile.FileName);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
