using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_BenMap_Ozone_MonitorData : UserControl
    {
        public uc_BenMap_Ozone_MonitorData()
        {
            InitializeComponent();
            choChangedHeightAndTop();
        }
        private void choVNA_CheckedChanged(object sender, EventArgs e)
        {
            if (!choVNA.Checked)
            {
                if (!choEVNA.Checked)
                {
                    choEVNA.Checked = true;
                }
            }
        }

        private void choEVNA_CheckedChanged(object sender, EventArgs e)
        {
            if (!choEVNA.Checked)
            {
                if (!choVNA.Checked)
                {
                    choVNA.Checked = true;
                }
            }
        }

        private void btnOzoneData_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(CommonClass.ozoneMonitorFile) || !Directory.Exists(Path.GetDirectoryName(CommonClass.ozoneMonitorFile)))
                {
                    openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                }
                else
                {
                    openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.ozoneMonitorFile);
                }
                openfile.Title = "Select file...";
                // Application.StartupPath + @"\Data\SampleData";
                openfile.Filter = "CSV Files(*.csv)|*.csv";
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.ozoneMonitorFile = openfile.FileName;
                    txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);
                    openfile.RestoreDirectory = true;
                    cboEndYearOzone.Items.Clear();
                    cboStartYearOzone.Items.Clear();
                    bool isOK = CommonClass.getmonitorYear("");
                    if (!isOK)
                    {
                        MessageBox.Show("Ozone Monitor Data File is ill-formatted data!");
                    }
                    else
                    {
                        List<string> year = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.lstOzoneMonitorData;
                        for (int i = 0; i < year.Count; i++)
                        {
                            cboStartYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                            cboEndYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                        }

                        if (cboStartYearOzone.Items.Count >= 5)
                            cboStartYearOzone.SelectedIndex = 4;
                        else
                            cboStartYearOzone.SelectedIndex = cboStartYearOzone.Items.Count - 1;
                        if (cboEndYearOzone.Items.Count >= 7)
                            cboEndYearOzone.SelectedIndex = 6;
                        else
                            cboEndYearOzone.SelectedIndex = cboEndYearOzone.Items.Count - 1;
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void uc_MonitorDataInputO_Load(object sender, EventArgs e)
        {
            cboGridOzone.Items.Add("1x1");
            cboGridOzone.Items.Add("3x3");
            cboGridOzone.Items.Add("5x5");
            cboGridOzone.Items.Add("7x7");
            cboStatisticOzone.Items.Add("Mean");
            cboStatisticOzone.Items.Add("Maximum");
            cboStatisticOzone.Items.Add("Maximum-paired in space");
        }

        private void cboStartYearOzone_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (cboEndYearOzone.SelectedIndex<0|| cboStartYearOzone.SelectedIndex<0)
                {
                    return;
                }
                if (Convert.ToInt32(cboEndYearOzone.Text.Substring(0, 4)) < Convert.ToInt32(cboStartYearOzone.Text.Substring(0, 4)))
                    cboEndYearOzone.Text = cboStartYearOzone.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboEndYearOzone_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (cboEndYearOzone.SelectedIndex < 0 || cboStartYearOzone.SelectedIndex < 0)
                {
                    return;
                }
                if (Convert.ToInt32(cboEndYearOzone.Text.Substring(0, 4)) < Convert.ToInt32(cboStartYearOzone.Text.Substring(0, 4)))
                    cboStartYearOzone.Text = cboEndYearOzone.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        public void choChangedHeightAndTop()
        {
            bool DS = true, DSadvance = true;
            DS = chkDS.Checked;
            DSadvance = chkDSAdvance.Checked;

            //the default location when all controls are expanded
            int thisheight = 492;
            //int pnlTopHeight = 517;
            //int pnlVNATop = 102;
            //int choEVNATop = 133;
            //int pnlEVNATop = 183;
            int chkDSTop = 227;
            int pnlDSTop = 269;
            int pnlDSAdvanceTop = 357;
            //int pnlBottom = 526;

            //Calculate the new location
            //top
            int delta = 0;
            //if (!VNA) delta = choEVNATop - pnlVNATop;
            //choEVNATop -= delta;
            //pnlEVNATop -= delta;
            //if (!eVNA) delta = chkDSTop - pnlEVNATop;
            //chkDSTop -= delta;
            //pnlDSTop -= delta;
            //pnlDSAdvanceTop -= delta;
            if (!DS)
            {
                delta = thisheight - pnlDSTop;
                //pnlTopHeight -= delta;
                thisheight -= delta;
            }
            else if (!DSadvance)
            {
                delta = thisheight - pnlDSAdvanceTop;
                //pnlTopHeight -= delta;
                thisheight -= delta;
            }

            //Bottom
            //pnlBottom -= delta;
            //thisheight -= delta;

            //reset the locations of Controls            
            this.Height = thisheight;
            //panel_Top.Height = pnlTopHeight;
            //choIAdjustedFRMSpeA.Top = choEVNATop;
            //panelEvna.Top = pnlEVNATop;
            chkDS.Top = chkDSTop;
            panelDS.Top = pnlDSTop;
            pnlDSAdvance.Top = pnlDSAdvanceTop;
            //panel_bottom.Top = pnlBottom;

        }

        private void chkDS_CheckedChanged(object sender, EventArgs e)
        {
            choChangedHeightAndTop();
        }

        private void chkDSAdvance_CheckedChanged(object sender, EventArgs e)
        {
            choChangedHeightAndTop();
        }
    }
}
