﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_ModelDataInputDep : UserControl
    {
        string path = "";
        public uc_ModelDataInputDep()
        {
            InitializeComponent();
        }

        private void btnBaselineDep_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.baseModelFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.baseModelFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData\SSIA\Deposition";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.baseModelFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = "Select file...";
                string filter = "";
                //if (rbtnCMAQA.Checked == true)
                //{
                //    filter = "All Files(*.*)|*.*";
                //}
                //else
                {
                    filter = "CSV Files(*.csv)|*.csv";
                }
                openfile.Filter = filter;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.baseModelFile = openfile.FileName;
                    txtBaselineDep.Text = Path.GetFileName(CommonClass.baseModelFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnForecastDep_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.futureModelFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.futureModelFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData\Deposition";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.futureModelFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = "Select file...";
                string filter = "";
                //if (rbtnCMAQA.Checked == true)
                //{
                //    filter = "All Files(*.*)|*.*";
                //}
                //else
                {
                    filter = "CSV Files(*.csv)|*.csv";
                }
                openfile.Filter = filter;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.futureModelFile = openfile.FileName;
                    txtForecastDep.Text = Path.GetFileName(CommonClass.futureModelFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnSource_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {

                    if (string.IsNullOrEmpty(CommonClass.ssiasourcefile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.ssiasourcefile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData\Deposition";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.ssiasourcefile);
                    }

                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = "Select file...";
                string filter = "";
                filter = "CSV Files(*.csv)|*.csv";
                //filter = "CSV Files(*.csv)|*.csv";
                openfile.Filter = filter;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.ssiasourcefile = openfile.FileName;
                    txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
