using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_ModelDataInputO : UserControl
    {
        string path = "";
        public uc_ModelDataInputO()
        {
            InitializeComponent();
        }

        private void btnChooseModelFile_Click(object sender, EventArgs e)
        {
            try
            {
                Button btn = sender as Button;
                string tag = btn.Tag.ToString().ToLower();
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    switch (tag)
                    {
                        case "baseline":
                            if (string.IsNullOrEmpty(CommonClass.baseModelFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.baseModelFile)))
                            {
                                openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                            }
                            else
                            {
                                openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.baseModelFile);
                            }
                            break;
                        case "forecast":
                            if (string.IsNullOrEmpty(CommonClass.futureModelFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.futureModelFile)))
                            {
                                openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                            }
                            else
                            {
                                openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.futureModelFile);
                            }
                            break;
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = "Select file...";
                //openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                string filter = "";
                if (choCMAQOzone.Checked == true)
                {
                    filter = "All Files(*.*)|*.*";
                }
                else
                {
                    filter = "CSV Files(*.csv)|*.csv";
                }
                openfile.Filter = filter;
                openfile.RestoreDirectory = true;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    switch (tag)
                    {
                        case "baseline":
                            CommonClass.baseModelFile = openfile.FileName;
                            txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                            break;
                        case "forecast":
                            CommonClass.futureModelFile = openfile.FileName;
                            txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                            break;
                    }
                    path = Path.GetDirectoryName(openfile.FileName);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnSource_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {

                    if (string.IsNullOrEmpty(CommonClass.ssiasourcefile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.ssiasourcefile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.ssiasourcefile);
                    }

                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = "Select file...";
                string filter = "";
                filter = "CSV Files(*.csv)|*.csv";
                //filter = "CSV Files(*.csv)|*.csv";
                openfile.Filter = filter;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.ssiasourcefile = openfile.FileName;
                    txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
