using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_MonitorDataInputA : UserControl
    {
        public uc_MonitorDataInputA()
        {
            InitializeComponent();
        }

        private void btnOfficialMonitorA_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(CommonClass.officialPMFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.officialPMFile)))
                {
                    openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData\SSIA";
                }
                else
                {
                    openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.officialPMFile);
                }
                openfile.Title = "Select file...";
                openfile.Filter = "CSV Files(*.csv)|*.csv";
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.officialPMFile = openfile.FileName;
                    txtOfficialMonitorA.Text = Path.GetFileName(CommonClass.officialPMFile);
                    openfile.RestoreDirectory = true;
                    cboEndYearA.DataSource = null;
                    cboStartYearA.DataSource = null;
                    bool isOK = CommonClass.getmonitorYear("");
                    if (!isOK)
                    {
                        MessageBox.Show("Official Quarterly Average FRM Data File is ill-formatted data!");
                    }
                    else
                    {
                        List<string> year = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears;
                        cboStartYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                        cboEndYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();

                        if (cboStartYearA.Items.Count >= 7)
                            cboStartYearA.SelectedIndex = 6;
                        else
                            cboStartYearA.SelectedIndex = cboStartYearA.Items.Count - 1;
                        if (cboEndYearA.Items.Count >= 11)
                            cboEndYearA.SelectedIndex = 10;
                        else
                            cboEndYearA.SelectedIndex = cboEndYearA.Items.Count - 1;
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choVNA_CheckedChanged(object sender, EventArgs e)
        {
            if (!choVNA.Checked)
            {
                if (!choEVNA.Checked)// && choEVNA.Enabled)
                {
                    choEVNA.Checked = true;
                }
            }
        }

        private void choEVNA_CheckedChanged(object sender, EventArgs e)
        {
            if (!choEVNA.Checked)
            {
                if (!choVNA.Checked)
                {
                    choVNA.Checked = true;
                }
            }
        }

        private void cboStartYearA_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboEndYearA.Text) < Convert.ToInt32(cboStartYearA.Text))
                    cboEndYearA.Text = cboStartYearA.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboEndYearA_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboEndYearA.Text) < Convert.ToInt32(cboStartYearA.Text))
                    cboStartYearA.Text = cboEndYearA.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void uc_MonitorDataInputA_Load(object sender, EventArgs e)
        {
            cboPointGridA.Items.Add("1x1");
            //cboPointGridA.Items.Add("3x3");
            //cboPointGridA.Items.Add("5x5");
            //cboPointGridA.Items.Add("7x7");
        }
    }
}
