using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class uc_FilteringV : ucBase
    {
        public uc_FilteringV()
        {
            InitializeComponent();

            #region Language added by Yangwenwei
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }

        private void lblChooseYears_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_4_3_filtering.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblValidVisibilityMonitors_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_4_3_filtering.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboStartYearVisibility_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboStartYearVisibility.Text) > Convert.ToInt32(cboEndYearVisibility.Text))
                    MessageBox.Show(LanguageOld.Translate("End Year should be later than Start Year."));
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboEndYearVisibility_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboStartYearVisibility.Text) > Convert.ToInt32(cboEndYearVisibility.Text))
                    MessageBox.Show(LanguageOld.Translate("End Year should be later than Start Year."));
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboBaseYearVisibility_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboBaseYearVisibility.Text) < Convert.ToInt32(cboStartYearVisibility.Text)
                    || Convert.ToInt32(cboBaseYearVisibility.Text) > Convert.ToInt32(cboEndYearVisibility.Text))
                    MessageBox.Show(LanguageOld.Translate("Base Model Year should be between Start Year and End Year."));
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
