
### Read in MATS output file with design values and monitor information

a <- "/work/ROMO/2016platform/CAMx_v7.10/2023gf_ussa_apca_lnox_GEOS_Chem/12US2/postp_tools/rrfcalc_leap/mats.nwXm.2023gf.csv"

mats <- read.csv(file=a,skip=1,header=F,col.names=c("site","latitude","longitude","bdv","fdv","bdvmax","fdvmax","refcell","rrf","ppb","days","state","county"),colClasses=c("character",rep("numeric",10),rep("character",2)))

head(mats)
mats.sub <- mats[c("site","state","county","bdv","bdvmax","fdv","fdvmax")]
head(mats.sub)
final <- mats.sub


tags <- c("001","002","003","004","005","006","007","008","009","010","011","012","013","014","015","016","017","018","019","020","021","022","023","024","025","026","027","028","029","030","031","032","033","034","035","036","037","038","039","040","041","042","043","044","045","046","047","048","049","050","051","052","053","054","055","056")

for (i in 1:length(tags)) {

### Add tagged contributions to the file

a <- paste("/work/ROMO/2016platform/CAMx_v7.10/2023gf_ussa_apca_lnox_GEOS_Chem/12US2/tables_leap/newsite/contrib.nwXm.12US2.QQCASEQQ_tag",tags[i],".QQRRFTESTQQ.txt",sep="")

b <- read.table(file=a,skip=0,header=F,col.names=c("site","contrib","latitude","longitude","bdv","bdvmax","fdv","fdvmax","rrf","n","cut","i","j","maxval","nsil","nthreshold","source_tag"),colClasses=c("character",rep("numeric",14),rep("character",1)))

head(b)
temp <- b[c("source_tag")]
source <- unique(temp)
print(source)
one <- b[c("site","nthreshold")]
colnames(one)[2] <- source

final <- merge(final,one,by=c("site"),all.x=FALSE,all.y=FALSE)

}


### Output final table

head(final)

write.table(final, file='/work/ROMO/2016platform/CAMx_v7.10/2023gf_ussa_apca_lnox_GEOS_Chem/12US2/tables_leap/newsite/2023gf.ozonecontrib_nthreshold_finaltable_QQCASEQQ.QQRRFTESTQQ.csv', sep=",",row.names=FALSE)

