#!/bin/csh -f

# Programmer: Jonathan Petters
# Revision History:  First used October 8, 2003
#	Modified to do CMAQ test run of January and July with new met data
#            December 29, 2003
#       Modified to merge CAMx files for January, and use SMK2EMIS
#         to convert merged file to binary
#            Januray 27, 2004
#    
# C. Allen, 12/27/06-1115a: Modified for the 2002 "bud" platform
# C. Allen, 2/20/07-1207p: Modified for use on amber
# C. Allen, 4/5/07-833a: Modified for 2002ac (new biogenics; different date settings)

setenv MRG_ONE        Y   
setenv MRG_TWO        Y   
setenv MRG_BIO        Y    #Y to merge biogenics (Petters)
setenv MRG_POINT      Y 

setenv RUN_LAST       N 
setenv RUN_FIRST      Y 

setenv MRG_DIFF_DAYS  Y
setenv RUN_M3STAT     Y

setenv scenario 2002ac
setenv mrg_run 2002ac
setenv grid 36km
setenv spec cmaq_cb05pm
setenv platform v3

setenv WORK /orchid/oaqps

setenv rootdir /work/ozl/OAQPS/SMK_merge
setenv LOGROOTDIR $WORK/2002/smoke/intermed/${platform}/${scenario}
setenv MYBIN /work/ozl/bin
setenv MBIN $WORK/2002/smoke/subsys/${platform}/smoke23/Linux2_x86ifc
setenv TOOLS $WORK/2002/smoke/subsys/${platform}/ioapi/Linux2_x86ifc
setenv indir $WORK/2002/smoke/intermed/${platform}
setenv MODELREADY $WORK/2002/cmaq_emis/$grid/${platform}/$mrg_run
setenv REPORTS $WORK/2002/smoke/reports/${platform}/$scenario/mrggrid

set BIOGENICS = /orchid/oaqps/2002/smoke/intermed/v3

# C. Allen: These are input directories to zip afterwards (usually the daily point sources)
setenv dir_zip1 $WORK/2002/smoke/intermed/${platform}/2002ac/ptnonipm
setenv dir_zip2 $WORK/2002/smoke/intermed/${platform}/2002ac/ptipm
setenv dir_zip3 $WORK/2002/smoke/intermed/${platform}/2002ac/ptfire
setenv dir_zip4 $WORK/2002/smoke/intermed/${platform}/2002ac/othpt

#setenv CHLOR_DIR /gpfs/work/ozl/OAQPS/cmaq_model_save_01h_36km/chlor_2

if (! -d $MODELREADY) then
  mkdir -p $MODELREADY
endif

if (! -d $REPORTS) then
  mkdir $REPORTS
endif

setenv SMK_DATES $rootdir/smk_dates_2002

setenv EDSS_ROOT $rootdir
setenv EDSS_OS AIX64
setenv RUN_FMRG $MBIN

# C. Allen: Use "Month 13" for December 2001 spinup
set daysinmonth = ( 31 28 31  30  31  30  31  31  30   31  30 31 31)
set months = ( 13 1 2 3 4 5 6 7 8 9 10 11 12 )

#if running m3stat, enter unique IDENTIFIER 
if ($RUN_M3STAT == 'Y') then
   setenv IDENTIFIER group1
   setenv OUTPUT $REPORTS/m3stat.mr_$IDENTIFIER.$mrg_run.$grid.$$.rpt
   if (-e $OUTPUT) then
      rm -f $OUTPUT
   endif
endif

#SET VARIABLES FOR MRG_ONE EMISSIONS
set sector_2   = (1      2      3         4     )
set source_2   = (2002ac 2002ac 2002ac    2002ac)
set type_2     = (ag     afdust nonptfire ptfire)

#SET VARIABLES FOR MRG_TWO EMISSIONS
set sector  =  (1      2       3      4      5      6     )
set source  =  (2002ac 2002ac  2002ac 2002ac 2002ac 2002ac)
set type    =  (nonpt  nonroad onroad alm    othar  othon )

#SET VARIABLES FOR MRG_POINT EMISSIONS
set sector_3   =  (1      2        3     ) 
set source_3   =  (2002ac 2002ac   2002ac)
set type_3     =  (ptipm  ptnonipm othpt )
#SET VARIABLES FOR BIOGENIC EMISSIONS
#set BIOGENICS = /gpfs/work/ozl/OAQPS/data/run_bg_01ah/output/cb4p25


foreach month ($months)

   if ($month < 10) then
      set month = 0${month}
   else
      set month = $month
   endif

set daysmonth = $daysinmonth[$month]
if ($month == 13) then #spinup
  set date_counter = 22
  echo "Spinup dates"
#else if ($month == 06) then
#  set date_counter = 21
##  set daysmonth = 27
#  echo "June spinup dates"
#else if ($month == 08) then
#  set date_counter = 22
##  set daysmonth = 23
#  echo "Starting with 22-Aug"
else
  set date_counter = 1
  echo "starting with 1st of month"
endif
# set date_counter = 1

#if ($RUN_LAST == 'Y') then
#@    date_counter = $daysmonth - 9
#endif

#if ($RUN_FIRST == 'Y') then
#@    daysmonth = $daysmonth - 10
#endif

if ($month == 13) then
  setenv DATAFILE $SMK_DATES/smk_merge_dates_200112.txt
else
  setenv DATAFILE $SMK_DATES/smk_merge_dates_2002$month.txt
endif

while ($date_counter <= $daysmonth)
   
   if ($date_counter < 10) then
      set day = 0${date_counter}
   else
      set day = $date_counter
   endif   
      
   if ($month == 13) then
      set esdate = 200112${day}
      set biodir = 2001ab
   else
      set esdate = 2002${month}${day}
      set biodir = 2002ab
   endif

   setenv ESDATE $esdate
   setenv LOGFILE /dev/null
   set jdate = `$MYBIN/mdy2julian.x `
   setenv JDATE $jdate

   setenv SDATE $jdate
   
   setenv FILELIST $rootdir/FILELIST.$SDATE.$$.dat
	  
   setenv OUTFILE $MODELREADY/emis3d.${mrg_run}.$grid.$ESDATE.ncf
   
   setenv LOGDIR  $LOGROOTDIR/cmaq_logs
   if (! -e $LOGDIR) then
      mkdir -p $LOGDIR
   endif
   setenv LOGFILE $LOGDIR/mrggrid.cmaq.$SDATE.$grid.${mrg_run}.log
   if (-e $LOGFILE) then
      rm $LOGFILE
   endif

   if (-e $FILELIST) then
      rm $FILELIST
   endif
   if ( -e $OUTFILE) then
      rm $OUTFILE
   endif  

   #MERGE US SECTORS
   # Just to explain the different columns in the SMK_DATES files, since two columns have changed over the
   # previous versions used in the SMOKE v2.2 2001 platform.
   # Columns 2 and 4 are for representative days by month. This script only uses column 2, since they are
   # equivalent. This is used by ag, afdust, and nonptfire. Column 4 was kept in the file for legacy.
   # Columns 3 and 5 are for representative days by season, and are not used in the current setup. Again,
   # they were kept for legacy, and in case they are needed later.
   # Column 6 is for "mwdss" - four representative days for the month (Mon, Tue, Sat, Sun), plus holidays.
   # This is used by nonroad and nonpt.
   # Column 7 is the same as Column 6, except without holidays. This is for alm, othar, and othon.
   # This is a change from 2002ab where othar and othon (then called nonptoth and moboth) ran holidays. 
   # Column 8 is for onroad - seven representative days per month (one for each day of the week) plus
   # holidays.
   # Column 9 is daily, and is used by ptipm, ptnonipm, and othpt.
   # Column 10 is for ptfire. It is daily and is the same as Column 9, except for the spinup dates.
   # Unlike for ptipm and ptnonipm, December 2001 files are NOT produced for ptfire. Instead, we use the
   # 2002 file for that date. This is another change from the previous version.
   # Column 11 is not used. I think it was used previously for biogenics.

   if ($MRG_ONE == 'Y') then
   
    foreach sect ($sector_2) 

      if ($sect == 1) then
          set ODATE = {`grep ^$ESDATE $DATAFILE | awk ' { print $2 }' `}
      else if ($sect == 2) then
          set ODATE = {`grep ^$ESDATE $DATAFILE | awk ' { print $2 }' `}
      else if ($sect == 3) then
          set ODATE = {`grep ^$ESDATE $DATAFILE | awk ' { print $2 }' `}
      else if ($sect == 4) then
          set ODATE = {`grep ^$ESDATE $DATAFILE | awk ' { print $10 }' `}  
      endif
      
      setenv OUTDIR $indir/${source_2[$sect]}/${type_2[$sect]}
      setenv INFILE $OUTDIR/emis_mole_${type_2[$sect]}_${ODATE}_${grid}_${spec}_${source_2[$sect]}.ncf

      if (-e $INFILE.gz) then
         gunzip -fv $INFILE.gz
      endif     
      set LNAME = $type_2[$sect]
      echo $LNAME >> $FILELIST
      setenv $LNAME $INFILE
       
    end #foreach sector  
   
   endif

  if ($MRG_TWO == 'Y') then

   foreach sect ($sector) 
      if ($sect == 1) then
          set ODATE = {`grep ^$ESDATE $DATAFILE | awk ' { print $6 }' `}
      else if ($sect == 2) then
          set ODATE = {`grep ^$ESDATE $DATAFILE | awk ' { print $6 }' `}
      else if ($sect == 3) then
          set ODATE = {`grep ^$ESDATE $DATAFILE | awk ' { print $8 }' `}
      else if ($sect == 4) then
          set ODATE = {`grep ^$ESDATE $DATAFILE | awk ' { print $7 }' `}
      else if ($sect == 5) then
          set ODATE = {`grep ^$ESDATE $DATAFILE | awk ' { print $7 }' `}
      else if ($sect == 6) then
          set ODATE = {`grep ^$ESDATE $DATAFILE | awk ' { print $7 }' `}
      endif

      setenv OUTDIR $indir/${source[$sect]}/${type[$sect]}
      setenv INFILE $OUTDIR/emis_mole_${type[$sect]}_${ODATE}_${grid}_${spec}_${source[$sect]}.ncf
      
      if (-e $INFILE.gz) then
         gunzip -fv $INFILE.gz
      endif     
      set LNAME = $type[$sect]
      echo $LNAME >> $FILELIST
      setenv $LNAME $INFILE
       
    end #foreach sector
    
   endif
   
    
     if ($MRG_POINT == 'Y') then

   foreach sect ($sector_3) 
      if ($sect == 1) then
          set ODATE = {`grep ^$ESDATE $DATAFILE | awk ' { print $9 }' `}
      else if ($sect == 2) then
          set ODATE = {`grep ^$ESDATE $DATAFILE | awk ' { print $9 }' `}
      else if ($sect == 3) then
          set ODATE = {`grep ^$ESDATE $DATAFILE | awk ' { print $9 }' `}
      endif

      setenv OUTDIR $indir/${source_3[$sect]}/${type_3[$sect]}
      setenv INFILE $OUTDIR/emis_mole_${type_3[$sect]}_${ODATE}_${grid}_${spec}_${source_3[$sect]}.ncf

      if (-e $INFILE.gz) then
         gunzip -fv $INFILE.gz
      endif     
      set LNAME = $type_3[$sect]
      echo $LNAME >> $FILELIST
      setenv $LNAME $INFILE
       
    end #foreach sector
    
   endif
   
   
   
    #MERGE BIOGENICS
   
   if ($MRG_BIO == 'Y') then

# C. Allen: I don't know if this stuff is needed
#    if ($ESDATE < 20010401) then
#       setenv BDATE 20010101.90
#    else if ($ESDATE < 20010701) then
#       setenv BDATE 20010401.91
#    else if ($ESDATE < 20011001) then
#       setenv BDATE 20010701.92
#    else 
#       setenv BDATE 20011001.92
#    endif    

    setenv INFILE $BIOGENICS/$biodir/bg/b3gts_l_${ESDATE}_1_${grid}_${spec}_${biodir}.ncf

    if (-e $INFILE.gz) then
         gunzip -fv $INFILE.gz
    endif     
    set LNAME = b3_12
    echo $LNAME >> $FILELIST
    setenv $LNAME $INFILE
    
   endif

  setenv PROMPTFLAG FALSE
  
  if ($MRG_DIFF_DAYS == 'Y') then
  
     setenv G_STDATE   $SDATE      # Julian start date
     setenv G_STTIME   000000      # start time (HHMMSS)
     setenv G_TSTEP     10000      # time step  (HHMMSS)
     setenv G_RUNLEN   250000      # run length (HHMMSS)
     setenv REPMRGGRID $REPORTS/mrggrid_dates.$SDATE.$mrg_run.rpt
     
     if (-e $REPMRGGRID) then
	 rm -f $REPMRGGRID
     endif
   
  endif
  
  time $RUN_FMRG/mrggrid
  
  setenv LOG_FILE $LOGFILE
  $rootdir/checklogfile.script
  if ($status != 0) then
     echo ERROR detected in MRGGRID 
     exit (1)
  endif 

  #CLEAN UP FILES
  
  if ($RUN_M3STAT == 'Y') then
     
     setenv LOGDIR  $LOGROOTDIR/m3stat_logs
     if (! -e $LOGDIR) then
        mkdir -p $LOGDIR
     endif
     
     setenv LOGFILE $LOGDIR/m3stat.cmaq.$SDATE.$grid.$mrg_run.log
     if (-e $LOGFILE) then
       rm $LOGFILE
     endif
     
     setenv INFILE $OUTFILE
     setenv REPORT $LOGDIR/m3stat.mr.$ESDATE.$grid.$mrg_run.rpt
   
     if (-e $REPORT) then
        rm -f $REPORT
     endif 
   
     if ( -e m3stat.in) then
        rm -f m3stat.in
     endif
   
     echo INFILE >> m3stat.in
     echo REPORT >> m3stat.in
     echo Y >> m3stat.in
     echo $JDATE >> m3stat.in
     echo 0 >> m3stat.in
     echo 250000 >> m3stat.in
   
     $TOOLS/m3stat < m3stat.in
  
     setenv LOG_FILE $LOGFILE
     $rootdir/checklogfile.script
     if ($status != 0) then
       echo ERROR detected in M3STAT
       exit (1)
     endif
   
     echo $ESDATE >> $OUTPUT
     grep NaN $REPORT >> $OUTPUT
     grep nan $REPORT >> $OUTPUT
     grep Nan $REPORT >> $OUTPUT
     grep naN $REPORT >> $OUTPUT
     grep ' -' $REPORT >> $OUTPUT
    
  endif
  
  gzip -qfv $dir_zip1/e*{$ESDATE}*{$grid}*ncf
  gzip -qfv $dir_zip2/e*{$ESDATE}*{$grid}*ncf
  gzip -qfv $dir_zip3/e*{$ESDATE}*{$grid}*ncf
  gzip -qfv $dir_zip4/e*{$ESDATE}*{$grid}*ncf
#  gzip -qfv $BIOGENICS/*{$SDATE}*ncf
  gzip -qfv $OUTFILE
  
   rm -f $FILELIST

@                date_counter = ($date_counter + 1)
end #while loop 
end #foreach month

exit (1)
