#!/bin/csh -f
#BSUB 0:30

# Version @(#)$Id$
# Path    $Source$
# Date    $Date$

# This script sets up needed environment variables for running alm sector
# source emissions in SMOKE for the EPA 2002v3CAP modeling platform, and calls the scripts 
# that runs the SMOKE programs. 
#
# Script created by : M. Houyoux, Environmental Protection Agency
# 11/22/2006
#
#*********************************************************************

# set Assigns file name
setenv ASSIGNS_FILE /orchid/oaqps/2002/smoke/subsys/v3/smoke23/assigns/ASSIGNS.2002ac.cmaq.cb05p25.36km
source $ASSIGNS_FILE

# set source category
setenv SMK_SOURCE A           # source category to process
setenv MRG_SOURCE A           # source category to merge
setenv MRG_CTLMAT_MULT ' '    # [A|P|AP] for merging with multiplier controls
setenv MRG_CTLMAT_REAC ' '    # [A|M|P|AMP] for merging with reactivity controls

## month-dependent programs
setenv RUN_SMKINVEN  Y        #  run inventory import program
setenv RUN_SPCMAT    Y        #  run speciation matrix program
setenv RUN_GRDMAT    Y        #  run gridding matrix program

## time-dependent programs
setenv RUN_TEMPORAL  Y       #  run temporal allocation program
setenv RUN_SMKMERGE  Y        #  run merge program
setenv RUN_SMK2EMIS  N        #  run conversion of 2-d to UAM binary

## quality assurance
setenv RUN_SMKREPORT Y        # Y runs reporting for state reports
setenv BUD_REPORTS   N        # Y copies smkreport output to bud
setenv BUD_INSTALL   /bud2

## Program-specific controls...

## For Smkinven
setenv FILL_ANNUAL          N  # Y fills annual value when only average day is provided
setenv RAW_DUP_CHECK        Y  # Y errors on duplicate records
setenv SMK_BASEYR_OVERRIDE  0  # Enter year of the base year when future-year inven provided
setenv SMK_NHAPEXCLUDE_YN   N  # Y uses NonHAP exclusions file
setenv SMKINVEN_FORMULA    "PMC=PM10-PM2_5" # Internal PMC calculation
setenv WEST_HSPHERE         Y  # Y converts ALL stack coords to western hemisphere
setenv WKDAY_NORMALIZE      N  # Y normalizes weekly profiles by weekdays
setenv WRITE_ANN_ZERO       N  # Y writes 0 values to SMOKE intermediate inventory
setenv SMK_ARTOPNT_YN       Y  # Y use area-to-point file during import
#     OUTZONE              # see multiple-program controls, below
#     REPORT_DEFAULTS      # see multiple-program controls, below

## For Grdmat
setenv SMK_DEFAULT_SRGID    100     # default surrogate code (8=popl'n)

## For Spcmat
setenv POLLUTANT_CONVERSION Y     # Y uses ROG to TOG file, for example
#     REPORT_DEFAULTS         # see multiple-program controls, below

# For Temporal
setenv RENORM_TPROF         Y     # Y renormalizes temporal profiles
setenv UNIFORM_TPROF_YN     N     # Y makes all temporal profiles uniform
setenv ZONE4WM              Y     # Y uses time zones for start of day & month
#     OUTZONE                 # see multiple-program controls, below
#     REPORT_DEFAULTS         # see multiple-program controls, below
#     SMK_AVEDAY_YN           # see multiple-program controls, below
#     Date/time settings      # in Assigns file

# For Smkmerge
setenv SMKMERGE_CUSTOM_OUTPUT Y        # Y allows AOUT, BOUT, MOUT, and POUT
setenv MRG_TEMPORAL_YN      Y          # Y merges with hourly emissions
setenv MRG_SPCMAT_YN        Y          # Y merges with speciation matrix
setenv MRG_GRDOUT_YN        Y          # Y outputs gridded file
setenv MRG_REPSTA_YN        N          # Y outputs state totals
setenv MRG_REPCNY_YN        N          # Y outputs county totals
setenv MRG_GRDOUT_UNIT      moles/s    # units for gridded output file
setenv MRG_TOTOUT_UNIT      moles/day  # units for state and/or county totals
setenv MRG_REPORT_TIME      230000     # hour in OUTZONE for reporting emissions
setenv MRG_MARKETPEN_YN     N          # apply reac. controls market penetration
#     SMK_AVEDAY_YN               # see multiple-program controls

# For Smk2emis
setenv SMK2EMIS_VMAP_YN     N     # Y uses name remapping file

# Multiple-program controls
setenv OUTZONE              0     # output time zone of emissions
setenv REPORT_DEFAULTS      N     # Y reports default profile application
setenv SMK_DEFAULT_TZONE    5     # time zone to fix in missing COSTCY file
setenv SMK_AVEDAY_YN        N     # Y uses average day emissions instead of annual
setenv SMK_MAXWARNING       100   # maximum number of warnings in log file
setenv SMK_MAXERROR         900000   # maximum number of errors in log file
setenv USE_SPEED_PROFILES   N     # Y uses speed profiles instead of inventory speeds
setenv FULLSCC_ONLY         Y     # Y only matches profiles by full SCCs

# Script settings
setenv SECTOR             alm 
setenv SRCABBR            alm     # abbreviation for naming log files
setenv PROMPTFLAG         N       # Y (never set to Y for batch processing)
setenv AUTO_DELETE        Y       # Y deletes SMOKE I/O API output files (recommended)
setenv AUTO_DELETE_LOG    Y       # Y automatically deletes logs without asking
setenv DEBUGMODE          N       # Y changes script to use debugger
setenv DEBUG_EXE          pgdbg     # Sets the debugger to use when DEBUGMODE = Y

setenv RUN_HOLIDAYS       N       # Y = run holiday dates in temporal loop
setenv L_TYPE             mwdss   # Type for running temporal: aveday, mwdss, week, or all
setenv M_TYPE             mwdss   # Type for running Smkmerge: aveday, mwdss, week, or all
setenv IOAPI_ISPH         19
setenv SPINUP_DURATION    10      # 10 days for 36-km grid, 3 days for 12-km
# setenv RESTART_JDATE      2002008 # Set to Julian date for restarting run

##############################################################################

unsetenv DISPLAY

switch ( $# )
   case 0:
   case 1:
      echo "SCRIPT ERROR: Script requires -m or -q option with 2 settings."
      echo "  This script expects to be called using one of the following options:"
      echo "     -m <monthlist> <spinup>"
      echo "     -q <quarters> <spinup>"
      echo "  You can only use one option or the other."
      echo "  Examples:"
      echo "     <script name> -m '1 2 3' N: runs script for Jan, Feb, & Mar "
      echo "                                 with no spinup"
      echo "     <script name> -q 2 Y      : runs script for the 2nd quarter,"
      echo "                                 including spin-up days specified"
      echo "                                 SPINUP_DURATION environment variable."
      exit( 1 )
endsw

## Invoke script to interpret calling arguments
if ( $# == 2 ) then
   source $SCRIPTS/run/set_months.csh $argv[1] "$argv[2]"
   if ( $status == 1 ) exit ( 1 )
else
   source $SCRIPTS/run/set_months.csh $argv[1] "$argv[2]" $argv[3]
   if ( $status == 1 ) exit ( 1 )
endif

set spinup_array = ( $SPINUP_LIST )

## Set up scripting environment variables prior to calling the Assigns file
setenv SUBSECT $SECTOR                   # set variable for input/output names
setenv SRCABBR $SUBSECT                  # set abbreviation for naming log files

## Run Smkinven, Grdmat, and Spcmat

setenv RUN_PART1 Y
source $ASSIGNS_FILE               # Invoke Assigns file
source $SCRIPTS/run/smk_run_v2.csh # Run programs

setenv QA_TYPE  inv                # Used to name the report inputs and outputs
setenv QA_LABEL $SUBSECT           # Used to name the report inputs and outputs
setenv REPLABEL $SUBSECT           # Used internally by Smkreport
source $SCRIPTS/run/qa_run_v3.csh  # Run QA for part 1
setenv RUN_PART1 N

set monname = ( jan feb mar apr may jun jul aug sep oct nov dec )

# /bin/rm -rf check_dates.txt

# Loop through months as determined from calling arguments.
set mc = 0

foreach m ( $MONTHS_LIST ) 

   @ mc = $mc + 1   # month array counter

   setenv RUN_PART2 Y
   setenv MONTH ${monname[$m]}           # set variable for month name

   ## Determine dates to run in this month
   setenv MONTH_ARRAY  $m     # MONTH_ARRAY can have as many months listed as needed
   setenv SPINUP_ARRAY $spinup_array[$mc]

   # Source assigns file BEFORE set_days_v2.csh to set PROCDATES and SMK_RUN_DATES
   source $ASSIGNS_FILE                  # Invoke Assigns file to set new dates

   setenv T_TYPE $L_TYPE                 # Set temporal type to type for temporal
   source $SCRIPTS/run/set_days_v3.csh   # Call script to set dates for run

   # Source assigns file AFTER set_days_v3.csh so that it can use PROCDATES file
   source $ASSIGNS_FILE                  # Invoke Assigns file to set new dates

#   echo "Check Temporal dates:" >> check_dates.txt
#   cat $SMK_RUN_DATES >> check_dates.txt

   ## Run Temporal (using PROCDATES file - run for all days needed in month)
   source $SCRIPTS/run/smk_run_v2.csh       # Run programs
   setenv RUN_PART2 N

   ## Run Smkmerge and Smkreport, and optionally, Smk2emis (for CAMx)

   setenv T_TYPE $M_TYPE                 # Set temporal type to type for merge
   source $SCRIPTS/run/set_days_v3.csh   # Call script to set dates for run

#   echo "Check Smkmerge dates:" >> check_dates.txt
#   cat $SMK_RUN_DATES >> check_dates.txt
#   echo " " >> check_dates.txt

## Determine the number of days to run.
   set ndays = `cat $SMK_RUN_DATES | wc -l`

   set n = 0
   set diff = 0
   set g_stdate_sav = $G_STDATE

   # Loop through days to run during the month.
   while ( $n < $ndays )

      @ n = $n + 1   

      set line = `head -$n $SMK_RUN_DATES | tail -1`
      @ diff = $line[1] - $g_stdate_sav

      setenv G_STDATE_ADVANCE $diff
      source $ASSIGNS_FILE   # Invoke Assigns file to set new dates

      setenv RUN_PART2 Y
      setenv QA_TYPE  temporal           # Used to name the report inputs and outputs
      setenv QA_LABEL $SUBSECT           # Used to name the report inputs and outputs
      setenv REPLABEL $SUBSECT           # Used internally by Smkreport
      source $SCRIPTS/run/qa_run_v3.csh  # Run QA for part 2
      setenv RUN_PART2 N

      setenv RUN_PART4 Y
      source $ASSIGNS_FILE
      source $SCRIPTS/run/smk_run_v2.csh        # Run programs

      # Run m3stat script on Smkmerge output file
      $SCRIPTS/run/m3stat_chk_v2.csh $AOUT

      # Save settings for rerunning Smkmerge to get state totals
      set save_temporal = $RUN_TEMPORAL
      set save_smk2emis = $RUN_SMK2EMIS
      set save_smkreport = $RUN_SMKREPORT
      set save_mrggrd = $MRG_GRDOUT_YN 
      set save_mrgsta = $MRG_REPSTA_YN 
      set save_mrgcny = $MRG_REPCNY_YN
      set save_grdunt = $MRG_GRDOUT_UNIT
      set save_totunt = $MRG_TOTOUT_UNIT
      set save_abbr   = $SRCABBR

      # Reset settings for rerunning Smkmerge
      setenv RUN_TEMPORAL  N        #  run temporal allocation program
      setenv RUN_SMK2EMIS  N        #  run conversion of 2-d to UAM binary
      setenv RUN_SMKREPORT N        # run reporting as defined in qa_run_v2.csh

      setenv MRG_GRDOUT_YN        N          # Y outputs gridded file
      setenv MRG_REPSTA_YN        Y          # Y outputs state totals
      setenv MRG_REPCNY_YN        N          # Y outputs county totals
      setenv MRG_GRDOUT_UNIT      tons/hr    # units for gridded outputs
      setenv MRG_TOTOUT_UNIT      tons/day   # units for state and/or county totals   
      setenv SRCABBR  ${SRCABBR}_rpt

      # Run mass-based Smkmerge reports
      source $ASSIGNS_FILE
      source $SCRIPTS/run/smk_run_v2.csh

      # Reset settings back to original values.
      setenv RUN_TEMPORAL    $save_temporal
      setenv RUN_SMK2EMIS    $save_smk2emis
      setenv RUN_SMKREPORT   $save_smkreport
      setenv MRG_GRDOUT_YN   $save_mrggrd
      setenv MRG_REPSTA_YN   $save_mrgsta
      setenv MRG_REPCNY_YN   $save_mrgcny
      setenv MRG_GRDOUT_UNIT $save_grdunt
      setenv MRG_TOTOUT_UNIT $save_totunt
      setenv SRCABBR $save_abbr

   end

   setenv RUN_PART4 N
   unsetenv G_STDATE_ADVANCE

end  # End loop over parts

#
## Ending of script
#
exit( 0 )

 
