#!/bin/tcsh
#PBS -j oe
#PBS -r n

limit stacksize unlimited

## Manually set directory names [**change**]
setenv SMK_HOME "/amber/work/cvy/WO94.1"
setenv MET_ROOT "/orchid/oaqps/met/MCIP_v3.4b4/MM5_2005b_14aL" # Change to point to your MCIP

setenv CASE "2005ck_05b"
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "0"

## Derived directory and filenames
setenv OUT_ROOT "$SMK_HOME/smoke_out"
setenv IMD_ROOT "$SMK_HOME/intermed"
setenv DAT_ROOT $SMK_HOME
set dirinputs  = "$SMK_HOME/inputs"
set dirscripts = "$SMK_HOME/subsys/smoke24/scripts"
setenv RUNSET "$dirscripts/cases/$CASE/run_settings_$CASE.txt"
setenv ASSIGNS_FILE "$SMK_HOME/subsys/smoke24/assigns/ASSIGNS.emf"

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
setenv EMF_CLIENT false

## Job run file for job: Annual_nonroad_12EUS1

## Parameters -- from Case summary 
setenv MODEL_LABEL "SMOKE2.4"
setenv EMF_GRID "36km, 12km-EUS"
setenv EMF_AQM "CMAQ v4.7 N1c"
setenv EMF_SPC "cmaq_cb05_soa"
setenv BASE_YEAR "2005"
setenv FUTURE_YEAR "2005"
setenv EPI_STDATE_TIME "2005-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2005-12-31 23:59:00.0"

## EMF specific variables - leave alone
setenv EMF_JOBID "7544"
setenv EMF_JOBNAME "Monthly_nonroad_12EUS1"
setenv EMF_USER "bte"
setenv EMF_SCRIPTDIR "${dirscripts}/cases/$CASE"
setenv EMF_SCRIPTNAME "${dirscripts}/cases/$CASE/Monthly_nonroad_12EUS1_${CASE}.csh"
setenv EMF_JOBKEY "7544_1237404676635"

## Ancillary files unlikely to change between sectors
setenv GRIDDESC "${dirinputs}/ge_dat/griddesc_lambertonly_18may2009_v18.txt"
setenv COSTCY "${dirinputs}/ge_dat/costcy_for_2002_10mar2009_v4.txt"
setenv ORISDESC "${dirinputs}/ge_dat/orisdesc_04dec2006_v0.txt"
setenv PSTK "${dirinputs}/ge_dat/pstk_20nov2006_v0.txt"
setenv AGREF "${dirinputs}/ge_dat/amgref_us_can_mex_revised_11mar2010_v8.txt"
setenv MGREF "${dirinputs}/ge_dat/amgref_us_can_mex_revised_11mar2010_v8.txt"
setenv ATREF "${dirinputs}/ge_dat/amptref_v3_3_revised_13mar2009_v1.txt"
setenv MTREF "${dirinputs}/ge_dat/amptref_v3_3_revised_13mar2009_v1.txt"
setenv ATPRO "${dirinputs}/ge_dat/amptpro_2005_us_can_revised_10mar2009_v0.txt"
setenv MTPRO "${dirinputs}/ge_dat/amptpro_2005_us_can_revised_10mar2009_v0.txt"
setenv PTPRO "${dirinputs}/ge_dat/amptpro_2005_us_can_revised_10mar2009_v0.txt"
setenv SICDESC "${dirinputs}/ge_dat/sic_desc_04oct2006_v0.txt"
setenv SCCDESC "${dirinputs}/ge_dat/sccdesc_pf31_03feb2009_v5.txt"
setenv ARTOPNT "${dirinputs}/ge_dat/artopnt_2002detroit_12jul2007_v0.txt"
setenv HOLIDAYS "${dirinputs}/ge_dat/holidays_04may2006_v0.txt"
setenv MCODES "${dirinputs}/ge_dat/mcodes_21nov2008_v1.txt"
setenv MACTDESC "${dirinputs}/ge_dat/mactdesc_2002v3_23apr2008_v1.txt"
setenv NAICSDESC "${dirinputs}/ge_dat/naicsdesc_02jan2008_v0.txt"
setenv GSPROTMP_A "${dirinputs}/ge_dat/gspro_cmaq_cb05_soa_2005ck_05b_19mar2009.txt"
setenv GSREFTMP_A "${dirinputs}/ge_dat/gsref_cmaq_cb05_soa_2005ck_05b_19mar2009.txt"
setenv SRGDESC "${dirinputs}/ge_dat/srgdesc_36km_revised_17mar2009_v1.txt"
setenv MRGDATE_FILES "${dirscripts}/smk_dates/2005/smk_merge_dates_200412.txt"

# Extra inputs set for temperature adjust python scripts
setenv SPC_PARAM "${dirscripts}/parameter_file_cmaq_cb05_soa.txt"
setenv SMK_DATES "${dirscripts}/smk_dates/2005"

## Ancillary files likely to change between sectors
#setenv INVTABLE "${dirinputs}/ge_dat/invtable_hapcapnohapuse_cb05soa_nomp_17mar2009_v4.txt"
setenv INVTABLE "${dirinputs}/ge_dat/invtable_hapcapintegate_cb05soa_nomp_09mar2009_v4.txt"
setenv GSCNV "${dirinputs}/ge_dat/gscnv_cmaq_cb05_tx_pf4_15apr2009_nf_v3.txt"
setenv GSPRO_COMBO "${dirinputs}/ge_dat/gspro_combo_2005_09sep2008_v2.txt"
setenv PTREF "${dirinputs}/ge_dat/amptref_v3_3_revised_13mar2009_v1.txt"
setenv PELVCONFIG "${dirinputs}/ge_dat/pelvconfig_inline_allpts_11apr2008_v0.txt"
setenv REPCONFIG_INV "${dirinputs}/ge_dat/repconfig/default/repconfig_nonroad_inv_caphap_01sep2008_v0.txt"
setenv REPCONFIG_INV2_A "${dirinputs}/ge_dat/repconfig/default/repconfig_nonroad_inv2a_04mar2008_v1.txt"
setenv REPCONFIG_INV2_B "${dirinputs}/ge_dat/repconfig/default/repconfig_nonroad_inv2b_04mar2008_v1.txt"
setenv REPCONFIG_INV2_C "${dirinputs}/ge_dat/repconfig/default/repconfig_nonroad_inv2c_04mar2008_v1.txt"
setenv REPCONFIG_GRID "${dirinputs}/ge_dat/repconfig/default/repconfig_nonroad_invgrid_caphap_11sep2008_v2.txt"
setenv EMISINV_01A "${dirinputs}/$CASE/nonroad/arinv_nonroad_caps_2005v2_jan_revised_05sep2008_v0_orl.txt"
setenv EMISINV_02A "${dirinputs}/$CASE/nonroad/arinv_nonroad_caps_2005v2_feb_revised_08sep2008_v0_orl.txt"
setenv EMISINV_03A "${dirinputs}/$CASE/nonroad/arinv_nonroad_caps_2005v2_mar_revised_08sep2008_v0_orl.txt"
setenv EMISINV_04A "${dirinputs}/$CASE/nonroad/arinv_nonroad_caps_2005v2_apr_revised_08sep2008_v0_orl.txt"
setenv EMISINV_05A "${dirinputs}/$CASE/nonroad/arinv_nonroad_caps_2005v2_may_revised_08sep2008_v0_orl.txt"
setenv EMISINV_06A "${dirinputs}/$CASE/nonroad/arinv_nonroad_caps_2005v2_jun_revised_08sep2008_v0_orl.txt"
setenv EMISINV_07A "${dirinputs}/$CASE/nonroad/arinv_nonroad_caps_2005v2_jul_revised_08sep2008_v0_orl.txt"
setenv EMISINV_08A "${dirinputs}/$CASE/nonroad/arinv_nonroad_caps_2005v2_aug_revised_08sep2008_v0_orl.txt"
setenv EMISINV_09A "${dirinputs}/$CASE/nonroad/arinv_nonroad_caps_2005v2_sep_revised_08sep2008_v0_orl.txt"
setenv EMISINV_10A "${dirinputs}/$CASE/nonroad/arinv_nonroad_caps_2005v2_oct_revised_08sep2008_v0_orl.txt"
setenv EMISINV_11A "${dirinputs}/$CASE/nonroad/arinv_nonroad_caps_2005v2_nov_revised_08sep2008_v0_orl.txt"
setenv EMISINV_12A "${dirinputs}/$CASE/nonroad/arinv_nonroad_caps_2005v2_dec_revised_08sep2008_v0_orl.txt"
setenv EMISINV_01C "${dirinputs}/$CASE/nonroad/arinv_nonroad_calif_caphap_2005v2_jan_02apr2008_v0_orl.txt"
setenv EMISINV_02B "${dirinputs}/$CASE/nonroad/arinv_nonroad_haps_2005v2_feb_revised_05sep2008_v0_orl.txt"
setenv EMISINV_02C "${dirinputs}/$CASE/nonroad/arinv_nonroad_calif_caphap_2005v2_feb_02apr2008_v0_orl.txt"
setenv EMISINV_03C "${dirinputs}/$CASE/nonroad/arinv_nonroad_calif_caphap_2005v2_mar_02apr2008_v0_orl.txt"
setenv EMISINV_03B "${dirinputs}/$CASE/nonroad/arinv_nonroad_haps_2005v2_mar_revised_05sep2008_v0_orl.txt"
setenv EMISINV_04C "${dirinputs}/$CASE/nonroad/arinv_nonroad_calif_caphap_2005v2_apr_02apr2008_v0_orl.txt"
setenv EMISINV_04B "${dirinputs}/$CASE/nonroad/arinv_nonroad_haps_2005v2_apr_revised_05sep2008_v0_orl.txt"
setenv EMISINV_05C "${dirinputs}/$CASE/nonroad/arinv_nonroad_calif_caphap_2005v2_may_02apr2008_v0_orl.txt"
setenv EMISINV_05B "${dirinputs}/$CASE/nonroad/arinv_nonroad_haps_2005v2_may_revised_05sep2008_v0_orl.txt"
setenv EMISINV_06C "${dirinputs}/$CASE/nonroad/arinv_nonroad_calif_caphap_2005v2_jun_02apr2008_v0_orl.txt"
setenv EMISINV_06B "${dirinputs}/$CASE/nonroad/arinv_nonroad_haps_2005v2_jun_revised_05sep2008_v0_orl.txt"
setenv EMISINV_07C "${dirinputs}/$CASE/nonroad/arinv_nonroad_calif_caphap_2005v2_jul_02apr2008_v0_orl.txt"
setenv EMISINV_07B "${dirinputs}/$CASE/nonroad/arinv_nonroad_haps_2005v2_jul_revised_05sep2008_v0_orl.txt"
setenv EMISINV_08C "${dirinputs}/$CASE/nonroad/arinv_nonroad_calif_caphap_2005v2_aug_02apr2008_v0_orl.txt"
setenv EMISINV_09C "${dirinputs}/$CASE/nonroad/arinv_nonroad_calif_caphap_2005v2_sep_02apr2008_v0_orl.txt"
setenv EMISINV_09B "${dirinputs}/$CASE/nonroad/arinv_nonroad_haps_2005v2_sep_revised_05sep2008_v0_orl.txt"
setenv EMISINV_10B "${dirinputs}/$CASE/nonroad/arinv_nonroad_haps_2005v2_oct_revised_05sep2008_v0_orl.txt"
setenv EMISINV_11C "${dirinputs}/$CASE/nonroad/arinv_nonroad_calif_caphap_2005v2_nov_02apr2008_v0_orl.txt"
setenv EMISINV_12C "${dirinputs}/$CASE/nonroad/arinv_nonroad_calif_caphap_2005v2_dec_02apr2008_v0_orl.txt"
setenv EMISINV_12B "${dirinputs}/$CASE/nonroad/arinv_nonroad_haps_2005v2_dec_revised_05sep2008_v0_orl.txt"
setenv EMISINV_08B "${dirinputs}/$CASE/nonroad/arinv_nonroad_haps_2005v2_aug_revised_05sep2008_v0_orl.txt"
setenv EMISINV_01B "${dirinputs}/$CASE/nonroad/arinv_nonroad_haps_2005v2_jan_revised_05sep2008_v0_orl.txt"
setenv EMISINV_10C "${dirinputs}/$CASE/nonroad/arinv_nonroad_calif_caphap_2005v2_oct_02apr2008_v0_orl.txt"
setenv EMISINV_11B "${dirinputs}/$CASE/nonroad/arinv_nonroad_haps_2005v2_nov_revised_05sep2008_v0_orl.txt"
setenv NHAPEXCLUDE "${dirinputs}/ge_dat/nhapexclude_nonroad_pf4_14apr2009_nf_v2.txt"

## Ancillary files likely to change between grids
setenv SECTORLIST "${dirscripts}/cases/$CASE/sectorlist_2005ck_05b_04may2009_v1"

## Ancillary files that aren't online (yet)
setenv ADJ_FACS "${dirinputs}/$CASE/OMOVESPmOcEcTempAdjFactors_10oct2008_nf_v1.csv"

## Parameters -- from job tab
setenv SECTOR "nonroad"

## Parameters -- all sectors
setenv EMF_QUEUE_OPTIONS "-A fedrules -q workq -W group_list=romo -W umask=022"
setenv SPINUP_DURATION_1 "10"
setenv IOAPI_GRIDNAME_1 "36US1_148X112"
setenv SPINUP_DURATION_3 "3"
setenv SPINUP_DURATION_2 "3"
setenv IOAPI_GRIDNAME_2 "12EUS1_279X240"
setenv IOAPI_GRIDNAME_3 "12WUS1_213X192"
setenv GRID_3 "12WUS1"
setenv GRID_2 "12EUS1"
setenv GRID_1 "36US1"
setenv SMK_EMLAYS "10"
setenv SPC "$EMF_SPC"
setenv PLATFORM "v4"
setenv EGU_TYPE "model_performance"
setenv MCIPNAME "MCIP_v3.4beta4"
setenv RUN_PYTHON_ANNUAL "Y"
setenv INLINE_MODE "both"
setenv SMK_PING_METHOD "0"
setenv SMK_SPECELEV_YN "Y"
setenv RAW_DUP_CHECK "Y"
setenv M_TYPE "mwdss"
setenv L_TYPE "mwdss"
setenv RUN_HOLIDAYS "Y"
setenv FULLSCC_ONLY "Y"
setenv SMK_MAXERROR "10"
setenv SMK_MAXWARNING "10"
setenv SMK_AVEDAY_YN "N"
setenv REPORT_DEFAULTS "Y"
setenv SMK_DEFAULT_SRGID "100"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv FILL_ANNUAL "N"
setenv MRG_MARKETPEN_YN "N"
setenv WEST_HSPHERE "Y"
setenv ALL_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv MRG_REPCNY_YN "N"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv OUTZONE "0"
setenv RENORM_TPROF "Y"
setenv POLLUTANT_CONVERSION "Y"
setenv IOAPI_ISPH "19"
setenv MRG_REPSTA_YN "Y"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv OUTPUT_FORMAT "$EMF_AQM"

## Parameters -- sector-specific
#setenv L_TYPE "aveday"
#setenv M_TYPE "aveday"
#setenv RUN_HOLIDAYS "N"
#setenv SMK_DEFAULT_SRGID "340"
setenv NONHAP_TYPE "VOC"
setenv SMKINVEN_FORMULA "EXH__PMC=EXH__PM10-EXH__PM2_5"
#setenv SORT_LIST_EVS "Y"
setenv SMK_NHAPEXCLUDE_YN "Y"
setenv SMK_ARTOPNT_YN "Y"
setenv FILL_ANNUAL "Y"

## job executable
$SMK_HOME/subsys/smoke24/scripts/emf/smk_ar_monthly_emf.csh $GRID_2 $IOAPI_GRIDNAME_2 -m "$RUN_MONTHS" $SPINUP_DURATION jan-dec
if ( $status != 0 ) then
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e' 
	 exit(1)
else
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

