#!/bin/tcsh -f

# Version @(#)$Id$
# Path    $Source$
# Date    $Date$

# This script sets up needed environment variables for running SMOKE point
# sources using daily and/or hourly emissions for 1 or more months.  The
# "onetime" steps are intended to be run in another script. 
# This script is intended to be used with the EMF
# source emissions in SMOKE for the EPA 2002 modeling platform, and
# calls the scripts that runs the SMOKE programs.
# 
# Script created by : M. Houyoux, Environmental Protection Agency
# October, 2007
#
#*********************************************************************
  
## log w/ EMF server that script is running
$EMF_CLIENT -k $EMF_JOBKEY -s "Running"

# set source category
setenv SMK_SOURCE P           # source category to process
setenv MRG_SOURCE $SMK_SOURCE # source category to merge

##############################################################################

switch ( $#argv )
   case 0:
   case 1:
      echo " "
      echo "  This script expects to be called using one of the following argument lists:"
      echo "     <grid abbrv> <run type>"
      echo "     <grid abbrv> <run type>"
      echo " "
      echo "  You can either use one approach or the other (differing by the -m or -q options)."
      echo " "
      echo "  In the above list, the arguments are defined as follows:"
      echo "     <grid abbrv>       : Grid abbreviation (e.g., 36US1)"
      echo "     <run type>         : ADJ or UNADJ for adjusted or unadjusted"
      echo " "
      echo "  Examples:"
      echo "     <script name> 36US1 RUN:"
      echo "              This example runs the script for the entire year"
      echo "              for the 36US1 grid and the runpm reports."
      echo " "
      echo "     <script name> 12EUS1 START:"
      echo "               This example runs the script for the entire year"
      echo "               for the 12EUS1 grid and the startpm reports."
      $EMF_CLIENT -k $EMF_JOBKEY -m "ERROR: smoke script did not receive more than 2 arguments" -t "e"
      exit( 1 )
endsw

# Get the first two options for the grid abbreviation and I/O API grid
setenv GRID "$argv[1]"
setenv RUN_TYPE "$argv[2]"

## source the ASSIGN file
source $ASSIGNS_FILE

## List of all the helper scripts that are run in this script
set emf_cleanup  = $SCRIPTS/run/emf_cleanup.csh
set timetracker  = $SCRIPTS/run/timetracker_v2.csh
set combine_data = $SCRIPTS/run/combine_data_v5.csh
set log_analyzer = $SCRIPTS/log_analyzer/log_analyzer.py
set msg_list     = $SCRIPTS/log_analyzer/known_messages.txt
set duplic_chk   = $SCRIPTS/run/duplicate_check.csh
set python_annl  = $SCRIPTS/annual_report/annual_report.py
set path_parser  = $SCRIPTS/run/path_parser.py

## If running from EMF, move old EMF-created scripts to "old"
if ( $?EMF_JOBID ) then
   source $emf_cleanup
   if ( $status != 0 ) then
        echo "ERROR: running EMF script/log cleanup script"
        $EMF_CLIENT -k $EMF_JOBKEY -m "ERROR: running EMF script/log cleanup script" -t "e" -x $emf_cleanup
        exit ( 1 )
   endif
endif

## Invoke script to interpret calling arguments
## Set naming label
set namelabel = ${SECTOR}_${CASE}_${GRID}

## Record the helper scripts being used
set suffix = _$namelabel.txt
echo "# Helper scripts used for $SECTOR" > $LOGS/helper_scripts_list$suffix
echo $emf_cleanup >> $LOGS/helper_scripts_list$suffix
echo $timetracker >> $LOGS/helper_scripts_list$suffix
echo $combine_data >> $LOGS/helper_scripts_list$suffix
echo $log_analyzer >> $LOGS/helper_scripts_list$suffix
echo $msg_list >> $LOGS/helper_scripts_list$suffix
echo $duplic_chk >> $LOGS/helper_scripts_list$suffix
echo $python_annl >> $LOGS/helper_scripts_list$suffix
echo $path_parser >> $LOGS/helper_scripts_list$suffix

## Set Time Log filename and initialize file
setenv TIMELOG $LOGS/timelog_$namelabel.txt

# Only initialize TIMELOG if it doesn't already exist, since the timeracker
#   can now delete/add entries to prevent duplicates
if ( ! -e $TIMELOG ) then
   $EMF_CLIENT -k $EMF_JOBKEY -m "Initializing Time Log" -x $timetracker  ## log w/ EMF server
   $timetracker Y $TIMELOG
   if ( $status != 0 ) then
        echo "ERROR: running timetracker"
        $EMF_CLIENT -k $EMF_JOBKEY -m "ERROR: running timetracker to initialize time log" -t "e" -x $timetracker
        exit ( 1 )
   endif
endif

## Set up scripting environment variables prior to calling the Assigns file
setenv SUBSECT $SECTOR                   # set variable for input/output names
setenv SRCABBR $SUBSECT                  # set abbreviation for naming log files
setenv EISECTOR $SECTOR

# Call EMF Client for current period
$EMF_CLIENT -k $EMF_JOBKEY -m "Running state and county adjusted reports"    ## log w/ EMF server

/usr/bin/python ${SMK_HOME}/subsys/tempadj/tmp_adj_reports.py
