#!/bin/csh -f

##Manually set directory names [**change**]
setenv SMK_HOME "/garnet/work/bte/WO105.1/tree"
setenv MET_ROOT "/orchid/oaqps/met/MCIP_v3.4b4/MM5_2005b_14aL"  #Change to your MCIP path

setenv CASE "2005ah_tox_05a"
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "0"

## Derived directory and filenames
setenv OUT_ROOT "$SMK_HOME/smoke_out"
setenv IMD_ROOT "$SMK_HOME/intermed"
setenv DAT_ROOT $SMK_HOME
set dirinputs  = "$SMK_HOME/inputs"
set dirscripts = "$SMK_HOME/subsys26/smoke26/scripts"
setenv RUNSET "$dirscripts/cases/$CASE/run_settings_$CASE.txt"
setenv ASSIGNS_FILE "$SMK_HOME/subsys26/smoke26/assigns/ASSIGNS.emf"

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
setenv EMF_CLIENT false

## Job run file for job: Annual_ag_36US1

## EMF specific variables
setenv EMF_JOBID "4301"
setenv EMF_JOBNAME "Annual_ag_36US1"
setenv EMF_USER "cvy"
setenv EMF_SCRIPTDIR "${dirscripts}/cases/${CASE}"
setenv EMF_SCRIPTNAME "${dirscripts}/cases/${CASE}/Annual_ag_36US1_${CASE}__20081216073902.csh"
setenv EMF_JOBKEY "4301_1229431142804"

## Inputs -- for all sectors and all jobs
setenv GRIDDESC "${dirinputs}/${CASE}/../ge_dat/griddesc_lambertonly_23jun2008_v13.txt"
setenv COSTCY "${dirinputs}/${CASE}/../ge_dat/costcy_for_2002_19dec2007_v1.txt"
setenv INVTABLE "${dirinputs}/${CASE}/../ge_dat/invtable_hapcap_cb05soa_12sep2008_v3.txt"
setenv GSCNV "${dirinputs}/${CASE}/../ge_dat/gscnv_cmaq_cb05_tx_pf4_11sep2008_v1.txt"
setenv PELVCONFIG "${dirinputs}/${CASE}/../ge_dat/pelvconfig_inline_allpts_11apr2008_v0.txt"
setenv ORISDESC "${dirinputs}/${CASE}/../ge_dat/orisdesc_04dec2006_v0.txt"
setenv PSTK "${dirinputs}/${CASE}/../ge_dat/pstk_20nov2006_v0.txt"
## surrogate ratios USA 36km = /orchid/oaqps/2002/em_v31/inputs/ge_dat/36km_surg/USA_110_NOFILL.txt
## surrogate ratios MEX 36km = /orchid/oaqps/2002/em_v31/inputs/ge_dat/36km_surg/MEX_11.txt
## surrogate ratios CAN 36km = /orchid/oaqps/2002/em_v31/inputs/ge_dat/36km_surg/CAN_100.txt
## surrogate ratios USA 12km = /orchid/oaqps/2002/em_v31/inputs/ge_dat/12km_surg/USA_100_NOFILL.txt
## surrogate ratios MEX 12km = /orchid/oaqps/2002/em_v31/inputs/ge_dat/12km_surg/MEX_10.txt
## surrogate ratios CAN 12km = /orchid/oaqps/2002/em_v31/inputs/ge_dat/12km_surg/CAN_100.txt
setenv AGREF "${dirinputs}/${CASE}/../ge_dat/amgref_us_can_allmex3_17apr2008_v3.txt"
setenv ATREF "${dirinputs}/${CASE}/../ge_dat/amptref_v3_3_08sep2008_v4.txt"
setenv ATPRO "${dirinputs}/${CASE}/../ge_dat/amptpro_2005_us_can_03apr2008_v1.txt"
setenv PTREF "${dirinputs}/${CASE}/../ge_dat/amptref_v3_3_08sep2008_v4.txt"
setenv PTPRO "${dirinputs}/${CASE}/../ge_dat/amptpro_2005_us_can_03apr2008_v1.txt"
setenv MTREF "${dirinputs}/${CASE}/../ge_dat/amptref_v3_3_08sep2008_v4.txt"
setenv REPCONFIG_INV "${dirinputs}/${CASE}/../ge_dat/repconfig/default/repconfig_area_inv_caphap_08aug2008_v0.txt"
setenv SICDESC "${dirinputs}/${CASE}/../ge_dat/sic_desc_04oct2006_v0.txt"
setenv SCCDESC "${dirinputs}/${CASE}/../ge_dat/sccdesc_pf31_07mar2008_v0.txt"
setenv ARTOPNT "${dirinputs}/${CASE}/../ge_dat/artopnt_2002detroit_12jul2007_v0.txt"
setenv HOLIDAYS "${dirinputs}/${CASE}/../ge_dat/holidays_04may2006_v0.txt"
setenv MTPRO "${dirinputs}/${CASE}/../ge_dat/amptpro_2005_us_can_03apr2008_v1.txt"
setenv MGREF "${dirinputs}/${CASE}/../ge_dat/amgref_us_can_allmex3_17apr2008_v3.txt"
setenv MCODES "${dirinputs}/${CASE}/../ge_dat/mcodes_27nov2006_v0.txt"
setenv GSPRO_COMBO "${dirinputs}/${CASE}/../ge_dat/gspro_combo_2005_09sep2008_v2.txt"
setenv MACTDESC "${dirinputs}/${CASE}/../ge_dat/mactdesc_2002v3_23apr2008_v1.txt"
setenv NAICSDESC "${dirinputs}/${CASE}/../ge_dat/naicsdesc_02jan2008_v0.txt"
setenv REPCONFIG_INV2 "${dirinputs}/${CASE}/../ge_dat/repconfig/default/repconfig_area_inv2_02jan2008_v0.txt"
setenv REPCONFIG_GRID "${dirinputs}/${CASE}/../ge_dat/repconfig/default/repconfig_area_invgrid_caphap_05sep2008_v1.txt"
setenv GSPROTMP_C  "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_pm25_26jun2007_v0.txt"
setenv GSPROTMP_D  "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_tog_nohapuse_cb05_tx_pf4_pretier2_28aug2008_v0.txt"
setenv GSPROTMP_B  "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_sulf_29jun2007_v1.txt"
setenv GSPROTMP_A  "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_static_cmaq_16jul2008_v7.txt"
setenv GSREFTMP_D "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_sulf_09jul2007_v0.txt"
setenv GSREFTMP_F "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_voc_general_27aug2008_v9.txt"
setenv GSREFTMP_K "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_voc_2002_29apr2008_v1.txt"
setenv GSPROTMP_E "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_nox_hono_pf4_06aug2008_v0.txt"
setenv SECTORLIST "${dirinputs}/${CASE}/mrggrid/sectorlist_${CASE}_22sep2008_v0"
setenv SRGDESC "${dirinputs}/${CASE}/../ge_dat/srgdesc_12km_01jun2007_v0.txt"
setenv GSREFTMP_C "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_static_cap_pf4_06aug2008_v0.txt"
setenv GSREFTMP_H "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_static_hap_emv4_10sep2008_v1.txt"
setenv GSREFTMP_J "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_hg_15sep2008_v4.txt"
setenv GSPROTMP_G "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_nonhaptog_cb05_tx_pf4_pretier2_28aug2008_v0.txt"
setenv GSPROTMP_F "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_integratehaps_cb05_tx_pf4_28aug2008_v0.txt"
setenv GSPROTMP_I "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_chromium_28jun2007_v0.txt"
setenv GSPROTMP_J "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_hapmetals_28jun2007_v0.txt"
setenv GSPROTMP_H "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_hg_26nov2007_v2.txt"
setenv GSPROTMP_K "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_dieselpm_12sep2008_v1.txt"
setenv GSPROTMP_L "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_other_hapvoc_10sep2008_v4.txt"
setenv GSREFTMP_E "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_pm25_pf4_nondiesel_02sep2008_v0.txt"
setenv GSREFTMP_M "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_nonhapvoc_2002_09sep2008_v0.txt"
setenv GSREFTMP_L "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_nonhapvoc_general_09sep2008_v0.txt"
setenv GSREFTMP_B "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_static_nox_hono_pf4_23sep2008_v1.txt"

## Inputs -- sector (ag) and all jobs
setenv REPCONFIG_INV "${dirinputs}/${CASE}/../ge_dat/repconfig/default/repconfig_ag_inv_05may2008_v3.txt"
setenv EMISINV "${dirinputs}/${CASE}/ag/arinv_ag_cap2002nei_06nov2006_v0_orl.txt"

## Inputs -- for all sectors and job: Annual ag 36US1

## Inputs -- sector (ag) and job: Annual ag 36US1

## Parameters -- from Case summary 
setenv MODEL_LABEL "SMOKE2.6"
setenv IOAPI_GRIDNAME_1 "US36KM_148X112"
setenv EMF_GRID "36km"
setenv EMF_AQM "CMAQ v4.7 N1b"
setenv EMF_SPC "cmaq_cb05_tx"
setenv BASE_YEAR "2005"
setenv FUTURE_YEAR "2005"
setenv EPI_STDATE_TIME "2005-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2005-12-31 23:59:00.0"
setenv PARENT_CASE "2005ag_tox_05a"

## Parameters -- from job tab
setenv SECTOR "ag"

## Parameters -- all sectors, all jobs 
setenv EMF_QUEUE_OPTIONS "-A fedrules -q romo -W group_list=romo -W umask=022"
setenv IOAPI_GRIDNAME_1 "36US1_148X112"
setenv GRID_1 "36US1"
setenv SPINUP_DURATION_1 "10"
setenv SMK_EMLAYS "10"
setenv PLATFORM "v4"
setenv SPC "$EMF_SPC"
setenv EGU_TYPE "model_performance"
setenv MCIPNAME "MCIP_v3.4beta4"
setenv SMK_MAXWARNING "10"
setenv SMK_PING_METHOD "0"
setenv INLINE_MODE "off"
setenv SMK_AVEDAY_YN "N"
setenv SMK_SPECELEV_YN "Y"
setenv REPORT_DEFAULTS "Y"
setenv SMK_MAXERROR "10"
setenv RUN_PYTHON_ANNUAL "Y"
setenv FULLSCC_ONLY "Y"
setenv FILL_ANNUAL "N"
setenv RUN_HOLIDAYS "Y"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv L_TYPE "mwdss"
setenv RAW_DUP_CHECK "Y"
setenv SMK_DEFAULT_SRGID "100"
setenv M_TYPE "mwdss"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv OUTZONE "0"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv MRG_MARKETPEN_YN "N"
setenv MRG_REPSTA_YN "Y"
setenv WEST_HSPHERE "Y"
setenv IOAPI_ISPH "19"
setenv MRG_REPCNY_YN "N"
setenv OUTPUT_FORMAT "$EMF_AQM"
setenv RENORM_TPROF "Y"
setenv POLLUTANT_CONVERSION "Y"
setenv ALL_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"

## Parameters -- sectors (ag), all jobs 
setenv RUN_HOLIDAYS "N"
setenv L_TYPE "aveday"
setenv M_TYPE "aveday"
setenv SMKINVEN_FORMULA " "

## Parameters -- all sectors, job: Annual ag 36US1

## Parameters -- sectors (ag), job: Annual ag 36US1

## job executable
$EMF_CLIENT -k $EMF_JOBKEY -x $SMK_HOME/subsys26/smoke26/scripts/emf/smk_ar_annual_emf.csh -m "Running top level script for job: Annual_ag_36US1"
$SMK_HOME/subsys26/smoke26/scripts/emf/smk_ar_annual_emf.csh $GRID_1 $IOAPI_GRIDNAME_1  -m "$RUN_MONTHS" $SPINUP_DURATION jan-dec
if ( $status != 0 ) then
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e' 
	 exit(1)
else
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

