#!/bin/csh -f

##Manually set directory names [**change**]
setenv SMK_HOME "/garnet/work/bte/WO105.1/tree"
setenv MET_ROOT "/orchid/oaqps/met/MCIP_v3.4b4/MM5_2005b_14aL"  #Change to your MCIP path

setenv CASE "2005cs_hdghg_05b"
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "0"

## Derived directory and filenames
setenv OUT_ROOT "$SMK_HOME/smoke_out"
setenv IMD_ROOT "$SMK_HOME/intermed"
setenv DAT_ROOT $SMK_HOME
set dirinputs  = "$SMK_HOME/inputs"
set dirscripts = "$SMK_HOME/subsys26/smoke26/scripts"
setenv RUNSET "$dirscripts/cases/$CASE/run_settings_$CASE.txt"
setenv ASSIGNS_FILE "$SMK_HOME/subsys26/smoke26/assigns/ASSIGNS.emf"

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
setenv EMF_CLIENT false

## Job run file for job: Sector_merge_Jan_Jun_36US1

## EMF specific variables
setenv EMF_JOBID "25363"
setenv EMF_JOBNAME "Sector_merge_Jan_Jun_36US1"
setenv EMF_USER "bte"
setenv EMF_SCRIPTDIR "${dirscripts}/cases/${CASE}"
setenv EMF_SCRIPTNAME "${dirscripts}/cases/${CASE}/Sector_merge_Jan_Jun_36US1_mrggrid_${CASE}_20110307070415.csh"
setenv EMF_LOGNAME "${dirscripts}/cases/${CASE}/logs/Sector_merge_Jan_Jun_36US1_mrggrid_${CASE}_20110307070415.log"
setenv EMF_JOBKEY "25363_1299499455576"

## Inputs -- for all regions, all sectors and all jobs
setenv GRIDDESC "${dirinputs}/${CASE}/../ge_dat/griddesc_lambertonly_19oct2010_v33.txt"
setenv COSTCY "${dirinputs}/${CASE}/../ge_dat/costcy_for_2002_21oct2010_v5.txt"
setenv GSCNV "${dirinputs}/${CASE}/../ge_dat/gscnv_cb05_soa_11feb2011_nf_v1.txt"
setenv PELVCONFIG "${dirinputs}/${CASE}/../ge_dat/pelvconfig_inline_allpts_26apr2010_v1.txt"
setenv ORISDESC "${dirinputs}/${CASE}/../ge_dat/orisdesc_04dec2006_v0.txt"
setenv PSTK "${dirinputs}/${CASE}/../ge_dat/pstk_20nov2006_v0.txt"
setenv AGREF "${dirinputs}/${CASE}/../ge_dat/amgref_us_can_mex_revised_07jun2010_v10.txt"
setenv ATREF "${dirinputs}/${CASE}/../ge_dat/amptref_v3_3_revised_10jan2011_v11.txt"
setenv ATPRO "${dirinputs}/${CASE}/../ge_dat/amptpro_2005_us_can_revised_10jan2011_v2.txt"
setenv PTREF "${dirinputs}/${CASE}/../ge_dat/amptref_v3_3_revised_10jan2011_v11.txt"
setenv PTPRO "${dirinputs}/${CASE}/../ge_dat/amptpro_2005_us_can_revised_10jan2011_v2.txt"
setenv MTREF "${dirinputs}/${CASE}/../ge_dat/amptref_v3_3_revised_10jan2011_v11.txt"
setenv REPCONFIG_INV "${dirinputs}/${CASE}/../ge_dat/repconfig/default/repconfig_area_inv_caphap_08aug2008_v0.txt"
setenv SICDESC "${dirinputs}/${CASE}/../ge_dat/sic_desc_04oct2006_v0.txt"
setenv SCCDESC "${dirinputs}/${CASE}/../ge_dat/sccdesc_pf31_23jul2010_v11.txt"
setenv ARTOPNT "${dirinputs}/${CASE}/../ge_dat/artopnt_2002detroit_12jul2007_v0.txt"
setenv HOLIDAYS "${dirinputs}/${CASE}/../ge_dat/holidays_04may2006_v0.txt"
setenv MTPRO "${dirinputs}/${CASE}/../ge_dat/amptpro_2005_us_can_revised_10jan2011_v2.txt"
setenv MGREF "${dirinputs}/${CASE}/../ge_dat/amgref_us_can_mex_revised_07jun2010_v10.txt"
setenv MCODES "${dirinputs}/${CASE}/../ge_dat/mcodes_21nov2008_v1.txt"
setenv GSPRO_COMBO "${dirinputs}/${CASE}/../ge_dat/gspro_combo_2005_23feb2011_v6.txt"
setenv MACTDESC "${dirinputs}/${CASE}/../ge_dat/mactdesc_2002v3_23apr2008_v1.txt"
setenv NAICSDESC "${dirinputs}/${CASE}/../ge_dat/naicsdesc_02jan2008_v0.txt"
setenv REPCONFIG_INV2 "${dirinputs}/${CASE}/../ge_dat/repconfig/default/repconfig_area_inv2_02jan2008_v0.txt"
setenv REPCONFIG_GRID "${dirinputs}/${CASE}/../ge_dat/repconfig/default/repconfig_area_invgrid_caphap_05sep2008_v1.txt"
setenv GSPROTMP_C  "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_pm25_20apr2010_v2.txt"
setenv GSPROTMP_D  "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_tog_cb05_soa_14feb2011_v1.txt"
setenv GSPROTMP_B  "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_sulf_29jun2007_v1.txt"
setenv GSPROTMP_A  "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_static_cmaq_14feb2011_v12.txt"
setenv GSREFTMP_B "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_sulf_09jul2007_v0.txt"
setenv GSREFTMP_F "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_voc_general_hdghg_16feb2011_v2.txt"
setenv GSREFTMP_G "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_voc_2005_hdghg_22feb2011_nf_v3.txt"
setenv GSPROTMP_G "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_nox_hono_pf4_06aug2008_v0.txt"
setenv SECTORLIST "${dirinputs}/${CASE}/mrggrid/sectorlist_${CASE}_03mar2011_v5"
setenv SRGDESC "${dirinputs}/${CASE}/../ge_dat/srgdesc_12km_07jun2010_v2.txt"
setenv GSPROTMP_H "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_hg_26nov2007_v2.txt"
setenv GSREFTMP_A "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_static_cap_pf4_11feb2011_v1.txt"
setenv GSREFTMP_K "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_hg_13apr2010_v8.txt"
setenv GSPROTMP_E "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_nonhaptog_cb05_11feb2011_nf_v1.txt"
setenv GSPROTMP_F "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_integratehaps_cb05_tx_pf4_16mar2009_v1.txt"
setenv GSPROTMP_M "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_other_hapvoc_no_benz_benz_16nov2009_v0.txt"
setenv GSREFTMP_I "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_nonhapvoc_2005_hdghg_18feb2011_v1.txt"
setenv GSREFTMP_H "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_nonhapvoc_general_hdghg_11feb2011_v1.txt"
setenv GSREFTMP_C "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_static_nox_hono_pf4_08dec2010_v6.txt"
setenv GSPROTMP_L "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_speciated_pm_20nov2009_v3.txt"
setenv GSREFTMP_L "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_speciated_pm_20nov2009_v2.txt"
setenv MRGDATE_FILES "${dirinputs}/ge_dat/smk_dates/2005/smk_merge_dates_200412.txt"
setenv GSREFTMP_J "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_static_integratehap_emv4_10feb2009_v2.txt"
setenv GSREFTMP_E "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_pm25_pf4_nondiesel_10may2010_v13.txt"
setenv GSREFTMP_D "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_no_dieselpm_13apr2010_v3.txt"
setenv GSPROTMP_I "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_speciated_voc_30jan2009_v0.txt"
setenv SRGPRO "${dirinputs}/ge_dat/12EUS1_surg/CAN_100.txt"
setenv INVTABLE "${dirinputs}/${CASE}/../ge_dat/invtable_hapcap_cb05soa_11feb2011_v10.txt"

## Inputs -- region (Continental US 36km (36US1)) and all sectors and all jobs
setenv SECTORLIST "${dirinputs}/${CASE}/mrggrid/sectorlist_${CASE}_03mar2011_v4"
setenv SRGPRO "${dirinputs}/ge_dat/36US1_surg/CAN_100.txt"

## Inputs -- all regions and  sector (mrggrid) and all jobs

## Inputs -- region (Continental US 36km (36US1)) and  sector (mrggrid) and all jobs

## Inputs -- all regions and  all sector and job (Sector merge Jan-Jun 36US1 (mrggrid, 36US1))

## Inputs -- region (Continental US 36km (36US1)) and  all sectors and job (Sector merge Jan-Jun 36US1 (mrggrid, 36US1))

## Inputs -- all regions and  sector (mrggrid) and job (Sector merge Jan-Jun 36US1)

## Inputs -- region (Continental US 36km (36US1)) and  sector (mrggrid) and job (Sector merge Jan-Jun 36US1)

## Parameters -- from Case summary 
setenv MODEL_LABEL "SMOKE2.6"
setenv EMF_AQM "CMAQ v4.7 N5c"
setenv EMF_SPC "cmaq_cb05_tx"
setenv BASE_YEAR "2005"
setenv EPI_STDATE_TIME "2005-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2005-12-31 23:59:00.0"
setenv PARENT_CASE "2030cs_hdghg_ref_05b"

## Parameters -- from job tab
setenv SECTOR "mrggrid"
setenv REGION "Continental US 36km"
setenv REGION_ABBREV "36US1"
setenv REGION_IOAPI_GRIDNAME "36US1_148X112"

## Parameters -- all regions, all sectors, all jobs 
setenv EMF_QUEUE_OPTIONS "-A fedrules -q romo -W group_list=romo -W umask=022"
setenv REGION_SPINUP "3"
setenv GRID_1 "36US1"
setenv SMK_EMLAYS "10"
setenv IOAPI_GRIDNAME_1 "36US1_148X112"
setenv SPC "$EMF_SPC"
setenv PLATFORM "v4"
setenv EGU_TYPE "model_performance"
setenv MCIPNAME "MCIP_v3.4beta4"
setenv RUN_PYTHON_ANNUAL "Y"
setenv INLINE_MODE "both"
setenv SMK_PING_METHOD "0"
setenv SMK_SPECELEV_YN "Y"
setenv RAW_DUP_CHECK "Y"
setenv M_TYPE "mwdss"
setenv L_TYPE "mwdss"
setenv RUN_HOLIDAYS "Y"
setenv FULLSCC_ONLY "Y"
setenv SMK_MAXERROR "10000"
setenv SMK_MAXWARNING "10"
setenv SMK_AVEDAY_YN "N"
setenv REPORT_DEFAULTS "Y"
setenv SMK_DEFAULT_SRGID "100"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv FILL_ANNUAL "N"
setenv MRG_MARKETPEN_YN "N"
setenv WEST_HSPHERE "Y"
setenv ALL_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv MRG_REPCNY_YN "N"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv OUTZONE "0"
setenv RENORM_TPROF "Y"
setenv POLLUTANT_CONVERSION "Y"
setenv IOAPI_ISPH "19"
setenv MRG_REPSTA_YN "Y"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv OUTPUT_FORMAT "$EMF_AQM"

## Parameters -- region (Continental US 36km (36US1)), all sectors, all jobs 
setenv REGION_SPINUP "10"

## Parameters -- all regions, sector (mrggrid), all jobs 
setenv GZIP_OUTPUTS "Y"
setenv OCL2ROOT "$IMD_ROOT/2005ck_05b/ocean_cl2/cl2_"
setenv EXT ".ncf"
setenv VOLCROOT "/orchid/oaqps/em_v4/intermed/2005ag_tox_05a/hg_volcanic/volc_"

## Parameters -- region (Continental US 36km (36US1)), sector (mrggrid), all jobs 

## Parameters -- all regions, all sectors, job (Sector merge Jan-Jun 36US1)

## Parameters -- region (Continental US 36km (36US1)), all sectors, job (Sector merge Jan-Jun 36US1)

## Parameters -- all regions, sector (mrggrid), all job (Sector merge Jan-Jun 36US1)

## Parameters -- region (Continental US 36km (36US1)), sector (mrggrid), job (Sector merge Jan-Jun 36US1)

## job executable
$EMF_CLIENT -k $EMF_JOBKEY -x $SMK_HOME/subsys26/smoke26/scripts/emf/smk_sectormerge_emf.csh -m "Running top level script for job: Sector_merge_Jan_Jun_36US1"
$SMK_HOME/subsys26/smoke26/scripts/emf/smk_sectormerge_emf.csh $REGION_ABBREV  -m "$RUN_MONTHS" $SPINUP_DURATION jan-dec
if ( $status != 0 ) then
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e' 
	 exit(1)
else
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

