#!/bin/csh -f
#PBS -j oe
#PBS -r n

limit stacksize unlimited
## Manually set directory names [**change**]
setenv INSTALL_DIR "/garnet/work/ozl/packages"
setenv MET_ROOT "/garnet/oaqps/met/MCIP_v3.4b4/MM5_2005b_14aL" # Change to point to your MCIP
setenv TLABEL test
setenv CASE "2007ea_v5_07c"
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "10"

## Grid parameters
setenv REGION_ABBREV "12US1"
setenv REGION_IOAPI_GRIDNAME "12US1_459X299"


## Derived directory and filenames
setenv PROJECT "2007ee_v5_07c"

setenv OUT_ROOT "$INSTALL_DIR"
setenv PROJECT_ROOT "$INSTALL_DIR/2007ee_v5_07c"
setenv IMD_ROOT "$PROJECT_ROOT/$CASE/intermed"
setenv DAT_ROOT $PROJECT_ROOT/$CASE
setenv SMK_HOME "$INSTALL_DIR/smoke"
set caseinputs  = "$PROJECT_ROOT/$CASE/inputs"
set ge_dat = "$INSTALL_DIR/2007ee_v5_07c/ge_dat"
set casescripts = "$INSTALL_DIR/2007ee_v5_07c/scripts"
set runscripts = "$INSTALL_DIR/smoke/smoke3.1/scripts"
setenv RUNSET "$casescripts/run_settings_2007ea_v5_07c.txt"
setenv ASSIGNS_FILE "$INSTALL_DIR/smoke/smoke3.1/assigns/ASSIGNS.emf"

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
setenv EMF_CLIENT false

## Parameters -- from Case summary 
setenv MODEL_LABEL "SMOKE3.1"
setenv EMF_AQM "CMAQ v4.7 N1c"
setenv EMF_SPC "cmaq_cb05_soa"
setenv BASE_YEAR "2007"
setenv EPI_STDATE_TIME "2007-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2007-12-31 23:59:00.0"

## EMF specific variables - leave alone
setenv EMF_JOBNAME "Annual_point"
setenv EMF_SCRIPTDIR "${casescripts}"
setenv EMF_SCRIPTNAME "${casescripts}/${EMF_JOBNAME}.csh"
setenv EMF_LOGNAME "${casescripts}/logs/$EMF_SCRIPTNAME.log"
setenv EMF_JOBKEY "28310_1312400444602"

## Ancillary files unlikely to change between sectors
setenv GRIDDESC "${ge_dat}/griddesc_lambertonly_06apr2012_v45.txt"
setenv NAICSDESC "${ge_dat}/naicsdesc_02jan2008_v0.txt"
setenv COSTCY "${ge_dat}/costcy_for_2007platform_16feb2012_nf_v3.txt"
setenv HOLIDAYS "${ge_dat}/holidays_04may2006_v0.txt"
setenv ATREF "${ge_dat}/amptref_v3_3_revised_03nov2011_v14.txt"
setenv MACTDESC "${ge_dat}/mactdesc_2002v3_23apr2008_v1.txt"
setenv GSCNV "${ge_dat}/gscnv_cb05_soa_29jul2011_v2.txt"
setenv GSREFTMP_A "${ge_dat}/speciation/${CASE}/gsref_c3marine_cmaq_cb05_soa_2007ea_v5_07c_03nov2011.txt"
setenv INVTABLE "${ge_dat}/invtable_hapcapintegate_cb05soa_nomp_nohg_09feb2012_v8.txt"
setenv MGREF "${ge_dat}/amgref_us_can_mex_revised_28jun2012_nf_v20.txt"
setenv AGREF "${ge_dat}/amgref_us_can_mex_revised_28jun2012_nf_v20.txt"
setenv SICDESC "${ge_dat}/sic_desc_04oct2006_v0.txt"
setenv ATPRO "${ge_dat}/amptpro_2008aa_us_can_revised_21jun2012_v2.txt"
setenv MTPRO "${ge_dat}/amptpro_2008aa_us_can_revised_21jun2012_v2.txt"
setenv MCODES "${ge_dat}/mcodes_22nov2011_nf_v4.txt"
setenv SRGDESC "${ge_dat}/srgdesc_CONUS12_2010_26jun2012_v2.txt"
setenv PSTK "${ge_dat}/pstk_20nov2006_v0.txt"
setenv ARTOPNT "${ge_dat}/artopnt_2002detroit_12jul2007_v0.txt"
setenv AGREF "${ge_dat}/amgref_us_can_mex_revised_28jun2012_nf_v20.txt"
setenv SCCDESC "${ge_dat}/sccdesc_pf31_28jun2012_nf_v15.txt"
setenv MTREF "${ge_dat}/Gentpro_TREF_agNH3_RWC_2007ed.txt"
setenv ORISDESC "${ge_dat}/orisdesc_04dec2006_v0.txt"
setenv MRGDATE_FILES "${ge_dat}/smk_dates/2007/smk_merge_dates_200612.txt"
setenv GSPROTMP_A "${ge_dat}/speciation/${CASE}/gspro_c3marine_cmaq_cb05_soa_2007ea_v5_07c_13feb2012.txt"
setenv PTPRO "${ge_dat}/amptpro_2007ea_us_can_revised_09feb2012_v0.txt"
setenv PTREF "${ge_dat}/amptref_v3_3_revised_03nov2011_v14.txt"
setenv GSPRO_COMBO "${ge_dat}/gspro_combo_2005_09sep2008_v2.txt"

setenv SECTOR "c3marine"
setenv REGION "Continental US 12km"

setenv NHAPEXCLUDE "${ge_dat}//nhapexclude_nothing_08sep2008_v0.txt"
setenv EMISINV_A "$caseinputs/$SECTOR/ptinv_eca_imo_caps_US_2007_07feb2012_v0_orl.txt"
setenv EMISINV_B "${INSTALL_DIR}/${CASE}inputs/c3marine/ptinv_eca_imo_US_vochaps_2007_07feb2012_v0_orl.txt"
setenv EMISINV_D "$caseinputs/$SECTOR/ptinv_eca_imo_CANADA_vochaps_2007_07feb2012_v0_orl.txt"
setenv EMISINV_C "$caseinputs/$SECTOR/ptinv_eca_imo_CANADA_caps_2007_07feb2012_v0_orl.txt"
setenv REPCONFIG_INV2 "${ge_dat}/repconfig/default/repconfig_point_inv2_13feb2008_v0.txt"
setenv REPCONFIG_INV "${ge_dat}/repconfig/default/repconfig_seca_c3_inv_caphap_01sep2008_v0.txt"
setenv REPCONFIG_GRID "${ge_dat}/repconfig/default/repconfig_pt_noplant_invgrid_caphap_05sep2008_v1.txt"
setenv PELVCONFIG "${ge_dat}/pelvconfig_seca_c3_22jul2010_v1.txt"





setenv XPORTFRAC "$caseinputs//afdust/xportfrac.12US1_459X299.from4km.v2.ncf"



## Parameters -- all regions, all sectors, all jobs
setenv OUTZONE "0"
setenv MCIPNAME "MCIP_v3.6"
setenv ALL_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv REPORT_DEFAULTS "Y"
setenv FULLSCC_ONLY "Y"
setenv SMK_PING_METHOD "0"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv POLLUTANT_CONVERSION "Y"
setenv FILL_ANNUAL "N"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv WEST_HSPHERE "Y"
setenv RENORM_TPROF "Y"
setenv PLATFORM "v5"
setenv EMF_QUEUE_OPTIONS "-A mobile -q romo -W group_list=romo -W umask=022"
setenv SMK_SPECELEV_YN "Y"
setenv MRG_REPSTA_YN "Y"
setenv SMK_MAXWARNING "10"
setenv SPC "$EMF_SPC"
setenv RUN_PYTHON_ANNUAL "Y"
setenv INLINE_MODE "only"
setenv EGU_TYPE "model_performance"
setenv OUTPUT_FORMAT "$EMF_AQM"
setenv IOAPI_ISPH "20"
setenv SMK_MAXERROR "10000"
setenv MRG_REPCNY_YN "N"
setenv SMK_EMLAYS "24"
setenv RAW_DUP_CHECK "Y"
setenv SMK_AVEDAY_YN "N"
setenv MRG_MARKETPEN_YN "N"

## Parameters -- sector/region/job specific
setenv M_TYPE "aveday"
setenv RUN_HOLIDAYS "N"
setenv SMK_DEFAULT_SRGID "340"
setenv L_TYPE "aveday"
setenv FUTURE_YEAR "2007"
setenv SPINUP_DURATION "0"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv NONHAP_TYPE "VOC"

setenv SRGPRO "${ge_dat}/CONUS12_2010_v2_20120625/"




$runscripts/emf/smk_pt_annual_byday_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME -q 1  $SPINUP_DURATION q1
if ( $status != 0 ) then
         $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e'
         exit(1)
else
         $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

