#!/bin/csh -f
#PBS -j oe
#PBS -r n

limit stacksize unlimited

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
source /orchid/oaqps/EMFClient/EmfCmdClientEnv.csh
setenv EMF_JAVACMDLINE "$JAVA_EXE -DUSER_PREFERENCES=$PREF_FILE -DEMF_HOME=$EMF_HOME -classpath $CLASSPATH gov.epa.emissions.framework.client.EMFCmdClient $TOMCAT_SERVER/emf/services  -r 3"
setenv EMF_CLIENT /orchid/oaqps/EMFClient/EMFCmdClient.py

## Job run file for job: Annual_beis3_12US1

## EMF specific variables
setenv EMF_JOBID "18008"
setenv EMF_JOBNAME "Annual_beis3_12US1"
setenv EMF_USER "cvy"
setenv EMF_SCRIPTDIR "/orchid/share/em_v4/subsys26/smoke26/scripts/cases/2007aq_07c"
setenv EMF_SCRIPTNAME "/orchid/share/em_v4/subsys26/smoke26/scripts/cases/2007aq_07c/Annual_beis3_12US1_2007aq_07c_20100420111007.csh"
setenv EMF_JOBKEY "18008_1271776208168"

## Inputs -- for all regions, all sectors and all jobs
setenv GRIDDESC "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/griddesc_lambertonly_30nov2009_v23.txt"
setenv COSTCY "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/costcy_for_2002_10mar2009_v4.txt"
setenv GSCNV "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/gscnv_cmaq_cb05_tx_pf4_23aug2009_v3.txt"
setenv PELVCONFIG "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/pelvconfig_inline_allpts_11apr2008_v0.txt"
setenv ORISDESC "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/orisdesc_04dec2006_v0.txt"
setenv PSTK "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/pstk_20nov2006_v0.txt"
setenv AGREF "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/amgref_us_can_mex_revised_18mar2009_v7.txt"
setenv ATREF "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/amptref_v3_3_revised_15apr2010_nf_v5.txt"
setenv ATPRO "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/amptpro_2007_us_can_revised_28jan2010_v0.txt"
setenv PTREF "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/amptref_v3_3_revised_15apr2010_nf_v5.txt"
setenv PTPRO "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/amptpro_2005_us_can_revised_10mar2009_v0.txt"
setenv MTREF "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/amptref_v3_3_revised_15apr2010_nf_v5.txt"
setenv REPCONFIG_INV "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/repconfig/default/repconfig_area_inv_caphap_08aug2008_v0.txt"
setenv SICDESC "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/sic_desc_04oct2006_v0.txt"
setenv SCCDESC "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/sccdesc_pf31_06apr2010_v10.txt"
setenv ARTOPNT "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/artopnt_2002detroit_12jul2007_v0.txt"
setenv HOLIDAYS "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/holidays_04may2006_v0.txt"
setenv MTPRO "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/amptpro_2005_us_can_revised_10mar2009_v0.txt"
setenv MGREF "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/amgref_us_can_allmex3_15apr2010_nf_v13.txt"
setenv MCODES "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/mcodes_21nov2008_v1.txt"
setenv GSPRO_COMBO "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/gspro_combo_2005_09sep2008_v2.txt"
setenv MACTDESC "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/mactdesc_2002v3_23apr2008_v1.txt"
setenv NAICSDESC "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/naicsdesc_02jan2008_v0.txt"
setenv REPCONFIG_INV2 "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/repconfig/default/repconfig_area_inv2_02jan2008_v0.txt"
setenv REPCONFIG_GRID "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/repconfig/default/repconfig_area_invgrid_caphap_05sep2008_v1.txt"
setenv GSPROTMP_C  "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gspro_pm25_26jun2007_v0.txt"
setenv GSPROTMP_D  "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gspro_tog_cb05_soa_pf4_pretier2_08feb2009_v1.txt"
setenv GSPROTMP_B  "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gspro_sulf_29jun2007_v1.txt"
setenv GSPROTMP_A  "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gspro_static_cmaq_19mar2009_v9.txt"
setenv GSREFTMP_B "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gsref_sulf_09jul2007_v0.txt"
setenv GSREFTMP_F "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gsref_voc_general_13apr2010_v24.txt"
setenv GSREFTMP_G "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gsref_voc_2005_13apr2010_v4.txt"
setenv GSPROTMP_G "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gspro_nox_hono_pf4_06aug2008_v0.txt"
setenv SECTORLIST "/orchid/share/em_v4/inputs/2007aq_07c/mrggrid/old_2005ck_05b_01apr2009_v4"
setenv SRGDESC "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/srgdesc_36km_revised_17mar2009_v1.txt"
setenv GSPROTMP_H "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gspro_hg_26nov2007_v2.txt"
setenv GSREFTMP_A "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gsref_static_cap_pf4_06aug2008_v0.txt"
setenv GSREFTMP_K "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gsref_hg_13apr2010_v8.txt"
setenv GSPROTMP_E "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gspro_nonhaptog_cb05_tx_pf4_pretier2_14nov2008_v1.txt"
setenv GSPROTMP_F "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gspro_integratehaps_cb05_tx_pf4_16mar2009_v1.txt"
setenv GSREFTMP_I "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gsref_nonhapvoc_2005_13apr2010_v2.txt"
setenv GSREFTMP_H "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gsref_nonhapvoc_general_update_13apr2010_v5.txt"
setenv GSREFTMP_C "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gsref_static_nox_hono_pf4_13apr2010_v5.txt"
setenv GSPROTMP_P "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/gspro_speciated_pm_24oct2008_v2.txt"
setenv GSREFTMP_P "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/gsref_speciated_pm_27jan2009_v1.txt"
setenv MRGDATE_FILES "/orchid/share/em_v4/inputs/ge_dat/smk_dates/2005/smk_merge_dates_200412.txt"
setenv GSREFTMP_J "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gsref_static_integratehap_emv4_10feb2009_v2.txt"
setenv INVTABLE "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/invtable_hapcapintegate_cb05soa_nomp_15sep2009_v7.txt"
setenv GSREFTMP_E "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gsref_pm25_pf4_nondiesel_13apr2010_v11.txt"
setenv GSREFTMP_D "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gsref_no_dieselpm_13apr2010_v3.txt"
setenv GSPROTMP_M "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gspro_speciated_voc_30jan2009_v0.txt"
setenv SRGPRO "/orchid/share/em_v4/inputs/ge_dat/12km_surg_revised/CA_100_NOFILL.txt"

## Inputs -- region (Continental US 12km (12US1)) and all sectors and all jobs

## Inputs -- all regions and  sector (beis) and all jobs
setenv B3FAC "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/beis3_efac_v3_14_16may2008_v0"
setenv GSPROTMP_O "/orchid/share/em_v4/inputs/2007aq_07c/../ge_dat/spec_parts/gspro_biogenics_19mar2009_v0.txt"

## Inputs -- region (Continental US 12km (12US1)) and  sector (beis) and all jobs
setenv BIOSEASON "/orchid/share/em_v4/inputs/2007aq_07c/beis/bioseason.cmaq.2007c_12US1.ncf"
setenv BGPRO "/orchid/share/em_v4/inputs/2007aq_07c/beis/bgpro_12US1_USonly.txt"
setenv BELD3_A "/orchid/share/em_v4/inputs/2007aq_07c/beis/beld3_12US1_459X299_output_a.ncf"
setenv BELD3_B "/orchid/share/em_v4/inputs/2007aq_07c/beis/beld3_12US1_459X299_output_b.ncf"
setenv BELD3_TOT "/orchid/share/em_v4/inputs/2007aq_07c/beis/beld3_12US1_459X299_output_tot.ncf"

## Inputs -- all regions and  all sector and job (Annual beis3 12US1)

## Inputs -- region (Continental US 12km (12US1)) and  all sectors and job (Annual beis3 12US1)

## Inputs -- all regions and  sector (beis) and job (Annual beis3 12US1)

## Inputs -- region (Continental US 12km (12US1)) and  sector (beis) and job (Annual beis3 12US1)

## Parameters -- from Case summary 
setenv CASE "2007aq_07c"
setenv MODEL_LABEL "SMOKE2.6"
setenv EMF_AQM "CMAQ v4.7 N1c"
setenv EMF_SPC "cmaq_cb05_soa"
setenv BASE_YEAR "2007"
setenv FUTURE_YEAR "2007"
setenv EPI_STDATE_TIME "2007-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2007-12-31 23:59:00.0"
setenv PARENT_CASE "B24_2005"

## Parameters -- from job tab
setenv SECTOR "beis"
setenv REGION "Continental US 12km"
setenv REGION_ABBREV "12US1"
setenv REGION_IOAPI_GRIDNAME "12US1_459X299"

## Parameters -- all regions, all sectors, all jobs 
setenv EMF_QUEUE_OPTIONS "-A plateval -q romo -W group_list=romo -W umask=022 -l walltime=88:00:00"
setenv SPINUP_DURATION_3 "3"
setenv SPINUP_DURATION_2 "3"
setenv SPC "$EMF_SPC"
setenv SMK_EMLAYS "10"
setenv PLATFORM "v4"
setenv IOAPI_GRIDNAME_3 "12WUS1_213X192"
setenv IOAPI_GRIDNAME_2 "12EUS1_279X240"
setenv IOAPI_GRIDNAME_1 "36US1_148X112"
setenv GRID_3 "12WUS1"
setenv GRID_2 "12EUS1"
setenv GRID_1 "36US1"
setenv MCIPNAME "MCIP_v3.4beta4"
setenv EGU_TYPE "model_performance"
setenv SMK_HOME "/orchid/share/em_$PLATFORM"
setenv OUT_ROOT "/orchid/oaqps/cdc_2/smoke_out_$PLATFORM"
setenv MET_ROOT "/asm/MOD3EVAL/met/MCIP_v3.6/WRF_2007c_24aL"
setenv IMD_ROOT "/garnet/oaqps/em_$PLATFORM/intermed"
setenv DAT_ROOT "/orchid/share/em_$PLATFORM"
setenv RUNSET "$SMK_HOME/subsys26/smoke26/scripts/cases/$CASE/run_settings_$CASE.txt"
setenv ASSIGNS_FILE "$SMK_HOME/subsys26/smoke26/assigns/ASSIGNS.emf"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv SMK_SPECELEV_YN "Y"
setenv SMK_PING_METHOD "0"
setenv SMK_MAXWARNING "10"
setenv SMK_MAXERROR "10000"
setenv SMK_DEFAULT_SRGID "100"
setenv SMK_AVEDAY_YN "N"
setenv RUN_PYTHON_ANNUAL "Y"
setenv RUN_HOLIDAYS "Y"
setenv REPORT_DEFAULTS "Y"
setenv RAW_DUP_CHECK "Y"
setenv M_TYPE "mwdss"
setenv L_TYPE "mwdss"
setenv INLINE_MODE "both"
setenv FULLSCC_ONLY "Y"
setenv FILL_ANNUAL "N"
setenv WEST_HSPHERE "Y"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv RENORM_TPROF "Y"
setenv POLLUTANT_CONVERSION "Y"
setenv OUTZONE "0"
setenv OUTPUT_FORMAT "$EMF_AQM"
setenv MRG_REPSTA_YN "Y"
setenv MRG_REPCNY_YN "N"
setenv MRG_MARKETPEN_YN "N"
setenv IOAPI_ISPH "19"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv ALL_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"

## Parameters -- region (Continental US 12km (12US1)), all sectors, all jobs 
setenv SPINUP_DURATION "10"

## Parameters -- all regions, sector (beis), all jobs 
setenv BEIS3_VERSION "3.14"
setenv BIOG_SPRO "B10C5"
setenv AREA_SURROGATE_NUM "340"
setenv L_TYPE "all"
setenv M_TYPE "all"
setenv BIO_COUNTY_SUMS "Y"
setenv BIO_STATE_SUMS "Y"
setenv RAD_VAR "RGRND"
setenv TMPR_VAR "TEMP2"
setenv PRES_VAR "PRSFC"
setenv PX_VERSION "Y"
setenv SOILT_VAR "SOIT1"
setenv ISLTYP_VAR "SLTYP"
setenv SOIM1_VAR "SOIM1"
setenv RC_VAR "RC"

## Parameters -- region (Continental US 12km (12US1)), sector (beis), all jobs 

## Parameters -- all regions, all sectors, job (Annual beis3 12US1)

## Parameters -- region (Continental US 12km (12US1)), all sectors, job (Annual beis3 12US1)

## Parameters -- all regions, sector (beis), all job (Annual beis3 12US1)

## Parameters -- region (Continental US 12km (12US1)), sector (beis), job (Annual beis3 12US1)

## job executable
$EMF_CLIENT -k $EMF_JOBKEY -x $SMK_HOME/subsys26/smoke26/scripts/emf/smk_beis_emf.csh -m "Running top level script for job: Annual_beis3_12US1"
$SMK_HOME/subsys26/smoke26/scripts/emf/smk_beis_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME -q "1 2 3 4" $SPINUP_DURATION
if ( $status != 0 ) then
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e' 
	 exit(1)
else
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

