#!/usr/local/bin/python2.6

import sys

## User defined
#Install directory
iDir = '/garnet/work/ozl/packages/2007ee_v5_07c'

# GSPROTMP_A filename -- concatenated 
gspA = '../spec_parts/gspro_ptipm_cmaq_cb05_soa_2007ee_v5_10c_17jul2012.txt'

# GSREFTMP_A filename -- concatenated 
gsrA = '../spec_parts/gsref_ptipm_cmaq_cb05_soa_2007ee_v5_10c_23aug2012.txt'

# Project name override.  Leave blank to use project name from script.
project = '2007platform'

# Case name to use for run settings file.  Leave blank to use case name from script. 
runset = '2007ee_v5_07c'


## Other variables
inFileName = sys.argv[1]

# All inputs section first line
aiHead = "## Inputs -- for all regions, all sectors and all jobs"

# All parameters section first line
apHead = "## Parameters -- all regions, all sectors, all jobs"

# Variable names from sections with defined included variables.
# These will be either used in a specific section of the output file or dropped.
# These are generally variables such as paths and EMF specific variables.
ddList = ('MET_ROOT', 'CASE', \
'REGION_ABBREV', 'REGION_IOAPI_GRIDNAME', 'REGION', \
'OUT_ROOT', 'PROJECT_ROOT', 'IMD_ROOT', 'DAT_ROOT', 'SMK_HOME', 'RUNSET', 'ASSIGNS_FILE', 'PROJECT',\
'EMF_JAVACMDLINE', 'EMF_CLIENT', \
'MODEL_LABEL', 'EMF_AQM', 'EMF_SPC', 'BASE_YEAR', 'EPI_STDATE_TIME', 'EPI_ENDATE_TIME', \
'EMF_JOBID', 'EMF_JOBNAME', 'EMF_USER', 'EMF_SCRIPTDIR', 'EMF_SCRIPTNAME', 'EMF_LOGNAME', 'EMF_JOBKEY', \
'SECTORLIST', 'SECTOR', 'SRGPRO')

def parseIn(inFileName):
	"""
	Reads the infile and returns a dictionary of the environment variables
	"""
	envDict = { 'dd': {}, 'ai': {}, 'oi': {}, 'ap': {}, 'op': {}, 'unk': {} }
	inFile = open(inFileName)
	for line in inFile.readlines():

		line = line.strip()

		# Set the environmental variable type based on section
		if line[:2] == '##':
			# If the section has the all inputs header, the set env type to ai
			if aiHead in line:
				envType = 'ai'
			# If the section has the all parameters header, then set to ap
			elif apHead in line:
				envType = 'ap'
			# If the section starts off with the word inputs, then set to oi
			elif "## Inputs" in line[:11]:
				envType = 'oi'
			# If the section starts off with the word parameters, then set to op
			elif "## Parameters" in line[:14]:
				envType = 'op'
			# Otherwise set to unk
			else:
				envType = 'unk'

		# Get the environment variable name and definition if it is a setenv line
		if line[:6] == 'setenv':

			line = line.split(' ')
			varName = line[1].strip()
			varDef = ' '.join(line[2:]).strip('"')

			# Skip over the multifile portions of the GSPRO and GSREF
			if varName[:8] == 'GSPROTMP' and varName != 'GSPROTMP_A': continue
			if varName[:8] == 'GSREFTMP' and varName != 'GSREFTMP_A': continue

			# Put the environment variable in the correct dictionary section
			# If the variable name is in the defined section list, then set to env type to dd
			if varName in ddList: 
				envDict['dd'][varName] = varDef
			else:
				envDict[envType][varName] = varDef

		# Get the emf script
		if line[:9] == '$SMK_HOME' and '.csh' in line:
			sPath = line.split(' ')[0]
			sFile = sPath.split('/')[-1]
			envDict['dd']['SFILE'] = sFile

	if len(envDict['unk']) > 0:
		print 'WARNING: Variables of unknown type found in file'

	return envDict

# Fix the path to be based on the variable names rather than absolute paths
def fixPath(varName, path):
	# fix ge_dat based paths
	if 'ge_dat' in path:
		geDatIdx = path.split('/').index('ge_dat')
		fName = '/'.join(path.split('/')[geDatIdx + 1:])

		if varName == 'GSPROTMP_A': fName = gspA
		if varName == 'GSREFTMP_A': fName = gsrA
		 
		path = '${ge_dat}/%s' %fName
	# fix smoke merge dates path
	elif 'smk_dates' in path:
		smdIdx = path.split('/').index('smk_dates')
		fName = '/'.join(path.split('/')[smdIdx:])
		path = '${runscripts}/%s' %fName
	# fix general inputs path
	elif 'inputs' in path:
		inIdx = path.split('/').index('inputs')
		fName = '/'.join(path.split('/')[inIdx + 1:])
		path = '${caseinputs}/%s' %fName
	return path


### Main
envDict = parseIn(inFileName)

case = envDict['dd']['CASE']
sector = envDict['dd']['SECTOR']
grid = envDict['dd']['REGION_ABBREV']
runType = envDict['dd']['EMF_JOBNAME'].split('_')[0]

if 'onetime' in envDict['dd']['EMF_JOBNAME'].lower():
	runType = "Onetime"

outFileName = '%s_%s_%s_%s.csh' %(runType, sector, grid, case)
runType = runType.lower()

if len(project) < 1:
	project = envDict['dd']['PROJECT']

if len(runset) < 1:
	runset = envDict['dd']['CASE']

outFile = open(outFileName, 'w')

# Write header section
head = """#!/bin/tcsh
#PBS -j oe
#PBS -r n

limit stacksize unlimited
\n"""
outFile.write(head)

# Write manual set section
manual = """## Manually set directory names [**change**]
setenv INSTALL_DIR "%s"
setenv MET_ROOT "%s" # Change to point to your MCIP

setenv CASE "%s"
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "0"
\n""" %(iDir, envDict['dd']['MET_ROOT'], envDict['dd']['CASE'])
outFile.write(manual)

# Write grid parameters
gparm = """## Grid parameters
setenv REGION_ABBREV "%s"
setenv REGION_IOAPI_GRIDNAME "%s"
\n""" %(envDict['dd']['REGION_ABBREV'], envDict['dd']['REGION_IOAPI_GRIDNAME'])
outFile.write(gparm)

# Write derived directories
derdir = """## Derived directory and filenames
setenv OUT_ROOT "$INSTALL_DIR"
setenv PROJECT_ROOT "$INSTALL_DIR/%s"
setenv IMD_ROOT "$PROJECT_ROOT/$CASE/intermed"
setenv DAT_ROOT $INSTALL_DIR
setenv SMK_HOME "$INSTALL_DIR/smoke"
set caseinputs  = "$PROJECT_ROOT/$CASE/inputs"
set ge_dat = "$INSTALL_DIR/ge_dat"
set casescripts = "$INSTALL_DIR/%s/%s/scripts"
set runscripts = "$INSTALL_DIR/smoke/smoke3.1/scripts"
setenv RUNSET "$casescripts/run_settings_%s.txt"
setenv ASSIGNS_FILE "$INSTALL_DIR/smoke/smoke3.1/assigns/ASSIGNS.emf"
\n""" %(project, project, runset, envDict['dd']['CASE'])
outFile.write(derdir)

# Write EMF and Case summary
ecSum = """## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
setenv EMF_CLIENT false

## Parameters -- from Case summary 
setenv MODEL_LABEL "%s"
setenv EMF_AQM "%s"
setenv EMF_SPC "%s"
setenv BASE_YEAR "%s"
setenv EPI_STDATE_TIME "%s"
setenv EPI_ENDATE_TIME "%s"

## EMF specific variables - leave alone
setenv EMF_JOBNAME "%s"
setenv EMF_SCRIPTDIR "${casescripts}"
setenv EMF_SCRIPTNAME "${casescripts}/${EMF_JOBNAME}.csh"
setenv EMF_LOGNAME "${casescripts}/logs/$EMF_SCRIPTNAME.log"
setenv EMF_JOBKEY "%s"
\n""" %(envDict['dd']['MODEL_LABEL'], envDict['dd']['EMF_AQM'], envDict['dd']['EMF_SPC'], envDict['dd']['BASE_YEAR'], envDict['dd']['EPI_STDATE_TIME'], envDict['dd']['EPI_ENDATE_TIME'], \
envDict['dd']['EMF_JOBNAME'], envDict['dd']['EMF_JOBKEY'])
outFile.write(ecSum)

# Write the common ancillary inputs (all sectors)
outFile.write('## Ancillary files unlikely to change between sectors\n')
for varName in envDict['ai']:
	
	# Skip the variables that are overridden in a more specific section 
	if varName in envDict['oi']: continue

	varDef = fixPath(varName, envDict['ai'][varName])

	outFile.write('setenv %s "%s"\n' %(varName, varDef))
		
# Write the sector specific ancillary inputs
outFile.write('\n## Ancillary files likely to change between sectors\n')
for varName in envDict['oi']:
	varDef = fixPath(varName, envDict['oi'][varName])
	outFile.write('setenv %s "%s"\n' %(varName, varDef))

# Write sectorlist and sector
sectList = '${casescripts}/' + envDict['dd']['SECTORLIST'].split('/')[-1]
ssSum = """\n## Ancillary files likely to change between grids
setenv SECTORLIST "%s"

## Parameters -- from job tab
setenv SECTOR "%s"
\n""" %(sectList, envDict['dd']['SECTOR'])
outFile.write(ssSum)

# Write the common parameters (all sectors)
outFile.write('## Parameters -- all regions, all sectors, all jobs\n')
outFile.write('setenv PROJECT "%s"\n' %project)
for varName in envDict['ap']:

        # Skip the variables that are overridden in a more specific section 
	if varName in envDict['op']: continue

	varDef = envDict['ap'][varName]
	outFile.write('setenv %s "%s"\n' %(varName, varDef))

# Write the sector specific parameters
outFile.write('\n## Parameters -- sector/region/job specific\n')
for varName in envDict['op']:

	varDef = envDict['op'][varName]
	outFile.write('setenv %s "%s"\n' %(varName, varDef))

# Write the surrogate paths
srgPath = """\n
if ($REGION_ABBREV == "36US1") then
   setenv SRGPRO "${ge_dat}/36US1_surg/"
else
   setenv SRGPRO "${ge_dat}/CONUS12_2010/"
endif
\n"""
outFile.write(srgPath)

# Write the job executables

if runType == 'sector': 
	scrSettings = '$REGION_ABBREV -m "$RUN_MONTHS" $SPINUP_DURATION jan-dec'
elif runType == 'onetime':
	scrSettings = '$REGION_ABBREV $REGION_IOAPI_GRIDNAME onetime'
elif runType == 'monthly' or runType == 'daily':
	scrSettings = '$REGION_ABBREV $REGION_IOAPI_GRIDNAME -m "$RUN_MONTHS" $SPINUP_DURATION all'
else:
	scrSettings = '$REGION_ABBREV $REGION_IOAPI_GRIDNAME -m "$RUN_MONTHS" $SPINUP_DURATION'

jExec = """
$runscripts/emf/%s %s 
if ( $status != 0 ) then
         $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e'
         exit(1)
else
         $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif
\n""" %(envDict['dd']['SFILE'], scrSettings)
outFile.write(jExec)

