#!/bin/csh -f
#PBS -W group_list=romo
#PBS -A plateval 
#PBS -q romo
#PBS -l walltime=80:00:00
#PBS -l select=ncpus=1

unset verbose

## Manually set directory names [**change**]
setenv INSTALL_DIR "/garnet/work/cvy/for_package"
setenv MET_ROOT "/garnet/oaqps/met/MCIP_v4.1.3/WRF_2011g_25aL/25l_asmlink/12US2/mcip_out" # Change to point to your MCIP

if ( $?PBS_JOBID ) then
 cd $PBS_O_WORKDIR
else
 set PBS_JOBID = $?
endif

#-----------------------------------------------------------------#

set CTM_3DPTFIRE = Y ## Convert 3D point fires to UAM ptsr

setenv SECTOR ptwildfire3D
setenv GRID 12US2
setenv SPEC cmaq_cb6
setenv CASE 2011eh_cb6v2_v6_11g  ## secondary case for inline emissions
setenv XORG -2412.
setenv YORG -1620.
setenv NX 396
setenv NY 246
setenv DX 12.
set LAYERS = 25  ## Number of layers to output

set casescripts = $INSTALL_DIR/$CASE/scripts/camx
set camxscripts = $INSTALL_DIR/camx
set SPECIES_MAPPING = $camxscripts/Species_Mapping_Tables/MAPTBL.CMAQ_CB6+AERO6_to_CAMXv6_CB6+CF+RTRACPM_2015feb17

set YEAR = 2011
set datefile = $camxscripts/dates/mergedates_${YEAR}.txt
set execroot = $camxscripts/bin # Root to cmaq2camx executables

set QADIR = $casescripts/qatemp #location for QA files - domain totals and domain total 2D plots of point emissions
if (! -e $QADIR) then
	mkdir -p $QADIR
endif

set tempdir = $casescripts/work  ## Path for the temporary work directory
if (! -e $tempdir) then
	mkdir -p $tempdir
endif

setenv SCRIPTLOG cmaq2camx_${CASE}_${GRID}_${PBS_JOBID}.log  ## Name of script log 
if ( -e $casescripts/$SCRIPTLOG) then
	rm $casescripts/$SCRIPTLOG
endif

#-----------------------------------------------------------------#

set start_date = 2010356         #first Julian day
set end_date = 2011365          #last Julian day

set today = $start_date

setenv OUTPUT_TIMEZONE 0 ## Timezone for output, typically should be left at 0
setenv OUTPUT_N_LAYERS $LAYERS

## Run the CMAQ to CAMx conversion by loop over the specified date range 
while ($today <= $end_date )

	echo $today >> $casescripts/$SCRIPTLOG
	#-----------------------------------------------------------------#
	set STDATE = $today

	set GDAY = (`$execroot/j2g $today`)
	set YYYY = `echo $GDAY | cut -c1-4`
	set YY = `echo $GDAY | cut -c3-4`
	set MM = `echo $GDAY | cut -c5-6`
	set DD = `echo $GDAY | cut -c7-8`
	set G_DAY = $YYYY$MM$DD
	set GS_DAY = $YY$MM$DD
	set YYDDD = `echo $today | cut -c3-8`

	set iday = `grep ^$STDATE $datefile`
	set dateheader = `grep ^Date $datefile`
	#---------------------------------------------------------------------------#

	setenv CMAQ_METCRO3D $MET_ROOT/METCRO3D_${YY}${MM}${DD}

	if ($CTM_3DPTFIRE == Y) then ## elevated point file preparation
                set repday = $iday[9]
		set PATHA = $INSTALL_DIR/${CASE}/intermed/$SECTOR
		set FILEA = emis_mole_${SECTOR}_${repday}_${GRID}_${SPEC}_${CASE}.ncf

		rm -f ${tempdir}/temp_${PBS_JOBID}_ptf.ncf

		if (! -e $PATHA/$FILEA) then
			gunzip -c $PATHA/${FILEA}.gz > ${tempdir}/temp_${PBS_JOBID}_ptf.ncf
		else
			cp $PATHA/$FILEA ${tempdir}/temp_${PBS_JOBID}_ptf.ncf
		endif

		# 1. run cmaq2camx to convert IOAPI 2D file to camx format and adjust species 
		# 2. run qaemis on camx input file

		rm -f ${tempdir}/tmp_emis_${PBS_JOBID}_ptf

		setenv INFILE  ${tempdir}/temp_${PBS_JOBID}_ptf.ncf
		setenv OUTFILE ${tempdir}/tmp_emis_${PBS_JOBID}_ptf
		setenv MAPTBL  $SPECIES_MAPPING
		$execroot/spcmap

		setenv CMAQEMIS ${tempdir}/tmp_emis_${PBS_JOBID}_ptf
		rm -f ${tempdir}/tmp_pnt_${PBS_JOBID} ${tempdir}/junk 

$execroot/cmaq2uam-11sep2013 << EOF
File Type          |EMIS
OutFile1 (IC,BC,AR)|${tempdir}/junk
OutFile2 (TopC,PT) |${tempdir}/tmp_pnt_${PBS_JOBID}
Output Timezone    |0
EOF
		rm -f ${tempdir}/junk

		## Add effective plume height to the CAMx elevated point source file
		echo ${PATHA}/${FILEA} >> $casescripts/$SCRIPTLOG
		set OUTPATH = $INSTALL_DIR/$CASE/smoke_out/$CASE/$GRID/$SPEC/$SECTOR
		set OUTFILE = ptsr.$SECTOR.${G_DAY}.${GRID}.bin

		rm -f $OUTPATH/$OUTFILE

$execroot/pthtq << EOF
Input CAMx PT      |${tempdir}/tmp_pnt_${PBS_JOBID}
Output CAMx PT     |$OUTPATH/$OUTFILE
EOF

		rm -f ${tempdir}/tmp_pnt_${PBS_JOBID}
		rm -f ${tempdir}/qaemis.ptwildfire.${PBS_JOBID}.in
cat << ieof > ${tempdir}/qaemis.ptwildfire.${PBS_JOBID}.in
$OUTPATH/$OUTFILE
$QADIR/ptfire_ca.$G_DAY.$GRID.$CASE.camx.tot.txt
$QADIR/ptfire_ca.$G_DAY.$GRID.$CASE.camx.hrs.txt
$QADIR/ptfire_ca.$G_DAY.$GRID.$CASE.camx.pave.bin
ieof

		$execroot/qaelev < ${tempdir}/qaemis.ptwildfire.${PBS_JOBID}.in
		rm -f ${tempdir}/qaemis.ptwildfire.${PBS_JOBID}.in
		rm -f ${tempdir}/temp_${PBS_JOBID}_ptf.ncf

	endif # if CTM_3DPTFIRE

	@ today = $today + 1

	if ($today == 2010366) then
		set today = 2011001
	endif

end #loop back to next day

exit


