      subroutine ckhdr( ierr,
     &                        ifile)
c
c-----------------------------------------------------------------------
c
c    compare the header at the iounit to the USERIN info in the
c    common block.
c    set up the index between species names in input files
c    and species names from the uamcntl.inc
c    called from header.
c
c    Argument Declaration.
c     outputs:
c       ierr  i  error flag
c     inputs:
c       ifile i  which file do we have
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      10/25/91   --hjt--  original development
c      09/25/92   --mcc--  modified to write out mismatched records
c                          and detect day a hour 2400 is the same as
c                          day b hour 0000.
c      12/01/92   --gmw--  now echos the header data when mismathced
c
c-----------------------------------------------------------------------
c    Include Files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'uamcntl.inc'
      include 'uamregn.inc'
      include 'rdhdr.inc'
      include 'mrguam.inc'
c
c-----------------------------------------------------------------------
c    Argument Declarations:
c-----------------------------------------------------------------------
c
      integer*4  ierr
      integer*4  ifile
c
c-----------------------------------------------------------------------
c    library calls:
c-----------------------------------------------------------------------
c
c   strlen  i  returns the actual length of a string
c
      integer*4 strlen
c
c-----------------------------------------------------------------------
c    Local Variables:
c-----------------------------------------------------------------------
c
c     icntl   i  loop variable for reading species from uamcntl
c     ilen    i  string length
c     inew    i  loop variable for reading this file's species names
c     rdiff   r  real difference
c     string  c  holder for species name
c
      character*10 string
      integer*4    inew, icntl, ilen, jlen, idatmp, idareg
      real*4       rdiff, timtmp, timreg
      logical*4    lmatch
c
c-----------------------------------------------------------------------
c   Entry Point:
c-----------------------------------------------------------------------
c
c   --- assume failure ---
c
      ierr = IFAIL
c
c   --- compare region ---
c
      lmatch = .TRUE.
      rdiff = abs(utmx - tutmx)
      if(rdiff .GT. BFUZZ) lmatch = .FALSE.
c
      rdiff = abs(utmy - tutmy)
      if(rdiff .GT. BFUZZ) lmatch = .FALSE.
c
      if(izone .NE. izonet) lmatch = .FALSE.
c
      rdiff = abs(xorig - txorig)
      if(rdiff .GT. BFUZZ) lmatch = .FALSE.
c
      rdiff = abs(yorig - tyorig)
      if(rdiff .GT. BFUZZ) lmatch = .FALSE.
c
      if(nxcell .NE. nxcelt) lmatch = .FALSE.
      if(nycell .NE. nycelt) lmatch = .FALSE.
      if(nzcell .NE. nzcelt) lmatch = .FALSE.
      if(nzlowr .NE. nzlowt) lmatch = .FALSE.
      if(nzuppr .NE. nzuppt) lmatch = .FALSE.
c
      rdiff = abs(htsur - thtsur)
      if(rdiff .GT. BFUZZ) lmatch = .FALSE.
c
      rdiff = abs(htlowr - thtlow)
      if(rdiff .GT. BFUZZ) lmatch = .FALSE.
c
      rdiff = abs(htuppr - thtupp)
      if(rdiff .GT. BFUZZ) lmatch = .FALSE.
      if( .NOT. lmatch ) goto 7000
c
c   --- compare time ---
c
c
c   --- if beginning hour is 24, change day and set date to next
c       day ---
c
      idatmp = idateb
      timtmp = tbegti
      if( timtmp .EQ. 24. ) then
          idatmp = idatmp + 1
          timtmp = 0.
      endif
c
      idareg = ibgdat
      timreg = begtim/100
      if( timreg .EQ. 24. ) then
          idareg = idareg + 1
          timreg = 0.
      endif
c
  111 continue
      lmatch = .TRUE.
      if(idatmp .NE. idareg) lmatch = .FALSE.
      rdiff = abs(timtmp - timreg)
      if(rdiff .GT. BFUZZ) lmatch = .FALSE.
c
c   --- if beginning hour is 0, change day and set date to previous
c       day ---
c
      idatmp = idatee
      timtmp = tendti
      if( timtmp .EQ. 0. ) then
          idatmp = idatmp - 1
          timtmp = 24.
      endif
c
      idareg = iendat
      timreg = endtim/100
      if( timreg .EQ. 0. ) then
          idareg = idareg - 1
          timreg = 24.
      endif
c
      if(idatmp .NE. idareg) lmatch = .FALSE.
      rdiff = abs(timtmp - timreg)
      if(rdiff .GT. BFUZZ) lmatch = .FALSE.
      if( .NOT. lmatch ) goto 7002
c
c   --- set up index for species names ---
c
  222 continue
      do 110 inew = 1, iscnt(ifile)
          string = table(ifile, inew)
          do 100 icntl = 1, nspecs
              if(string .EQ. spcnam(icntl) ) then
                   index(ifile, inew) = icntl
                   goto 110
              endif
  100     continue
          index(ifile, inew) = -1
          jlen = strlen ( innm(ifile), MXSTR )
          ilen = strlen ( string, 10 )
          write(IOWMSG,9001,ERR=7002) 'WARNING:  Species ',
     &              string(1:ilen),' read from input file: ',
     &        innm(ifile)(1:jlen),' not found in /EPISODE/ packet.',
     &              ' It will not be included in the inventory.'
  110 continue
c
c   --- set error flag to sucess ---
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error Messages:
c-----------------------------------------------------------------------
c
 7000 continue
      jlen = strlen ( innm(ifile), MXSTR )
      write(IOWSTD,9000,ERR=9999)
     &                   'WARNING: Header read from input file: ',
     &                                            innm(ifile)(1:jlen),
     &                       ' is not consistent with /UAMREGN/ packet.'
c
      write(IOWMSG,9000,ERR=7001)
     &                   'WARNING: Header read from input file: ',
     &                                            innm(ifile)(1:jlen),
     &                       ' is not consistent with /UAMREGN/ packet.'
      write(IOWMSG,9000,ERR=7001) 'Input emissions header:'
      write(IOWMSG,9005,ERR=7001) 'UTM origin (km)',tutmx,tutmy
      write(IOWMSG,9003,ERR=7001) 'UTM zone',izonet
      write(IOWMSG,9005,ERR=7001) 'Grid origin (km)',txorig,tyorig
      write(IOWMSG,9005,ERR=7001) 'Grid cell width (km)',tdxcel,tdycel
      write(IOWMSG,9006,ERR=7001) 'Number of cells',nxcelt,nycelt
      write(IOWMSG,9003,ERR=7001) 'Number of vertical layers',nzcelt
      write(IOWMSG,9003,ERR=7001) 'Layers above and below',nzlowt,nzuppt
      write(IOWMSG,9007,ERR=7001) 'Layer heights (m)',thtsur,thtlow,
     &                                                           thtupp
      write(IOWMSG,9000,ERR=7001) '/UAMREGN/ header:'
      write(IOWMSG,9005,ERR=7001) 'UTM origin (km)',utmx,utmy
      write(IOWMSG,9003,ERR=7001) 'UTM zone',izone
      write(IOWMSG,9005,ERR=7001) 'Grid origin (km)',xorig,yorig
      write(IOWMSG,9005,ERR=7001) 'Grid cell width (km)',dxcell,dycell
      write(IOWMSG,9006,ERR=7001) 'Number of cells',nxcell,nycell
      write(IOWMSG,9003,ERR=7001) 'Number of vertical layers',nzcell
      write(IOWMSG,9003,ERR=7001) 'Layers above and below',nzlowr,nzuppr
      write(IOWMSG,9007,ERR=7001) 'Layer heights (m)',htsur,htlowr,
     &                                                            htuppr
      goto 111
c
 7001 continue
      write(IOWSTD,9000,ERR=9999) 'ERROR:  Writing message file.'
      goto 9999
c
 7002 continue
      jlen = strlen ( innm(ifile), MXSTR )
      write(IOWSTD,9000,ERR=9999)
     &               'WARNING: Header read from input file: ',
     &                                            innm(ifile)(1:jlen),
     &                       ' is not consistent with /EPISODE/ packet.'
      write(IOWMSG,9000,ERR=7001)
     &               'WARNING: Header read from input file: ',
     &                                            innm(ifile)(1:jlen),
     &                       ' is not consistent with /EPISODE/ packet.'
      write(IOWMSG,9000,ERR=7001) 'Input Emissions header:'
      ilen = strlen(fnote,60)
      write(IOWMSG,9002,ERR=7001) 'File note',fnote(1:ilen)
      write(IOWMSG,9003,ERR=7001) 'Beginning date',idateb
      write(IOWMSG,9004,ERR=7001) 'Beginning time',tbegti
      write(IOWMSG,9003,ERR=7001) 'Ending date',idatee
      write(IOWMSG,9004,ERR=7001) 'Ending time',tendti
c
      write(IOWMSG,9000,ERR=7001) '/EPISODE/ header:'
      write(IOWMSG,9003,ERR=7001) 'Beginning date',ibgdat
      write(IOWMSG,9004,ERR=7001) 'Beginning time',begtim/100
      write(IOWMSG,9003,ERR=7001) 'Ending date',iendat
      write(IOWMSG,9004,ERR=7001) 'Ending time',endtim/100
c
      goto 222
c
c-----------------------------------------------------------------------
c   Format Statements:
c-----------------------------------------------------------------------
c
 9000 format(1x,a,a,a)
 9001 format(1x,a,a,a,a,a,/,t10,a)
 9002 format(t10,a,t40,:,':',a)
 9003 format(t10,a,t40,:,':',i5,i5)
 9004 format(t10,a,t40,:,':',f7.2)
 9005 format(t10,a,t40,:,': (',f7.2,',',f7.2,')')
 9006 format(t10,a,t40,:,': (',i5,',',i5,')')
 9007 format(t10,a,t40,:,':',f7.2,:,1x,f7.2,:,1x,f7.2)
c-----------------------------------------------------------------------
c   Return Point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
