      subroutine rdhdr( ierr,
     &                        iounit )
c
c-----------------------------------------------------------------------
c
c    reads the first records in the header of an EMBR file and
c    stores the data in common variables
c
c    Argument declaration.
c     Outputs:
c       ierr   I error flag
c     Inputs:
c       iounit I logical unit number of file to read
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      11/10/91  --gmw--  original development
c      12/10/92  --gmw--  now if species list has thc the index will be
c                         set to VOC which is where thc is stored.
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'embrdat.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4          ierr
      integer*4          iounit
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
c   string  C   character string for temporary storage
c   PAD     C   temporary storage for last part of species list records
c
      character*(LENREC) string
      character*1        PAD
      integer*4          irec, i
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      irec = 1
c
c   --- write common variables into character strings ---
c
      read( iounit,ERR=7000 ) string
      read( string,9000,ERR=7000) filtyp
c
      irec = irec + 1
      read( iounit,ERR=7000 ) string
      read( string,9001,ERR=7000) rgutme, rgutmn, irgzn, nxrgn, nyrgn,
     &                            dxrgn, dyrgn
c
c   --- write species list and molecular weights in tow lines ---
c
      irec = irec + 1
      read( iounit,ERR=7000) (spclst(i),molwt(i),spcrit(i),
     &                      i=1,MXSPEC/2),(PAD,i=MXSPEC/2*19+1,LENREC)
      read( iounit,ERR=7000) (spclst(i),molwt(i),spcrit(i),
     &    i=MXSPEC/2+1,MXSPEC),(PAD,i=(MXSPEC-MXSPEC/2)*19+1,LENREC)
c
c   --- compute number of non-blank species in header ---
c
      nspchd = MXSPEC
      do 10 i=1,MXSPEC
         if( spclst(i)(1:1) .EQ. ' ' ) then
             nspchd = i-1
             goto 222
         endif
   10 continue
c
c  --- if there is a species list, get the index of criteria pollutant --
c
  222 continue
      if( nspchd .GT. 0 ) then
          do 20 i=1,nspchd
             if( spcrit(i) .EQ. NAMNOX ) ispcrt(i) = IDXNOX
             if( spcrit(i) .EQ. NAMVOC ) ispcrt(i) = IDXVOC
             if( spcrit(i) .EQ. NAMCO ) ispcrt(i) = IDXCO
             if( spcrit(i) .EQ. NAMSOX ) ispcrt(i) = IDXSOX
             if( spcrit(i) .EQ. NAMTSP ) ispcrt(i) = IDXTSP
             if( spcrit(i) .EQ. NAMPM ) ispcrt(i) = IDXPM
             if( spcrit(i) .EQ. NAMTVC ) ispcrt(i) = IDXVOC
   20     continue
      endif
c
c  --- set error flag to success ---
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,9004,ERR=9999) 'ERROR: Reading header of EMBR file ',
     &                                                'at record: ',irec
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 9000 format(a30)
 9001 format(f10.4,f10.4,i10,i10,i10,f10.4,f10.4)
 9004 format(/,1x,a,a,i5,/)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
