C
      PROGRAM qalowemis
C
      CHARACTER*4 IFILE(10),NOTE(60),MSPEC(10,90)
      REAL EMOB(400,400,90)
      REAL sum(90),HRLY(90,25),nsum(90)
      REAL sumsp(400,400,90)
      REAL fine(400,400),coar(400,400),poa(400,400),pec(400,400)
      REAL sumsox(400,400),ammonia(400,400),terp(400,400)
      REAL sumnox(400,400),sumrhc(400,400),isop(400,400)
      REAL noxsum,qsum,rhcsum,psum,osum
      REAL rsum,ssum,pasum,pbsum
      integer l,hr,IH
      character*1 comma
      character*10 cspec
      character*2 hrh
      character*4 nox(10),rhc(10),zco(7),issum(10)
      character*80 header,head2
      character*200 filnam,fil2
      character*4 zname(10),pcsum(10),pfsum(10),nosum(10),ppoa(10)
      character*4 rhsum(10),amsum(10),sosum(10),tesum(10),ppec(10)
      data nox/'N','O','X',' ',' ',' ',' ',' ',' ',' '/
      data rhc/'R','H','C',' ',' ',' ',' ',' ',' ',' '/
      data zco/'-','-','-','-','-','-','-'/
      data comma/','/
      data zname/'A','V','E','R','A','G','E',' ',' ',' '/
      data pcsum/'P','M','C','S','U','M',' ',' ',' ',' '/
      data pfsum/'P','M','F','S','U','M',' ',' ',' ',' '/
      data nosum/'N','O','X','S','U','M',' ',' ',' ',' '/
      data sosum/'S','O','X','S','U','M',' ',' ',' ',' '/
      data amsum/'N','H','3','S','U','M',' ',' ',' ',' '/
      data rhsum/'R','H','C','S','U','M',' ',' ',' ',' '/
      data tesum/'T','E','R','S','U','M',' ',' ',' ',' '/
      data issum/'I','S','O','S','U','M',' ',' ',' ',' '/
      data ppoa/'P','O','A','S','U','M',' ',' ',' ',' '/
      data ppec/'P','E','C','S','U','M',' ',' ',' ',' '/
      data zero /0./
      data ione /1/
      data izero /0/

      write(*,*)'enter the name of input file'
      read(*,'(a200)')filnam
      OPEN (7,FILE=filnam,FORM='UNFORMATTED',STATUS='OLD')
      write(*,*)'enter the name of output totals file'
      read(*,'(a200)')fil2
      OPEN (9,FILE=fil2,FORM='FORMATTED',STATUS='UNKNOWN')
      write(*,*)'enter the name of output hourly file'
      read(*,'(a200)')fil2
      OPEN (10,FILE=fil2,FORM='FORMATTED',STATUS='UNKNOWN')
      write(*,*)'enter the name of output PAVE file'
      read(*,'(a200)')fil2
      open(8,file=fil2,form='unformatted',status='unknown')

      IOUT=6

C
C---- READ AND WRITE OUT FILE HEADER INFORMATION
C
      READ (7)IFILE,NOTE,NSEG,NSPECS,IDATE,BEGTIM,JDATE,ENDTIM
      write(6,2100)ifile,note,nseg,nspecs
      write(6,1005)IDATE,BEGTIM,JDATE,ENDTIM
2100  FORMAT(10A1,60A1,/,I2,1X,I2,1X,I6,F6.0,I6,F6.0)
      READ  (7) ORGX,ORGY,IZONE,UTMX,UTMY,DELTAX,DELTAY,NX,NY,
     $ NZ,NZLOWR,NZUPPR,HTSUR,HTLOW,HTUPP
      write  (6,2001) ORGX,ORGY,0,UTMX,UTMY,DELTAX,DELTAY,NX,NY,
     $ NZ,NZLOWR,NZUPPR,HTSUR,HTLOW,HTUPP
 2001  FORMAT(F10.1,1X,F10.1,1X,I3,F10.1,1X,F10.1,1X,2F6.0,5I4,3F7.0)
      READ  (7) IX,IY,NXCLL,NYCLL
      write(6,*) ix,iy,nxcll,nycll
 1002 FORMAT(4I5)
      READ  (7) ((MSPEC(I,J),I=1,10),J=1,NSPECS)
      write(6,'(1x,10a1)')((mspec(i,j),i=1,10),j=1,nspecs)
 1003 FORMAT(10A1)

c----- Conversion factors

      cfac = 1./1000.
      cfac2 = .001102293 !to go from kg/day to tons/day

c----- Zero out sum arrays

      qsum=0.
      rsum=0.
      ssum=0.

       do l = 1,nspecs
          sum(l)=0
          nsum(l)=0
       enddo

      do l = 1,nspecs
       do hr = 1,24
        HRLY(l,hr)=0.
       enddo
      enddo

      do l = 1,nspecs
       do i = 1, nx
        do j = 1, ny
         sumsp(i,j,l) = 0.
        enddo
       enddo
      enddo

      do i = 1, nx
       do j = 1, ny
        fine(i,j)=0.
        coar(i,j)=0.
        sumnox(i,j)=0.
        sumrhc(i,j)=0.
        sumsox(i,j)=0.
        ammonia(i,j)=0.
        terp(i,j)=0.
        isop(i,j)=0.
        poa(i,j)=0.
        pec(i,j)=0.
       enddo
      enddo

C
c
c-----Write UAM-file header
c
     
      nspec = 10
      write(8) zname,note,ione,nspec,idate,float(0),jdate,
     &          float(1)
      write(8) orgx,orgy,izero,utmx,utmy,deltax,
     &          deltay,nx,ny,ione,izero,izero,zero,zero,zero
      write(8) izero,izero,nx,ny
      write(8) pcsum,pfsum,nosum,rhsum,sosum,amsum,tesum,issum,
     &          ppoa,ppec

c---------------------------
c 
C    LARGE LOOP FOR 24 HOURS OF EMISSIONS
C

      DO 1000 IH = 1,100
          READ  (7,END=999) IBGDAT, BEGTIM, IENDAT, ENDTIM
          WRITE (6,1005) IBGDAT,BEGTIM,IENDAT,ENDTIM
1005      FORMAT(5X,2(I10,F10.2))
C
C
C    LOOP ON INDIVIDUAL SPECIES -  READ AND WRITE OUT IN ASCII
C
          DO 400 L = 1,NSPECS
             READ (7) ISEG, (MSPEC(M,L),M = 1,10), ((EMOB(I,J,L),
     $          I=1,NX),J=1,NY)
             do j = 1,ny
                do i =1,nx
                   sum(l)=sum(l)+emob(i,j,l)
                   HRLY(l,IH)=HRLY(l,IH)+emob(i,j,l)
                   sumsp(i,j,l)=sumsp(i,j,l)+emob(i,j,l)
                enddo
             enddo
 1006            FORMAT(I4,10A1)
 1007            FORMAT(9E14.7)
  400     CONTINUE
c
 1000 CONTINUE
  999 header = 'Species      gram-moles/day       kg/day       tons/day'
      head2  = 'Species             Hour    g-moles/hr'
      hrh    = 'HR'
      write(9,2002)filnam
      write(9,2002)"       "
      write(9,2002)header
 2002 format(80a)

      do l =1,nspecs

      write(cspec,'(10a1)') (MSPEC(i,L),i=1,10)

       if (cspec .eq. 'NO        ') nsum(l)=sum(l)*30.*cfac  
       if (cspec .eq. 'NO2       ') nsum(l)=sum(l)*46.*cfac
       if (cspec .eq. 'SO2       ') nsum(l)=sum(l)*64.*cfac
       if (cspec .eq. 'CO        ') nsum(l)=sum(l)*28.*cfac
       if (cspec .eq. 'NH3       ') nsum(l)=sum(l)*17.*cfac

       if (cspec .eq. 'TERPB     ') nsum(l)=sum(l)*136.*cfac
       if (cspec .eq. 'TERP      ') nsum(l)=sum(l)*136.*cfac
       if (cspec .eq. 'TRP       ') nsum(l)=sum(l)*136.*cfac
       if (cspec .eq. 'SQT       ') nsum(l)=sum(l)*204.*cfac
       if (cspec .eq. 'CG3       ') nsum(l)=sum(l)*130.*cfac

       if (cspec .eq. 'ALD2      ') nsum(l)=sum(l)*32.*cfac
       if (cspec .eq. 'ALDX      ') nsum(l)=sum(l)*32.*cfac
       if (cspec .eq. 'ETH       ') nsum(l)=sum(l)*32.*cfac
       if (cspec .eq. 'ETHA      ') nsum(l)=sum(l)*32.*cfac
       if (cspec .eq. 'FORM      ') nsum(l)=sum(l)*16.*cfac
       if (cspec .eq. 'HCHO      ') nsum(l)=sum(l)*16.*cfac
       if (cspec .eq. 'ISOP      ') nsum(l)=sum(l)*68.*cfac 
       if (cspec .eq. 'ISP       ') nsum(l)=sum(l)*68.*cfac 
       if (cspec .eq. 'MEOH      ') nsum(l)=sum(l)*16.*cfac
       if (cspec .eq. 'NR        ') nsum(l)=sum(l)*16.*cfac
       if (cspec .eq. 'UNR       ') nsum(l)=sum(l)*16.*cfac
       if (cspec .eq. 'OLE       ') nsum(l)=sum(l)*32.*cfac
       if (cspec .eq. 'OLE2      ') nsum(l)=sum(l)*32.*cfac
       if (cspec .eq. 'IOLE      ') nsum(l)=sum(l)*32.*cfac
       if (cspec .eq. 'PAR       ') nsum(l)=sum(l)*16.*cfac
       if (cspec .eq. 'ETOH      ') nsum(l)=sum(l)*32.*cfac
       if (cspec .eq. 'TOL       ') nsum(l)=sum(l)*112.*cfac
       if (cspec .eq. 'XYL       ') nsum(l)=sum(l)*128.*cfac
       if (cspec .eq. 'MTBE      ') nsum(l)=sum(l)*30.*cfac
       if (cspec .eq. 'CH4       ') nsum(l)=sum(l)*16.*cfac

       if (cspec .eq. 'NO        ') osum=sum(l)*46.*cfac 
       if (cspec .eq. 'NO2       ') psum=sum(l)*46.*cfac


        if (cspec .eq. 'AERO      '.or.
     &      cspec .eq. 'PM10      '.or.
     &      cspec .eq. 'PM25      '.or.
     &      cspec .eq. 'SULF      '.or.
     &      cspec .eq. 'PMF       '.or.
     &      cspec .eq. 'PEC       '.or.
     &      cspec .eq. 'PNO3      '.or.
     &      cspec .eq. 'PSO4      '.or.
     &      cspec .eq. 'POA       '.or.
     &      cspec .eq. 'PSO4      '.or.
     &      cspec .eq. 'PMCOARS   '.or.
     &      cspec .eq. 'PMFINE    '.or.
     &      cspec .eq. 'FCRS      '.or.
     &      cspec .eq. 'GSO4      '.or.
     &      cspec .eq. 'FPRM      '.or.
     &      cspec .eq. 'CPRM      '.or.
     &      cspec .eq. 'CCRS      '.or.
     &      cspec .eq. 'PMC       ') then
          nsum(l)=sum(l)*1.*cfac
          else
          endif          

        if (cspec .eq. 'PM10      '.or.
     &      cspec .eq. 'PMCOARS   '.or.
     &      cspec .eq. 'CPRM      '.or.
     &      cspec .eq. 'CCRS      '.or.
     &      cspec .eq. 'PMC       ') then
          rsum=rsum+sum(l)*1.*cfac
          else
          endif          

        if (cspec .eq. 'PM25      '.or.
     &      cspec .eq. 'PMF       '.or.
     &      cspec .eq. 'PEC       '.or.
     &      cspec .eq. 'PNO3      '.or.
     &      cspec .eq. 'PSO4      '.or.
     &      cspec .eq. 'POA       '.or.
     &      cspec .eq. 'PSO4      '.or.
     &      cspec .eq. 'PMFINE    '.or.
     &      cspec .eq. 'FCRS      '.or.
     &      cspec .eq. 'GSO4      '.or.
     &      cspec .eq. 'FPRM      ') then
          ssum=ssum+sum(l)*1.*cfac
          else
          endif          

       if (cspec .eq. 'ALD2      ') qsum=qsum+2.*sum(l)*16.*cfac
       if (cspec .eq. 'ALDX      ') qsum=qsum+2.*sum(l)*16.*cfac
       if (cspec .eq. 'ETH       ') qsum=qsum+2.*sum(l)*16.*cfac
       if (cspec .eq. 'ETHA      ') qsum=qsum+2.*sum(l)*16.*cfac
       if (cspec .eq. 'FORM      ') qsum=qsum+1.*sum(l)*16.*cfac
       if (cspec .eq. 'HCHO      ') qsum=qsum+1.*sum(l)*16.*cfac
       if (cspec .eq. 'ISOP      ') qsum=qsum+5.*sum(l)*16.*cfac
       if (cspec .eq. 'MEOH      ') qsum=qsum+1.*sum(l)*16.*cfac
       if (cspec .eq. 'OLE       ') qsum=qsum+2.*sum(l)*16.*cfac
       if (cspec .eq. 'OLE2      ') qsum=qsum+2.*sum(l)*16.*cfac
       if (cspec .eq. 'IOLE      ') qsum=qsum+2.*sum(l)*16.*cfac
       if (cspec .eq. 'PAR       ') qsum=qsum+1.*sum(l)*16.*cfac
       if (cspec .eq. 'ETOH      ') qsum=qsum+2.*sum(l)*16.*cfac
       if (cspec .eq. 'TOL       ') qsum=qsum+7.*sum(l)*16.*cfac
       if (cspec .eq. 'XYL       ') qsum=qsum+8.*sum(l)*16.*cfac
       if (cspec .eq. 'MTBE      ') qsum=qsum+5.*sum(l)*16.*cfac


         write(9,1001)(mspec(m,l),m=1,10),sum(l),nsum(l),
     &     (nsum(l)*cfac2)
      enddo

         noxsum = osum + psum
         rhcsum = qsum
         pasum = rsum
         pbsum = ssum

         write(9,2002)zco,zco

         write(9,1001)(nox(m),m=1,10),a,noxsum,(noxsum*cfac2)
         write(9,1001)(rhc(m),m=1,10),a,rhcsum,(rhcsum*cfac2)
         write(9,1001)(pcsum(m),m=1,10),a,pasum,(pasum*cfac2)
         write(9,1001)(pfsum(m),m=1,10),a,pbsum,(pbsum*cfac2)

         write(10,2002)filnam
         write(10,1300)hrh,(comma,(mspec(m,l),m=1,10),l=1,nspecs)

          do hr=1,24
         write(10,1301)hr,(comma,HRLY(l,hr),l=1,nspecs)
          enddo

C       do l=1,nspecs
        do i=1,nx
         do j=1,ny
          do l=1,nspecs

      write(cspec,'(10a1)') (MSPEC(m,L),m=1,10)

       if (cspec .eq. 'SO2       ') sumsox(i,j)=sumsox(i,j)+
     &   sumsp(i,j,l)*64.*cfac

       if (cspec .eq. 'NH3       ') ammonia(i,j)=ammonia(i,j)+
     &   sumsp(i,j,l)*17.*cfac

       if (cspec .eq. 'POA       ') poa(i,j)=poa(i,j)+
     &   sumsp(i,j,l)*1.*cfac
       if (cspec .eq. 'PEC       ') pec(i,j)=pec(i,j)+
     &   sumsp(i,j,l)*1.*cfac

       if (cspec .eq. 'TERPB     ') terp(i,j)=terp(i,j)+
     &   sumsp(i,j,l)*136.*cfac
c       if (cspec .eq. 'TRP       ') terp(i,j)=terp(i,j)+
c     &   sumsp(i,j,l)*136.*cfac
       if (cspec .eq. 'TERP      ') terp(i,j)=terp(i,j)+
     &   sumsp(i,j,l)*136.*cfac
       if (cspec .eq. 'SQT       ') terp(i,j)=terp(i,j)+
     &   sumsp(i,j,l)*204.*cfac
       if (cspec .eq. 'CG3       ') terp(i,j)=terp(i,j)+
     &   sumsp(i,j,l)*130.*cfac

       if (cspec .eq. 'OLE2      ') terp(i,j)=terp(i,j)+
     &   sumsp(i,j,l)*32.*cfac

       if (cspec .eq. 'ISOP      ') isop(i,j)=isop(i,j)+
     &   sumsp(i,j,l)*68.*cfac
c       if (cspec .eq. 'ISP       ') isop(i,j)=isop(i,j)+
c     &   sumsp(i,j,l)*68.*cfac

       if (cspec .eq. 'NO        ') sumnox(i,j)=sumnox(i,j)+
     &   sumsp(i,j,l)*46.*cfac
       if (cspec .eq. 'NO2       ') sumnox(i,j)=sumnox(i,j)+
     &   sumsp(i,j,l)*46.*cfac

       if (cspec .eq. 'ALD2      ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*32.*cfac
       if (cspec .eq. 'ALDX      ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*32.*cfac
       if (cspec .eq. 'ETH       ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*32.*cfac
       if (cspec .eq. 'ETHA      ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*32.*cfac
       if (cspec .eq. 'FORM      ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*16.*cfac
       if (cspec .eq. 'HCHO      ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*16.*cfac
       if (cspec .eq. 'ISOP      ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*80.*cfac
       if (cspec .eq. 'MEOH      ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*16.*cfac
       if (cspec .eq. 'NR        ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*1.*cfac
       if (cspec .eq. 'UNR       ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*1.*cfac
       if (cspec .eq. 'CH4       ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*1.*cfac
       if (cspec .eq. 'OLE       ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*32.*cfac
       if (cspec .eq. 'OLE2      ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*32.*cfac
       if (cspec .eq. 'IOLE      ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*32.*cfac
       if (cspec .eq. 'PAR       ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*16.*cfac
       if (cspec .eq. 'ETOH      ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*32.*cfac
       if (cspec .eq. 'TOL       ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*112.*cfac
       if (cspec .eq. 'XYL       ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*128.*cfac
       if (cspec .eq. 'MTBE      ') sumrhc(i,j)=sumrhc(i,j)+
     &   sumsp(i,j,l)*30.*cfac

        if (cspec .eq. 'PM10      '.or.
     &      cspec .eq. 'PMCOARS   '.or.
     &      cspec .eq. 'CPRM      '.or.
     &      cspec .eq. 'CCRS      '.or.
     &      cspec .eq. 'PMC       ') then
          coar(i,j)=coar(i,j)+sumsp(i,j,l)*1.*cfac
          else
          endif         

        if (cspec .eq. 'PM25      '.or.
     &      cspec .eq. 'PMF       '.or.
     &      cspec .eq. 'PEC       '.or.
     &      cspec .eq. 'PNO3      '.or.
     &      cspec .eq. 'PSO4      '.or.
     &      cspec .eq. 'POA       '.or.
     &      cspec .eq. 'PSO4      '.or.
     &      cspec .eq. 'PMFINE    '.or.
     &      cspec .eq. 'FCRS      '.or.
     &      cspec .eq. 'GSO4      '.or.
     &      cspec .eq. 'FPRM      ') then
          fine(i,j)=fine(i,j)+sumsp(i,j,l)*1.*cfac
          else
          endif          

         enddo
        enddo
       enddo

c OUTPUT species are in units kg/day

        write(*,*)'Writing data at ',ibgdat,begtim
        write(8) ibgdat,float(0),ibgdat,float(1) 
        write(8) ione,pcsum,((coar(i,j),i=1,nx),j=1,ny)        
        write(8) ione,pfsum,((fine(i,j),i=1,nx),j=1,ny)
        write(8) ione,nosum,((sumnox(i,j),i=1,nx),j=1,ny)
        write(8) ione,rhsum,((sumrhc(i,j),i=1,nx),j=1,ny)
        write(8) ione,sosum,((sumsox(i,j),i=1,nx),j=1,ny)
        write(8) ione,amsum,((ammonia(i,j),i=1,nx),j=1,ny)
        write(8) ione,tesum,((terp(i,j),i=1,nx),j=1,ny)
        write(8) ione,issum,((isop(i,j),i=1,nx),j=1,ny)
        write(8) ione,ppoa,((poa(i,j),i=1,nx),j=1,ny)
        write(8) ione,ppec,((pec(i,j),i=1,nx),j=1,ny)


 1001 format(10a1,3f20.0)
 1009 format(10a1)
 1300 format(a2,50(a1,10a1))
 1301 format(i10,25(a,f10.0))
       STOP
       END
