      subroutine rdcnty( ierr,
     &                         iounit )
c
c-----------------------------------------------------------------------
c
c    Reads the user input file and stores the data in the /COUNTY/
c    packet in common variables
c
c    Argument declaration.
c     Outputs:
c       ierr   I error flag
c     Inputs:
c       iounit I logical unit number of file to read
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      11/10/91  --gmw--  original development
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'cntylst.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
      integer*4 iounit
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   strlen    I     returns actual length of string
c
      integer*4 strlen
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
c   keywrd  C   keyword for packet as variable
c   string  C   character string for temporary storage
c   fiptmp  C   character string for reading FIPS codes
c   strtmp  C   character string for reading design values
c   jerr    I   error flag for subroutine calls
c
      character*(KEYLEN) keywrd
      character*(KEYLEN) string
      character*(MXSTR)  strtmp
      character*5        fiptmp
      integer*4          ilen, jerr, i
c
c-----------------------------------------------------------------------
c   Data statements:
c-----------------------------------------------------------------------
c
      data keywrd /'/COUNTY/'/
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   ---  set error flag ---
c
      ierr = IFAIL
c
c   --- call routine to get to find packet identifier ---
c
      ncdfip = 0
      call fndkey( jerr,
     &                   iounit, keywrd )
      if( jerr .EQ. IRDERR ) goto 9999
      if( jerr .NE. ISUCES ) goto 7000
c
c   --- read counties (incramenting the array counter) ---
c
  111 continue
      read( iounit,8000,ERR=7001,END=7001 ) string, fiptmp, strtmp
c
      call low2up(
     &            string, KEYLEN )
      call lftjst(
     &            string, KEYLEN )
      if( string .EQ. KEYEND ) goto 222
      ncdfip = ncdfip + 1
      if( ncdfip .GT. MXFIP ) goto 7002
      fipcd(ncdfip) = fiptmp
      read( strtmp,8001,ERR=7001) (dsnval(i,ncdfip),i=1,MXDVAL)
      goto 111
c
c   --- set error flag to success ---
c
  222 continue
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      ilen = strlen ( keywrd, KEYLEN )
      write(IOWSTD,9000,ERR=9999) 'ERROR: This program requires the ',
     &                               keywrd(1:ilen),' packet of USERIN.'
      goto 9999
c
 7001 continue
      ilen = strlen ( keywrd, KEYLEN )
      write(IOWSTD,9000,ERR=9999) 'ERROR: Reading ',keywrd(1:ilen),
     &                     ' packet of USERIN file at line: ',ncdfip+1
      goto 9999
c
 7002 continue
      write(IOWSTD,9001,ERR=9999) 'ERROR: Number of counties: ',ncdfip,
     &                                           ' exceeds max: ',MXFIP
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A19,1X,A5,1X,A)
 8001 format(F10.0,1X,F10.0,1X,F10.0)
 9000 format(/,1X,A,A,A,I5,/)
 9001 format(/,1X,A,I5,A,I5,/)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
