c*** sccxrf.inc  version 1.0 07/30/92
c
c-----------------------------------------------------------------------
c
c    Include file for ASC/SCC profiles cross reference data used by the
c    many of the core EPS 2.0 modules.
c
c-----------------------------------------------------------------------
c   LOG:
c-----------------------------------------------------------------------
c
c     02/15/92  -mcc original development
c
c-----------------------------------------------------------------------
c   Parameters for cross reference data:
c-----------------------------------------------------------------------
c
c   MXREF    i   parameter for array bounds
c
      integer*4 MXREF
c
      parameter( MXREF  = 10000 )
c
c-----------------------------------------------------------------------
c   Cross reference data variables:
c-----------------------------------------------------------------------
c
c   alladj   R   overall adjustment for formaldehyde and ethane
c   ethadj   R   emissions adjustment for ethane
c   facxrf   C   array of facilities
c   fipxrf   C   array of FIPS codes
c   frmadj   R   emissions adjustment for formaldehyde
c   ictg     I   ctg flag
c                 = 1  ctg source
c                 = 0  non-ctg source
c   istxrf   I   array of stacks
c   npfxrf   I   number of cross reference records
c   prfxrf   C   speciation profile code
c   sccxrf   C   array of SCC codes
c   toxmax   R   maximum percentage of any one toxic substance in profile
c   toxtot   R   total percentage of all toxic substances in profile
c   vreact   R   array of percent reactivity for each profile
c
      character*10 sccxrf(MXREF)
      character*5  facxrf(MXREF)
      character*5  fipxrf(MXREF)
      character*5  prfxrf(MXREF)
      integer*4    ictg(MXREF)
      integer*4    istxrf(MXREF)
      integer*4    npfxrf
      real*4       alladj(MXREF)
      real*4       ethadj(MXREF)
      real*4       frmadj(MXREF)
      real*4       toxmax(MXREF)
      real*4       toxtot(MXREF)
      real*4       vreact(MXREF)
c
      common /xrfchr/ fipxrf, sccxrf, facxrf, prfxrf
      common /xrfdat/ npfxrf, istxrf, ictg, toxmax, toxtot, vreact,
     &                alladj, frmadj, ethadj
