      subroutine wrthdr( ierr )
c
c-----------------------------------------------------------------------
c
c    writes the merged header record to output emissions file.
c
c    Argument Declaration.
c     outputs:
c       ierr  i  error flag
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      10/25/91  --hjt--  original development
c      12/01/92  --gmw--  now re-reads the region data to avoid the
c                         machine "fuzz".
c
c-----------------------------------------------------------------------
c    Include Files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'uamcntl.inc'
      include 'uamregn.inc'
      include 'mrguam.inc'
c
c-----------------------------------------------------------------------
c    Argument Declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
c
c-----------------------------------------------------------------------
c    Local Variables:
c-----------------------------------------------------------------------
c
c   estr      c  string for 'EMISSIONS'
c   ichar     i  loop variable for characters
c   ifname    i  fname in integer format
c   ifnote    i  file description in integer format
c   iloop     i  generic loop variable
c   ispc      i  loop variable for species
c   nseg      i  always 1
c   tempch    c  single character for conversions
c
      character*10 estr
      character*1  tempch
      integer*4    ifname(10), ifnote(60), nseg
      integer*4    ispc, ichar, iloop, jerr
c
c-----------------------------------------------------------------------
c   Entry Point:
c-----------------------------------------------------------------------
c
c   --- assume failure ---
c
      ierr = ISUCES
c
c   --- since some machines will get some fuzz after dividing the
c       origin variables by 1000, we read the clean values again ---
c
      call rdregn( jerr,
     &                  IORINP )
      if( jerr .NE. ISUCES ) goto 9999
c
c   --- record 1 ---
c
      estr = 'EMISSIONS'
      nseg = 1
      do 100 iloop= 1, 10
          tempch = estr(iloop:iloop)
          read(tempch, 8000) ifname(iloop)
  100 continue
c
      do 110 iloop = 1, 60
          tempch = fnote(iloop:iloop)
          read(tempch, 8000) ifnote(iloop)
  110 continue
c
      call bswap(ifname,10,0)
      call bswap(ifnote,60,0)
      write(IOWUAM)
     &   ifname,
     &   ifnote,
     &   nseg,
     &   nspecs,
     &   ibgdat,
     &   begtim/100,
     &   iendat,
     &   endtim/100
c
c   --- record 2 ---
c
      write(IOWUAM,ERR=7010)
     &   utmx,
     &   utmy,
     &   izone,
     &   xorig,
     &   yorig,
     &   dxcell,
     &   dycell,
     &   nxcell,
     &   nycell,
     &   nzcell,
     &   nzlowr,
     &   nzuppr,
     &   htsur,
     &   htlowr,
     &   htuppr
c
c   --- record 3 ---
c
      write(IOWUAM,ERR=7010) seg4
c
c   --- record 4 ---
c
      call bswap(intnam,10,MXSPEC)
      write(IOWUAM,ERR=7010)
     &     ((intnam(ispc,ichar),ichar=1,10),ispc=1,nspecs)
c
c   --- convert the coordinates to kilometers ---
c
      utmx = utmx / 1000.
      utmy = utmy / 1000.
      xorig = xorig / 1000.
      yorig = yorig / 1000.
      dxcell = dxcell / 1000.
      dycell = dycell / 1000.
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error Messages:
c-----------------------------------------------------------------------
c
 7010 continue
      write (IOWSTD, 9000, ERR=9999) 'ERROR:  Writing header of output',
     &                                                ' emissions file.'
      goto 9999
c
c-----------------------------------------------------------------------
c   Format Statements:
c-----------------------------------------------------------------------
c
 8000 format(a1)
 9000 format(1x,a,a)
c
c-----------------------------------------------------------------------
c   Return Point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
